/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @lightSyntaxTransform
 * @noflow
 * @nolint
 * @preventMunge
 * @preserve-invariant-messages
 */
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __knownSymbol = (name, symbol2) => (symbol2 = Symbol[name]) ? symbol2 : Symbol.for("Symbol." + name);
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __pow = Math.pow;
var __defNormalProp = (obj, key2, value) => key2 in obj ? __defProp(obj, key2, { enumerable: true, configurable: true, writable: true, value }) : obj[key2] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key2 of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key2) && key2 !== except)
        __defProp(to, key2, { get: () => from[key2], enumerable: !(desc = __getOwnPropDesc(from, key2)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key2, value) => __defNormalProp(obj, typeof key2 !== "symbol" ? key2 + "" : key2, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var __await = function(promise2, isYieldStar) {
  this[0] = promise2;
  this[1] = isYieldStar;
};
var __yieldStar = (value) => {
  var obj = value[__knownSymbol("asyncIterator")], isAwait = false, method, it = {};
  if (obj == null) {
    obj = value[__knownSymbol("iterator")]();
    method = (k) => it[k] = (x) => obj[k](x);
  } else {
    obj = obj.call(value);
    method = (k) => it[k] = (v) => {
      if (isAwait) {
        isAwait = false;
        if (k === "throw") throw v;
        return v;
      }
      isAwait = true;
      return {
        done: false,
        value: new __await(new Promise((resolve) => {
          var x = obj[k](v);
          if (!(x instanceof Object)) __typeError("Object expected");
          resolve(x);
        }), 1)
      };
    };
  }
  return it[__knownSymbol("iterator")] = () => it, method("next"), "throw" in obj ? method("throw") : it.throw = (x) => {
    throw x;
  }, "return" in obj && method("return"), it;
};

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/virtual-types.js
var require_virtual_types = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/virtual-types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.Var = exports2.User = exports2.Statement = exports2.SpreadProperty = exports2.Scope = exports2.RestProperty = exports2.ReferencedMemberExpression = exports2.ReferencedIdentifier = exports2.Referenced = exports2.Pure = exports2.NumericLiteralTypeAnnotation = exports2.Generated = exports2.ForAwaitStatement = exports2.Flow = exports2.Expression = exports2.ExistentialTypeParam = exports2.BlockScoped = exports2.BindingIdentifier = void 0;
    var ReferencedIdentifier = exports2.ReferencedIdentifier = ["Identifier", "JSXIdentifier"];
    var ReferencedMemberExpression = exports2.ReferencedMemberExpression = ["MemberExpression"];
    var BindingIdentifier = exports2.BindingIdentifier = ["Identifier"];
    var Statement = exports2.Statement = ["Statement"];
    var Expression = exports2.Expression = ["Expression"];
    var Scope = exports2.Scope = ["Scopable", "Pattern"];
    var Referenced = exports2.Referenced = null;
    var BlockScoped = exports2.BlockScoped = null;
    var Var = exports2.Var = ["VariableDeclaration"];
    var User = exports2.User = null;
    var Generated = exports2.Generated = null;
    var Pure = exports2.Pure = null;
    var Flow = exports2.Flow = ["Flow", "ImportDeclaration", "ExportDeclaration", "ImportSpecifier"];
    var RestProperty = exports2.RestProperty = ["RestElement"];
    var SpreadProperty = exports2.SpreadProperty = ["RestElement"];
    var ExistentialTypeParam = exports2.ExistentialTypeParam = ["ExistsTypeAnnotation"];
    var NumericLiteralTypeAnnotation = exports2.NumericLiteralTypeAnnotation = ["NumberLiteralTypeAnnotation"];
    var ForAwaitStatement = exports2.ForAwaitStatement = ["ForOfStatement"];
  }
});

// ../../node_modules/ms/index.js
var require_ms = __commonJS({
  "../../node_modules/ms/index.js"(exports2, module2) {
    "use strict";
    var s = 1e3;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    var w = d * 7;
    var y = d * 365.25;
    module2.exports = function(val, options) {
      options = options || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse6(val);
      } else if (type === "number" && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse6(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n = parseFloat(match[1]);
      var type = (match[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n * y;
        case "weeks":
        case "week":
        case "w":
          return n * w;
        case "days":
        case "day":
        case "d":
          return n * d;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n * h;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n * m;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n * s;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n;
        default:
          return void 0;
      }
    }
    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return Math.round(ms / d) + "d";
      }
      if (msAbs >= h) {
        return Math.round(ms / h) + "h";
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + "m";
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + "s";
      }
      return ms + "ms";
    }
    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return plural(ms, msAbs, d, "day");
      }
      if (msAbs >= h) {
        return plural(ms, msAbs, h, "hour");
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, "minute");
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, "second");
      }
      return ms + " ms";
    }
    function plural(ms, msAbs, n, name) {
      var isPlural = msAbs >= n * 1.5;
      return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
    }
  }
});

// ../../node_modules/debug/src/common.js
var require_common = __commonJS({
  "../../node_modules/debug/src/common.js"(exports2, module2) {
    "use strict";
    function setup(env) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env).forEach((key2) => {
        createDebug[key2] = env[key2];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash2 = 0;
        for (let i = 0; i < namespace.length; i++) {
          hash2 = (hash2 << 5) - hash2 + namespace.charCodeAt(i);
          hash2 |= 0;
        }
        return createDebug.colors[Math.abs(hash2) % createDebug.colors.length];
      }
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug(...args) {
          if (!debug.enabled) {
            return;
          }
          const self2 = debug;
          const curr = Number(/* @__PURE__ */ new Date());
          const ms = curr - (prevTime || curr);
          self2.diff = ms;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          args[0] = createDebug.coerce(args[0]);
          if (typeof args[0] !== "string") {
            args.unshift("%O");
          }
          let index = 0;
          args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
            if (match === "%%") {
              return "%";
            }
            index++;
            const formatter = createDebug.formatters[format];
            if (typeof formatter === "function") {
              const val = args[index];
              match = formatter.call(self2, val);
              args.splice(index, 1);
              index--;
            }
            return match;
          });
          createDebug.formatArgs.call(self2, args);
          const logFn = self2.log || createDebug.log;
          logFn.apply(self2, args);
        }
        debug.namespace = namespace;
        debug.useColors = createDebug.useColors();
        debug.color = createDebug.selectColor(namespace);
        debug.extend = extend2;
        debug.destroy = createDebug.destroy;
        Object.defineProperty(debug, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v) => {
            enableOverride = v;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug);
        }
        return debug;
      }
      function extend2(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(" ", ",").split(",").filter(Boolean);
        for (const ns of split) {
          if (ns[0] === "-") {
            createDebug.skips.push(ns.slice(1));
          } else {
            createDebug.names.push(ns);
          }
        }
      }
      function matchesTemplate(search, template) {
        let searchIndex = 0;
        let templateIndex = 0;
        let starIndex = -1;
        let matchIndex = 0;
        while (searchIndex < search.length) {
          if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
            if (template[templateIndex] === "*") {
              starIndex = templateIndex;
              matchIndex = searchIndex;
              templateIndex++;
            } else {
              searchIndex++;
              templateIndex++;
            }
          } else if (starIndex !== -1) {
            templateIndex = starIndex + 1;
            matchIndex++;
            searchIndex = matchIndex;
          } else {
            return false;
          }
        }
        while (templateIndex < template.length && template[templateIndex] === "*") {
          templateIndex++;
        }
        return templateIndex === template.length;
      }
      function disable() {
        const namespaces = [
          ...createDebug.names,
          ...createDebug.skips.map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      function enabled(name) {
        for (const skip of createDebug.skips) {
          if (matchesTemplate(name, skip)) {
            return false;
          }
        }
        for (const ns of createDebug.names) {
          if (matchesTemplate(name, ns)) {
            return true;
          }
        }
        return false;
      }
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    module2.exports = setup;
  }
});

// ../../node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "../../node_modules/debug/src/browser.js"(exports2, module2) {
    "use strict";
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.storage = localstorage();
    exports2.destroy = /* @__PURE__ */ (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports2.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      let m;
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
      typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
      // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
      typeof navigator !== "undefined" && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c2 = "color: " + this.color;
      args.splice(1, 0, c2, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c2);
    }
    exports2.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports2.storage.setItem("debug", namespaces);
        } else {
          exports2.storage.removeItem("debug");
        }
      } catch (error45) {
      }
    }
    function load() {
      let r;
      try {
        r = exports2.storage.getItem("debug");
      } catch (error45) {
      }
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error45) {
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error45) {
        return "[UnexpectedJSONParseError]: " + error45.message;
      }
    };
  }
});

// ../../node_modules/has-flag/index.js
var require_has_flag = __commonJS({
  "../../node_modules/has-flag/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (flag, argv = process.argv) => {
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const position = argv.indexOf(prefix + flag);
      const terminatorPosition = argv.indexOf("--");
      return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };
  }
});

// ../../node_modules/supports-color/index.js
var require_supports_color = __commonJS({
  "../../node_modules/supports-color/index.js"(exports2, module2) {
    "use strict";
    var os = require("os");
    var tty = require("tty");
    var hasFlag = require_has_flag();
    var { env } = process;
    var flagForceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
      flagForceColor = 0;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      flagForceColor = 1;
    }
    function envForceColor() {
      if ("FORCE_COLOR" in env) {
        if (env.FORCE_COLOR === "true") {
          return 1;
        }
        if (env.FORCE_COLOR === "false") {
          return 0;
        }
        return env.FORCE_COLOR.length === 0 ? 1 : Math.min(Number.parseInt(env.FORCE_COLOR, 10), 3);
      }
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    function supportsColor(haveStream, { streamIsTTY, sniffFlags = true } = {}) {
      const noFlagForceColor = envForceColor();
      if (noFlagForceColor !== void 0) {
        flagForceColor = noFlagForceColor;
      }
      const forceColor = sniffFlags ? flagForceColor : noFlagForceColor;
      if (forceColor === 0) {
        return 0;
      }
      if (sniffFlags) {
        if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
          return 3;
        }
        if (hasFlag("color=256")) {
          return 2;
        }
      }
      if (haveStream && !streamIsTTY && forceColor === void 0) {
        return 0;
      }
      const min = forceColor || 0;
      if (env.TERM === "dumb") {
        return min;
      }
      if (process.platform === "win32") {
        const osRelease = os.release().split(".");
        if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE", "DRONE"].some((sign2) => sign2 in env) || env.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env) {
        const version2 = Number.parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            return version2 >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env) {
        return 1;
      }
      return min;
    }
    function getSupportLevel(stream, options = {}) {
      const level = supportsColor(stream, __spreadValues({
        streamIsTTY: stream && stream.isTTY
      }, options));
      return translateLevel(level);
    }
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: getSupportLevel({ isTTY: tty.isatty(1) }),
      stderr: getSupportLevel({ isTTY: tty.isatty(2) })
    };
  }
});

// ../../node_modules/debug/src/node.js
var require_node = __commonJS({
  "../../node_modules/debug/src/node.js"(exports2, module2) {
    "use strict";
    var tty = require("tty");
    var util2 = require("util");
    exports2.init = init;
    exports2.log = log2;
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.destroy = util2.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports2.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = require_supports_color();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports2.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error45) {
    }
    exports2.inspectOpts = Object.keys(process.env).filter((key2) => {
      return /^debug_/i.test(key2);
    }).reduce((obj, key2) => {
      const prop = key2.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key2];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    function formatArgs(args) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c2 = this.color;
        const colorCode = "\x1B[3" + (c2 < 8 ? c2 : "8;5;" + c2);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    function getDate() {
      if (exports2.inspectOpts.hideDate) {
        return "";
      }
      return (/* @__PURE__ */ new Date()).toISOString() + " ";
    }
    function log2(...args) {
      return process.stderr.write(util2.formatWithOptions(exports2.inspectOpts, ...args) + "\n");
    }
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    function load() {
      return process.env.DEBUG;
    }
    function init(debug) {
      debug.inspectOpts = {};
      const keys = Object.keys(exports2.inspectOpts);
      for (let i = 0; i < keys.length; i++) {
        debug.inspectOpts[keys[i]] = exports2.inspectOpts[keys[i]];
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.o = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util2.inspect(v, this.inspectOpts);
    };
  }
});

// ../../node_modules/debug/src/index.js
var require_src = __commonJS({
  "../../node_modules/debug/src/index.js"(exports2, module2) {
    "use strict";
    if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
      module2.exports = require_browser();
    } else {
      module2.exports = require_node();
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/virtual-types-validator.js
var require_virtual_types_validator = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/virtual-types-validator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isBindingIdentifier = isBindingIdentifier;
    exports2.isBlockScoped = isBlockScoped;
    exports2.isExpression = isExpression2;
    exports2.isFlow = isFlow;
    exports2.isForAwaitStatement = isForAwaitStatement;
    exports2.isGenerated = isGenerated;
    exports2.isPure = isPure;
    exports2.isReferenced = isReferenced;
    exports2.isReferencedIdentifier = isReferencedIdentifier;
    exports2.isReferencedMemberExpression = isReferencedMemberExpression;
    exports2.isRestProperty = isRestProperty;
    exports2.isScope = isScope;
    exports2.isSpreadProperty = isSpreadProperty;
    exports2.isStatement = isStatement2;
    exports2.isUser = isUser;
    exports2.isVar = isVar;
    var _t = require("@babel/types");
    var {
      isBinding,
      isBlockScoped: nodeIsBlockScoped,
      isExportDeclaration,
      isExpression: nodeIsExpression,
      isFlow: nodeIsFlow,
      isForStatement,
      isForXStatement,
      isIdentifier,
      isImportDeclaration,
      isImportSpecifier,
      isJSXIdentifier,
      isJSXMemberExpression,
      isMemberExpression: isMemberExpression2,
      isRestElement: nodeIsRestElement,
      isReferenced: nodeIsReferenced,
      isScope: nodeIsScope,
      isStatement: nodeIsStatement,
      isVar: nodeIsVar,
      isVariableDeclaration: isVariableDeclaration2,
      react,
      isForOfStatement
    } = _t;
    var {
      isCompatTag
    } = react;
    function isReferencedIdentifier(opts) {
      const {
        node,
        parent
      } = this;
      if (!isIdentifier(node, opts) && !isJSXMemberExpression(parent, opts)) {
        if (isJSXIdentifier(node, opts)) {
          if (isCompatTag(node.name)) return false;
        } else {
          return false;
        }
      }
      return nodeIsReferenced(node, parent, this.parentPath.parent);
    }
    function isReferencedMemberExpression() {
      const {
        node,
        parent
      } = this;
      return isMemberExpression2(node) && nodeIsReferenced(node, parent);
    }
    function isBindingIdentifier() {
      const {
        node,
        parent
      } = this;
      const grandparent = this.parentPath.parent;
      return isIdentifier(node) && isBinding(node, parent, grandparent);
    }
    function isStatement2() {
      const {
        node,
        parent
      } = this;
      if (nodeIsStatement(node)) {
        if (isVariableDeclaration2(node)) {
          if (isForXStatement(parent, {
            left: node
          })) return false;
          if (isForStatement(parent, {
            init: node
          })) return false;
        }
        return true;
      } else {
        return false;
      }
    }
    function isExpression2() {
      if (this.isIdentifier()) {
        return this.isReferencedIdentifier();
      } else {
        return nodeIsExpression(this.node);
      }
    }
    function isScope() {
      return nodeIsScope(this.node, this.parent);
    }
    function isReferenced() {
      return nodeIsReferenced(this.node, this.parent);
    }
    function isBlockScoped() {
      return nodeIsBlockScoped(this.node);
    }
    function isVar() {
      return nodeIsVar(this.node);
    }
    function isUser() {
      return this.node && !!this.node.loc;
    }
    function isGenerated() {
      return !this.isUser();
    }
    function isPure(constantsOnly) {
      return this.scope.isPure(this.node, constantsOnly);
    }
    function isFlow() {
      const {
        node
      } = this;
      if (nodeIsFlow(node)) {
        return true;
      } else if (isImportDeclaration(node)) {
        return node.importKind === "type" || node.importKind === "typeof";
      } else if (isExportDeclaration(node)) {
        return node.exportKind === "type";
      } else if (isImportSpecifier(node)) {
        return node.importKind === "type" || node.importKind === "typeof";
      } else {
        return false;
      }
    }
    function isRestProperty() {
      var _this$parentPath;
      return nodeIsRestElement(this.node) && ((_this$parentPath = this.parentPath) == null ? void 0 : _this$parentPath.isObjectPattern());
    }
    function isSpreadProperty() {
      var _this$parentPath2;
      return nodeIsRestElement(this.node) && ((_this$parentPath2 = this.parentPath) == null ? void 0 : _this$parentPath2.isObjectExpression());
    }
    function isForAwaitStatement() {
      return isForOfStatement(this.node, {
        await: true
      });
    }
    {
      exports2.isExistentialTypeParam = function isExistentialTypeParam() {
        throw new Error("`path.isExistentialTypeParam` has been renamed to `path.isExistsTypeAnnotation()` in Babel 7.");
      };
      exports2.isNumericLiteralTypeAnnotation = function isNumericLiteralTypeAnnotation() {
        throw new Error("`path.isNumericLiteralTypeAnnotation()` has been renamed to `path.isNumberLiteralTypeAnnotation()` in Babel 7.");
      };
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/visitors.js
var require_visitors = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/visitors.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.environmentVisitor = environmentVisitor;
    exports2.explode = explode$1;
    exports2.isExplodedVisitor = isExplodedVisitor;
    exports2.merge = merge4;
    exports2.verify = verify$1;
    var virtualTypes = require_virtual_types();
    var virtualTypesValidators = require_virtual_types_validator();
    var _t = require("@babel/types");
    var _context3 = require_context2();
    var {
      DEPRECATED_KEYS,
      DEPRECATED_ALIASES,
      FLIPPED_ALIAS_KEYS,
      TYPES,
      __internal__deprecationWarning: deprecationWarning
    } = _t;
    function isVirtualType(type) {
      return type in virtualTypes;
    }
    function isExplodedVisitor(visitor) {
      return visitor == null ? void 0 : visitor._exploded;
    }
    function explode$1(visitor) {
      if (isExplodedVisitor(visitor)) return visitor;
      visitor._exploded = true;
      for (const nodeType of Object.keys(visitor)) {
        if (shouldIgnoreKey(nodeType)) continue;
        const parts = nodeType.split("|");
        if (parts.length === 1) continue;
        const fns = visitor[nodeType];
        delete visitor[nodeType];
        for (const part of parts) {
          visitor[part] = fns;
        }
      }
      verify$1(visitor);
      delete visitor.__esModule;
      ensureEntranceObjects(visitor);
      ensureCallbackArrays(visitor);
      for (const nodeType of Object.keys(visitor)) {
        if (shouldIgnoreKey(nodeType)) continue;
        if (!isVirtualType(nodeType)) continue;
        const fns = visitor[nodeType];
        for (const type of Object.keys(fns)) {
          fns[type] = wrapCheck(nodeType, fns[type]);
        }
        delete visitor[nodeType];
        const types = virtualTypes[nodeType];
        if (types !== null) {
          for (const type of types) {
            if (visitor[type]) {
              mergePair(visitor[type], fns);
            } else {
              visitor[type] = fns;
            }
          }
        } else {
          mergePair(visitor, fns);
        }
      }
      for (const nodeType of Object.keys(visitor)) {
        if (shouldIgnoreKey(nodeType)) continue;
        let aliases = FLIPPED_ALIAS_KEYS[nodeType];
        if (nodeType in DEPRECATED_KEYS) {
          const deprecatedKey = DEPRECATED_KEYS[nodeType];
          deprecationWarning(nodeType, deprecatedKey, "Visitor ");
          aliases = [deprecatedKey];
        } else if (nodeType in DEPRECATED_ALIASES) {
          const deprecatedAlias = DEPRECATED_ALIASES[nodeType];
          deprecationWarning(nodeType, deprecatedAlias, "Visitor ");
          aliases = FLIPPED_ALIAS_KEYS[deprecatedAlias];
        }
        if (!aliases) continue;
        const fns = visitor[nodeType];
        delete visitor[nodeType];
        for (const alias of aliases) {
          const existing = visitor[alias];
          if (existing) {
            mergePair(existing, fns);
          } else {
            visitor[alias] = Object.assign({}, fns);
          }
        }
      }
      for (const nodeType of Object.keys(visitor)) {
        if (shouldIgnoreKey(nodeType)) continue;
        ensureCallbackArrays(visitor[nodeType]);
      }
      return visitor;
    }
    function verify$1(visitor) {
      if (visitor._verified) return;
      if (typeof visitor === "function") {
        throw new Error("You passed `traverse()` a function when it expected a visitor object, are you sure you didn't mean `{ enter: Function }`?");
      }
      for (const nodeType of Object.keys(visitor)) {
        if (nodeType === "enter" || nodeType === "exit") {
          validateVisitorMethods(nodeType, visitor[nodeType]);
        }
        if (shouldIgnoreKey(nodeType)) continue;
        if (!TYPES.includes(nodeType)) {
          throw new Error(`You gave us a visitor for the node type ${nodeType} but it's not a valid type in @babel/traverse ${"7.26.4"}`);
        }
        const visitors = visitor[nodeType];
        if (typeof visitors === "object") {
          for (const visitorKey of Object.keys(visitors)) {
            if (visitorKey === "enter" || visitorKey === "exit") {
              validateVisitorMethods(`${nodeType}.${visitorKey}`, visitors[visitorKey]);
            } else {
              throw new Error(`You passed \`traverse()\` a visitor object with the property ${nodeType} that has the invalid property ${visitorKey}`);
            }
          }
        }
      }
      visitor._verified = true;
    }
    function validateVisitorMethods(path, val) {
      const fns = [].concat(val);
      for (const fn of fns) {
        if (typeof fn !== "function") {
          throw new TypeError(`Non-function found defined in ${path} with type ${typeof fn}`);
        }
      }
    }
    function merge4(visitors, states = [], wrapper) {
      const mergedVisitor = {
        _verified: true,
        _exploded: true
      };
      {
        Object.defineProperty(mergedVisitor, "_exploded", {
          enumerable: false
        });
        Object.defineProperty(mergedVisitor, "_verified", {
          enumerable: false
        });
      }
      for (let i = 0; i < visitors.length; i++) {
        const visitor = explode$1(visitors[i]);
        const state = states[i];
        let topVisitor = visitor;
        if (state || wrapper) {
          topVisitor = wrapWithStateOrWrapper(topVisitor, state, wrapper);
        }
        mergePair(mergedVisitor, topVisitor);
        for (const key2 of Object.keys(visitor)) {
          if (shouldIgnoreKey(key2)) continue;
          let typeVisitor = visitor[key2];
          if (state || wrapper) {
            typeVisitor = wrapWithStateOrWrapper(typeVisitor, state, wrapper);
          }
          const nodeVisitor = mergedVisitor[key2] || (mergedVisitor[key2] = {});
          mergePair(nodeVisitor, typeVisitor);
        }
      }
      return mergedVisitor;
    }
    function wrapWithStateOrWrapper(oldVisitor, state, wrapper) {
      const newVisitor = {};
      for (const phase of ["enter", "exit"]) {
        let fns = oldVisitor[phase];
        if (!Array.isArray(fns)) continue;
        fns = fns.map(function(fn) {
          let newFn = fn;
          if (state) {
            newFn = function(path) {
              fn.call(state, path, state);
            };
          }
          if (wrapper) {
            newFn = wrapper(state == null ? void 0 : state.key, phase, newFn);
          }
          if (newFn !== fn) {
            newFn.toString = () => fn.toString();
          }
          return newFn;
        });
        newVisitor[phase] = fns;
      }
      return newVisitor;
    }
    function ensureEntranceObjects(obj) {
      for (const key2 of Object.keys(obj)) {
        if (shouldIgnoreKey(key2)) continue;
        const fns = obj[key2];
        if (typeof fns === "function") {
          obj[key2] = {
            enter: fns
          };
        }
      }
    }
    function ensureCallbackArrays(obj) {
      if (obj.enter && !Array.isArray(obj.enter)) obj.enter = [obj.enter];
      if (obj.exit && !Array.isArray(obj.exit)) obj.exit = [obj.exit];
    }
    function wrapCheck(nodeType, fn) {
      const fnKey = `is${nodeType}`;
      const validator = virtualTypesValidators[fnKey];
      const newFn = function(path) {
        if (validator.call(path)) {
          return fn.apply(this, arguments);
        }
      };
      newFn.toString = () => fn.toString();
      return newFn;
    }
    function shouldIgnoreKey(key2) {
      if (key2[0] === "_") return true;
      if (key2 === "enter" || key2 === "exit" || key2 === "shouldSkip") return true;
      if (key2 === "denylist" || key2 === "noScope" || key2 === "skipKeys") {
        return true;
      }
      {
        if (key2 === "blacklist") {
          return true;
        }
      }
      return false;
    }
    function mergePair(dest, src) {
      for (const phase of ["enter", "exit"]) {
        if (!src[phase]) continue;
        dest[phase] = [].concat(dest[phase] || [], src[phase]);
      }
    }
    var _environmentVisitor = {
      FunctionParent(path) {
        if (path.isArrowFunctionExpression()) return;
        path.skip();
        if (path.isMethod()) {
          if (!path.requeueComputedKeyAndDecorators) {
            _context3.requeueComputedKeyAndDecorators.call(path);
          } else {
            path.requeueComputedKeyAndDecorators();
          }
        }
      },
      Property(path) {
        if (path.isObjectProperty()) return;
        path.skip();
        if (!path.requeueComputedKeyAndDecorators) {
          _context3.requeueComputedKeyAndDecorators.call(path);
        } else {
          path.requeueComputedKeyAndDecorators();
        }
      }
    };
    function environmentVisitor(visitor) {
      return merge4([_environmentVisitor, visitor]);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/lib/renamer.js
var require_renamer = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/lib/renamer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var t6 = require("@babel/types");
    var _t = t6;
    var _traverseNode = require_traverse_node();
    var _visitors = require_visitors();
    var _context3 = require_context2();
    var {
      getAssignmentIdentifiers
    } = _t;
    var renameVisitor = {
      ReferencedIdentifier({
        node
      }, state) {
        if (node.name === state.oldName) {
          node.name = state.newName;
        }
      },
      Scope(path, state) {
        if (!path.scope.bindingIdentifierEquals(state.oldName, state.binding.identifier)) {
          path.skip();
          if (path.isMethod()) {
            if (!path.requeueComputedKeyAndDecorators) {
              _context3.requeueComputedKeyAndDecorators.call(path);
            } else {
              path.requeueComputedKeyAndDecorators();
            }
          }
        }
      },
      ObjectProperty({
        node,
        scope
      }, state) {
        const {
          name
        } = node.key;
        if (node.shorthand && (name === state.oldName || name === state.newName) && scope.getBindingIdentifier(name) === state.binding.identifier) {
          node.shorthand = false;
          {
            var _node$extra;
            if ((_node$extra = node.extra) != null && _node$extra.shorthand) node.extra.shorthand = false;
          }
        }
      },
      "AssignmentExpression|Declaration|VariableDeclarator"(path, state) {
        if (path.isVariableDeclaration()) return;
        const ids = path.isAssignmentExpression() ? getAssignmentIdentifiers(path.node) : path.getOuterBindingIdentifiers();
        for (const name in ids) {
          if (name === state.oldName) ids[name].name = state.newName;
        }
      }
    };
    var Renamer = class {
      constructor(binding, oldName, newName) {
        this.newName = newName;
        this.oldName = oldName;
        this.binding = binding;
      }
      maybeConvertFromExportDeclaration(parentDeclar) {
        const maybeExportDeclar = parentDeclar.parentPath;
        if (!maybeExportDeclar.isExportDeclaration()) {
          return;
        }
        if (maybeExportDeclar.isExportDefaultDeclaration()) {
          const {
            declaration
          } = maybeExportDeclar.node;
          if (t6.isDeclaration(declaration) && !declaration.id) {
            return;
          }
        }
        if (maybeExportDeclar.isExportAllDeclaration()) {
          return;
        }
        maybeExportDeclar.splitExportDeclaration();
      }
      maybeConvertFromClassFunctionDeclaration(path) {
        return path;
      }
      maybeConvertFromClassFunctionExpression(path) {
        return path;
      }
      rename() {
        const {
          binding,
          oldName,
          newName
        } = this;
        const {
          scope,
          path
        } = binding;
        const parentDeclar = path.find((path2) => path2.isDeclaration() || path2.isFunctionExpression() || path2.isClassExpression());
        if (parentDeclar) {
          const bindingIds = parentDeclar.getOuterBindingIdentifiers();
          if (bindingIds[oldName] === binding.identifier) {
            this.maybeConvertFromExportDeclaration(parentDeclar);
          }
        }
        const blockToTraverse = arguments[0] || scope.block;
        const skipKeys = {
          discriminant: true
        };
        if (t6.isMethod(blockToTraverse)) {
          if (blockToTraverse.computed) {
            skipKeys.key = true;
          }
          if (!t6.isObjectMethod(blockToTraverse)) {
            skipKeys.decorators = true;
          }
        }
        (0, _traverseNode.traverseNode)(blockToTraverse, (0, _visitors.explode)(renameVisitor), scope, this, scope.path, skipKeys);
        if (!arguments[0]) {
          scope.removeOwnBinding(oldName);
          scope.bindings[newName] = binding;
          this.binding.identifier.name = newName;
        }
        if (parentDeclar) {
          this.maybeConvertFromClassFunctionDeclaration(path);
          this.maybeConvertFromClassFunctionExpression(path);
        }
      }
    };
    exports2.default = Renamer;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/binding.js
var require_binding = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/binding.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var Binding = class {
      constructor({
        identifier: identifier4,
        scope,
        path,
        kind
      }) {
        this.identifier = void 0;
        this.scope = void 0;
        this.path = void 0;
        this.kind = void 0;
        this.constantViolations = [];
        this.constant = true;
        this.referencePaths = [];
        this.referenced = false;
        this.references = 0;
        this.identifier = identifier4;
        this.scope = scope;
        this.path = path;
        this.kind = kind;
        if ((kind === "var" || kind === "hoisted") && isDeclaredInLoop(path)) {
          this.reassign(path);
        }
        this.clearValue();
      }
      deoptValue() {
        this.clearValue();
        this.hasDeoptedValue = true;
      }
      setValue(value) {
        if (this.hasDeoptedValue) return;
        this.hasValue = true;
        this.value = value;
      }
      clearValue() {
        this.hasDeoptedValue = false;
        this.hasValue = false;
        this.value = null;
      }
      reassign(path) {
        this.constant = false;
        if (this.constantViolations.includes(path)) {
          return;
        }
        this.constantViolations.push(path);
      }
      reference(path) {
        if (this.referencePaths.includes(path)) {
          return;
        }
        this.referenced = true;
        this.references++;
        this.referencePaths.push(path);
      }
      dereference() {
        this.references--;
        this.referenced = !!this.references;
      }
    };
    exports2.default = Binding;
    function isDeclaredInLoop(path) {
      for (let {
        parentPath,
        key: key2
      } = path; parentPath; {
        parentPath,
        key: key2
      } = parentPath) {
        if (parentPath.isFunctionParent()) return false;
        if (parentPath.isWhile() || parentPath.isForXStatement() || parentPath.isForStatement() && key2 === "body") {
          return true;
        }
      }
      return false;
    }
  }
});

// ../../node_modules/globals/globals.json
var require_globals = __commonJS({
  "../../node_modules/globals/globals.json"(exports2, module2) {
    module2.exports = {
      builtin: {
        Array: false,
        ArrayBuffer: false,
        Atomics: false,
        BigInt: false,
        BigInt64Array: false,
        BigUint64Array: false,
        Boolean: false,
        constructor: false,
        DataView: false,
        Date: false,
        decodeURI: false,
        decodeURIComponent: false,
        encodeURI: false,
        encodeURIComponent: false,
        Error: false,
        escape: false,
        eval: false,
        EvalError: false,
        Float32Array: false,
        Float64Array: false,
        Function: false,
        globalThis: false,
        hasOwnProperty: false,
        Infinity: false,
        Int16Array: false,
        Int32Array: false,
        Int8Array: false,
        isFinite: false,
        isNaN: false,
        isPrototypeOf: false,
        JSON: false,
        Map: false,
        Math: false,
        NaN: false,
        Number: false,
        Object: false,
        parseFloat: false,
        parseInt: false,
        Promise: false,
        propertyIsEnumerable: false,
        Proxy: false,
        RangeError: false,
        ReferenceError: false,
        Reflect: false,
        RegExp: false,
        Set: false,
        SharedArrayBuffer: false,
        String: false,
        Symbol: false,
        SyntaxError: false,
        toLocaleString: false,
        toString: false,
        TypeError: false,
        Uint16Array: false,
        Uint32Array: false,
        Uint8Array: false,
        Uint8ClampedArray: false,
        undefined: false,
        unescape: false,
        URIError: false,
        valueOf: false,
        WeakMap: false,
        WeakSet: false
      },
      es5: {
        Array: false,
        Boolean: false,
        constructor: false,
        Date: false,
        decodeURI: false,
        decodeURIComponent: false,
        encodeURI: false,
        encodeURIComponent: false,
        Error: false,
        escape: false,
        eval: false,
        EvalError: false,
        Function: false,
        hasOwnProperty: false,
        Infinity: false,
        isFinite: false,
        isNaN: false,
        isPrototypeOf: false,
        JSON: false,
        Math: false,
        NaN: false,
        Number: false,
        Object: false,
        parseFloat: false,
        parseInt: false,
        propertyIsEnumerable: false,
        RangeError: false,
        ReferenceError: false,
        RegExp: false,
        String: false,
        SyntaxError: false,
        toLocaleString: false,
        toString: false,
        TypeError: false,
        undefined: false,
        unescape: false,
        URIError: false,
        valueOf: false
      },
      es2015: {
        Array: false,
        ArrayBuffer: false,
        Boolean: false,
        constructor: false,
        DataView: false,
        Date: false,
        decodeURI: false,
        decodeURIComponent: false,
        encodeURI: false,
        encodeURIComponent: false,
        Error: false,
        escape: false,
        eval: false,
        EvalError: false,
        Float32Array: false,
        Float64Array: false,
        Function: false,
        hasOwnProperty: false,
        Infinity: false,
        Int16Array: false,
        Int32Array: false,
        Int8Array: false,
        isFinite: false,
        isNaN: false,
        isPrototypeOf: false,
        JSON: false,
        Map: false,
        Math: false,
        NaN: false,
        Number: false,
        Object: false,
        parseFloat: false,
        parseInt: false,
        Promise: false,
        propertyIsEnumerable: false,
        Proxy: false,
        RangeError: false,
        ReferenceError: false,
        Reflect: false,
        RegExp: false,
        Set: false,
        String: false,
        Symbol: false,
        SyntaxError: false,
        toLocaleString: false,
        toString: false,
        TypeError: false,
        Uint16Array: false,
        Uint32Array: false,
        Uint8Array: false,
        Uint8ClampedArray: false,
        undefined: false,
        unescape: false,
        URIError: false,
        valueOf: false,
        WeakMap: false,
        WeakSet: false
      },
      es2017: {
        Array: false,
        ArrayBuffer: false,
        Atomics: false,
        Boolean: false,
        constructor: false,
        DataView: false,
        Date: false,
        decodeURI: false,
        decodeURIComponent: false,
        encodeURI: false,
        encodeURIComponent: false,
        Error: false,
        escape: false,
        eval: false,
        EvalError: false,
        Float32Array: false,
        Float64Array: false,
        Function: false,
        hasOwnProperty: false,
        Infinity: false,
        Int16Array: false,
        Int32Array: false,
        Int8Array: false,
        isFinite: false,
        isNaN: false,
        isPrototypeOf: false,
        JSON: false,
        Map: false,
        Math: false,
        NaN: false,
        Number: false,
        Object: false,
        parseFloat: false,
        parseInt: false,
        Promise: false,
        propertyIsEnumerable: false,
        Proxy: false,
        RangeError: false,
        ReferenceError: false,
        Reflect: false,
        RegExp: false,
        Set: false,
        SharedArrayBuffer: false,
        String: false,
        Symbol: false,
        SyntaxError: false,
        toLocaleString: false,
        toString: false,
        TypeError: false,
        Uint16Array: false,
        Uint32Array: false,
        Uint8Array: false,
        Uint8ClampedArray: false,
        undefined: false,
        unescape: false,
        URIError: false,
        valueOf: false,
        WeakMap: false,
        WeakSet: false
      },
      browser: {
        AbortController: false,
        AbortSignal: false,
        addEventListener: false,
        alert: false,
        AnalyserNode: false,
        Animation: false,
        AnimationEffectReadOnly: false,
        AnimationEffectTiming: false,
        AnimationEffectTimingReadOnly: false,
        AnimationEvent: false,
        AnimationPlaybackEvent: false,
        AnimationTimeline: false,
        applicationCache: false,
        ApplicationCache: false,
        ApplicationCacheErrorEvent: false,
        atob: false,
        Attr: false,
        Audio: false,
        AudioBuffer: false,
        AudioBufferSourceNode: false,
        AudioContext: false,
        AudioDestinationNode: false,
        AudioListener: false,
        AudioNode: false,
        AudioParam: false,
        AudioProcessingEvent: false,
        AudioScheduledSourceNode: false,
        "AudioWorkletGlobalScope ": false,
        AudioWorkletNode: false,
        AudioWorkletProcessor: false,
        BarProp: false,
        BaseAudioContext: false,
        BatteryManager: false,
        BeforeUnloadEvent: false,
        BiquadFilterNode: false,
        Blob: false,
        BlobEvent: false,
        blur: false,
        BroadcastChannel: false,
        btoa: false,
        BudgetService: false,
        ByteLengthQueuingStrategy: false,
        Cache: false,
        caches: false,
        CacheStorage: false,
        cancelAnimationFrame: false,
        cancelIdleCallback: false,
        CanvasCaptureMediaStreamTrack: false,
        CanvasGradient: false,
        CanvasPattern: false,
        CanvasRenderingContext2D: false,
        ChannelMergerNode: false,
        ChannelSplitterNode: false,
        CharacterData: false,
        clearInterval: false,
        clearTimeout: false,
        clientInformation: false,
        ClipboardEvent: false,
        close: false,
        closed: false,
        CloseEvent: false,
        Comment: false,
        CompositionEvent: false,
        confirm: false,
        console: false,
        ConstantSourceNode: false,
        ConvolverNode: false,
        CountQueuingStrategy: false,
        createImageBitmap: false,
        Credential: false,
        CredentialsContainer: false,
        crypto: false,
        Crypto: false,
        CryptoKey: false,
        CSS: false,
        CSSConditionRule: false,
        CSSFontFaceRule: false,
        CSSGroupingRule: false,
        CSSImportRule: false,
        CSSKeyframeRule: false,
        CSSKeyframesRule: false,
        CSSMediaRule: false,
        CSSNamespaceRule: false,
        CSSPageRule: false,
        CSSRule: false,
        CSSRuleList: false,
        CSSStyleDeclaration: false,
        CSSStyleRule: false,
        CSSStyleSheet: false,
        CSSSupportsRule: false,
        CustomElementRegistry: false,
        customElements: false,
        CustomEvent: false,
        DataTransfer: false,
        DataTransferItem: false,
        DataTransferItemList: false,
        defaultstatus: false,
        defaultStatus: false,
        DelayNode: false,
        DeviceMotionEvent: false,
        DeviceOrientationEvent: false,
        devicePixelRatio: false,
        dispatchEvent: false,
        document: false,
        Document: false,
        DocumentFragment: false,
        DocumentType: false,
        DOMError: false,
        DOMException: false,
        DOMImplementation: false,
        DOMMatrix: false,
        DOMMatrixReadOnly: false,
        DOMParser: false,
        DOMPoint: false,
        DOMPointReadOnly: false,
        DOMQuad: false,
        DOMRect: false,
        DOMRectReadOnly: false,
        DOMStringList: false,
        DOMStringMap: false,
        DOMTokenList: false,
        DragEvent: false,
        DynamicsCompressorNode: false,
        Element: false,
        ErrorEvent: false,
        event: false,
        Event: false,
        EventSource: false,
        EventTarget: false,
        external: false,
        fetch: false,
        File: false,
        FileList: false,
        FileReader: false,
        find: false,
        focus: false,
        FocusEvent: false,
        FontFace: false,
        FontFaceSetLoadEvent: false,
        FormData: false,
        frameElement: false,
        frames: false,
        GainNode: false,
        Gamepad: false,
        GamepadButton: false,
        GamepadEvent: false,
        getComputedStyle: false,
        getSelection: false,
        HashChangeEvent: false,
        Headers: false,
        history: false,
        History: false,
        HTMLAllCollection: false,
        HTMLAnchorElement: false,
        HTMLAreaElement: false,
        HTMLAudioElement: false,
        HTMLBaseElement: false,
        HTMLBodyElement: false,
        HTMLBRElement: false,
        HTMLButtonElement: false,
        HTMLCanvasElement: false,
        HTMLCollection: false,
        HTMLContentElement: false,
        HTMLDataElement: false,
        HTMLDataListElement: false,
        HTMLDetailsElement: false,
        HTMLDialogElement: false,
        HTMLDirectoryElement: false,
        HTMLDivElement: false,
        HTMLDListElement: false,
        HTMLDocument: false,
        HTMLElement: false,
        HTMLEmbedElement: false,
        HTMLFieldSetElement: false,
        HTMLFontElement: false,
        HTMLFormControlsCollection: false,
        HTMLFormElement: false,
        HTMLFrameElement: false,
        HTMLFrameSetElement: false,
        HTMLHeadElement: false,
        HTMLHeadingElement: false,
        HTMLHRElement: false,
        HTMLHtmlElement: false,
        HTMLIFrameElement: false,
        HTMLImageElement: false,
        HTMLInputElement: false,
        HTMLLabelElement: false,
        HTMLLegendElement: false,
        HTMLLIElement: false,
        HTMLLinkElement: false,
        HTMLMapElement: false,
        HTMLMarqueeElement: false,
        HTMLMediaElement: false,
        HTMLMenuElement: false,
        HTMLMetaElement: false,
        HTMLMeterElement: false,
        HTMLModElement: false,
        HTMLObjectElement: false,
        HTMLOListElement: false,
        HTMLOptGroupElement: false,
        HTMLOptionElement: false,
        HTMLOptionsCollection: false,
        HTMLOutputElement: false,
        HTMLParagraphElement: false,
        HTMLParamElement: false,
        HTMLPictureElement: false,
        HTMLPreElement: false,
        HTMLProgressElement: false,
        HTMLQuoteElement: false,
        HTMLScriptElement: false,
        HTMLSelectElement: false,
        HTMLShadowElement: false,
        HTMLSlotElement: false,
        HTMLSourceElement: false,
        HTMLSpanElement: false,
        HTMLStyleElement: false,
        HTMLTableCaptionElement: false,
        HTMLTableCellElement: false,
        HTMLTableColElement: false,
        HTMLTableElement: false,
        HTMLTableRowElement: false,
        HTMLTableSectionElement: false,
        HTMLTemplateElement: false,
        HTMLTextAreaElement: false,
        HTMLTimeElement: false,
        HTMLTitleElement: false,
        HTMLTrackElement: false,
        HTMLUListElement: false,
        HTMLUnknownElement: false,
        HTMLVideoElement: false,
        IDBCursor: false,
        IDBCursorWithValue: false,
        IDBDatabase: false,
        IDBFactory: false,
        IDBIndex: false,
        IDBKeyRange: false,
        IDBObjectStore: false,
        IDBOpenDBRequest: false,
        IDBRequest: false,
        IDBTransaction: false,
        IDBVersionChangeEvent: false,
        IdleDeadline: false,
        IIRFilterNode: false,
        Image: false,
        ImageBitmap: false,
        ImageBitmapRenderingContext: false,
        ImageCapture: false,
        ImageData: false,
        indexedDB: false,
        innerHeight: false,
        innerWidth: false,
        InputEvent: false,
        IntersectionObserver: false,
        IntersectionObserverEntry: false,
        Intl: false,
        isSecureContext: false,
        KeyboardEvent: false,
        KeyframeEffect: false,
        KeyframeEffectReadOnly: false,
        length: false,
        localStorage: false,
        location: true,
        Location: false,
        locationbar: false,
        matchMedia: false,
        MediaDeviceInfo: false,
        MediaDevices: false,
        MediaElementAudioSourceNode: false,
        MediaEncryptedEvent: false,
        MediaError: false,
        MediaKeyMessageEvent: false,
        MediaKeySession: false,
        MediaKeyStatusMap: false,
        MediaKeySystemAccess: false,
        MediaList: false,
        MediaQueryList: false,
        MediaQueryListEvent: false,
        MediaRecorder: false,
        MediaSettingsRange: false,
        MediaSource: false,
        MediaStream: false,
        MediaStreamAudioDestinationNode: false,
        MediaStreamAudioSourceNode: false,
        MediaStreamEvent: false,
        MediaStreamTrack: false,
        MediaStreamTrackEvent: false,
        menubar: false,
        MessageChannel: false,
        MessageEvent: false,
        MessagePort: false,
        MIDIAccess: false,
        MIDIConnectionEvent: false,
        MIDIInput: false,
        MIDIInputMap: false,
        MIDIMessageEvent: false,
        MIDIOutput: false,
        MIDIOutputMap: false,
        MIDIPort: false,
        MimeType: false,
        MimeTypeArray: false,
        MouseEvent: false,
        moveBy: false,
        moveTo: false,
        MutationEvent: false,
        MutationObserver: false,
        MutationRecord: false,
        name: false,
        NamedNodeMap: false,
        NavigationPreloadManager: false,
        navigator: false,
        Navigator: false,
        NetworkInformation: false,
        Node: false,
        NodeFilter: false,
        NodeIterator: false,
        NodeList: false,
        Notification: false,
        OfflineAudioCompletionEvent: false,
        OfflineAudioContext: false,
        offscreenBuffering: false,
        OffscreenCanvas: true,
        onabort: true,
        onafterprint: true,
        onanimationend: true,
        onanimationiteration: true,
        onanimationstart: true,
        onappinstalled: true,
        onauxclick: true,
        onbeforeinstallprompt: true,
        onbeforeprint: true,
        onbeforeunload: true,
        onblur: true,
        oncancel: true,
        oncanplay: true,
        oncanplaythrough: true,
        onchange: true,
        onclick: true,
        onclose: true,
        oncontextmenu: true,
        oncuechange: true,
        ondblclick: true,
        ondevicemotion: true,
        ondeviceorientation: true,
        ondeviceorientationabsolute: true,
        ondrag: true,
        ondragend: true,
        ondragenter: true,
        ondragleave: true,
        ondragover: true,
        ondragstart: true,
        ondrop: true,
        ondurationchange: true,
        onemptied: true,
        onended: true,
        onerror: true,
        onfocus: true,
        ongotpointercapture: true,
        onhashchange: true,
        oninput: true,
        oninvalid: true,
        onkeydown: true,
        onkeypress: true,
        onkeyup: true,
        onlanguagechange: true,
        onload: true,
        onloadeddata: true,
        onloadedmetadata: true,
        onloadstart: true,
        onlostpointercapture: true,
        onmessage: true,
        onmessageerror: true,
        onmousedown: true,
        onmouseenter: true,
        onmouseleave: true,
        onmousemove: true,
        onmouseout: true,
        onmouseover: true,
        onmouseup: true,
        onmousewheel: true,
        onoffline: true,
        ononline: true,
        onpagehide: true,
        onpageshow: true,
        onpause: true,
        onplay: true,
        onplaying: true,
        onpointercancel: true,
        onpointerdown: true,
        onpointerenter: true,
        onpointerleave: true,
        onpointermove: true,
        onpointerout: true,
        onpointerover: true,
        onpointerup: true,
        onpopstate: true,
        onprogress: true,
        onratechange: true,
        onrejectionhandled: true,
        onreset: true,
        onresize: true,
        onscroll: true,
        onsearch: true,
        onseeked: true,
        onseeking: true,
        onselect: true,
        onstalled: true,
        onstorage: true,
        onsubmit: true,
        onsuspend: true,
        ontimeupdate: true,
        ontoggle: true,
        ontransitionend: true,
        onunhandledrejection: true,
        onunload: true,
        onvolumechange: true,
        onwaiting: true,
        onwheel: true,
        open: false,
        openDatabase: false,
        opener: false,
        Option: false,
        origin: false,
        OscillatorNode: false,
        outerHeight: false,
        outerWidth: false,
        PageTransitionEvent: false,
        pageXOffset: false,
        pageYOffset: false,
        PannerNode: false,
        parent: false,
        Path2D: false,
        PaymentAddress: false,
        PaymentRequest: false,
        PaymentRequestUpdateEvent: false,
        PaymentResponse: false,
        performance: false,
        Performance: false,
        PerformanceEntry: false,
        PerformanceLongTaskTiming: false,
        PerformanceMark: false,
        PerformanceMeasure: false,
        PerformanceNavigation: false,
        PerformanceNavigationTiming: false,
        PerformanceObserver: false,
        PerformanceObserverEntryList: false,
        PerformancePaintTiming: false,
        PerformanceResourceTiming: false,
        PerformanceTiming: false,
        PeriodicWave: false,
        Permissions: false,
        PermissionStatus: false,
        personalbar: false,
        PhotoCapabilities: false,
        Plugin: false,
        PluginArray: false,
        PointerEvent: false,
        PopStateEvent: false,
        postMessage: false,
        Presentation: false,
        PresentationAvailability: false,
        PresentationConnection: false,
        PresentationConnectionAvailableEvent: false,
        PresentationConnectionCloseEvent: false,
        PresentationConnectionList: false,
        PresentationReceiver: false,
        PresentationRequest: false,
        print: false,
        ProcessingInstruction: false,
        ProgressEvent: false,
        PromiseRejectionEvent: false,
        prompt: false,
        PushManager: false,
        PushSubscription: false,
        PushSubscriptionOptions: false,
        queueMicrotask: false,
        RadioNodeList: false,
        Range: false,
        ReadableStream: false,
        registerProcessor: false,
        RemotePlayback: false,
        removeEventListener: false,
        Request: false,
        requestAnimationFrame: false,
        requestIdleCallback: false,
        resizeBy: false,
        ResizeObserver: false,
        ResizeObserverEntry: false,
        resizeTo: false,
        Response: false,
        RTCCertificate: false,
        RTCDataChannel: false,
        RTCDataChannelEvent: false,
        RTCDtlsTransport: false,
        RTCIceCandidate: false,
        RTCIceGatherer: false,
        RTCIceTransport: false,
        RTCPeerConnection: false,
        RTCPeerConnectionIceEvent: false,
        RTCRtpContributingSource: false,
        RTCRtpReceiver: false,
        RTCRtpSender: false,
        RTCSctpTransport: false,
        RTCSessionDescription: false,
        RTCStatsReport: false,
        RTCTrackEvent: false,
        screen: false,
        Screen: false,
        screenLeft: false,
        ScreenOrientation: false,
        screenTop: false,
        screenX: false,
        screenY: false,
        ScriptProcessorNode: false,
        scroll: false,
        scrollbars: false,
        scrollBy: false,
        scrollTo: false,
        scrollX: false,
        scrollY: false,
        SecurityPolicyViolationEvent: false,
        Selection: false,
        self: false,
        ServiceWorker: false,
        ServiceWorkerContainer: false,
        ServiceWorkerRegistration: false,
        sessionStorage: false,
        setInterval: false,
        setTimeout: false,
        ShadowRoot: false,
        SharedWorker: false,
        SourceBuffer: false,
        SourceBufferList: false,
        speechSynthesis: false,
        SpeechSynthesisEvent: false,
        SpeechSynthesisUtterance: false,
        StaticRange: false,
        status: false,
        statusbar: false,
        StereoPannerNode: false,
        stop: false,
        Storage: false,
        StorageEvent: false,
        StorageManager: false,
        styleMedia: false,
        StyleSheet: false,
        StyleSheetList: false,
        SubtleCrypto: false,
        SVGAElement: false,
        SVGAngle: false,
        SVGAnimatedAngle: false,
        SVGAnimatedBoolean: false,
        SVGAnimatedEnumeration: false,
        SVGAnimatedInteger: false,
        SVGAnimatedLength: false,
        SVGAnimatedLengthList: false,
        SVGAnimatedNumber: false,
        SVGAnimatedNumberList: false,
        SVGAnimatedPreserveAspectRatio: false,
        SVGAnimatedRect: false,
        SVGAnimatedString: false,
        SVGAnimatedTransformList: false,
        SVGAnimateElement: false,
        SVGAnimateMotionElement: false,
        SVGAnimateTransformElement: false,
        SVGAnimationElement: false,
        SVGCircleElement: false,
        SVGClipPathElement: false,
        SVGComponentTransferFunctionElement: false,
        SVGDefsElement: false,
        SVGDescElement: false,
        SVGDiscardElement: false,
        SVGElement: false,
        SVGEllipseElement: false,
        SVGFEBlendElement: false,
        SVGFEColorMatrixElement: false,
        SVGFEComponentTransferElement: false,
        SVGFECompositeElement: false,
        SVGFEConvolveMatrixElement: false,
        SVGFEDiffuseLightingElement: false,
        SVGFEDisplacementMapElement: false,
        SVGFEDistantLightElement: false,
        SVGFEDropShadowElement: false,
        SVGFEFloodElement: false,
        SVGFEFuncAElement: false,
        SVGFEFuncBElement: false,
        SVGFEFuncGElement: false,
        SVGFEFuncRElement: false,
        SVGFEGaussianBlurElement: false,
        SVGFEImageElement: false,
        SVGFEMergeElement: false,
        SVGFEMergeNodeElement: false,
        SVGFEMorphologyElement: false,
        SVGFEOffsetElement: false,
        SVGFEPointLightElement: false,
        SVGFESpecularLightingElement: false,
        SVGFESpotLightElement: false,
        SVGFETileElement: false,
        SVGFETurbulenceElement: false,
        SVGFilterElement: false,
        SVGForeignObjectElement: false,
        SVGGElement: false,
        SVGGeometryElement: false,
        SVGGradientElement: false,
        SVGGraphicsElement: false,
        SVGImageElement: false,
        SVGLength: false,
        SVGLengthList: false,
        SVGLinearGradientElement: false,
        SVGLineElement: false,
        SVGMarkerElement: false,
        SVGMaskElement: false,
        SVGMatrix: false,
        SVGMetadataElement: false,
        SVGMPathElement: false,
        SVGNumber: false,
        SVGNumberList: false,
        SVGPathElement: false,
        SVGPatternElement: false,
        SVGPoint: false,
        SVGPointList: false,
        SVGPolygonElement: false,
        SVGPolylineElement: false,
        SVGPreserveAspectRatio: false,
        SVGRadialGradientElement: false,
        SVGRect: false,
        SVGRectElement: false,
        SVGScriptElement: false,
        SVGSetElement: false,
        SVGStopElement: false,
        SVGStringList: false,
        SVGStyleElement: false,
        SVGSVGElement: false,
        SVGSwitchElement: false,
        SVGSymbolElement: false,
        SVGTextContentElement: false,
        SVGTextElement: false,
        SVGTextPathElement: false,
        SVGTextPositioningElement: false,
        SVGTitleElement: false,
        SVGTransform: false,
        SVGTransformList: false,
        SVGTSpanElement: false,
        SVGUnitTypes: false,
        SVGUseElement: false,
        SVGViewElement: false,
        TaskAttributionTiming: false,
        Text: false,
        TextDecoder: false,
        TextEncoder: false,
        TextEvent: false,
        TextMetrics: false,
        TextTrack: false,
        TextTrackCue: false,
        TextTrackCueList: false,
        TextTrackList: false,
        TimeRanges: false,
        toolbar: false,
        top: false,
        Touch: false,
        TouchEvent: false,
        TouchList: false,
        TrackEvent: false,
        TransitionEvent: false,
        TreeWalker: false,
        UIEvent: false,
        URL: false,
        URLSearchParams: false,
        ValidityState: false,
        visualViewport: false,
        VisualViewport: false,
        VTTCue: false,
        WaveShaperNode: false,
        WebAssembly: false,
        WebGL2RenderingContext: false,
        WebGLActiveInfo: false,
        WebGLBuffer: false,
        WebGLContextEvent: false,
        WebGLFramebuffer: false,
        WebGLProgram: false,
        WebGLQuery: false,
        WebGLRenderbuffer: false,
        WebGLRenderingContext: false,
        WebGLSampler: false,
        WebGLShader: false,
        WebGLShaderPrecisionFormat: false,
        WebGLSync: false,
        WebGLTexture: false,
        WebGLTransformFeedback: false,
        WebGLUniformLocation: false,
        WebGLVertexArrayObject: false,
        WebSocket: false,
        WheelEvent: false,
        window: false,
        Window: false,
        Worker: false,
        WritableStream: false,
        XMLDocument: false,
        XMLHttpRequest: false,
        XMLHttpRequestEventTarget: false,
        XMLHttpRequestUpload: false,
        XMLSerializer: false,
        XPathEvaluator: false,
        XPathExpression: false,
        XPathResult: false,
        XSLTProcessor: false
      },
      worker: {
        addEventListener: false,
        applicationCache: false,
        atob: false,
        Blob: false,
        BroadcastChannel: false,
        btoa: false,
        Cache: false,
        caches: false,
        clearInterval: false,
        clearTimeout: false,
        close: true,
        console: false,
        fetch: false,
        FileReaderSync: false,
        FormData: false,
        Headers: false,
        IDBCursor: false,
        IDBCursorWithValue: false,
        IDBDatabase: false,
        IDBFactory: false,
        IDBIndex: false,
        IDBKeyRange: false,
        IDBObjectStore: false,
        IDBOpenDBRequest: false,
        IDBRequest: false,
        IDBTransaction: false,
        IDBVersionChangeEvent: false,
        ImageData: false,
        importScripts: true,
        indexedDB: false,
        location: false,
        MessageChannel: false,
        MessagePort: false,
        name: false,
        navigator: false,
        Notification: false,
        onclose: true,
        onconnect: true,
        onerror: true,
        onlanguagechange: true,
        onmessage: true,
        onoffline: true,
        ononline: true,
        onrejectionhandled: true,
        onunhandledrejection: true,
        performance: false,
        Performance: false,
        PerformanceEntry: false,
        PerformanceMark: false,
        PerformanceMeasure: false,
        PerformanceNavigation: false,
        PerformanceResourceTiming: false,
        PerformanceTiming: false,
        postMessage: true,
        Promise: false,
        queueMicrotask: false,
        removeEventListener: false,
        Request: false,
        Response: false,
        self: true,
        ServiceWorkerRegistration: false,
        setInterval: false,
        setTimeout: false,
        TextDecoder: false,
        TextEncoder: false,
        URL: false,
        URLSearchParams: false,
        WebSocket: false,
        Worker: false,
        WorkerGlobalScope: false,
        XMLHttpRequest: false
      },
      node: {
        __dirname: false,
        __filename: false,
        Buffer: false,
        clearImmediate: false,
        clearInterval: false,
        clearTimeout: false,
        console: false,
        exports: true,
        global: false,
        Intl: false,
        module: false,
        process: false,
        queueMicrotask: false,
        require: false,
        setImmediate: false,
        setInterval: false,
        setTimeout: false,
        TextDecoder: false,
        TextEncoder: false,
        URL: false,
        URLSearchParams: false
      },
      commonjs: {
        exports: true,
        global: false,
        module: false,
        require: false
      },
      amd: {
        define: false,
        require: false
      },
      mocha: {
        after: false,
        afterEach: false,
        before: false,
        beforeEach: false,
        context: false,
        describe: false,
        it: false,
        mocha: false,
        run: false,
        setup: false,
        specify: false,
        suite: false,
        suiteSetup: false,
        suiteTeardown: false,
        teardown: false,
        test: false,
        xcontext: false,
        xdescribe: false,
        xit: false,
        xspecify: false
      },
      jasmine: {
        afterAll: false,
        afterEach: false,
        beforeAll: false,
        beforeEach: false,
        describe: false,
        expect: false,
        fail: false,
        fdescribe: false,
        fit: false,
        it: false,
        jasmine: false,
        pending: false,
        runs: false,
        spyOn: false,
        spyOnProperty: false,
        waits: false,
        waitsFor: false,
        xdescribe: false,
        xit: false
      },
      jest: {
        afterAll: false,
        afterEach: false,
        beforeAll: false,
        beforeEach: false,
        describe: false,
        expect: false,
        fdescribe: false,
        fit: false,
        it: false,
        jest: false,
        pit: false,
        require: false,
        test: false,
        xdescribe: false,
        xit: false,
        xtest: false
      },
      qunit: {
        asyncTest: false,
        deepEqual: false,
        equal: false,
        expect: false,
        module: false,
        notDeepEqual: false,
        notEqual: false,
        notOk: false,
        notPropEqual: false,
        notStrictEqual: false,
        ok: false,
        propEqual: false,
        QUnit: false,
        raises: false,
        start: false,
        stop: false,
        strictEqual: false,
        test: false,
        throws: false
      },
      phantomjs: {
        console: true,
        exports: true,
        phantom: true,
        require: true,
        WebPage: true
      },
      couch: {
        emit: false,
        exports: false,
        getRow: false,
        log: false,
        module: false,
        provides: false,
        require: false,
        respond: false,
        send: false,
        start: false,
        sum: false
      },
      rhino: {
        defineClass: false,
        deserialize: false,
        gc: false,
        help: false,
        importClass: false,
        importPackage: false,
        java: false,
        load: false,
        loadClass: false,
        Packages: false,
        print: false,
        quit: false,
        readFile: false,
        readUrl: false,
        runCommand: false,
        seal: false,
        serialize: false,
        spawn: false,
        sync: false,
        toint32: false,
        version: false
      },
      nashorn: {
        __DIR__: false,
        __FILE__: false,
        __LINE__: false,
        com: false,
        edu: false,
        exit: false,
        java: false,
        Java: false,
        javafx: false,
        JavaImporter: false,
        javax: false,
        JSAdapter: false,
        load: false,
        loadWithNewGlobal: false,
        org: false,
        Packages: false,
        print: false,
        quit: false
      },
      wsh: {
        ActiveXObject: true,
        Enumerator: true,
        GetObject: true,
        ScriptEngine: true,
        ScriptEngineBuildVersion: true,
        ScriptEngineMajorVersion: true,
        ScriptEngineMinorVersion: true,
        VBArray: true,
        WScript: true,
        WSH: true,
        XDomainRequest: true
      },
      jquery: {
        $: false,
        jQuery: false
      },
      yui: {
        YAHOO: false,
        YAHOO_config: false,
        YUI: false,
        YUI_config: false
      },
      shelljs: {
        cat: false,
        cd: false,
        chmod: false,
        config: false,
        cp: false,
        dirs: false,
        echo: false,
        env: false,
        error: false,
        exec: false,
        exit: false,
        find: false,
        grep: false,
        ln: false,
        ls: false,
        mkdir: false,
        mv: false,
        popd: false,
        pushd: false,
        pwd: false,
        rm: false,
        sed: false,
        set: false,
        target: false,
        tempdir: false,
        test: false,
        touch: false,
        which: false
      },
      prototypejs: {
        $: false,
        $$: false,
        $A: false,
        $break: false,
        $continue: false,
        $F: false,
        $H: false,
        $R: false,
        $w: false,
        Abstract: false,
        Ajax: false,
        Autocompleter: false,
        Builder: false,
        Class: false,
        Control: false,
        Draggable: false,
        Draggables: false,
        Droppables: false,
        Effect: false,
        Element: false,
        Enumerable: false,
        Event: false,
        Field: false,
        Form: false,
        Hash: false,
        Insertion: false,
        ObjectRange: false,
        PeriodicalExecuter: false,
        Position: false,
        Prototype: false,
        Scriptaculous: false,
        Selector: false,
        Sortable: false,
        SortableObserver: false,
        Sound: false,
        Template: false,
        Toggle: false,
        Try: false
      },
      meteor: {
        _: false,
        $: false,
        Accounts: false,
        AccountsClient: false,
        AccountsCommon: false,
        AccountsServer: false,
        App: false,
        Assets: false,
        Blaze: false,
        check: false,
        Cordova: false,
        DDP: false,
        DDPRateLimiter: false,
        DDPServer: false,
        Deps: false,
        EJSON: false,
        Email: false,
        HTTP: false,
        Log: false,
        Match: false,
        Meteor: false,
        Mongo: false,
        MongoInternals: false,
        Npm: false,
        Package: false,
        Plugin: false,
        process: false,
        Random: false,
        ReactiveDict: false,
        ReactiveVar: false,
        Router: false,
        ServiceConfiguration: false,
        Session: false,
        share: false,
        Spacebars: false,
        Template: false,
        Tinytest: false,
        Tracker: false,
        UI: false,
        Utils: false,
        WebApp: false,
        WebAppInternals: false
      },
      mongo: {
        _isWindows: false,
        _rand: false,
        BulkWriteResult: false,
        cat: false,
        cd: false,
        connect: false,
        db: false,
        getHostName: false,
        getMemInfo: false,
        hostname: false,
        ISODate: false,
        listFiles: false,
        load: false,
        ls: false,
        md5sumFile: false,
        mkdir: false,
        Mongo: false,
        NumberInt: false,
        NumberLong: false,
        ObjectId: false,
        PlanCache: false,
        print: false,
        printjson: false,
        pwd: false,
        quit: false,
        removeFile: false,
        rs: false,
        sh: false,
        UUID: false,
        version: false,
        WriteResult: false
      },
      applescript: {
        $: false,
        Application: false,
        Automation: false,
        console: false,
        delay: false,
        Library: false,
        ObjC: false,
        ObjectSpecifier: false,
        Path: false,
        Progress: false,
        Ref: false
      },
      serviceworker: {
        addEventListener: false,
        applicationCache: false,
        atob: false,
        Blob: false,
        BroadcastChannel: false,
        btoa: false,
        Cache: false,
        caches: false,
        CacheStorage: false,
        clearInterval: false,
        clearTimeout: false,
        Client: false,
        clients: false,
        Clients: false,
        close: true,
        console: false,
        ExtendableEvent: false,
        ExtendableMessageEvent: false,
        fetch: false,
        FetchEvent: false,
        FileReaderSync: false,
        FormData: false,
        Headers: false,
        IDBCursor: false,
        IDBCursorWithValue: false,
        IDBDatabase: false,
        IDBFactory: false,
        IDBIndex: false,
        IDBKeyRange: false,
        IDBObjectStore: false,
        IDBOpenDBRequest: false,
        IDBRequest: false,
        IDBTransaction: false,
        IDBVersionChangeEvent: false,
        ImageData: false,
        importScripts: false,
        indexedDB: false,
        location: false,
        MessageChannel: false,
        MessagePort: false,
        name: false,
        navigator: false,
        Notification: false,
        onclose: true,
        onconnect: true,
        onerror: true,
        onfetch: true,
        oninstall: true,
        onlanguagechange: true,
        onmessage: true,
        onmessageerror: true,
        onnotificationclick: true,
        onnotificationclose: true,
        onoffline: true,
        ononline: true,
        onpush: true,
        onpushsubscriptionchange: true,
        onrejectionhandled: true,
        onsync: true,
        onunhandledrejection: true,
        performance: false,
        Performance: false,
        PerformanceEntry: false,
        PerformanceMark: false,
        PerformanceMeasure: false,
        PerformanceNavigation: false,
        PerformanceResourceTiming: false,
        PerformanceTiming: false,
        postMessage: true,
        Promise: false,
        queueMicrotask: false,
        registration: false,
        removeEventListener: false,
        Request: false,
        Response: false,
        self: false,
        ServiceWorker: false,
        ServiceWorkerContainer: false,
        ServiceWorkerGlobalScope: false,
        ServiceWorkerMessageEvent: false,
        ServiceWorkerRegistration: false,
        setInterval: false,
        setTimeout: false,
        skipWaiting: false,
        TextDecoder: false,
        TextEncoder: false,
        URL: false,
        URLSearchParams: false,
        WebSocket: false,
        WindowClient: false,
        Worker: false,
        WorkerGlobalScope: false,
        XMLHttpRequest: false
      },
      atomtest: {
        advanceClock: false,
        fakeClearInterval: false,
        fakeClearTimeout: false,
        fakeSetInterval: false,
        fakeSetTimeout: false,
        resetTimeouts: false,
        waitsForPromise: false
      },
      embertest: {
        andThen: false,
        click: false,
        currentPath: false,
        currentRouteName: false,
        currentURL: false,
        fillIn: false,
        find: false,
        findAll: false,
        findWithAssert: false,
        keyEvent: false,
        pauseTest: false,
        resumeTest: false,
        triggerEvent: false,
        visit: false,
        wait: false
      },
      protractor: {
        $: false,
        $$: false,
        browser: false,
        by: false,
        By: false,
        DartObject: false,
        element: false,
        protractor: false
      },
      "shared-node-browser": {
        clearInterval: false,
        clearTimeout: false,
        console: false,
        setInterval: false,
        setTimeout: false,
        URL: false,
        URLSearchParams: false
      },
      webextensions: {
        browser: false,
        chrome: false,
        opr: false
      },
      greasemonkey: {
        cloneInto: false,
        createObjectIn: false,
        exportFunction: false,
        GM: false,
        GM_addStyle: false,
        GM_deleteValue: false,
        GM_getResourceText: false,
        GM_getResourceURL: false,
        GM_getValue: false,
        GM_info: false,
        GM_listValues: false,
        GM_log: false,
        GM_openInTab: false,
        GM_registerMenuCommand: false,
        GM_setClipboard: false,
        GM_setValue: false,
        GM_xmlhttpRequest: false,
        unsafeWindow: false
      },
      devtools: {
        $: false,
        $_: false,
        $$: false,
        $0: false,
        $1: false,
        $2: false,
        $3: false,
        $4: false,
        $x: false,
        chrome: false,
        clear: false,
        copy: false,
        debug: false,
        dir: false,
        dirxml: false,
        getEventListeners: false,
        inspect: false,
        keys: false,
        monitor: false,
        monitorEvents: false,
        profile: false,
        profileEnd: false,
        queryObjects: false,
        table: false,
        undebug: false,
        unmonitor: false,
        unmonitorEvents: false,
        values: false
      }
    };
  }
});

// ../../node_modules/globals/index.js
var require_globals2 = __commonJS({
  "../../node_modules/globals/index.js"(exports2, module2) {
    "use strict";
    module2.exports = require_globals();
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/cache.js
var require_cache = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/cache.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.clear = clear;
    exports2.clearPath = clearPath;
    exports2.clearScope = clearScope;
    exports2.getCachedPaths = getCachedPaths;
    exports2.getOrCreateCachedPaths = getOrCreateCachedPaths;
    exports2.scope = exports2.path = void 0;
    var pathsCache = exports2.path = /* @__PURE__ */ new WeakMap();
    var scope = exports2.scope = /* @__PURE__ */ new WeakMap();
    function clear() {
      clearPath();
      clearScope();
    }
    function clearPath() {
      exports2.path = pathsCache = /* @__PURE__ */ new WeakMap();
    }
    function clearScope() {
      exports2.scope = scope = /* @__PURE__ */ new WeakMap();
    }
    var nullHub = Object.freeze({});
    function getCachedPaths(hub, parent) {
      var _pathsCache$get, _hub;
      {
        hub = null;
      }
      return (_pathsCache$get = pathsCache.get((_hub = hub) != null ? _hub : nullHub)) == null ? void 0 : _pathsCache$get.get(parent);
    }
    function getOrCreateCachedPaths(hub, parent) {
      var _hub2, _hub3;
      {
        hub = null;
      }
      let parents = pathsCache.get((_hub2 = hub) != null ? _hub2 : nullHub);
      if (!parents) pathsCache.set((_hub3 = hub) != null ? _hub3 : nullHub, parents = /* @__PURE__ */ new WeakMap());
      let paths = parents.get(parent);
      if (!paths) parents.set(parent, paths = /* @__PURE__ */ new Map());
      return paths;
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/index.js
var require_scope = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/scope/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _renamer = require_renamer();
    var _index = require_lib6();
    var _binding = require_binding();
    var _globals4 = require_globals2();
    var _t = require("@babel/types");
    var t6 = _t;
    var _cache = require_cache();
    var _visitors = require_visitors();
    var {
      NOT_LOCAL_BINDING,
      assignmentExpression: assignmentExpression2,
      callExpression: callExpression4,
      cloneNode: cloneNode2,
      getBindingIdentifiers,
      identifier: identifier4,
      isArrayExpression,
      isBinary,
      isCallExpression,
      isClass,
      isClassBody,
      isClassDeclaration,
      isExportAllDeclaration,
      isExportDefaultDeclaration,
      isExportNamedDeclaration,
      isFunctionDeclaration,
      isIdentifier,
      isImportDeclaration,
      isLiteral,
      isMemberExpression: isMemberExpression2,
      isMethod,
      isModuleSpecifier,
      isNullLiteral,
      isObjectExpression,
      isProperty,
      isPureish,
      isRegExpLiteral,
      isSuper,
      isTaggedTemplateExpression,
      isTemplateLiteral,
      isThisExpression,
      isUnaryExpression,
      isVariableDeclaration: isVariableDeclaration2,
      expressionStatement: expressionStatement2,
      matchesPattern,
      memberExpression: memberExpression2,
      numericLiteral: numericLiteral2,
      toIdentifier,
      variableDeclaration: variableDeclaration4,
      variableDeclarator: variableDeclarator4,
      isRecordExpression,
      isTupleExpression,
      isObjectProperty,
      isTopicReference,
      isMetaProperty,
      isPrivateName,
      isExportDeclaration,
      buildUndefinedNode,
      sequenceExpression: sequenceExpression2
    } = _t;
    function gatherNodeParts(node, parts) {
      switch (node == null ? void 0 : node.type) {
        default:
          if (isImportDeclaration(node) || isExportDeclaration(node)) {
            var _node$specifiers;
            if ((isExportAllDeclaration(node) || isExportNamedDeclaration(node) || isImportDeclaration(node)) && node.source) {
              gatherNodeParts(node.source, parts);
            } else if ((isExportNamedDeclaration(node) || isImportDeclaration(node)) && (_node$specifiers = node.specifiers) != null && _node$specifiers.length) {
              for (const e of node.specifiers) gatherNodeParts(e, parts);
            } else if ((isExportDefaultDeclaration(node) || isExportNamedDeclaration(node)) && node.declaration) {
              gatherNodeParts(node.declaration, parts);
            }
          } else if (isModuleSpecifier(node)) {
            gatherNodeParts(node.local, parts);
          } else if (isLiteral(node) && !isNullLiteral(node) && !isRegExpLiteral(node) && !isTemplateLiteral(node)) {
            parts.push(node.value);
          }
          break;
        case "MemberExpression":
        case "OptionalMemberExpression":
        case "JSXMemberExpression":
          gatherNodeParts(node.object, parts);
          gatherNodeParts(node.property, parts);
          break;
        case "Identifier":
        case "JSXIdentifier":
          parts.push(node.name);
          break;
        case "CallExpression":
        case "OptionalCallExpression":
        case "NewExpression":
          gatherNodeParts(node.callee, parts);
          break;
        case "ObjectExpression":
        case "ObjectPattern":
          for (const e of node.properties) {
            gatherNodeParts(e, parts);
          }
          break;
        case "SpreadElement":
        case "RestElement":
          gatherNodeParts(node.argument, parts);
          break;
        case "ObjectProperty":
        case "ObjectMethod":
        case "ClassProperty":
        case "ClassMethod":
        case "ClassPrivateProperty":
        case "ClassPrivateMethod":
          gatherNodeParts(node.key, parts);
          break;
        case "ThisExpression":
          parts.push("this");
          break;
        case "Super":
          parts.push("super");
          break;
        case "Import":
          parts.push("import");
          break;
        case "DoExpression":
          parts.push("do");
          break;
        case "YieldExpression":
          parts.push("yield");
          gatherNodeParts(node.argument, parts);
          break;
        case "AwaitExpression":
          parts.push("await");
          gatherNodeParts(node.argument, parts);
          break;
        case "AssignmentExpression":
          gatherNodeParts(node.left, parts);
          break;
        case "VariableDeclarator":
          gatherNodeParts(node.id, parts);
          break;
        case "FunctionExpression":
        case "FunctionDeclaration":
        case "ClassExpression":
        case "ClassDeclaration":
          gatherNodeParts(node.id, parts);
          break;
        case "PrivateName":
          gatherNodeParts(node.id, parts);
          break;
        case "ParenthesizedExpression":
          gatherNodeParts(node.expression, parts);
          break;
        case "UnaryExpression":
        case "UpdateExpression":
          gatherNodeParts(node.argument, parts);
          break;
        case "MetaProperty":
          gatherNodeParts(node.meta, parts);
          gatherNodeParts(node.property, parts);
          break;
        case "JSXElement":
          gatherNodeParts(node.openingElement, parts);
          break;
        case "JSXOpeningElement":
          gatherNodeParts(node.name, parts);
          break;
        case "JSXFragment":
          gatherNodeParts(node.openingFragment, parts);
          break;
        case "JSXOpeningFragment":
          parts.push("Fragment");
          break;
        case "JSXNamespacedName":
          gatherNodeParts(node.namespace, parts);
          gatherNodeParts(node.name, parts);
          break;
      }
    }
    var collectorVisitor = {
      ForStatement(path) {
        const declar = path.get("init");
        if (declar.isVar()) {
          const {
            scope
          } = path;
          const parentScope = scope.getFunctionParent() || scope.getProgramParent();
          parentScope.registerBinding("var", declar);
        }
      },
      Declaration(path) {
        if (path.isBlockScoped()) return;
        if (path.isImportDeclaration()) return;
        if (path.isExportDeclaration()) return;
        const parent = path.scope.getFunctionParent() || path.scope.getProgramParent();
        parent.registerDeclaration(path);
      },
      ImportDeclaration(path) {
        const parent = path.scope.getBlockParent();
        parent.registerDeclaration(path);
      },
      ReferencedIdentifier(path, state) {
        state.references.push(path);
      },
      ForXStatement(path, state) {
        const left = path.get("left");
        if (left.isPattern() || left.isIdentifier()) {
          state.constantViolations.push(path);
        } else if (left.isVar()) {
          const {
            scope
          } = path;
          const parentScope = scope.getFunctionParent() || scope.getProgramParent();
          parentScope.registerBinding("var", left);
        }
      },
      ExportDeclaration: {
        exit(path) {
          const {
            node,
            scope
          } = path;
          if (isExportAllDeclaration(node)) return;
          const declar = node.declaration;
          if (isClassDeclaration(declar) || isFunctionDeclaration(declar)) {
            const id = declar.id;
            if (!id) return;
            const binding = scope.getBinding(id.name);
            binding == null || binding.reference(path);
          } else if (isVariableDeclaration2(declar)) {
            for (const decl of declar.declarations) {
              for (const name of Object.keys(getBindingIdentifiers(decl))) {
                const binding = scope.getBinding(name);
                binding == null || binding.reference(path);
              }
            }
          }
        }
      },
      LabeledStatement(path) {
        path.scope.getBlockParent().registerDeclaration(path);
      },
      AssignmentExpression(path, state) {
        state.assignments.push(path);
      },
      UpdateExpression(path, state) {
        state.constantViolations.push(path);
      },
      UnaryExpression(path, state) {
        if (path.node.operator === "delete") {
          state.constantViolations.push(path);
        }
      },
      BlockScoped(path) {
        let scope = path.scope;
        if (scope.path === path) scope = scope.parent;
        const parent = scope.getBlockParent();
        parent.registerDeclaration(path);
        if (path.isClassDeclaration() && path.node.id) {
          const id = path.node.id;
          const name = id.name;
          path.scope.bindings[name] = path.scope.parent.getBinding(name);
        }
      },
      CatchClause(path) {
        path.scope.registerBinding("let", path);
      },
      Function(path) {
        const params = path.get("params");
        for (const param of params) {
          path.scope.registerBinding("param", param);
        }
        if (path.isFunctionExpression() && path.node.id && !path.node.id[NOT_LOCAL_BINDING]) {
          path.scope.registerBinding("local", path.get("id"), path);
        }
      },
      ClassExpression(path) {
        if (path.node.id && !path.node.id[NOT_LOCAL_BINDING]) {
          path.scope.registerBinding("local", path.get("id"), path);
        }
      },
      TSTypeAnnotation(path) {
        path.skip();
      }
    };
    var uid = 0;
    var Scope = class _Scope {
      constructor(path) {
        this.uid = void 0;
        this.path = void 0;
        this.block = void 0;
        this.inited = void 0;
        this.labels = void 0;
        this.bindings = void 0;
        this.references = void 0;
        this.globals = void 0;
        this.uids = void 0;
        this.data = void 0;
        this.crawling = void 0;
        const {
          node
        } = path;
        const cached2 = _cache.scope.get(node);
        if ((cached2 == null ? void 0 : cached2.path) === path) {
          return cached2;
        }
        _cache.scope.set(node, this);
        this.uid = uid++;
        this.block = node;
        this.path = path;
        this.labels = /* @__PURE__ */ new Map();
        this.inited = false;
      }
      get parent() {
        var _parent;
        let parent, path = this.path;
        do {
          var _path;
          const shouldSkip = path.key === "key" || path.listKey === "decorators";
          path = path.parentPath;
          if (shouldSkip && path.isMethod()) path = path.parentPath;
          if ((_path = path) != null && _path.isScope()) parent = path;
        } while (path && !parent);
        return (_parent = parent) == null ? void 0 : _parent.scope;
      }
      generateDeclaredUidIdentifier(name) {
        const id = this.generateUidIdentifier(name);
        this.push({
          id
        });
        return cloneNode2(id);
      }
      generateUidIdentifier(name) {
        return identifier4(this.generateUid(name));
      }
      generateUid(name = "temp") {
        name = toIdentifier(name).replace(/^_+/, "").replace(/\d+$/g, "");
        let uid2;
        let i = 1;
        do {
          uid2 = `_${name}`;
          if (i > 1) uid2 += i;
          i++;
        } while (this.hasLabel(uid2) || this.hasBinding(uid2) || this.hasGlobal(uid2) || this.hasReference(uid2));
        const program = this.getProgramParent();
        program.references[uid2] = true;
        program.uids[uid2] = true;
        return uid2;
      }
      generateUidBasedOnNode(node, defaultName) {
        const parts = [];
        gatherNodeParts(node, parts);
        let id = parts.join("$");
        id = id.replace(/^_/, "") || defaultName || "ref";
        return this.generateUid(id.slice(0, 20));
      }
      generateUidIdentifierBasedOnNode(node, defaultName) {
        return identifier4(this.generateUidBasedOnNode(node, defaultName));
      }
      isStatic(node) {
        if (isThisExpression(node) || isSuper(node) || isTopicReference(node)) {
          return true;
        }
        if (isIdentifier(node)) {
          const binding = this.getBinding(node.name);
          if (binding) {
            return binding.constant;
          } else {
            return this.hasBinding(node.name);
          }
        }
        return false;
      }
      maybeGenerateMemoised(node, dontPush) {
        if (this.isStatic(node)) {
          return null;
        } else {
          const id = this.generateUidIdentifierBasedOnNode(node);
          if (!dontPush) {
            this.push({
              id
            });
            return cloneNode2(id);
          }
          return id;
        }
      }
      checkBlockScopedCollisions(local, kind, name, id) {
        if (kind === "param") return;
        if (local.kind === "local") return;
        const duplicate = kind === "let" || local.kind === "let" || local.kind === "const" || local.kind === "module" || local.kind === "param" && kind === "const";
        if (duplicate) {
          throw this.path.hub.buildError(id, `Duplicate declaration "${name}"`, TypeError);
        }
      }
      rename(oldName, newName) {
        const binding = this.getBinding(oldName);
        if (binding) {
          newName || (newName = this.generateUidIdentifier(oldName).name);
          const renamer = new _renamer.default(binding, oldName, newName);
          {
            renamer.rename(arguments[2]);
          }
        }
      }
      dump() {
        const sep = "-".repeat(60);
        console.log(sep);
        let scope = this;
        do {
          console.log("#", scope.block.type);
          for (const name of Object.keys(scope.bindings)) {
            const binding = scope.bindings[name];
            console.log(" -", name, {
              constant: binding.constant,
              references: binding.references,
              violations: binding.constantViolations.length,
              kind: binding.kind
            });
          }
        } while (scope = scope.parent);
        console.log(sep);
      }
      hasLabel(name) {
        return !!this.getLabel(name);
      }
      getLabel(name) {
        return this.labels.get(name);
      }
      registerLabel(path) {
        this.labels.set(path.node.label.name, path);
      }
      registerDeclaration(path) {
        if (path.isLabeledStatement()) {
          this.registerLabel(path);
        } else if (path.isFunctionDeclaration()) {
          this.registerBinding("hoisted", path.get("id"), path);
        } else if (path.isVariableDeclaration()) {
          const declarations = path.get("declarations");
          const {
            kind
          } = path.node;
          for (const declar of declarations) {
            this.registerBinding(kind === "using" || kind === "await using" ? "const" : kind, declar);
          }
        } else if (path.isClassDeclaration()) {
          if (path.node.declare) return;
          this.registerBinding("let", path);
        } else if (path.isImportDeclaration()) {
          const isTypeDeclaration = path.node.importKind === "type" || path.node.importKind === "typeof";
          const specifiers = path.get("specifiers");
          for (const specifier of specifiers) {
            const isTypeSpecifier = isTypeDeclaration || specifier.isImportSpecifier() && (specifier.node.importKind === "type" || specifier.node.importKind === "typeof");
            this.registerBinding(isTypeSpecifier ? "unknown" : "module", specifier);
          }
        } else if (path.isExportDeclaration()) {
          const declar = path.get("declaration");
          if (declar.isClassDeclaration() || declar.isFunctionDeclaration() || declar.isVariableDeclaration()) {
            this.registerDeclaration(declar);
          }
        } else {
          this.registerBinding("unknown", path);
        }
      }
      buildUndefinedNode() {
        return buildUndefinedNode();
      }
      registerConstantViolation(path) {
        const ids = path.getAssignmentIdentifiers();
        for (const name of Object.keys(ids)) {
          var _this$getBinding;
          (_this$getBinding = this.getBinding(name)) == null || _this$getBinding.reassign(path);
        }
      }
      registerBinding(kind, path, bindingPath = path) {
        if (!kind) throw new ReferenceError("no `kind`");
        if (path.isVariableDeclaration()) {
          const declarators = path.get("declarations");
          for (const declar of declarators) {
            this.registerBinding(kind, declar);
          }
          return;
        }
        const parent = this.getProgramParent();
        const ids = path.getOuterBindingIdentifiers(true);
        for (const name of Object.keys(ids)) {
          parent.references[name] = true;
          for (const id of ids[name]) {
            const local = this.getOwnBinding(name);
            if (local) {
              if (local.identifier === id) continue;
              this.checkBlockScopedCollisions(local, kind, name, id);
            }
            if (local) {
              local.reassign(bindingPath);
            } else {
              this.bindings[name] = new _binding.default({
                identifier: id,
                scope: this,
                path: bindingPath,
                kind
              });
            }
          }
        }
      }
      addGlobal(node) {
        this.globals[node.name] = node;
      }
      hasUid(name) {
        let scope = this;
        do {
          if (scope.uids[name]) return true;
        } while (scope = scope.parent);
        return false;
      }
      hasGlobal(name) {
        let scope = this;
        do {
          if (scope.globals[name]) return true;
        } while (scope = scope.parent);
        return false;
      }
      hasReference(name) {
        return !!this.getProgramParent().references[name];
      }
      isPure(node, constantsOnly) {
        if (isIdentifier(node)) {
          const binding = this.getBinding(node.name);
          if (!binding) return false;
          if (constantsOnly) return binding.constant;
          return true;
        } else if (isThisExpression(node) || isMetaProperty(node) || isTopicReference(node) || isPrivateName(node)) {
          return true;
        } else if (isClass(node)) {
          var _node$decorators;
          if (node.superClass && !this.isPure(node.superClass, constantsOnly)) {
            return false;
          }
          if (((_node$decorators = node.decorators) == null ? void 0 : _node$decorators.length) > 0) {
            return false;
          }
          return this.isPure(node.body, constantsOnly);
        } else if (isClassBody(node)) {
          for (const method of node.body) {
            if (!this.isPure(method, constantsOnly)) return false;
          }
          return true;
        } else if (isBinary(node)) {
          return this.isPure(node.left, constantsOnly) && this.isPure(node.right, constantsOnly);
        } else if (isArrayExpression(node) || isTupleExpression(node)) {
          for (const elem of node.elements) {
            if (elem !== null && !this.isPure(elem, constantsOnly)) return false;
          }
          return true;
        } else if (isObjectExpression(node) || isRecordExpression(node)) {
          for (const prop of node.properties) {
            if (!this.isPure(prop, constantsOnly)) return false;
          }
          return true;
        } else if (isMethod(node)) {
          var _node$decorators2;
          if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
          if (((_node$decorators2 = node.decorators) == null ? void 0 : _node$decorators2.length) > 0) {
            return false;
          }
          return true;
        } else if (isProperty(node)) {
          var _node$decorators3;
          if (node.computed && !this.isPure(node.key, constantsOnly)) return false;
          if (((_node$decorators3 = node.decorators) == null ? void 0 : _node$decorators3.length) > 0) {
            return false;
          }
          if (isObjectProperty(node) || node.static) {
            if (node.value !== null && !this.isPure(node.value, constantsOnly)) {
              return false;
            }
          }
          return true;
        } else if (isUnaryExpression(node)) {
          return this.isPure(node.argument, constantsOnly);
        } else if (isTemplateLiteral(node)) {
          for (const expression of node.expressions) {
            if (!this.isPure(expression, constantsOnly)) return false;
          }
          return true;
        } else if (isTaggedTemplateExpression(node)) {
          return matchesPattern(node.tag, "String.raw") && !this.hasBinding("String", {
            noGlobals: true
          }) && this.isPure(node.quasi, constantsOnly);
        } else if (isMemberExpression2(node)) {
          return !node.computed && isIdentifier(node.object) && node.object.name === "Symbol" && isIdentifier(node.property) && node.property.name !== "for" && !this.hasBinding("Symbol", {
            noGlobals: true
          });
        } else if (isCallExpression(node)) {
          return matchesPattern(node.callee, "Symbol.for") && !this.hasBinding("Symbol", {
            noGlobals: true
          }) && node.arguments.length === 1 && t6.isStringLiteral(node.arguments[0]);
        } else {
          return isPureish(node);
        }
      }
      setData(key2, val) {
        return this.data[key2] = val;
      }
      getData(key2) {
        let scope = this;
        do {
          const data = scope.data[key2];
          if (data != null) return data;
        } while (scope = scope.parent);
      }
      removeData(key2) {
        let scope = this;
        do {
          const data = scope.data[key2];
          if (data != null) scope.data[key2] = null;
        } while (scope = scope.parent);
      }
      init() {
        if (!this.inited) {
          this.inited = true;
          this.crawl();
        }
      }
      crawl() {
        const path = this.path;
        this.references = /* @__PURE__ */ Object.create(null);
        this.bindings = /* @__PURE__ */ Object.create(null);
        this.globals = /* @__PURE__ */ Object.create(null);
        this.uids = /* @__PURE__ */ Object.create(null);
        this.data = /* @__PURE__ */ Object.create(null);
        let scope = this;
        do {
          if (scope.crawling) return;
          if (scope.path.isProgram()) {
            break;
          }
        } while (scope = scope.parent);
        const programParent = scope;
        const state = {
          references: [],
          constantViolations: [],
          assignments: []
        };
        this.crawling = true;
        if (path.type !== "Program" && (0, _visitors.isExplodedVisitor)(collectorVisitor)) {
          for (const visit4 of collectorVisitor.enter) {
            visit4.call(state, path, state);
          }
          const typeVisitors = collectorVisitor[path.type];
          if (typeVisitors) {
            for (const visit4 of typeVisitors.enter) {
              visit4.call(state, path, state);
            }
          }
        }
        path.traverse(collectorVisitor, state);
        this.crawling = false;
        for (const path2 of state.assignments) {
          const ids = path2.getAssignmentIdentifiers();
          for (const name of Object.keys(ids)) {
            if (path2.scope.getBinding(name)) continue;
            programParent.addGlobal(ids[name]);
          }
          path2.scope.registerConstantViolation(path2);
        }
        for (const ref of state.references) {
          const binding = ref.scope.getBinding(ref.node.name);
          if (binding) {
            binding.reference(ref);
          } else {
            programParent.addGlobal(ref.node);
          }
        }
        for (const path2 of state.constantViolations) {
          path2.scope.registerConstantViolation(path2);
        }
      }
      push(opts) {
        let path = this.path;
        if (path.isPattern()) {
          path = this.getPatternParent().path;
        } else if (!path.isBlockStatement() && !path.isProgram()) {
          path = this.getBlockParent().path;
        }
        if (path.isSwitchStatement()) {
          path = (this.getFunctionParent() || this.getProgramParent()).path;
        }
        const {
          init,
          unique,
          kind = "var",
          id
        } = opts;
        if (!init && !unique && (kind === "var" || kind === "let") && path.isFunction() && !path.node.name && isCallExpression(path.parent, {
          callee: path.node
        }) && path.parent.arguments.length <= path.node.params.length && isIdentifier(id)) {
          path.pushContainer("params", id);
          path.scope.registerBinding("param", path.get("params")[path.node.params.length - 1]);
          return;
        }
        if (path.isLoop() || path.isCatchClause() || path.isFunction()) {
          path.ensureBlock();
          path = path.get("body");
        }
        const blockHoist = opts._blockHoist == null ? 2 : opts._blockHoist;
        const dataKey = `declaration:${kind}:${blockHoist}`;
        let declarPath = !unique && path.getData(dataKey);
        if (!declarPath) {
          const declar = variableDeclaration4(kind, []);
          declar._blockHoist = blockHoist;
          [declarPath] = path.unshiftContainer("body", [declar]);
          if (!unique) path.setData(dataKey, declarPath);
        }
        const declarator = variableDeclarator4(id, init);
        const len = declarPath.node.declarations.push(declarator);
        path.scope.registerBinding(kind, declarPath.get("declarations")[len - 1]);
      }
      getProgramParent() {
        let scope = this;
        do {
          if (scope.path.isProgram()) {
            return scope;
          }
        } while (scope = scope.parent);
        throw new Error("Couldn't find a Program");
      }
      getFunctionParent() {
        let scope = this;
        do {
          if (scope.path.isFunctionParent()) {
            return scope;
          }
        } while (scope = scope.parent);
        return null;
      }
      getBlockParent() {
        let scope = this;
        do {
          if (scope.path.isBlockParent()) {
            return scope;
          }
        } while (scope = scope.parent);
        throw new Error("We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...");
      }
      getPatternParent() {
        let scope = this;
        do {
          if (!scope.path.isPattern()) {
            return scope.getBlockParent();
          }
        } while (scope = scope.parent.parent);
        throw new Error("We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...");
      }
      getAllBindings() {
        const ids = /* @__PURE__ */ Object.create(null);
        let scope = this;
        do {
          for (const key2 of Object.keys(scope.bindings)) {
            if (key2 in ids === false) {
              ids[key2] = scope.bindings[key2];
            }
          }
          scope = scope.parent;
        } while (scope);
        return ids;
      }
      bindingIdentifierEquals(name, node) {
        return this.getBindingIdentifier(name) === node;
      }
      getBinding(name) {
        let scope = this;
        let previousPath;
        do {
          const binding = scope.getOwnBinding(name);
          if (binding) {
            var _previousPath;
            if ((_previousPath = previousPath) != null && _previousPath.isPattern() && binding.kind !== "param" && binding.kind !== "local") {
            } else {
              return binding;
            }
          } else if (!binding && name === "arguments" && scope.path.isFunction() && !scope.path.isArrowFunctionExpression()) {
            break;
          }
          previousPath = scope.path;
        } while (scope = scope.parent);
      }
      getOwnBinding(name) {
        return this.bindings[name];
      }
      getBindingIdentifier(name) {
        var _this$getBinding2;
        return (_this$getBinding2 = this.getBinding(name)) == null ? void 0 : _this$getBinding2.identifier;
      }
      getOwnBindingIdentifier(name) {
        const binding = this.bindings[name];
        return binding == null ? void 0 : binding.identifier;
      }
      hasOwnBinding(name) {
        return !!this.getOwnBinding(name);
      }
      hasBinding(name, opts) {
        if (!name) return false;
        let scope = this;
        do {
          if (scope.hasOwnBinding(name)) {
            return true;
          }
        } while (scope = scope.parent);
        let noGlobals;
        let noUids;
        if (typeof opts === "object") {
          noGlobals = opts.noGlobals;
          noUids = opts.noUids;
        } else if (typeof opts === "boolean") {
          noGlobals = opts;
        }
        if (!noUids && this.hasUid(name)) return true;
        if (!noGlobals && _Scope.globals.includes(name)) return true;
        if (!noGlobals && _Scope.contextVariables.includes(name)) return true;
        return false;
      }
      parentHasBinding(name, opts) {
        var _this$parent;
        return (_this$parent = this.parent) == null ? void 0 : _this$parent.hasBinding(name, opts);
      }
      moveBindingTo(name, scope) {
        const info = this.getBinding(name);
        if (info) {
          info.scope.removeOwnBinding(name);
          info.scope = scope;
          scope.bindings[name] = info;
        }
      }
      removeOwnBinding(name) {
        delete this.bindings[name];
      }
      removeBinding(name) {
        var _this$getBinding3;
        (_this$getBinding3 = this.getBinding(name)) == null || _this$getBinding3.scope.removeOwnBinding(name);
        let scope = this;
        do {
          if (scope.uids[name]) {
            scope.uids[name] = false;
          }
        } while (scope = scope.parent);
      }
      hoistVariables(emit2 = (id) => this.push({
        id
      })) {
        this.crawl();
        const seen = /* @__PURE__ */ new Set();
        for (const name of Object.keys(this.bindings)) {
          const binding = this.bindings[name];
          if (!binding) continue;
          const {
            path
          } = binding;
          if (!path.isVariableDeclarator()) continue;
          const {
            parent,
            parentPath
          } = path;
          if (parent.kind !== "var" || seen.has(parent)) continue;
          seen.add(path.parent);
          let firstId;
          const init = [];
          for (const decl of parent.declarations) {
            var _firstId;
            (_firstId = firstId) != null ? _firstId : firstId = decl.id;
            if (decl.init) {
              init.push(assignmentExpression2("=", decl.id, decl.init));
            }
            const ids = Object.keys(getBindingIdentifiers(decl, false, true, true));
            for (const name2 of ids) {
              emit2(identifier4(name2), decl.init != null);
            }
          }
          if (parentPath.parentPath.isFor({
            left: parent
          })) {
            parentPath.replaceWith(firstId);
          } else if (init.length === 0) {
            parentPath.remove();
          } else {
            const expr = init.length === 1 ? init[0] : sequenceExpression2(init);
            if (parentPath.parentPath.isForStatement({
              init: parent
            })) {
              parentPath.replaceWith(expr);
            } else {
              parentPath.replaceWith(expressionStatement2(expr));
            }
          }
        }
      }
    };
    exports2.default = Scope;
    Scope.globals = Object.keys(_globals4.builtin);
    Scope.contextVariables = ["arguments", "undefined", "Infinity", "NaN"];
    {
      Scope.prototype._renameFromMap = function _renameFromMap(map2, oldName, newName, value) {
        if (map2[oldName]) {
          map2[newName] = value;
          map2[oldName] = null;
        }
      };
      Scope.prototype.traverse = function(node, opts, state) {
        (0, _index.default)(node, opts, this, state, this.path);
      };
      Scope.prototype._generateUid = function _generateUid(name, i) {
        let id = name;
        if (i > 1) id += i;
        return `_${id}`;
      };
      Scope.prototype.toArray = function toArray(node, i, arrayLikeIsIterable) {
        if (isIdentifier(node)) {
          const binding = this.getBinding(node.name);
          if (binding != null && binding.constant && binding.path.isGenericType("Array")) {
            return node;
          }
        }
        if (isArrayExpression(node)) {
          return node;
        }
        if (isIdentifier(node, {
          name: "arguments"
        })) {
          return callExpression4(memberExpression2(memberExpression2(memberExpression2(identifier4("Array"), identifier4("prototype")), identifier4("slice")), identifier4("call")), [node]);
        }
        let helperName;
        const args = [node];
        if (i === true) {
          helperName = "toConsumableArray";
        } else if (typeof i === "number") {
          args.push(numericLiteral2(i));
          helperName = "slicedToArray";
        } else {
          helperName = "toArray";
        }
        if (arrayLikeIsIterable) {
          args.unshift(this.path.hub.addHelper(helperName));
          helperName = "maybeArrayLike";
        }
        return callExpression4(this.path.hub.addHelper(helperName), args);
      };
      Scope.prototype.getAllBindingsOfKind = function getAllBindingsOfKind(...kinds) {
        const ids = /* @__PURE__ */ Object.create(null);
        for (const kind of kinds) {
          let scope = this;
          do {
            for (const name of Object.keys(scope.bindings)) {
              const binding = scope.bindings[name];
              if (binding.kind === kind) ids[name] = binding;
            }
            scope = scope.parent;
          } while (scope);
        }
        return ids;
      };
      Object.defineProperties(Scope.prototype, {
        parentBlock: {
          configurable: true,
          enumerable: true,
          get() {
            return this.path.parent;
          }
        },
        hub: {
          configurable: true,
          enumerable: true,
          get() {
            return this.path.hub;
          }
        }
      });
    }
  }
});

// ../../node_modules/@jridgewell/set-array/dist/set-array.umd.js
var require_set_array_umd = __commonJS({
  "../../node_modules/@jridgewell/set-array/dist/set-array.umd.js"(exports2, module2) {
    "use strict";
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.setArray = {}));
    })(exports2, function(exports3) {
      "use strict";
      class SetArray {
        constructor() {
          this._indexes = { __proto__: null };
          this.array = [];
        }
      }
      function cast(set2) {
        return set2;
      }
      function get(setarr, key2) {
        return cast(setarr)._indexes[key2];
      }
      function put(setarr, key2) {
        const index = get(setarr, key2);
        if (index !== void 0)
          return index;
        const { array: array2, _indexes: indexes } = cast(setarr);
        const length = array2.push(key2);
        return indexes[key2] = length - 1;
      }
      function pop2(setarr) {
        const { array: array2, _indexes: indexes } = cast(setarr);
        if (array2.length === 0)
          return;
        const last = array2.pop();
        indexes[last] = void 0;
      }
      function remove(setarr, key2) {
        const index = get(setarr, key2);
        if (index === void 0)
          return;
        const { array: array2, _indexes: indexes } = cast(setarr);
        for (let i = index + 1; i < array2.length; i++) {
          const k = array2[i];
          array2[i - 1] = k;
          indexes[k]--;
        }
        indexes[key2] = void 0;
        array2.pop();
      }
      exports3.SetArray = SetArray;
      exports3.get = get;
      exports3.pop = pop2;
      exports3.put = put;
      exports3.remove = remove;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// ../../node_modules/@jridgewell/sourcemap-codec/dist/sourcemap-codec.umd.js
var require_sourcemap_codec_umd = __commonJS({
  "../../node_modules/@jridgewell/sourcemap-codec/dist/sourcemap-codec.umd.js"(exports2, module2) {
    "use strict";
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.sourcemapCodec = {}));
    })(exports2, function(exports3) {
      "use strict";
      const comma = ",".charCodeAt(0);
      const semicolon = ";".charCodeAt(0);
      const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      const intToChar = new Uint8Array(64);
      const charToInt = new Uint8Array(128);
      for (let i = 0; i < chars.length; i++) {
        const c2 = chars.charCodeAt(i);
        intToChar[i] = c2;
        charToInt[c2] = i;
      }
      const td = typeof TextDecoder !== "undefined" ? /* @__PURE__ */ new TextDecoder() : typeof Buffer !== "undefined" ? {
        decode(buf) {
          const out = Buffer.from(buf.buffer, buf.byteOffset, buf.byteLength);
          return out.toString();
        }
      } : {
        decode(buf) {
          let out = "";
          for (let i = 0; i < buf.length; i++) {
            out += String.fromCharCode(buf[i]);
          }
          return out;
        }
      };
      function decode3(mappings) {
        const state = new Int32Array(5);
        const decoded = [];
        let index = 0;
        do {
          const semi = indexOf(mappings, index);
          const line2 = [];
          let sorted = true;
          let lastCol = 0;
          state[0] = 0;
          for (let i = index; i < semi; i++) {
            let seg;
            i = decodeInteger(mappings, i, state, 0);
            const col = state[0];
            if (col < lastCol)
              sorted = false;
            lastCol = col;
            if (hasMoreVlq(mappings, i, semi)) {
              i = decodeInteger(mappings, i, state, 1);
              i = decodeInteger(mappings, i, state, 2);
              i = decodeInteger(mappings, i, state, 3);
              if (hasMoreVlq(mappings, i, semi)) {
                i = decodeInteger(mappings, i, state, 4);
                seg = [col, state[1], state[2], state[3], state[4]];
              } else {
                seg = [col, state[1], state[2], state[3]];
              }
            } else {
              seg = [col];
            }
            line2.push(seg);
          }
          if (!sorted)
            sort(line2);
          decoded.push(line2);
          index = semi + 1;
        } while (index <= mappings.length);
        return decoded;
      }
      function indexOf(mappings, index) {
        const idx = mappings.indexOf(";", index);
        return idx === -1 ? mappings.length : idx;
      }
      function decodeInteger(mappings, pos2, state, j) {
        let value = 0;
        let shift = 0;
        let integer2 = 0;
        do {
          const c2 = mappings.charCodeAt(pos2++);
          integer2 = charToInt[c2];
          value |= (integer2 & 31) << shift;
          shift += 5;
        } while (integer2 & 32);
        const shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
          value = -2147483648 | -value;
        }
        state[j] += value;
        return pos2;
      }
      function hasMoreVlq(mappings, i, length) {
        if (i >= length)
          return false;
        return mappings.charCodeAt(i) !== comma;
      }
      function sort(line2) {
        line2.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[0] - b[0];
      }
      function encode3(decoded) {
        const state = new Int32Array(5);
        const bufLength = 1024 * 16;
        const subLength = bufLength - 36;
        const buf = new Uint8Array(bufLength);
        const sub = buf.subarray(0, subLength);
        let pos2 = 0;
        let out = "";
        for (let i = 0; i < decoded.length; i++) {
          const line2 = decoded[i];
          if (i > 0) {
            if (pos2 === bufLength) {
              out += td.decode(buf);
              pos2 = 0;
            }
            buf[pos2++] = semicolon;
          }
          if (line2.length === 0)
            continue;
          state[0] = 0;
          for (let j = 0; j < line2.length; j++) {
            const segment = line2[j];
            if (pos2 > subLength) {
              out += td.decode(sub);
              buf.copyWithin(0, subLength, pos2);
              pos2 -= subLength;
            }
            if (j > 0)
              buf[pos2++] = comma;
            pos2 = encodeInteger(buf, pos2, state, segment, 0);
            if (segment.length === 1)
              continue;
            pos2 = encodeInteger(buf, pos2, state, segment, 1);
            pos2 = encodeInteger(buf, pos2, state, segment, 2);
            pos2 = encodeInteger(buf, pos2, state, segment, 3);
            if (segment.length === 4)
              continue;
            pos2 = encodeInteger(buf, pos2, state, segment, 4);
          }
        }
        return out + td.decode(buf.subarray(0, pos2));
      }
      function encodeInteger(buf, pos2, state, segment, j) {
        const next = segment[j];
        let num = next - state[j];
        state[j] = next;
        num = num < 0 ? -num << 1 | 1 : num << 1;
        do {
          let clamped = num & 31;
          num >>>= 5;
          if (num > 0)
            clamped |= 32;
          buf[pos2++] = intToChar[clamped];
        } while (num > 0);
        return pos2;
      }
      exports3.decode = decode3;
      exports3.encode = encode3;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// ../../node_modules/@jridgewell/resolve-uri/dist/resolve-uri.umd.js
var require_resolve_uri_umd = __commonJS({
  "../../node_modules/@jridgewell/resolve-uri/dist/resolve-uri.umd.js"(exports2, module2) {
    "use strict";
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.resolveURI = factory());
    })(exports2, function() {
      "use strict";
      const schemeRegex = /^[\w+.-]+:\/\//;
      const urlRegex = /^([\w+.-]+:)\/\/([^@/#?]*@)?([^:/#?]*)(:\d+)?(\/[^#?]*)?(\?[^#]*)?(#.*)?/;
      const fileRegex = /^file:(?:\/\/((?![a-z]:)[^/#?]*)?)?(\/?[^#?]*)(\?[^#]*)?(#.*)?/i;
      var UrlType;
      (function(UrlType2) {
        UrlType2[UrlType2["Empty"] = 1] = "Empty";
        UrlType2[UrlType2["Hash"] = 2] = "Hash";
        UrlType2[UrlType2["Query"] = 3] = "Query";
        UrlType2[UrlType2["RelativePath"] = 4] = "RelativePath";
        UrlType2[UrlType2["AbsolutePath"] = 5] = "AbsolutePath";
        UrlType2[UrlType2["SchemeRelative"] = 6] = "SchemeRelative";
        UrlType2[UrlType2["Absolute"] = 7] = "Absolute";
      })(UrlType || (UrlType = {}));
      function isAbsoluteUrl(input) {
        return schemeRegex.test(input);
      }
      function isSchemeRelativeUrl(input) {
        return input.startsWith("//");
      }
      function isAbsolutePath(input) {
        return input.startsWith("/");
      }
      function isFileUrl(input) {
        return input.startsWith("file:");
      }
      function isRelative(input) {
        return /^[.?#]/.test(input);
      }
      function parseAbsoluteUrl(input) {
        const match = urlRegex.exec(input);
        return makeUrl(match[1], match[2] || "", match[3], match[4] || "", match[5] || "/", match[6] || "", match[7] || "");
      }
      function parseFileUrl(input) {
        const match = fileRegex.exec(input);
        const path = match[2];
        return makeUrl("file:", "", match[1] || "", "", isAbsolutePath(path) ? path : "/" + path, match[3] || "", match[4] || "");
      }
      function makeUrl(scheme, user, host, port, path, query, hash2) {
        return {
          scheme,
          user,
          host,
          port,
          path,
          query,
          hash: hash2,
          type: UrlType.Absolute
        };
      }
      function parseUrl(input) {
        if (isSchemeRelativeUrl(input)) {
          const url3 = parseAbsoluteUrl("http:" + input);
          url3.scheme = "";
          url3.type = UrlType.SchemeRelative;
          return url3;
        }
        if (isAbsolutePath(input)) {
          const url3 = parseAbsoluteUrl("http://foo.com" + input);
          url3.scheme = "";
          url3.host = "";
          url3.type = UrlType.AbsolutePath;
          return url3;
        }
        if (isFileUrl(input))
          return parseFileUrl(input);
        if (isAbsoluteUrl(input))
          return parseAbsoluteUrl(input);
        const url2 = parseAbsoluteUrl("http://foo.com/" + input);
        url2.scheme = "";
        url2.host = "";
        url2.type = input ? input.startsWith("?") ? UrlType.Query : input.startsWith("#") ? UrlType.Hash : UrlType.RelativePath : UrlType.Empty;
        return url2;
      }
      function stripPathFilename(path) {
        if (path.endsWith("/.."))
          return path;
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      function mergePaths(url2, base) {
        normalizePath(base, base.type);
        if (url2.path === "/") {
          url2.path = base.path;
        } else {
          url2.path = stripPathFilename(base.path) + url2.path;
        }
      }
      function normalizePath(url2, type) {
        const rel = type <= UrlType.RelativePath;
        const pieces = url2.path.split("/");
        let pointer = 1;
        let positive = 0;
        let addTrailingSlash = false;
        for (let i = 1; i < pieces.length; i++) {
          const piece = pieces[i];
          if (!piece) {
            addTrailingSlash = true;
            continue;
          }
          addTrailingSlash = false;
          if (piece === ".")
            continue;
          if (piece === "..") {
            if (positive) {
              addTrailingSlash = true;
              positive--;
              pointer--;
            } else if (rel) {
              pieces[pointer++] = piece;
            }
            continue;
          }
          pieces[pointer++] = piece;
          positive++;
        }
        let path = "";
        for (let i = 1; i < pointer; i++) {
          path += "/" + pieces[i];
        }
        if (!path || addTrailingSlash && !path.endsWith("/..")) {
          path += "/";
        }
        url2.path = path;
      }
      function resolve(input, base) {
        if (!input && !base)
          return "";
        const url2 = parseUrl(input);
        let inputType = url2.type;
        if (base && inputType !== UrlType.Absolute) {
          const baseUrl = parseUrl(base);
          const baseType = baseUrl.type;
          switch (inputType) {
            case UrlType.Empty:
              url2.hash = baseUrl.hash;
            // fall through
            case UrlType.Hash:
              url2.query = baseUrl.query;
            // fall through
            case UrlType.Query:
            case UrlType.RelativePath:
              mergePaths(url2, baseUrl);
            // fall through
            case UrlType.AbsolutePath:
              url2.user = baseUrl.user;
              url2.host = baseUrl.host;
              url2.port = baseUrl.port;
            // fall through
            case UrlType.SchemeRelative:
              url2.scheme = baseUrl.scheme;
          }
          if (baseType > inputType)
            inputType = baseType;
        }
        normalizePath(url2, inputType);
        const queryHash = url2.query + url2.hash;
        switch (inputType) {
          // This is impossible, because of the empty checks at the start of the function.
          // case UrlType.Empty:
          case UrlType.Hash:
          case UrlType.Query:
            return queryHash;
          case UrlType.RelativePath: {
            const path = url2.path.slice(1);
            if (!path)
              return queryHash || ".";
            if (isRelative(base || input) && !isRelative(path)) {
              return "./" + path + queryHash;
            }
            return path + queryHash;
          }
          case UrlType.AbsolutePath:
            return url2.path + queryHash;
          default:
            return url2.scheme + "//" + url2.user + url2.host + url2.port + url2.path + queryHash;
        }
      }
      return resolve;
    });
  }
});

// ../../node_modules/@jridgewell/trace-mapping/dist/trace-mapping.umd.js
var require_trace_mapping_umd = __commonJS({
  "../../node_modules/@jridgewell/trace-mapping/dist/trace-mapping.umd.js"(exports2, module2) {
    "use strict";
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2, require_sourcemap_codec_umd(), require_resolve_uri_umd()) : typeof define === "function" && define.amd ? define(["exports", "@jridgewell/sourcemap-codec", "@jridgewell/resolve-uri"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.traceMapping = {}, global2.sourcemapCodec, global2.resolveURI));
    })(exports2, function(exports3, sourcemapCodec, resolveUri) {
      "use strict";
      function resolve(input, base) {
        if (base && !base.endsWith("/"))
          base += "/";
        return resolveUri(input, base);
      }
      function stripFilename(path) {
        if (!path)
          return "";
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      const COLUMN = 0;
      const SOURCES_INDEX = 1;
      const SOURCE_LINE = 2;
      const SOURCE_COLUMN = 3;
      const NAMES_INDEX = 4;
      const REV_GENERATED_LINE = 1;
      const REV_GENERATED_COLUMN = 2;
      function maybeSort(mappings, owned) {
        const unsortedIndex = nextUnsortedSegmentLine(mappings, 0);
        if (unsortedIndex === mappings.length)
          return mappings;
        if (!owned)
          mappings = mappings.slice();
        for (let i = unsortedIndex; i < mappings.length; i = nextUnsortedSegmentLine(mappings, i + 1)) {
          mappings[i] = sortSegments(mappings[i], owned);
        }
        return mappings;
      }
      function nextUnsortedSegmentLine(mappings, start) {
        for (let i = start; i < mappings.length; i++) {
          if (!isSorted(mappings[i]))
            return i;
        }
        return mappings.length;
      }
      function isSorted(line2) {
        for (let j = 1; j < line2.length; j++) {
          if (line2[j][COLUMN] < line2[j - 1][COLUMN]) {
            return false;
          }
        }
        return true;
      }
      function sortSegments(line2, owned) {
        if (!owned)
          line2 = line2.slice();
        return line2.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[COLUMN] - b[COLUMN];
      }
      let found = false;
      function binarySearch(haystack, needle, low, high) {
        while (low <= high) {
          const mid = low + (high - low >> 1);
          const cmp = haystack[mid][COLUMN] - needle;
          if (cmp === 0) {
            found = true;
            return mid;
          }
          if (cmp < 0) {
            low = mid + 1;
          } else {
            high = mid - 1;
          }
        }
        found = false;
        return low - 1;
      }
      function upperBound(haystack, needle, index) {
        for (let i = index + 1; i < haystack.length; index = i++) {
          if (haystack[i][COLUMN] !== needle)
            break;
        }
        return index;
      }
      function lowerBound(haystack, needle, index) {
        for (let i = index - 1; i >= 0; index = i--) {
          if (haystack[i][COLUMN] !== needle)
            break;
        }
        return index;
      }
      function memoizedState() {
        return {
          lastKey: -1,
          lastNeedle: -1,
          lastIndex: -1
        };
      }
      function memoizedBinarySearch(haystack, needle, state, key2) {
        const { lastKey, lastNeedle, lastIndex } = state;
        let low = 0;
        let high = haystack.length - 1;
        if (key2 === lastKey) {
          if (needle === lastNeedle) {
            found = lastIndex !== -1 && haystack[lastIndex][COLUMN] === needle;
            return lastIndex;
          }
          if (needle >= lastNeedle) {
            low = lastIndex === -1 ? 0 : lastIndex;
          } else {
            high = lastIndex;
          }
        }
        state.lastKey = key2;
        state.lastNeedle = needle;
        return state.lastIndex = binarySearch(haystack, needle, low, high);
      }
      function buildBySources(decoded, memos) {
        const sources = memos.map(buildNullArray);
        for (let i = 0; i < decoded.length; i++) {
          const line2 = decoded[i];
          for (let j = 0; j < line2.length; j++) {
            const seg = line2[j];
            if (seg.length === 1)
              continue;
            const sourceIndex2 = seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            const originalSource = sources[sourceIndex2];
            const originalLine = originalSource[sourceLine] || (originalSource[sourceLine] = []);
            const memo = memos[sourceIndex2];
            let index = upperBound(originalLine, sourceColumn, memoizedBinarySearch(originalLine, sourceColumn, memo, sourceLine));
            memo.lastIndex = ++index;
            insert(originalLine, index, [sourceColumn, i, seg[COLUMN]]);
          }
        }
        return sources;
      }
      function insert(array2, index, value) {
        for (let i = array2.length; i > index; i--) {
          array2[i] = array2[i - 1];
        }
        array2[index] = value;
      }
      function buildNullArray() {
        return { __proto__: null };
      }
      const AnyMap = function(map2, mapUrl) {
        const parsed = parse6(map2);
        if (!("sections" in parsed)) {
          return new TraceMap(parsed, mapUrl);
        }
        const mappings = [];
        const sources = [];
        const sourcesContent = [];
        const names = [];
        const ignoreList = [];
        recurse(parsed, mapUrl, mappings, sources, sourcesContent, names, ignoreList, 0, 0, Infinity, Infinity);
        const joined = {
          version: 3,
          file: parsed.file,
          names,
          sources,
          sourcesContent,
          mappings,
          ignoreList
        };
        return presortedDecodedMap(joined);
      };
      function parse6(map2) {
        return typeof map2 === "string" ? JSON.parse(map2) : map2;
      }
      function recurse(input, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset, columnOffset, stopLine, stopColumn) {
        const { sections } = input;
        for (let i = 0; i < sections.length; i++) {
          const { map: map2, offset } = sections[i];
          let sl = stopLine;
          let sc = stopColumn;
          if (i + 1 < sections.length) {
            const nextOffset = sections[i + 1].offset;
            sl = Math.min(stopLine, lineOffset + nextOffset.line);
            if (sl === stopLine) {
              sc = Math.min(stopColumn, columnOffset + nextOffset.column);
            } else if (sl < stopLine) {
              sc = columnOffset + nextOffset.column;
            }
          }
          addSection(map2, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset + offset.line, columnOffset + offset.column, sl, sc);
        }
      }
      function addSection(input, mapUrl, mappings, sources, sourcesContent, names, ignoreList, lineOffset, columnOffset, stopLine, stopColumn) {
        const parsed = parse6(input);
        if ("sections" in parsed)
          return recurse(...arguments);
        const map2 = new TraceMap(parsed, mapUrl);
        const sourcesOffset = sources.length;
        const namesOffset = names.length;
        const decoded = decodedMappings(map2);
        const { resolvedSources, sourcesContent: contents, ignoreList: ignores } = map2;
        append(sources, resolvedSources);
        append(names, map2.names);
        if (contents)
          append(sourcesContent, contents);
        else
          for (let i = 0; i < resolvedSources.length; i++)
            sourcesContent.push(null);
        if (ignores)
          for (let i = 0; i < ignores.length; i++)
            ignoreList.push(ignores[i] + sourcesOffset);
        for (let i = 0; i < decoded.length; i++) {
          const lineI = lineOffset + i;
          if (lineI > stopLine)
            return;
          const out = getLine(mappings, lineI);
          const cOffset = i === 0 ? columnOffset : 0;
          const line2 = decoded[i];
          for (let j = 0; j < line2.length; j++) {
            const seg = line2[j];
            const column2 = cOffset + seg[COLUMN];
            if (lineI === stopLine && column2 >= stopColumn)
              return;
            if (seg.length === 1) {
              out.push([column2]);
              continue;
            }
            const sourcesIndex = sourcesOffset + seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            out.push(seg.length === 4 ? [column2, sourcesIndex, sourceLine, sourceColumn] : [column2, sourcesIndex, sourceLine, sourceColumn, namesOffset + seg[NAMES_INDEX]]);
          }
        }
      }
      function append(arr, other) {
        for (let i = 0; i < other.length; i++)
          arr.push(other[i]);
      }
      function getLine(arr, index) {
        for (let i = arr.length; i <= index; i++)
          arr[i] = [];
        return arr[index];
      }
      const LINE_GTR_ZERO = "`line` must be greater than 0 (lines start at line 1)";
      const COL_GTR_EQ_ZERO = "`column` must be greater than or equal to 0 (columns start at column 0)";
      const LEAST_UPPER_BOUND = -1;
      const GREATEST_LOWER_BOUND = 1;
      class TraceMap {
        constructor(map2, mapUrl) {
          const isString = typeof map2 === "string";
          if (!isString && map2._decodedMemo)
            return map2;
          const parsed = isString ? JSON.parse(map2) : map2;
          const { version: version2, file: file2, names, sourceRoot, sources, sourcesContent } = parsed;
          this.version = version2;
          this.file = file2;
          this.names = names || [];
          this.sourceRoot = sourceRoot;
          this.sources = sources;
          this.sourcesContent = sourcesContent;
          this.ignoreList = parsed.ignoreList || parsed.x_google_ignoreList || void 0;
          const from = resolve(sourceRoot || "", stripFilename(mapUrl));
          this.resolvedSources = sources.map((s) => resolve(s || "", from));
          const { mappings } = parsed;
          if (typeof mappings === "string") {
            this._encoded = mappings;
            this._decoded = void 0;
          } else {
            this._encoded = void 0;
            this._decoded = maybeSort(mappings, isString);
          }
          this._decodedMemo = memoizedState();
          this._bySources = void 0;
          this._bySourceMemos = void 0;
        }
      }
      function cast(map2) {
        return map2;
      }
      function encodedMappings(map2) {
        var _a;
        var _b;
        return (_a = (_b = cast(map2))._encoded) !== null && _a !== void 0 ? _a : _b._encoded = sourcemapCodec.encode(cast(map2)._decoded);
      }
      function decodedMappings(map2) {
        var _a;
        return (_a = cast(map2))._decoded || (_a._decoded = sourcemapCodec.decode(cast(map2)._encoded));
      }
      function traceSegment(map2, line2, column2) {
        const decoded = decodedMappings(map2);
        if (line2 >= decoded.length)
          return null;
        const segments = decoded[line2];
        const index = traceSegmentInternal(segments, cast(map2)._decodedMemo, line2, column2, GREATEST_LOWER_BOUND);
        return index === -1 ? null : segments[index];
      }
      function originalPositionFor(map2, needle) {
        let { line: line2, column: column2, bias } = needle;
        line2--;
        if (line2 < 0)
          throw new Error(LINE_GTR_ZERO);
        if (column2 < 0)
          throw new Error(COL_GTR_EQ_ZERO);
        const decoded = decodedMappings(map2);
        if (line2 >= decoded.length)
          return OMapping(null, null, null, null);
        const segments = decoded[line2];
        const index = traceSegmentInternal(segments, cast(map2)._decodedMemo, line2, column2, bias || GREATEST_LOWER_BOUND);
        if (index === -1)
          return OMapping(null, null, null, null);
        const segment = segments[index];
        if (segment.length === 1)
          return OMapping(null, null, null, null);
        const { names, resolvedSources } = map2;
        return OMapping(resolvedSources[segment[SOURCES_INDEX]], segment[SOURCE_LINE] + 1, segment[SOURCE_COLUMN], segment.length === 5 ? names[segment[NAMES_INDEX]] : null);
      }
      function generatedPositionFor(map2, needle) {
        const { source: source2, line: line2, column: column2, bias } = needle;
        return generatedPosition(map2, source2, line2, column2, bias || GREATEST_LOWER_BOUND, false);
      }
      function allGeneratedPositionsFor(map2, needle) {
        const { source: source2, line: line2, column: column2, bias } = needle;
        return generatedPosition(map2, source2, line2, column2, bias || LEAST_UPPER_BOUND, true);
      }
      function eachMapping(map2, cb) {
        const decoded = decodedMappings(map2);
        const { names, resolvedSources } = map2;
        for (let i = 0; i < decoded.length; i++) {
          const line2 = decoded[i];
          for (let j = 0; j < line2.length; j++) {
            const seg = line2[j];
            const generatedLine = i + 1;
            const generatedColumn = seg[0];
            let source2 = null;
            let originalLine = null;
            let originalColumn = null;
            let name = null;
            if (seg.length !== 1) {
              source2 = resolvedSources[seg[1]];
              originalLine = seg[2] + 1;
              originalColumn = seg[3];
            }
            if (seg.length === 5)
              name = names[seg[4]];
            cb({
              generatedLine,
              generatedColumn,
              source: source2,
              originalLine,
              originalColumn,
              name
            });
          }
        }
      }
      function sourceIndex(map2, source2) {
        const { sources, resolvedSources } = map2;
        let index = sources.indexOf(source2);
        if (index === -1)
          index = resolvedSources.indexOf(source2);
        return index;
      }
      function sourceContentFor(map2, source2) {
        const { sourcesContent } = map2;
        if (sourcesContent == null)
          return null;
        const index = sourceIndex(map2, source2);
        return index === -1 ? null : sourcesContent[index];
      }
      function isIgnored(map2, source2) {
        const { ignoreList } = map2;
        if (ignoreList == null)
          return false;
        const index = sourceIndex(map2, source2);
        return index === -1 ? false : ignoreList.includes(index);
      }
      function presortedDecodedMap(map2, mapUrl) {
        const tracer = new TraceMap(clone2(map2, []), mapUrl);
        cast(tracer)._decoded = map2.mappings;
        return tracer;
      }
      function decodedMap(map2) {
        return clone2(map2, decodedMappings(map2));
      }
      function encodedMap(map2) {
        return clone2(map2, encodedMappings(map2));
      }
      function clone2(map2, mappings) {
        return {
          version: map2.version,
          file: map2.file,
          names: map2.names,
          sourceRoot: map2.sourceRoot,
          sources: map2.sources,
          sourcesContent: map2.sourcesContent,
          mappings,
          ignoreList: map2.ignoreList || map2.x_google_ignoreList
        };
      }
      function OMapping(source2, line2, column2, name) {
        return { source: source2, line: line2, column: column2, name };
      }
      function GMapping(line2, column2) {
        return { line: line2, column: column2 };
      }
      function traceSegmentInternal(segments, memo, line2, column2, bias) {
        let index = memoizedBinarySearch(segments, column2, memo, line2);
        if (found) {
          index = (bias === LEAST_UPPER_BOUND ? upperBound : lowerBound)(segments, column2, index);
        } else if (bias === LEAST_UPPER_BOUND)
          index++;
        if (index === -1 || index === segments.length)
          return -1;
        return index;
      }
      function sliceGeneratedPositions(segments, memo, line2, column2, bias) {
        let min = traceSegmentInternal(segments, memo, line2, column2, GREATEST_LOWER_BOUND);
        if (!found && bias === LEAST_UPPER_BOUND)
          min++;
        if (min === -1 || min === segments.length)
          return [];
        const matchedColumn = found ? column2 : segments[min][COLUMN];
        if (!found)
          min = lowerBound(segments, matchedColumn, min);
        const max = upperBound(segments, matchedColumn, min);
        const result = [];
        for (; min <= max; min++) {
          const segment = segments[min];
          result.push(GMapping(segment[REV_GENERATED_LINE] + 1, segment[REV_GENERATED_COLUMN]));
        }
        return result;
      }
      function generatedPosition(map2, source2, line2, column2, bias, all) {
        var _a;
        line2--;
        if (line2 < 0)
          throw new Error(LINE_GTR_ZERO);
        if (column2 < 0)
          throw new Error(COL_GTR_EQ_ZERO);
        const { sources, resolvedSources } = map2;
        let sourceIndex2 = sources.indexOf(source2);
        if (sourceIndex2 === -1)
          sourceIndex2 = resolvedSources.indexOf(source2);
        if (sourceIndex2 === -1)
          return all ? [] : GMapping(null, null);
        const generated = (_a = cast(map2))._bySources || (_a._bySources = buildBySources(decodedMappings(map2), cast(map2)._bySourceMemos = sources.map(memoizedState)));
        const segments = generated[sourceIndex2][line2];
        if (segments == null)
          return all ? [] : GMapping(null, null);
        const memo = cast(map2)._bySourceMemos[sourceIndex2];
        if (all)
          return sliceGeneratedPositions(segments, memo, line2, column2, bias);
        const index = traceSegmentInternal(segments, memo, line2, column2, bias);
        if (index === -1)
          return GMapping(null, null);
        const segment = segments[index];
        return GMapping(segment[REV_GENERATED_LINE] + 1, segment[REV_GENERATED_COLUMN]);
      }
      exports3.AnyMap = AnyMap;
      exports3.GREATEST_LOWER_BOUND = GREATEST_LOWER_BOUND;
      exports3.LEAST_UPPER_BOUND = LEAST_UPPER_BOUND;
      exports3.TraceMap = TraceMap;
      exports3.allGeneratedPositionsFor = allGeneratedPositionsFor;
      exports3.decodedMap = decodedMap;
      exports3.decodedMappings = decodedMappings;
      exports3.eachMapping = eachMapping;
      exports3.encodedMap = encodedMap;
      exports3.encodedMappings = encodedMappings;
      exports3.generatedPositionFor = generatedPositionFor;
      exports3.isIgnored = isIgnored;
      exports3.originalPositionFor = originalPositionFor;
      exports3.presortedDecodedMap = presortedDecodedMap;
      exports3.sourceContentFor = sourceContentFor;
      exports3.traceSegment = traceSegment;
    });
  }
});

// ../../node_modules/@jridgewell/gen-mapping/dist/gen-mapping.umd.js
var require_gen_mapping_umd = __commonJS({
  "../../node_modules/@jridgewell/gen-mapping/dist/gen-mapping.umd.js"(exports2, module2) {
    "use strict";
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2, require_set_array_umd(), require_sourcemap_codec_umd(), require_trace_mapping_umd()) : typeof define === "function" && define.amd ? define(["exports", "@jridgewell/set-array", "@jridgewell/sourcemap-codec", "@jridgewell/trace-mapping"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.genMapping = {}, global2.setArray, global2.sourcemapCodec, global2.traceMapping));
    })(exports2, function(exports3, setArray, sourcemapCodec, traceMapping) {
      "use strict";
      const COLUMN = 0;
      const SOURCES_INDEX = 1;
      const SOURCE_LINE = 2;
      const SOURCE_COLUMN = 3;
      const NAMES_INDEX = 4;
      const NO_NAME = -1;
      class GenMapping {
        constructor({ file: file2, sourceRoot } = {}) {
          this._names = new setArray.SetArray();
          this._sources = new setArray.SetArray();
          this._sourcesContent = [];
          this._mappings = [];
          this.file = file2;
          this.sourceRoot = sourceRoot;
          this._ignoreList = new setArray.SetArray();
        }
      }
      function cast(map2) {
        return map2;
      }
      function addSegment(map2, genLine, genColumn, source2, sourceLine, sourceColumn, name, content) {
        return addSegmentInternal(false, map2, genLine, genColumn, source2, sourceLine, sourceColumn, name, content);
      }
      function addMapping(map2, mapping) {
        return addMappingInternal(false, map2, mapping);
      }
      const maybeAddSegment = (map2, genLine, genColumn, source2, sourceLine, sourceColumn, name, content) => {
        return addSegmentInternal(true, map2, genLine, genColumn, source2, sourceLine, sourceColumn, name, content);
      };
      const maybeAddMapping = (map2, mapping) => {
        return addMappingInternal(true, map2, mapping);
      };
      function setSourceContent(map2, source2, content) {
        const { _sources: sources, _sourcesContent: sourcesContent } = cast(map2);
        const index = setArray.put(sources, source2);
        sourcesContent[index] = content;
      }
      function setIgnore(map2, source2, ignore = true) {
        const { _sources: sources, _sourcesContent: sourcesContent, _ignoreList: ignoreList } = cast(map2);
        const index = setArray.put(sources, source2);
        if (index === sourcesContent.length)
          sourcesContent[index] = null;
        if (ignore)
          setArray.put(ignoreList, index);
        else
          setArray.remove(ignoreList, index);
      }
      function toDecodedMap(map2) {
        const { _mappings: mappings, _sources: sources, _sourcesContent: sourcesContent, _names: names, _ignoreList: ignoreList } = cast(map2);
        removeEmptyFinalLines(mappings);
        return {
          version: 3,
          file: map2.file || void 0,
          names: names.array,
          sourceRoot: map2.sourceRoot || void 0,
          sources: sources.array,
          sourcesContent,
          mappings,
          ignoreList: ignoreList.array
        };
      }
      function toEncodedMap(map2) {
        const decoded = toDecodedMap(map2);
        return Object.assign(Object.assign({}, decoded), { mappings: sourcemapCodec.encode(decoded.mappings) });
      }
      function fromMap(input) {
        const map2 = new traceMapping.TraceMap(input);
        const gen = new GenMapping({ file: map2.file, sourceRoot: map2.sourceRoot });
        putAll(cast(gen)._names, map2.names);
        putAll(cast(gen)._sources, map2.sources);
        cast(gen)._sourcesContent = map2.sourcesContent || map2.sources.map(() => null);
        cast(gen)._mappings = traceMapping.decodedMappings(map2);
        if (map2.ignoreList)
          putAll(cast(gen)._ignoreList, map2.ignoreList);
        return gen;
      }
      function allMappings(map2) {
        const out = [];
        const { _mappings: mappings, _sources: sources, _names: names } = cast(map2);
        for (let i = 0; i < mappings.length; i++) {
          const line2 = mappings[i];
          for (let j = 0; j < line2.length; j++) {
            const seg = line2[j];
            const generated = { line: i + 1, column: seg[COLUMN] };
            let source2 = void 0;
            let original = void 0;
            let name = void 0;
            if (seg.length !== 1) {
              source2 = sources.array[seg[SOURCES_INDEX]];
              original = { line: seg[SOURCE_LINE] + 1, column: seg[SOURCE_COLUMN] };
              if (seg.length === 5)
                name = names.array[seg[NAMES_INDEX]];
            }
            out.push({ generated, source: source2, original, name });
          }
        }
        return out;
      }
      function addSegmentInternal(skipable, map2, genLine, genColumn, source2, sourceLine, sourceColumn, name, content) {
        const { _mappings: mappings, _sources: sources, _sourcesContent: sourcesContent, _names: names } = cast(map2);
        const line2 = getLine(mappings, genLine);
        const index = getColumnIndex(line2, genColumn);
        if (!source2) {
          if (skipable && skipSourceless(line2, index))
            return;
          return insert(line2, index, [genColumn]);
        }
        const sourcesIndex = setArray.put(sources, source2);
        const namesIndex = name ? setArray.put(names, name) : NO_NAME;
        if (sourcesIndex === sourcesContent.length)
          sourcesContent[sourcesIndex] = content !== null && content !== void 0 ? content : null;
        if (skipable && skipSource(line2, index, sourcesIndex, sourceLine, sourceColumn, namesIndex)) {
          return;
        }
        return insert(line2, index, name ? [genColumn, sourcesIndex, sourceLine, sourceColumn, namesIndex] : [genColumn, sourcesIndex, sourceLine, sourceColumn]);
      }
      function getLine(mappings, index) {
        for (let i = mappings.length; i <= index; i++) {
          mappings[i] = [];
        }
        return mappings[index];
      }
      function getColumnIndex(line2, genColumn) {
        let index = line2.length;
        for (let i = index - 1; i >= 0; index = i--) {
          const current = line2[i];
          if (genColumn >= current[COLUMN])
            break;
        }
        return index;
      }
      function insert(array2, index, value) {
        for (let i = array2.length; i > index; i--) {
          array2[i] = array2[i - 1];
        }
        array2[index] = value;
      }
      function removeEmptyFinalLines(mappings) {
        const { length } = mappings;
        let len = length;
        for (let i = len - 1; i >= 0; len = i, i--) {
          if (mappings[i].length > 0)
            break;
        }
        if (len < length)
          mappings.length = len;
      }
      function putAll(setarr, array2) {
        for (let i = 0; i < array2.length; i++)
          setArray.put(setarr, array2[i]);
      }
      function skipSourceless(line2, index) {
        if (index === 0)
          return true;
        const prev = line2[index - 1];
        return prev.length === 1;
      }
      function skipSource(line2, index, sourcesIndex, sourceLine, sourceColumn, namesIndex) {
        if (index === 0)
          return false;
        const prev = line2[index - 1];
        if (prev.length === 1)
          return false;
        return sourcesIndex === prev[SOURCES_INDEX] && sourceLine === prev[SOURCE_LINE] && sourceColumn === prev[SOURCE_COLUMN] && namesIndex === (prev.length === 5 ? prev[NAMES_INDEX] : NO_NAME);
      }
      function addMappingInternal(skipable, map2, mapping) {
        const { generated, source: source2, original, name, content } = mapping;
        if (!source2) {
          return addSegmentInternal(skipable, map2, generated.line - 1, generated.column, null, null, null, null, null);
        }
        return addSegmentInternal(skipable, map2, generated.line - 1, generated.column, source2, original.line - 1, original.column, name, content);
      }
      exports3.GenMapping = GenMapping;
      exports3.addMapping = addMapping;
      exports3.addSegment = addSegment;
      exports3.allMappings = allMappings;
      exports3.fromMap = fromMap;
      exports3.maybeAddMapping = maybeAddMapping;
      exports3.maybeAddSegment = maybeAddSegment;
      exports3.setIgnore = setIgnore;
      exports3.setSourceContent = setSourceContent;
      exports3.toDecodedMap = toDecodedMap;
      exports3.toEncodedMap = toEncodedMap;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/source-map.js
var require_source_map = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/source-map.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _genMapping = require_gen_mapping_umd();
    var _traceMapping = require_trace_mapping_umd();
    var SourceMap = class {
      constructor(opts, code) {
        var _opts$sourceFileName;
        this._map = void 0;
        this._rawMappings = void 0;
        this._sourceFileName = void 0;
        this._lastGenLine = 0;
        this._lastSourceLine = 0;
        this._lastSourceColumn = 0;
        this._inputMap = void 0;
        const map2 = this._map = new _genMapping.GenMapping({
          sourceRoot: opts.sourceRoot
        });
        this._sourceFileName = (_opts$sourceFileName = opts.sourceFileName) == null ? void 0 : _opts$sourceFileName.replace(/\\/g, "/");
        this._rawMappings = void 0;
        if (opts.inputSourceMap) {
          this._inputMap = new _traceMapping.TraceMap(opts.inputSourceMap);
          const resolvedSources = this._inputMap.resolvedSources;
          if (resolvedSources.length) {
            for (let i = 0; i < resolvedSources.length; i++) {
              var _this$_inputMap$sourc;
              (0, _genMapping.setSourceContent)(map2, resolvedSources[i], (_this$_inputMap$sourc = this._inputMap.sourcesContent) == null ? void 0 : _this$_inputMap$sourc[i]);
            }
          }
        }
        if (typeof code === "string" && !opts.inputSourceMap) {
          (0, _genMapping.setSourceContent)(map2, this._sourceFileName, code);
        } else if (typeof code === "object") {
          for (const sourceFileName of Object.keys(code)) {
            (0, _genMapping.setSourceContent)(map2, sourceFileName.replace(/\\/g, "/"), code[sourceFileName]);
          }
        }
      }
      get() {
        return (0, _genMapping.toEncodedMap)(this._map);
      }
      getDecoded() {
        return (0, _genMapping.toDecodedMap)(this._map);
      }
      getRawMappings() {
        return this._rawMappings || (this._rawMappings = (0, _genMapping.allMappings)(this._map));
      }
      mark(generated, line2, column2, identifierName, identifierNamePos, filename) {
        var _originalMapping;
        this._rawMappings = void 0;
        let originalMapping;
        if (line2 != null) {
          if (this._inputMap) {
            originalMapping = (0, _traceMapping.originalPositionFor)(this._inputMap, {
              line: line2,
              column: column2
            });
            if (!originalMapping.name && identifierNamePos) {
              const originalIdentifierMapping = (0, _traceMapping.originalPositionFor)(this._inputMap, identifierNamePos);
              if (originalIdentifierMapping.name) {
                identifierName = originalIdentifierMapping.name;
              }
            }
          } else {
            originalMapping = {
              source: (filename == null ? void 0 : filename.replace(/\\/g, "/")) || this._sourceFileName,
              line: line2,
              column: column2
            };
          }
        }
        (0, _genMapping.maybeAddMapping)(this._map, {
          name: identifierName,
          generated,
          source: (_originalMapping = originalMapping) == null ? void 0 : _originalMapping.source,
          original: originalMapping
        });
      }
    };
    exports2.default = SourceMap;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/buffer.js
var require_buffer = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/buffer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var Buffer2 = class {
      constructor(map2, indentChar) {
        this._map = null;
        this._buf = "";
        this._str = "";
        this._appendCount = 0;
        this._last = 0;
        this._queue = [];
        this._queueCursor = 0;
        this._canMarkIdName = true;
        this._indentChar = "";
        this._fastIndentations = [];
        this._position = {
          line: 1,
          column: 0
        };
        this._sourcePosition = {
          identifierName: void 0,
          identifierNamePos: void 0,
          line: void 0,
          column: void 0,
          filename: void 0
        };
        this._map = map2;
        this._indentChar = indentChar;
        for (let i = 0; i < 64; i++) {
          this._fastIndentations.push(indentChar.repeat(i));
        }
        this._allocQueue();
      }
      _allocQueue() {
        const queue = this._queue;
        for (let i = 0; i < 16; i++) {
          queue.push({
            char: 0,
            repeat: 1,
            line: void 0,
            column: void 0,
            identifierName: void 0,
            identifierNamePos: void 0,
            filename: ""
          });
        }
      }
      _pushQueue(char, repeat, line2, column2, filename) {
        const cursor = this._queueCursor;
        if (cursor === this._queue.length) {
          this._allocQueue();
        }
        const item = this._queue[cursor];
        item.char = char;
        item.repeat = repeat;
        item.line = line2;
        item.column = column2;
        item.filename = filename;
        this._queueCursor++;
      }
      _popQueue() {
        if (this._queueCursor === 0) {
          throw new Error("Cannot pop from empty queue");
        }
        return this._queue[--this._queueCursor];
      }
      get() {
        this._flush();
        const map2 = this._map;
        const result = {
          code: (this._buf + this._str).trimRight(),
          decodedMap: map2 == null ? void 0 : map2.getDecoded(),
          get __mergedMap() {
            return this.map;
          },
          get map() {
            const resultMap = map2 ? map2.get() : null;
            result.map = resultMap;
            return resultMap;
          },
          set map(value) {
            Object.defineProperty(result, "map", {
              value,
              writable: true
            });
          },
          get rawMappings() {
            const mappings = map2 == null ? void 0 : map2.getRawMappings();
            result.rawMappings = mappings;
            return mappings;
          },
          set rawMappings(value) {
            Object.defineProperty(result, "rawMappings", {
              value,
              writable: true
            });
          }
        };
        return result;
      }
      append(str, maybeNewline) {
        this._flush();
        this._append(str, this._sourcePosition, maybeNewline);
      }
      appendChar(char) {
        this._flush();
        this._appendChar(char, 1, this._sourcePosition);
      }
      queue(char) {
        if (char === 10) {
          while (this._queueCursor !== 0) {
            const char2 = this._queue[this._queueCursor - 1].char;
            if (char2 !== 32 && char2 !== 9) {
              break;
            }
            this._queueCursor--;
          }
        }
        const sourcePosition = this._sourcePosition;
        this._pushQueue(char, 1, sourcePosition.line, sourcePosition.column, sourcePosition.filename);
      }
      queueIndentation(repeat) {
        if (repeat === 0) return;
        this._pushQueue(-1, repeat, void 0, void 0, void 0);
      }
      _flush() {
        const queueCursor = this._queueCursor;
        const queue = this._queue;
        for (let i = 0; i < queueCursor; i++) {
          const item = queue[i];
          this._appendChar(item.char, item.repeat, item);
        }
        this._queueCursor = 0;
      }
      _appendChar(char, repeat, sourcePos) {
        this._last = char;
        if (char === -1) {
          const fastIndentation = this._fastIndentations[repeat];
          if (fastIndentation !== void 0) {
            this._str += fastIndentation;
          } else {
            this._str += repeat > 1 ? this._indentChar.repeat(repeat) : this._indentChar;
          }
        } else {
          this._str += repeat > 1 ? String.fromCharCode(char).repeat(repeat) : String.fromCharCode(char);
        }
        if (char !== 10) {
          this._mark(sourcePos.line, sourcePos.column, sourcePos.identifierName, sourcePos.identifierNamePos, sourcePos.filename);
          this._position.column += repeat;
        } else {
          this._position.line++;
          this._position.column = 0;
        }
        if (this._canMarkIdName) {
          sourcePos.identifierName = void 0;
          sourcePos.identifierNamePos = void 0;
        }
      }
      _append(str, sourcePos, maybeNewline) {
        const len = str.length;
        const position = this._position;
        this._last = str.charCodeAt(len - 1);
        if (++this._appendCount > 4096) {
          +this._str;
          this._buf += this._str;
          this._str = str;
          this._appendCount = 0;
        } else {
          this._str += str;
        }
        if (!maybeNewline && !this._map) {
          position.column += len;
          return;
        }
        const {
          column: column2,
          identifierName,
          identifierNamePos,
          filename
        } = sourcePos;
        let line2 = sourcePos.line;
        if ((identifierName != null || identifierNamePos != null) && this._canMarkIdName) {
          sourcePos.identifierName = void 0;
          sourcePos.identifierNamePos = void 0;
        }
        let i = str.indexOf("\n");
        let last = 0;
        if (i !== 0) {
          this._mark(line2, column2, identifierName, identifierNamePos, filename);
        }
        while (i !== -1) {
          position.line++;
          position.column = 0;
          last = i + 1;
          if (last < len && line2 !== void 0) {
            this._mark(++line2, 0, null, null, filename);
          }
          i = str.indexOf("\n", last);
        }
        position.column += len - last;
      }
      _mark(line2, column2, identifierName, identifierNamePos, filename) {
        var _this$_map;
        (_this$_map = this._map) == null || _this$_map.mark(this._position, line2, column2, identifierName, identifierNamePos, filename);
      }
      removeTrailingNewline() {
        const queueCursor = this._queueCursor;
        if (queueCursor !== 0 && this._queue[queueCursor - 1].char === 10) {
          this._queueCursor--;
        }
      }
      removeLastSemicolon() {
        const queueCursor = this._queueCursor;
        if (queueCursor !== 0 && this._queue[queueCursor - 1].char === 59) {
          this._queueCursor--;
        }
      }
      getLastChar() {
        const queueCursor = this._queueCursor;
        return queueCursor !== 0 ? this._queue[queueCursor - 1].char : this._last;
      }
      getNewlineCount() {
        const queueCursor = this._queueCursor;
        let count = 0;
        if (queueCursor === 0) return this._last === 10 ? 1 : 0;
        for (let i = queueCursor - 1; i >= 0; i--) {
          if (this._queue[i].char !== 10) {
            break;
          }
          count++;
        }
        return count === queueCursor && this._last === 10 ? count + 1 : count;
      }
      endsWithCharAndNewline() {
        const queue = this._queue;
        const queueCursor = this._queueCursor;
        if (queueCursor !== 0) {
          const lastCp = queue[queueCursor - 1].char;
          if (lastCp !== 10) return;
          if (queueCursor > 1) {
            return queue[queueCursor - 2].char;
          } else {
            return this._last;
          }
        }
      }
      hasContent() {
        return this._queueCursor !== 0 || !!this._last;
      }
      exactSource(loc, cb) {
        if (!this._map) {
          cb();
          return;
        }
        this.source("start", loc);
        const identifierName = loc.identifierName;
        const sourcePos = this._sourcePosition;
        if (identifierName) {
          this._canMarkIdName = false;
          sourcePos.identifierName = identifierName;
        }
        cb();
        if (identifierName) {
          this._canMarkIdName = true;
          sourcePos.identifierName = void 0;
          sourcePos.identifierNamePos = void 0;
        }
        this.source("end", loc);
      }
      source(prop, loc) {
        if (!this._map) return;
        this._normalizePosition(prop, loc, 0);
      }
      sourceWithOffset(prop, loc, columnOffset) {
        if (!this._map) return;
        this._normalizePosition(prop, loc, columnOffset);
      }
      _normalizePosition(prop, loc, columnOffset) {
        const pos2 = loc[prop];
        const target = this._sourcePosition;
        if (pos2) {
          target.line = pos2.line;
          target.column = Math.max(pos2.column + columnOffset, 0);
          target.filename = loc.filename;
        }
      }
      getCurrentColumn() {
        const queue = this._queue;
        const queueCursor = this._queueCursor;
        let lastIndex = -1;
        let len = 0;
        for (let i = 0; i < queueCursor; i++) {
          const item = queue[i];
          if (item.char === 10) {
            lastIndex = len;
          }
          len += item.repeat;
        }
        return lastIndex === -1 ? this._position.column + len : len - 1 - lastIndex;
      }
      getCurrentLine() {
        let count = 0;
        const queue = this._queue;
        for (let i = 0; i < this._queueCursor; i++) {
          if (queue[i].char === 10) {
            count++;
          }
        }
        return this._position.line + count;
      }
    };
    exports2.default = Buffer2;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/whitespace.js
var require_whitespace = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/whitespace.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.nodes = void 0;
    var _t = require("@babel/types");
    var {
      FLIPPED_ALIAS_KEYS,
      isArrayExpression,
      isAssignmentExpression,
      isBinary,
      isBlockStatement,
      isCallExpression,
      isFunction,
      isIdentifier,
      isLiteral,
      isMemberExpression: isMemberExpression2,
      isObjectExpression,
      isOptionalCallExpression,
      isOptionalMemberExpression: isOptionalMemberExpression2,
      isStringLiteral
    } = _t;
    function crawlInternal(node, state) {
      if (!node) return state;
      if (isMemberExpression2(node) || isOptionalMemberExpression2(node)) {
        crawlInternal(node.object, state);
        if (node.computed) crawlInternal(node.property, state);
      } else if (isBinary(node) || isAssignmentExpression(node)) {
        crawlInternal(node.left, state);
        crawlInternal(node.right, state);
      } else if (isCallExpression(node) || isOptionalCallExpression(node)) {
        state.hasCall = true;
        crawlInternal(node.callee, state);
      } else if (isFunction(node)) {
        state.hasFunction = true;
      } else if (isIdentifier(node)) {
        state.hasHelper = state.hasHelper || node.callee && isHelper(node.callee);
      }
      return state;
    }
    function crawl(node) {
      return crawlInternal(node, {
        hasCall: false,
        hasFunction: false,
        hasHelper: false
      });
    }
    function isHelper(node) {
      if (!node) return false;
      if (isMemberExpression2(node)) {
        return isHelper(node.object) || isHelper(node.property);
      } else if (isIdentifier(node)) {
        return node.name === "require" || node.name.charCodeAt(0) === 95;
      } else if (isCallExpression(node)) {
        return isHelper(node.callee);
      } else if (isBinary(node) || isAssignmentExpression(node)) {
        return isIdentifier(node.left) && isHelper(node.left) || isHelper(node.right);
      } else {
        return false;
      }
    }
    function isType(node) {
      return isLiteral(node) || isObjectExpression(node) || isArrayExpression(node) || isIdentifier(node) || isMemberExpression2(node);
    }
    var nodes = exports2.nodes = {
      AssignmentExpression(node) {
        const state = crawl(node.right);
        if (state.hasCall && state.hasHelper || state.hasFunction) {
          return state.hasFunction ? 1 | 2 : 2;
        }
      },
      SwitchCase(node, parent) {
        return (!!node.consequent.length || parent.cases[0] === node ? 1 : 0) | (!node.consequent.length && parent.cases[parent.cases.length - 1] === node ? 2 : 0);
      },
      LogicalExpression(node) {
        if (isFunction(node.left) || isFunction(node.right)) {
          return 2;
        }
      },
      Literal(node) {
        if (isStringLiteral(node) && node.value === "use strict") {
          return 2;
        }
      },
      CallExpression(node) {
        if (isFunction(node.callee) || isHelper(node)) {
          return 1 | 2;
        }
      },
      OptionalCallExpression(node) {
        if (isFunction(node.callee)) {
          return 1 | 2;
        }
      },
      VariableDeclaration(node) {
        for (let i = 0; i < node.declarations.length; i++) {
          const declar = node.declarations[i];
          let enabled = isHelper(declar.id) && !isType(declar.init);
          if (!enabled && declar.init) {
            const state = crawl(declar.init);
            enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
          }
          if (enabled) {
            return 1 | 2;
          }
        }
      },
      IfStatement(node) {
        if (isBlockStatement(node.consequent)) {
          return 1 | 2;
        }
      }
    };
    nodes.ObjectProperty = nodes.ObjectTypeProperty = nodes.ObjectMethod = function(node, parent) {
      if (parent.properties[0] === node) {
        return 1;
      }
    };
    nodes.ObjectTypeCallProperty = function(node, parent) {
      var _parent$properties;
      if (parent.callProperties[0] === node && !((_parent$properties = parent.properties) != null && _parent$properties.length)) {
        return 1;
      }
    };
    nodes.ObjectTypeIndexer = function(node, parent) {
      var _parent$properties2, _parent$callPropertie;
      if (parent.indexers[0] === node && !((_parent$properties2 = parent.properties) != null && _parent$properties2.length) && !((_parent$callPropertie = parent.callProperties) != null && _parent$callPropertie.length)) {
        return 1;
      }
    };
    nodes.ObjectTypeInternalSlot = function(node, parent) {
      var _parent$properties3, _parent$callPropertie2, _parent$indexers;
      if (parent.internalSlots[0] === node && !((_parent$properties3 = parent.properties) != null && _parent$properties3.length) && !((_parent$callPropertie2 = parent.callProperties) != null && _parent$callPropertie2.length) && !((_parent$indexers = parent.indexers) != null && _parent$indexers.length)) {
        return 1;
      }
    };
    [["Function", true], ["Class", true], ["Loop", true], ["LabeledStatement", true], ["SwitchStatement", true], ["TryStatement", true]].forEach(function([type, amounts]) {
      [type].concat(FLIPPED_ALIAS_KEYS[type] || []).forEach(function(type2) {
        const ret = amounts ? 1 | 2 : 0;
        nodes[type2] = () => ret;
      });
    });
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/parentheses.js
var require_parentheses = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/parentheses.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.AssignmentExpression = AssignmentExpression;
    exports2.Binary = Binary;
    exports2.BinaryExpression = BinaryExpression;
    exports2.ClassExpression = ClassExpression;
    exports2.ArrowFunctionExpression = exports2.ConditionalExpression = ConditionalExpression;
    exports2.DoExpression = DoExpression;
    exports2.FunctionExpression = FunctionExpression11;
    exports2.FunctionTypeAnnotation = FunctionTypeAnnotation;
    exports2.Identifier = Identifier25;
    exports2.LogicalExpression = LogicalExpression;
    exports2.NullableTypeAnnotation = NullableTypeAnnotation;
    exports2.ObjectExpression = ObjectExpression;
    exports2.OptionalIndexedAccessType = OptionalIndexedAccessType;
    exports2.OptionalCallExpression = exports2.OptionalMemberExpression = OptionalMemberExpression;
    exports2.SequenceExpression = SequenceExpression;
    exports2.TSSatisfiesExpression = exports2.TSAsExpression = TSAsExpression;
    exports2.TSConditionalType = TSConditionalType;
    exports2.TSConstructorType = exports2.TSFunctionType = TSFunctionType;
    exports2.TSInferType = TSInferType;
    exports2.TSInstantiationExpression = TSInstantiationExpression;
    exports2.TSIntersectionType = TSIntersectionType;
    exports2.UnaryLike = exports2.TSTypeAssertion = UnaryLike;
    exports2.TSTypeOperator = TSTypeOperator;
    exports2.TSUnionType = TSUnionType;
    exports2.IntersectionTypeAnnotation = exports2.UnionTypeAnnotation = UnionTypeAnnotation;
    exports2.UpdateExpression = UpdateExpression;
    exports2.AwaitExpression = exports2.YieldExpression = YieldExpression;
    var _t = require("@babel/types");
    var _index = require_node2();
    var {
      isArrayTypeAnnotation,
      isBinaryExpression,
      isCallExpression,
      isForOfStatement,
      isIndexedAccessType,
      isMemberExpression: isMemberExpression2,
      isObjectPattern,
      isOptionalMemberExpression: isOptionalMemberExpression2,
      isYieldExpression,
      isStatement: isStatement2
    } = _t;
    var PRECEDENCE = /* @__PURE__ */ new Map([["||", 0], ["??", 0], ["|>", 0], ["&&", 1], ["|", 2], ["^", 3], ["&", 4], ["==", 5], ["===", 5], ["!=", 5], ["!==", 5], ["<", 6], [">", 6], ["<=", 6], [">=", 6], ["in", 6], ["instanceof", 6], [">>", 7], ["<<", 7], [">>>", 7], ["+", 8], ["-", 8], ["*", 9], ["/", 9], ["%", 9], ["**", 10]]);
    function getBinaryPrecedence(node, nodeType) {
      if (nodeType === "BinaryExpression" || nodeType === "LogicalExpression") {
        return PRECEDENCE.get(node.operator);
      }
      if (nodeType === "TSAsExpression" || nodeType === "TSSatisfiesExpression") {
        return PRECEDENCE.get("in");
      }
    }
    function isTSTypeExpression(nodeType) {
      return nodeType === "TSAsExpression" || nodeType === "TSSatisfiesExpression" || nodeType === "TSTypeAssertion";
    }
    var isClassExtendsClause = (node, parent) => {
      const parentType = parent.type;
      return (parentType === "ClassDeclaration" || parentType === "ClassExpression") && parent.superClass === node;
    };
    var hasPostfixPart = (node, parent) => {
      const parentType = parent.type;
      return (parentType === "MemberExpression" || parentType === "OptionalMemberExpression") && parent.object === node || (parentType === "CallExpression" || parentType === "OptionalCallExpression" || parentType === "NewExpression") && parent.callee === node || parentType === "TaggedTemplateExpression" && parent.tag === node || parentType === "TSNonNullExpression";
    };
    function NullableTypeAnnotation(node, parent) {
      return isArrayTypeAnnotation(parent);
    }
    function FunctionTypeAnnotation(node, parent, tokenContext) {
      const parentType = parent.type;
      return parentType === "UnionTypeAnnotation" || parentType === "IntersectionTypeAnnotation" || parentType === "ArrayTypeAnnotation" || Boolean(tokenContext & _index.TokenContext.arrowFlowReturnType);
    }
    function UpdateExpression(node, parent) {
      return hasPostfixPart(node, parent) || isClassExtendsClause(node, parent);
    }
    function needsParenBeforeExpressionBrace(tokenContext) {
      return Boolean(tokenContext & (_index.TokenContext.expressionStatement | _index.TokenContext.arrowBody));
    }
    function ObjectExpression(node, parent, tokenContext) {
      return needsParenBeforeExpressionBrace(tokenContext);
    }
    function DoExpression(node, parent, tokenContext) {
      return !node.async && Boolean(tokenContext & _index.TokenContext.expressionStatement);
    }
    function Binary(node, parent) {
      const parentType = parent.type;
      if (node.type === "BinaryExpression" && node.operator === "**" && parentType === "BinaryExpression" && parent.operator === "**") {
        return parent.left === node;
      }
      if (isClassExtendsClause(node, parent)) {
        return true;
      }
      if (hasPostfixPart(node, parent) || parentType === "UnaryExpression" || parentType === "SpreadElement" || parentType === "AwaitExpression") {
        return true;
      }
      const parentPos = getBinaryPrecedence(parent, parentType);
      if (parentPos != null) {
        const nodePos = getBinaryPrecedence(node, node.type);
        if (parentPos === nodePos && parentType === "BinaryExpression" && parent.right === node || parentPos > nodePos) {
          return true;
        }
      }
      return void 0;
    }
    function UnionTypeAnnotation(node, parent) {
      const parentType = parent.type;
      return parentType === "ArrayTypeAnnotation" || parentType === "NullableTypeAnnotation" || parentType === "IntersectionTypeAnnotation" || parentType === "UnionTypeAnnotation";
    }
    function OptionalIndexedAccessType(node, parent) {
      return isIndexedAccessType(parent) && parent.objectType === node;
    }
    function TSAsExpression(node, parent) {
      if ((parent.type === "AssignmentExpression" || parent.type === "AssignmentPattern") && parent.left === node) {
        return true;
      }
      if (parent.type === "BinaryExpression" && (parent.operator === "|" || parent.operator === "&") && node === parent.left) {
        return true;
      }
      return Binary(node, parent);
    }
    function TSConditionalType(node, parent) {
      const parentType = parent.type;
      if (parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSOptionalType" || parentType === "TSTypeOperator" || parentType === "TSTypeParameter") {
        return true;
      }
      if ((parentType === "TSIntersectionType" || parentType === "TSUnionType") && parent.types[0] === node) {
        return true;
      }
      if (parentType === "TSConditionalType" && (parent.checkType === node || parent.extendsType === node)) {
        return true;
      }
      return false;
    }
    function TSUnionType(node, parent) {
      const parentType = parent.type;
      return parentType === "TSIntersectionType" || parentType === "TSTypeOperator" || parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSOptionalType";
    }
    function TSIntersectionType(node, parent) {
      const parentType = parent.type;
      return parentType === "TSTypeOperator" || parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSOptionalType";
    }
    function TSInferType(node, parent) {
      const parentType = parent.type;
      if (parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSOptionalType") {
        return true;
      }
      if (node.typeParameter.constraint) {
        if ((parentType === "TSIntersectionType" || parentType === "TSUnionType") && parent.types[0] === node) {
          return true;
        }
      }
      return false;
    }
    function TSTypeOperator(node, parent) {
      const parentType = parent.type;
      return parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSOptionalType";
    }
    function TSInstantiationExpression(node, parent) {
      const parentType = parent.type;
      return (parentType === "CallExpression" || parentType === "OptionalCallExpression" || parentType === "NewExpression" || parentType === "TSInstantiationExpression") && !!parent.typeParameters;
    }
    function TSFunctionType(node, parent) {
      const parentType = parent.type;
      return parentType === "TSIntersectionType" || parentType === "TSUnionType" || parentType === "TSTypeOperator" || parentType === "TSOptionalType" || parentType === "TSArrayType" || parentType === "TSIndexedAccessType" && parent.objectType === node || parentType === "TSConditionalType" && (parent.checkType === node || parent.extendsType === node);
    }
    function BinaryExpression(node, parent, tokenContext, inForStatementInit) {
      return node.operator === "in" && inForStatementInit;
    }
    function SequenceExpression(node, parent) {
      const parentType = parent.type;
      if (parentType === "SequenceExpression" || parentType === "ParenthesizedExpression" || parentType === "MemberExpression" && parent.property === node || parentType === "OptionalMemberExpression" && parent.property === node || parentType === "TemplateLiteral") {
        return false;
      }
      if (parentType === "ClassDeclaration") {
        return true;
      }
      if (parentType === "ForOfStatement") {
        return parent.right === node;
      }
      if (parentType === "ExportDefaultDeclaration") {
        return true;
      }
      return !isStatement2(parent);
    }
    function YieldExpression(node, parent) {
      const parentType = parent.type;
      return parentType === "BinaryExpression" || parentType === "LogicalExpression" || parentType === "UnaryExpression" || parentType === "SpreadElement" || hasPostfixPart(node, parent) || parentType === "AwaitExpression" && isYieldExpression(node) || parentType === "ConditionalExpression" && node === parent.test || isClassExtendsClause(node, parent) || isTSTypeExpression(parentType);
    }
    function ClassExpression(node, parent, tokenContext) {
      return Boolean(tokenContext & (_index.TokenContext.expressionStatement | _index.TokenContext.exportDefault));
    }
    function UnaryLike(node, parent) {
      return hasPostfixPart(node, parent) || isBinaryExpression(parent) && parent.operator === "**" && parent.left === node || isClassExtendsClause(node, parent);
    }
    function FunctionExpression11(node, parent, tokenContext) {
      return Boolean(tokenContext & (_index.TokenContext.expressionStatement | _index.TokenContext.exportDefault));
    }
    function ConditionalExpression(node, parent) {
      const parentType = parent.type;
      if (parentType === "UnaryExpression" || parentType === "SpreadElement" || parentType === "BinaryExpression" || parentType === "LogicalExpression" || parentType === "ConditionalExpression" && parent.test === node || parentType === "AwaitExpression" || isTSTypeExpression(parentType)) {
        return true;
      }
      return UnaryLike(node, parent);
    }
    function OptionalMemberExpression(node, parent) {
      return isCallExpression(parent) && parent.callee === node || isMemberExpression2(parent) && parent.object === node;
    }
    function AssignmentExpression(node, parent, tokenContext) {
      if (needsParenBeforeExpressionBrace(tokenContext) && isObjectPattern(node.left)) {
        return true;
      } else {
        return ConditionalExpression(node, parent);
      }
    }
    function LogicalExpression(node, parent) {
      const parentType = parent.type;
      if (isTSTypeExpression(parentType)) return true;
      if (parentType !== "LogicalExpression") return false;
      switch (node.operator) {
        case "||":
          return parent.operator === "??" || parent.operator === "&&";
        case "&&":
          return parent.operator === "??";
        case "??":
          return parent.operator !== "??";
      }
    }
    function Identifier25(node, parent, tokenContext, _inForInit, getRawIdentifier) {
      var _node$extra;
      const parentType = parent.type;
      if ((_node$extra = node.extra) != null && _node$extra.parenthesized && parentType === "AssignmentExpression" && parent.left === node) {
        const rightType = parent.right.type;
        if ((rightType === "FunctionExpression" || rightType === "ClassExpression") && parent.right.id == null) {
          return true;
        }
      }
      if (getRawIdentifier && getRawIdentifier(node) !== node.name) {
        return false;
      }
      if (node.name === "let") {
        const isFollowedByBracket = isMemberExpression2(parent, {
          object: node,
          computed: true
        }) || isOptionalMemberExpression2(parent, {
          object: node,
          computed: true,
          optional: false
        });
        if (isFollowedByBracket && tokenContext & (_index.TokenContext.expressionStatement | _index.TokenContext.forHead | _index.TokenContext.forInHead)) {
          return true;
        }
        return Boolean(tokenContext & _index.TokenContext.forOfHead);
      }
      return node.name === "async" && isForOfStatement(parent, {
        left: node,
        await: false
      });
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/index.js
var require_node2 = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/node/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TokenContext = void 0;
    exports2.isLastChild = isLastChild;
    exports2.needsParens = needsParens;
    exports2.needsWhitespace = needsWhitespace;
    exports2.needsWhitespaceAfter = needsWhitespaceAfter;
    exports2.needsWhitespaceBefore = needsWhitespaceBefore;
    var whitespace = require_whitespace();
    var parens = require_parentheses();
    var _t = require("@babel/types");
    var {
      FLIPPED_ALIAS_KEYS,
      VISITOR_KEYS,
      isCallExpression,
      isDecorator,
      isExpressionStatement,
      isMemberExpression: isMemberExpression2,
      isNewExpression,
      isParenthesizedExpression
    } = _t;
    var TokenContext = exports2.TokenContext = {
      expressionStatement: 1,
      arrowBody: 2,
      exportDefault: 4,
      forHead: 8,
      forInHead: 16,
      forOfHead: 32,
      arrowFlowReturnType: 64
    };
    function expandAliases(obj) {
      const map2 = /* @__PURE__ */ new Map();
      function add(type, func) {
        const fn = map2.get(type);
        map2.set(type, fn ? function(node, parent, stack2, inForInit, getRawIdentifier) {
          var _fn;
          return (_fn = fn(node, parent, stack2, inForInit, getRawIdentifier)) != null ? _fn : func(node, parent, stack2, inForInit, getRawIdentifier);
        } : func);
      }
      for (const type of Object.keys(obj)) {
        const aliases = FLIPPED_ALIAS_KEYS[type];
        if (aliases) {
          for (const alias of aliases) {
            add(alias, obj[type]);
          }
        } else {
          add(type, obj[type]);
        }
      }
      return map2;
    }
    var expandedParens = expandAliases(parens);
    var expandedWhitespaceNodes = expandAliases(whitespace.nodes);
    function isOrHasCallExpression(node) {
      if (isCallExpression(node)) {
        return true;
      }
      return isMemberExpression2(node) && isOrHasCallExpression(node.object);
    }
    function needsWhitespace(node, parent, type) {
      var _expandedWhitespaceNo;
      if (!node) return false;
      if (isExpressionStatement(node)) {
        node = node.expression;
      }
      const flag = (_expandedWhitespaceNo = expandedWhitespaceNodes.get(node.type)) == null ? void 0 : _expandedWhitespaceNo(node, parent);
      if (typeof flag === "number") {
        return (flag & type) !== 0;
      }
      return false;
    }
    function needsWhitespaceBefore(node, parent) {
      return needsWhitespace(node, parent, 1);
    }
    function needsWhitespaceAfter(node, parent) {
      return needsWhitespace(node, parent, 2);
    }
    function needsParens(node, parent, tokenContext, inForInit, getRawIdentifier) {
      var _expandedParens$get;
      if (!parent) return false;
      if (isNewExpression(parent) && parent.callee === node) {
        if (isOrHasCallExpression(node)) return true;
      }
      if (isDecorator(parent)) {
        return !isDecoratorMemberExpression(node) && !(isCallExpression(node) && isDecoratorMemberExpression(node.callee)) && !isParenthesizedExpression(node);
      }
      return (_expandedParens$get = expandedParens.get(node.type)) == null ? void 0 : _expandedParens$get(node, parent, tokenContext, inForInit, getRawIdentifier);
    }
    function isDecoratorMemberExpression(node) {
      switch (node.type) {
        case "Identifier":
          return true;
        case "MemberExpression":
          return !node.computed && node.property.type === "Identifier" && isDecoratorMemberExpression(node.object);
        default:
          return false;
      }
    }
    function isLastChild(parent, child) {
      const visitorKeys = VISITOR_KEYS[parent.type];
      for (let i = visitorKeys.length - 1; i >= 0; i--) {
        const val = parent[visitorKeys[i]];
        if (val === child) {
          return true;
        } else if (Array.isArray(val)) {
          let j = val.length - 1;
          while (j >= 0 && val[j] === null) j--;
          return j >= 0 && val[j] === child;
        } else if (val) {
          return false;
        }
      }
      return false;
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/token-map.js
var require_token_map = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/token-map.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TokenMap = void 0;
    var _t = require("@babel/types");
    var {
      traverseFast,
      VISITOR_KEYS
    } = _t;
    var TokenMap = class {
      constructor(ast, tokens, source2) {
        this._tokens = void 0;
        this._source = void 0;
        this._nodesToTokenIndexes = /* @__PURE__ */ new Map();
        this._nodesOccurrencesCountCache = /* @__PURE__ */ new Map();
        this._tokensCache = /* @__PURE__ */ new Map();
        this._tokens = tokens;
        this._source = source2;
        traverseFast(ast, (node) => {
          const indexes = this._getTokensIndexesOfNode(node);
          if (indexes.length > 0) this._nodesToTokenIndexes.set(node, indexes);
        });
        this._tokensCache = null;
      }
      has(node) {
        return this._nodesToTokenIndexes.has(node);
      }
      getIndexes(node) {
        return this._nodesToTokenIndexes.get(node);
      }
      find(node, condition) {
        const indexes = this._nodesToTokenIndexes.get(node);
        if (indexes) {
          for (let k = 0; k < indexes.length; k++) {
            const index = indexes[k];
            const tok = this._tokens[index];
            if (condition(tok, index)) return tok;
          }
        }
        return null;
      }
      findLastIndex(node, condition) {
        const indexes = this._nodesToTokenIndexes.get(node);
        if (indexes) {
          for (let k = indexes.length - 1; k >= 0; k--) {
            const index = indexes[k];
            const tok = this._tokens[index];
            if (condition(tok, index)) return index;
          }
        }
        return -1;
      }
      findMatching(node, test, occurrenceCount = 0) {
        const indexes = this._nodesToTokenIndexes.get(node);
        if (indexes) {
          let i = 0;
          const count = occurrenceCount;
          if (count > 1) {
            const cache = this._nodesOccurrencesCountCache.get(node);
            if (cache && cache.test === test && cache.count < count) {
              i = cache.i + 1;
              occurrenceCount -= cache.count + 1;
            }
          }
          for (; i < indexes.length; i++) {
            const tok = this._tokens[indexes[i]];
            if (this.matchesOriginal(tok, test)) {
              if (occurrenceCount === 0) {
                if (count > 0) {
                  this._nodesOccurrencesCountCache.set(node, {
                    test,
                    count,
                    i
                  });
                }
                return tok;
              }
              occurrenceCount--;
            }
          }
        }
        return null;
      }
      matchesOriginal(token2, test) {
        if (token2.end - token2.start !== test.length) return false;
        if (token2.value != null) return token2.value === test;
        return this._source.startsWith(test, token2.start);
      }
      startMatches(node, test) {
        const indexes = this._nodesToTokenIndexes.get(node);
        if (!indexes) return false;
        const tok = this._tokens[indexes[0]];
        if (tok.start !== node.start) return false;
        return this.matchesOriginal(tok, test);
      }
      endMatches(node, test) {
        const indexes = this._nodesToTokenIndexes.get(node);
        if (!indexes) return false;
        const tok = this._tokens[indexes[indexes.length - 1]];
        if (tok.end !== node.end) return false;
        return this.matchesOriginal(tok, test);
      }
      _getTokensIndexesOfNode(node) {
        if (node.start == null || node.end == null) return [];
        const {
          first,
          last
        } = this._findTokensOfNode(node, 0, this._tokens.length - 1);
        let low = first;
        const children = childrenIterator(node);
        if ((node.type === "ExportNamedDeclaration" || node.type === "ExportDefaultDeclaration") && node.declaration && node.declaration.type === "ClassDeclaration") {
          children.next();
        }
        const indexes = [];
        for (const child of children) {
          if (child == null) continue;
          if (child.start == null || child.end == null) continue;
          const childTok = this._findTokensOfNode(child, low, last);
          const high = childTok.first;
          for (let k = low; k < high; k++) indexes.push(k);
          low = childTok.last + 1;
        }
        for (let k = low; k <= last; k++) indexes.push(k);
        return indexes;
      }
      _findTokensOfNode(node, low, high) {
        const cached2 = this._tokensCache.get(node);
        if (cached2) return cached2;
        const first = this._findFirstTokenOfNode(node.start, low, high);
        const last = this._findLastTokenOfNode(node.end, first, high);
        this._tokensCache.set(node, {
          first,
          last
        });
        return {
          first,
          last
        };
      }
      _findFirstTokenOfNode(start, low, high) {
        while (low <= high) {
          const mid = high + low >> 1;
          if (start < this._tokens[mid].start) {
            high = mid - 1;
          } else if (start > this._tokens[mid].start) {
            low = mid + 1;
          } else {
            return mid;
          }
        }
        return low;
      }
      _findLastTokenOfNode(end, low, high) {
        while (low <= high) {
          const mid = high + low >> 1;
          if (end < this._tokens[mid].end) {
            high = mid - 1;
          } else if (end > this._tokens[mid].end) {
            low = mid + 1;
          } else {
            return mid;
          }
        }
        return high;
      }
    };
    exports2.TokenMap = TokenMap;
    function* childrenIterator(node) {
      if (node.type === "TemplateLiteral") {
        yield node.quasis[0];
        for (let i = 1; i < node.quasis.length; i++) {
          yield node.expressions[i - 1];
          yield node.quasis[i];
        }
        return;
      }
      const keys = VISITOR_KEYS[node.type];
      for (const key2 of keys) {
        const child = node[key2];
        if (!child) continue;
        if (Array.isArray(child)) {
          yield* __yieldStar(child);
        } else {
          yield child;
        }
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/template-literals.js
var require_template_literals = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/template-literals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TaggedTemplateExpression = TaggedTemplateExpression;
    exports2.TemplateElement = TemplateElement;
    exports2.TemplateLiteral = TemplateLiteral;
    exports2._printTemplate = _printTemplate;
    function TaggedTemplateExpression(node) {
      this.print(node.tag);
      {
        this.print(node.typeParameters);
      }
      this.print(node.quasi);
    }
    function TemplateElement() {
      throw new Error("TemplateElement printing is handled in TemplateLiteral");
    }
    function _printTemplate(node, substitutions) {
      const quasis = node.quasis;
      let partRaw = "`";
      for (let i = 0; i < quasis.length - 1; i++) {
        partRaw += quasis[i].value.raw;
        this.token(partRaw + "${", true);
        this.print(substitutions[i]);
        partRaw = "}";
        if (this.tokenMap) {
          const token2 = this.tokenMap.findMatching(node, "}", i);
          if (token2) this._catchUpTo(token2.loc.start);
        }
      }
      partRaw += quasis[quasis.length - 1].value.raw;
      this.token(partRaw + "`", true);
    }
    function TemplateLiteral(node) {
      this._printTemplate(node, node.expressions);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/expressions.js
var require_expressions = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/expressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.LogicalExpression = exports2.BinaryExpression = exports2.AssignmentExpression = AssignmentExpression;
    exports2.AssignmentPattern = AssignmentPattern;
    exports2.AwaitExpression = AwaitExpression;
    exports2.BindExpression = BindExpression;
    exports2.CallExpression = CallExpression4;
    exports2.ConditionalExpression = ConditionalExpression;
    exports2.Decorator = Decorator;
    exports2.DoExpression = DoExpression;
    exports2.EmptyStatement = EmptyStatement;
    exports2.ExpressionStatement = ExpressionStatement;
    exports2.Import = Import;
    exports2.MemberExpression = MemberExpression;
    exports2.MetaProperty = MetaProperty;
    exports2.ModuleExpression = ModuleExpression;
    exports2.NewExpression = NewExpression;
    exports2.OptionalCallExpression = OptionalCallExpression;
    exports2.OptionalMemberExpression = OptionalMemberExpression;
    exports2.ParenthesizedExpression = ParenthesizedExpression;
    exports2.PrivateName = PrivateName;
    exports2.SequenceExpression = SequenceExpression;
    exports2.Super = Super;
    exports2.ThisExpression = ThisExpression;
    exports2.UnaryExpression = UnaryExpression;
    exports2.UpdateExpression = UpdateExpression;
    exports2.V8IntrinsicIdentifier = V8IntrinsicIdentifier;
    exports2.YieldExpression = YieldExpression;
    exports2._shouldPrintDecoratorsBeforeExport = _shouldPrintDecoratorsBeforeExport;
    var _t = require("@babel/types");
    var _index = require_node2();
    var {
      isCallExpression,
      isLiteral,
      isMemberExpression: isMemberExpression2,
      isNewExpression,
      isPattern
    } = _t;
    function UnaryExpression(node) {
      const {
        operator
      } = node;
      if (operator === "void" || operator === "delete" || operator === "typeof" || operator === "throw") {
        this.word(operator);
        this.space();
      } else {
        this.token(operator);
      }
      this.print(node.argument);
    }
    function DoExpression(node) {
      if (node.async) {
        this.word("async", true);
        this.space();
      }
      this.word("do");
      this.space();
      this.print(node.body);
    }
    function ParenthesizedExpression(node) {
      this.tokenChar(40);
      const exit = this.enterDelimited();
      this.print(node.expression);
      exit();
      this.rightParens(node);
    }
    function UpdateExpression(node) {
      if (node.prefix) {
        this.token(node.operator);
        this.print(node.argument);
      } else {
        this.print(node.argument, true);
        this.token(node.operator);
      }
    }
    function ConditionalExpression(node) {
      this.print(node.test);
      this.space();
      this.tokenChar(63);
      this.space();
      this.print(node.consequent);
      this.space();
      this.tokenChar(58);
      this.space();
      this.print(node.alternate);
    }
    function NewExpression(node, parent) {
      this.word("new");
      this.space();
      this.print(node.callee);
      if (this.format.minified && node.arguments.length === 0 && !node.optional && !isCallExpression(parent, {
        callee: node
      }) && !isMemberExpression2(parent) && !isNewExpression(parent)) {
        return;
      }
      this.print(node.typeArguments);
      {
        this.print(node.typeParameters);
      }
      if (node.optional) {
        this.token("?.");
      }
      if (node.arguments.length === 0 && this.tokenMap && !this.tokenMap.endMatches(node, ")")) {
        return;
      }
      this.tokenChar(40);
      const exit = this.enterDelimited();
      this.printList(node.arguments, this.shouldPrintTrailingComma(")"));
      exit();
      this.rightParens(node);
    }
    function SequenceExpression(node) {
      this.printList(node.expressions);
    }
    function ThisExpression() {
      this.word("this");
    }
    function Super() {
      this.word("super");
    }
    function _shouldPrintDecoratorsBeforeExport(node) {
      if (typeof this.format.decoratorsBeforeExport === "boolean") {
        return this.format.decoratorsBeforeExport;
      }
      return typeof node.start === "number" && node.start === node.declaration.start;
    }
    function Decorator(node) {
      this.tokenChar(64);
      this.print(node.expression);
      this.newline();
    }
    function OptionalMemberExpression(node) {
      let {
        computed
      } = node;
      const {
        optional: optional2,
        property
      } = node;
      this.print(node.object);
      if (!computed && isMemberExpression2(property)) {
        throw new TypeError("Got a MemberExpression for MemberExpression property");
      }
      if (isLiteral(property) && typeof property.value === "number") {
        computed = true;
      }
      if (optional2) {
        this.token("?.");
      }
      if (computed) {
        this.tokenChar(91);
        this.print(property);
        this.tokenChar(93);
      } else {
        if (!optional2) {
          this.tokenChar(46);
        }
        this.print(property);
      }
    }
    function OptionalCallExpression(node) {
      this.print(node.callee);
      {
        this.print(node.typeParameters);
      }
      if (node.optional) {
        this.token("?.");
      }
      this.print(node.typeArguments);
      this.tokenChar(40);
      const exit = this.enterDelimited();
      this.printList(node.arguments);
      exit();
      this.rightParens(node);
    }
    function CallExpression4(node) {
      this.print(node.callee);
      this.print(node.typeArguments);
      {
        this.print(node.typeParameters);
      }
      this.tokenChar(40);
      const exit = this.enterDelimited();
      this.printList(node.arguments, this.shouldPrintTrailingComma(")"));
      exit();
      this.rightParens(node);
    }
    function Import() {
      this.word("import");
    }
    function AwaitExpression(node) {
      this.word("await");
      if (node.argument) {
        this.space();
        this.printTerminatorless(node.argument);
      }
    }
    function YieldExpression(node) {
      this.word("yield", true);
      if (node.delegate) {
        this.tokenChar(42);
        if (node.argument) {
          this.space();
          this.print(node.argument);
        }
      } else {
        if (node.argument) {
          this.space();
          this.printTerminatorless(node.argument);
        }
      }
    }
    function EmptyStatement() {
      this.semicolon(true);
    }
    function ExpressionStatement(node) {
      this.tokenContext |= _index.TokenContext.expressionStatement;
      this.print(node.expression);
      this.semicolon();
    }
    function AssignmentPattern(node) {
      this.print(node.left);
      if (node.left.type === "Identifier" || isPattern(node.left)) {
        if (node.left.optional) this.tokenChar(63);
        this.print(node.left.typeAnnotation);
      }
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.right);
    }
    function AssignmentExpression(node) {
      this.print(node.left);
      this.space();
      if (node.operator === "in" || node.operator === "instanceof") {
        this.word(node.operator);
      } else {
        this.token(node.operator);
        this._endsWithDiv = node.operator === "/";
      }
      this.space();
      this.print(node.right);
    }
    function BindExpression(node) {
      this.print(node.object);
      this.token("::");
      this.print(node.callee);
    }
    function MemberExpression(node) {
      this.print(node.object);
      if (!node.computed && isMemberExpression2(node.property)) {
        throw new TypeError("Got a MemberExpression for MemberExpression property");
      }
      let computed = node.computed;
      if (isLiteral(node.property) && typeof node.property.value === "number") {
        computed = true;
      }
      if (computed) {
        const exit = this.enterDelimited();
        this.tokenChar(91);
        this.print(node.property);
        this.tokenChar(93);
        exit();
      } else {
        this.tokenChar(46);
        this.print(node.property);
      }
    }
    function MetaProperty(node) {
      this.print(node.meta);
      this.tokenChar(46);
      this.print(node.property);
    }
    function PrivateName(node) {
      this.tokenChar(35);
      this.print(node.id);
    }
    function V8IntrinsicIdentifier(node) {
      this.tokenChar(37);
      this.word(node.name);
    }
    function ModuleExpression(node) {
      this.word("module", true);
      this.space();
      this.tokenChar(123);
      this.indent();
      const {
        body
      } = node;
      if (body.body.length || body.directives.length) {
        this.newline();
      }
      this.print(body);
      this.dedent();
      this.rightBrace(node);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/statements.js
var require_statements = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/statements.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.BreakStatement = BreakStatement;
    exports2.CatchClause = CatchClause;
    exports2.ContinueStatement = ContinueStatement;
    exports2.DebuggerStatement = DebuggerStatement;
    exports2.DoWhileStatement = DoWhileStatement;
    exports2.ForOfStatement = exports2.ForInStatement = void 0;
    exports2.ForStatement = ForStatement;
    exports2.IfStatement = IfStatement;
    exports2.LabeledStatement = LabeledStatement;
    exports2.ReturnStatement = ReturnStatement;
    exports2.SwitchCase = SwitchCase;
    exports2.SwitchStatement = SwitchStatement;
    exports2.ThrowStatement = ThrowStatement;
    exports2.TryStatement = TryStatement;
    exports2.VariableDeclaration = VariableDeclaration;
    exports2.VariableDeclarator = VariableDeclarator;
    exports2.WhileStatement = WhileStatement;
    exports2.WithStatement = WithStatement;
    var _t = require("@babel/types");
    var _index = require_node2();
    var {
      isFor,
      isForStatement,
      isIfStatement,
      isStatement: isStatement2
    } = _t;
    function WithStatement(node) {
      this.word("with");
      this.space();
      this.tokenChar(40);
      this.print(node.object);
      this.tokenChar(41);
      this.printBlock(node);
    }
    function IfStatement(node) {
      this.word("if");
      this.space();
      this.tokenChar(40);
      this.print(node.test);
      this.tokenChar(41);
      this.space();
      const needsBlock = node.alternate && isIfStatement(getLastStatement(node.consequent));
      if (needsBlock) {
        this.tokenChar(123);
        this.newline();
        this.indent();
      }
      this.printAndIndentOnComments(node.consequent);
      if (needsBlock) {
        this.dedent();
        this.newline();
        this.tokenChar(125);
      }
      if (node.alternate) {
        if (this.endsWith(125)) this.space();
        this.word("else");
        this.space();
        this.printAndIndentOnComments(node.alternate);
      }
    }
    function getLastStatement(statement) {
      const {
        body
      } = statement;
      if (isStatement2(body) === false) {
        return statement;
      }
      return getLastStatement(body);
    }
    function ForStatement(node) {
      this.word("for");
      this.space();
      this.tokenChar(40);
      {
        const exit = this.enterForStatementInit();
        this.tokenContext |= _index.TokenContext.forHead;
        this.print(node.init);
        exit();
      }
      this.tokenChar(59);
      if (node.test) {
        this.space();
        this.print(node.test);
      }
      this.token(";", false, 1);
      if (node.update) {
        this.space();
        this.print(node.update);
      }
      this.tokenChar(41);
      this.printBlock(node);
    }
    function WhileStatement(node) {
      this.word("while");
      this.space();
      this.tokenChar(40);
      this.print(node.test);
      this.tokenChar(41);
      this.printBlock(node);
    }
    function ForXStatement(node) {
      this.word("for");
      this.space();
      const isForOf = node.type === "ForOfStatement";
      if (isForOf && node.await) {
        this.word("await");
        this.space();
      }
      this.noIndentInnerCommentsHere();
      this.tokenChar(40);
      {
        const exit = isForOf ? null : this.enterForStatementInit();
        this.tokenContext |= isForOf ? _index.TokenContext.forOfHead : _index.TokenContext.forInHead;
        this.print(node.left);
        exit == null || exit();
      }
      this.space();
      this.word(isForOf ? "of" : "in");
      this.space();
      this.print(node.right);
      this.tokenChar(41);
      this.printBlock(node);
    }
    var ForInStatement = exports2.ForInStatement = ForXStatement;
    var ForOfStatement = exports2.ForOfStatement = ForXStatement;
    function DoWhileStatement(node) {
      this.word("do");
      this.space();
      this.print(node.body);
      this.space();
      this.word("while");
      this.space();
      this.tokenChar(40);
      this.print(node.test);
      this.tokenChar(41);
      this.semicolon();
    }
    function printStatementAfterKeyword(printer, node) {
      if (node) {
        printer.space();
        printer.printTerminatorless(node);
      }
      printer.semicolon();
    }
    function BreakStatement(node) {
      this.word("break");
      printStatementAfterKeyword(this, node.label);
    }
    function ContinueStatement(node) {
      this.word("continue");
      printStatementAfterKeyword(this, node.label);
    }
    function ReturnStatement(node) {
      this.word("return");
      printStatementAfterKeyword(this, node.argument);
    }
    function ThrowStatement(node) {
      this.word("throw");
      printStatementAfterKeyword(this, node.argument);
    }
    function LabeledStatement(node) {
      this.print(node.label);
      this.tokenChar(58);
      this.space();
      this.print(node.body);
    }
    function TryStatement(node) {
      this.word("try");
      this.space();
      this.print(node.block);
      this.space();
      if (node.handlers) {
        this.print(node.handlers[0]);
      } else {
        this.print(node.handler);
      }
      if (node.finalizer) {
        this.space();
        this.word("finally");
        this.space();
        this.print(node.finalizer);
      }
    }
    function CatchClause(node) {
      this.word("catch");
      this.space();
      if (node.param) {
        this.tokenChar(40);
        this.print(node.param);
        this.print(node.param.typeAnnotation);
        this.tokenChar(41);
        this.space();
      }
      this.print(node.body);
    }
    function SwitchStatement(node) {
      this.word("switch");
      this.space();
      this.tokenChar(40);
      this.print(node.discriminant);
      this.tokenChar(41);
      this.space();
      this.tokenChar(123);
      this.printSequence(node.cases, true, void 0, function addNewlines(leading, cas) {
        if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
      });
      this.rightBrace(node);
    }
    function SwitchCase(node) {
      if (node.test) {
        this.word("case");
        this.space();
        this.print(node.test);
        this.tokenChar(58);
      } else {
        this.word("default");
        this.tokenChar(58);
      }
      if (node.consequent.length) {
        this.newline();
        this.printSequence(node.consequent, true);
      }
    }
    function DebuggerStatement() {
      this.word("debugger");
      this.semicolon();
    }
    function VariableDeclaration(node, parent) {
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      const {
        kind
      } = node;
      if (kind === "await using") {
        this.word("await");
        this.space();
        this.word("using", true);
      } else {
        this.word(kind, kind === "using");
      }
      this.space();
      let hasInits = false;
      if (!isFor(parent)) {
        for (const declar of node.declarations) {
          if (declar.init) {
            hasInits = true;
          }
        }
      }
      this.printList(node.declarations, void 0, void 0, node.declarations.length > 1, hasInits ? function(occurrenceCount) {
        this.token(",", false, occurrenceCount);
        this.newline();
      } : void 0);
      if (isFor(parent)) {
        if (isForStatement(parent)) {
          if (parent.init === node) return;
        } else {
          if (parent.left === node) return;
        }
      }
      this.semicolon();
    }
    function VariableDeclarator(node) {
      this.print(node.id);
      if (node.definite) this.tokenChar(33);
      this.print(node.id.typeAnnotation);
      if (node.init) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.init);
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/classes.js
var require_classes = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/classes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ClassAccessorProperty = ClassAccessorProperty;
    exports2.ClassBody = ClassBody;
    exports2.ClassExpression = exports2.ClassDeclaration = ClassDeclaration;
    exports2.ClassMethod = ClassMethod;
    exports2.ClassPrivateMethod = ClassPrivateMethod;
    exports2.ClassPrivateProperty = ClassPrivateProperty;
    exports2.ClassProperty = ClassProperty;
    exports2.StaticBlock = StaticBlock;
    exports2._classMethodHead = _classMethodHead;
    var _t = require("@babel/types");
    var {
      isExportDefaultDeclaration,
      isExportNamedDeclaration
    } = _t;
    function ClassDeclaration(node, parent) {
      const inExport = isExportDefaultDeclaration(parent) || isExportNamedDeclaration(parent);
      if (!inExport || !this._shouldPrintDecoratorsBeforeExport(parent)) {
        this.printJoin(node.decorators);
      }
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      if (node.abstract) {
        this.word("abstract");
        this.space();
      }
      this.word("class");
      if (node.id) {
        this.space();
        this.print(node.id);
      }
      this.print(node.typeParameters);
      if (node.superClass) {
        this.space();
        this.word("extends");
        this.space();
        this.print(node.superClass);
        this.print(node.superTypeParameters);
      }
      if (node.implements) {
        this.space();
        this.word("implements");
        this.space();
        this.printList(node.implements);
      }
      this.space();
      this.print(node.body);
    }
    function ClassBody(node) {
      this.tokenChar(123);
      if (node.body.length === 0) {
        this.tokenChar(125);
      } else {
        this.newline();
        const separator = classBodyEmptySemicolonsPrinter(this, node);
        separator == null || separator(-1);
        const exit = this.enterDelimited();
        this.printJoin(node.body, true, true, separator, true);
        exit();
        if (!this.endsWith(10)) this.newline();
        this.rightBrace(node);
      }
    }
    function classBodyEmptySemicolonsPrinter(printer, node) {
      if (!printer.tokenMap || node.start == null || node.end == null) {
        return null;
      }
      const indexes = printer.tokenMap.getIndexes(node);
      if (!indexes) return null;
      let k = 1;
      let occurrenceCount = 0;
      let nextLocIndex = 0;
      const advanceNextLocIndex = () => {
        while (nextLocIndex < node.body.length && node.body[nextLocIndex].start == null) {
          nextLocIndex++;
        }
      };
      advanceNextLocIndex();
      return (i) => {
        if (nextLocIndex <= i) {
          nextLocIndex = i + 1;
          advanceNextLocIndex();
        }
        const end = nextLocIndex === node.body.length ? node.end : node.body[nextLocIndex].start;
        let tok;
        while (k < indexes.length && printer.tokenMap.matchesOriginal(tok = printer._tokens[indexes[k]], ";") && tok.start < end) {
          printer.token(";", void 0, occurrenceCount++);
          k++;
        }
      };
    }
    function ClassProperty(node) {
      this.printJoin(node.decorators);
      if (!node.static && !this.format.preserveFormat) {
        var _node$key$loc;
        const endLine = (_node$key$loc = node.key.loc) == null || (_node$key$loc = _node$key$loc.end) == null ? void 0 : _node$key$loc.line;
        if (endLine) this.catchUp(endLine);
      }
      this.tsPrintClassMemberModifiers(node);
      if (node.computed) {
        this.tokenChar(91);
        this.print(node.key);
        this.tokenChar(93);
      } else {
        this._variance(node);
        this.print(node.key);
      }
      if (node.optional) {
        this.tokenChar(63);
      }
      if (node.definite) {
        this.tokenChar(33);
      }
      this.print(node.typeAnnotation);
      if (node.value) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.value);
      }
      this.semicolon();
    }
    function ClassAccessorProperty(node) {
      var _node$key$loc2;
      this.printJoin(node.decorators);
      const endLine = (_node$key$loc2 = node.key.loc) == null || (_node$key$loc2 = _node$key$loc2.end) == null ? void 0 : _node$key$loc2.line;
      if (endLine) this.catchUp(endLine);
      this.tsPrintClassMemberModifiers(node);
      this.word("accessor", true);
      this.space();
      if (node.computed) {
        this.tokenChar(91);
        this.print(node.key);
        this.tokenChar(93);
      } else {
        this._variance(node);
        this.print(node.key);
      }
      if (node.optional) {
        this.tokenChar(63);
      }
      if (node.definite) {
        this.tokenChar(33);
      }
      this.print(node.typeAnnotation);
      if (node.value) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.value);
      }
      this.semicolon();
    }
    function ClassPrivateProperty(node) {
      this.printJoin(node.decorators);
      this.tsPrintClassMemberModifiers(node);
      this.print(node.key);
      if (node.optional) {
        this.tokenChar(63);
      }
      if (node.definite) {
        this.tokenChar(33);
      }
      this.print(node.typeAnnotation);
      if (node.value) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.value);
      }
      this.semicolon();
    }
    function ClassMethod(node) {
      this._classMethodHead(node);
      this.space();
      this.print(node.body);
    }
    function ClassPrivateMethod(node) {
      this._classMethodHead(node);
      this.space();
      this.print(node.body);
    }
    function _classMethodHead(node) {
      this.printJoin(node.decorators);
      if (!this.format.preserveFormat) {
        var _node$key$loc3;
        const endLine = (_node$key$loc3 = node.key.loc) == null || (_node$key$loc3 = _node$key$loc3.end) == null ? void 0 : _node$key$loc3.line;
        if (endLine) this.catchUp(endLine);
      }
      this.tsPrintClassMemberModifiers(node);
      this._methodHead(node);
    }
    function StaticBlock(node) {
      this.word("static");
      this.space();
      this.tokenChar(123);
      if (node.body.length === 0) {
        this.tokenChar(125);
      } else {
        this.newline();
        this.printSequence(node.body, true);
        this.rightBrace(node);
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/methods.js
var require_methods = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/methods.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ArrowFunctionExpression = ArrowFunctionExpression;
    exports2.FunctionDeclaration = exports2.FunctionExpression = FunctionExpression11;
    exports2._functionHead = _functionHead;
    exports2._methodHead = _methodHead;
    exports2._param = _param;
    exports2._parameters = _parameters;
    exports2._params = _params;
    exports2._predicate = _predicate;
    exports2._shouldPrintArrowParamsParens = _shouldPrintArrowParamsParens;
    var _t = require("@babel/types");
    var _index = require_node2();
    var {
      isIdentifier
    } = _t;
    function _params(node, idNode, parentNode) {
      this.print(node.typeParameters);
      const nameInfo = _getFuncIdName.call(this, idNode, parentNode);
      if (nameInfo) {
        this.sourceIdentifierName(nameInfo.name, nameInfo.pos);
      }
      this.tokenChar(40);
      this._parameters(node.params, ")");
      const noLineTerminator = node.type === "ArrowFunctionExpression";
      this.print(node.returnType, noLineTerminator);
      this._noLineTerminator = noLineTerminator;
    }
    function _parameters(parameters, endToken) {
      const exit = this.enterDelimited();
      const trailingComma = this.shouldPrintTrailingComma(endToken);
      const paramLength = parameters.length;
      for (let i = 0; i < paramLength; i++) {
        this._param(parameters[i]);
        if (trailingComma || i < paramLength - 1) {
          this.token(",", null, i);
          this.space();
        }
      }
      this.token(endToken);
      exit();
    }
    function _param(parameter) {
      this.printJoin(parameter.decorators);
      this.print(parameter);
      if (parameter.optional) {
        this.tokenChar(63);
      }
      this.print(parameter.typeAnnotation);
    }
    function _methodHead(node) {
      const kind = node.kind;
      const key2 = node.key;
      if (kind === "get" || kind === "set") {
        this.word(kind);
        this.space();
      }
      if (node.async) {
        this.word("async", true);
        this.space();
      }
      if (kind === "method" || kind === "init") {
        if (node.generator) {
          this.tokenChar(42);
        }
      }
      if (node.computed) {
        this.tokenChar(91);
        this.print(key2);
        this.tokenChar(93);
      } else {
        this.print(key2);
      }
      if (node.optional) {
        this.tokenChar(63);
      }
      this._params(node, node.computed && node.key.type !== "StringLiteral" ? void 0 : node.key, void 0);
    }
    function _predicate(node, noLineTerminatorAfter) {
      if (node.predicate) {
        if (!node.returnType) {
          this.tokenChar(58);
        }
        this.space();
        this.print(node.predicate, noLineTerminatorAfter);
      }
    }
    function _functionHead(node, parent) {
      if (node.async) {
        this.word("async");
        if (!this.format.preserveFormat) {
          this._endsWithInnerRaw = false;
        }
        this.space();
      }
      this.word("function");
      if (node.generator) {
        if (!this.format.preserveFormat) {
          this._endsWithInnerRaw = false;
        }
        this.tokenChar(42);
      }
      this.space();
      if (node.id) {
        this.print(node.id);
      }
      this._params(node, node.id, parent);
      if (node.type !== "TSDeclareFunction") {
        this._predicate(node);
      }
    }
    function FunctionExpression11(node, parent) {
      this._functionHead(node, parent);
      this.space();
      this.print(node.body);
    }
    function ArrowFunctionExpression(node, parent) {
      if (node.async) {
        this.word("async", true);
        this.space();
      }
      if (this._shouldPrintArrowParamsParens(node)) {
        this._params(node, void 0, parent);
      } else {
        this.print(node.params[0], true);
      }
      this._predicate(node, true);
      this.space();
      this.printInnerComments();
      this.token("=>");
      this.space();
      this.tokenContext |= _index.TokenContext.arrowBody;
      this.print(node.body);
    }
    function _shouldPrintArrowParamsParens(node) {
      var _firstParam$leadingCo, _firstParam$trailingC;
      if (node.params.length !== 1) return true;
      if (node.typeParameters || node.returnType || node.predicate) {
        return true;
      }
      const firstParam = node.params[0];
      if (!isIdentifier(firstParam) || firstParam.typeAnnotation || firstParam.optional || (_firstParam$leadingCo = firstParam.leadingComments) != null && _firstParam$leadingCo.length || (_firstParam$trailingC = firstParam.trailingComments) != null && _firstParam$trailingC.length) {
        return true;
      }
      if (this.tokenMap) {
        if (node.loc == null) return true;
        if (this.tokenMap.findMatching(node, "(") !== null) return true;
        const arrowToken = this.tokenMap.findMatching(node, "=>");
        if ((arrowToken == null ? void 0 : arrowToken.loc) == null) return true;
        return arrowToken.loc.start.line !== node.loc.start.line;
      }
      if (this.format.retainLines) return true;
      return false;
    }
    function _getFuncIdName(idNode, parent) {
      let id = idNode;
      if (!id && parent) {
        const parentType = parent.type;
        if (parentType === "VariableDeclarator") {
          id = parent.id;
        } else if (parentType === "AssignmentExpression" || parentType === "AssignmentPattern") {
          id = parent.left;
        } else if (parentType === "ObjectProperty" || parentType === "ClassProperty") {
          if (!parent.computed || parent.key.type === "StringLiteral") {
            id = parent.key;
          }
        } else if (parentType === "ClassPrivateProperty" || parentType === "ClassAccessorProperty") {
          id = parent.key;
        }
      }
      if (!id) return;
      let nameInfo;
      if (id.type === "Identifier") {
        var _id$loc, _id$loc2;
        nameInfo = {
          pos: (_id$loc = id.loc) == null ? void 0 : _id$loc.start,
          name: ((_id$loc2 = id.loc) == null ? void 0 : _id$loc2.identifierName) || id.name
        };
      } else if (id.type === "PrivateName") {
        var _id$loc3;
        nameInfo = {
          pos: (_id$loc3 = id.loc) == null ? void 0 : _id$loc3.start,
          name: "#" + id.id.name
        };
      } else if (id.type === "StringLiteral") {
        var _id$loc4;
        nameInfo = {
          pos: (_id$loc4 = id.loc) == null ? void 0 : _id$loc4.start,
          name: id.value
        };
      }
      return nameInfo;
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/modules.js
var require_modules = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/modules.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ExportAllDeclaration = ExportAllDeclaration;
    exports2.ExportDefaultDeclaration = ExportDefaultDeclaration;
    exports2.ExportDefaultSpecifier = ExportDefaultSpecifier;
    exports2.ExportNamedDeclaration = ExportNamedDeclaration;
    exports2.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
    exports2.ExportSpecifier = ExportSpecifier;
    exports2.ImportAttribute = ImportAttribute;
    exports2.ImportDeclaration = ImportDeclaration;
    exports2.ImportDefaultSpecifier = ImportDefaultSpecifier;
    exports2.ImportExpression = ImportExpression;
    exports2.ImportNamespaceSpecifier = ImportNamespaceSpecifier;
    exports2.ImportSpecifier = ImportSpecifier;
    exports2._printAttributes = _printAttributes;
    var _t = require("@babel/types");
    var _index = require_node2();
    var {
      isClassDeclaration,
      isExportDefaultSpecifier,
      isExportNamespaceSpecifier,
      isImportDefaultSpecifier,
      isImportNamespaceSpecifier,
      isStatement: isStatement2
    } = _t;
    function ImportSpecifier(node) {
      if (node.importKind === "type" || node.importKind === "typeof") {
        this.word(node.importKind);
        this.space();
      }
      this.print(node.imported);
      if (node.local && node.local.name !== node.imported.name) {
        this.space();
        this.word("as");
        this.space();
        this.print(node.local);
      }
    }
    function ImportDefaultSpecifier(node) {
      this.print(node.local);
    }
    function ExportDefaultSpecifier(node) {
      this.print(node.exported);
    }
    function ExportSpecifier(node) {
      if (node.exportKind === "type") {
        this.word("type");
        this.space();
      }
      this.print(node.local);
      if (node.exported && node.local.name !== node.exported.name) {
        this.space();
        this.word("as");
        this.space();
        this.print(node.exported);
      }
    }
    function ExportNamespaceSpecifier(node) {
      this.tokenChar(42);
      this.space();
      this.word("as");
      this.space();
      this.print(node.exported);
    }
    var warningShown = false;
    function _printAttributes(node, hasPreviousBrace) {
      var _node$extra;
      const {
        importAttributesKeyword
      } = this.format;
      const {
        attributes,
        assertions
      } = node;
      if (attributes && !importAttributesKeyword && node.extra && (node.extra.deprecatedAssertSyntax || node.extra.deprecatedWithLegacySyntax) && !warningShown) {
        warningShown = true;
        console.warn(`You are using import attributes, without specifying the desired output syntax.
Please specify the "importAttributesKeyword" generator option, whose value can be one of:
 - "with"        : \`import { a } from "b" with { type: "json" };\`
 - "assert"      : \`import { a } from "b" assert { type: "json" };\`
 - "with-legacy" : \`import { a } from "b" with type: "json";\`
`);
      }
      const useAssertKeyword = importAttributesKeyword === "assert" || !importAttributesKeyword && assertions;
      this.word(useAssertKeyword ? "assert" : "with");
      this.space();
      if (!useAssertKeyword && (importAttributesKeyword === "with-legacy" || !importAttributesKeyword && (_node$extra = node.extra) != null && _node$extra.deprecatedWithLegacySyntax)) {
        this.printList(attributes || assertions);
        return;
      }
      const occurrenceCount = hasPreviousBrace ? 1 : 0;
      this.token("{", null, occurrenceCount);
      this.space();
      this.printList(attributes || assertions, this.shouldPrintTrailingComma("}"));
      this.space();
      this.token("}", null, occurrenceCount);
    }
    function ExportAllDeclaration(node) {
      var _node$attributes, _node$assertions;
      this.word("export");
      this.space();
      if (node.exportKind === "type") {
        this.word("type");
        this.space();
      }
      this.tokenChar(42);
      this.space();
      this.word("from");
      this.space();
      if ((_node$attributes = node.attributes) != null && _node$attributes.length || (_node$assertions = node.assertions) != null && _node$assertions.length) {
        this.print(node.source, true);
        this.space();
        this._printAttributes(node, false);
      } else {
        this.print(node.source);
      }
      this.semicolon();
    }
    function maybePrintDecoratorsBeforeExport(printer, node) {
      if (isClassDeclaration(node.declaration) && printer._shouldPrintDecoratorsBeforeExport(node)) {
        printer.printJoin(node.declaration.decorators);
      }
    }
    function ExportNamedDeclaration(node) {
      maybePrintDecoratorsBeforeExport(this, node);
      this.word("export");
      this.space();
      if (node.declaration) {
        const declar = node.declaration;
        this.print(declar);
        if (!isStatement2(declar)) this.semicolon();
      } else {
        if (node.exportKind === "type") {
          this.word("type");
          this.space();
        }
        const specifiers = node.specifiers.slice(0);
        let hasSpecial = false;
        for (; ; ) {
          const first = specifiers[0];
          if (isExportDefaultSpecifier(first) || isExportNamespaceSpecifier(first)) {
            hasSpecial = true;
            this.print(specifiers.shift());
            if (specifiers.length) {
              this.tokenChar(44);
              this.space();
            }
          } else {
            break;
          }
        }
        let hasBrace = false;
        if (specifiers.length || !specifiers.length && !hasSpecial) {
          hasBrace = true;
          this.tokenChar(123);
          if (specifiers.length) {
            this.space();
            this.printList(specifiers, this.shouldPrintTrailingComma("}"));
            this.space();
          }
          this.tokenChar(125);
        }
        if (node.source) {
          var _node$attributes2, _node$assertions2;
          this.space();
          this.word("from");
          this.space();
          if ((_node$attributes2 = node.attributes) != null && _node$attributes2.length || (_node$assertions2 = node.assertions) != null && _node$assertions2.length) {
            this.print(node.source, true);
            this.space();
            this._printAttributes(node, hasBrace);
          } else {
            this.print(node.source);
          }
        }
        this.semicolon();
      }
    }
    function ExportDefaultDeclaration(node) {
      maybePrintDecoratorsBeforeExport(this, node);
      this.word("export");
      this.noIndentInnerCommentsHere();
      this.space();
      this.word("default");
      this.space();
      this.tokenContext |= _index.TokenContext.exportDefault;
      const declar = node.declaration;
      this.print(declar);
      if (!isStatement2(declar)) this.semicolon();
    }
    function ImportDeclaration(node) {
      var _node$attributes3, _node$assertions3;
      this.word("import");
      this.space();
      const isTypeKind = node.importKind === "type" || node.importKind === "typeof";
      if (isTypeKind) {
        this.noIndentInnerCommentsHere();
        this.word(node.importKind);
        this.space();
      } else if (node.module) {
        this.noIndentInnerCommentsHere();
        this.word("module");
        this.space();
      } else if (node.phase) {
        this.noIndentInnerCommentsHere();
        this.word(node.phase);
        this.space();
      }
      const specifiers = node.specifiers.slice(0);
      const hasSpecifiers = !!specifiers.length;
      while (hasSpecifiers) {
        const first = specifiers[0];
        if (isImportDefaultSpecifier(first) || isImportNamespaceSpecifier(first)) {
          this.print(specifiers.shift());
          if (specifiers.length) {
            this.tokenChar(44);
            this.space();
          }
        } else {
          break;
        }
      }
      let hasBrace = false;
      if (specifiers.length) {
        hasBrace = true;
        this.tokenChar(123);
        this.space();
        this.printList(specifiers, this.shouldPrintTrailingComma("}"));
        this.space();
        this.tokenChar(125);
      } else if (isTypeKind && !hasSpecifiers) {
        hasBrace = true;
        this.tokenChar(123);
        this.tokenChar(125);
      }
      if (hasSpecifiers || isTypeKind) {
        this.space();
        this.word("from");
        this.space();
      }
      if ((_node$attributes3 = node.attributes) != null && _node$attributes3.length || (_node$assertions3 = node.assertions) != null && _node$assertions3.length) {
        this.print(node.source, true);
        this.space();
        this._printAttributes(node, hasBrace);
      } else {
        this.print(node.source);
      }
      this.semicolon();
    }
    function ImportAttribute(node) {
      this.print(node.key);
      this.tokenChar(58);
      this.space();
      this.print(node.value);
    }
    function ImportNamespaceSpecifier(node) {
      this.tokenChar(42);
      this.space();
      this.word("as");
      this.space();
      this.print(node.local);
    }
    function ImportExpression(node) {
      this.word("import");
      if (node.phase) {
        this.tokenChar(46);
        this.word(node.phase);
      }
      this.tokenChar(40);
      this.print(node.source);
      if (node.options != null) {
        this.tokenChar(44);
        this.space();
        this.print(node.options);
      }
      this.tokenChar(41);
    }
  }
});

// node_modules/@babel/helpers/node_modules/jsesc/jsesc.js
var require_jsesc = __commonJS({
  "node_modules/@babel/helpers/node_modules/jsesc/jsesc.js"(exports2, module2) {
    "use strict";
    var object2 = {};
    var hasOwnProperty3 = object2.hasOwnProperty;
    var forOwn = (object3, callback) => {
      for (const key2 in object3) {
        if (hasOwnProperty3.call(object3, key2)) {
          callback(key2, object3[key2]);
        }
      }
    };
    var extend2 = (destination, source2) => {
      if (!source2) {
        return destination;
      }
      forOwn(source2, (key2, value) => {
        destination[key2] = value;
      });
      return destination;
    };
    var forEach = (array2, callback) => {
      const length = array2.length;
      let index = -1;
      while (++index < length) {
        callback(array2[index]);
      }
    };
    var fourHexEscape = (hex3) => {
      return "\\u" + ("0000" + hex3).slice(-4);
    };
    var hexadecimal = (code, lowercase2) => {
      let hexadecimal2 = code.toString(16);
      if (lowercase2) return hexadecimal2;
      return hexadecimal2.toUpperCase();
    };
    var toString = object2.toString;
    var isArray = Array.isArray;
    var isBuffer = (value) => {
      return typeof Buffer === "function" && Buffer.isBuffer(value);
    };
    var isObject2 = (value) => {
      return toString.call(value) == "[object Object]";
    };
    var isString = (value) => {
      return typeof value == "string" || toString.call(value) == "[object String]";
    };
    var isNumber = (value) => {
      return typeof value == "number" || toString.call(value) == "[object Number]";
    };
    var isBigInt = (value) => {
      return typeof value == "bigint";
    };
    var isFunction = (value) => {
      return typeof value == "function";
    };
    var isMap = (value) => {
      return toString.call(value) == "[object Map]";
    };
    var isSet = (value) => {
      return toString.call(value) == "[object Set]";
    };
    var singleEscapes = {
      "\\": "\\\\",
      "\b": "\\b",
      "\f": "\\f",
      "\n": "\\n",
      "\r": "\\r",
      "	": "\\t"
      // `\v` is omitted intentionally, because in IE < 9, '\v' == 'v'.
      // '\v': '\\x0B'
    };
    var regexSingleEscape = /[\\\b\f\n\r\t]/;
    var regexDigit = /[0-9]/;
    var regexWhitespace = /[\xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/;
    var escapeEverythingRegex = /([\uD800-\uDBFF][\uDC00-\uDFFF])|([\uD800-\uDFFF])|(['"`])|[^]/g;
    var escapeNonAsciiRegex = /([\uD800-\uDBFF][\uDC00-\uDFFF])|([\uD800-\uDFFF])|(['"`])|[^ !#-&\(-\[\]-_a-~]/g;
    var jsesc = (argument, options) => {
      const increaseIndentation = () => {
        oldIndent = indent;
        ++options.indentLevel;
        indent = options.indent.repeat(options.indentLevel);
      };
      const defaults = {
        "escapeEverything": false,
        "minimal": false,
        "isScriptContext": false,
        "quotes": "single",
        "wrap": false,
        "es6": false,
        "json": false,
        "compact": true,
        "lowercaseHex": false,
        "numbers": "decimal",
        "indent": "	",
        "indentLevel": 0,
        "__inline1__": false,
        "__inline2__": false
      };
      const json2 = options && options.json;
      if (json2) {
        defaults.quotes = "double";
        defaults.wrap = true;
      }
      options = extend2(defaults, options);
      if (options.quotes != "single" && options.quotes != "double" && options.quotes != "backtick") {
        options.quotes = "single";
      }
      const quote = options.quotes == "double" ? '"' : options.quotes == "backtick" ? "`" : "'";
      const compact = options.compact;
      const lowercaseHex = options.lowercaseHex;
      let indent = options.indent.repeat(options.indentLevel);
      let oldIndent = "";
      const inline1 = options.__inline1__;
      const inline2 = options.__inline2__;
      const newLine = compact ? "" : "\n";
      let result;
      let isEmpty = true;
      const useBinNumbers = options.numbers == "binary";
      const useOctNumbers = options.numbers == "octal";
      const useDecNumbers = options.numbers == "decimal";
      const useHexNumbers = options.numbers == "hexadecimal";
      if (json2 && argument && isFunction(argument.toJSON)) {
        argument = argument.toJSON();
      }
      if (!isString(argument)) {
        if (isMap(argument)) {
          if (argument.size == 0) {
            return "new Map()";
          }
          if (!compact) {
            options.__inline1__ = true;
            options.__inline2__ = false;
          }
          return "new Map(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isSet(argument)) {
          if (argument.size == 0) {
            return "new Set()";
          }
          return "new Set(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isBuffer(argument)) {
          if (argument.length == 0) {
            return "Buffer.from([])";
          }
          return "Buffer.from(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isArray(argument)) {
          result = [];
          options.wrap = true;
          if (inline1) {
            options.__inline1__ = false;
            options.__inline2__ = true;
          }
          if (!inline2) {
            increaseIndentation();
          }
          forEach(argument, (value) => {
            isEmpty = false;
            if (inline2) {
              options.__inline2__ = false;
            }
            result.push(
              (compact || inline2 ? "" : indent) + jsesc(value, options)
            );
          });
          if (isEmpty) {
            return "[]";
          }
          if (inline2) {
            return "[" + result.join(", ") + "]";
          }
          return "[" + newLine + result.join("," + newLine) + newLine + (compact ? "" : oldIndent) + "]";
        } else if (isNumber(argument) || isBigInt(argument)) {
          if (json2) {
            return JSON.stringify(Number(argument));
          }
          let result2;
          if (useDecNumbers) {
            result2 = String(argument);
          } else if (useHexNumbers) {
            let hexadecimal2 = argument.toString(16);
            if (!lowercaseHex) {
              hexadecimal2 = hexadecimal2.toUpperCase();
            }
            result2 = "0x" + hexadecimal2;
          } else if (useBinNumbers) {
            result2 = "0b" + argument.toString(2);
          } else if (useOctNumbers) {
            result2 = "0o" + argument.toString(8);
          }
          if (isBigInt(argument)) {
            return result2 + "n";
          }
          return result2;
        } else if (isBigInt(argument)) {
          if (json2) {
            return JSON.stringify(Number(argument));
          }
          return argument + "n";
        } else if (!isObject2(argument)) {
          if (json2) {
            return JSON.stringify(argument) || "null";
          }
          return String(argument);
        } else {
          result = [];
          options.wrap = true;
          increaseIndentation();
          forOwn(argument, (key2, value) => {
            isEmpty = false;
            result.push(
              (compact ? "" : indent) + jsesc(key2, options) + ":" + (compact ? "" : " ") + jsesc(value, options)
            );
          });
          if (isEmpty) {
            return "{}";
          }
          return "{" + newLine + result.join("," + newLine) + newLine + (compact ? "" : oldIndent) + "}";
        }
      }
      const regex = options.escapeEverything ? escapeEverythingRegex : escapeNonAsciiRegex;
      result = argument.replace(regex, (char, pair, lone, quoteChar, index, string4) => {
        if (pair) {
          if (options.minimal) return pair;
          const first = pair.charCodeAt(0);
          const second = pair.charCodeAt(1);
          if (options.es6) {
            const codePoint = (first - 55296) * 1024 + second - 56320 + 65536;
            const hex4 = hexadecimal(codePoint, lowercaseHex);
            return "\\u{" + hex4 + "}";
          }
          return fourHexEscape(hexadecimal(first, lowercaseHex)) + fourHexEscape(hexadecimal(second, lowercaseHex));
        }
        if (lone) {
          return fourHexEscape(hexadecimal(lone.charCodeAt(0), lowercaseHex));
        }
        if (char == "\0" && !json2 && !regexDigit.test(string4.charAt(index + 1))) {
          return "\\0";
        }
        if (quoteChar) {
          if (quoteChar == quote || options.escapeEverything) {
            return "\\" + quoteChar;
          }
          return quoteChar;
        }
        if (regexSingleEscape.test(char)) {
          return singleEscapes[char];
        }
        if (options.minimal && !regexWhitespace.test(char)) {
          return char;
        }
        const hex3 = hexadecimal(char.charCodeAt(0), lowercaseHex);
        if (json2 || hex3.length > 2) {
          return fourHexEscape(hex3);
        }
        return "\\x" + ("00" + hex3).slice(-2);
      });
      if (quote == "`") {
        result = result.replace(/\$\{/g, "\\${");
      }
      if (options.isScriptContext) {
        result = result.replace(/<\/(script|style)/gi, "<\\/$1").replace(/<!--/g, json2 ? "\\u003C!--" : "\\x3C!--");
      }
      if (options.wrap) {
        result = quote + result + quote;
      }
      return result;
    };
    jsesc.version = "3.0.2";
    module2.exports = jsesc;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/types.js
var require_types = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ArgumentPlaceholder = ArgumentPlaceholder;
    exports2.ArrayPattern = exports2.ArrayExpression = ArrayExpression6;
    exports2.BigIntLiteral = BigIntLiteral;
    exports2.BooleanLiteral = BooleanLiteral;
    exports2.Identifier = Identifier25;
    exports2.NullLiteral = NullLiteral;
    exports2.NumericLiteral = NumericLiteral;
    exports2.ObjectPattern = exports2.ObjectExpression = ObjectExpression;
    exports2.ObjectMethod = ObjectMethod4;
    exports2.ObjectProperty = ObjectProperty4;
    exports2.PipelineBareFunction = PipelineBareFunction;
    exports2.PipelinePrimaryTopicReference = PipelinePrimaryTopicReference;
    exports2.PipelineTopicExpression = PipelineTopicExpression;
    exports2.RecordExpression = RecordExpression;
    exports2.RegExpLiteral = RegExpLiteral;
    exports2.SpreadElement = exports2.RestElement = RestElement;
    exports2.StringLiteral = StringLiteral;
    exports2.TopicReference = TopicReference;
    exports2.TupleExpression = TupleExpression;
    exports2._getRawIdentifier = _getRawIdentifier;
    var _t = require("@babel/types");
    var _jsesc = require_jsesc();
    var {
      isAssignmentPattern,
      isIdentifier
    } = _t;
    var lastRawIdentNode = null;
    var lastRawIdentResult = "";
    function _getRawIdentifier(node) {
      if (node === lastRawIdentNode) return lastRawIdentResult;
      lastRawIdentNode = node;
      const {
        name
      } = node;
      const token2 = this.tokenMap.find(node, (tok) => tok.value === name);
      if (token2) {
        lastRawIdentResult = this._originalCode.slice(token2.start, token2.end);
        return lastRawIdentResult;
      }
      return lastRawIdentResult = node.name;
    }
    function Identifier25(node) {
      var _node$loc;
      this.sourceIdentifierName(((_node$loc = node.loc) == null ? void 0 : _node$loc.identifierName) || node.name);
      this.word(this.tokenMap ? this._getRawIdentifier(node) : node.name);
    }
    function ArgumentPlaceholder() {
      this.tokenChar(63);
    }
    function RestElement(node) {
      this.token("...");
      this.print(node.argument);
    }
    function ObjectExpression(node) {
      const props = node.properties;
      this.tokenChar(123);
      if (props.length) {
        const exit = this.enterDelimited();
        this.space();
        this.printList(props, this.shouldPrintTrailingComma("}"), true, true);
        this.space();
        exit();
      }
      this.sourceWithOffset("end", node.loc, -1);
      this.tokenChar(125);
    }
    function ObjectMethod4(node) {
      this.printJoin(node.decorators);
      this._methodHead(node);
      this.space();
      this.print(node.body);
    }
    function ObjectProperty4(node) {
      this.printJoin(node.decorators);
      if (node.computed) {
        this.tokenChar(91);
        this.print(node.key);
        this.tokenChar(93);
      } else {
        if (isAssignmentPattern(node.value) && isIdentifier(node.key) && node.key.name === node.value.left.name) {
          this.print(node.value);
          return;
        }
        this.print(node.key);
        if (node.shorthand && isIdentifier(node.key) && isIdentifier(node.value) && node.key.name === node.value.name) {
          return;
        }
      }
      this.tokenChar(58);
      this.space();
      this.print(node.value);
    }
    function ArrayExpression6(node) {
      const elems = node.elements;
      const len = elems.length;
      this.tokenChar(91);
      const exit = this.enterDelimited();
      for (let i = 0; i < elems.length; i++) {
        const elem = elems[i];
        if (elem) {
          if (i > 0) this.space();
          this.print(elem);
          if (i < len - 1 || this.shouldPrintTrailingComma("]")) {
            this.token(",", false, i);
          }
        } else {
          this.token(",", false, i);
        }
      }
      exit();
      this.tokenChar(93);
    }
    function RecordExpression(node) {
      const props = node.properties;
      let startToken;
      let endToken;
      {
        if (this.format.recordAndTupleSyntaxType === "bar") {
          startToken = "{|";
          endToken = "|}";
        } else if (this.format.recordAndTupleSyntaxType !== "hash" && this.format.recordAndTupleSyntaxType != null) {
          throw new Error(`The "recordAndTupleSyntaxType" generator option must be "bar" or "hash" (${JSON.stringify(this.format.recordAndTupleSyntaxType)} received).`);
        } else {
          startToken = "#{";
          endToken = "}";
        }
      }
      this.token(startToken);
      if (props.length) {
        this.space();
        this.printList(props, this.shouldPrintTrailingComma(endToken), true, true);
        this.space();
      }
      this.token(endToken);
    }
    function TupleExpression(node) {
      const elems = node.elements;
      const len = elems.length;
      let startToken;
      let endToken;
      {
        if (this.format.recordAndTupleSyntaxType === "bar") {
          startToken = "[|";
          endToken = "|]";
        } else if (this.format.recordAndTupleSyntaxType === "hash") {
          startToken = "#[";
          endToken = "]";
        } else {
          throw new Error(`${this.format.recordAndTupleSyntaxType} is not a valid recordAndTuple syntax type`);
        }
      }
      this.token(startToken);
      for (let i = 0; i < elems.length; i++) {
        const elem = elems[i];
        if (elem) {
          if (i > 0) this.space();
          this.print(elem);
          if (i < len - 1 || this.shouldPrintTrailingComma(endToken)) {
            this.token(",", false, i);
          }
        }
      }
      this.token(endToken);
    }
    function RegExpLiteral(node) {
      this.word(`/${node.pattern}/${node.flags}`);
    }
    function BooleanLiteral(node) {
      this.word(node.value ? "true" : "false");
    }
    function NullLiteral() {
      this.word("null");
    }
    function NumericLiteral(node) {
      const raw = this.getPossibleRaw(node);
      const opts = this.format.jsescOption;
      const value = node.value;
      const str = value + "";
      if (opts.numbers) {
        this.number(_jsesc(value, opts), value);
      } else if (raw == null) {
        this.number(str, value);
      } else if (this.format.minified) {
        this.number(raw.length < str.length ? raw : str, value);
      } else {
        this.number(raw, value);
      }
    }
    function StringLiteral(node) {
      const raw = this.getPossibleRaw(node);
      if (!this.format.minified && raw !== void 0) {
        this.token(raw);
        return;
      }
      const val = _jsesc(node.value, this.format.jsescOption);
      this.token(val);
    }
    function BigIntLiteral(node) {
      const raw = this.getPossibleRaw(node);
      if (!this.format.minified && raw !== void 0) {
        this.word(raw);
        return;
      }
      this.word(node.value + "n");
    }
    var validTopicTokenSet = /* @__PURE__ */ new Set(["^^", "@@", "^", "%", "#"]);
    function TopicReference() {
      const {
        topicToken
      } = this.format;
      if (validTopicTokenSet.has(topicToken)) {
        this.token(topicToken);
      } else {
        const givenTopicTokenJSON = JSON.stringify(topicToken);
        const validTopics = Array.from(validTopicTokenSet, (v) => JSON.stringify(v));
        throw new Error(`The "topicToken" generator option must be one of ${validTopics.join(", ")} (${givenTopicTokenJSON} received instead).`);
      }
    }
    function PipelineTopicExpression(node) {
      this.print(node.expression);
    }
    function PipelineBareFunction(node) {
      this.print(node.callee);
    }
    function PipelinePrimaryTopicReference() {
      this.tokenChar(35);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/flow.js
var require_flow = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/flow.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.AnyTypeAnnotation = AnyTypeAnnotation;
    exports2.ArrayTypeAnnotation = ArrayTypeAnnotation;
    exports2.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
    exports2.BooleanTypeAnnotation = BooleanTypeAnnotation;
    exports2.DeclareClass = DeclareClass;
    exports2.DeclareExportAllDeclaration = DeclareExportAllDeclaration;
    exports2.DeclareExportDeclaration = DeclareExportDeclaration;
    exports2.DeclareFunction = DeclareFunction;
    exports2.DeclareInterface = DeclareInterface;
    exports2.DeclareModule = DeclareModule;
    exports2.DeclareModuleExports = DeclareModuleExports;
    exports2.DeclareOpaqueType = DeclareOpaqueType;
    exports2.DeclareTypeAlias = DeclareTypeAlias;
    exports2.DeclareVariable = DeclareVariable;
    exports2.DeclaredPredicate = DeclaredPredicate;
    exports2.EmptyTypeAnnotation = EmptyTypeAnnotation;
    exports2.EnumBooleanBody = EnumBooleanBody;
    exports2.EnumBooleanMember = EnumBooleanMember;
    exports2.EnumDeclaration = EnumDeclaration;
    exports2.EnumDefaultedMember = EnumDefaultedMember;
    exports2.EnumNumberBody = EnumNumberBody;
    exports2.EnumNumberMember = EnumNumberMember;
    exports2.EnumStringBody = EnumStringBody;
    exports2.EnumStringMember = EnumStringMember;
    exports2.EnumSymbolBody = EnumSymbolBody;
    exports2.ExistsTypeAnnotation = ExistsTypeAnnotation;
    exports2.FunctionTypeAnnotation = FunctionTypeAnnotation;
    exports2.FunctionTypeParam = FunctionTypeParam;
    exports2.IndexedAccessType = IndexedAccessType;
    exports2.InferredPredicate = InferredPredicate;
    exports2.InterfaceDeclaration = InterfaceDeclaration;
    exports2.GenericTypeAnnotation = exports2.ClassImplements = exports2.InterfaceExtends = InterfaceExtends;
    exports2.InterfaceTypeAnnotation = InterfaceTypeAnnotation;
    exports2.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
    exports2.MixedTypeAnnotation = MixedTypeAnnotation;
    exports2.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
    exports2.NullableTypeAnnotation = NullableTypeAnnotation;
    Object.defineProperty(exports2, "NumberLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _types2.NumericLiteral;
      }
    });
    exports2.NumberTypeAnnotation = NumberTypeAnnotation;
    exports2.ObjectTypeAnnotation = ObjectTypeAnnotation;
    exports2.ObjectTypeCallProperty = ObjectTypeCallProperty;
    exports2.ObjectTypeIndexer = ObjectTypeIndexer;
    exports2.ObjectTypeInternalSlot = ObjectTypeInternalSlot;
    exports2.ObjectTypeProperty = ObjectTypeProperty;
    exports2.ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
    exports2.OpaqueType = OpaqueType;
    exports2.OptionalIndexedAccessType = OptionalIndexedAccessType;
    exports2.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
    Object.defineProperty(exports2, "StringLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _types2.StringLiteral;
      }
    });
    exports2.StringTypeAnnotation = StringTypeAnnotation;
    exports2.SymbolTypeAnnotation = SymbolTypeAnnotation;
    exports2.ThisTypeAnnotation = ThisTypeAnnotation;
    exports2.TupleTypeAnnotation = TupleTypeAnnotation;
    exports2.TypeAlias = TypeAlias;
    exports2.TypeAnnotation = TypeAnnotation;
    exports2.TypeCastExpression = TypeCastExpression;
    exports2.TypeParameter = TypeParameter;
    exports2.TypeParameterDeclaration = exports2.TypeParameterInstantiation = TypeParameterInstantiation;
    exports2.TypeofTypeAnnotation = TypeofTypeAnnotation;
    exports2.UnionTypeAnnotation = UnionTypeAnnotation;
    exports2.Variance = Variance;
    exports2.VoidTypeAnnotation = VoidTypeAnnotation;
    exports2._interfaceish = _interfaceish;
    exports2._variance = _variance;
    var _t = require("@babel/types");
    var _modules = require_modules();
    var _index = require_node2();
    var _types2 = require_types();
    var {
      isDeclareExportDeclaration,
      isStatement: isStatement2
    } = _t;
    function AnyTypeAnnotation() {
      this.word("any");
    }
    function ArrayTypeAnnotation(node) {
      this.print(node.elementType, true);
      this.tokenChar(91);
      this.tokenChar(93);
    }
    function BooleanTypeAnnotation() {
      this.word("boolean");
    }
    function BooleanLiteralTypeAnnotation(node) {
      this.word(node.value ? "true" : "false");
    }
    function NullLiteralTypeAnnotation() {
      this.word("null");
    }
    function DeclareClass(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("class");
      this.space();
      this._interfaceish(node);
    }
    function DeclareFunction(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("function");
      this.space();
      this.print(node.id);
      this.print(node.id.typeAnnotation.typeAnnotation);
      if (node.predicate) {
        this.space();
        this.print(node.predicate);
      }
      this.semicolon();
    }
    function InferredPredicate() {
      this.tokenChar(37);
      this.word("checks");
    }
    function DeclaredPredicate(node) {
      this.tokenChar(37);
      this.word("checks");
      this.tokenChar(40);
      this.print(node.value);
      this.tokenChar(41);
    }
    function DeclareInterface(node) {
      this.word("declare");
      this.space();
      this.InterfaceDeclaration(node);
    }
    function DeclareModule(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.space();
      this.print(node.id);
      this.space();
      this.print(node.body);
    }
    function DeclareModuleExports(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.tokenChar(46);
      this.word("exports");
      this.print(node.typeAnnotation);
    }
    function DeclareTypeAlias(node) {
      this.word("declare");
      this.space();
      this.TypeAlias(node);
    }
    function DeclareOpaqueType(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.OpaqueType(node);
    }
    function DeclareVariable(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("var");
      this.space();
      this.print(node.id);
      this.print(node.id.typeAnnotation);
      this.semicolon();
    }
    function DeclareExportDeclaration(node) {
      this.word("declare");
      this.space();
      this.word("export");
      this.space();
      if (node.default) {
        this.word("default");
        this.space();
      }
      FlowExportDeclaration.call(this, node);
    }
    function DeclareExportAllDeclaration(node) {
      this.word("declare");
      this.space();
      _modules.ExportAllDeclaration.call(this, node);
    }
    function EnumDeclaration(node) {
      const {
        id,
        body
      } = node;
      this.word("enum");
      this.space();
      this.print(id);
      this.print(body);
    }
    function enumExplicitType(context, name, hasExplicitType) {
      if (hasExplicitType) {
        context.space();
        context.word("of");
        context.space();
        context.word(name);
      }
      context.space();
    }
    function enumBody(context, node) {
      const {
        members
      } = node;
      context.token("{");
      context.indent();
      context.newline();
      for (const member of members) {
        context.print(member);
        context.newline();
      }
      if (node.hasUnknownMembers) {
        context.token("...");
        context.newline();
      }
      context.dedent();
      context.token("}");
    }
    function EnumBooleanBody(node) {
      const {
        explicitType
      } = node;
      enumExplicitType(this, "boolean", explicitType);
      enumBody(this, node);
    }
    function EnumNumberBody(node) {
      const {
        explicitType
      } = node;
      enumExplicitType(this, "number", explicitType);
      enumBody(this, node);
    }
    function EnumStringBody(node) {
      const {
        explicitType
      } = node;
      enumExplicitType(this, "string", explicitType);
      enumBody(this, node);
    }
    function EnumSymbolBody(node) {
      enumExplicitType(this, "symbol", true);
      enumBody(this, node);
    }
    function EnumDefaultedMember(node) {
      const {
        id
      } = node;
      this.print(id);
      this.tokenChar(44);
    }
    function enumInitializedMember(context, node) {
      context.print(node.id);
      context.space();
      context.token("=");
      context.space();
      context.print(node.init);
      context.token(",");
    }
    function EnumBooleanMember(node) {
      enumInitializedMember(this, node);
    }
    function EnumNumberMember(node) {
      enumInitializedMember(this, node);
    }
    function EnumStringMember(node) {
      enumInitializedMember(this, node);
    }
    function FlowExportDeclaration(node) {
      if (node.declaration) {
        const declar = node.declaration;
        this.print(declar);
        if (!isStatement2(declar)) this.semicolon();
      } else {
        this.tokenChar(123);
        if (node.specifiers.length) {
          this.space();
          this.printList(node.specifiers);
          this.space();
        }
        this.tokenChar(125);
        if (node.source) {
          this.space();
          this.word("from");
          this.space();
          this.print(node.source);
        }
        this.semicolon();
      }
    }
    function ExistsTypeAnnotation() {
      this.tokenChar(42);
    }
    function FunctionTypeAnnotation(node, parent) {
      this.print(node.typeParameters);
      this.tokenChar(40);
      if (node.this) {
        this.word("this");
        this.tokenChar(58);
        this.space();
        this.print(node.this.typeAnnotation);
        if (node.params.length || node.rest) {
          this.tokenChar(44);
          this.space();
        }
      }
      this.printList(node.params);
      if (node.rest) {
        if (node.params.length) {
          this.tokenChar(44);
          this.space();
        }
        this.token("...");
        this.print(node.rest);
      }
      this.tokenChar(41);
      const type = parent == null ? void 0 : parent.type;
      if (type != null && (type === "ObjectTypeCallProperty" || type === "ObjectTypeInternalSlot" || type === "DeclareFunction" || type === "ObjectTypeProperty" && parent.method)) {
        this.tokenChar(58);
      } else {
        this.space();
        this.token("=>");
      }
      this.space();
      this.print(node.returnType);
    }
    function FunctionTypeParam(node) {
      this.print(node.name);
      if (node.optional) this.tokenChar(63);
      if (node.name) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.typeAnnotation);
    }
    function InterfaceExtends(node) {
      this.print(node.id);
      this.print(node.typeParameters, true);
    }
    function _interfaceish(node) {
      var _node$extends;
      this.print(node.id);
      this.print(node.typeParameters);
      if ((_node$extends = node.extends) != null && _node$extends.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends);
      }
      if (node.type === "DeclareClass") {
        var _node$mixins, _node$implements;
        if ((_node$mixins = node.mixins) != null && _node$mixins.length) {
          this.space();
          this.word("mixins");
          this.space();
          this.printList(node.mixins);
        }
        if ((_node$implements = node.implements) != null && _node$implements.length) {
          this.space();
          this.word("implements");
          this.space();
          this.printList(node.implements);
        }
      }
      this.space();
      this.print(node.body);
    }
    function _variance(node) {
      var _node$variance;
      const kind = (_node$variance = node.variance) == null ? void 0 : _node$variance.kind;
      if (kind != null) {
        if (kind === "plus") {
          this.tokenChar(43);
        } else if (kind === "minus") {
          this.tokenChar(45);
        }
      }
    }
    function InterfaceDeclaration(node) {
      this.word("interface");
      this.space();
      this._interfaceish(node);
    }
    function andSeparator(occurrenceCount) {
      this.space();
      this.token("&", false, occurrenceCount);
      this.space();
    }
    function InterfaceTypeAnnotation(node) {
      var _node$extends2;
      this.word("interface");
      if ((_node$extends2 = node.extends) != null && _node$extends2.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends);
      }
      this.space();
      this.print(node.body);
    }
    function IntersectionTypeAnnotation(node) {
      this.printJoin(node.types, void 0, void 0, andSeparator);
    }
    function MixedTypeAnnotation() {
      this.word("mixed");
    }
    function EmptyTypeAnnotation() {
      this.word("empty");
    }
    function NullableTypeAnnotation(node) {
      this.tokenChar(63);
      this.print(node.typeAnnotation);
    }
    function NumberTypeAnnotation() {
      this.word("number");
    }
    function StringTypeAnnotation() {
      this.word("string");
    }
    function ThisTypeAnnotation() {
      this.word("this");
    }
    function TupleTypeAnnotation(node) {
      this.tokenChar(91);
      this.printList(node.types);
      this.tokenChar(93);
    }
    function TypeofTypeAnnotation(node) {
      this.word("typeof");
      this.space();
      this.print(node.argument);
    }
    function TypeAlias(node) {
      this.word("type");
      this.space();
      this.print(node.id);
      this.print(node.typeParameters);
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.right);
      this.semicolon();
    }
    function TypeAnnotation(node, parent) {
      this.tokenChar(58);
      this.space();
      if (parent.type === "ArrowFunctionExpression") {
        this.tokenContext |= _index.TokenContext.arrowFlowReturnType;
      } else if (node.optional) {
        this.tokenChar(63);
      }
      this.print(node.typeAnnotation);
    }
    function TypeParameterInstantiation(node) {
      this.tokenChar(60);
      this.printList(node.params);
      this.tokenChar(62);
    }
    function TypeParameter(node) {
      this._variance(node);
      this.word(node.name);
      if (node.bound) {
        this.print(node.bound);
      }
      if (node.default) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.default);
      }
    }
    function OpaqueType(node) {
      this.word("opaque");
      this.space();
      this.word("type");
      this.space();
      this.print(node.id);
      this.print(node.typeParameters);
      if (node.supertype) {
        this.tokenChar(58);
        this.space();
        this.print(node.supertype);
      }
      if (node.impltype) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.impltype);
      }
      this.semicolon();
    }
    function ObjectTypeAnnotation(node) {
      if (node.exact) {
        this.token("{|");
      } else {
        this.tokenChar(123);
      }
      const props = [...node.properties, ...node.callProperties || [], ...node.indexers || [], ...node.internalSlots || []];
      if (props.length) {
        this.newline();
        this.space();
        this.printJoin(props, true, true, void 0, void 0, function addNewlines(leading) {
          if (leading && !props[0]) return 1;
        }, () => {
          if (props.length !== 1 || node.inexact) {
            this.tokenChar(44);
            this.space();
          }
        });
        this.space();
      }
      if (node.inexact) {
        this.indent();
        this.token("...");
        if (props.length) {
          this.newline();
        }
        this.dedent();
      }
      if (node.exact) {
        this.token("|}");
      } else {
        this.tokenChar(125);
      }
    }
    function ObjectTypeInternalSlot(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.tokenChar(91);
      this.tokenChar(91);
      this.print(node.id);
      this.tokenChar(93);
      this.tokenChar(93);
      if (node.optional) this.tokenChar(63);
      if (!node.method) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.value);
    }
    function ObjectTypeCallProperty(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.print(node.value);
    }
    function ObjectTypeIndexer(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this._variance(node);
      this.tokenChar(91);
      if (node.id) {
        this.print(node.id);
        this.tokenChar(58);
        this.space();
      }
      this.print(node.key);
      this.tokenChar(93);
      this.tokenChar(58);
      this.space();
      this.print(node.value);
    }
    function ObjectTypeProperty(node) {
      if (node.proto) {
        this.word("proto");
        this.space();
      }
      if (node.static) {
        this.word("static");
        this.space();
      }
      if (node.kind === "get" || node.kind === "set") {
        this.word(node.kind);
        this.space();
      }
      this._variance(node);
      this.print(node.key);
      if (node.optional) this.tokenChar(63);
      if (!node.method) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.value);
    }
    function ObjectTypeSpreadProperty(node) {
      this.token("...");
      this.print(node.argument);
    }
    function QualifiedTypeIdentifier(node) {
      this.print(node.qualification);
      this.tokenChar(46);
      this.print(node.id);
    }
    function SymbolTypeAnnotation() {
      this.word("symbol");
    }
    function orSeparator(occurrenceCount) {
      this.space();
      this.token("|", false, occurrenceCount);
      this.space();
    }
    function UnionTypeAnnotation(node) {
      this.printJoin(node.types, void 0, void 0, orSeparator);
    }
    function TypeCastExpression(node) {
      this.tokenChar(40);
      this.print(node.expression);
      this.print(node.typeAnnotation);
      this.tokenChar(41);
    }
    function Variance(node) {
      if (node.kind === "plus") {
        this.tokenChar(43);
      } else {
        this.tokenChar(45);
      }
    }
    function VoidTypeAnnotation() {
      this.word("void");
    }
    function IndexedAccessType(node) {
      this.print(node.objectType, true);
      this.tokenChar(91);
      this.print(node.indexType);
      this.tokenChar(93);
    }
    function OptionalIndexedAccessType(node) {
      this.print(node.objectType);
      if (node.optional) {
        this.token("?.");
      }
      this.tokenChar(91);
      this.print(node.indexType);
      this.tokenChar(93);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/base.js
var require_base = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/base.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.BlockStatement = BlockStatement;
    exports2.Directive = Directive;
    exports2.DirectiveLiteral = DirectiveLiteral;
    exports2.File = File2;
    exports2.InterpreterDirective = InterpreterDirective;
    exports2.Placeholder = Placeholder;
    exports2.Program = Program;
    function File2(node) {
      if (node.program) {
        this.print(node.program.interpreter);
      }
      this.print(node.program);
    }
    function Program(node) {
      var _node$directives;
      this.noIndentInnerCommentsHere();
      this.printInnerComments();
      const directivesLen = (_node$directives = node.directives) == null ? void 0 : _node$directives.length;
      if (directivesLen) {
        var _node$directives$trai;
        const newline = node.body.length ? 2 : 1;
        this.printSequence(node.directives, void 0, newline);
        if (!((_node$directives$trai = node.directives[directivesLen - 1].trailingComments) != null && _node$directives$trai.length)) {
          this.newline(newline);
        }
      }
      this.printSequence(node.body);
    }
    function BlockStatement(node) {
      var _node$directives2;
      this.tokenChar(123);
      const exit = this.enterDelimited();
      const directivesLen = (_node$directives2 = node.directives) == null ? void 0 : _node$directives2.length;
      if (directivesLen) {
        var _node$directives$trai2;
        const newline = node.body.length ? 2 : 1;
        this.printSequence(node.directives, true, newline);
        if (!((_node$directives$trai2 = node.directives[directivesLen - 1].trailingComments) != null && _node$directives$trai2.length)) {
          this.newline(newline);
        }
      }
      this.printSequence(node.body, true);
      exit();
      this.rightBrace(node);
    }
    function Directive(node) {
      this.print(node.value);
      this.semicolon();
    }
    var unescapedSingleQuoteRE = /(?:^|[^\\])(?:\\\\)*'/;
    var unescapedDoubleQuoteRE = /(?:^|[^\\])(?:\\\\)*"/;
    function DirectiveLiteral(node) {
      const raw = this.getPossibleRaw(node);
      if (!this.format.minified && raw !== void 0) {
        this.token(raw);
        return;
      }
      const {
        value
      } = node;
      if (!unescapedDoubleQuoteRE.test(value)) {
        this.token(`"${value}"`);
      } else if (!unescapedSingleQuoteRE.test(value)) {
        this.token(`'${value}'`);
      } else {
        throw new Error("Malformed AST: it is not possible to print a directive containing both unescaped single and double quotes.");
      }
    }
    function InterpreterDirective(node) {
      this.token(`#!${node.value}`);
      this.newline(1, true);
    }
    function Placeholder(node) {
      this.token("%%");
      this.print(node.name);
      this.token("%%");
      if (node.expectedNode === "Statement") {
        this.semicolon();
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/jsx.js
var require_jsx = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/jsx.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.JSXAttribute = JSXAttribute;
    exports2.JSXClosingElement = JSXClosingElement;
    exports2.JSXClosingFragment = JSXClosingFragment;
    exports2.JSXElement = JSXElement;
    exports2.JSXEmptyExpression = JSXEmptyExpression;
    exports2.JSXExpressionContainer = JSXExpressionContainer;
    exports2.JSXFragment = JSXFragment;
    exports2.JSXIdentifier = JSXIdentifier;
    exports2.JSXMemberExpression = JSXMemberExpression;
    exports2.JSXNamespacedName = JSXNamespacedName;
    exports2.JSXOpeningElement = JSXOpeningElement;
    exports2.JSXOpeningFragment = JSXOpeningFragment;
    exports2.JSXSpreadAttribute = JSXSpreadAttribute;
    exports2.JSXSpreadChild = JSXSpreadChild;
    exports2.JSXText = JSXText;
    function JSXAttribute(node) {
      this.print(node.name);
      if (node.value) {
        this.tokenChar(61);
        this.print(node.value);
      }
    }
    function JSXIdentifier(node) {
      this.word(node.name);
    }
    function JSXNamespacedName(node) {
      this.print(node.namespace);
      this.tokenChar(58);
      this.print(node.name);
    }
    function JSXMemberExpression(node) {
      this.print(node.object);
      this.tokenChar(46);
      this.print(node.property);
    }
    function JSXSpreadAttribute(node) {
      this.tokenChar(123);
      this.token("...");
      this.print(node.argument);
      this.rightBrace(node);
    }
    function JSXExpressionContainer(node) {
      this.tokenChar(123);
      this.print(node.expression);
      this.rightBrace(node);
    }
    function JSXSpreadChild(node) {
      this.tokenChar(123);
      this.token("...");
      this.print(node.expression);
      this.rightBrace(node);
    }
    function JSXText(node) {
      const raw = this.getPossibleRaw(node);
      if (raw !== void 0) {
        this.token(raw, true);
      } else {
        this.token(node.value, true);
      }
    }
    function JSXElement(node) {
      const open = node.openingElement;
      this.print(open);
      if (open.selfClosing) return;
      this.indent();
      for (const child of node.children) {
        this.print(child);
      }
      this.dedent();
      this.print(node.closingElement);
    }
    function spaceSeparator() {
      this.space();
    }
    function JSXOpeningElement(node) {
      this.tokenChar(60);
      this.print(node.name);
      {
        if (node.typeArguments) {
          this.print(node.typeArguments);
        }
        this.print(node.typeParameters);
      }
      if (node.attributes.length > 0) {
        this.space();
        this.printJoin(node.attributes, void 0, void 0, spaceSeparator);
      }
      if (node.selfClosing) {
        this.space();
        this.tokenChar(47);
      }
      this.tokenChar(62);
    }
    function JSXClosingElement(node) {
      this.tokenChar(60);
      this.tokenChar(47);
      this.print(node.name);
      this.tokenChar(62);
    }
    function JSXEmptyExpression() {
      this.printInnerComments();
    }
    function JSXFragment(node) {
      this.print(node.openingFragment);
      this.indent();
      for (const child of node.children) {
        this.print(child);
      }
      this.dedent();
      this.print(node.closingFragment);
    }
    function JSXOpeningFragment() {
      this.tokenChar(60);
      this.tokenChar(62);
    }
    function JSXClosingFragment() {
      this.token("</");
      this.tokenChar(62);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/typescript.js
var require_typescript = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/typescript.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TSAnyKeyword = TSAnyKeyword;
    exports2.TSArrayType = TSArrayType;
    exports2.TSSatisfiesExpression = exports2.TSAsExpression = TSTypeExpression;
    exports2.TSBigIntKeyword = TSBigIntKeyword;
    exports2.TSBooleanKeyword = TSBooleanKeyword;
    exports2.TSCallSignatureDeclaration = TSCallSignatureDeclaration;
    exports2.TSInterfaceHeritage = exports2.TSClassImplements = TSClassImplements;
    exports2.TSConditionalType = TSConditionalType;
    exports2.TSConstructSignatureDeclaration = TSConstructSignatureDeclaration;
    exports2.TSConstructorType = TSConstructorType;
    exports2.TSDeclareFunction = TSDeclareFunction;
    exports2.TSDeclareMethod = TSDeclareMethod;
    exports2.TSEnumBody = TSEnumBody;
    exports2.TSEnumDeclaration = TSEnumDeclaration;
    exports2.TSEnumMember = TSEnumMember;
    exports2.TSExportAssignment = TSExportAssignment;
    exports2.TSExternalModuleReference = TSExternalModuleReference;
    exports2.TSFunctionType = TSFunctionType;
    exports2.TSImportEqualsDeclaration = TSImportEqualsDeclaration;
    exports2.TSImportType = TSImportType;
    exports2.TSIndexSignature = TSIndexSignature;
    exports2.TSIndexedAccessType = TSIndexedAccessType;
    exports2.TSInferType = TSInferType;
    exports2.TSInstantiationExpression = TSInstantiationExpression;
    exports2.TSInterfaceBody = TSInterfaceBody;
    exports2.TSInterfaceDeclaration = TSInterfaceDeclaration;
    exports2.TSIntersectionType = TSIntersectionType;
    exports2.TSIntrinsicKeyword = TSIntrinsicKeyword;
    exports2.TSLiteralType = TSLiteralType;
    exports2.TSMappedType = TSMappedType;
    exports2.TSMethodSignature = TSMethodSignature;
    exports2.TSModuleBlock = TSModuleBlock;
    exports2.TSModuleDeclaration = TSModuleDeclaration;
    exports2.TSNamedTupleMember = TSNamedTupleMember;
    exports2.TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
    exports2.TSNeverKeyword = TSNeverKeyword;
    exports2.TSNonNullExpression = TSNonNullExpression;
    exports2.TSNullKeyword = TSNullKeyword;
    exports2.TSNumberKeyword = TSNumberKeyword;
    exports2.TSObjectKeyword = TSObjectKeyword;
    exports2.TSOptionalType = TSOptionalType;
    exports2.TSParameterProperty = TSParameterProperty;
    exports2.TSParenthesizedType = TSParenthesizedType;
    exports2.TSPropertySignature = TSPropertySignature;
    exports2.TSQualifiedName = TSQualifiedName;
    exports2.TSRestType = TSRestType;
    exports2.TSStringKeyword = TSStringKeyword;
    exports2.TSSymbolKeyword = TSSymbolKeyword;
    exports2.TSTemplateLiteralType = TSTemplateLiteralType;
    exports2.TSThisType = TSThisType;
    exports2.TSTupleType = TSTupleType;
    exports2.TSTypeAliasDeclaration = TSTypeAliasDeclaration;
    exports2.TSTypeAnnotation = TSTypeAnnotation;
    exports2.TSTypeAssertion = TSTypeAssertion;
    exports2.TSTypeLiteral = TSTypeLiteral;
    exports2.TSTypeOperator = TSTypeOperator;
    exports2.TSTypeParameter = TSTypeParameter;
    exports2.TSTypeParameterDeclaration = exports2.TSTypeParameterInstantiation = TSTypeParameterInstantiation;
    exports2.TSTypePredicate = TSTypePredicate;
    exports2.TSTypeQuery = TSTypeQuery;
    exports2.TSTypeReference = TSTypeReference;
    exports2.TSUndefinedKeyword = TSUndefinedKeyword;
    exports2.TSUnionType = TSUnionType;
    exports2.TSUnknownKeyword = TSUnknownKeyword;
    exports2.TSVoidKeyword = TSVoidKeyword;
    exports2.tsPrintClassMemberModifiers = tsPrintClassMemberModifiers;
    exports2.tsPrintFunctionOrConstructorType = tsPrintFunctionOrConstructorType;
    exports2.tsPrintPropertyOrMethodName = tsPrintPropertyOrMethodName;
    exports2.tsPrintSignatureDeclarationBase = tsPrintSignatureDeclarationBase;
    function TSTypeAnnotation(node, parent) {
      this.token((parent.type === "TSFunctionType" || parent.type === "TSConstructorType") && parent.typeAnnotation === node ? "=>" : ":");
      this.space();
      if (node.optional) this.tokenChar(63);
      this.print(node.typeAnnotation);
    }
    function TSTypeParameterInstantiation(node, parent) {
      this.tokenChar(60);
      let printTrailingSeparator = parent.type === "ArrowFunctionExpression" && node.params.length === 1;
      if (this.tokenMap && node.start != null && node.end != null) {
        printTrailingSeparator && (printTrailingSeparator = !!this.tokenMap.find(node, (t6) => this.tokenMap.matchesOriginal(t6, ",")));
        printTrailingSeparator || (printTrailingSeparator = this.shouldPrintTrailingComma(">"));
      }
      this.printList(node.params, printTrailingSeparator);
      this.tokenChar(62);
    }
    function TSTypeParameter(node) {
      if (node.in) {
        this.word("in");
        this.space();
      }
      if (node.out) {
        this.word("out");
        this.space();
      }
      this.word(node.name);
      if (node.constraint) {
        this.space();
        this.word("extends");
        this.space();
        this.print(node.constraint);
      }
      if (node.default) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.default);
      }
    }
    function TSParameterProperty(node) {
      if (node.accessibility) {
        this.word(node.accessibility);
        this.space();
      }
      if (node.readonly) {
        this.word("readonly");
        this.space();
      }
      this._param(node.parameter);
    }
    function TSDeclareFunction(node, parent) {
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      this._functionHead(node, parent);
      this.semicolon();
    }
    function TSDeclareMethod(node) {
      this._classMethodHead(node);
      this.semicolon();
    }
    function TSQualifiedName(node) {
      this.print(node.left);
      this.tokenChar(46);
      this.print(node.right);
    }
    function TSCallSignatureDeclaration(node) {
      this.tsPrintSignatureDeclarationBase(node);
      maybePrintTrailingCommaOrSemicolon(this, node);
    }
    function maybePrintTrailingCommaOrSemicolon(printer, node) {
      if (!printer.tokenMap || !node.start || !node.end) {
        printer.semicolon();
        return;
      }
      if (printer.tokenMap.endMatches(node, ",")) {
        printer.token(",");
      } else if (printer.tokenMap.endMatches(node, ";")) {
        printer.semicolon();
      }
    }
    function TSConstructSignatureDeclaration(node) {
      this.word("new");
      this.space();
      this.tsPrintSignatureDeclarationBase(node);
      maybePrintTrailingCommaOrSemicolon(this, node);
    }
    function TSPropertySignature(node) {
      const {
        readonly: readonly2
      } = node;
      if (readonly2) {
        this.word("readonly");
        this.space();
      }
      this.tsPrintPropertyOrMethodName(node);
      this.print(node.typeAnnotation);
      maybePrintTrailingCommaOrSemicolon(this, node);
    }
    function tsPrintPropertyOrMethodName(node) {
      if (node.computed) {
        this.tokenChar(91);
      }
      this.print(node.key);
      if (node.computed) {
        this.tokenChar(93);
      }
      if (node.optional) {
        this.tokenChar(63);
      }
    }
    function TSMethodSignature(node) {
      const {
        kind
      } = node;
      if (kind === "set" || kind === "get") {
        this.word(kind);
        this.space();
      }
      this.tsPrintPropertyOrMethodName(node);
      this.tsPrintSignatureDeclarationBase(node);
      maybePrintTrailingCommaOrSemicolon(this, node);
    }
    function TSIndexSignature(node) {
      const {
        readonly: readonly2,
        static: isStatic
      } = node;
      if (isStatic) {
        this.word("static");
        this.space();
      }
      if (readonly2) {
        this.word("readonly");
        this.space();
      }
      this.tokenChar(91);
      this._parameters(node.parameters, "]");
      this.print(node.typeAnnotation);
      maybePrintTrailingCommaOrSemicolon(this, node);
    }
    function TSAnyKeyword() {
      this.word("any");
    }
    function TSBigIntKeyword() {
      this.word("bigint");
    }
    function TSUnknownKeyword() {
      this.word("unknown");
    }
    function TSNumberKeyword() {
      this.word("number");
    }
    function TSObjectKeyword() {
      this.word("object");
    }
    function TSBooleanKeyword() {
      this.word("boolean");
    }
    function TSStringKeyword() {
      this.word("string");
    }
    function TSSymbolKeyword() {
      this.word("symbol");
    }
    function TSVoidKeyword() {
      this.word("void");
    }
    function TSUndefinedKeyword() {
      this.word("undefined");
    }
    function TSNullKeyword() {
      this.word("null");
    }
    function TSNeverKeyword() {
      this.word("never");
    }
    function TSIntrinsicKeyword() {
      this.word("intrinsic");
    }
    function TSThisType() {
      this.word("this");
    }
    function TSFunctionType(node) {
      this.tsPrintFunctionOrConstructorType(node);
    }
    function TSConstructorType(node) {
      if (node.abstract) {
        this.word("abstract");
        this.space();
      }
      this.word("new");
      this.space();
      this.tsPrintFunctionOrConstructorType(node);
    }
    function tsPrintFunctionOrConstructorType(node) {
      const {
        typeParameters
      } = node;
      const parameters = node.parameters;
      this.print(typeParameters);
      this.tokenChar(40);
      this._parameters(parameters, ")");
      this.space();
      const returnType = node.typeAnnotation;
      this.print(returnType);
    }
    function TSTypeReference(node) {
      const typeArguments = node.typeParameters;
      this.print(node.typeName, !!typeArguments);
      this.print(typeArguments);
    }
    function TSTypePredicate(node) {
      if (node.asserts) {
        this.word("asserts");
        this.space();
      }
      this.print(node.parameterName);
      if (node.typeAnnotation) {
        this.space();
        this.word("is");
        this.space();
        this.print(node.typeAnnotation.typeAnnotation);
      }
    }
    function TSTypeQuery(node) {
      this.word("typeof");
      this.space();
      this.print(node.exprName);
      const typeArguments = node.typeParameters;
      if (typeArguments) {
        this.print(typeArguments);
      }
    }
    function TSTypeLiteral(node) {
      printBraced(this, node, () => this.printJoin(node.members, true, true));
    }
    function TSArrayType(node) {
      this.print(node.elementType, true);
      this.tokenChar(91);
      this.tokenChar(93);
    }
    function TSTupleType(node) {
      this.tokenChar(91);
      this.printList(node.elementTypes, this.shouldPrintTrailingComma("]"));
      this.tokenChar(93);
    }
    function TSOptionalType(node) {
      this.print(node.typeAnnotation);
      this.tokenChar(63);
    }
    function TSRestType(node) {
      this.token("...");
      this.print(node.typeAnnotation);
    }
    function TSNamedTupleMember(node) {
      this.print(node.label);
      if (node.optional) this.tokenChar(63);
      this.tokenChar(58);
      this.space();
      this.print(node.elementType);
    }
    function TSUnionType(node) {
      tsPrintUnionOrIntersectionType(this, node, "|");
    }
    function TSIntersectionType(node) {
      tsPrintUnionOrIntersectionType(this, node, "&");
    }
    function tsPrintUnionOrIntersectionType(printer, node, sep) {
      var _printer$tokenMap;
      let hasLeadingToken = 0;
      if ((_printer$tokenMap = printer.tokenMap) != null && _printer$tokenMap.startMatches(node, sep)) {
        hasLeadingToken = 1;
        printer.token(sep);
      }
      printer.printJoin(node.types, void 0, void 0, function(i) {
        this.space();
        this.token(sep, null, i + hasLeadingToken);
        this.space();
      });
    }
    function TSConditionalType(node) {
      this.print(node.checkType);
      this.space();
      this.word("extends");
      this.space();
      this.print(node.extendsType);
      this.space();
      this.tokenChar(63);
      this.space();
      this.print(node.trueType);
      this.space();
      this.tokenChar(58);
      this.space();
      this.print(node.falseType);
    }
    function TSInferType(node) {
      this.word("infer");
      this.print(node.typeParameter);
    }
    function TSParenthesizedType(node) {
      this.tokenChar(40);
      this.print(node.typeAnnotation);
      this.tokenChar(41);
    }
    function TSTypeOperator(node) {
      this.word(node.operator);
      this.space();
      this.print(node.typeAnnotation);
    }
    function TSIndexedAccessType(node) {
      this.print(node.objectType, true);
      this.tokenChar(91);
      this.print(node.indexType);
      this.tokenChar(93);
    }
    function TSMappedType(node) {
      const {
        nameType,
        optional: optional2,
        readonly: readonly2,
        typeAnnotation: typeAnnotation2
      } = node;
      this.tokenChar(123);
      const exit = this.enterDelimited();
      this.space();
      if (readonly2) {
        tokenIfPlusMinus(this, readonly2);
        this.word("readonly");
        this.space();
      }
      this.tokenChar(91);
      {
        this.word(node.typeParameter.name);
      }
      this.space();
      this.word("in");
      this.space();
      {
        this.print(node.typeParameter.constraint);
      }
      if (nameType) {
        this.space();
        this.word("as");
        this.space();
        this.print(nameType);
      }
      this.tokenChar(93);
      if (optional2) {
        tokenIfPlusMinus(this, optional2);
        this.tokenChar(63);
      }
      if (typeAnnotation2) {
        this.tokenChar(58);
        this.space();
        this.print(typeAnnotation2);
      }
      this.space();
      exit();
      this.tokenChar(125);
    }
    function tokenIfPlusMinus(self2, tok) {
      if (tok !== true) {
        self2.token(tok);
      }
    }
    function TSTemplateLiteralType(node) {
      this._printTemplate(node, node.types);
    }
    function TSLiteralType(node) {
      this.print(node.literal);
    }
    function TSClassImplements(node) {
      this.print(node.expression);
      this.print(node.typeArguments);
    }
    function TSInterfaceDeclaration(node) {
      const {
        declare,
        id,
        typeParameters,
        extends: extendz,
        body
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      this.word("interface");
      this.space();
      this.print(id);
      this.print(typeParameters);
      if (extendz != null && extendz.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(extendz);
      }
      this.space();
      this.print(body);
    }
    function TSInterfaceBody(node) {
      printBraced(this, node, () => this.printJoin(node.body, true, true));
    }
    function TSTypeAliasDeclaration(node) {
      const {
        declare,
        id,
        typeParameters,
        typeAnnotation: typeAnnotation2
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      this.word("type");
      this.space();
      this.print(id);
      this.print(typeParameters);
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(typeAnnotation2);
      this.semicolon();
    }
    function TSTypeExpression(node) {
      const {
        type,
        expression,
        typeAnnotation: typeAnnotation2
      } = node;
      this.print(expression, true);
      this.space();
      this.word(type === "TSAsExpression" ? "as" : "satisfies");
      this.space();
      this.print(typeAnnotation2);
    }
    function TSTypeAssertion(node) {
      const {
        typeAnnotation: typeAnnotation2,
        expression
      } = node;
      this.tokenChar(60);
      this.print(typeAnnotation2);
      this.tokenChar(62);
      this.space();
      this.print(expression);
    }
    function TSInstantiationExpression(node) {
      this.print(node.expression);
      {
        this.print(node.typeParameters);
      }
    }
    function TSEnumDeclaration(node) {
      const {
        declare,
        const: isConst,
        id
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      if (isConst) {
        this.word("const");
        this.space();
      }
      this.word("enum");
      this.space();
      this.print(id);
      this.space();
      {
        TSEnumBody.call(this, node);
      }
    }
    function TSEnumBody(node) {
      printBraced(this, node, () => {
        var _this$shouldPrintTrai;
        return this.printList(node.members, (_this$shouldPrintTrai = this.shouldPrintTrailingComma("}")) != null ? _this$shouldPrintTrai : true, true, true);
      });
    }
    function TSEnumMember(node) {
      const {
        id,
        initializer: initializer3
      } = node;
      this.print(id);
      if (initializer3) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(initializer3);
      }
    }
    function TSModuleDeclaration(node) {
      const {
        declare,
        id,
        kind
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      {
        if (!node.global) {
          this.word(kind != null ? kind : id.type === "Identifier" ? "namespace" : "module");
          this.space();
        }
        this.print(id);
        if (!node.body) {
          this.semicolon();
          return;
        }
        let body = node.body;
        while (body.type === "TSModuleDeclaration") {
          this.tokenChar(46);
          this.print(body.id);
          body = body.body;
        }
        this.space();
        this.print(body);
      }
    }
    function TSModuleBlock(node) {
      printBraced(this, node, () => this.printSequence(node.body, true));
    }
    function TSImportType(node) {
      const {
        argument,
        qualifier,
        options
      } = node;
      this.word("import");
      this.tokenChar(40);
      this.print(argument);
      if (options) {
        this.tokenChar(44);
        this.print(options);
      }
      this.tokenChar(41);
      if (qualifier) {
        this.tokenChar(46);
        this.print(qualifier);
      }
      const typeArguments = node.typeParameters;
      if (typeArguments) {
        this.print(typeArguments);
      }
    }
    function TSImportEqualsDeclaration(node) {
      const {
        id,
        moduleReference
      } = node;
      if (node.isExport) {
        this.word("export");
        this.space();
      }
      this.word("import");
      this.space();
      this.print(id);
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(moduleReference);
      this.semicolon();
    }
    function TSExternalModuleReference(node) {
      this.token("require(");
      this.print(node.expression);
      this.tokenChar(41);
    }
    function TSNonNullExpression(node) {
      this.print(node.expression);
      this.tokenChar(33);
    }
    function TSExportAssignment(node) {
      this.word("export");
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.expression);
      this.semicolon();
    }
    function TSNamespaceExportDeclaration(node) {
      this.word("export");
      this.space();
      this.word("as");
      this.space();
      this.word("namespace");
      this.space();
      this.print(node.id);
      this.semicolon();
    }
    function tsPrintSignatureDeclarationBase(node) {
      const {
        typeParameters
      } = node;
      const parameters = node.parameters;
      this.print(typeParameters);
      this.tokenChar(40);
      this._parameters(parameters, ")");
      const returnType = node.typeAnnotation;
      this.print(returnType);
    }
    function tsPrintClassMemberModifiers(node) {
      const isPrivateField = node.type === "ClassPrivateProperty";
      const isPublicField = node.type === "ClassAccessorProperty" || node.type === "ClassProperty";
      printModifiersList(this, node, [isPublicField && node.declare && "declare", !isPrivateField && node.accessibility]);
      if (node.static) {
        this.word("static");
        this.space();
      }
      printModifiersList(this, node, [!isPrivateField && node.abstract && "abstract", !isPrivateField && node.override && "override", (isPublicField || isPrivateField) && node.readonly && "readonly"]);
    }
    function printBraced(printer, node, cb) {
      printer.token("{");
      const exit = printer.enterDelimited();
      cb();
      exit();
      printer.rightBrace(node);
    }
    function printModifiersList(printer, node, modifiers) {
      var _printer$tokenMap2;
      const modifiersSet = /* @__PURE__ */ new Set();
      for (const modifier of modifiers) {
        if (modifier) modifiersSet.add(modifier);
      }
      (_printer$tokenMap2 = printer.tokenMap) == null || _printer$tokenMap2.find(node, (tok) => {
        if (modifiersSet.has(tok.value)) {
          printer.token(tok.value);
          printer.space();
          modifiersSet.delete(tok.value);
          return modifiersSet.size === 0;
        }
      });
      for (const modifier of modifiersSet) {
        printer.word(modifier);
        printer.space();
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/index.js
var require_generators = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    var _templateLiterals = require_template_literals();
    Object.keys(_templateLiterals).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _templateLiterals[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _templateLiterals[key2];
        }
      });
    });
    var _expressions = require_expressions();
    Object.keys(_expressions).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _expressions[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _expressions[key2];
        }
      });
    });
    var _statements = require_statements();
    Object.keys(_statements).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _statements[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _statements[key2];
        }
      });
    });
    var _classes = require_classes();
    Object.keys(_classes).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _classes[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _classes[key2];
        }
      });
    });
    var _methods = require_methods();
    Object.keys(_methods).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _methods[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _methods[key2];
        }
      });
    });
    var _modules = require_modules();
    Object.keys(_modules).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _modules[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _modules[key2];
        }
      });
    });
    var _types2 = require_types();
    Object.keys(_types2).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _types2[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _types2[key2];
        }
      });
    });
    var _flow = require_flow();
    Object.keys(_flow).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _flow[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _flow[key2];
        }
      });
    });
    var _base = require_base();
    Object.keys(_base).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _base[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _base[key2];
        }
      });
    });
    var _jsx = require_jsx();
    Object.keys(_jsx).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _jsx[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _jsx[key2];
        }
      });
    });
    var _typescript = require_typescript();
    Object.keys(_typescript).forEach(function(key2) {
      if (key2 === "default" || key2 === "__esModule") return;
      if (key2 in exports2 && exports2[key2] === _typescript[key2]) return;
      Object.defineProperty(exports2, key2, {
        enumerable: true,
        get: function() {
          return _typescript[key2];
        }
      });
    });
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/deprecated.js
var require_deprecated = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/generators/deprecated.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.addDeprecatedGenerators = addDeprecatedGenerators;
    function addDeprecatedGenerators(PrinterClass) {
      {
        const deprecatedBabel7Generators = {
          Noop() {
          },
          TSExpressionWithTypeArguments(node) {
            this.print(node.expression);
            this.print(node.typeParameters);
          },
          DecimalLiteral(node) {
            const raw = this.getPossibleRaw(node);
            if (!this.format.minified && raw !== void 0) {
              this.word(raw);
              return;
            }
            this.word(node.value + "m");
          }
        };
        Object.assign(PrinterClass.prototype, deprecatedBabel7Generators);
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/printer.js
var require_printer = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/printer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _buffer = require_buffer();
    var n = require_node2();
    var _t = require("@babel/types");
    var _tokenMap = require_token_map();
    var generatorFunctions = require_generators();
    var _deprecated = require_deprecated();
    var {
      isExpression: isExpression2,
      isFunction,
      isStatement: isStatement2,
      isClassBody,
      isTSInterfaceBody,
      isTSEnumMember
    } = _t;
    var SCIENTIFIC_NOTATION = /e/i;
    var ZERO_DECIMAL_INTEGER = /\.0+$/;
    var HAS_NEWLINE = /[\n\r\u2028\u2029]/;
    var HAS_NEWLINE_OR_BlOCK_COMMENT_END = /[\n\r\u2028\u2029]|\*\//;
    function commentIsNewline(c2) {
      return c2.type === "CommentLine" || HAS_NEWLINE.test(c2.value);
    }
    var {
      needsParens
    } = n;
    var Printer = class {
      constructor(format, map2, tokens, originalCode) {
        this.inForStatementInit = false;
        this.tokenContext = 0;
        this._tokens = null;
        this._originalCode = null;
        this._currentNode = null;
        this._indent = 0;
        this._indentRepeat = 0;
        this._insideAux = false;
        this._noLineTerminator = false;
        this._noLineTerminatorAfterNode = null;
        this._printAuxAfterOnNextUserNode = false;
        this._printedComments = /* @__PURE__ */ new Set();
        this._endsWithInteger = false;
        this._endsWithWord = false;
        this._endsWithDiv = false;
        this._lastCommentLine = 0;
        this._endsWithInnerRaw = false;
        this._indentInnerComments = true;
        this.tokenMap = null;
        this._boundGetRawIdentifier = this._getRawIdentifier.bind(this);
        this._printSemicolonBeforeNextNode = -1;
        this._printSemicolonBeforeNextToken = -1;
        this.format = format;
        this._tokens = tokens;
        this._originalCode = originalCode;
        this._indentRepeat = format.indent.style.length;
        this._inputMap = map2 == null ? void 0 : map2._inputMap;
        this._buf = new _buffer.default(map2, format.indent.style[0]);
      }
      enterForStatementInit() {
        if (this.inForStatementInit) return () => {
        };
        this.inForStatementInit = true;
        return () => {
          this.inForStatementInit = false;
        };
      }
      enterDelimited() {
        const oldInForStatementInit = this.inForStatementInit;
        const oldNoLineTerminatorAfterNode = this._noLineTerminatorAfterNode;
        if (oldInForStatementInit === false && oldNoLineTerminatorAfterNode === null) {
          return () => {
          };
        }
        this.inForStatementInit = false;
        this._noLineTerminatorAfterNode = null;
        return () => {
          this.inForStatementInit = oldInForStatementInit;
          this._noLineTerminatorAfterNode = oldNoLineTerminatorAfterNode;
        };
      }
      generate(ast) {
        if (this.format.preserveFormat) {
          this.tokenMap = new _tokenMap.TokenMap(ast, this._tokens, this._originalCode);
        }
        this.print(ast);
        this._maybeAddAuxComment();
        return this._buf.get();
      }
      indent() {
        const {
          format
        } = this;
        if (format.preserveFormat || format.compact || format.concise) {
          return;
        }
        this._indent++;
      }
      dedent() {
        const {
          format
        } = this;
        if (format.preserveFormat || format.compact || format.concise) {
          return;
        }
        this._indent--;
      }
      semicolon(force = false) {
        this._maybeAddAuxComment();
        if (force) {
          this._appendChar(59);
          this._noLineTerminator = false;
          return;
        }
        if (this.tokenMap) {
          const node = this._currentNode;
          if (node.start != null && node.end != null) {
            if (!this.tokenMap.endMatches(node, ";")) {
              this._printSemicolonBeforeNextNode = this._buf.getCurrentLine();
              return;
            }
            const indexes = this.tokenMap.getIndexes(this._currentNode);
            this._catchUpTo(this._tokens[indexes[indexes.length - 1]].loc.start);
          }
        }
        this._queue(59);
        this._noLineTerminator = false;
      }
      rightBrace(node) {
        if (this.format.minified) {
          this._buf.removeLastSemicolon();
        }
        this.sourceWithOffset("end", node.loc, -1);
        this.tokenChar(125);
      }
      rightParens(node) {
        this.sourceWithOffset("end", node.loc, -1);
        this.tokenChar(41);
      }
      space(force = false) {
        const {
          format
        } = this;
        if (format.compact || format.preserveFormat) return;
        if (force) {
          this._space();
        } else if (this._buf.hasContent()) {
          const lastCp = this.getLastChar();
          if (lastCp !== 32 && lastCp !== 10) {
            this._space();
          }
        }
      }
      word(str, noLineTerminatorAfter = false) {
        this.tokenContext = 0;
        this._maybePrintInnerComments(str);
        this._maybeAddAuxComment();
        if (this.tokenMap) this._catchUpToCurrentToken(str);
        if (this._endsWithWord || this._endsWithDiv && str.charCodeAt(0) === 47) {
          this._space();
        }
        this._append(str, false);
        this._endsWithWord = true;
        this._noLineTerminator = noLineTerminatorAfter;
      }
      number(str, number4) {
        function isNonDecimalLiteral(str2) {
          if (str2.length > 2 && str2.charCodeAt(0) === 48) {
            const secondChar = str2.charCodeAt(1);
            return secondChar === 98 || secondChar === 111 || secondChar === 120;
          }
          return false;
        }
        this.word(str);
        this._endsWithInteger = Number.isInteger(number4) && !isNonDecimalLiteral(str) && !SCIENTIFIC_NOTATION.test(str) && !ZERO_DECIMAL_INTEGER.test(str) && str.charCodeAt(str.length - 1) !== 46;
      }
      token(str, maybeNewline = false, occurrenceCount = 0) {
        this.tokenContext = 0;
        this._maybePrintInnerComments(str, occurrenceCount);
        this._maybeAddAuxComment();
        if (this.tokenMap) this._catchUpToCurrentToken(str, occurrenceCount);
        const lastChar = this.getLastChar();
        const strFirst = str.charCodeAt(0);
        if (lastChar === 33 && (str === "--" || strFirst === 61) || strFirst === 43 && lastChar === 43 || strFirst === 45 && lastChar === 45 || strFirst === 46 && this._endsWithInteger) {
          this._space();
        }
        this._append(str, maybeNewline);
        this._noLineTerminator = false;
      }
      tokenChar(char) {
        this.tokenContext = 0;
        const str = String.fromCharCode(char);
        this._maybePrintInnerComments(str);
        this._maybeAddAuxComment();
        if (this.tokenMap) this._catchUpToCurrentToken(str);
        const lastChar = this.getLastChar();
        if (char === 43 && lastChar === 43 || char === 45 && lastChar === 45 || char === 46 && this._endsWithInteger) {
          this._space();
        }
        this._appendChar(char);
        this._noLineTerminator = false;
      }
      newline(i = 1, force) {
        if (i <= 0) return;
        if (!force) {
          if (this.format.retainLines || this.format.compact) return;
          if (this.format.concise) {
            this.space();
            return;
          }
        }
        if (i > 2) i = 2;
        i -= this._buf.getNewlineCount();
        for (let j = 0; j < i; j++) {
          this._newline();
        }
        return;
      }
      endsWith(char) {
        return this.getLastChar() === char;
      }
      getLastChar() {
        return this._buf.getLastChar();
      }
      endsWithCharAndNewline() {
        return this._buf.endsWithCharAndNewline();
      }
      removeTrailingNewline() {
        this._buf.removeTrailingNewline();
      }
      exactSource(loc, cb) {
        if (!loc) {
          cb();
          return;
        }
        this._catchUp("start", loc);
        this._buf.exactSource(loc, cb);
      }
      source(prop, loc) {
        if (!loc) return;
        this._catchUp(prop, loc);
        this._buf.source(prop, loc);
      }
      sourceWithOffset(prop, loc, columnOffset) {
        if (!loc || this.format.preserveFormat) return;
        this._catchUp(prop, loc);
        this._buf.sourceWithOffset(prop, loc, columnOffset);
      }
      sourceIdentifierName(identifierName, pos2) {
        if (!this._buf._canMarkIdName) return;
        const sourcePosition = this._buf._sourcePosition;
        sourcePosition.identifierNamePos = pos2;
        sourcePosition.identifierName = identifierName;
      }
      _space() {
        this._queue(32);
      }
      _newline() {
        this._queue(10);
      }
      _catchUpToCurrentToken(str, occurrenceCount = 0) {
        const token2 = this.tokenMap.findMatching(this._currentNode, str, occurrenceCount);
        if (token2) this._catchUpTo(token2.loc.start);
        if (this._printSemicolonBeforeNextToken !== -1 && this._printSemicolonBeforeNextToken === this._buf.getCurrentLine()) {
          this._buf.appendChar(59);
          this._endsWithWord = false;
          this._endsWithInteger = false;
          this._endsWithDiv = false;
        }
        this._printSemicolonBeforeNextToken = -1;
        this._printSemicolonBeforeNextNode = -1;
      }
      _append(str, maybeNewline) {
        this._maybeIndent(str.charCodeAt(0));
        this._buf.append(str, maybeNewline);
        this._endsWithWord = false;
        this._endsWithInteger = false;
        this._endsWithDiv = false;
      }
      _appendChar(char) {
        this._maybeIndent(char);
        this._buf.appendChar(char);
        this._endsWithWord = false;
        this._endsWithInteger = false;
        this._endsWithDiv = false;
      }
      _queue(char) {
        this._maybeIndent(char);
        this._buf.queue(char);
        this._endsWithWord = false;
        this._endsWithInteger = false;
      }
      _maybeIndent(firstChar) {
        if (this._indent && firstChar !== 10 && this.endsWith(10)) {
          this._buf.queueIndentation(this._getIndent());
        }
      }
      _shouldIndent(firstChar) {
        if (this._indent && firstChar !== 10 && this.endsWith(10)) {
          return true;
        }
      }
      catchUp(line2) {
        if (!this.format.retainLines) return;
        const count = line2 - this._buf.getCurrentLine();
        for (let i = 0; i < count; i++) {
          this._newline();
        }
      }
      _catchUp(prop, loc) {
        const {
          format
        } = this;
        if (!format.preserveFormat) {
          if (format.retainLines && loc != null && loc[prop]) {
            this.catchUp(loc[prop].line);
          }
          return;
        }
        const pos2 = loc == null ? void 0 : loc[prop];
        if (pos2 != null) this._catchUpTo(pos2);
      }
      _catchUpTo({
        line: line2,
        column: column2,
        index
      }) {
        const count = line2 - this._buf.getCurrentLine();
        if (count > 0 && this._noLineTerminator) {
          return;
        }
        for (let i = 0; i < count; i++) {
          this._newline();
        }
        const spacesCount = count > 0 ? column2 : column2 - this._buf.getCurrentColumn();
        if (spacesCount > 0) {
          const spaces = this._originalCode ? this._originalCode.slice(index - spacesCount, index).replace(/[^\t\x0B\f \xA0\u1680\u2000-\u200A\u202F\u205F\u3000\uFEFF]/gu, " ") : " ".repeat(spacesCount);
          this._append(spaces, false);
        }
      }
      _getIndent() {
        return this._indentRepeat * this._indent;
      }
      printTerminatorless(node) {
        this._noLineTerminator = true;
        this.print(node);
      }
      print(node, noLineTerminatorAfter, trailingCommentsLineOffset) {
        var _node$extra, _node$leadingComments, _node$leadingComments2;
        if (!node) return;
        this._endsWithInnerRaw = false;
        const nodeType = node.type;
        const format = this.format;
        const oldConcise = format.concise;
        if (node._compact) {
          format.concise = true;
        }
        const printMethod = this[nodeType];
        if (printMethod === void 0) {
          throw new ReferenceError(`unknown node of type ${JSON.stringify(nodeType)} with constructor ${JSON.stringify(node.constructor.name)}`);
        }
        const parent = this._currentNode;
        this._currentNode = node;
        if (this.tokenMap) {
          this._printSemicolonBeforeNextToken = this._printSemicolonBeforeNextNode;
        }
        const oldInAux = this._insideAux;
        this._insideAux = node.loc == null;
        this._maybeAddAuxComment(this._insideAux && !oldInAux);
        const parenthesized = (_node$extra = node.extra) == null ? void 0 : _node$extra.parenthesized;
        let shouldPrintParens = parenthesized && format.preserveFormat || parenthesized && format.retainFunctionParens && nodeType === "FunctionExpression" || needsParens(node, parent, this.tokenContext, this.inForStatementInit, format.preserveFormat ? this._boundGetRawIdentifier : void 0);
        if (!shouldPrintParens && parenthesized && (_node$leadingComments = node.leadingComments) != null && _node$leadingComments.length && node.leadingComments[0].type === "CommentBlock") {
          const parentType = parent == null ? void 0 : parent.type;
          switch (parentType) {
            case "ExpressionStatement":
            case "VariableDeclarator":
            case "AssignmentExpression":
            case "ReturnStatement":
              break;
            case "CallExpression":
            case "OptionalCallExpression":
            case "NewExpression":
              if (parent.callee !== node) break;
            default:
              shouldPrintParens = true;
          }
        }
        let indentParenthesized = false;
        if (!shouldPrintParens && this._noLineTerminator && ((_node$leadingComments2 = node.leadingComments) != null && _node$leadingComments2.some(commentIsNewline) || this.format.retainLines && node.loc && node.loc.start.line > this._buf.getCurrentLine())) {
          shouldPrintParens = true;
          indentParenthesized = true;
        }
        let oldNoLineTerminatorAfterNode;
        let oldInForStatementInitWasTrue;
        if (!shouldPrintParens) {
          noLineTerminatorAfter || (noLineTerminatorAfter = parent && this._noLineTerminatorAfterNode === parent && n.isLastChild(parent, node));
          if (noLineTerminatorAfter) {
            var _node$trailingComment;
            if ((_node$trailingComment = node.trailingComments) != null && _node$trailingComment.some(commentIsNewline)) {
              if (isExpression2(node)) shouldPrintParens = true;
            } else {
              oldNoLineTerminatorAfterNode = this._noLineTerminatorAfterNode;
              this._noLineTerminatorAfterNode = node;
            }
          }
        }
        if (shouldPrintParens) {
          this.tokenChar(40);
          if (indentParenthesized) this.indent();
          this._endsWithInnerRaw = false;
          if (this.inForStatementInit) {
            oldInForStatementInitWasTrue = true;
            this.inForStatementInit = false;
          }
          oldNoLineTerminatorAfterNode = this._noLineTerminatorAfterNode;
          this._noLineTerminatorAfterNode = null;
        }
        this._lastCommentLine = 0;
        this._printLeadingComments(node, parent);
        const loc = nodeType === "Program" || nodeType === "File" ? null : node.loc;
        this.exactSource(loc, printMethod.bind(this, node, parent));
        if (shouldPrintParens) {
          this._printTrailingComments(node, parent);
          if (indentParenthesized) {
            this.dedent();
            this.newline();
          }
          this.tokenChar(41);
          this._noLineTerminator = noLineTerminatorAfter;
          if (oldInForStatementInitWasTrue) this.inForStatementInit = true;
        } else if (noLineTerminatorAfter && !this._noLineTerminator) {
          this._noLineTerminator = true;
          this._printTrailingComments(node, parent);
        } else {
          this._printTrailingComments(node, parent, trailingCommentsLineOffset);
        }
        this._currentNode = parent;
        format.concise = oldConcise;
        this._insideAux = oldInAux;
        if (oldNoLineTerminatorAfterNode !== void 0) {
          this._noLineTerminatorAfterNode = oldNoLineTerminatorAfterNode;
        }
        this._endsWithInnerRaw = false;
      }
      _maybeAddAuxComment(enteredPositionlessNode) {
        if (enteredPositionlessNode) this._printAuxBeforeComment();
        if (!this._insideAux) this._printAuxAfterComment();
      }
      _printAuxBeforeComment() {
        if (this._printAuxAfterOnNextUserNode) return;
        this._printAuxAfterOnNextUserNode = true;
        const comment = this.format.auxiliaryCommentBefore;
        if (comment) {
          this._printComment({
            type: "CommentBlock",
            value: comment
          }, 0);
        }
      }
      _printAuxAfterComment() {
        if (!this._printAuxAfterOnNextUserNode) return;
        this._printAuxAfterOnNextUserNode = false;
        const comment = this.format.auxiliaryCommentAfter;
        if (comment) {
          this._printComment({
            type: "CommentBlock",
            value: comment
          }, 0);
        }
      }
      getPossibleRaw(node) {
        const extra = node.extra;
        if ((extra == null ? void 0 : extra.raw) != null && extra.rawValue != null && node.value === extra.rawValue) {
          return extra.raw;
        }
      }
      printJoin(nodes, statement, indent, separator, printTrailingSeparator, addNewlines, iterator, trailingCommentsLineOffset) {
        if (!(nodes != null && nodes.length)) return;
        if (indent == null && this.format.retainLines) {
          var _nodes$0$loc;
          const startLine = (_nodes$0$loc = nodes[0].loc) == null ? void 0 : _nodes$0$loc.start.line;
          if (startLine != null && startLine !== this._buf.getCurrentLine()) {
            indent = true;
          }
        }
        if (indent) this.indent();
        const newlineOpts = {
          addNewlines,
          nextNodeStartLine: 0
        };
        const boundSeparator = separator == null ? void 0 : separator.bind(this);
        const len = nodes.length;
        for (let i = 0; i < len; i++) {
          const node = nodes[i];
          if (!node) continue;
          if (statement) this._printNewline(i === 0, newlineOpts);
          this.print(node, void 0, trailingCommentsLineOffset || 0);
          iterator == null || iterator(node, i);
          if (boundSeparator != null) {
            if (i < len - 1) boundSeparator(i, false);
            else if (printTrailingSeparator) boundSeparator(i, true);
          }
          if (statement) {
            var _node$trailingComment2;
            if (!((_node$trailingComment2 = node.trailingComments) != null && _node$trailingComment2.length)) {
              this._lastCommentLine = 0;
            }
            if (i + 1 === len) {
              this.newline(1);
            } else {
              var _nextNode$loc;
              const nextNode = nodes[i + 1];
              newlineOpts.nextNodeStartLine = ((_nextNode$loc = nextNode.loc) == null ? void 0 : _nextNode$loc.start.line) || 0;
              this._printNewline(true, newlineOpts);
            }
          }
        }
        if (indent) this.dedent();
      }
      printAndIndentOnComments(node) {
        const indent = node.leadingComments && node.leadingComments.length > 0;
        if (indent) this.indent();
        this.print(node);
        if (indent) this.dedent();
      }
      printBlock(parent) {
        const node = parent.body;
        if (node.type !== "EmptyStatement") {
          this.space();
        }
        this.print(node);
      }
      _printTrailingComments(node, parent, lineOffset) {
        const {
          innerComments,
          trailingComments
        } = node;
        if (innerComments != null && innerComments.length) {
          this._printComments(2, innerComments, node, parent, lineOffset);
        }
        if (trailingComments != null && trailingComments.length) {
          this._printComments(2, trailingComments, node, parent, lineOffset);
        }
      }
      _printLeadingComments(node, parent) {
        const comments = node.leadingComments;
        if (!(comments != null && comments.length)) return;
        this._printComments(0, comments, node, parent);
      }
      _maybePrintInnerComments(nextTokenStr, nextTokenOccurrenceCount) {
        if (this._endsWithInnerRaw) {
          var _this$tokenMap;
          this.printInnerComments((_this$tokenMap = this.tokenMap) == null ? void 0 : _this$tokenMap.findMatching(this._currentNode, nextTokenStr, nextTokenOccurrenceCount));
        }
        this._endsWithInnerRaw = true;
        this._indentInnerComments = true;
      }
      printInnerComments(nextToken) {
        const node = this._currentNode;
        const comments = node.innerComments;
        if (!(comments != null && comments.length)) return;
        const hasSpace = this.endsWith(32);
        const indent = this._indentInnerComments;
        const printedCommentsCount = this._printedComments.size;
        if (indent) this.indent();
        this._printComments(1, comments, node, void 0, void 0, nextToken);
        if (hasSpace && printedCommentsCount !== this._printedComments.size) {
          this.space();
        }
        if (indent) this.dedent();
      }
      noIndentInnerCommentsHere() {
        this._indentInnerComments = false;
      }
      printSequence(nodes, indent, trailingCommentsLineOffset, addNewlines) {
        this.printJoin(nodes, true, indent != null ? indent : false, void 0, void 0, addNewlines, void 0, trailingCommentsLineOffset);
      }
      printList(items, printTrailingSeparator, statement, indent, separator, iterator) {
        this.printJoin(items, statement, indent, separator != null ? separator : commaSeparator, printTrailingSeparator, void 0, iterator);
      }
      shouldPrintTrailingComma(listEnd) {
        if (!this.tokenMap) return null;
        const listEndIndex = this.tokenMap.findLastIndex(this._currentNode, (token2) => this.tokenMap.matchesOriginal(token2, listEnd));
        if (listEndIndex <= 0) return null;
        return this.tokenMap.matchesOriginal(this._tokens[listEndIndex - 1], ",");
      }
      _printNewline(newLine, opts) {
        const format = this.format;
        if (format.retainLines || format.compact) return;
        if (format.concise) {
          this.space();
          return;
        }
        if (!newLine) {
          return;
        }
        const startLine = opts.nextNodeStartLine;
        const lastCommentLine = this._lastCommentLine;
        if (startLine > 0 && lastCommentLine > 0) {
          const offset = startLine - lastCommentLine;
          if (offset >= 0) {
            this.newline(offset || 1);
            return;
          }
        }
        if (this._buf.hasContent()) {
          this.newline(1);
        }
      }
      _shouldPrintComment(comment, nextToken) {
        if (comment.ignore) return 0;
        if (this._printedComments.has(comment)) return 0;
        if (this._noLineTerminator && HAS_NEWLINE_OR_BlOCK_COMMENT_END.test(comment.value)) {
          return 2;
        }
        if (nextToken && this.tokenMap) {
          const commentTok = this.tokenMap.find(this._currentNode, (token2) => token2.value === comment.value);
          if (commentTok && commentTok.start > nextToken.start) {
            return 2;
          }
        }
        this._printedComments.add(comment);
        if (!this.format.shouldPrintComment(comment.value)) {
          return 0;
        }
        return 1;
      }
      _printComment(comment, skipNewLines) {
        const noLineTerminator = this._noLineTerminator;
        const isBlockComment = comment.type === "CommentBlock";
        const printNewLines = isBlockComment && skipNewLines !== 1 && !this._noLineTerminator;
        if (printNewLines && this._buf.hasContent() && skipNewLines !== 2) {
          this.newline(1);
        }
        const lastCharCode = this.getLastChar();
        if (lastCharCode !== 91 && lastCharCode !== 123 && lastCharCode !== 40) {
          this.space();
        }
        let val;
        if (isBlockComment) {
          val = `/*${comment.value}*/`;
          if (this.format.indent.adjustMultilineComment) {
            var _comment$loc;
            const offset = (_comment$loc = comment.loc) == null ? void 0 : _comment$loc.start.column;
            if (offset) {
              const newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
              val = val.replace(newlineRegex, "\n");
            }
            if (this.format.concise) {
              val = val.replace(/\n(?!$)/g, `
`);
            } else {
              let indentSize = this.format.retainLines ? 0 : this._buf.getCurrentColumn();
              if (this._shouldIndent(47) || this.format.retainLines) {
                indentSize += this._getIndent();
              }
              val = val.replace(/\n(?!$)/g, `
${" ".repeat(indentSize)}`);
            }
          }
        } else if (!noLineTerminator) {
          val = `//${comment.value}`;
        } else {
          val = `/*${comment.value}*/`;
        }
        if (this._endsWithDiv) this._space();
        if (this.tokenMap) {
          const {
            _printSemicolonBeforeNextToken,
            _printSemicolonBeforeNextNode
          } = this;
          this._printSemicolonBeforeNextToken = -1;
          this._printSemicolonBeforeNextNode = -1;
          this.source("start", comment.loc);
          this._append(val, isBlockComment);
          this._printSemicolonBeforeNextNode = _printSemicolonBeforeNextNode;
          this._printSemicolonBeforeNextToken = _printSemicolonBeforeNextToken;
        } else {
          this.source("start", comment.loc);
          this._append(val, isBlockComment);
        }
        if (!isBlockComment && !noLineTerminator) {
          this.newline(1, true);
        }
        if (printNewLines && skipNewLines !== 3) {
          this.newline(1);
        }
      }
      _printComments(type, comments, node, parent, lineOffset = 0, nextToken) {
        const nodeLoc = node.loc;
        const len = comments.length;
        let hasLoc = !!nodeLoc;
        const nodeStartLine = hasLoc ? nodeLoc.start.line : 0;
        const nodeEndLine = hasLoc ? nodeLoc.end.line : 0;
        let lastLine = 0;
        let leadingCommentNewline = 0;
        const maybeNewline = this._noLineTerminator ? function() {
        } : this.newline.bind(this);
        for (let i = 0; i < len; i++) {
          const comment = comments[i];
          const shouldPrint = this._shouldPrintComment(comment, nextToken);
          if (shouldPrint === 2) {
            hasLoc = false;
            break;
          }
          if (hasLoc && comment.loc && shouldPrint === 1) {
            const commentStartLine = comment.loc.start.line;
            const commentEndLine = comment.loc.end.line;
            if (type === 0) {
              let offset = 0;
              if (i === 0) {
                if (this._buf.hasContent() && (comment.type === "CommentLine" || commentStartLine !== commentEndLine)) {
                  offset = leadingCommentNewline = 1;
                }
              } else {
                offset = commentStartLine - lastLine;
              }
              lastLine = commentEndLine;
              maybeNewline(offset);
              this._printComment(comment, 1);
              if (i + 1 === len) {
                maybeNewline(Math.max(nodeStartLine - lastLine, leadingCommentNewline));
                lastLine = nodeStartLine;
              }
            } else if (type === 1) {
              const offset = commentStartLine - (i === 0 ? nodeStartLine : lastLine);
              lastLine = commentEndLine;
              maybeNewline(offset);
              this._printComment(comment, 1);
              if (i + 1 === len) {
                maybeNewline(Math.min(1, nodeEndLine - lastLine));
                lastLine = nodeEndLine;
              }
            } else {
              const offset = commentStartLine - (i === 0 ? nodeEndLine - lineOffset : lastLine);
              lastLine = commentEndLine;
              maybeNewline(offset);
              this._printComment(comment, 1);
            }
          } else {
            hasLoc = false;
            if (shouldPrint !== 1) {
              continue;
            }
            if (len === 1) {
              const singleLine = comment.loc ? comment.loc.start.line === comment.loc.end.line : !HAS_NEWLINE.test(comment.value);
              const shouldSkipNewline = singleLine && !isStatement2(node) && !isClassBody(parent) && !isTSInterfaceBody(parent) && !isTSEnumMember(node);
              if (type === 0) {
                this._printComment(comment, shouldSkipNewline && node.type !== "ObjectExpression" || singleLine && isFunction(parent, {
                  body: node
                }) ? 1 : 0);
              } else if (shouldSkipNewline && type === 2) {
                this._printComment(comment, 1);
              } else {
                this._printComment(comment, 0);
              }
            } else if (type === 1 && !(node.type === "ObjectExpression" && node.properties.length > 1) && node.type !== "ClassBody" && node.type !== "TSInterfaceBody") {
              this._printComment(comment, i === 0 ? 2 : i === len - 1 ? 3 : 0);
            } else {
              this._printComment(comment, 0);
            }
          }
        }
        if (type === 2 && hasLoc && lastLine) {
          this._lastCommentLine = lastLine;
        }
      }
    };
    Object.assign(Printer.prototype, generatorFunctions);
    {
      (0, _deprecated.addDeprecatedGenerators)(Printer);
    }
    var _default3 = exports2.default = Printer;
    function commaSeparator(occurrenceCount, last) {
      this.token(",", false, occurrenceCount);
      if (!last) this.space();
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/generator/lib/index.js
var require_lib = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/generator/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    exports2.generate = generate2;
    var _sourceMap = require_source_map();
    var _printer = require_printer();
    function normalizeOptions(code, opts, ast) {
      if (opts.experimental_preserveFormat) {
        if (typeof code !== "string") {
          throw new Error("`experimental_preserveFormat` requires the original `code` to be passed to @babel/generator as a string");
        }
        if (!opts.retainLines) {
          throw new Error("`experimental_preserveFormat` requires `retainLines` to be set to `true`");
        }
        if (opts.compact && opts.compact !== "auto") {
          throw new Error("`experimental_preserveFormat` is not compatible with the `compact` option");
        }
        if (opts.minified) {
          throw new Error("`experimental_preserveFormat` is not compatible with the `minified` option");
        }
        if (opts.jsescOption) {
          throw new Error("`experimental_preserveFormat` is not compatible with the `jsescOption` option");
        }
        if (!Array.isArray(ast.tokens)) {
          throw new Error("`experimental_preserveFormat` requires the AST to have attatched the token of the input code. Make sure to enable the `tokens: true` parser option.");
        }
      }
      const format = {
        auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
        auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
        shouldPrintComment: opts.shouldPrintComment,
        preserveFormat: opts.experimental_preserveFormat,
        retainLines: opts.retainLines,
        retainFunctionParens: opts.retainFunctionParens,
        comments: opts.comments == null || opts.comments,
        compact: opts.compact,
        minified: opts.minified,
        concise: opts.concise,
        indent: {
          adjustMultilineComment: true,
          style: "  "
        },
        jsescOption: Object.assign({
          quotes: "double",
          wrap: true,
          minimal: false
        }, opts.jsescOption),
        topicToken: opts.topicToken,
        importAttributesKeyword: opts.importAttributesKeyword
      };
      {
        var _opts$recordAndTupleS;
        format.decoratorsBeforeExport = opts.decoratorsBeforeExport;
        format.jsescOption.json = opts.jsonCompatibleStrings;
        format.recordAndTupleSyntaxType = (_opts$recordAndTupleS = opts.recordAndTupleSyntaxType) != null ? _opts$recordAndTupleS : "hash";
      }
      if (format.minified) {
        format.compact = true;
        format.shouldPrintComment = format.shouldPrintComment || (() => format.comments);
      } else {
        format.shouldPrintComment = format.shouldPrintComment || ((value) => format.comments || value.includes("@license") || value.includes("@preserve"));
      }
      if (format.compact === "auto") {
        format.compact = typeof code === "string" && code.length > 5e5;
        if (format.compact) {
          console.error(`[BABEL] Note: The code generator has deoptimised the styling of ${opts.filename} as it exceeds the max of ${"500KB"}.`);
        }
      }
      if (format.compact || format.preserveFormat) {
        format.indent.adjustMultilineComment = false;
      }
      const {
        auxiliaryCommentBefore,
        auxiliaryCommentAfter,
        shouldPrintComment
      } = format;
      if (auxiliaryCommentBefore && !shouldPrintComment(auxiliaryCommentBefore)) {
        format.auxiliaryCommentBefore = void 0;
      }
      if (auxiliaryCommentAfter && !shouldPrintComment(auxiliaryCommentAfter)) {
        format.auxiliaryCommentAfter = void 0;
      }
      return format;
    }
    {
      exports2.CodeGenerator = class CodeGenerator {
        constructor(ast, opts = {}, code) {
          this._ast = void 0;
          this._format = void 0;
          this._map = void 0;
          this._ast = ast;
          this._format = normalizeOptions(code, opts, ast);
          this._map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
        }
        generate() {
          const printer = new _printer.default(this._format, this._map);
          return printer.generate(this._ast);
        }
      };
    }
    function generate2(ast, opts = {}, code) {
      const format = normalizeOptions(code, opts, ast);
      const map2 = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
      const printer = new _printer.default(format, map2, ast.tokens, typeof code === "string" ? code : null);
      return printer.generate(ast);
    }
    var _default3 = exports2.default = generate2;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/ancestry.js
var require_ancestry = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/ancestry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.find = find;
    exports2.findParent = findParent;
    exports2.getAncestry = getAncestry;
    exports2.getDeepestCommonAncestorFrom = getDeepestCommonAncestorFrom;
    exports2.getEarliestCommonAncestorFrom = getEarliestCommonAncestorFrom;
    exports2.getFunctionParent = getFunctionParent;
    exports2.getStatementParent = getStatementParent;
    exports2.inType = inType;
    exports2.isAncestor = isAncestor;
    exports2.isDescendant = isDescendant;
    var _t = require("@babel/types");
    var {
      VISITOR_KEYS
    } = _t;
    function findParent(callback) {
      let path = this;
      while (path = path.parentPath) {
        if (callback(path)) return path;
      }
      return null;
    }
    function find(callback) {
      let path = this;
      do {
        if (callback(path)) return path;
      } while (path = path.parentPath);
      return null;
    }
    function getFunctionParent() {
      return this.findParent((p) => p.isFunction());
    }
    function getStatementParent() {
      let path = this;
      do {
        if (!path.parentPath || Array.isArray(path.container) && path.isStatement()) {
          break;
        } else {
          path = path.parentPath;
        }
      } while (path);
      if (path && (path.isProgram() || path.isFile())) {
        throw new Error("File/Program node, we can't possibly find a statement parent to this");
      }
      return path;
    }
    function getEarliestCommonAncestorFrom(paths) {
      return this.getDeepestCommonAncestorFrom(paths, function(deepest, i, ancestries) {
        let earliest;
        const keys = VISITOR_KEYS[deepest.type];
        for (const ancestry of ancestries) {
          const path = ancestry[i + 1];
          if (!earliest) {
            earliest = path;
            continue;
          }
          if (path.listKey && earliest.listKey === path.listKey) {
            if (path.key < earliest.key) {
              earliest = path;
              continue;
            }
          }
          const earliestKeyIndex = keys.indexOf(earliest.parentKey);
          const currentKeyIndex = keys.indexOf(path.parentKey);
          if (earliestKeyIndex > currentKeyIndex) {
            earliest = path;
          }
        }
        return earliest;
      });
    }
    function getDeepestCommonAncestorFrom(paths, filter) {
      if (!paths.length) {
        return this;
      }
      if (paths.length === 1) {
        return paths[0];
      }
      let minDepth = Infinity;
      let lastCommonIndex, lastCommon;
      const ancestries = paths.map((path) => {
        const ancestry = [];
        do {
          ancestry.unshift(path);
        } while ((path = path.parentPath) && path !== this);
        if (ancestry.length < minDepth) {
          minDepth = ancestry.length;
        }
        return ancestry;
      });
      const first = ancestries[0];
      depthLoop: for (let i = 0; i < minDepth; i++) {
        const shouldMatch = first[i];
        for (const ancestry of ancestries) {
          if (ancestry[i] !== shouldMatch) {
            break depthLoop;
          }
        }
        lastCommonIndex = i;
        lastCommon = shouldMatch;
      }
      if (lastCommon) {
        if (filter) {
          return filter(lastCommon, lastCommonIndex, ancestries);
        } else {
          return lastCommon;
        }
      } else {
        throw new Error("Couldn't find intersection");
      }
    }
    function getAncestry() {
      let path = this;
      const paths = [];
      do {
        paths.push(path);
      } while (path = path.parentPath);
      return paths;
    }
    function isAncestor(maybeDescendant) {
      return maybeDescendant.isDescendant(this);
    }
    function isDescendant(maybeAncestor) {
      return !!this.findParent((parent) => parent === maybeAncestor);
    }
    function inType(...candidateTypes) {
      let path = this;
      while (path) {
        for (const type of candidateTypes) {
          if (path.node.type === type) return true;
        }
        path = path.parentPath;
      }
      return false;
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/util.js
var require_util = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/util.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.createUnionType = createUnionType;
    var _t = require("@babel/types");
    var {
      createFlowUnionType,
      createTSUnionType,
      createUnionTypeAnnotation,
      isFlowType,
      isTSType: isTSType2
    } = _t;
    function createUnionType(types) {
      {
        if (types.every((v) => isFlowType(v))) {
          if (createFlowUnionType) {
            return createFlowUnionType(types);
          }
          return createUnionTypeAnnotation(types);
        } else if (types.every((v) => isTSType2(v))) {
          if (createTSUnionType) {
            return createTSUnionType(types);
          }
        }
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/inferer-reference.js
var require_inferer_reference = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/inferer-reference.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = _default3;
    var _t = require("@babel/types");
    var _util = require_util();
    var {
      BOOLEAN_NUMBER_BINARY_OPERATORS,
      createTypeAnnotationBasedOnTypeof,
      numberTypeAnnotation,
      voidTypeAnnotation
    } = _t;
    function _default3(node) {
      if (!this.isReferenced()) return;
      const binding = this.scope.getBinding(node.name);
      if (binding) {
        if (binding.identifier.typeAnnotation) {
          return binding.identifier.typeAnnotation;
        } else {
          return getTypeAnnotationBindingConstantViolations(binding, this, node.name);
        }
      }
      if (node.name === "undefined") {
        return voidTypeAnnotation();
      } else if (node.name === "NaN" || node.name === "Infinity") {
        return numberTypeAnnotation();
      } else if (node.name === "arguments") {
      }
    }
    function getTypeAnnotationBindingConstantViolations(binding, path, name) {
      const types = [];
      const functionConstantViolations = [];
      let constantViolations = getConstantViolationsBefore(binding, path, functionConstantViolations);
      const testType = getConditionalAnnotation(binding, path, name);
      if (testType) {
        const testConstantViolations = getConstantViolationsBefore(binding, testType.ifStatement);
        constantViolations = constantViolations.filter((path2) => !testConstantViolations.includes(path2));
        types.push(testType.typeAnnotation);
      }
      if (constantViolations.length) {
        constantViolations.push(...functionConstantViolations);
        for (const violation of constantViolations) {
          types.push(violation.getTypeAnnotation());
        }
      }
      if (!types.length) {
        return;
      }
      return (0, _util.createUnionType)(types);
    }
    function getConstantViolationsBefore(binding, path, functions) {
      const violations = binding.constantViolations.slice();
      violations.unshift(binding.path);
      return violations.filter((violation) => {
        violation = violation.resolve();
        const status = violation._guessExecutionStatusRelativeTo(path);
        if (functions && status === "unknown") functions.push(violation);
        return status === "before";
      });
    }
    function inferAnnotationFromBinaryExpression(name, path) {
      const operator = path.node.operator;
      const right = path.get("right").resolve();
      const left = path.get("left").resolve();
      let target;
      if (left.isIdentifier({
        name
      })) {
        target = right;
      } else if (right.isIdentifier({
        name
      })) {
        target = left;
      }
      if (target) {
        if (operator === "===") {
          return target.getTypeAnnotation();
        }
        if (BOOLEAN_NUMBER_BINARY_OPERATORS.includes(operator)) {
          return numberTypeAnnotation();
        }
        return;
      }
      if (operator !== "===" && operator !== "==") return;
      let typeofPath;
      let typePath;
      if (left.isUnaryExpression({
        operator: "typeof"
      })) {
        typeofPath = left;
        typePath = right;
      } else if (right.isUnaryExpression({
        operator: "typeof"
      })) {
        typeofPath = right;
        typePath = left;
      }
      if (!typeofPath) return;
      if (!typeofPath.get("argument").isIdentifier({
        name
      })) return;
      typePath = typePath.resolve();
      if (!typePath.isLiteral()) return;
      const typeValue = typePath.node.value;
      if (typeof typeValue !== "string") return;
      return createTypeAnnotationBasedOnTypeof(typeValue);
    }
    function getParentConditionalPath(binding, path, name) {
      let parentPath;
      while (parentPath = path.parentPath) {
        if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
          if (path.key === "test") {
            return;
          }
          return parentPath;
        }
        if (parentPath.isFunction()) {
          if (parentPath.parentPath.scope.getBinding(name) !== binding) return;
        }
        path = parentPath;
      }
    }
    function getConditionalAnnotation(binding, path, name) {
      const ifStatement3 = getParentConditionalPath(binding, path, name);
      if (!ifStatement3) return;
      const test = ifStatement3.get("test");
      const paths = [test];
      const types = [];
      for (let i = 0; i < paths.length; i++) {
        const path2 = paths[i];
        if (path2.isLogicalExpression()) {
          if (path2.node.operator === "&&") {
            paths.push(path2.get("left"));
            paths.push(path2.get("right"));
          }
        } else if (path2.isBinaryExpression()) {
          const type = inferAnnotationFromBinaryExpression(name, path2);
          if (type) types.push(type);
        }
      }
      if (types.length) {
        return {
          typeAnnotation: (0, _util.createUnionType)(types),
          ifStatement: ifStatement3
        };
      }
      return getConditionalAnnotation(binding, ifStatement3, name);
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/inferers.js
var require_inferers = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/inferers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ArrayExpression = ArrayExpression6;
    exports2.AssignmentExpression = AssignmentExpression;
    exports2.BinaryExpression = BinaryExpression;
    exports2.BooleanLiteral = BooleanLiteral;
    exports2.CallExpression = CallExpression4;
    exports2.ConditionalExpression = ConditionalExpression;
    exports2.ClassDeclaration = exports2.ClassExpression = exports2.FunctionDeclaration = exports2.ArrowFunctionExpression = exports2.FunctionExpression = Func;
    Object.defineProperty(exports2, "Identifier", {
      enumerable: true,
      get: function() {
        return _infererReference.default;
      }
    });
    exports2.LogicalExpression = LogicalExpression;
    exports2.NewExpression = NewExpression;
    exports2.NullLiteral = NullLiteral;
    exports2.NumericLiteral = NumericLiteral;
    exports2.ObjectExpression = ObjectExpression;
    exports2.ParenthesizedExpression = ParenthesizedExpression;
    exports2.RegExpLiteral = RegExpLiteral;
    exports2.RestElement = RestElement;
    exports2.SequenceExpression = SequenceExpression;
    exports2.StringLiteral = StringLiteral;
    exports2.TSAsExpression = TSAsExpression;
    exports2.TSNonNullExpression = TSNonNullExpression;
    exports2.TaggedTemplateExpression = TaggedTemplateExpression;
    exports2.TemplateLiteral = TemplateLiteral;
    exports2.TypeCastExpression = TypeCastExpression;
    exports2.UnaryExpression = UnaryExpression;
    exports2.UpdateExpression = UpdateExpression;
    exports2.VariableDeclarator = VariableDeclarator;
    var _t = require("@babel/types");
    var _infererReference = require_inferer_reference();
    var _util = require_util();
    var {
      BOOLEAN_BINARY_OPERATORS,
      BOOLEAN_UNARY_OPERATORS,
      NUMBER_BINARY_OPERATORS,
      NUMBER_UNARY_OPERATORS,
      STRING_UNARY_OPERATORS,
      anyTypeAnnotation,
      arrayTypeAnnotation,
      booleanTypeAnnotation,
      buildMatchMemberExpression,
      genericTypeAnnotation,
      identifier: identifier4,
      nullLiteralTypeAnnotation,
      numberTypeAnnotation,
      stringTypeAnnotation,
      tupleTypeAnnotation,
      unionTypeAnnotation,
      voidTypeAnnotation,
      isIdentifier
    } = _t;
    function VariableDeclarator() {
      if (!this.get("id").isIdentifier()) return;
      return this.get("init").getTypeAnnotation();
    }
    function TypeCastExpression(node) {
      return node.typeAnnotation;
    }
    TypeCastExpression.validParent = true;
    function TSAsExpression(node) {
      return node.typeAnnotation;
    }
    TSAsExpression.validParent = true;
    function TSNonNullExpression() {
      return this.get("expression").getTypeAnnotation();
    }
    function NewExpression(node) {
      if (node.callee.type === "Identifier") {
        return genericTypeAnnotation(node.callee);
      }
    }
    function TemplateLiteral() {
      return stringTypeAnnotation();
    }
    function UnaryExpression(node) {
      const operator = node.operator;
      if (operator === "void") {
        return voidTypeAnnotation();
      } else if (NUMBER_UNARY_OPERATORS.includes(operator)) {
        return numberTypeAnnotation();
      } else if (STRING_UNARY_OPERATORS.includes(operator)) {
        return stringTypeAnnotation();
      } else if (BOOLEAN_UNARY_OPERATORS.includes(operator)) {
        return booleanTypeAnnotation();
      }
    }
    function BinaryExpression(node) {
      const operator = node.operator;
      if (NUMBER_BINARY_OPERATORS.includes(operator)) {
        return numberTypeAnnotation();
      } else if (BOOLEAN_BINARY_OPERATORS.includes(operator)) {
        return booleanTypeAnnotation();
      } else if (operator === "+") {
        const right = this.get("right");
        const left = this.get("left");
        if (left.isBaseType("number") && right.isBaseType("number")) {
          return numberTypeAnnotation();
        } else if (left.isBaseType("string") || right.isBaseType("string")) {
          return stringTypeAnnotation();
        }
        return unionTypeAnnotation([stringTypeAnnotation(), numberTypeAnnotation()]);
      }
    }
    function LogicalExpression() {
      const argumentTypes = [this.get("left").getTypeAnnotation(), this.get("right").getTypeAnnotation()];
      return (0, _util.createUnionType)(argumentTypes);
    }
    function ConditionalExpression() {
      const argumentTypes = [this.get("consequent").getTypeAnnotation(), this.get("alternate").getTypeAnnotation()];
      return (0, _util.createUnionType)(argumentTypes);
    }
    function SequenceExpression() {
      return this.get("expressions").pop().getTypeAnnotation();
    }
    function ParenthesizedExpression() {
      return this.get("expression").getTypeAnnotation();
    }
    function AssignmentExpression() {
      return this.get("right").getTypeAnnotation();
    }
    function UpdateExpression(node) {
      const operator = node.operator;
      if (operator === "++" || operator === "--") {
        return numberTypeAnnotation();
      }
    }
    function StringLiteral() {
      return stringTypeAnnotation();
    }
    function NumericLiteral() {
      return numberTypeAnnotation();
    }
    function BooleanLiteral() {
      return booleanTypeAnnotation();
    }
    function NullLiteral() {
      return nullLiteralTypeAnnotation();
    }
    function RegExpLiteral() {
      return genericTypeAnnotation(identifier4("RegExp"));
    }
    function ObjectExpression() {
      return genericTypeAnnotation(identifier4("Object"));
    }
    function ArrayExpression6() {
      return genericTypeAnnotation(identifier4("Array"));
    }
    function RestElement() {
      return ArrayExpression6();
    }
    RestElement.validParent = true;
    function Func() {
      return genericTypeAnnotation(identifier4("Function"));
    }
    var isArrayFrom = buildMatchMemberExpression("Array.from");
    var isObjectKeys = buildMatchMemberExpression("Object.keys");
    var isObjectValues = buildMatchMemberExpression("Object.values");
    var isObjectEntries = buildMatchMemberExpression("Object.entries");
    function CallExpression4() {
      const {
        callee
      } = this.node;
      if (isObjectKeys(callee)) {
        return arrayTypeAnnotation(stringTypeAnnotation());
      } else if (isArrayFrom(callee) || isObjectValues(callee) || isIdentifier(callee, {
        name: "Array"
      })) {
        return arrayTypeAnnotation(anyTypeAnnotation());
      } else if (isObjectEntries(callee)) {
        return arrayTypeAnnotation(tupleTypeAnnotation([stringTypeAnnotation(), anyTypeAnnotation()]));
      }
      return resolveCall(this.get("callee"));
    }
    function TaggedTemplateExpression() {
      return resolveCall(this.get("tag"));
    }
    function resolveCall(callee) {
      callee = callee.resolve();
      if (callee.isFunction()) {
        const {
          node
        } = callee;
        if (node.async) {
          if (node.generator) {
            return genericTypeAnnotation(identifier4("AsyncIterator"));
          } else {
            return genericTypeAnnotation(identifier4("Promise"));
          }
        } else {
          if (node.generator) {
            return genericTypeAnnotation(identifier4("Iterator"));
          } else if (callee.node.returnType) {
            return callee.node.returnType;
          } else {
          }
        }
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/index.js
var require_inference = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/inference/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2._getTypeAnnotation = _getTypeAnnotation;
    exports2.baseTypeStrictlyMatches = baseTypeStrictlyMatches;
    exports2.couldBeBaseType = couldBeBaseType;
    exports2.getTypeAnnotation = getTypeAnnotation;
    exports2.isBaseType = isBaseType;
    exports2.isGenericType = isGenericType;
    var inferers = require_inferers();
    var _t = require("@babel/types");
    var {
      anyTypeAnnotation,
      isAnyTypeAnnotation,
      isArrayTypeAnnotation,
      isBooleanTypeAnnotation,
      isEmptyTypeAnnotation,
      isFlowBaseAnnotation,
      isGenericTypeAnnotation,
      isIdentifier,
      isMixedTypeAnnotation,
      isNumberTypeAnnotation,
      isStringTypeAnnotation,
      isTSArrayType,
      isTSTypeAnnotation,
      isTSTypeReference,
      isTupleTypeAnnotation,
      isTypeAnnotation,
      isUnionTypeAnnotation,
      isVoidTypeAnnotation,
      stringTypeAnnotation,
      voidTypeAnnotation
    } = _t;
    function getTypeAnnotation() {
      let type = this.getData("typeAnnotation");
      if (type != null) {
        return type;
      }
      type = _getTypeAnnotation.call(this) || anyTypeAnnotation();
      if (isTypeAnnotation(type) || isTSTypeAnnotation(type)) {
        type = type.typeAnnotation;
      }
      this.setData("typeAnnotation", type);
      return type;
    }
    var typeAnnotationInferringNodes = /* @__PURE__ */ new WeakSet();
    function _getTypeAnnotation() {
      const node = this.node;
      if (!node) {
        if (this.key === "init" && this.parentPath.isVariableDeclarator()) {
          const declar = this.parentPath.parentPath;
          const declarParent = declar.parentPath;
          if (declar.key === "left" && declarParent.isForInStatement()) {
            return stringTypeAnnotation();
          }
          if (declar.key === "left" && declarParent.isForOfStatement()) {
            return anyTypeAnnotation();
          }
          return voidTypeAnnotation();
        } else {
          return;
        }
      }
      if (node.typeAnnotation) {
        return node.typeAnnotation;
      }
      if (typeAnnotationInferringNodes.has(node)) {
        return;
      }
      typeAnnotationInferringNodes.add(node);
      try {
        var _inferer;
        let inferer = inferers[node.type];
        if (inferer) {
          return inferer.call(this, node);
        }
        inferer = inferers[this.parentPath.type];
        if ((_inferer = inferer) != null && _inferer.validParent) {
          return this.parentPath.getTypeAnnotation();
        }
      } finally {
        typeAnnotationInferringNodes.delete(node);
      }
    }
    function isBaseType(baseName, soft) {
      return _isBaseType(baseName, this.getTypeAnnotation(), soft);
    }
    function _isBaseType(baseName, type, soft) {
      if (baseName === "string") {
        return isStringTypeAnnotation(type);
      } else if (baseName === "number") {
        return isNumberTypeAnnotation(type);
      } else if (baseName === "boolean") {
        return isBooleanTypeAnnotation(type);
      } else if (baseName === "any") {
        return isAnyTypeAnnotation(type);
      } else if (baseName === "mixed") {
        return isMixedTypeAnnotation(type);
      } else if (baseName === "empty") {
        return isEmptyTypeAnnotation(type);
      } else if (baseName === "void") {
        return isVoidTypeAnnotation(type);
      } else {
        if (soft) {
          return false;
        } else {
          throw new Error(`Unknown base type ${baseName}`);
        }
      }
    }
    function couldBeBaseType(name) {
      const type = this.getTypeAnnotation();
      if (isAnyTypeAnnotation(type)) return true;
      if (isUnionTypeAnnotation(type)) {
        for (const type2 of type.types) {
          if (isAnyTypeAnnotation(type2) || _isBaseType(name, type2, true)) {
            return true;
          }
        }
        return false;
      } else {
        return _isBaseType(name, type, true);
      }
    }
    function baseTypeStrictlyMatches(rightArg) {
      const left = this.getTypeAnnotation();
      const right = rightArg.getTypeAnnotation();
      if (!isAnyTypeAnnotation(left) && isFlowBaseAnnotation(left)) {
        return right.type === left.type;
      }
      return false;
    }
    function isGenericType(genericName) {
      const type = this.getTypeAnnotation();
      if (genericName === "Array") {
        if (isTSArrayType(type) || isArrayTypeAnnotation(type) || isTupleTypeAnnotation(type)) {
          return true;
        }
      }
      return isGenericTypeAnnotation(type) && isIdentifier(type.id, {
        name: genericName
      }) || isTSTypeReference(type) && isIdentifier(type.typeName, {
        name: genericName
      });
    }
  }
});

// ../../node_modules/picocolors/picocolors.js
var require_picocolors = __commonJS({
  "../../node_modules/picocolors/picocolors.js"(exports2, module2) {
    "use strict";
    var p = process || {};
    var argv = p.argv || [];
    var env = p.env || {};
    var isColorSupported = !(!!env.NO_COLOR || argv.includes("--no-color")) && (!!env.FORCE_COLOR || argv.includes("--color") || p.platform === "win32" || (p.stdout || {}).isTTY && env.TERM !== "dumb" || !!env.CI);
    var formatter = (open, close, replace = open) => (input) => {
      let string4 = "" + input, index = string4.indexOf(close, open.length);
      return ~index ? open + replaceClose(string4, close, replace, index) + close : open + string4 + close;
    };
    var replaceClose = (string4, close, replace, index) => {
      let result = "", cursor = 0;
      do {
        result += string4.substring(cursor, index) + replace;
        cursor = index + close.length;
        index = string4.indexOf(close, cursor);
      } while (~index);
      return result + string4.substring(cursor);
    };
    var createColors = (enabled = isColorSupported) => {
      let f = enabled ? formatter : () => String;
      return {
        isColorSupported: enabled,
        reset: f("\x1B[0m", "\x1B[0m"),
        bold: f("\x1B[1m", "\x1B[22m", "\x1B[22m\x1B[1m"),
        dim: f("\x1B[2m", "\x1B[22m", "\x1B[22m\x1B[2m"),
        italic: f("\x1B[3m", "\x1B[23m"),
        underline: f("\x1B[4m", "\x1B[24m"),
        inverse: f("\x1B[7m", "\x1B[27m"),
        hidden: f("\x1B[8m", "\x1B[28m"),
        strikethrough: f("\x1B[9m", "\x1B[29m"),
        black: f("\x1B[30m", "\x1B[39m"),
        red: f("\x1B[31m", "\x1B[39m"),
        green: f("\x1B[32m", "\x1B[39m"),
        yellow: f("\x1B[33m", "\x1B[39m"),
        blue: f("\x1B[34m", "\x1B[39m"),
        magenta: f("\x1B[35m", "\x1B[39m"),
        cyan: f("\x1B[36m", "\x1B[39m"),
        white: f("\x1B[37m", "\x1B[39m"),
        gray: f("\x1B[90m", "\x1B[39m"),
        bgBlack: f("\x1B[40m", "\x1B[49m"),
        bgRed: f("\x1B[41m", "\x1B[49m"),
        bgGreen: f("\x1B[42m", "\x1B[49m"),
        bgYellow: f("\x1B[43m", "\x1B[49m"),
        bgBlue: f("\x1B[44m", "\x1B[49m"),
        bgMagenta: f("\x1B[45m", "\x1B[49m"),
        bgCyan: f("\x1B[46m", "\x1B[49m"),
        bgWhite: f("\x1B[47m", "\x1B[49m"),
        blackBright: f("\x1B[90m", "\x1B[39m"),
        redBright: f("\x1B[91m", "\x1B[39m"),
        greenBright: f("\x1B[92m", "\x1B[39m"),
        yellowBright: f("\x1B[93m", "\x1B[39m"),
        blueBright: f("\x1B[94m", "\x1B[39m"),
        magentaBright: f("\x1B[95m", "\x1B[39m"),
        cyanBright: f("\x1B[96m", "\x1B[39m"),
        whiteBright: f("\x1B[97m", "\x1B[39m"),
        bgBlackBright: f("\x1B[100m", "\x1B[49m"),
        bgRedBright: f("\x1B[101m", "\x1B[49m"),
        bgGreenBright: f("\x1B[102m", "\x1B[49m"),
        bgYellowBright: f("\x1B[103m", "\x1B[49m"),
        bgBlueBright: f("\x1B[104m", "\x1B[49m"),
        bgMagentaBright: f("\x1B[105m", "\x1B[49m"),
        bgCyanBright: f("\x1B[106m", "\x1B[49m"),
        bgWhiteBright: f("\x1B[107m", "\x1B[49m")
      };
    };
    module2.exports = createColors();
    module2.exports.createColors = createColors;
  }
});

// ../../node_modules/js-tokens/index.js
var require_js_tokens = __commonJS({
  "../../node_modules/js-tokens/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
    exports2.matchToToken = function(match) {
      var token2 = { type: "invalid", value: match[0], closed: void 0 };
      if (match[1]) token2.type = "string", token2.closed = !!(match[3] || match[4]);
      else if (match[5]) token2.type = "comment";
      else if (match[6]) token2.type = "comment", token2.closed = !!match[7];
      else if (match[8]) token2.type = "regex";
      else if (match[9]) token2.type = "number";
      else if (match[10]) token2.type = "name";
      else if (match[11]) token2.type = "punctuator";
      else if (match[12]) token2.type = "whitespace";
      return token2;
    };
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/identifier.js
var require_identifier = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/identifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isIdentifierChar = isIdentifierChar;
    exports2.isIdentifierName = isIdentifierName;
    exports2.isIdentifierStart = isIdentifierStart;
    var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C8A\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CD\uA7D0\uA7D1\uA7D3\uA7D5-\uA7DC\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    var nonASCIIidentifierChars = "\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0897-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u200C\u200D\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\u30FB\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F\uFF65";
    var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];
    var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    function isInAstralSet(code, set2) {
      let pos2 = 65536;
      for (let i = 0, length = set2.length; i < length; i += 2) {
        pos2 += set2[i];
        if (pos2 > code) return false;
        pos2 += set2[i + 1];
        if (pos2 >= code) return true;
      }
      return false;
    }
    function isIdentifierStart(code) {
      if (code < 65) return code === 36;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes);
    }
    function isIdentifierChar(code) {
      if (code < 48) return code === 36;
      if (code < 58) return true;
      if (code < 65) return false;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
    }
    function isIdentifierName(name) {
      let isFirst = true;
      for (let i = 0; i < name.length; i++) {
        let cp = name.charCodeAt(i);
        if ((cp & 64512) === 55296 && i + 1 < name.length) {
          const trail = name.charCodeAt(++i);
          if ((trail & 64512) === 56320) {
            cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
          }
        }
        if (isFirst) {
          isFirst = false;
          if (!isIdentifierStart(cp)) {
            return false;
          }
        } else if (!isIdentifierChar(cp)) {
          return false;
        }
      }
      return !isFirst;
    }
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/keyword.js
var require_keyword = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/keyword.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isKeyword = isKeyword;
    exports2.isReservedWord = isReservedWord2;
    exports2.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
    exports2.isStrictBindReservedWord = isStrictBindReservedWord;
    exports2.isStrictReservedWord = isStrictReservedWord;
    var reservedWords = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    var keywords = new Set(reservedWords.keyword);
    var reservedWordsStrictSet = new Set(reservedWords.strict);
    var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
    function isReservedWord2(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }
    function isStrictReservedWord(word, inModule) {
      return isReservedWord2(word, inModule) || reservedWordsStrictSet.has(word);
    }
    function isStrictBindOnlyReservedWord(word) {
      return reservedWordsStrictBindSet.has(word);
    }
    function isStrictBindReservedWord(word, inModule) {
      return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
    }
    function isKeyword(word) {
      return keywords.has(word);
    }
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/index.js
var require_lib2 = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    Object.defineProperty(exports2, "isIdentifierChar", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierChar;
      }
    });
    Object.defineProperty(exports2, "isIdentifierName", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierName;
      }
    });
    Object.defineProperty(exports2, "isIdentifierStart", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierStart;
      }
    });
    Object.defineProperty(exports2, "isKeyword", {
      enumerable: true,
      get: function() {
        return _keyword.isKeyword;
      }
    });
    Object.defineProperty(exports2, "isReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindOnlyReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindOnlyReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictReservedWord;
      }
    });
    var _identifier = require_identifier();
    var _keyword = require_keyword();
  }
});

// ../../node_modules/@babel/code-frame/lib/index.js
var require_lib3 = __commonJS({
  "../../node_modules/@babel/code-frame/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var picocolors = require_picocolors();
    var jsTokens = require_js_tokens();
    var helperValidatorIdentifier = require_lib2();
    function isColorSupported() {
      return typeof process === "object" && (process.env.FORCE_COLOR === "0" || process.env.FORCE_COLOR === "false") ? false : picocolors.isColorSupported;
    }
    var compose = (f, g) => (v) => f(g(v));
    function buildDefs(colors) {
      return {
        keyword: colors.cyan,
        capitalized: colors.yellow,
        jsxIdentifier: colors.yellow,
        punctuator: colors.yellow,
        number: colors.magenta,
        string: colors.green,
        regex: colors.magenta,
        comment: colors.gray,
        invalid: compose(compose(colors.white, colors.bgRed), colors.bold),
        gutter: colors.gray,
        marker: compose(colors.red, colors.bold),
        message: compose(colors.red, colors.bold),
        reset: colors.reset
      };
    }
    var defsOn = buildDefs(picocolors.createColors(true));
    var defsOff = buildDefs(picocolors.createColors(false));
    function getDefs(enabled) {
      return enabled ? defsOn : defsOff;
    }
    var sometimesKeywords = /* @__PURE__ */ new Set(["as", "async", "from", "get", "of", "set"]);
    var NEWLINE$1 = /\r\n|[\n\r\u2028\u2029]/;
    var BRACKET = /^[()[\]{}]$/;
    var tokenize;
    {
      const JSX_TAG = /^[a-z][\w-]*$/i;
      const getTokenType = function(token2, offset, text) {
        if (token2.type === "name") {
          if (helperValidatorIdentifier.isKeyword(token2.value) || helperValidatorIdentifier.isStrictReservedWord(token2.value, true) || sometimesKeywords.has(token2.value)) {
            return "keyword";
          }
          if (JSX_TAG.test(token2.value) && (text[offset - 1] === "<" || text.slice(offset - 2, offset) === "</")) {
            return "jsxIdentifier";
          }
          if (token2.value[0] !== token2.value[0].toLowerCase()) {
            return "capitalized";
          }
        }
        if (token2.type === "punctuator" && BRACKET.test(token2.value)) {
          return "bracket";
        }
        if (token2.type === "invalid" && (token2.value === "@" || token2.value === "#")) {
          return "punctuator";
        }
        return token2.type;
      };
      tokenize = function* (text) {
        let match;
        while (match = jsTokens.default.exec(text)) {
          const token2 = jsTokens.matchToToken(match);
          yield {
            type: getTokenType(token2, match.index, text),
            value: token2.value
          };
        }
      };
    }
    function highlight(text) {
      if (text === "") return "";
      const defs = getDefs(true);
      let highlighted = "";
      for (const {
        type,
        value
      } of tokenize(text)) {
        if (type in defs) {
          highlighted += value.split(NEWLINE$1).map((str) => defs[type](str)).join("\n");
        } else {
          highlighted += value;
        }
      }
      return highlighted;
    }
    var deprecationWarningShown = false;
    var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
    function getMarkerLines(loc, source2, opts) {
      const startLoc = Object.assign({
        column: 0,
        line: -1
      }, loc.start);
      const endLoc = Object.assign({}, startLoc, loc.end);
      const {
        linesAbove = 2,
        linesBelow = 3
      } = opts || {};
      const startLine = startLoc.line;
      const startColumn = startLoc.column;
      const endLine = endLoc.line;
      const endColumn = endLoc.column;
      let start = Math.max(startLine - (linesAbove + 1), 0);
      let end = Math.min(source2.length, endLine + linesBelow);
      if (startLine === -1) {
        start = 0;
      }
      if (endLine === -1) {
        end = source2.length;
      }
      const lineDiff = endLine - startLine;
      const markerLines = {};
      if (lineDiff) {
        for (let i = 0; i <= lineDiff; i++) {
          const lineNumber = i + startLine;
          if (!startColumn) {
            markerLines[lineNumber] = true;
          } else if (i === 0) {
            const sourceLength = source2[lineNumber - 1].length;
            markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
          } else if (i === lineDiff) {
            markerLines[lineNumber] = [0, endColumn];
          } else {
            const sourceLength = source2[lineNumber - i].length;
            markerLines[lineNumber] = [0, sourceLength];
          }
        }
      } else {
        if (startColumn === endColumn) {
          if (startColumn) {
            markerLines[startLine] = [startColumn, 0];
          } else {
            markerLines[startLine] = true;
          }
        } else {
          markerLines[startLine] = [startColumn, endColumn - startColumn];
        }
      }
      return {
        start,
        end,
        markerLines
      };
    }
    function codeFrameColumns2(rawLines, loc, opts = {}) {
      const shouldHighlight = opts.forceColor || isColorSupported() && opts.highlightCode;
      const defs = getDefs(shouldHighlight);
      const lines = rawLines.split(NEWLINE);
      const {
        start,
        end,
        markerLines
      } = getMarkerLines(loc, lines, opts);
      const hasColumns = loc.start && typeof loc.start.column === "number";
      const numberMaxWidth = String(end).length;
      const highlightedLines = shouldHighlight ? highlight(rawLines) : rawLines;
      let frame = highlightedLines.split(NEWLINE, end).slice(start, end).map((line2, index2) => {
        const number4 = start + 1 + index2;
        const paddedNumber = ` ${number4}`.slice(-numberMaxWidth);
        const gutter = ` ${paddedNumber} |`;
        const hasMarker = markerLines[number4];
        const lastMarkerLine = !markerLines[number4 + 1];
        if (hasMarker) {
          let markerLine = "";
          if (Array.isArray(hasMarker)) {
            const markerSpacing = line2.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
            const numberOfMarkers = hasMarker[1] || 1;
            markerLine = ["\n ", defs.gutter(gutter.replace(/\d/g, " ")), " ", markerSpacing, defs.marker("^").repeat(numberOfMarkers)].join("");
            if (lastMarkerLine && opts.message) {
              markerLine += " " + defs.message(opts.message);
            }
          }
          return [defs.marker(">"), defs.gutter(gutter), line2.length > 0 ? ` ${line2}` : "", markerLine].join("");
        } else {
          return ` ${defs.gutter(gutter)}${line2.length > 0 ? ` ${line2}` : ""}`;
        }
      }).join("\n");
      if (opts.message && !hasColumns) {
        frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}
${frame}`;
      }
      if (shouldHighlight) {
        return defs.reset(frame);
      } else {
        return frame;
      }
    }
    function index(rawLines, lineNumber, colNumber, opts = {}) {
      if (!deprecationWarningShown) {
        deprecationWarningShown = true;
        const message = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";
        if (process.emitWarning) {
          process.emitWarning(message, "DeprecationWarning");
        } else {
          const deprecationError = new Error(message);
          deprecationError.name = "DeprecationWarning";
          console.warn(new Error(message));
        }
      }
      colNumber = Math.max(colNumber, 0);
      const location = {
        start: {
          column: colNumber,
          line: lineNumber
        }
      };
      return codeFrameColumns2(rawLines, location, opts);
    }
    exports2.codeFrameColumns = codeFrameColumns2;
    exports2.default = index;
    exports2.highlight = highlight;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/hoister.js
var require_hoister = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/hoister.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _t = require("@babel/types");
    var _t2 = _t;
    var {
      react
    } = _t;
    var {
      cloneNode: cloneNode2,
      jsxExpressionContainer: jsxExpressionContainer2,
      variableDeclaration: variableDeclaration4,
      variableDeclarator: variableDeclarator4
    } = _t2;
    var referenceVisitor = {
      ReferencedIdentifier(path, state) {
        if (path.isJSXIdentifier() && react.isCompatTag(path.node.name) && !path.parentPath.isJSXMemberExpression()) {
          return;
        }
        if (path.node.name === "this") {
          let scope = path.scope;
          do {
            if (scope.path.isFunction() && !scope.path.isArrowFunctionExpression()) {
              break;
            }
          } while (scope = scope.parent);
          if (scope) state.breakOnScopePaths.push(scope.path);
        }
        const binding = path.scope.getBinding(path.node.name);
        if (!binding) return;
        for (const violation of binding.constantViolations) {
          if (violation.scope !== binding.path.scope) {
            state.mutableBinding = true;
            path.stop();
            return;
          }
        }
        if (binding !== state.scope.getBinding(path.node.name)) return;
        state.bindings[path.node.name] = binding;
      }
    };
    var PathHoister = class {
      constructor(path, scope) {
        this.breakOnScopePaths = void 0;
        this.bindings = void 0;
        this.mutableBinding = void 0;
        this.scopes = void 0;
        this.scope = void 0;
        this.path = void 0;
        this.attachAfter = void 0;
        this.breakOnScopePaths = [];
        this.bindings = {};
        this.mutableBinding = false;
        this.scopes = [];
        this.scope = scope;
        this.path = path;
        this.attachAfter = false;
      }
      isCompatibleScope(scope) {
        for (const key2 of Object.keys(this.bindings)) {
          const binding = this.bindings[key2];
          if (!scope.bindingIdentifierEquals(key2, binding.identifier)) {
            return false;
          }
        }
        return true;
      }
      getCompatibleScopes() {
        let scope = this.path.scope;
        do {
          if (this.isCompatibleScope(scope)) {
            this.scopes.push(scope);
          } else {
            break;
          }
          if (this.breakOnScopePaths.includes(scope.path)) {
            break;
          }
        } while (scope = scope.parent);
      }
      getAttachmentPath() {
        let path = this._getAttachmentPath();
        if (!path) return;
        let targetScope = path.scope;
        if (targetScope.path === path) {
          targetScope = path.scope.parent;
        }
        if (targetScope.path.isProgram() || targetScope.path.isFunction()) {
          for (const name of Object.keys(this.bindings)) {
            if (!targetScope.hasOwnBinding(name)) continue;
            const binding = this.bindings[name];
            if (binding.kind === "param" || binding.path.parentKey === "params") {
              continue;
            }
            const bindingParentPath = this.getAttachmentParentForPath(binding.path);
            if (bindingParentPath.key >= path.key) {
              this.attachAfter = true;
              path = binding.path;
              for (const violationPath of binding.constantViolations) {
                if (this.getAttachmentParentForPath(violationPath).key > path.key) {
                  path = violationPath;
                }
              }
            }
          }
        }
        return path;
      }
      _getAttachmentPath() {
        const scopes = this.scopes;
        const scope = scopes.pop();
        if (!scope) return;
        if (scope.path.isFunction()) {
          if (this.hasOwnParamBindings(scope)) {
            if (this.scope === scope) return;
            const bodies = scope.path.get("body").get("body");
            for (let i = 0; i < bodies.length; i++) {
              if (bodies[i].node._blockHoist) continue;
              return bodies[i];
            }
          } else {
            return this.getNextScopeAttachmentParent();
          }
        } else if (scope.path.isProgram()) {
          return this.getNextScopeAttachmentParent();
        }
      }
      getNextScopeAttachmentParent() {
        const scope = this.scopes.pop();
        if (scope) return this.getAttachmentParentForPath(scope.path);
      }
      getAttachmentParentForPath(path) {
        do {
          if (!path.parentPath || Array.isArray(path.container) && path.isStatement()) {
            return path;
          }
        } while (path = path.parentPath);
      }
      hasOwnParamBindings(scope) {
        for (const name of Object.keys(this.bindings)) {
          if (!scope.hasOwnBinding(name)) continue;
          const binding = this.bindings[name];
          if (binding.kind === "param" && binding.constant) return true;
        }
        return false;
      }
      run() {
        this.path.traverse(referenceVisitor, this);
        if (this.mutableBinding) return;
        this.getCompatibleScopes();
        const attachTo = this.getAttachmentPath();
        if (!attachTo) return;
        if (attachTo.getFunctionParent() === this.path.getFunctionParent()) return;
        let uid = attachTo.scope.generateUidIdentifier("ref");
        const declarator = variableDeclarator4(uid, this.path.node);
        const insertFn = this.attachAfter ? "insertAfter" : "insertBefore";
        const [attached] = attachTo[insertFn]([attachTo.isVariableDeclarator() ? declarator : variableDeclaration4("var", [declarator])]);
        const parent = this.path.parentPath;
        if (parent.isJSXElement() && this.path.container === parent.node.children) {
          uid = jsxExpressionContainer2(uid);
        }
        this.path.replaceWith(cloneNode2(uid));
        return attachTo.isVariableDeclarator() ? attached.get("init") : attached.get("declarations.0.init");
      }
    };
    exports2.default = PathHoister;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/removal-hooks.js
var require_removal_hooks = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/lib/removal-hooks.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.hooks = void 0;
    var hooks = exports2.hooks = [function(self2, parent) {
      const removeParent = self2.key === "test" && (parent.isWhile() || parent.isSwitchCase()) || self2.key === "declaration" && parent.isExportDeclaration() || self2.key === "body" && parent.isLabeledStatement() || self2.listKey === "declarations" && parent.isVariableDeclaration() && parent.node.declarations.length === 1 || self2.key === "expression" && parent.isExpressionStatement();
      if (removeParent) {
        parent.remove();
        return true;
      }
    }, function(self2, parent) {
      if (parent.isSequenceExpression() && parent.node.expressions.length === 1) {
        parent.replaceWith(parent.node.expressions[0]);
        return true;
      }
    }, function(self2, parent) {
      if (parent.isBinary()) {
        if (self2.key === "left") {
          parent.replaceWith(parent.node.right);
        } else {
          parent.replaceWith(parent.node.left);
        }
        return true;
      }
    }, function(self2, parent) {
      if (parent.isIfStatement() && self2.key === "consequent" || self2.key === "body" && (parent.isLoop() || parent.isArrowFunctionExpression())) {
        self2.replaceWith({
          type: "BlockStatement",
          body: []
        });
        return true;
      }
    }];
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/removal.js
var require_removal = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/removal.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2._assertUnremoved = _assertUnremoved;
    exports2._callRemovalHooks = _callRemovalHooks;
    exports2._markRemoved = _markRemoved;
    exports2._remove = _remove;
    exports2._removeFromScope = _removeFromScope;
    exports2.remove = remove;
    var _removalHooks = require_removal_hooks();
    var _cache = require_cache();
    var _replacement = require_replacement();
    var _index = require_path();
    var _t = require("@babel/types");
    var _modification = require_modification();
    var _context3 = require_context2();
    var {
      getBindingIdentifiers
    } = _t;
    function remove() {
      var _this$opts;
      _assertUnremoved.call(this);
      _context3.resync.call(this);
      if (_callRemovalHooks.call(this)) {
        _markRemoved.call(this);
        return;
      }
      if (!((_this$opts = this.opts) != null && _this$opts.noScope)) {
        _removeFromScope.call(this);
      }
      this.shareCommentsWithSiblings();
      _remove.call(this);
      _markRemoved.call(this);
    }
    function _removeFromScope() {
      const bindings = getBindingIdentifiers(this.node, false, false, true);
      Object.keys(bindings).forEach((name) => this.scope.removeBinding(name));
    }
    function _callRemovalHooks() {
      if (this.parentPath) {
        for (const fn of _removalHooks.hooks) {
          if (fn(this, this.parentPath)) return true;
        }
      }
    }
    function _remove() {
      if (Array.isArray(this.container)) {
        this.container.splice(this.key, 1);
        _modification.updateSiblingKeys.call(this, this.key, -1);
      } else {
        _replacement._replaceWith.call(this, null);
      }
    }
    function _markRemoved() {
      this._traverseFlags |= _index.SHOULD_SKIP | _index.REMOVED;
      if (this.parent) {
        (0, _cache.getCachedPaths)(this.hub, this.parent).delete(this.node);
      }
      this.node = null;
    }
    function _assertUnremoved() {
      if (this.removed) {
        throw this.buildCodeFrameError("NodePath has been removed so is read-only.");
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/modification.js
var require_modification = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/modification.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2._containerInsert = _containerInsert;
    exports2._containerInsertAfter = _containerInsertAfter;
    exports2._containerInsertBefore = _containerInsertBefore;
    exports2._verifyNodeList = _verifyNodeList;
    exports2.insertAfter = insertAfter;
    exports2.insertBefore = insertBefore;
    exports2.pushContainer = pushContainer;
    exports2.unshiftContainer = unshiftContainer;
    exports2.updateSiblingKeys = updateSiblingKeys;
    var _cache = require_cache();
    var _hoister = require_hoister();
    var _index = require_path();
    var _context3 = require_context2();
    var _removal = require_removal();
    var _t = require("@babel/types");
    var {
      arrowFunctionExpression: arrowFunctionExpression2,
      assertExpression,
      assignmentExpression: assignmentExpression2,
      blockStatement: blockStatement3,
      callExpression: callExpression4,
      cloneNode: cloneNode2,
      expressionStatement: expressionStatement2,
      isAssignmentExpression,
      isCallExpression,
      isExportNamedDeclaration,
      isExpression: isExpression2,
      isIdentifier,
      isSequenceExpression,
      isSuper,
      thisExpression
    } = _t;
    function insertBefore(nodes_) {
      _removal._assertUnremoved.call(this);
      const nodes = _verifyNodeList.call(this, nodes_);
      const {
        parentPath,
        parent
      } = this;
      if (parentPath.isExpressionStatement() || parentPath.isLabeledStatement() || isExportNamedDeclaration(parent) || parentPath.isExportDefaultDeclaration() && this.isDeclaration()) {
        return parentPath.insertBefore(nodes);
      } else if (this.isNodeType("Expression") && !this.isJSXElement() || parentPath.isForStatement() && this.key === "init") {
        if (this.node) nodes.push(this.node);
        return this.replaceExpressionWithStatements(nodes);
      } else if (Array.isArray(this.container)) {
        return _containerInsertBefore.call(this, nodes);
      } else if (this.isStatementOrBlock()) {
        const node = this.node;
        const shouldInsertCurrentNode = node && (!this.isExpressionStatement() || node.expression != null);
        this.replaceWith(blockStatement3(shouldInsertCurrentNode ? [node] : []));
        return this.unshiftContainer("body", nodes);
      } else {
        throw new Error("We don't know what to do with this node type. We were previously a Statement but we can't fit in here?");
      }
    }
    function _containerInsert(from, nodes) {
      updateSiblingKeys.call(this, from, nodes.length);
      const paths = [];
      this.container.splice(from, 0, ...nodes);
      for (let i = 0; i < nodes.length; i++) {
        var _this$context;
        const to = from + i;
        const path = this.getSibling(to);
        paths.push(path);
        if ((_this$context = this.context) != null && _this$context.queue) {
          _context3.pushContext.call(path, this.context);
        }
      }
      const contexts = _context3._getQueueContexts.call(this);
      for (const path of paths) {
        _context3.setScope.call(path);
        path.debug("Inserted.");
        for (const context of contexts) {
          context.maybeQueue(path, true);
        }
      }
      return paths;
    }
    function _containerInsertBefore(nodes) {
      return _containerInsert.call(this, this.key, nodes);
    }
    function _containerInsertAfter(nodes) {
      return _containerInsert.call(this, this.key + 1, nodes);
    }
    var last = (arr) => arr[arr.length - 1];
    function isHiddenInSequenceExpression(path) {
      return isSequenceExpression(path.parent) && (last(path.parent.expressions) !== path.node || isHiddenInSequenceExpression(path.parentPath));
    }
    function isAlmostConstantAssignment(node, scope) {
      if (!isAssignmentExpression(node) || !isIdentifier(node.left)) {
        return false;
      }
      const blockScope = scope.getBlockParent();
      return blockScope.hasOwnBinding(node.left.name) && blockScope.getOwnBinding(node.left.name).constantViolations.length <= 1;
    }
    function insertAfter(nodes_) {
      _removal._assertUnremoved.call(this);
      if (this.isSequenceExpression()) {
        return last(this.get("expressions")).insertAfter(nodes_);
      }
      const nodes = _verifyNodeList.call(this, nodes_);
      const {
        parentPath,
        parent
      } = this;
      if (parentPath.isExpressionStatement() || parentPath.isLabeledStatement() || isExportNamedDeclaration(parent) || parentPath.isExportDefaultDeclaration() && this.isDeclaration()) {
        return parentPath.insertAfter(nodes.map((node) => {
          return isExpression2(node) ? expressionStatement2(node) : node;
        }));
      } else if (this.isNodeType("Expression") && !this.isJSXElement() && !parentPath.isJSXElement() || parentPath.isForStatement() && this.key === "init") {
        const self2 = this;
        if (self2.node) {
          const node = self2.node;
          let {
            scope
          } = this;
          if (scope.path.isPattern()) {
            assertExpression(node);
            self2.replaceWith(callExpression4(arrowFunctionExpression2([], node), []));
            self2.get("callee.body").insertAfter(nodes);
            return [self2];
          }
          if (isHiddenInSequenceExpression(self2)) {
            nodes.unshift(node);
          } else if (isCallExpression(node) && isSuper(node.callee)) {
            nodes.unshift(node);
            nodes.push(thisExpression());
          } else if (isAlmostConstantAssignment(node, scope)) {
            nodes.unshift(node);
            nodes.push(cloneNode2(node.left));
          } else if (scope.isPure(node, true)) {
            nodes.push(node);
          } else {
            if (parentPath.isMethod({
              computed: true,
              key: node
            })) {
              scope = scope.parent;
            }
            const temp = scope.generateDeclaredUidIdentifier();
            nodes.unshift(expressionStatement2(assignmentExpression2("=", cloneNode2(temp), node)));
            nodes.push(expressionStatement2(cloneNode2(temp)));
          }
        }
        return this.replaceExpressionWithStatements(nodes);
      } else if (Array.isArray(this.container)) {
        return _containerInsertAfter.call(this, nodes);
      } else if (this.isStatementOrBlock()) {
        const node = this.node;
        const shouldInsertCurrentNode = node && (!this.isExpressionStatement() || node.expression != null);
        this.replaceWith(blockStatement3(shouldInsertCurrentNode ? [node] : []));
        return this.pushContainer("body", nodes);
      } else {
        throw new Error("We don't know what to do with this node type. We were previously a Statement but we can't fit in here?");
      }
    }
    function updateSiblingKeys(fromIndex, incrementBy) {
      if (!this.parent) return;
      const paths = (0, _cache.getCachedPaths)(this.hub, this.parent) || [];
      for (const [, path] of paths) {
        if (typeof path.key === "number" && path.container === this.container && path.key >= fromIndex) {
          path.key += incrementBy;
        }
      }
    }
    function _verifyNodeList(nodes) {
      if (!nodes) {
        return [];
      }
      if (!Array.isArray(nodes)) {
        nodes = [nodes];
      }
      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        let msg;
        if (!node) {
          msg = "has falsy node";
        } else if (typeof node !== "object") {
          msg = "contains a non-object node";
        } else if (!node.type) {
          msg = "without a type";
        } else if (node instanceof _index.default) {
          msg = "has a NodePath when it expected a raw object";
        }
        if (msg) {
          const type = Array.isArray(node) ? "array" : typeof node;
          throw new Error(`Node list ${msg} with the index of ${i} and type of ${type}`);
        }
      }
      return nodes;
    }
    function unshiftContainer(listKey, nodes) {
      _removal._assertUnremoved.call(this);
      nodes = _verifyNodeList.call(this, nodes);
      const path = _index.default.get({
        parentPath: this,
        parent: this.node,
        container: this.node[listKey],
        listKey,
        key: 0
      }).setContext(this.context);
      return _containerInsertBefore.call(path, nodes);
    }
    function pushContainer(listKey, nodes) {
      _removal._assertUnremoved.call(this);
      const verifiedNodes = _verifyNodeList.call(this, nodes);
      const container = this.node[listKey];
      const path = _index.default.get({
        parentPath: this,
        parent: this.node,
        container,
        listKey,
        key: container.length
      }).setContext(this.context);
      return path.replaceWithMultiple(verifiedNodes);
    }
    {
      exports2.hoist = function hoist(scope = this.scope) {
        const hoister = new _hoister.default(this, scope);
        return hoister.run();
      };
    }
  }
});

// ../../node_modules/@babel/parser/lib/index.js
var require_lib4 = __commonJS({
  "../../node_modules/@babel/parser/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    function _objectWithoutPropertiesLoose(r, e) {
      if (null == r) return {};
      var t6 = {};
      for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
        if (-1 !== e.indexOf(n)) continue;
        t6[n] = r[n];
      }
      return t6;
    }
    var Position = class {
      constructor(line2, col, index) {
        this.line = void 0;
        this.column = void 0;
        this.index = void 0;
        this.line = line2;
        this.column = col;
        this.index = index;
      }
    };
    var SourceLocation22 = class {
      constructor(start, end) {
        this.start = void 0;
        this.end = void 0;
        this.filename = void 0;
        this.identifierName = void 0;
        this.start = start;
        this.end = end;
      }
    };
    function createPositionWithColumnOffset(position, columnOffset) {
      const {
        line: line2,
        column: column2,
        index
      } = position;
      return new Position(line2, column2 + columnOffset, index + columnOffset);
    }
    var code = "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED";
    var ModuleErrors = {
      ImportMetaOutsideModule: {
        message: `import.meta may appear only with 'sourceType: "module"'`,
        code
      },
      ImportOutsideModule: {
        message: `'import' and 'export' may appear only with 'sourceType: "module"'`,
        code
      }
    };
    var NodeDescriptions = {
      ArrayPattern: "array destructuring pattern",
      AssignmentExpression: "assignment expression",
      AssignmentPattern: "assignment expression",
      ArrowFunctionExpression: "arrow function expression",
      ConditionalExpression: "conditional expression",
      CatchClause: "catch clause",
      ForOfStatement: "for-of statement",
      ForInStatement: "for-in statement",
      ForStatement: "for-loop",
      FormalParameters: "function parameter list",
      Identifier: "identifier",
      ImportSpecifier: "import specifier",
      ImportDefaultSpecifier: "import default specifier",
      ImportNamespaceSpecifier: "import namespace specifier",
      ObjectPattern: "object destructuring pattern",
      ParenthesizedExpression: "parenthesized expression",
      RestElement: "rest element",
      UpdateExpression: {
        true: "prefix operation",
        false: "postfix operation"
      },
      VariableDeclarator: "variable declaration",
      YieldExpression: "yield expression"
    };
    var toNodeDescription = (node) => node.type === "UpdateExpression" ? NodeDescriptions.UpdateExpression[`${node.prefix}`] : NodeDescriptions[node.type];
    var StandardErrors = {
      AccessorIsGenerator: ({
        kind
      }) => `A ${kind}ter cannot be a generator.`,
      ArgumentsInClass: "'arguments' is only allowed in functions and class methods.",
      AsyncFunctionInSingleStatementContext: "Async functions can only be declared at the top level or inside a block.",
      AwaitBindingIdentifier: "Can not use 'await' as identifier inside an async function.",
      AwaitBindingIdentifierInStaticBlock: "Can not use 'await' as identifier inside a static block.",
      AwaitExpressionFormalParameter: "'await' is not allowed in async function parameters.",
      AwaitUsingNotInAsyncContext: "'await using' is only allowed within async functions and at the top levels of modules.",
      AwaitNotInAsyncContext: "'await' is only allowed within async functions and at the top levels of modules.",
      BadGetterArity: "A 'get' accessor must not have any formal parameters.",
      BadSetterArity: "A 'set' accessor must have exactly one formal parameter.",
      BadSetterRestParameter: "A 'set' accessor function argument must not be a rest parameter.",
      ConstructorClassField: "Classes may not have a field named 'constructor'.",
      ConstructorClassPrivateField: "Classes may not have a private field named '#constructor'.",
      ConstructorIsAccessor: "Class constructor may not be an accessor.",
      ConstructorIsAsync: "Constructor can't be an async function.",
      ConstructorIsGenerator: "Constructor can't be a generator.",
      DeclarationMissingInitializer: ({
        kind
      }) => `Missing initializer in ${kind} declaration.`,
      DecoratorArgumentsOutsideParentheses: "Decorator arguments must be moved inside parentheses: use '@(decorator(args))' instead of '@(decorator)(args)'.",
      DecoratorBeforeExport: "Decorators must be placed *before* the 'export' keyword. Remove the 'decoratorsBeforeExport: true' option to use the 'export @decorator class {}' syntax.",
      DecoratorsBeforeAfterExport: "Decorators can be placed *either* before or after the 'export' keyword, but not in both locations at the same time.",
      DecoratorConstructor: "Decorators can't be used with a constructor. Did you mean '@dec class { ... }'?",
      DecoratorExportClass: "Decorators must be placed *after* the 'export' keyword. Remove the 'decoratorsBeforeExport: false' option to use the '@decorator export class {}' syntax.",
      DecoratorSemicolon: "Decorators must not be followed by a semicolon.",
      DecoratorStaticBlock: "Decorators can't be used with a static block.",
      DeferImportRequiresNamespace: 'Only `import defer * as x from "./module"` is valid.',
      DeletePrivateField: "Deleting a private field is not allowed.",
      DestructureNamedImport: "ES2015 named imports do not destructure. Use another statement for destructuring after the import.",
      DuplicateConstructor: "Duplicate constructor in the same class.",
      DuplicateDefaultExport: "Only one default export allowed per module.",
      DuplicateExport: ({
        exportName
      }) => `\`${exportName}\` has already been exported. Exported identifiers must be unique.`,
      DuplicateProto: "Redefinition of __proto__ property.",
      DuplicateRegExpFlags: "Duplicate regular expression flag.",
      DynamicImportPhaseRequiresImportExpressions: ({
        phase
      }) => `'import.${phase}(...)' can only be parsed when using the 'createImportExpressions' option.`,
      ElementAfterRest: "Rest element must be last element.",
      EscapedCharNotAnIdentifier: "Invalid Unicode escape.",
      ExportBindingIsString: ({
        localName,
        exportName
      }) => `A string literal cannot be used as an exported binding without \`from\`.
- Did you mean \`export { '${localName}' as '${exportName}' } from 'some-module'\`?`,
      ExportDefaultFromAsIdentifier: "'from' is not allowed as an identifier after 'export default'.",
      ForInOfLoopInitializer: ({
        type
      }) => `'${type === "ForInStatement" ? "for-in" : "for-of"}' loop variable declaration may not have an initializer.`,
      ForInUsing: "For-in loop may not start with 'using' declaration.",
      ForOfAsync: "The left-hand side of a for-of loop may not be 'async'.",
      ForOfLet: "The left-hand side of a for-of loop may not start with 'let'.",
      GeneratorInSingleStatementContext: "Generators can only be declared at the top level or inside a block.",
      IllegalBreakContinue: ({
        type
      }) => `Unsyntactic ${type === "BreakStatement" ? "break" : "continue"}.`,
      IllegalLanguageModeDirective: "Illegal 'use strict' directive in function with non-simple parameter list.",
      IllegalReturn: "'return' outside of function.",
      ImportAttributesUseAssert: "The `assert` keyword in import attributes is deprecated and it has been replaced by the `with` keyword. You can enable the `deprecatedImportAssert` parser plugin to suppress this error.",
      ImportBindingIsString: ({
        importName
      }) => `A string literal cannot be used as an imported binding.
- Did you mean \`import { "${importName}" as foo }\`?`,
      ImportCallArity: `\`import()\` requires exactly one or two arguments.`,
      ImportCallNotNewExpression: "Cannot use new with import(...).",
      ImportCallSpreadArgument: "`...` is not allowed in `import()`.",
      ImportJSONBindingNotDefault: "A JSON module can only be imported with `default`.",
      ImportReflectionHasAssertion: "`import module x` cannot have assertions.",
      ImportReflectionNotBinding: 'Only `import module x from "./module"` is valid.',
      IncompatibleRegExpUVFlags: "The 'u' and 'v' regular expression flags cannot be enabled at the same time.",
      InvalidBigIntLiteral: "Invalid BigIntLiteral.",
      InvalidCodePoint: "Code point out of bounds.",
      InvalidCoverInitializedName: "Invalid shorthand property initializer.",
      InvalidDecimal: "Invalid decimal.",
      InvalidDigit: ({
        radix
      }) => `Expected number in radix ${radix}.`,
      InvalidEscapeSequence: "Bad character escape sequence.",
      InvalidEscapeSequenceTemplate: "Invalid escape sequence in template.",
      InvalidEscapedReservedWord: ({
        reservedWord
      }) => `Escape sequence in keyword ${reservedWord}.`,
      InvalidIdentifier: ({
        identifierName
      }) => `Invalid identifier ${identifierName}.`,
      InvalidLhs: ({
        ancestor
      }) => `Invalid left-hand side in ${toNodeDescription(ancestor)}.`,
      InvalidLhsBinding: ({
        ancestor
      }) => `Binding invalid left-hand side in ${toNodeDescription(ancestor)}.`,
      InvalidLhsOptionalChaining: ({
        ancestor
      }) => `Invalid optional chaining in the left-hand side of ${toNodeDescription(ancestor)}.`,
      InvalidNumber: "Invalid number.",
      InvalidOrMissingExponent: "Floating-point numbers require a valid exponent after the 'e'.",
      InvalidOrUnexpectedToken: ({
        unexpected
      }) => `Unexpected character '${unexpected}'.`,
      InvalidParenthesizedAssignment: "Invalid parenthesized assignment pattern.",
      InvalidPrivateFieldResolution: ({
        identifierName
      }) => `Private name #${identifierName} is not defined.`,
      InvalidPropertyBindingPattern: "Binding member expression.",
      InvalidRecordProperty: "Only properties and spread elements are allowed in record definitions.",
      InvalidRestAssignmentPattern: "Invalid rest operator's argument.",
      LabelRedeclaration: ({
        labelName
      }) => `Label '${labelName}' is already declared.`,
      LetInLexicalBinding: "'let' is disallowed as a lexically bound name.",
      LineTerminatorBeforeArrow: "No line break is allowed before '=>'.",
      MalformedRegExpFlags: "Invalid regular expression flag.",
      MissingClassName: "A class name is required.",
      MissingEqInAssignment: "Only '=' operator can be used for specifying default value.",
      MissingSemicolon: "Missing semicolon.",
      MissingPlugin: ({
        missingPlugin
      }) => `This experimental syntax requires enabling the parser plugin: ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
      MissingOneOfPlugins: ({
        missingPlugin
      }) => `This experimental syntax requires enabling one of the following parser plugin(s): ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
      MissingUnicodeEscape: "Expecting Unicode escape sequence \\uXXXX.",
      MixingCoalesceWithLogical: "Nullish coalescing operator(??) requires parens when mixing with logical operators.",
      ModuleAttributeDifferentFromType: "The only accepted module attribute is `type`.",
      ModuleAttributeInvalidValue: "Only string literals are allowed as module attribute values.",
      ModuleAttributesWithDuplicateKeys: ({
        key: key2
      }) => `Duplicate key "${key2}" is not allowed in module attributes.`,
      ModuleExportNameHasLoneSurrogate: ({
        surrogateCharCode
      }) => `An export name cannot include a lone surrogate, found '\\u${surrogateCharCode.toString(16)}'.`,
      ModuleExportUndefined: ({
        localName
      }) => `Export '${localName}' is not defined.`,
      MultipleDefaultsInSwitch: "Multiple default clauses.",
      NewlineAfterThrow: "Illegal newline after throw.",
      NoCatchOrFinally: "Missing catch or finally clause.",
      NumberIdentifier: "Identifier directly after number.",
      NumericSeparatorInEscapeSequence: "Numeric separators are not allowed inside unicode escape sequences or hex escape sequences.",
      ObsoleteAwaitStar: "'await*' has been removed from the async functions proposal. Use Promise.all() instead.",
      OptionalChainingNoNew: "Constructors in/after an Optional Chain are not allowed.",
      OptionalChainingNoTemplate: "Tagged Template Literals are not allowed in optionalChain.",
      OverrideOnConstructor: "'override' modifier cannot appear on a constructor declaration.",
      ParamDupe: "Argument name clash.",
      PatternHasAccessor: "Object pattern can't contain getter or setter.",
      PatternHasMethod: "Object pattern can't contain methods.",
      PrivateInExpectedIn: ({
        identifierName
      }) => `Private names are only allowed in property accesses (\`obj.#${identifierName}\`) or in \`in\` expressions (\`#${identifierName} in obj\`).`,
      PrivateNameRedeclaration: ({
        identifierName
      }) => `Duplicate private name #${identifierName}.`,
      RecordExpressionBarIncorrectEndSyntaxType: "Record expressions ending with '|}' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
      RecordExpressionBarIncorrectStartSyntaxType: "Record expressions starting with '{|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
      RecordExpressionHashIncorrectStartSyntaxType: "Record expressions starting with '#{' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
      RecordNoProto: "'__proto__' is not allowed in Record expressions.",
      RestTrailingComma: "Unexpected trailing comma after rest element.",
      SloppyFunction: "In non-strict mode code, functions can only be declared at top level or inside a block.",
      SloppyFunctionAnnexB: "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement.",
      SourcePhaseImportRequiresDefault: 'Only `import source x from "./module"` is valid.',
      StaticPrototype: "Classes may not have static property named prototype.",
      SuperNotAllowed: "`super()` is only valid inside a class constructor of a subclass. Maybe a typo in the method name ('constructor') or not extending another class?",
      SuperPrivateField: "Private fields can't be accessed on super.",
      TrailingDecorator: "Decorators must be attached to a class element.",
      TupleExpressionBarIncorrectEndSyntaxType: "Tuple expressions ending with '|]' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
      TupleExpressionBarIncorrectStartSyntaxType: "Tuple expressions starting with '[|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
      TupleExpressionHashIncorrectStartSyntaxType: "Tuple expressions starting with '#[' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
      UnexpectedArgumentPlaceholder: "Unexpected argument placeholder.",
      UnexpectedAwaitAfterPipelineBody: 'Unexpected "await" after pipeline body; await must have parentheses in minimal proposal.',
      UnexpectedDigitAfterHash: "Unexpected digit after hash token.",
      UnexpectedImportExport: "'import' and 'export' may only appear at the top level.",
      UnexpectedKeyword: ({
        keyword
      }) => `Unexpected keyword '${keyword}'.`,
      UnexpectedLeadingDecorator: "Leading decorators must be attached to a class declaration.",
      UnexpectedLexicalDeclaration: "Lexical declaration cannot appear in a single-statement context.",
      UnexpectedNewTarget: "`new.target` can only be used in functions or class properties.",
      UnexpectedNumericSeparator: "A numeric separator is only allowed between two digits.",
      UnexpectedPrivateField: "Unexpected private name.",
      UnexpectedReservedWord: ({
        reservedWord
      }) => `Unexpected reserved word '${reservedWord}'.`,
      UnexpectedSuper: "'super' is only allowed in object methods and classes.",
      UnexpectedToken: ({
        expected,
        unexpected
      }) => `Unexpected token${unexpected ? ` '${unexpected}'.` : ""}${expected ? `, expected "${expected}"` : ""}`,
      UnexpectedTokenUnaryExponentiation: "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.",
      UnexpectedUsingDeclaration: "Using declaration cannot appear in the top level when source type is `script`.",
      UnsupportedBind: "Binding should be performed on object property.",
      UnsupportedDecoratorExport: "A decorated export must export a class declaration.",
      UnsupportedDefaultExport: "Only expressions, functions or classes are allowed as the `default` export.",
      UnsupportedImport: "`import` can only be used in `import()` or `import.meta`.",
      UnsupportedMetaProperty: ({
        target,
        onlyValidPropertyName
      }) => `The only valid meta property for ${target} is ${target}.${onlyValidPropertyName}.`,
      UnsupportedParameterDecorator: "Decorators cannot be used to decorate parameters.",
      UnsupportedPropertyDecorator: "Decorators cannot be used to decorate object literal properties.",
      UnsupportedSuper: "'super' can only be used with function calls (i.e. super()) or in property accesses (i.e. super.prop or super[prop]).",
      UnterminatedComment: "Unterminated comment.",
      UnterminatedRegExp: "Unterminated regular expression.",
      UnterminatedString: "Unterminated string constant.",
      UnterminatedTemplate: "Unterminated template.",
      UsingDeclarationExport: "Using declaration cannot be exported.",
      UsingDeclarationHasBindingPattern: "Using declaration cannot have destructuring patterns.",
      VarRedeclaration: ({
        identifierName
      }) => `Identifier '${identifierName}' has already been declared.`,
      YieldBindingIdentifier: "Can not use 'yield' as identifier inside a generator.",
      YieldInParameter: "Yield expression is not allowed in formal parameters.",
      YieldNotInGeneratorFunction: "'yield' is only allowed within generator functions.",
      ZeroDigitNumericSeparator: "Numeric separator can not be used after leading 0."
    };
    var StrictModeErrors = {
      StrictDelete: "Deleting local variable in strict mode.",
      StrictEvalArguments: ({
        referenceName
      }) => `Assigning to '${referenceName}' in strict mode.`,
      StrictEvalArgumentsBinding: ({
        bindingName
      }) => `Binding '${bindingName}' in strict mode.`,
      StrictFunction: "In strict mode code, functions can only be declared at top level or inside a block.",
      StrictNumericEscape: "The only valid numeric escape in strict mode is '\\0'.",
      StrictOctalLiteral: "Legacy octal literals are not allowed in strict mode.",
      StrictWith: "'with' in strict mode."
    };
    var UnparenthesizedPipeBodyDescriptions = /* @__PURE__ */ new Set(["ArrowFunctionExpression", "AssignmentExpression", "ConditionalExpression", "YieldExpression"]);
    var PipelineOperatorErrors = Object.assign({
      PipeBodyIsTighter: "Unexpected yield after pipeline body; any yield expression acting as Hack-style pipe body must be parenthesized due to its loose operator precedence.",
      PipeTopicRequiresHackPipes: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.',
      PipeTopicUnbound: "Topic reference is unbound; it must be inside a pipe body.",
      PipeTopicUnconfiguredToken: ({
        token: token2
      }) => `Invalid topic token ${token2}. In order to use ${token2} as a topic reference, the pipelineOperator plugin must be configured with { "proposal": "hack", "topicToken": "${token2}" }.`,
      PipeTopicUnused: "Hack-style pipe body does not contain a topic reference; Hack-style pipes must use topic at least once.",
      PipeUnparenthesizedBody: ({
        type
      }) => `Hack-style pipe body cannot be an unparenthesized ${toNodeDescription({
        type
      })}; please wrap it in parentheses.`
    }, {
      PipelineBodyNoArrow: 'Unexpected arrow "=>" after pipeline body; arrow function in pipeline body must be parenthesized.',
      PipelineBodySequenceExpression: "Pipeline body may not be a comma-separated sequence expression.",
      PipelineHeadSequenceExpression: "Pipeline head should not be a comma-separated sequence expression.",
      PipelineTopicUnused: "Pipeline is in topic style but does not use topic reference.",
      PrimaryTopicNotAllowed: "Topic reference was used in a lexical context without topic binding.",
      PrimaryTopicRequiresSmartPipeline: 'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.'
    });
    var _excluded = ["message"];
    function defineHidden(obj, key2, value) {
      Object.defineProperty(obj, key2, {
        enumerable: false,
        configurable: true,
        value
      });
    }
    function toParseErrorConstructor({
      toMessage,
      code: code2,
      reasonCode,
      syntaxPlugin
    }) {
      const hasMissingPlugin = reasonCode === "MissingPlugin" || reasonCode === "MissingOneOfPlugins";
      {
        const oldReasonCodes = {
          AccessorCannotDeclareThisParameter: "AccesorCannotDeclareThisParameter",
          AccessorCannotHaveTypeParameters: "AccesorCannotHaveTypeParameters",
          ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference: "ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference",
          SetAccessorCannotHaveOptionalParameter: "SetAccesorCannotHaveOptionalParameter",
          SetAccessorCannotHaveRestParameter: "SetAccesorCannotHaveRestParameter",
          SetAccessorCannotHaveReturnType: "SetAccesorCannotHaveReturnType"
        };
        if (oldReasonCodes[reasonCode]) {
          reasonCode = oldReasonCodes[reasonCode];
        }
      }
      return function constructor(loc, details) {
        const error45 = new SyntaxError();
        error45.code = code2;
        error45.reasonCode = reasonCode;
        error45.loc = loc;
        error45.pos = loc.index;
        error45.syntaxPlugin = syntaxPlugin;
        if (hasMissingPlugin) {
          error45.missingPlugin = details.missingPlugin;
        }
        defineHidden(error45, "clone", function clone2(overrides = {}) {
          var _overrides$loc;
          const {
            line: line2,
            column: column2,
            index
          } = (_overrides$loc = overrides.loc) != null ? _overrides$loc : loc;
          return constructor(new Position(line2, column2, index), Object.assign({}, details, overrides.details));
        });
        defineHidden(error45, "details", details);
        Object.defineProperty(error45, "message", {
          configurable: true,
          get() {
            const message = `${toMessage(details)} (${loc.line}:${loc.column})`;
            this.message = message;
            return message;
          },
          set(value) {
            Object.defineProperty(this, "message", {
              value,
              writable: true
            });
          }
        });
        return error45;
      };
    }
    function ParseErrorEnum(argument, syntaxPlugin) {
      if (Array.isArray(argument)) {
        return (parseErrorTemplates) => ParseErrorEnum(parseErrorTemplates, argument[0]);
      }
      const ParseErrorConstructors = {};
      for (const reasonCode of Object.keys(argument)) {
        const template = argument[reasonCode];
        const _ref = typeof template === "string" ? {
          message: () => template
        } : typeof template === "function" ? {
          message: template
        } : template, {
          message
        } = _ref, rest = _objectWithoutPropertiesLoose(_ref, _excluded);
        const toMessage = typeof message === "string" ? () => message : message;
        ParseErrorConstructors[reasonCode] = toParseErrorConstructor(Object.assign({
          code: "BABEL_PARSER_SYNTAX_ERROR",
          reasonCode,
          toMessage
        }, syntaxPlugin ? {
          syntaxPlugin
        } : {}, rest));
      }
      return ParseErrorConstructors;
    }
    var Errors = Object.assign({}, ParseErrorEnum(ModuleErrors), ParseErrorEnum(StandardErrors), ParseErrorEnum(StrictModeErrors), ParseErrorEnum`pipelineOperator`(PipelineOperatorErrors));
    function createDefaultOptions() {
      return {
        sourceType: "script",
        sourceFilename: void 0,
        startIndex: 0,
        startColumn: 0,
        startLine: 1,
        allowAwaitOutsideFunction: false,
        allowReturnOutsideFunction: false,
        allowNewTargetOutsideFunction: false,
        allowImportExportEverywhere: false,
        allowSuperOutsideMethod: false,
        allowUndeclaredExports: false,
        allowYieldOutsideFunction: false,
        plugins: [],
        strictMode: null,
        ranges: false,
        tokens: false,
        createImportExpressions: false,
        createParenthesizedExpressions: false,
        errorRecovery: false,
        attachComment: true,
        annexB: true
      };
    }
    function getOptions(opts) {
      const options = createDefaultOptions();
      if (opts == null) {
        return options;
      }
      if (opts.annexB != null && opts.annexB !== false) {
        throw new Error("The `annexB` option can only be set to `false`.");
      }
      for (const key2 of Object.keys(options)) {
        if (opts[key2] != null) options[key2] = opts[key2];
      }
      if (options.startLine === 1) {
        if (opts.startIndex == null && options.startColumn > 0) {
          options.startIndex = options.startColumn;
        } else if (opts.startColumn == null && options.startIndex > 0) {
          options.startColumn = options.startIndex;
        }
      } else if (opts.startColumn == null || opts.startIndex == null) {
        if (opts.startIndex != null) {
          throw new Error("With a `startLine > 1` you must also specify `startIndex` and `startColumn`.");
        }
      }
      return options;
    }
    var {
      defineProperty
    } = Object;
    var toUnenumerable = (object2, key2) => {
      if (object2) {
        defineProperty(object2, key2, {
          enumerable: false,
          value: object2[key2]
        });
      }
    };
    function toESTreeLocation(node) {
      toUnenumerable(node.loc.start, "index");
      toUnenumerable(node.loc.end, "index");
      return node;
    }
    var estree = (superClass) => class ESTreeParserMixin extends superClass {
      parse() {
        const file2 = toESTreeLocation(super.parse());
        if (this.optionFlags & 256) {
          file2.tokens = file2.tokens.map(toESTreeLocation);
        }
        return file2;
      }
      parseRegExpLiteral({
        pattern,
        flags
      }) {
        let regex = null;
        try {
          regex = new RegExp(pattern, flags);
        } catch (_) {
        }
        const node = this.estreeParseLiteral(regex);
        node.regex = {
          pattern,
          flags
        };
        return node;
      }
      parseBigIntLiteral(value) {
        let bigInt;
        try {
          bigInt = BigInt(value);
        } catch (_unused) {
          bigInt = null;
        }
        const node = this.estreeParseLiteral(bigInt);
        node.bigint = String(node.value || value);
        return node;
      }
      parseDecimalLiteral(value) {
        const decimal = null;
        const node = this.estreeParseLiteral(decimal);
        node.decimal = String(node.value || value);
        return node;
      }
      estreeParseLiteral(value) {
        return this.parseLiteral(value, "Literal");
      }
      parseStringLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      parseNumericLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      parseNullLiteral() {
        return this.estreeParseLiteral(null);
      }
      parseBooleanLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      directiveToStmt(directive2) {
        const expression = directive2.value;
        delete directive2.value;
        expression.type = "Literal";
        expression.raw = expression.extra.raw;
        expression.value = expression.extra.expressionValue;
        const stmt = directive2;
        stmt.type = "ExpressionStatement";
        stmt.expression = expression;
        stmt.directive = expression.extra.rawValue;
        delete expression.extra;
        return stmt;
      }
      initFunction(node, isAsync) {
        super.initFunction(node, isAsync);
        node.expression = false;
      }
      checkDeclaration(node) {
        if (node != null && this.isObjectProperty(node)) {
          this.checkDeclaration(node.value);
        } else {
          super.checkDeclaration(node);
        }
      }
      getObjectOrClassMethodParams(method) {
        return method.value.params;
      }
      isValidDirective(stmt) {
        var _stmt$expression$extr;
        return stmt.type === "ExpressionStatement" && stmt.expression.type === "Literal" && typeof stmt.expression.value === "string" && !((_stmt$expression$extr = stmt.expression.extra) != null && _stmt$expression$extr.parenthesized);
      }
      parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
        super.parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse);
        const directiveStatements = node.directives.map((d) => this.directiveToStmt(d));
        node.body = directiveStatements.concat(node.body);
        delete node.directives;
      }
      parsePrivateName() {
        const node = super.parsePrivateName();
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return node;
          }
        }
        return this.convertPrivateNameToPrivateIdentifier(node);
      }
      convertPrivateNameToPrivateIdentifier(node) {
        const name = super.getPrivateNameSV(node);
        node = node;
        delete node.id;
        node.name = name;
        node.type = "PrivateIdentifier";
        return node;
      }
      isPrivateName(node) {
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return super.isPrivateName(node);
          }
        }
        return node.type === "PrivateIdentifier";
      }
      getPrivateNameSV(node) {
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return super.getPrivateNameSV(node);
          }
        }
        return node.name;
      }
      parseLiteral(value, type) {
        const node = super.parseLiteral(value, type);
        node.raw = node.extra.raw;
        delete node.extra;
        return node;
      }
      parseFunctionBody(node, allowExpression, isMethod = false) {
        super.parseFunctionBody(node, allowExpression, isMethod);
        node.expression = node.body.type !== "BlockStatement";
      }
      parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope = false) {
        let funcNode = this.startNode();
        funcNode.kind = node.kind;
        funcNode = super.parseMethod(funcNode, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope);
        funcNode.type = "FunctionExpression";
        delete funcNode.kind;
        node.value = funcNode;
        const {
          typeParameters
        } = node;
        if (typeParameters) {
          delete node.typeParameters;
          funcNode.typeParameters = typeParameters;
          this.resetStartLocationFromNode(funcNode, typeParameters);
        }
        if (type === "ClassPrivateMethod") {
          node.computed = false;
        }
        return this.finishNode(node, "MethodDefinition");
      }
      nameIsConstructor(key2) {
        if (key2.type === "Literal") return key2.value === "constructor";
        return super.nameIsConstructor(key2);
      }
      parseClassProperty(...args) {
        const propertyNode = super.parseClassProperty(...args);
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return propertyNode;
          }
        }
        {
          propertyNode.type = "PropertyDefinition";
        }
        return propertyNode;
      }
      parseClassPrivateProperty(...args) {
        const propertyNode = super.parseClassPrivateProperty(...args);
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return propertyNode;
          }
        }
        {
          propertyNode.type = "PropertyDefinition";
        }
        propertyNode.computed = false;
        return propertyNode;
      }
      parseClassAccessorProperty(node) {
        const accessorPropertyNode = super.parseClassAccessorProperty(node);
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return accessorPropertyNode;
          }
        }
        accessorPropertyNode.type = "AccessorProperty";
        return accessorPropertyNode;
      }
      parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
        const node = super.parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor);
        if (node) {
          node.type = "Property";
          if (node.kind === "method") {
            node.kind = "init";
          }
          node.shorthand = false;
        }
        return node;
      }
      parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
        const node = super.parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors);
        if (node) {
          node.kind = "init";
          node.type = "Property";
        }
        return node;
      }
      isValidLVal(type, isUnparenthesizedInAssign, binding) {
        return type === "Property" ? "value" : super.isValidLVal(type, isUnparenthesizedInAssign, binding);
      }
      isAssignable(node, isBinding) {
        if (node != null && this.isObjectProperty(node)) {
          return this.isAssignable(node.value, isBinding);
        }
        return super.isAssignable(node, isBinding);
      }
      toAssignable(node, isLHS = false) {
        if (node != null && this.isObjectProperty(node)) {
          const {
            key: key2,
            value
          } = node;
          if (this.isPrivateName(key2)) {
            this.classScope.usePrivateName(this.getPrivateNameSV(key2), key2.loc.start);
          }
          this.toAssignable(value, isLHS);
        } else {
          super.toAssignable(node, isLHS);
        }
      }
      toAssignableObjectExpressionProp(prop, isLast, isLHS) {
        if (prop.type === "Property" && (prop.kind === "get" || prop.kind === "set")) {
          this.raise(Errors.PatternHasAccessor, prop.key);
        } else if (prop.type === "Property" && prop.method) {
          this.raise(Errors.PatternHasMethod, prop.key);
        } else {
          super.toAssignableObjectExpressionProp(prop, isLast, isLHS);
        }
      }
      finishCallExpression(unfinished, optional2) {
        const node = super.finishCallExpression(unfinished, optional2);
        if (node.callee.type === "Import") {
          var _ref, _ref2;
          node.type = "ImportExpression";
          node.source = node.arguments[0];
          node.options = (_ref = node.arguments[1]) != null ? _ref : null;
          node.attributes = (_ref2 = node.arguments[1]) != null ? _ref2 : null;
          delete node.arguments;
          delete node.callee;
        }
        return node;
      }
      toReferencedArguments(node) {
        if (node.type === "ImportExpression") {
          return;
        }
        super.toReferencedArguments(node);
      }
      parseExport(unfinished, decorators) {
        const exportStartLoc = this.state.lastTokStartLoc;
        const node = super.parseExport(unfinished, decorators);
        switch (node.type) {
          case "ExportAllDeclaration":
            node.exported = null;
            break;
          case "ExportNamedDeclaration":
            if (node.specifiers.length === 1 && node.specifiers[0].type === "ExportNamespaceSpecifier") {
              node.type = "ExportAllDeclaration";
              node.exported = node.specifiers[0].exported;
              delete node.specifiers;
            }
          case "ExportDefaultDeclaration":
            {
              var _declaration$decorato;
              const {
                declaration
              } = node;
              if ((declaration == null ? void 0 : declaration.type) === "ClassDeclaration" && ((_declaration$decorato = declaration.decorators) == null ? void 0 : _declaration$decorato.length) > 0 && declaration.start === node.start) {
                this.resetStartLocation(node, exportStartLoc);
              }
            }
            break;
        }
        return node;
      }
      parseSubscript(base, startLoc, noCalls, state) {
        const node = super.parseSubscript(base, startLoc, noCalls, state);
        if (state.optionalChainMember) {
          if (node.type === "OptionalMemberExpression" || node.type === "OptionalCallExpression") {
            node.type = node.type.substring(8);
          }
          if (state.stop) {
            const chain = this.startNodeAtNode(node);
            chain.expression = node;
            return this.finishNode(chain, "ChainExpression");
          }
        } else if (node.type === "MemberExpression" || node.type === "CallExpression") {
          node.optional = false;
        }
        return node;
      }
      isOptionalMemberExpression(node) {
        if (node.type === "ChainExpression") {
          return node.expression.type === "MemberExpression";
        }
        return super.isOptionalMemberExpression(node);
      }
      hasPropertyAsPrivateName(node) {
        if (node.type === "ChainExpression") {
          node = node.expression;
        }
        return super.hasPropertyAsPrivateName(node);
      }
      isObjectProperty(node) {
        return node.type === "Property" && node.kind === "init" && !node.method;
      }
      isObjectMethod(node) {
        return node.type === "Property" && (node.method || node.kind === "get" || node.kind === "set");
      }
      finishNodeAt(node, type, endLoc) {
        return toESTreeLocation(super.finishNodeAt(node, type, endLoc));
      }
      resetStartLocation(node, startLoc) {
        super.resetStartLocation(node, startLoc);
        toESTreeLocation(node);
      }
      resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
        super.resetEndLocation(node, endLoc);
        toESTreeLocation(node);
      }
    };
    var TokContext = class {
      constructor(token2, preserveSpace) {
        this.token = void 0;
        this.preserveSpace = void 0;
        this.token = token2;
        this.preserveSpace = !!preserveSpace;
      }
    };
    var types = {
      brace: new TokContext("{"),
      j_oTag: new TokContext("<tag"),
      j_cTag: new TokContext("</tag"),
      j_expr: new TokContext("<tag>...</tag>", true)
    };
    {
      types.template = new TokContext("`", true);
    }
    var beforeExpr = true;
    var startsExpr = true;
    var isLoop = true;
    var isAssign = true;
    var prefix = true;
    var postfix = true;
    var ExportedTokenType = class {
      constructor(label, conf = {}) {
        this.label = void 0;
        this.keyword = void 0;
        this.beforeExpr = void 0;
        this.startsExpr = void 0;
        this.rightAssociative = void 0;
        this.isLoop = void 0;
        this.isAssign = void 0;
        this.prefix = void 0;
        this.postfix = void 0;
        this.binop = void 0;
        this.label = label;
        this.keyword = conf.keyword;
        this.beforeExpr = !!conf.beforeExpr;
        this.startsExpr = !!conf.startsExpr;
        this.rightAssociative = !!conf.rightAssociative;
        this.isLoop = !!conf.isLoop;
        this.isAssign = !!conf.isAssign;
        this.prefix = !!conf.prefix;
        this.postfix = !!conf.postfix;
        this.binop = conf.binop != null ? conf.binop : null;
        {
          this.updateContext = null;
        }
      }
    };
    var keywords$1 = /* @__PURE__ */ new Map();
    function createKeyword(name, options = {}) {
      options.keyword = name;
      const token2 = createToken(name, options);
      keywords$1.set(name, token2);
      return token2;
    }
    function createBinop(name, binop) {
      return createToken(name, {
        beforeExpr,
        binop
      });
    }
    var tokenTypeCounter = -1;
    var tokenTypes = [];
    var tokenLabels = [];
    var tokenBinops = [];
    var tokenBeforeExprs = [];
    var tokenStartsExprs = [];
    var tokenPrefixes = [];
    function createToken(name, options = {}) {
      var _options$binop, _options$beforeExpr, _options$startsExpr, _options$prefix;
      ++tokenTypeCounter;
      tokenLabels.push(name);
      tokenBinops.push((_options$binop = options.binop) != null ? _options$binop : -1);
      tokenBeforeExprs.push((_options$beforeExpr = options.beforeExpr) != null ? _options$beforeExpr : false);
      tokenStartsExprs.push((_options$startsExpr = options.startsExpr) != null ? _options$startsExpr : false);
      tokenPrefixes.push((_options$prefix = options.prefix) != null ? _options$prefix : false);
      tokenTypes.push(new ExportedTokenType(name, options));
      return tokenTypeCounter;
    }
    function createKeywordLike(name, options = {}) {
      var _options$binop2, _options$beforeExpr2, _options$startsExpr2, _options$prefix2;
      ++tokenTypeCounter;
      keywords$1.set(name, tokenTypeCounter);
      tokenLabels.push(name);
      tokenBinops.push((_options$binop2 = options.binop) != null ? _options$binop2 : -1);
      tokenBeforeExprs.push((_options$beforeExpr2 = options.beforeExpr) != null ? _options$beforeExpr2 : false);
      tokenStartsExprs.push((_options$startsExpr2 = options.startsExpr) != null ? _options$startsExpr2 : false);
      tokenPrefixes.push((_options$prefix2 = options.prefix) != null ? _options$prefix2 : false);
      tokenTypes.push(new ExportedTokenType("name", options));
      return tokenTypeCounter;
    }
    var tt = {
      bracketL: createToken("[", {
        beforeExpr,
        startsExpr
      }),
      bracketHashL: createToken("#[", {
        beforeExpr,
        startsExpr
      }),
      bracketBarL: createToken("[|", {
        beforeExpr,
        startsExpr
      }),
      bracketR: createToken("]"),
      bracketBarR: createToken("|]"),
      braceL: createToken("{", {
        beforeExpr,
        startsExpr
      }),
      braceBarL: createToken("{|", {
        beforeExpr,
        startsExpr
      }),
      braceHashL: createToken("#{", {
        beforeExpr,
        startsExpr
      }),
      braceR: createToken("}"),
      braceBarR: createToken("|}"),
      parenL: createToken("(", {
        beforeExpr,
        startsExpr
      }),
      parenR: createToken(")"),
      comma: createToken(",", {
        beforeExpr
      }),
      semi: createToken(";", {
        beforeExpr
      }),
      colon: createToken(":", {
        beforeExpr
      }),
      doubleColon: createToken("::", {
        beforeExpr
      }),
      dot: createToken("."),
      question: createToken("?", {
        beforeExpr
      }),
      questionDot: createToken("?."),
      arrow: createToken("=>", {
        beforeExpr
      }),
      template: createToken("template"),
      ellipsis: createToken("...", {
        beforeExpr
      }),
      backQuote: createToken("`", {
        startsExpr
      }),
      dollarBraceL: createToken("${", {
        beforeExpr,
        startsExpr
      }),
      templateTail: createToken("...`", {
        startsExpr
      }),
      templateNonTail: createToken("...${", {
        beforeExpr,
        startsExpr
      }),
      at: createToken("@"),
      hash: createToken("#", {
        startsExpr
      }),
      interpreterDirective: createToken("#!..."),
      eq: createToken("=", {
        beforeExpr,
        isAssign
      }),
      assign: createToken("_=", {
        beforeExpr,
        isAssign
      }),
      slashAssign: createToken("_=", {
        beforeExpr,
        isAssign
      }),
      xorAssign: createToken("_=", {
        beforeExpr,
        isAssign
      }),
      moduloAssign: createToken("_=", {
        beforeExpr,
        isAssign
      }),
      incDec: createToken("++/--", {
        prefix,
        postfix,
        startsExpr
      }),
      bang: createToken("!", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      tilde: createToken("~", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      doubleCaret: createToken("^^", {
        startsExpr
      }),
      doubleAt: createToken("@@", {
        startsExpr
      }),
      pipeline: createBinop("|>", 0),
      nullishCoalescing: createBinop("??", 1),
      logicalOR: createBinop("||", 1),
      logicalAND: createBinop("&&", 2),
      bitwiseOR: createBinop("|", 3),
      bitwiseXOR: createBinop("^", 4),
      bitwiseAND: createBinop("&", 5),
      equality: createBinop("==/!=/===/!==", 6),
      lt: createBinop("</>/<=/>=", 7),
      gt: createBinop("</>/<=/>=", 7),
      relational: createBinop("</>/<=/>=", 7),
      bitShift: createBinop("<</>>/>>>", 8),
      bitShiftL: createBinop("<</>>/>>>", 8),
      bitShiftR: createBinop("<</>>/>>>", 8),
      plusMin: createToken("+/-", {
        beforeExpr,
        binop: 9,
        prefix,
        startsExpr
      }),
      modulo: createToken("%", {
        binop: 10,
        startsExpr
      }),
      star: createToken("*", {
        binop: 10
      }),
      slash: createBinop("/", 10),
      exponent: createToken("**", {
        beforeExpr,
        binop: 11,
        rightAssociative: true
      }),
      _in: createKeyword("in", {
        beforeExpr,
        binop: 7
      }),
      _instanceof: createKeyword("instanceof", {
        beforeExpr,
        binop: 7
      }),
      _break: createKeyword("break"),
      _case: createKeyword("case", {
        beforeExpr
      }),
      _catch: createKeyword("catch"),
      _continue: createKeyword("continue"),
      _debugger: createKeyword("debugger"),
      _default: createKeyword("default", {
        beforeExpr
      }),
      _else: createKeyword("else", {
        beforeExpr
      }),
      _finally: createKeyword("finally"),
      _function: createKeyword("function", {
        startsExpr
      }),
      _if: createKeyword("if"),
      _return: createKeyword("return", {
        beforeExpr
      }),
      _switch: createKeyword("switch"),
      _throw: createKeyword("throw", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      _try: createKeyword("try"),
      _var: createKeyword("var"),
      _const: createKeyword("const"),
      _with: createKeyword("with"),
      _new: createKeyword("new", {
        beforeExpr,
        startsExpr
      }),
      _this: createKeyword("this", {
        startsExpr
      }),
      _super: createKeyword("super", {
        startsExpr
      }),
      _class: createKeyword("class", {
        startsExpr
      }),
      _extends: createKeyword("extends", {
        beforeExpr
      }),
      _export: createKeyword("export"),
      _import: createKeyword("import", {
        startsExpr
      }),
      _null: createKeyword("null", {
        startsExpr
      }),
      _true: createKeyword("true", {
        startsExpr
      }),
      _false: createKeyword("false", {
        startsExpr
      }),
      _typeof: createKeyword("typeof", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      _void: createKeyword("void", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      _delete: createKeyword("delete", {
        beforeExpr,
        prefix,
        startsExpr
      }),
      _do: createKeyword("do", {
        isLoop,
        beforeExpr
      }),
      _for: createKeyword("for", {
        isLoop
      }),
      _while: createKeyword("while", {
        isLoop
      }),
      _as: createKeywordLike("as", {
        startsExpr
      }),
      _assert: createKeywordLike("assert", {
        startsExpr
      }),
      _async: createKeywordLike("async", {
        startsExpr
      }),
      _await: createKeywordLike("await", {
        startsExpr
      }),
      _defer: createKeywordLike("defer", {
        startsExpr
      }),
      _from: createKeywordLike("from", {
        startsExpr
      }),
      _get: createKeywordLike("get", {
        startsExpr
      }),
      _let: createKeywordLike("let", {
        startsExpr
      }),
      _meta: createKeywordLike("meta", {
        startsExpr
      }),
      _of: createKeywordLike("of", {
        startsExpr
      }),
      _sent: createKeywordLike("sent", {
        startsExpr
      }),
      _set: createKeywordLike("set", {
        startsExpr
      }),
      _source: createKeywordLike("source", {
        startsExpr
      }),
      _static: createKeywordLike("static", {
        startsExpr
      }),
      _using: createKeywordLike("using", {
        startsExpr
      }),
      _yield: createKeywordLike("yield", {
        startsExpr
      }),
      _asserts: createKeywordLike("asserts", {
        startsExpr
      }),
      _checks: createKeywordLike("checks", {
        startsExpr
      }),
      _exports: createKeywordLike("exports", {
        startsExpr
      }),
      _global: createKeywordLike("global", {
        startsExpr
      }),
      _implements: createKeywordLike("implements", {
        startsExpr
      }),
      _intrinsic: createKeywordLike("intrinsic", {
        startsExpr
      }),
      _infer: createKeywordLike("infer", {
        startsExpr
      }),
      _is: createKeywordLike("is", {
        startsExpr
      }),
      _mixins: createKeywordLike("mixins", {
        startsExpr
      }),
      _proto: createKeywordLike("proto", {
        startsExpr
      }),
      _require: createKeywordLike("require", {
        startsExpr
      }),
      _satisfies: createKeywordLike("satisfies", {
        startsExpr
      }),
      _keyof: createKeywordLike("keyof", {
        startsExpr
      }),
      _readonly: createKeywordLike("readonly", {
        startsExpr
      }),
      _unique: createKeywordLike("unique", {
        startsExpr
      }),
      _abstract: createKeywordLike("abstract", {
        startsExpr
      }),
      _declare: createKeywordLike("declare", {
        startsExpr
      }),
      _enum: createKeywordLike("enum", {
        startsExpr
      }),
      _module: createKeywordLike("module", {
        startsExpr
      }),
      _namespace: createKeywordLike("namespace", {
        startsExpr
      }),
      _interface: createKeywordLike("interface", {
        startsExpr
      }),
      _type: createKeywordLike("type", {
        startsExpr
      }),
      _opaque: createKeywordLike("opaque", {
        startsExpr
      }),
      name: createToken("name", {
        startsExpr
      }),
      placeholder: createToken("%%", {
        startsExpr: true
      }),
      string: createToken("string", {
        startsExpr
      }),
      num: createToken("num", {
        startsExpr
      }),
      bigint: createToken("bigint", {
        startsExpr
      }),
      decimal: createToken("decimal", {
        startsExpr
      }),
      regexp: createToken("regexp", {
        startsExpr
      }),
      privateName: createToken("#name", {
        startsExpr
      }),
      eof: createToken("eof"),
      jsxName: createToken("jsxName"),
      jsxText: createToken("jsxText", {
        beforeExpr: true
      }),
      jsxTagStart: createToken("jsxTagStart", {
        startsExpr: true
      }),
      jsxTagEnd: createToken("jsxTagEnd")
    };
    function tokenIsIdentifier(token2) {
      return token2 >= 93 && token2 <= 133;
    }
    function tokenKeywordOrIdentifierIsKeyword(token2) {
      return token2 <= 92;
    }
    function tokenIsKeywordOrIdentifier(token2) {
      return token2 >= 58 && token2 <= 133;
    }
    function tokenIsLiteralPropertyName(token2) {
      return token2 >= 58 && token2 <= 137;
    }
    function tokenComesBeforeExpression(token2) {
      return tokenBeforeExprs[token2];
    }
    function tokenCanStartExpression(token2) {
      return tokenStartsExprs[token2];
    }
    function tokenIsAssignment(token2) {
      return token2 >= 29 && token2 <= 33;
    }
    function tokenIsFlowInterfaceOrTypeOrOpaque(token2) {
      return token2 >= 129 && token2 <= 131;
    }
    function tokenIsLoop(token2) {
      return token2 >= 90 && token2 <= 92;
    }
    function tokenIsKeyword(token2) {
      return token2 >= 58 && token2 <= 92;
    }
    function tokenIsOperator(token2) {
      return token2 >= 39 && token2 <= 59;
    }
    function tokenIsPostfix(token2) {
      return token2 === 34;
    }
    function tokenIsPrefix(token2) {
      return tokenPrefixes[token2];
    }
    function tokenIsTSTypeOperator(token2) {
      return token2 >= 121 && token2 <= 123;
    }
    function tokenIsTSDeclarationStart(token2) {
      return token2 >= 124 && token2 <= 130;
    }
    function tokenLabelName(token2) {
      return tokenLabels[token2];
    }
    function tokenOperatorPrecedence(token2) {
      return tokenBinops[token2];
    }
    function tokenIsRightAssociative(token2) {
      return token2 === 57;
    }
    function tokenIsTemplate(token2) {
      return token2 >= 24 && token2 <= 25;
    }
    function getExportedToken(token2) {
      return tokenTypes[token2];
    }
    {
      tokenTypes[8].updateContext = (context) => {
        context.pop();
      };
      tokenTypes[5].updateContext = tokenTypes[7].updateContext = tokenTypes[23].updateContext = (context) => {
        context.push(types.brace);
      };
      tokenTypes[22].updateContext = (context) => {
        if (context[context.length - 1] === types.template) {
          context.pop();
        } else {
          context.push(types.template);
        }
      };
      tokenTypes[143].updateContext = (context) => {
        context.push(types.j_expr, types.j_oTag);
      };
    }
    var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C8A\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CD\uA7D0\uA7D1\uA7D3\uA7D5-\uA7DC\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    var nonASCIIidentifierChars = "\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0897-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u200C\u200D\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\u30FB\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F\uFF65";
    var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];
    var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    function isInAstralSet(code2, set2) {
      let pos2 = 65536;
      for (let i = 0, length = set2.length; i < length; i += 2) {
        pos2 += set2[i];
        if (pos2 > code2) return false;
        pos2 += set2[i + 1];
        if (pos2 >= code2) return true;
      }
      return false;
    }
    function isIdentifierStart(code2) {
      if (code2 < 65) return code2 === 36;
      if (code2 <= 90) return true;
      if (code2 < 97) return code2 === 95;
      if (code2 <= 122) return true;
      if (code2 <= 65535) {
        return code2 >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code2));
      }
      return isInAstralSet(code2, astralIdentifierStartCodes);
    }
    function isIdentifierChar(code2) {
      if (code2 < 48) return code2 === 36;
      if (code2 < 58) return true;
      if (code2 < 65) return false;
      if (code2 <= 90) return true;
      if (code2 < 97) return code2 === 95;
      if (code2 <= 122) return true;
      if (code2 <= 65535) {
        return code2 >= 170 && nonASCIIidentifier.test(String.fromCharCode(code2));
      }
      return isInAstralSet(code2, astralIdentifierStartCodes) || isInAstralSet(code2, astralIdentifierCodes);
    }
    var reservedWords = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    var keywords = new Set(reservedWords.keyword);
    var reservedWordsStrictSet = new Set(reservedWords.strict);
    var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
    function isReservedWord2(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }
    function isStrictReservedWord(word, inModule) {
      return isReservedWord2(word, inModule) || reservedWordsStrictSet.has(word);
    }
    function isStrictBindOnlyReservedWord(word) {
      return reservedWordsStrictBindSet.has(word);
    }
    function isStrictBindReservedWord(word, inModule) {
      return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
    }
    function isKeyword(word) {
      return keywords.has(word);
    }
    function isIteratorStart(current, next, next2) {
      return current === 64 && next === 64 && isIdentifierStart(next2);
    }
    var reservedWordLikeSet = /* @__PURE__ */ new Set(["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "eval", "arguments", "enum", "await"]);
    function canBeReservedWord(word) {
      return reservedWordLikeSet.has(word);
    }
    var Scope = class {
      constructor(flags) {
        this.flags = 0;
        this.names = /* @__PURE__ */ new Map();
        this.firstLexicalName = "";
        this.flags = flags;
      }
    };
    var ScopeHandler = class {
      constructor(parser, inModule) {
        this.parser = void 0;
        this.scopeStack = [];
        this.inModule = void 0;
        this.undefinedExports = /* @__PURE__ */ new Map();
        this.parser = parser;
        this.inModule = inModule;
      }
      get inTopLevel() {
        return (this.currentScope().flags & 1) > 0;
      }
      get inFunction() {
        return (this.currentVarScopeFlags() & 2) > 0;
      }
      get allowSuper() {
        return (this.currentThisScopeFlags() & 16) > 0;
      }
      get allowDirectSuper() {
        return (this.currentThisScopeFlags() & 32) > 0;
      }
      get inClass() {
        return (this.currentThisScopeFlags() & 64) > 0;
      }
      get inClassAndNotInNonArrowFunction() {
        const flags = this.currentThisScopeFlags();
        return (flags & 64) > 0 && (flags & 2) === 0;
      }
      get inStaticBlock() {
        for (let i = this.scopeStack.length - 1; ; i--) {
          const {
            flags
          } = this.scopeStack[i];
          if (flags & 128) {
            return true;
          }
          if (flags & (387 | 64)) {
            return false;
          }
        }
      }
      get inNonArrowFunction() {
        return (this.currentThisScopeFlags() & 2) > 0;
      }
      get treatFunctionsAsVar() {
        return this.treatFunctionsAsVarInScope(this.currentScope());
      }
      createScope(flags) {
        return new Scope(flags);
      }
      enter(flags) {
        this.scopeStack.push(this.createScope(flags));
      }
      exit() {
        const scope = this.scopeStack.pop();
        return scope.flags;
      }
      treatFunctionsAsVarInScope(scope) {
        return !!(scope.flags & (2 | 128) || !this.parser.inModule && scope.flags & 1);
      }
      declareName(name, bindingType, loc) {
        let scope = this.currentScope();
        if (bindingType & 8 || bindingType & 16) {
          this.checkRedeclarationInScope(scope, name, bindingType, loc);
          let type = scope.names.get(name) || 0;
          if (bindingType & 16) {
            type = type | 4;
          } else {
            if (!scope.firstLexicalName) {
              scope.firstLexicalName = name;
            }
            type = type | 2;
          }
          scope.names.set(name, type);
          if (bindingType & 8) {
            this.maybeExportDefined(scope, name);
          }
        } else if (bindingType & 4) {
          for (let i = this.scopeStack.length - 1; i >= 0; --i) {
            scope = this.scopeStack[i];
            this.checkRedeclarationInScope(scope, name, bindingType, loc);
            scope.names.set(name, (scope.names.get(name) || 0) | 1);
            this.maybeExportDefined(scope, name);
            if (scope.flags & 387) break;
          }
        }
        if (this.parser.inModule && scope.flags & 1) {
          this.undefinedExports.delete(name);
        }
      }
      maybeExportDefined(scope, name) {
        if (this.parser.inModule && scope.flags & 1) {
          this.undefinedExports.delete(name);
        }
      }
      checkRedeclarationInScope(scope, name, bindingType, loc) {
        if (this.isRedeclaredInScope(scope, name, bindingType)) {
          this.parser.raise(Errors.VarRedeclaration, loc, {
            identifierName: name
          });
        }
      }
      isRedeclaredInScope(scope, name, bindingType) {
        if (!(bindingType & 1)) return false;
        if (bindingType & 8) {
          return scope.names.has(name);
        }
        const type = scope.names.get(name);
        if (bindingType & 16) {
          return (type & 2) > 0 || !this.treatFunctionsAsVarInScope(scope) && (type & 1) > 0;
        }
        return (type & 2) > 0 && !(scope.flags & 8 && scope.firstLexicalName === name) || !this.treatFunctionsAsVarInScope(scope) && (type & 4) > 0;
      }
      checkLocalExport(id) {
        const {
          name
        } = id;
        const topLevelScope = this.scopeStack[0];
        if (!topLevelScope.names.has(name)) {
          this.undefinedExports.set(name, id.loc.start);
        }
      }
      currentScope() {
        return this.scopeStack[this.scopeStack.length - 1];
      }
      currentVarScopeFlags() {
        for (let i = this.scopeStack.length - 1; ; i--) {
          const {
            flags
          } = this.scopeStack[i];
          if (flags & 387) {
            return flags;
          }
        }
      }
      currentThisScopeFlags() {
        for (let i = this.scopeStack.length - 1; ; i--) {
          const {
            flags
          } = this.scopeStack[i];
          if (flags & (387 | 64) && !(flags & 4)) {
            return flags;
          }
        }
      }
    };
    var FlowScope = class extends Scope {
      constructor(...args) {
        super(...args);
        this.declareFunctions = /* @__PURE__ */ new Set();
      }
    };
    var FlowScopeHandler = class extends ScopeHandler {
      createScope(flags) {
        return new FlowScope(flags);
      }
      declareName(name, bindingType, loc) {
        const scope = this.currentScope();
        if (bindingType & 2048) {
          this.checkRedeclarationInScope(scope, name, bindingType, loc);
          this.maybeExportDefined(scope, name);
          scope.declareFunctions.add(name);
          return;
        }
        super.declareName(name, bindingType, loc);
      }
      isRedeclaredInScope(scope, name, bindingType) {
        if (super.isRedeclaredInScope(scope, name, bindingType)) return true;
        if (bindingType & 2048 && !scope.declareFunctions.has(name)) {
          const type = scope.names.get(name);
          return (type & 4) > 0 || (type & 2) > 0;
        }
        return false;
      }
      checkLocalExport(id) {
        if (!this.scopeStack[0].declareFunctions.has(id.name)) {
          super.checkLocalExport(id);
        }
      }
    };
    var BaseParser = class {
      constructor() {
        this.sawUnambiguousESM = false;
        this.ambiguousScriptDifferentAst = false;
      }
      sourceToOffsetPos(sourcePos) {
        return sourcePos + this.startIndex;
      }
      offsetToSourcePos(offsetPos) {
        return offsetPos - this.startIndex;
      }
      hasPlugin(pluginConfig) {
        if (typeof pluginConfig === "string") {
          return this.plugins.has(pluginConfig);
        } else {
          const [pluginName, pluginOptions] = pluginConfig;
          if (!this.hasPlugin(pluginName)) {
            return false;
          }
          const actualOptions = this.plugins.get(pluginName);
          for (const key2 of Object.keys(pluginOptions)) {
            if ((actualOptions == null ? void 0 : actualOptions[key2]) !== pluginOptions[key2]) {
              return false;
            }
          }
          return true;
        }
      }
      getPluginOption(plugin, name) {
        var _this$plugins$get;
        return (_this$plugins$get = this.plugins.get(plugin)) == null ? void 0 : _this$plugins$get[name];
      }
    };
    function setTrailingComments(node, comments) {
      if (node.trailingComments === void 0) {
        node.trailingComments = comments;
      } else {
        node.trailingComments.unshift(...comments);
      }
    }
    function setLeadingComments(node, comments) {
      if (node.leadingComments === void 0) {
        node.leadingComments = comments;
      } else {
        node.leadingComments.unshift(...comments);
      }
    }
    function setInnerComments(node, comments) {
      if (node.innerComments === void 0) {
        node.innerComments = comments;
      } else {
        node.innerComments.unshift(...comments);
      }
    }
    function adjustInnerComments(node, elements, commentWS) {
      let lastElement = null;
      let i = elements.length;
      while (lastElement === null && i > 0) {
        lastElement = elements[--i];
      }
      if (lastElement === null || lastElement.start > commentWS.start) {
        setInnerComments(node, commentWS.comments);
      } else {
        setTrailingComments(lastElement, commentWS.comments);
      }
    }
    var CommentsParser = class extends BaseParser {
      addComment(comment) {
        if (this.filename) comment.loc.filename = this.filename;
        const {
          commentsLen
        } = this.state;
        if (this.comments.length !== commentsLen) {
          this.comments.length = commentsLen;
        }
        this.comments.push(comment);
        this.state.commentsLen++;
      }
      processComment(node) {
        const {
          commentStack
        } = this.state;
        const commentStackLength = commentStack.length;
        if (commentStackLength === 0) return;
        let i = commentStackLength - 1;
        const lastCommentWS = commentStack[i];
        if (lastCommentWS.start === node.end) {
          lastCommentWS.leadingNode = node;
          i--;
        }
        const {
          start: nodeStart
        } = node;
        for (; i >= 0; i--) {
          const commentWS = commentStack[i];
          const commentEnd = commentWS.end;
          if (commentEnd > nodeStart) {
            commentWS.containingNode = node;
            this.finalizeComment(commentWS);
            commentStack.splice(i, 1);
          } else {
            if (commentEnd === nodeStart) {
              commentWS.trailingNode = node;
            }
            break;
          }
        }
      }
      finalizeComment(commentWS) {
        const {
          comments
        } = commentWS;
        if (commentWS.leadingNode !== null || commentWS.trailingNode !== null) {
          if (commentWS.leadingNode !== null) {
            setTrailingComments(commentWS.leadingNode, comments);
          }
          if (commentWS.trailingNode !== null) {
            setLeadingComments(commentWS.trailingNode, comments);
          }
        } else {
          const {
            containingNode: node,
            start: commentStart
          } = commentWS;
          if (this.input.charCodeAt(this.offsetToSourcePos(commentStart) - 1) === 44) {
            switch (node.type) {
              case "ObjectExpression":
              case "ObjectPattern":
              case "RecordExpression":
                adjustInnerComments(node, node.properties, commentWS);
                break;
              case "CallExpression":
              case "OptionalCallExpression":
                adjustInnerComments(node, node.arguments, commentWS);
                break;
              case "FunctionDeclaration":
              case "FunctionExpression":
              case "ArrowFunctionExpression":
              case "ObjectMethod":
              case "ClassMethod":
              case "ClassPrivateMethod":
                adjustInnerComments(node, node.params, commentWS);
                break;
              case "ArrayExpression":
              case "ArrayPattern":
              case "TupleExpression":
                adjustInnerComments(node, node.elements, commentWS);
                break;
              case "ExportNamedDeclaration":
              case "ImportDeclaration":
                adjustInnerComments(node, node.specifiers, commentWS);
                break;
              case "TSEnumDeclaration":
                {
                  adjustInnerComments(node, node.members, commentWS);
                }
                break;
              case "TSEnumBody":
                adjustInnerComments(node, node.members, commentWS);
                break;
              default: {
                setInnerComments(node, comments);
              }
            }
          } else {
            setInnerComments(node, comments);
          }
        }
      }
      finalizeRemainingComments() {
        const {
          commentStack
        } = this.state;
        for (let i = commentStack.length - 1; i >= 0; i--) {
          this.finalizeComment(commentStack[i]);
        }
        this.state.commentStack = [];
      }
      resetPreviousNodeTrailingComments(node) {
        const {
          commentStack
        } = this.state;
        const {
          length
        } = commentStack;
        if (length === 0) return;
        const commentWS = commentStack[length - 1];
        if (commentWS.leadingNode === node) {
          commentWS.leadingNode = null;
        }
      }
      resetPreviousIdentifierLeadingComments(node) {
        const {
          commentStack
        } = this.state;
        const {
          length
        } = commentStack;
        if (length === 0) return;
        if (commentStack[length - 1].trailingNode === node) {
          commentStack[length - 1].trailingNode = null;
        } else if (length >= 2 && commentStack[length - 2].trailingNode === node) {
          commentStack[length - 2].trailingNode = null;
        }
      }
      takeSurroundingComments(node, start, end) {
        const {
          commentStack
        } = this.state;
        const commentStackLength = commentStack.length;
        if (commentStackLength === 0) return;
        let i = commentStackLength - 1;
        for (; i >= 0; i--) {
          const commentWS = commentStack[i];
          const commentEnd = commentWS.end;
          const commentStart = commentWS.start;
          if (commentStart === end) {
            commentWS.leadingNode = node;
          } else if (commentEnd === start) {
            commentWS.trailingNode = node;
          } else if (commentEnd < start) {
            break;
          }
        }
      }
    };
    var lineBreak = /\r\n|[\r\n\u2028\u2029]/;
    var lineBreakG = new RegExp(lineBreak.source, "g");
    function isNewLine(code2) {
      switch (code2) {
        case 10:
        case 13:
        case 8232:
        case 8233:
          return true;
        default:
          return false;
      }
    }
    function hasNewLine(input, start, end) {
      for (let i = start; i < end; i++) {
        if (isNewLine(input.charCodeAt(i))) {
          return true;
        }
      }
      return false;
    }
    var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
    var skipWhiteSpaceInLine = /(?:[^\S\n\r\u2028\u2029]|\/\/.*|\/\*.*?\*\/)*/g;
    function isWhitespace(code2) {
      switch (code2) {
        case 9:
        case 11:
        case 12:
        case 32:
        case 160:
        case 5760:
        case 8192:
        case 8193:
        case 8194:
        case 8195:
        case 8196:
        case 8197:
        case 8198:
        case 8199:
        case 8200:
        case 8201:
        case 8202:
        case 8239:
        case 8287:
        case 12288:
        case 65279:
          return true;
        default:
          return false;
      }
    }
    var State4 = class _State {
      constructor() {
        this.flags = 1024;
        this.startIndex = void 0;
        this.curLine = void 0;
        this.lineStart = void 0;
        this.startLoc = void 0;
        this.endLoc = void 0;
        this.errors = [];
        this.potentialArrowAt = -1;
        this.noArrowAt = [];
        this.noArrowParamsConversionAt = [];
        this.topicContext = {
          maxNumOfResolvableTopics: 0,
          maxTopicIndex: null
        };
        this.labels = [];
        this.commentsLen = 0;
        this.commentStack = [];
        this.pos = 0;
        this.type = 140;
        this.value = null;
        this.start = 0;
        this.end = 0;
        this.lastTokEndLoc = null;
        this.lastTokStartLoc = null;
        this.context = [types.brace];
        this.firstInvalidTemplateEscapePos = null;
        this.strictErrors = /* @__PURE__ */ new Map();
        this.tokensLength = 0;
      }
      get strict() {
        return (this.flags & 1) > 0;
      }
      set strict(v) {
        if (v) this.flags |= 1;
        else this.flags &= -2;
      }
      init({
        strictMode,
        sourceType,
        startIndex,
        startLine,
        startColumn
      }) {
        this.strict = strictMode === false ? false : strictMode === true ? true : sourceType === "module";
        this.startIndex = startIndex;
        this.curLine = startLine;
        this.lineStart = -startColumn;
        this.startLoc = this.endLoc = new Position(startLine, startColumn, startIndex);
      }
      get maybeInArrowParameters() {
        return (this.flags & 2) > 0;
      }
      set maybeInArrowParameters(v) {
        if (v) this.flags |= 2;
        else this.flags &= -3;
      }
      get inType() {
        return (this.flags & 4) > 0;
      }
      set inType(v) {
        if (v) this.flags |= 4;
        else this.flags &= -5;
      }
      get noAnonFunctionType() {
        return (this.flags & 8) > 0;
      }
      set noAnonFunctionType(v) {
        if (v) this.flags |= 8;
        else this.flags &= -9;
      }
      get hasFlowComment() {
        return (this.flags & 16) > 0;
      }
      set hasFlowComment(v) {
        if (v) this.flags |= 16;
        else this.flags &= -17;
      }
      get isAmbientContext() {
        return (this.flags & 32) > 0;
      }
      set isAmbientContext(v) {
        if (v) this.flags |= 32;
        else this.flags &= -33;
      }
      get inAbstractClass() {
        return (this.flags & 64) > 0;
      }
      set inAbstractClass(v) {
        if (v) this.flags |= 64;
        else this.flags &= -65;
      }
      get inDisallowConditionalTypesContext() {
        return (this.flags & 128) > 0;
      }
      set inDisallowConditionalTypesContext(v) {
        if (v) this.flags |= 128;
        else this.flags &= -129;
      }
      get soloAwait() {
        return (this.flags & 256) > 0;
      }
      set soloAwait(v) {
        if (v) this.flags |= 256;
        else this.flags &= -257;
      }
      get inFSharpPipelineDirectBody() {
        return (this.flags & 512) > 0;
      }
      set inFSharpPipelineDirectBody(v) {
        if (v) this.flags |= 512;
        else this.flags &= -513;
      }
      get canStartJSXElement() {
        return (this.flags & 1024) > 0;
      }
      set canStartJSXElement(v) {
        if (v) this.flags |= 1024;
        else this.flags &= -1025;
      }
      get containsEsc() {
        return (this.flags & 2048) > 0;
      }
      set containsEsc(v) {
        if (v) this.flags |= 2048;
        else this.flags &= -2049;
      }
      get hasTopLevelAwait() {
        return (this.flags & 4096) > 0;
      }
      set hasTopLevelAwait(v) {
        if (v) this.flags |= 4096;
        else this.flags &= -4097;
      }
      curPosition() {
        return new Position(this.curLine, this.pos - this.lineStart, this.pos + this.startIndex);
      }
      clone() {
        const state = new _State();
        state.flags = this.flags;
        state.startIndex = this.startIndex;
        state.curLine = this.curLine;
        state.lineStart = this.lineStart;
        state.startLoc = this.startLoc;
        state.endLoc = this.endLoc;
        state.errors = this.errors.slice();
        state.potentialArrowAt = this.potentialArrowAt;
        state.noArrowAt = this.noArrowAt.slice();
        state.noArrowParamsConversionAt = this.noArrowParamsConversionAt.slice();
        state.topicContext = this.topicContext;
        state.labels = this.labels.slice();
        state.commentsLen = this.commentsLen;
        state.commentStack = this.commentStack.slice();
        state.pos = this.pos;
        state.type = this.type;
        state.value = this.value;
        state.start = this.start;
        state.end = this.end;
        state.lastTokEndLoc = this.lastTokEndLoc;
        state.lastTokStartLoc = this.lastTokStartLoc;
        state.context = this.context.slice();
        state.firstInvalidTemplateEscapePos = this.firstInvalidTemplateEscapePos;
        state.strictErrors = this.strictErrors;
        state.tokensLength = this.tokensLength;
        return state;
      }
    };
    var _isDigit = function isDigit(code2) {
      return code2 >= 48 && code2 <= 57;
    };
    var forbiddenNumericSeparatorSiblings = {
      decBinOct: /* @__PURE__ */ new Set([46, 66, 69, 79, 95, 98, 101, 111]),
      hex: /* @__PURE__ */ new Set([46, 88, 95, 120])
    };
    var isAllowedNumericSeparatorSibling = {
      bin: (ch) => ch === 48 || ch === 49,
      oct: (ch) => ch >= 48 && ch <= 55,
      dec: (ch) => ch >= 48 && ch <= 57,
      hex: (ch) => ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102
    };
    function readStringContents(type, input, pos2, lineStart, curLine, errors) {
      const initialPos = pos2;
      const initialLineStart = lineStart;
      const initialCurLine = curLine;
      let out = "";
      let firstInvalidLoc = null;
      let chunkStart = pos2;
      const {
        length
      } = input;
      for (; ; ) {
        if (pos2 >= length) {
          errors.unterminated(initialPos, initialLineStart, initialCurLine);
          out += input.slice(chunkStart, pos2);
          break;
        }
        const ch = input.charCodeAt(pos2);
        if (isStringEnd(type, ch, input, pos2)) {
          out += input.slice(chunkStart, pos2);
          break;
        }
        if (ch === 92) {
          out += input.slice(chunkStart, pos2);
          const res = readEscapedChar(input, pos2, lineStart, curLine, type === "template", errors);
          if (res.ch === null && !firstInvalidLoc) {
            firstInvalidLoc = {
              pos: pos2,
              lineStart,
              curLine
            };
          } else {
            out += res.ch;
          }
          ({
            pos: pos2,
            lineStart,
            curLine
          } = res);
          chunkStart = pos2;
        } else if (ch === 8232 || ch === 8233) {
          ++pos2;
          ++curLine;
          lineStart = pos2;
        } else if (ch === 10 || ch === 13) {
          if (type === "template") {
            out += input.slice(chunkStart, pos2) + "\n";
            ++pos2;
            if (ch === 13 && input.charCodeAt(pos2) === 10) {
              ++pos2;
            }
            ++curLine;
            chunkStart = lineStart = pos2;
          } else {
            errors.unterminated(initialPos, initialLineStart, initialCurLine);
          }
        } else {
          ++pos2;
        }
      }
      return {
        pos: pos2,
        str: out,
        firstInvalidLoc,
        lineStart,
        curLine,
        containsInvalid: !!firstInvalidLoc
      };
    }
    function isStringEnd(type, ch, input, pos2) {
      if (type === "template") {
        return ch === 96 || ch === 36 && input.charCodeAt(pos2 + 1) === 123;
      }
      return ch === (type === "double" ? 34 : 39);
    }
    function readEscapedChar(input, pos2, lineStart, curLine, inTemplate, errors) {
      const throwOnInvalid = !inTemplate;
      pos2++;
      const res = (ch2) => ({
        pos: pos2,
        ch: ch2,
        lineStart,
        curLine
      });
      const ch = input.charCodeAt(pos2++);
      switch (ch) {
        case 110:
          return res("\n");
        case 114:
          return res("\r");
        case 120: {
          let code2;
          ({
            code: code2,
            pos: pos2
          } = readHexChar(input, pos2, lineStart, curLine, 2, false, throwOnInvalid, errors));
          return res(code2 === null ? null : String.fromCharCode(code2));
        }
        case 117: {
          let code2;
          ({
            code: code2,
            pos: pos2
          } = readCodePoint(input, pos2, lineStart, curLine, throwOnInvalid, errors));
          return res(code2 === null ? null : String.fromCodePoint(code2));
        }
        case 116:
          return res("	");
        case 98:
          return res("\b");
        case 118:
          return res("\v");
        case 102:
          return res("\f");
        case 13:
          if (input.charCodeAt(pos2) === 10) {
            ++pos2;
          }
        case 10:
          lineStart = pos2;
          ++curLine;
        case 8232:
        case 8233:
          return res("");
        case 56:
        case 57:
          if (inTemplate) {
            return res(null);
          } else {
            errors.strictNumericEscape(pos2 - 1, lineStart, curLine);
          }
        default:
          if (ch >= 48 && ch <= 55) {
            const startPos = pos2 - 1;
            const match = /^[0-7]+/.exec(input.slice(startPos, pos2 + 2));
            let octalStr = match[0];
            let octal = parseInt(octalStr, 8);
            if (octal > 255) {
              octalStr = octalStr.slice(0, -1);
              octal = parseInt(octalStr, 8);
            }
            pos2 += octalStr.length - 1;
            const next = input.charCodeAt(pos2);
            if (octalStr !== "0" || next === 56 || next === 57) {
              if (inTemplate) {
                return res(null);
              } else {
                errors.strictNumericEscape(startPos, lineStart, curLine);
              }
            }
            return res(String.fromCharCode(octal));
          }
          return res(String.fromCharCode(ch));
      }
    }
    function readHexChar(input, pos2, lineStart, curLine, len, forceLen, throwOnInvalid, errors) {
      const initialPos = pos2;
      let n;
      ({
        n,
        pos: pos2
      } = readInt(input, pos2, lineStart, curLine, 16, len, forceLen, false, errors, !throwOnInvalid));
      if (n === null) {
        if (throwOnInvalid) {
          errors.invalidEscapeSequence(initialPos, lineStart, curLine);
        } else {
          pos2 = initialPos - 1;
        }
      }
      return {
        code: n,
        pos: pos2
      };
    }
    function readInt(input, pos2, lineStart, curLine, radix, len, forceLen, allowNumSeparator, errors, bailOnError) {
      const start = pos2;
      const forbiddenSiblings = radix === 16 ? forbiddenNumericSeparatorSiblings.hex : forbiddenNumericSeparatorSiblings.decBinOct;
      const isAllowedSibling = radix === 16 ? isAllowedNumericSeparatorSibling.hex : radix === 10 ? isAllowedNumericSeparatorSibling.dec : radix === 8 ? isAllowedNumericSeparatorSibling.oct : isAllowedNumericSeparatorSibling.bin;
      let invalid = false;
      let total = 0;
      for (let i = 0, e = len == null ? Infinity : len; i < e; ++i) {
        const code2 = input.charCodeAt(pos2);
        let val;
        if (code2 === 95 && allowNumSeparator !== "bail") {
          const prev = input.charCodeAt(pos2 - 1);
          const next = input.charCodeAt(pos2 + 1);
          if (!allowNumSeparator) {
            if (bailOnError) return {
              n: null,
              pos: pos2
            };
            errors.numericSeparatorInEscapeSequence(pos2, lineStart, curLine);
          } else if (Number.isNaN(next) || !isAllowedSibling(next) || forbiddenSiblings.has(prev) || forbiddenSiblings.has(next)) {
            if (bailOnError) return {
              n: null,
              pos: pos2
            };
            errors.unexpectedNumericSeparator(pos2, lineStart, curLine);
          }
          ++pos2;
          continue;
        }
        if (code2 >= 97) {
          val = code2 - 97 + 10;
        } else if (code2 >= 65) {
          val = code2 - 65 + 10;
        } else if (_isDigit(code2)) {
          val = code2 - 48;
        } else {
          val = Infinity;
        }
        if (val >= radix) {
          if (val <= 9 && bailOnError) {
            return {
              n: null,
              pos: pos2
            };
          } else if (val <= 9 && errors.invalidDigit(pos2, lineStart, curLine, radix)) {
            val = 0;
          } else if (forceLen) {
            val = 0;
            invalid = true;
          } else {
            break;
          }
        }
        ++pos2;
        total = total * radix + val;
      }
      if (pos2 === start || len != null && pos2 - start !== len || invalid) {
        return {
          n: null,
          pos: pos2
        };
      }
      return {
        n: total,
        pos: pos2
      };
    }
    function readCodePoint(input, pos2, lineStart, curLine, throwOnInvalid, errors) {
      const ch = input.charCodeAt(pos2);
      let code2;
      if (ch === 123) {
        ++pos2;
        ({
          code: code2,
          pos: pos2
        } = readHexChar(input, pos2, lineStart, curLine, input.indexOf("}", pos2) - pos2, true, throwOnInvalid, errors));
        ++pos2;
        if (code2 !== null && code2 > 1114111) {
          if (throwOnInvalid) {
            errors.invalidCodePoint(pos2, lineStart, curLine);
          } else {
            return {
              code: null,
              pos: pos2
            };
          }
        }
      } else {
        ({
          code: code2,
          pos: pos2
        } = readHexChar(input, pos2, lineStart, curLine, 4, false, throwOnInvalid, errors));
      }
      return {
        code: code2,
        pos: pos2
      };
    }
    function buildPosition(pos2, lineStart, curLine) {
      return new Position(curLine, pos2 - lineStart, pos2);
    }
    var VALID_REGEX_FLAGS = /* @__PURE__ */ new Set([103, 109, 115, 105, 121, 117, 100, 118]);
    var Token = class {
      constructor(state) {
        const startIndex = state.startIndex || 0;
        this.type = state.type;
        this.value = state.value;
        this.start = startIndex + state.start;
        this.end = startIndex + state.end;
        this.loc = new SourceLocation22(state.startLoc, state.endLoc);
      }
    };
    var Tokenizer = class extends CommentsParser {
      constructor(options, input) {
        super();
        this.isLookahead = void 0;
        this.tokens = [];
        this.errorHandlers_readInt = {
          invalidDigit: (pos2, lineStart, curLine, radix) => {
            if (!(this.optionFlags & 2048)) return false;
            this.raise(Errors.InvalidDigit, buildPosition(pos2, lineStart, curLine), {
              radix
            });
            return true;
          },
          numericSeparatorInEscapeSequence: this.errorBuilder(Errors.NumericSeparatorInEscapeSequence),
          unexpectedNumericSeparator: this.errorBuilder(Errors.UnexpectedNumericSeparator)
        };
        this.errorHandlers_readCodePoint = Object.assign({}, this.errorHandlers_readInt, {
          invalidEscapeSequence: this.errorBuilder(Errors.InvalidEscapeSequence),
          invalidCodePoint: this.errorBuilder(Errors.InvalidCodePoint)
        });
        this.errorHandlers_readStringContents_string = Object.assign({}, this.errorHandlers_readCodePoint, {
          strictNumericEscape: (pos2, lineStart, curLine) => {
            this.recordStrictModeErrors(Errors.StrictNumericEscape, buildPosition(pos2, lineStart, curLine));
          },
          unterminated: (pos2, lineStart, curLine) => {
            throw this.raise(Errors.UnterminatedString, buildPosition(pos2 - 1, lineStart, curLine));
          }
        });
        this.errorHandlers_readStringContents_template = Object.assign({}, this.errorHandlers_readCodePoint, {
          strictNumericEscape: this.errorBuilder(Errors.StrictNumericEscape),
          unterminated: (pos2, lineStart, curLine) => {
            throw this.raise(Errors.UnterminatedTemplate, buildPosition(pos2, lineStart, curLine));
          }
        });
        this.state = new State4();
        this.state.init(options);
        this.input = input;
        this.length = input.length;
        this.comments = [];
        this.isLookahead = false;
      }
      pushToken(token2) {
        this.tokens.length = this.state.tokensLength;
        this.tokens.push(token2);
        ++this.state.tokensLength;
      }
      next() {
        this.checkKeywordEscapes();
        if (this.optionFlags & 256) {
          this.pushToken(new Token(this.state));
        }
        this.state.lastTokEndLoc = this.state.endLoc;
        this.state.lastTokStartLoc = this.state.startLoc;
        this.nextToken();
      }
      eat(type) {
        if (this.match(type)) {
          this.next();
          return true;
        } else {
          return false;
        }
      }
      match(type) {
        return this.state.type === type;
      }
      createLookaheadState(state) {
        return {
          pos: state.pos,
          value: null,
          type: state.type,
          start: state.start,
          end: state.end,
          context: [this.curContext()],
          inType: state.inType,
          startLoc: state.startLoc,
          lastTokEndLoc: state.lastTokEndLoc,
          curLine: state.curLine,
          lineStart: state.lineStart,
          curPosition: state.curPosition
        };
      }
      lookahead() {
        const old = this.state;
        this.state = this.createLookaheadState(old);
        this.isLookahead = true;
        this.nextToken();
        this.isLookahead = false;
        const curr = this.state;
        this.state = old;
        return curr;
      }
      nextTokenStart() {
        return this.nextTokenStartSince(this.state.pos);
      }
      nextTokenStartSince(pos2) {
        skipWhiteSpace.lastIndex = pos2;
        return skipWhiteSpace.test(this.input) ? skipWhiteSpace.lastIndex : pos2;
      }
      lookaheadCharCode() {
        return this.input.charCodeAt(this.nextTokenStart());
      }
      nextTokenInLineStart() {
        return this.nextTokenInLineStartSince(this.state.pos);
      }
      nextTokenInLineStartSince(pos2) {
        skipWhiteSpaceInLine.lastIndex = pos2;
        return skipWhiteSpaceInLine.test(this.input) ? skipWhiteSpaceInLine.lastIndex : pos2;
      }
      lookaheadInLineCharCode() {
        return this.input.charCodeAt(this.nextTokenInLineStart());
      }
      codePointAtPos(pos2) {
        let cp = this.input.charCodeAt(pos2);
        if ((cp & 64512) === 55296 && ++pos2 < this.input.length) {
          const trail = this.input.charCodeAt(pos2);
          if ((trail & 64512) === 56320) {
            cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
          }
        }
        return cp;
      }
      setStrict(strict) {
        this.state.strict = strict;
        if (strict) {
          this.state.strictErrors.forEach(([toParseError, at]) => this.raise(toParseError, at));
          this.state.strictErrors.clear();
        }
      }
      curContext() {
        return this.state.context[this.state.context.length - 1];
      }
      nextToken() {
        this.skipSpace();
        this.state.start = this.state.pos;
        if (!this.isLookahead) this.state.startLoc = this.state.curPosition();
        if (this.state.pos >= this.length) {
          this.finishToken(140);
          return;
        }
        this.getTokenFromCode(this.codePointAtPos(this.state.pos));
      }
      skipBlockComment(commentEnd) {
        let startLoc;
        if (!this.isLookahead) startLoc = this.state.curPosition();
        const start = this.state.pos;
        const end = this.input.indexOf(commentEnd, start + 2);
        if (end === -1) {
          throw this.raise(Errors.UnterminatedComment, this.state.curPosition());
        }
        this.state.pos = end + commentEnd.length;
        lineBreakG.lastIndex = start + 2;
        while (lineBreakG.test(this.input) && lineBreakG.lastIndex <= end) {
          ++this.state.curLine;
          this.state.lineStart = lineBreakG.lastIndex;
        }
        if (this.isLookahead) return;
        const comment = {
          type: "CommentBlock",
          value: this.input.slice(start + 2, end),
          start: this.sourceToOffsetPos(start),
          end: this.sourceToOffsetPos(end + commentEnd.length),
          loc: new SourceLocation22(startLoc, this.state.curPosition())
        };
        if (this.optionFlags & 256) this.pushToken(comment);
        return comment;
      }
      skipLineComment(startSkip) {
        const start = this.state.pos;
        let startLoc;
        if (!this.isLookahead) startLoc = this.state.curPosition();
        let ch = this.input.charCodeAt(this.state.pos += startSkip);
        if (this.state.pos < this.length) {
          while (!isNewLine(ch) && ++this.state.pos < this.length) {
            ch = this.input.charCodeAt(this.state.pos);
          }
        }
        if (this.isLookahead) return;
        const end = this.state.pos;
        const value = this.input.slice(start + startSkip, end);
        const comment = {
          type: "CommentLine",
          value,
          start: this.sourceToOffsetPos(start),
          end: this.sourceToOffsetPos(end),
          loc: new SourceLocation22(startLoc, this.state.curPosition())
        };
        if (this.optionFlags & 256) this.pushToken(comment);
        return comment;
      }
      skipSpace() {
        const spaceStart = this.state.pos;
        const comments = this.optionFlags & 4096 ? [] : null;
        loop: while (this.state.pos < this.length) {
          const ch = this.input.charCodeAt(this.state.pos);
          switch (ch) {
            case 32:
            case 160:
            case 9:
              ++this.state.pos;
              break;
            case 13:
              if (this.input.charCodeAt(this.state.pos + 1) === 10) {
                ++this.state.pos;
              }
            case 10:
            case 8232:
            case 8233:
              ++this.state.pos;
              ++this.state.curLine;
              this.state.lineStart = this.state.pos;
              break;
            case 47:
              switch (this.input.charCodeAt(this.state.pos + 1)) {
                case 42: {
                  const comment = this.skipBlockComment("*/");
                  if (comment !== void 0) {
                    this.addComment(comment);
                    comments == null || comments.push(comment);
                  }
                  break;
                }
                case 47: {
                  const comment = this.skipLineComment(2);
                  if (comment !== void 0) {
                    this.addComment(comment);
                    comments == null || comments.push(comment);
                  }
                  break;
                }
                default:
                  break loop;
              }
              break;
            default:
              if (isWhitespace(ch)) {
                ++this.state.pos;
              } else if (ch === 45 && !this.inModule && this.optionFlags & 8192) {
                const pos2 = this.state.pos;
                if (this.input.charCodeAt(pos2 + 1) === 45 && this.input.charCodeAt(pos2 + 2) === 62 && (spaceStart === 0 || this.state.lineStart > spaceStart)) {
                  const comment = this.skipLineComment(3);
                  if (comment !== void 0) {
                    this.addComment(comment);
                    comments == null || comments.push(comment);
                  }
                } else {
                  break loop;
                }
              } else if (ch === 60 && !this.inModule && this.optionFlags & 8192) {
                const pos2 = this.state.pos;
                if (this.input.charCodeAt(pos2 + 1) === 33 && this.input.charCodeAt(pos2 + 2) === 45 && this.input.charCodeAt(pos2 + 3) === 45) {
                  const comment = this.skipLineComment(4);
                  if (comment !== void 0) {
                    this.addComment(comment);
                    comments == null || comments.push(comment);
                  }
                } else {
                  break loop;
                }
              } else {
                break loop;
              }
          }
        }
        if ((comments == null ? void 0 : comments.length) > 0) {
          const end = this.state.pos;
          const commentWhitespace = {
            start: this.sourceToOffsetPos(spaceStart),
            end: this.sourceToOffsetPos(end),
            comments,
            leadingNode: null,
            trailingNode: null,
            containingNode: null
          };
          this.state.commentStack.push(commentWhitespace);
        }
      }
      finishToken(type, val) {
        this.state.end = this.state.pos;
        this.state.endLoc = this.state.curPosition();
        const prevType = this.state.type;
        this.state.type = type;
        this.state.value = val;
        if (!this.isLookahead) {
          this.updateContext(prevType);
        }
      }
      replaceToken(type) {
        this.state.type = type;
        this.updateContext();
      }
      readToken_numberSign() {
        if (this.state.pos === 0 && this.readToken_interpreter()) {
          return;
        }
        const nextPos = this.state.pos + 1;
        const next = this.codePointAtPos(nextPos);
        if (next >= 48 && next <= 57) {
          throw this.raise(Errors.UnexpectedDigitAfterHash, this.state.curPosition());
        }
        if (next === 123 || next === 91 && this.hasPlugin("recordAndTuple")) {
          this.expectPlugin("recordAndTuple");
          if (this.getPluginOption("recordAndTuple", "syntaxType") === "bar") {
            throw this.raise(next === 123 ? Errors.RecordExpressionHashIncorrectStartSyntaxType : Errors.TupleExpressionHashIncorrectStartSyntaxType, this.state.curPosition());
          }
          this.state.pos += 2;
          if (next === 123) {
            this.finishToken(7);
          } else {
            this.finishToken(1);
          }
        } else if (isIdentifierStart(next)) {
          ++this.state.pos;
          this.finishToken(139, this.readWord1(next));
        } else if (next === 92) {
          ++this.state.pos;
          this.finishToken(139, this.readWord1());
        } else {
          this.finishOp(27, 1);
        }
      }
      readToken_dot() {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next >= 48 && next <= 57) {
          this.readNumber(true);
          return;
        }
        if (next === 46 && this.input.charCodeAt(this.state.pos + 2) === 46) {
          this.state.pos += 3;
          this.finishToken(21);
        } else {
          ++this.state.pos;
          this.finishToken(16);
        }
      }
      readToken_slash() {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === 61) {
          this.finishOp(31, 2);
        } else {
          this.finishOp(56, 1);
        }
      }
      readToken_interpreter() {
        if (this.state.pos !== 0 || this.length < 2) return false;
        let ch = this.input.charCodeAt(this.state.pos + 1);
        if (ch !== 33) return false;
        const start = this.state.pos;
        this.state.pos += 1;
        while (!isNewLine(ch) && ++this.state.pos < this.length) {
          ch = this.input.charCodeAt(this.state.pos);
        }
        const value = this.input.slice(start + 2, this.state.pos);
        this.finishToken(28, value);
        return true;
      }
      readToken_mult_modulo(code2) {
        let type = code2 === 42 ? 55 : 54;
        let width = 1;
        let next = this.input.charCodeAt(this.state.pos + 1);
        if (code2 === 42 && next === 42) {
          width++;
          next = this.input.charCodeAt(this.state.pos + 2);
          type = 57;
        }
        if (next === 61 && !this.state.inType) {
          width++;
          type = code2 === 37 ? 33 : 30;
        }
        this.finishOp(type, width);
      }
      readToken_pipe_amp(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === code2) {
          if (this.input.charCodeAt(this.state.pos + 2) === 61) {
            this.finishOp(30, 3);
          } else {
            this.finishOp(code2 === 124 ? 41 : 42, 2);
          }
          return;
        }
        if (code2 === 124) {
          if (next === 62) {
            this.finishOp(39, 2);
            return;
          }
          if (this.hasPlugin("recordAndTuple") && next === 125) {
            if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
              throw this.raise(Errors.RecordExpressionBarIncorrectEndSyntaxType, this.state.curPosition());
            }
            this.state.pos += 2;
            this.finishToken(9);
            return;
          }
          if (this.hasPlugin("recordAndTuple") && next === 93) {
            if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
              throw this.raise(Errors.TupleExpressionBarIncorrectEndSyntaxType, this.state.curPosition());
            }
            this.state.pos += 2;
            this.finishToken(4);
            return;
          }
        }
        if (next === 61) {
          this.finishOp(30, 2);
          return;
        }
        this.finishOp(code2 === 124 ? 43 : 45, 1);
      }
      readToken_caret() {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === 61 && !this.state.inType) {
          this.finishOp(32, 2);
        } else if (next === 94 && this.hasPlugin(["pipelineOperator", {
          proposal: "hack",
          topicToken: "^^"
        }])) {
          this.finishOp(37, 2);
          const lookaheadCh = this.input.codePointAt(this.state.pos);
          if (lookaheadCh === 94) {
            this.unexpected();
          }
        } else {
          this.finishOp(44, 1);
        }
      }
      readToken_atSign() {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === 64 && this.hasPlugin(["pipelineOperator", {
          proposal: "hack",
          topicToken: "@@"
        }])) {
          this.finishOp(38, 2);
        } else {
          this.finishOp(26, 1);
        }
      }
      readToken_plus_min(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === code2) {
          this.finishOp(34, 2);
          return;
        }
        if (next === 61) {
          this.finishOp(30, 2);
        } else {
          this.finishOp(53, 1);
        }
      }
      readToken_lt() {
        const {
          pos: pos2
        } = this.state;
        const next = this.input.charCodeAt(pos2 + 1);
        if (next === 60) {
          if (this.input.charCodeAt(pos2 + 2) === 61) {
            this.finishOp(30, 3);
            return;
          }
          this.finishOp(51, 2);
          return;
        }
        if (next === 61) {
          this.finishOp(49, 2);
          return;
        }
        this.finishOp(47, 1);
      }
      readToken_gt() {
        const {
          pos: pos2
        } = this.state;
        const next = this.input.charCodeAt(pos2 + 1);
        if (next === 62) {
          const size = this.input.charCodeAt(pos2 + 2) === 62 ? 3 : 2;
          if (this.input.charCodeAt(pos2 + size) === 61) {
            this.finishOp(30, size + 1);
            return;
          }
          this.finishOp(52, size);
          return;
        }
        if (next === 61) {
          this.finishOp(49, 2);
          return;
        }
        this.finishOp(48, 1);
      }
      readToken_eq_excl(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (next === 61) {
          this.finishOp(46, this.input.charCodeAt(this.state.pos + 2) === 61 ? 3 : 2);
          return;
        }
        if (code2 === 61 && next === 62) {
          this.state.pos += 2;
          this.finishToken(19);
          return;
        }
        this.finishOp(code2 === 61 ? 29 : 35, 1);
      }
      readToken_question() {
        const next = this.input.charCodeAt(this.state.pos + 1);
        const next2 = this.input.charCodeAt(this.state.pos + 2);
        if (next === 63) {
          if (next2 === 61) {
            this.finishOp(30, 3);
          } else {
            this.finishOp(40, 2);
          }
        } else if (next === 46 && !(next2 >= 48 && next2 <= 57)) {
          this.state.pos += 2;
          this.finishToken(18);
        } else {
          ++this.state.pos;
          this.finishToken(17);
        }
      }
      getTokenFromCode(code2) {
        switch (code2) {
          case 46:
            this.readToken_dot();
            return;
          case 40:
            ++this.state.pos;
            this.finishToken(10);
            return;
          case 41:
            ++this.state.pos;
            this.finishToken(11);
            return;
          case 59:
            ++this.state.pos;
            this.finishToken(13);
            return;
          case 44:
            ++this.state.pos;
            this.finishToken(12);
            return;
          case 91:
            if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
              if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
                throw this.raise(Errors.TupleExpressionBarIncorrectStartSyntaxType, this.state.curPosition());
              }
              this.state.pos += 2;
              this.finishToken(2);
            } else {
              ++this.state.pos;
              this.finishToken(0);
            }
            return;
          case 93:
            ++this.state.pos;
            this.finishToken(3);
            return;
          case 123:
            if (this.hasPlugin("recordAndTuple") && this.input.charCodeAt(this.state.pos + 1) === 124) {
              if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
                throw this.raise(Errors.RecordExpressionBarIncorrectStartSyntaxType, this.state.curPosition());
              }
              this.state.pos += 2;
              this.finishToken(6);
            } else {
              ++this.state.pos;
              this.finishToken(5);
            }
            return;
          case 125:
            ++this.state.pos;
            this.finishToken(8);
            return;
          case 58:
            if (this.hasPlugin("functionBind") && this.input.charCodeAt(this.state.pos + 1) === 58) {
              this.finishOp(15, 2);
            } else {
              ++this.state.pos;
              this.finishToken(14);
            }
            return;
          case 63:
            this.readToken_question();
            return;
          case 96:
            this.readTemplateToken();
            return;
          case 48: {
            const next = this.input.charCodeAt(this.state.pos + 1);
            if (next === 120 || next === 88) {
              this.readRadixNumber(16);
              return;
            }
            if (next === 111 || next === 79) {
              this.readRadixNumber(8);
              return;
            }
            if (next === 98 || next === 66) {
              this.readRadixNumber(2);
              return;
            }
          }
          case 49:
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:
          case 56:
          case 57:
            this.readNumber(false);
            return;
          case 34:
          case 39:
            this.readString(code2);
            return;
          case 47:
            this.readToken_slash();
            return;
          case 37:
          case 42:
            this.readToken_mult_modulo(code2);
            return;
          case 124:
          case 38:
            this.readToken_pipe_amp(code2);
            return;
          case 94:
            this.readToken_caret();
            return;
          case 43:
          case 45:
            this.readToken_plus_min(code2);
            return;
          case 60:
            this.readToken_lt();
            return;
          case 62:
            this.readToken_gt();
            return;
          case 61:
          case 33:
            this.readToken_eq_excl(code2);
            return;
          case 126:
            this.finishOp(36, 1);
            return;
          case 64:
            this.readToken_atSign();
            return;
          case 35:
            this.readToken_numberSign();
            return;
          case 92:
            this.readWord();
            return;
          default:
            if (isIdentifierStart(code2)) {
              this.readWord(code2);
              return;
            }
        }
        throw this.raise(Errors.InvalidOrUnexpectedToken, this.state.curPosition(), {
          unexpected: String.fromCodePoint(code2)
        });
      }
      finishOp(type, size) {
        const str = this.input.slice(this.state.pos, this.state.pos + size);
        this.state.pos += size;
        this.finishToken(type, str);
      }
      readRegexp() {
        const startLoc = this.state.startLoc;
        const start = this.state.start + 1;
        let escaped, inClass;
        let {
          pos: pos2
        } = this.state;
        for (; ; ++pos2) {
          if (pos2 >= this.length) {
            throw this.raise(Errors.UnterminatedRegExp, createPositionWithColumnOffset(startLoc, 1));
          }
          const ch = this.input.charCodeAt(pos2);
          if (isNewLine(ch)) {
            throw this.raise(Errors.UnterminatedRegExp, createPositionWithColumnOffset(startLoc, 1));
          }
          if (escaped) {
            escaped = false;
          } else {
            if (ch === 91) {
              inClass = true;
            } else if (ch === 93 && inClass) {
              inClass = false;
            } else if (ch === 47 && !inClass) {
              break;
            }
            escaped = ch === 92;
          }
        }
        const content = this.input.slice(start, pos2);
        ++pos2;
        let mods = "";
        const nextPos = () => createPositionWithColumnOffset(startLoc, pos2 + 2 - start);
        while (pos2 < this.length) {
          const cp = this.codePointAtPos(pos2);
          const char = String.fromCharCode(cp);
          if (VALID_REGEX_FLAGS.has(cp)) {
            if (cp === 118) {
              if (mods.includes("u")) {
                this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
              }
            } else if (cp === 117) {
              if (mods.includes("v")) {
                this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
              }
            }
            if (mods.includes(char)) {
              this.raise(Errors.DuplicateRegExpFlags, nextPos());
            }
          } else if (isIdentifierChar(cp) || cp === 92) {
            this.raise(Errors.MalformedRegExpFlags, nextPos());
          } else {
            break;
          }
          ++pos2;
          mods += char;
        }
        this.state.pos = pos2;
        this.finishToken(138, {
          pattern: content,
          flags: mods
        });
      }
      readInt(radix, len, forceLen = false, allowNumSeparator = true) {
        const {
          n,
          pos: pos2
        } = readInt(this.input, this.state.pos, this.state.lineStart, this.state.curLine, radix, len, forceLen, allowNumSeparator, this.errorHandlers_readInt, false);
        this.state.pos = pos2;
        return n;
      }
      readRadixNumber(radix) {
        const start = this.state.pos;
        const startLoc = this.state.curPosition();
        let isBigInt = false;
        this.state.pos += 2;
        const val = this.readInt(radix);
        if (val == null) {
          this.raise(Errors.InvalidDigit, createPositionWithColumnOffset(startLoc, 2), {
            radix
          });
        }
        const next = this.input.charCodeAt(this.state.pos);
        if (next === 110) {
          ++this.state.pos;
          isBigInt = true;
        } else if (next === 109) {
          throw this.raise(Errors.InvalidDecimal, startLoc);
        }
        if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
          throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
        }
        if (isBigInt) {
          const str = this.input.slice(start, this.state.pos).replace(/[_n]/g, "");
          this.finishToken(136, str);
          return;
        }
        this.finishToken(135, val);
      }
      readNumber(startsWithDot) {
        const start = this.state.pos;
        const startLoc = this.state.curPosition();
        let isFloat = false;
        let isBigInt = false;
        let hasExponent = false;
        let isOctal = false;
        if (!startsWithDot && this.readInt(10) === null) {
          this.raise(Errors.InvalidNumber, this.state.curPosition());
        }
        const hasLeadingZero = this.state.pos - start >= 2 && this.input.charCodeAt(start) === 48;
        if (hasLeadingZero) {
          const integer2 = this.input.slice(start, this.state.pos);
          this.recordStrictModeErrors(Errors.StrictOctalLiteral, startLoc);
          if (!this.state.strict) {
            const underscorePos = integer2.indexOf("_");
            if (underscorePos > 0) {
              this.raise(Errors.ZeroDigitNumericSeparator, createPositionWithColumnOffset(startLoc, underscorePos));
            }
          }
          isOctal = hasLeadingZero && !/[89]/.test(integer2);
        }
        let next = this.input.charCodeAt(this.state.pos);
        if (next === 46 && !isOctal) {
          ++this.state.pos;
          this.readInt(10);
          isFloat = true;
          next = this.input.charCodeAt(this.state.pos);
        }
        if ((next === 69 || next === 101) && !isOctal) {
          next = this.input.charCodeAt(++this.state.pos);
          if (next === 43 || next === 45) {
            ++this.state.pos;
          }
          if (this.readInt(10) === null) {
            this.raise(Errors.InvalidOrMissingExponent, startLoc);
          }
          isFloat = true;
          hasExponent = true;
          next = this.input.charCodeAt(this.state.pos);
        }
        if (next === 110) {
          if (isFloat || hasLeadingZero) {
            this.raise(Errors.InvalidBigIntLiteral, startLoc);
          }
          ++this.state.pos;
          isBigInt = true;
        }
        if (next === 109) {
          this.expectPlugin("decimal", this.state.curPosition());
          if (hasExponent || hasLeadingZero) {
            this.raise(Errors.InvalidDecimal, startLoc);
          }
          ++this.state.pos;
          var isDecimal = true;
        }
        if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
          throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
        }
        const str = this.input.slice(start, this.state.pos).replace(/[_mn]/g, "");
        if (isBigInt) {
          this.finishToken(136, str);
          return;
        }
        if (isDecimal) {
          this.finishToken(137, str);
          return;
        }
        const val = isOctal ? parseInt(str, 8) : parseFloat(str);
        this.finishToken(135, val);
      }
      readCodePoint(throwOnInvalid) {
        const {
          code: code2,
          pos: pos2
        } = readCodePoint(this.input, this.state.pos, this.state.lineStart, this.state.curLine, throwOnInvalid, this.errorHandlers_readCodePoint);
        this.state.pos = pos2;
        return code2;
      }
      readString(quote) {
        const {
          str,
          pos: pos2,
          curLine,
          lineStart
        } = readStringContents(quote === 34 ? "double" : "single", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_string);
        this.state.pos = pos2 + 1;
        this.state.lineStart = lineStart;
        this.state.curLine = curLine;
        this.finishToken(134, str);
      }
      readTemplateContinuation() {
        if (!this.match(8)) {
          this.unexpected(null, 8);
        }
        this.state.pos--;
        this.readTemplateToken();
      }
      readTemplateToken() {
        const opening = this.input[this.state.pos];
        const {
          str,
          firstInvalidLoc,
          pos: pos2,
          curLine,
          lineStart
        } = readStringContents("template", this.input, this.state.pos + 1, this.state.lineStart, this.state.curLine, this.errorHandlers_readStringContents_template);
        this.state.pos = pos2 + 1;
        this.state.lineStart = lineStart;
        this.state.curLine = curLine;
        if (firstInvalidLoc) {
          this.state.firstInvalidTemplateEscapePos = new Position(firstInvalidLoc.curLine, firstInvalidLoc.pos - firstInvalidLoc.lineStart, this.sourceToOffsetPos(firstInvalidLoc.pos));
        }
        if (this.input.codePointAt(pos2) === 96) {
          this.finishToken(24, firstInvalidLoc ? null : opening + str + "`");
        } else {
          this.state.pos++;
          this.finishToken(25, firstInvalidLoc ? null : opening + str + "${");
        }
      }
      recordStrictModeErrors(toParseError, at) {
        const index = at.index;
        if (this.state.strict && !this.state.strictErrors.has(index)) {
          this.raise(toParseError, at);
        } else {
          this.state.strictErrors.set(index, [toParseError, at]);
        }
      }
      readWord1(firstCode) {
        this.state.containsEsc = false;
        let word = "";
        const start = this.state.pos;
        let chunkStart = this.state.pos;
        if (firstCode !== void 0) {
          this.state.pos += firstCode <= 65535 ? 1 : 2;
        }
        while (this.state.pos < this.length) {
          const ch = this.codePointAtPos(this.state.pos);
          if (isIdentifierChar(ch)) {
            this.state.pos += ch <= 65535 ? 1 : 2;
          } else if (ch === 92) {
            this.state.containsEsc = true;
            word += this.input.slice(chunkStart, this.state.pos);
            const escStart = this.state.curPosition();
            const identifierCheck = this.state.pos === start ? isIdentifierStart : isIdentifierChar;
            if (this.input.charCodeAt(++this.state.pos) !== 117) {
              this.raise(Errors.MissingUnicodeEscape, this.state.curPosition());
              chunkStart = this.state.pos - 1;
              continue;
            }
            ++this.state.pos;
            const esc2 = this.readCodePoint(true);
            if (esc2 !== null) {
              if (!identifierCheck(esc2)) {
                this.raise(Errors.EscapedCharNotAnIdentifier, escStart);
              }
              word += String.fromCodePoint(esc2);
            }
            chunkStart = this.state.pos;
          } else {
            break;
          }
        }
        return word + this.input.slice(chunkStart, this.state.pos);
      }
      readWord(firstCode) {
        const word = this.readWord1(firstCode);
        const type = keywords$1.get(word);
        if (type !== void 0) {
          this.finishToken(type, tokenLabelName(type));
        } else {
          this.finishToken(132, word);
        }
      }
      checkKeywordEscapes() {
        const {
          type
        } = this.state;
        if (tokenIsKeyword(type) && this.state.containsEsc) {
          this.raise(Errors.InvalidEscapedReservedWord, this.state.startLoc, {
            reservedWord: tokenLabelName(type)
          });
        }
      }
      raise(toParseError, at, details = {}) {
        const loc = at instanceof Position ? at : at.loc.start;
        const error45 = toParseError(loc, details);
        if (!(this.optionFlags & 2048)) throw error45;
        if (!this.isLookahead) this.state.errors.push(error45);
        return error45;
      }
      raiseOverwrite(toParseError, at, details = {}) {
        const loc = at instanceof Position ? at : at.loc.start;
        const pos2 = loc.index;
        const errors = this.state.errors;
        for (let i = errors.length - 1; i >= 0; i--) {
          const error45 = errors[i];
          if (error45.loc.index === pos2) {
            return errors[i] = toParseError(loc, details);
          }
          if (error45.loc.index < pos2) break;
        }
        return this.raise(toParseError, at, details);
      }
      updateContext(prevType) {
      }
      unexpected(loc, type) {
        throw this.raise(Errors.UnexpectedToken, loc != null ? loc : this.state.startLoc, {
          expected: type ? tokenLabelName(type) : null
        });
      }
      expectPlugin(pluginName, loc) {
        if (this.hasPlugin(pluginName)) {
          return true;
        }
        throw this.raise(Errors.MissingPlugin, loc != null ? loc : this.state.startLoc, {
          missingPlugin: [pluginName]
        });
      }
      expectOnePlugin(pluginNames) {
        if (!pluginNames.some((name) => this.hasPlugin(name))) {
          throw this.raise(Errors.MissingOneOfPlugins, this.state.startLoc, {
            missingPlugin: pluginNames
          });
        }
      }
      errorBuilder(error45) {
        return (pos2, lineStart, curLine) => {
          this.raise(error45, buildPosition(pos2, lineStart, curLine));
        };
      }
    };
    var ClassScope = class {
      constructor() {
        this.privateNames = /* @__PURE__ */ new Set();
        this.loneAccessors = /* @__PURE__ */ new Map();
        this.undefinedPrivateNames = /* @__PURE__ */ new Map();
      }
    };
    var ClassScopeHandler = class {
      constructor(parser) {
        this.parser = void 0;
        this.stack = [];
        this.undefinedPrivateNames = /* @__PURE__ */ new Map();
        this.parser = parser;
      }
      current() {
        return this.stack[this.stack.length - 1];
      }
      enter() {
        this.stack.push(new ClassScope());
      }
      exit() {
        const oldClassScope = this.stack.pop();
        const current = this.current();
        for (const [name, loc] of Array.from(oldClassScope.undefinedPrivateNames)) {
          if (current) {
            if (!current.undefinedPrivateNames.has(name)) {
              current.undefinedPrivateNames.set(name, loc);
            }
          } else {
            this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, {
              identifierName: name
            });
          }
        }
      }
      declarePrivateName(name, elementType, loc) {
        const {
          privateNames,
          loneAccessors,
          undefinedPrivateNames
        } = this.current();
        let redefined = privateNames.has(name);
        if (elementType & 3) {
          const accessor = redefined && loneAccessors.get(name);
          if (accessor) {
            const oldStatic = accessor & 4;
            const newStatic = elementType & 4;
            const oldKind = accessor & 3;
            const newKind = elementType & 3;
            redefined = oldKind === newKind || oldStatic !== newStatic;
            if (!redefined) loneAccessors.delete(name);
          } else if (!redefined) {
            loneAccessors.set(name, elementType);
          }
        }
        if (redefined) {
          this.parser.raise(Errors.PrivateNameRedeclaration, loc, {
            identifierName: name
          });
        }
        privateNames.add(name);
        undefinedPrivateNames.delete(name);
      }
      usePrivateName(name, loc) {
        let classScope;
        for (classScope of this.stack) {
          if (classScope.privateNames.has(name)) return;
        }
        if (classScope) {
          classScope.undefinedPrivateNames.set(name, loc);
        } else {
          this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, {
            identifierName: name
          });
        }
      }
    };
    var ExpressionScope = class {
      constructor(type = 0) {
        this.type = type;
      }
      canBeArrowParameterDeclaration() {
        return this.type === 2 || this.type === 1;
      }
      isCertainlyParameterDeclaration() {
        return this.type === 3;
      }
    };
    var ArrowHeadParsingScope = class extends ExpressionScope {
      constructor(type) {
        super(type);
        this.declarationErrors = /* @__PURE__ */ new Map();
      }
      recordDeclarationError(ParsingErrorClass, at) {
        const index = at.index;
        this.declarationErrors.set(index, [ParsingErrorClass, at]);
      }
      clearDeclarationError(index) {
        this.declarationErrors.delete(index);
      }
      iterateErrors(iterator) {
        this.declarationErrors.forEach(iterator);
      }
    };
    var ExpressionScopeHandler = class {
      constructor(parser) {
        this.parser = void 0;
        this.stack = [new ExpressionScope()];
        this.parser = parser;
      }
      enter(scope) {
        this.stack.push(scope);
      }
      exit() {
        this.stack.pop();
      }
      recordParameterInitializerError(toParseError, node) {
        const origin = node.loc.start;
        const {
          stack: stack2
        } = this;
        let i = stack2.length - 1;
        let scope = stack2[i];
        while (!scope.isCertainlyParameterDeclaration()) {
          if (scope.canBeArrowParameterDeclaration()) {
            scope.recordDeclarationError(toParseError, origin);
          } else {
            return;
          }
          scope = stack2[--i];
        }
        this.parser.raise(toParseError, origin);
      }
      recordArrowParameterBindingError(error45, node) {
        const {
          stack: stack2
        } = this;
        const scope = stack2[stack2.length - 1];
        const origin = node.loc.start;
        if (scope.isCertainlyParameterDeclaration()) {
          this.parser.raise(error45, origin);
        } else if (scope.canBeArrowParameterDeclaration()) {
          scope.recordDeclarationError(error45, origin);
        } else {
          return;
        }
      }
      recordAsyncArrowParametersError(at) {
        const {
          stack: stack2
        } = this;
        let i = stack2.length - 1;
        let scope = stack2[i];
        while (scope.canBeArrowParameterDeclaration()) {
          if (scope.type === 2) {
            scope.recordDeclarationError(Errors.AwaitBindingIdentifier, at);
          }
          scope = stack2[--i];
        }
      }
      validateAsPattern() {
        const {
          stack: stack2
        } = this;
        const currentScope = stack2[stack2.length - 1];
        if (!currentScope.canBeArrowParameterDeclaration()) return;
        currentScope.iterateErrors(([toParseError, loc]) => {
          this.parser.raise(toParseError, loc);
          let i = stack2.length - 2;
          let scope = stack2[i];
          while (scope.canBeArrowParameterDeclaration()) {
            scope.clearDeclarationError(loc.index);
            scope = stack2[--i];
          }
        });
      }
    };
    function newParameterDeclarationScope() {
      return new ExpressionScope(3);
    }
    function newArrowHeadScope() {
      return new ArrowHeadParsingScope(1);
    }
    function newAsyncArrowScope() {
      return new ArrowHeadParsingScope(2);
    }
    function newExpressionScope() {
      return new ExpressionScope();
    }
    var ProductionParameterHandler = class {
      constructor() {
        this.stacks = [];
      }
      enter(flags) {
        this.stacks.push(flags);
      }
      exit() {
        this.stacks.pop();
      }
      currentFlags() {
        return this.stacks[this.stacks.length - 1];
      }
      get hasAwait() {
        return (this.currentFlags() & 2) > 0;
      }
      get hasYield() {
        return (this.currentFlags() & 1) > 0;
      }
      get hasReturn() {
        return (this.currentFlags() & 4) > 0;
      }
      get hasIn() {
        return (this.currentFlags() & 8) > 0;
      }
    };
    function functionFlags(isAsync, isGenerator) {
      return (isAsync ? 2 : 0) | (isGenerator ? 1 : 0);
    }
    var UtilParser = class extends Tokenizer {
      addExtra(node, key2, value, enumerable = true) {
        if (!node) return;
        let {
          extra
        } = node;
        if (extra == null) {
          extra = {};
          node.extra = extra;
        }
        if (enumerable) {
          extra[key2] = value;
        } else {
          Object.defineProperty(extra, key2, {
            enumerable,
            value
          });
        }
      }
      isContextual(token2) {
        return this.state.type === token2 && !this.state.containsEsc;
      }
      isUnparsedContextual(nameStart, name) {
        const nameEnd = nameStart + name.length;
        if (this.input.slice(nameStart, nameEnd) === name) {
          const nextCh = this.input.charCodeAt(nameEnd);
          return !(isIdentifierChar(nextCh) || (nextCh & 64512) === 55296);
        }
        return false;
      }
      isLookaheadContextual(name) {
        const next = this.nextTokenStart();
        return this.isUnparsedContextual(next, name);
      }
      eatContextual(token2) {
        if (this.isContextual(token2)) {
          this.next();
          return true;
        }
        return false;
      }
      expectContextual(token2, toParseError) {
        if (!this.eatContextual(token2)) {
          if (toParseError != null) {
            throw this.raise(toParseError, this.state.startLoc);
          }
          this.unexpected(null, token2);
        }
      }
      canInsertSemicolon() {
        return this.match(140) || this.match(8) || this.hasPrecedingLineBreak();
      }
      hasPrecedingLineBreak() {
        return hasNewLine(this.input, this.offsetToSourcePos(this.state.lastTokEndLoc.index), this.state.start);
      }
      hasFollowingLineBreak() {
        return hasNewLine(this.input, this.state.end, this.nextTokenStart());
      }
      isLineTerminator() {
        return this.eat(13) || this.canInsertSemicolon();
      }
      semicolon(allowAsi = true) {
        if (allowAsi ? this.isLineTerminator() : this.eat(13)) return;
        this.raise(Errors.MissingSemicolon, this.state.lastTokEndLoc);
      }
      expect(type, loc) {
        if (!this.eat(type)) {
          this.unexpected(loc, type);
        }
      }
      tryParse(fn, oldState = this.state.clone()) {
        const abortSignal = {
          node: null
        };
        try {
          const node = fn((node2 = null) => {
            abortSignal.node = node2;
            throw abortSignal;
          });
          if (this.state.errors.length > oldState.errors.length) {
            const failState = this.state;
            this.state = oldState;
            this.state.tokensLength = failState.tokensLength;
            return {
              node,
              error: failState.errors[oldState.errors.length],
              thrown: false,
              aborted: false,
              failState
            };
          }
          return {
            node,
            error: null,
            thrown: false,
            aborted: false,
            failState: null
          };
        } catch (error45) {
          const failState = this.state;
          this.state = oldState;
          if (error45 instanceof SyntaxError) {
            return {
              node: null,
              error: error45,
              thrown: true,
              aborted: false,
              failState
            };
          }
          if (error45 === abortSignal) {
            return {
              node: abortSignal.node,
              error: null,
              thrown: false,
              aborted: true,
              failState
            };
          }
          throw error45;
        }
      }
      checkExpressionErrors(refExpressionErrors, andThrow) {
        if (!refExpressionErrors) return false;
        const {
          shorthandAssignLoc,
          doubleProtoLoc,
          privateKeyLoc,
          optionalParametersLoc
        } = refExpressionErrors;
        const hasErrors = !!shorthandAssignLoc || !!doubleProtoLoc || !!optionalParametersLoc || !!privateKeyLoc;
        if (!andThrow) {
          return hasErrors;
        }
        if (shorthandAssignLoc != null) {
          this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
        }
        if (doubleProtoLoc != null) {
          this.raise(Errors.DuplicateProto, doubleProtoLoc);
        }
        if (privateKeyLoc != null) {
          this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
        }
        if (optionalParametersLoc != null) {
          this.unexpected(optionalParametersLoc);
        }
      }
      isLiteralPropertyName() {
        return tokenIsLiteralPropertyName(this.state.type);
      }
      isPrivateName(node) {
        return node.type === "PrivateName";
      }
      getPrivateNameSV(node) {
        return node.id.name;
      }
      hasPropertyAsPrivateName(node) {
        return (node.type === "MemberExpression" || node.type === "OptionalMemberExpression") && this.isPrivateName(node.property);
      }
      isObjectProperty(node) {
        return node.type === "ObjectProperty";
      }
      isObjectMethod(node) {
        return node.type === "ObjectMethod";
      }
      initializeScopes(inModule = this.options.sourceType === "module") {
        const oldLabels = this.state.labels;
        this.state.labels = [];
        const oldExportedIdentifiers = this.exportedIdentifiers;
        this.exportedIdentifiers = /* @__PURE__ */ new Set();
        const oldInModule = this.inModule;
        this.inModule = inModule;
        const oldScope = this.scope;
        const ScopeHandler2 = this.getScopeHandler();
        this.scope = new ScopeHandler2(this, inModule);
        const oldProdParam = this.prodParam;
        this.prodParam = new ProductionParameterHandler();
        const oldClassScope = this.classScope;
        this.classScope = new ClassScopeHandler(this);
        const oldExpressionScope = this.expressionScope;
        this.expressionScope = new ExpressionScopeHandler(this);
        return () => {
          this.state.labels = oldLabels;
          this.exportedIdentifiers = oldExportedIdentifiers;
          this.inModule = oldInModule;
          this.scope = oldScope;
          this.prodParam = oldProdParam;
          this.classScope = oldClassScope;
          this.expressionScope = oldExpressionScope;
        };
      }
      enterInitialScopes() {
        let paramFlags = 0;
        if (this.inModule) {
          paramFlags |= 2;
        }
        if (this.optionFlags & 32) {
          paramFlags |= 1;
        }
        this.scope.enter(1);
        this.prodParam.enter(paramFlags);
      }
      checkDestructuringPrivate(refExpressionErrors) {
        const {
          privateKeyLoc
        } = refExpressionErrors;
        if (privateKeyLoc !== null) {
          this.expectPlugin("destructuringPrivate", privateKeyLoc);
        }
      }
    };
    var ExpressionErrors = class {
      constructor() {
        this.shorthandAssignLoc = null;
        this.doubleProtoLoc = null;
        this.privateKeyLoc = null;
        this.optionalParametersLoc = null;
      }
    };
    var Node2 = class {
      constructor(parser, pos2, loc) {
        this.type = "";
        this.start = pos2;
        this.end = 0;
        this.loc = new SourceLocation22(loc);
        if ((parser == null ? void 0 : parser.optionFlags) & 128) this.range = [pos2, 0];
        if (parser != null && parser.filename) this.loc.filename = parser.filename;
      }
    };
    var NodePrototype = Node2.prototype;
    {
      NodePrototype.__clone = function() {
        const newNode = new Node2(void 0, this.start, this.loc.start);
        const keys = Object.keys(this);
        for (let i = 0, length = keys.length; i < length; i++) {
          const key2 = keys[i];
          if (key2 !== "leadingComments" && key2 !== "trailingComments" && key2 !== "innerComments") {
            newNode[key2] = this[key2];
          }
        }
        return newNode;
      };
    }
    function clonePlaceholder(node) {
      return cloneIdentifier(node);
    }
    function cloneIdentifier(node) {
      const {
        type,
        start,
        end,
        loc,
        range,
        extra,
        name
      } = node;
      const cloned = Object.create(NodePrototype);
      cloned.type = type;
      cloned.start = start;
      cloned.end = end;
      cloned.loc = loc;
      cloned.range = range;
      cloned.extra = extra;
      cloned.name = name;
      if (type === "Placeholder") {
        cloned.expectedNode = node.expectedNode;
      }
      return cloned;
    }
    function cloneStringLiteral(node) {
      const {
        type,
        start,
        end,
        loc,
        range,
        extra
      } = node;
      if (type === "Placeholder") {
        return clonePlaceholder(node);
      }
      const cloned = Object.create(NodePrototype);
      cloned.type = type;
      cloned.start = start;
      cloned.end = end;
      cloned.loc = loc;
      cloned.range = range;
      if (node.raw !== void 0) {
        cloned.raw = node.raw;
      } else {
        cloned.extra = extra;
      }
      cloned.value = node.value;
      return cloned;
    }
    var NodeUtils = class extends UtilParser {
      startNode() {
        const loc = this.state.startLoc;
        return new Node2(this, loc.index, loc);
      }
      startNodeAt(loc) {
        return new Node2(this, loc.index, loc);
      }
      startNodeAtNode(type) {
        return this.startNodeAt(type.loc.start);
      }
      finishNode(node, type) {
        return this.finishNodeAt(node, type, this.state.lastTokEndLoc);
      }
      finishNodeAt(node, type, endLoc) {
        node.type = type;
        node.end = endLoc.index;
        node.loc.end = endLoc;
        if (this.optionFlags & 128) node.range[1] = endLoc.index;
        if (this.optionFlags & 4096) {
          this.processComment(node);
        }
        return node;
      }
      resetStartLocation(node, startLoc) {
        node.start = startLoc.index;
        node.loc.start = startLoc;
        if (this.optionFlags & 128) node.range[0] = startLoc.index;
      }
      resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
        node.end = endLoc.index;
        node.loc.end = endLoc;
        if (this.optionFlags & 128) node.range[1] = endLoc.index;
      }
      resetStartLocationFromNode(node, locationNode) {
        this.resetStartLocation(node, locationNode.loc.start);
      }
    };
    var reservedTypes = /* @__PURE__ */ new Set(["_", "any", "bool", "boolean", "empty", "extends", "false", "interface", "mixed", "null", "number", "static", "string", "true", "typeof", "void"]);
    var FlowErrors = ParseErrorEnum`flow`({
      AmbiguousConditionalArrow: "Ambiguous expression: wrap the arrow functions in parentheses to disambiguate.",
      AmbiguousDeclareModuleKind: "Found both `declare module.exports` and `declare export` in the same module. Modules can only have 1 since they are either an ES module or they are a CommonJS module.",
      AssignReservedType: ({
        reservedType
      }) => `Cannot overwrite reserved type ${reservedType}.`,
      DeclareClassElement: "The `declare` modifier can only appear on class fields.",
      DeclareClassFieldInitializer: "Initializers are not allowed in fields with the `declare` modifier.",
      DuplicateDeclareModuleExports: "Duplicate `declare module.exports` statement.",
      EnumBooleanMemberNotInitialized: ({
        memberName,
        enumName
      }) => `Boolean enum members need to be initialized. Use either \`${memberName} = true,\` or \`${memberName} = false,\` in enum \`${enumName}\`.`,
      EnumDuplicateMemberName: ({
        memberName,
        enumName
      }) => `Enum member names need to be unique, but the name \`${memberName}\` has already been used before in enum \`${enumName}\`.`,
      EnumInconsistentMemberValues: ({
        enumName
      }) => `Enum \`${enumName}\` has inconsistent member initializers. Either use no initializers, or consistently use literals (either booleans, numbers, or strings) for all member initializers.`,
      EnumInvalidExplicitType: ({
        invalidEnumType,
        enumName
      }) => `Enum type \`${invalidEnumType}\` is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
      EnumInvalidExplicitTypeUnknownSupplied: ({
        enumName
      }) => `Supplied enum type is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
      EnumInvalidMemberInitializerPrimaryType: ({
        enumName,
        memberName,
        explicitType
      }) => `Enum \`${enumName}\` has type \`${explicitType}\`, so the initializer of \`${memberName}\` needs to be a ${explicitType} literal.`,
      EnumInvalidMemberInitializerSymbolType: ({
        enumName,
        memberName
      }) => `Symbol enum members cannot be initialized. Use \`${memberName},\` in enum \`${enumName}\`.`,
      EnumInvalidMemberInitializerUnknownType: ({
        enumName,
        memberName
      }) => `The enum member initializer for \`${memberName}\` needs to be a literal (either a boolean, number, or string) in enum \`${enumName}\`.`,
      EnumInvalidMemberName: ({
        enumName,
        memberName,
        suggestion
      }) => `Enum member names cannot start with lowercase 'a' through 'z'. Instead of using \`${memberName}\`, consider using \`${suggestion}\`, in enum \`${enumName}\`.`,
      EnumNumberMemberNotInitialized: ({
        enumName,
        memberName
      }) => `Number enum members need to be initialized, e.g. \`${memberName} = 1\` in enum \`${enumName}\`.`,
      EnumStringMemberInconsistentlyInitialized: ({
        enumName
      }) => `String enum members need to consistently either all use initializers, or use no initializers, in enum \`${enumName}\`.`,
      GetterMayNotHaveThisParam: "A getter cannot have a `this` parameter.",
      ImportReflectionHasImportType: "An `import module` declaration can not use `type` or `typeof` keyword.",
      ImportTypeShorthandOnlyInPureImport: "The `type` and `typeof` keywords on named imports can only be used on regular `import` statements. It cannot be used with `import type` or `import typeof` statements.",
      InexactInsideExact: "Explicit inexact syntax cannot appear inside an explicit exact object type.",
      InexactInsideNonObject: "Explicit inexact syntax cannot appear in class or interface definitions.",
      InexactVariance: "Explicit inexact syntax cannot have variance.",
      InvalidNonTypeImportInDeclareModule: "Imports within a `declare module` body must always be `import type` or `import typeof`.",
      MissingTypeParamDefault: "Type parameter declaration needs a default, since a preceding type parameter declaration has a default.",
      NestedDeclareModule: "`declare module` cannot be used inside another `declare module`.",
      NestedFlowComment: "Cannot have a flow comment inside another flow comment.",
      PatternIsOptional: Object.assign({
        message: "A binding pattern parameter cannot be optional in an implementation signature."
      }, {
        reasonCode: "OptionalBindingPattern"
      }),
      SetterMayNotHaveThisParam: "A setter cannot have a `this` parameter.",
      SpreadVariance: "Spread properties cannot have variance.",
      ThisParamAnnotationRequired: "A type annotation is required for the `this` parameter.",
      ThisParamBannedInConstructor: "Constructors cannot have a `this` parameter; constructors don't bind `this` like other functions.",
      ThisParamMayNotBeOptional: "The `this` parameter cannot be optional.",
      ThisParamMustBeFirst: "The `this` parameter must be the first function parameter.",
      ThisParamNoDefault: "The `this` parameter may not have a default value.",
      TypeBeforeInitializer: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
      TypeCastInPattern: "The type cast expression is expected to be wrapped with parenthesis.",
      UnexpectedExplicitInexactInObject: "Explicit inexact syntax must appear at the end of an inexact object.",
      UnexpectedReservedType: ({
        reservedType
      }) => `Unexpected reserved type ${reservedType}.`,
      UnexpectedReservedUnderscore: "`_` is only allowed as a type argument to call or new.",
      UnexpectedSpaceBetweenModuloChecks: "Spaces between `%` and `checks` are not allowed here.",
      UnexpectedSpreadType: "Spread operator cannot appear in class or interface definitions.",
      UnexpectedSubtractionOperand: 'Unexpected token, expected "number" or "bigint".',
      UnexpectedTokenAfterTypeParameter: "Expected an arrow function after this type parameter declaration.",
      UnexpectedTypeParameterBeforeAsyncArrowFunction: "Type parameters must come after the async keyword, e.g. instead of `<T> async () => {}`, use `async <T>() => {}`.",
      UnsupportedDeclareExportKind: ({
        unsupportedExportKind,
        suggestion
      }) => `\`declare export ${unsupportedExportKind}\` is not supported. Use \`${suggestion}\` instead.`,
      UnsupportedStatementInDeclareModule: "Only declares and type imports are allowed inside declare module.",
      UnterminatedFlowComment: "Unterminated flow-comment."
    });
    function isEsModuleType(bodyElement) {
      return bodyElement.type === "DeclareExportAllDeclaration" || bodyElement.type === "DeclareExportDeclaration" && (!bodyElement.declaration || bodyElement.declaration.type !== "TypeAlias" && bodyElement.declaration.type !== "InterfaceDeclaration");
    }
    function hasTypeImportKind(node) {
      return node.importKind === "type" || node.importKind === "typeof";
    }
    var exportSuggestions = {
      const: "declare export var",
      let: "declare export var",
      type: "export type",
      interface: "export interface"
    };
    function partition(list, test) {
      const list1 = [];
      const list2 = [];
      for (let i = 0; i < list.length; i++) {
        (test(list[i], i, list) ? list1 : list2).push(list[i]);
      }
      return [list1, list2];
    }
    var FLOW_PRAGMA_REGEX = /\*?\s*@((?:no)?flow)\b/;
    var flow = (superClass) => class FlowParserMixin extends superClass {
      constructor(...args) {
        super(...args);
        this.flowPragma = void 0;
      }
      getScopeHandler() {
        return FlowScopeHandler;
      }
      shouldParseTypes() {
        return this.getPluginOption("flow", "all") || this.flowPragma === "flow";
      }
      finishToken(type, val) {
        if (type !== 134 && type !== 13 && type !== 28) {
          if (this.flowPragma === void 0) {
            this.flowPragma = null;
          }
        }
        super.finishToken(type, val);
      }
      addComment(comment) {
        if (this.flowPragma === void 0) {
          const matches = FLOW_PRAGMA_REGEX.exec(comment.value);
          if (!matches) ;
          else if (matches[1] === "flow") {
            this.flowPragma = "flow";
          } else if (matches[1] === "noflow") {
            this.flowPragma = "noflow";
          } else {
            throw new Error("Unexpected flow pragma");
          }
        }
        super.addComment(comment);
      }
      flowParseTypeInitialiser(tok) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        this.expect(tok || 14);
        const type = this.flowParseType();
        this.state.inType = oldInType;
        return type;
      }
      flowParsePredicate() {
        const node = this.startNode();
        const moduloLoc = this.state.startLoc;
        this.next();
        this.expectContextual(110);
        if (this.state.lastTokStartLoc.index > moduloLoc.index + 1) {
          this.raise(FlowErrors.UnexpectedSpaceBetweenModuloChecks, moduloLoc);
        }
        if (this.eat(10)) {
          node.value = super.parseExpression();
          this.expect(11);
          return this.finishNode(node, "DeclaredPredicate");
        } else {
          return this.finishNode(node, "InferredPredicate");
        }
      }
      flowParseTypeAndPredicateInitialiser() {
        const oldInType = this.state.inType;
        this.state.inType = true;
        this.expect(14);
        let type = null;
        let predicate = null;
        if (this.match(54)) {
          this.state.inType = oldInType;
          predicate = this.flowParsePredicate();
        } else {
          type = this.flowParseType();
          this.state.inType = oldInType;
          if (this.match(54)) {
            predicate = this.flowParsePredicate();
          }
        }
        return [type, predicate];
      }
      flowParseDeclareClass(node) {
        this.next();
        this.flowParseInterfaceish(node, true);
        return this.finishNode(node, "DeclareClass");
      }
      flowParseDeclareFunction(node) {
        this.next();
        const id = node.id = this.parseIdentifier();
        const typeNode = this.startNode();
        const typeContainer = this.startNode();
        if (this.match(47)) {
          typeNode.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          typeNode.typeParameters = null;
        }
        this.expect(10);
        const tmp = this.flowParseFunctionTypeParams();
        typeNode.params = tmp.params;
        typeNode.rest = tmp.rest;
        typeNode.this = tmp._this;
        this.expect(11);
        [typeNode.returnType, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
        typeContainer.typeAnnotation = this.finishNode(typeNode, "FunctionTypeAnnotation");
        id.typeAnnotation = this.finishNode(typeContainer, "TypeAnnotation");
        this.resetEndLocation(id);
        this.semicolon();
        this.scope.declareName(node.id.name, 2048, node.id.loc.start);
        return this.finishNode(node, "DeclareFunction");
      }
      flowParseDeclare(node, insideModule) {
        if (this.match(80)) {
          return this.flowParseDeclareClass(node);
        } else if (this.match(68)) {
          return this.flowParseDeclareFunction(node);
        } else if (this.match(74)) {
          return this.flowParseDeclareVariable(node);
        } else if (this.eatContextual(127)) {
          if (this.match(16)) {
            return this.flowParseDeclareModuleExports(node);
          } else {
            if (insideModule) {
              this.raise(FlowErrors.NestedDeclareModule, this.state.lastTokStartLoc);
            }
            return this.flowParseDeclareModule(node);
          }
        } else if (this.isContextual(130)) {
          return this.flowParseDeclareTypeAlias(node);
        } else if (this.isContextual(131)) {
          return this.flowParseDeclareOpaqueType(node);
        } else if (this.isContextual(129)) {
          return this.flowParseDeclareInterface(node);
        } else if (this.match(82)) {
          return this.flowParseDeclareExportDeclaration(node, insideModule);
        } else {
          this.unexpected();
        }
      }
      flowParseDeclareVariable(node) {
        this.next();
        node.id = this.flowParseTypeAnnotatableIdentifier(true);
        this.scope.declareName(node.id.name, 5, node.id.loc.start);
        this.semicolon();
        return this.finishNode(node, "DeclareVariable");
      }
      flowParseDeclareModule(node) {
        this.scope.enter(0);
        if (this.match(134)) {
          node.id = super.parseExprAtom();
        } else {
          node.id = this.parseIdentifier();
        }
        const bodyNode = node.body = this.startNode();
        const body = bodyNode.body = [];
        this.expect(5);
        while (!this.match(8)) {
          let bodyNode2 = this.startNode();
          if (this.match(83)) {
            this.next();
            if (!this.isContextual(130) && !this.match(87)) {
              this.raise(FlowErrors.InvalidNonTypeImportInDeclareModule, this.state.lastTokStartLoc);
            }
            super.parseImport(bodyNode2);
          } else {
            this.expectContextual(125, FlowErrors.UnsupportedStatementInDeclareModule);
            bodyNode2 = this.flowParseDeclare(bodyNode2, true);
          }
          body.push(bodyNode2);
        }
        this.scope.exit();
        this.expect(8);
        this.finishNode(bodyNode, "BlockStatement");
        let kind = null;
        let hasModuleExport = false;
        body.forEach((bodyElement) => {
          if (isEsModuleType(bodyElement)) {
            if (kind === "CommonJS") {
              this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
            }
            kind = "ES";
          } else if (bodyElement.type === "DeclareModuleExports") {
            if (hasModuleExport) {
              this.raise(FlowErrors.DuplicateDeclareModuleExports, bodyElement);
            }
            if (kind === "ES") {
              this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
            }
            kind = "CommonJS";
            hasModuleExport = true;
          }
        });
        node.kind = kind || "CommonJS";
        return this.finishNode(node, "DeclareModule");
      }
      flowParseDeclareExportDeclaration(node, insideModule) {
        this.expect(82);
        if (this.eat(65)) {
          if (this.match(68) || this.match(80)) {
            node.declaration = this.flowParseDeclare(this.startNode());
          } else {
            node.declaration = this.flowParseType();
            this.semicolon();
          }
          node.default = true;
          return this.finishNode(node, "DeclareExportDeclaration");
        } else {
          if (this.match(75) || this.isLet() || (this.isContextual(130) || this.isContextual(129)) && !insideModule) {
            const label = this.state.value;
            throw this.raise(FlowErrors.UnsupportedDeclareExportKind, this.state.startLoc, {
              unsupportedExportKind: label,
              suggestion: exportSuggestions[label]
            });
          }
          if (this.match(74) || this.match(68) || this.match(80) || this.isContextual(131)) {
            node.declaration = this.flowParseDeclare(this.startNode());
            node.default = false;
            return this.finishNode(node, "DeclareExportDeclaration");
          } else if (this.match(55) || this.match(5) || this.isContextual(129) || this.isContextual(130) || this.isContextual(131)) {
            node = this.parseExport(node, null);
            if (node.type === "ExportNamedDeclaration") {
              node.type = "ExportDeclaration";
              node.default = false;
              delete node.exportKind;
            }
            node.type = "Declare" + node.type;
            return node;
          }
        }
        this.unexpected();
      }
      flowParseDeclareModuleExports(node) {
        this.next();
        this.expectContextual(111);
        node.typeAnnotation = this.flowParseTypeAnnotation();
        this.semicolon();
        return this.finishNode(node, "DeclareModuleExports");
      }
      flowParseDeclareTypeAlias(node) {
        this.next();
        const finished = this.flowParseTypeAlias(node);
        finished.type = "DeclareTypeAlias";
        return finished;
      }
      flowParseDeclareOpaqueType(node) {
        this.next();
        const finished = this.flowParseOpaqueType(node, true);
        finished.type = "DeclareOpaqueType";
        return finished;
      }
      flowParseDeclareInterface(node) {
        this.next();
        this.flowParseInterfaceish(node, false);
        return this.finishNode(node, "DeclareInterface");
      }
      flowParseInterfaceish(node, isClass) {
        node.id = this.flowParseRestrictedIdentifier(!isClass, true);
        this.scope.declareName(node.id.name, isClass ? 17 : 8201, node.id.loc.start);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.extends = [];
        if (this.eat(81)) {
          do {
            node.extends.push(this.flowParseInterfaceExtends());
          } while (!isClass && this.eat(12));
        }
        if (isClass) {
          node.implements = [];
          node.mixins = [];
          if (this.eatContextual(117)) {
            do {
              node.mixins.push(this.flowParseInterfaceExtends());
            } while (this.eat(12));
          }
          if (this.eatContextual(113)) {
            do {
              node.implements.push(this.flowParseInterfaceExtends());
            } while (this.eat(12));
          }
        }
        node.body = this.flowParseObjectType({
          allowStatic: isClass,
          allowExact: false,
          allowSpread: false,
          allowProto: isClass,
          allowInexact: false
        });
      }
      flowParseInterfaceExtends() {
        const node = this.startNode();
        node.id = this.flowParseQualifiedTypeIdentifier();
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterInstantiation();
        } else {
          node.typeParameters = null;
        }
        return this.finishNode(node, "InterfaceExtends");
      }
      flowParseInterface(node) {
        this.flowParseInterfaceish(node, false);
        return this.finishNode(node, "InterfaceDeclaration");
      }
      checkNotUnderscore(word) {
        if (word === "_") {
          this.raise(FlowErrors.UnexpectedReservedUnderscore, this.state.startLoc);
        }
      }
      checkReservedType(word, startLoc, declaration) {
        if (!reservedTypes.has(word)) return;
        this.raise(declaration ? FlowErrors.AssignReservedType : FlowErrors.UnexpectedReservedType, startLoc, {
          reservedType: word
        });
      }
      flowParseRestrictedIdentifier(liberal, declaration) {
        this.checkReservedType(this.state.value, this.state.startLoc, declaration);
        return this.parseIdentifier(liberal);
      }
      flowParseTypeAlias(node) {
        node.id = this.flowParseRestrictedIdentifier(false, true);
        this.scope.declareName(node.id.name, 8201, node.id.loc.start);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.right = this.flowParseTypeInitialiser(29);
        this.semicolon();
        return this.finishNode(node, "TypeAlias");
      }
      flowParseOpaqueType(node, declare) {
        this.expectContextual(130);
        node.id = this.flowParseRestrictedIdentifier(true, true);
        this.scope.declareName(node.id.name, 8201, node.id.loc.start);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.supertype = null;
        if (this.match(14)) {
          node.supertype = this.flowParseTypeInitialiser(14);
        }
        node.impltype = null;
        if (!declare) {
          node.impltype = this.flowParseTypeInitialiser(29);
        }
        this.semicolon();
        return this.finishNode(node, "OpaqueType");
      }
      flowParseTypeParameter(requireDefault = false) {
        const nodeStartLoc = this.state.startLoc;
        const node = this.startNode();
        const variance = this.flowParseVariance();
        const ident = this.flowParseTypeAnnotatableIdentifier();
        node.name = ident.name;
        node.variance = variance;
        node.bound = ident.typeAnnotation;
        if (this.match(29)) {
          this.eat(29);
          node.default = this.flowParseType();
        } else {
          if (requireDefault) {
            this.raise(FlowErrors.MissingTypeParamDefault, nodeStartLoc);
          }
        }
        return this.finishNode(node, "TypeParameter");
      }
      flowParseTypeParameterDeclaration() {
        const oldInType = this.state.inType;
        const node = this.startNode();
        node.params = [];
        this.state.inType = true;
        if (this.match(47) || this.match(143)) {
          this.next();
        } else {
          this.unexpected();
        }
        let defaultRequired = false;
        do {
          const typeParameter = this.flowParseTypeParameter(defaultRequired);
          node.params.push(typeParameter);
          if (typeParameter.default) {
            defaultRequired = true;
          }
          if (!this.match(48)) {
            this.expect(12);
          }
        } while (!this.match(48));
        this.expect(48);
        this.state.inType = oldInType;
        return this.finishNode(node, "TypeParameterDeclaration");
      }
      flowInTopLevelContext(cb) {
        if (this.curContext() !== types.brace) {
          const oldContext = this.state.context;
          this.state.context = [oldContext[0]];
          try {
            return cb();
          } finally {
            this.state.context = oldContext;
          }
        } else {
          return cb();
        }
      }
      flowParseTypeParameterInstantiationInExpression() {
        if (this.reScan_lt() !== 47) return;
        return this.flowParseTypeParameterInstantiation();
      }
      flowParseTypeParameterInstantiation() {
        const node = this.startNode();
        const oldInType = this.state.inType;
        this.state.inType = true;
        node.params = [];
        this.flowInTopLevelContext(() => {
          this.expect(47);
          const oldNoAnonFunctionType = this.state.noAnonFunctionType;
          this.state.noAnonFunctionType = false;
          while (!this.match(48)) {
            node.params.push(this.flowParseType());
            if (!this.match(48)) {
              this.expect(12);
            }
          }
          this.state.noAnonFunctionType = oldNoAnonFunctionType;
        });
        this.state.inType = oldInType;
        if (!this.state.inType && this.curContext() === types.brace) {
          this.reScan_lt_gt();
        }
        this.expect(48);
        return this.finishNode(node, "TypeParameterInstantiation");
      }
      flowParseTypeParameterInstantiationCallOrNew() {
        if (this.reScan_lt() !== 47) return;
        const node = this.startNode();
        const oldInType = this.state.inType;
        node.params = [];
        this.state.inType = true;
        this.expect(47);
        while (!this.match(48)) {
          node.params.push(this.flowParseTypeOrImplicitInstantiation());
          if (!this.match(48)) {
            this.expect(12);
          }
        }
        this.expect(48);
        this.state.inType = oldInType;
        return this.finishNode(node, "TypeParameterInstantiation");
      }
      flowParseInterfaceType() {
        const node = this.startNode();
        this.expectContextual(129);
        node.extends = [];
        if (this.eat(81)) {
          do {
            node.extends.push(this.flowParseInterfaceExtends());
          } while (this.eat(12));
        }
        node.body = this.flowParseObjectType({
          allowStatic: false,
          allowExact: false,
          allowSpread: false,
          allowProto: false,
          allowInexact: false
        });
        return this.finishNode(node, "InterfaceTypeAnnotation");
      }
      flowParseObjectPropertyKey() {
        return this.match(135) || this.match(134) ? super.parseExprAtom() : this.parseIdentifier(true);
      }
      flowParseObjectTypeIndexer(node, isStatic, variance) {
        node.static = isStatic;
        if (this.lookahead().type === 14) {
          node.id = this.flowParseObjectPropertyKey();
          node.key = this.flowParseTypeInitialiser();
        } else {
          node.id = null;
          node.key = this.flowParseType();
        }
        this.expect(3);
        node.value = this.flowParseTypeInitialiser();
        node.variance = variance;
        return this.finishNode(node, "ObjectTypeIndexer");
      }
      flowParseObjectTypeInternalSlot(node, isStatic) {
        node.static = isStatic;
        node.id = this.flowParseObjectPropertyKey();
        this.expect(3);
        this.expect(3);
        if (this.match(47) || this.match(10)) {
          node.method = true;
          node.optional = false;
          node.value = this.flowParseObjectTypeMethodish(this.startNodeAt(node.loc.start));
        } else {
          node.method = false;
          if (this.eat(17)) {
            node.optional = true;
          }
          node.value = this.flowParseTypeInitialiser();
        }
        return this.finishNode(node, "ObjectTypeInternalSlot");
      }
      flowParseObjectTypeMethodish(node) {
        node.params = [];
        node.rest = null;
        node.typeParameters = null;
        node.this = null;
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        this.expect(10);
        if (this.match(78)) {
          node.this = this.flowParseFunctionTypeParam(true);
          node.this.name = null;
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        while (!this.match(11) && !this.match(21)) {
          node.params.push(this.flowParseFunctionTypeParam(false));
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        if (this.eat(21)) {
          node.rest = this.flowParseFunctionTypeParam(false);
        }
        this.expect(11);
        node.returnType = this.flowParseTypeInitialiser();
        return this.finishNode(node, "FunctionTypeAnnotation");
      }
      flowParseObjectTypeCallProperty(node, isStatic) {
        const valueNode = this.startNode();
        node.static = isStatic;
        node.value = this.flowParseObjectTypeMethodish(valueNode);
        return this.finishNode(node, "ObjectTypeCallProperty");
      }
      flowParseObjectType({
        allowStatic,
        allowExact,
        allowSpread,
        allowProto,
        allowInexact
      }) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        const nodeStart = this.startNode();
        nodeStart.callProperties = [];
        nodeStart.properties = [];
        nodeStart.indexers = [];
        nodeStart.internalSlots = [];
        let endDelim;
        let exact;
        let inexact = false;
        if (allowExact && this.match(6)) {
          this.expect(6);
          endDelim = 9;
          exact = true;
        } else {
          this.expect(5);
          endDelim = 8;
          exact = false;
        }
        nodeStart.exact = exact;
        while (!this.match(endDelim)) {
          let isStatic = false;
          let protoStartLoc = null;
          let inexactStartLoc = null;
          const node = this.startNode();
          if (allowProto && this.isContextual(118)) {
            const lookahead = this.lookahead();
            if (lookahead.type !== 14 && lookahead.type !== 17) {
              this.next();
              protoStartLoc = this.state.startLoc;
              allowStatic = false;
            }
          }
          if (allowStatic && this.isContextual(106)) {
            const lookahead = this.lookahead();
            if (lookahead.type !== 14 && lookahead.type !== 17) {
              this.next();
              isStatic = true;
            }
          }
          const variance = this.flowParseVariance();
          if (this.eat(0)) {
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (this.eat(0)) {
              if (variance) {
                this.unexpected(variance.loc.start);
              }
              nodeStart.internalSlots.push(this.flowParseObjectTypeInternalSlot(node, isStatic));
            } else {
              nodeStart.indexers.push(this.flowParseObjectTypeIndexer(node, isStatic, variance));
            }
          } else if (this.match(10) || this.match(47)) {
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (variance) {
              this.unexpected(variance.loc.start);
            }
            nodeStart.callProperties.push(this.flowParseObjectTypeCallProperty(node, isStatic));
          } else {
            let kind = "init";
            if (this.isContextual(99) || this.isContextual(104)) {
              const lookahead = this.lookahead();
              if (tokenIsLiteralPropertyName(lookahead.type)) {
                kind = this.state.value;
                this.next();
              }
            }
            const propOrInexact = this.flowParseObjectTypeProperty(node, isStatic, protoStartLoc, variance, kind, allowSpread, allowInexact != null ? allowInexact : !exact);
            if (propOrInexact === null) {
              inexact = true;
              inexactStartLoc = this.state.lastTokStartLoc;
            } else {
              nodeStart.properties.push(propOrInexact);
            }
          }
          this.flowObjectTypeSemicolon();
          if (inexactStartLoc && !this.match(8) && !this.match(9)) {
            this.raise(FlowErrors.UnexpectedExplicitInexactInObject, inexactStartLoc);
          }
        }
        this.expect(endDelim);
        if (allowSpread) {
          nodeStart.inexact = inexact;
        }
        const out = this.finishNode(nodeStart, "ObjectTypeAnnotation");
        this.state.inType = oldInType;
        return out;
      }
      flowParseObjectTypeProperty(node, isStatic, protoStartLoc, variance, kind, allowSpread, allowInexact) {
        if (this.eat(21)) {
          const isInexactToken = this.match(12) || this.match(13) || this.match(8) || this.match(9);
          if (isInexactToken) {
            if (!allowSpread) {
              this.raise(FlowErrors.InexactInsideNonObject, this.state.lastTokStartLoc);
            } else if (!allowInexact) {
              this.raise(FlowErrors.InexactInsideExact, this.state.lastTokStartLoc);
            }
            if (variance) {
              this.raise(FlowErrors.InexactVariance, variance);
            }
            return null;
          }
          if (!allowSpread) {
            this.raise(FlowErrors.UnexpectedSpreadType, this.state.lastTokStartLoc);
          }
          if (protoStartLoc != null) {
            this.unexpected(protoStartLoc);
          }
          if (variance) {
            this.raise(FlowErrors.SpreadVariance, variance);
          }
          node.argument = this.flowParseType();
          return this.finishNode(node, "ObjectTypeSpreadProperty");
        } else {
          node.key = this.flowParseObjectPropertyKey();
          node.static = isStatic;
          node.proto = protoStartLoc != null;
          node.kind = kind;
          let optional2 = false;
          if (this.match(47) || this.match(10)) {
            node.method = true;
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (variance) {
              this.unexpected(variance.loc.start);
            }
            node.value = this.flowParseObjectTypeMethodish(this.startNodeAt(node.loc.start));
            if (kind === "get" || kind === "set") {
              this.flowCheckGetterSetterParams(node);
            }
            if (!allowSpread && node.key.name === "constructor" && node.value.this) {
              this.raise(FlowErrors.ThisParamBannedInConstructor, node.value.this);
            }
          } else {
            if (kind !== "init") this.unexpected();
            node.method = false;
            if (this.eat(17)) {
              optional2 = true;
            }
            node.value = this.flowParseTypeInitialiser();
            node.variance = variance;
          }
          node.optional = optional2;
          return this.finishNode(node, "ObjectTypeProperty");
        }
      }
      flowCheckGetterSetterParams(property) {
        const paramCount = property.kind === "get" ? 0 : 1;
        const length = property.value.params.length + (property.value.rest ? 1 : 0);
        if (property.value.this) {
          this.raise(property.kind === "get" ? FlowErrors.GetterMayNotHaveThisParam : FlowErrors.SetterMayNotHaveThisParam, property.value.this);
        }
        if (length !== paramCount) {
          this.raise(property.kind === "get" ? Errors.BadGetterArity : Errors.BadSetterArity, property);
        }
        if (property.kind === "set" && property.value.rest) {
          this.raise(Errors.BadSetterRestParameter, property);
        }
      }
      flowObjectTypeSemicolon() {
        if (!this.eat(13) && !this.eat(12) && !this.match(8) && !this.match(9)) {
          this.unexpected();
        }
      }
      flowParseQualifiedTypeIdentifier(startLoc, id) {
        startLoc != null ? startLoc : startLoc = this.state.startLoc;
        let node = id || this.flowParseRestrictedIdentifier(true);
        while (this.eat(16)) {
          const node2 = this.startNodeAt(startLoc);
          node2.qualification = node;
          node2.id = this.flowParseRestrictedIdentifier(true);
          node = this.finishNode(node2, "QualifiedTypeIdentifier");
        }
        return node;
      }
      flowParseGenericType(startLoc, id) {
        const node = this.startNodeAt(startLoc);
        node.typeParameters = null;
        node.id = this.flowParseQualifiedTypeIdentifier(startLoc, id);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterInstantiation();
        }
        return this.finishNode(node, "GenericTypeAnnotation");
      }
      flowParseTypeofType() {
        const node = this.startNode();
        this.expect(87);
        node.argument = this.flowParsePrimaryType();
        return this.finishNode(node, "TypeofTypeAnnotation");
      }
      flowParseTupleType() {
        const node = this.startNode();
        node.types = [];
        this.expect(0);
        while (this.state.pos < this.length && !this.match(3)) {
          node.types.push(this.flowParseType());
          if (this.match(3)) break;
          this.expect(12);
        }
        this.expect(3);
        return this.finishNode(node, "TupleTypeAnnotation");
      }
      flowParseFunctionTypeParam(first) {
        let name = null;
        let optional2 = false;
        let typeAnnotation2 = null;
        const node = this.startNode();
        const lh = this.lookahead();
        const isThis = this.state.type === 78;
        if (lh.type === 14 || lh.type === 17) {
          if (isThis && !first) {
            this.raise(FlowErrors.ThisParamMustBeFirst, node);
          }
          name = this.parseIdentifier(isThis);
          if (this.eat(17)) {
            optional2 = true;
            if (isThis) {
              this.raise(FlowErrors.ThisParamMayNotBeOptional, node);
            }
          }
          typeAnnotation2 = this.flowParseTypeInitialiser();
        } else {
          typeAnnotation2 = this.flowParseType();
        }
        node.name = name;
        node.optional = optional2;
        node.typeAnnotation = typeAnnotation2;
        return this.finishNode(node, "FunctionTypeParam");
      }
      reinterpretTypeAsFunctionTypeParam(type) {
        const node = this.startNodeAt(type.loc.start);
        node.name = null;
        node.optional = false;
        node.typeAnnotation = type;
        return this.finishNode(node, "FunctionTypeParam");
      }
      flowParseFunctionTypeParams(params = []) {
        let rest = null;
        let _this = null;
        if (this.match(78)) {
          _this = this.flowParseFunctionTypeParam(true);
          _this.name = null;
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        while (!this.match(11) && !this.match(21)) {
          params.push(this.flowParseFunctionTypeParam(false));
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        if (this.eat(21)) {
          rest = this.flowParseFunctionTypeParam(false);
        }
        return {
          params,
          rest,
          _this
        };
      }
      flowIdentToTypeAnnotation(startLoc, node, id) {
        switch (id.name) {
          case "any":
            return this.finishNode(node, "AnyTypeAnnotation");
          case "bool":
          case "boolean":
            return this.finishNode(node, "BooleanTypeAnnotation");
          case "mixed":
            return this.finishNode(node, "MixedTypeAnnotation");
          case "empty":
            return this.finishNode(node, "EmptyTypeAnnotation");
          case "number":
            return this.finishNode(node, "NumberTypeAnnotation");
          case "string":
            return this.finishNode(node, "StringTypeAnnotation");
          case "symbol":
            return this.finishNode(node, "SymbolTypeAnnotation");
          default:
            this.checkNotUnderscore(id.name);
            return this.flowParseGenericType(startLoc, id);
        }
      }
      flowParsePrimaryType() {
        const startLoc = this.state.startLoc;
        const node = this.startNode();
        let tmp;
        let type;
        let isGroupedType = false;
        const oldNoAnonFunctionType = this.state.noAnonFunctionType;
        switch (this.state.type) {
          case 5:
            return this.flowParseObjectType({
              allowStatic: false,
              allowExact: false,
              allowSpread: true,
              allowProto: false,
              allowInexact: true
            });
          case 6:
            return this.flowParseObjectType({
              allowStatic: false,
              allowExact: true,
              allowSpread: true,
              allowProto: false,
              allowInexact: false
            });
          case 0:
            this.state.noAnonFunctionType = false;
            type = this.flowParseTupleType();
            this.state.noAnonFunctionType = oldNoAnonFunctionType;
            return type;
          case 47: {
            const node2 = this.startNode();
            node2.typeParameters = this.flowParseTypeParameterDeclaration();
            this.expect(10);
            tmp = this.flowParseFunctionTypeParams();
            node2.params = tmp.params;
            node2.rest = tmp.rest;
            node2.this = tmp._this;
            this.expect(11);
            this.expect(19);
            node2.returnType = this.flowParseType();
            return this.finishNode(node2, "FunctionTypeAnnotation");
          }
          case 10: {
            const node2 = this.startNode();
            this.next();
            if (!this.match(11) && !this.match(21)) {
              if (tokenIsIdentifier(this.state.type) || this.match(78)) {
                const token2 = this.lookahead().type;
                isGroupedType = token2 !== 17 && token2 !== 14;
              } else {
                isGroupedType = true;
              }
            }
            if (isGroupedType) {
              this.state.noAnonFunctionType = false;
              type = this.flowParseType();
              this.state.noAnonFunctionType = oldNoAnonFunctionType;
              if (this.state.noAnonFunctionType || !(this.match(12) || this.match(11) && this.lookahead().type === 19)) {
                this.expect(11);
                return type;
              } else {
                this.eat(12);
              }
            }
            if (type) {
              tmp = this.flowParseFunctionTypeParams([this.reinterpretTypeAsFunctionTypeParam(type)]);
            } else {
              tmp = this.flowParseFunctionTypeParams();
            }
            node2.params = tmp.params;
            node2.rest = tmp.rest;
            node2.this = tmp._this;
            this.expect(11);
            this.expect(19);
            node2.returnType = this.flowParseType();
            node2.typeParameters = null;
            return this.finishNode(node2, "FunctionTypeAnnotation");
          }
          case 134:
            return this.parseLiteral(this.state.value, "StringLiteralTypeAnnotation");
          case 85:
          case 86:
            node.value = this.match(85);
            this.next();
            return this.finishNode(node, "BooleanLiteralTypeAnnotation");
          case 53:
            if (this.state.value === "-") {
              this.next();
              if (this.match(135)) {
                return this.parseLiteralAtNode(-this.state.value, "NumberLiteralTypeAnnotation", node);
              }
              if (this.match(136)) {
                return this.parseLiteralAtNode(-this.state.value, "BigIntLiteralTypeAnnotation", node);
              }
              throw this.raise(FlowErrors.UnexpectedSubtractionOperand, this.state.startLoc);
            }
            this.unexpected();
            return;
          case 135:
            return this.parseLiteral(this.state.value, "NumberLiteralTypeAnnotation");
          case 136:
            return this.parseLiteral(this.state.value, "BigIntLiteralTypeAnnotation");
          case 88:
            this.next();
            return this.finishNode(node, "VoidTypeAnnotation");
          case 84:
            this.next();
            return this.finishNode(node, "NullLiteralTypeAnnotation");
          case 78:
            this.next();
            return this.finishNode(node, "ThisTypeAnnotation");
          case 55:
            this.next();
            return this.finishNode(node, "ExistsTypeAnnotation");
          case 87:
            return this.flowParseTypeofType();
          default:
            if (tokenIsKeyword(this.state.type)) {
              const label = tokenLabelName(this.state.type);
              this.next();
              return super.createIdentifier(node, label);
            } else if (tokenIsIdentifier(this.state.type)) {
              if (this.isContextual(129)) {
                return this.flowParseInterfaceType();
              }
              return this.flowIdentToTypeAnnotation(startLoc, node, this.parseIdentifier());
            }
        }
        this.unexpected();
      }
      flowParsePostfixType() {
        const startLoc = this.state.startLoc;
        let type = this.flowParsePrimaryType();
        let seenOptionalIndexedAccess = false;
        while ((this.match(0) || this.match(18)) && !this.canInsertSemicolon()) {
          const node = this.startNodeAt(startLoc);
          const optional2 = this.eat(18);
          seenOptionalIndexedAccess = seenOptionalIndexedAccess || optional2;
          this.expect(0);
          if (!optional2 && this.match(3)) {
            node.elementType = type;
            this.next();
            type = this.finishNode(node, "ArrayTypeAnnotation");
          } else {
            node.objectType = type;
            node.indexType = this.flowParseType();
            this.expect(3);
            if (seenOptionalIndexedAccess) {
              node.optional = optional2;
              type = this.finishNode(node, "OptionalIndexedAccessType");
            } else {
              type = this.finishNode(node, "IndexedAccessType");
            }
          }
        }
        return type;
      }
      flowParsePrefixType() {
        const node = this.startNode();
        if (this.eat(17)) {
          node.typeAnnotation = this.flowParsePrefixType();
          return this.finishNode(node, "NullableTypeAnnotation");
        } else {
          return this.flowParsePostfixType();
        }
      }
      flowParseAnonFunctionWithoutParens() {
        const param = this.flowParsePrefixType();
        if (!this.state.noAnonFunctionType && this.eat(19)) {
          const node = this.startNodeAt(param.loc.start);
          node.params = [this.reinterpretTypeAsFunctionTypeParam(param)];
          node.rest = null;
          node.this = null;
          node.returnType = this.flowParseType();
          node.typeParameters = null;
          return this.finishNode(node, "FunctionTypeAnnotation");
        }
        return param;
      }
      flowParseIntersectionType() {
        const node = this.startNode();
        this.eat(45);
        const type = this.flowParseAnonFunctionWithoutParens();
        node.types = [type];
        while (this.eat(45)) {
          node.types.push(this.flowParseAnonFunctionWithoutParens());
        }
        return node.types.length === 1 ? type : this.finishNode(node, "IntersectionTypeAnnotation");
      }
      flowParseUnionType() {
        const node = this.startNode();
        this.eat(43);
        const type = this.flowParseIntersectionType();
        node.types = [type];
        while (this.eat(43)) {
          node.types.push(this.flowParseIntersectionType());
        }
        return node.types.length === 1 ? type : this.finishNode(node, "UnionTypeAnnotation");
      }
      flowParseType() {
        const oldInType = this.state.inType;
        this.state.inType = true;
        const type = this.flowParseUnionType();
        this.state.inType = oldInType;
        return type;
      }
      flowParseTypeOrImplicitInstantiation() {
        if (this.state.type === 132 && this.state.value === "_") {
          const startLoc = this.state.startLoc;
          const node = this.parseIdentifier();
          return this.flowParseGenericType(startLoc, node);
        } else {
          return this.flowParseType();
        }
      }
      flowParseTypeAnnotation() {
        const node = this.startNode();
        node.typeAnnotation = this.flowParseTypeInitialiser();
        return this.finishNode(node, "TypeAnnotation");
      }
      flowParseTypeAnnotatableIdentifier(allowPrimitiveOverride) {
        const ident = allowPrimitiveOverride ? this.parseIdentifier() : this.flowParseRestrictedIdentifier();
        if (this.match(14)) {
          ident.typeAnnotation = this.flowParseTypeAnnotation();
          this.resetEndLocation(ident);
        }
        return ident;
      }
      typeCastToParameter(node) {
        node.expression.typeAnnotation = node.typeAnnotation;
        this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
        return node.expression;
      }
      flowParseVariance() {
        let variance = null;
        if (this.match(53)) {
          variance = this.startNode();
          if (this.state.value === "+") {
            variance.kind = "plus";
          } else {
            variance.kind = "minus";
          }
          this.next();
          return this.finishNode(variance, "Variance");
        }
        return variance;
      }
      parseFunctionBody(node, allowExpressionBody, isMethod = false) {
        if (allowExpressionBody) {
          this.forwardNoArrowParamsConversionAt(node, () => super.parseFunctionBody(node, true, isMethod));
          return;
        }
        super.parseFunctionBody(node, false, isMethod);
      }
      parseFunctionBodyAndFinish(node, type, isMethod = false) {
        if (this.match(14)) {
          const typeNode = this.startNode();
          [typeNode.typeAnnotation, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
          node.returnType = typeNode.typeAnnotation ? this.finishNode(typeNode, "TypeAnnotation") : null;
        }
        return super.parseFunctionBodyAndFinish(node, type, isMethod);
      }
      parseStatementLike(flags) {
        if (this.state.strict && this.isContextual(129)) {
          const lookahead = this.lookahead();
          if (tokenIsKeywordOrIdentifier(lookahead.type)) {
            const node = this.startNode();
            this.next();
            return this.flowParseInterface(node);
          }
        } else if (this.isContextual(126)) {
          const node = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(node);
        }
        const stmt = super.parseStatementLike(flags);
        if (this.flowPragma === void 0 && !this.isValidDirective(stmt)) {
          this.flowPragma = null;
        }
        return stmt;
      }
      parseExpressionStatement(node, expr, decorators) {
        if (expr.type === "Identifier") {
          if (expr.name === "declare") {
            if (this.match(80) || tokenIsIdentifier(this.state.type) || this.match(68) || this.match(74) || this.match(82)) {
              return this.flowParseDeclare(node);
            }
          } else if (tokenIsIdentifier(this.state.type)) {
            if (expr.name === "interface") {
              return this.flowParseInterface(node);
            } else if (expr.name === "type") {
              return this.flowParseTypeAlias(node);
            } else if (expr.name === "opaque") {
              return this.flowParseOpaqueType(node, false);
            }
          }
        }
        return super.parseExpressionStatement(node, expr, decorators);
      }
      shouldParseExportDeclaration() {
        const {
          type
        } = this.state;
        if (type === 126 || tokenIsFlowInterfaceOrTypeOrOpaque(type)) {
          return !this.state.containsEsc;
        }
        return super.shouldParseExportDeclaration();
      }
      isExportDefaultSpecifier() {
        const {
          type
        } = this.state;
        if (type === 126 || tokenIsFlowInterfaceOrTypeOrOpaque(type)) {
          return this.state.containsEsc;
        }
        return super.isExportDefaultSpecifier();
      }
      parseExportDefaultExpression() {
        if (this.isContextual(126)) {
          const node = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(node);
        }
        return super.parseExportDefaultExpression();
      }
      parseConditional(expr, startLoc, refExpressionErrors) {
        if (!this.match(17)) return expr;
        if (this.state.maybeInArrowParameters) {
          const nextCh = this.lookaheadCharCode();
          if (nextCh === 44 || nextCh === 61 || nextCh === 58 || nextCh === 41) {
            this.setOptionalParametersError(refExpressionErrors);
            return expr;
          }
        }
        this.expect(17);
        const state = this.state.clone();
        const originalNoArrowAt = this.state.noArrowAt;
        const node = this.startNodeAt(startLoc);
        let {
          consequent,
          failed
        } = this.tryParseConditionalConsequent();
        let [valid, invalid] = this.getArrowLikeExpressions(consequent);
        if (failed || invalid.length > 0) {
          const noArrowAt = [...originalNoArrowAt];
          if (invalid.length > 0) {
            this.state = state;
            this.state.noArrowAt = noArrowAt;
            for (let i = 0; i < invalid.length; i++) {
              noArrowAt.push(invalid[i].start);
            }
            ({
              consequent,
              failed
            } = this.tryParseConditionalConsequent());
            [valid, invalid] = this.getArrowLikeExpressions(consequent);
          }
          if (failed && valid.length > 1) {
            this.raise(FlowErrors.AmbiguousConditionalArrow, state.startLoc);
          }
          if (failed && valid.length === 1) {
            this.state = state;
            noArrowAt.push(valid[0].start);
            this.state.noArrowAt = noArrowAt;
            ({
              consequent,
              failed
            } = this.tryParseConditionalConsequent());
          }
        }
        this.getArrowLikeExpressions(consequent, true);
        this.state.noArrowAt = originalNoArrowAt;
        this.expect(14);
        node.test = expr;
        node.consequent = consequent;
        node.alternate = this.forwardNoArrowParamsConversionAt(node, () => this.parseMaybeAssign(void 0, void 0));
        return this.finishNode(node, "ConditionalExpression");
      }
      tryParseConditionalConsequent() {
        this.state.noArrowParamsConversionAt.push(this.state.start);
        const consequent = this.parseMaybeAssignAllowIn();
        const failed = !this.match(14);
        this.state.noArrowParamsConversionAt.pop();
        return {
          consequent,
          failed
        };
      }
      getArrowLikeExpressions(node, disallowInvalid) {
        const stack2 = [node];
        const arrows = [];
        while (stack2.length !== 0) {
          const node2 = stack2.pop();
          if (node2.type === "ArrowFunctionExpression" && node2.body.type !== "BlockStatement") {
            if (node2.typeParameters || !node2.returnType) {
              this.finishArrowValidation(node2);
            } else {
              arrows.push(node2);
            }
            stack2.push(node2.body);
          } else if (node2.type === "ConditionalExpression") {
            stack2.push(node2.consequent);
            stack2.push(node2.alternate);
          }
        }
        if (disallowInvalid) {
          arrows.forEach((node2) => this.finishArrowValidation(node2));
          return [arrows, []];
        }
        return partition(arrows, (node2) => node2.params.every((param) => this.isAssignable(param, true)));
      }
      finishArrowValidation(node) {
        var _node$extra;
        this.toAssignableList(node.params, (_node$extra = node.extra) == null ? void 0 : _node$extra.trailingCommaLoc, false);
        this.scope.enter(2 | 4);
        super.checkParams(node, false, true);
        this.scope.exit();
      }
      forwardNoArrowParamsConversionAt(node, parse7) {
        let result;
        if (this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) {
          this.state.noArrowParamsConversionAt.push(this.state.start);
          result = parse7();
          this.state.noArrowParamsConversionAt.pop();
        } else {
          result = parse7();
        }
        return result;
      }
      parseParenItem(node, startLoc) {
        const newNode = super.parseParenItem(node, startLoc);
        if (this.eat(17)) {
          newNode.optional = true;
          this.resetEndLocation(node);
        }
        if (this.match(14)) {
          const typeCastNode = this.startNodeAt(startLoc);
          typeCastNode.expression = newNode;
          typeCastNode.typeAnnotation = this.flowParseTypeAnnotation();
          return this.finishNode(typeCastNode, "TypeCastExpression");
        }
        return newNode;
      }
      assertModuleNodeAllowed(node) {
        if (node.type === "ImportDeclaration" && (node.importKind === "type" || node.importKind === "typeof") || node.type === "ExportNamedDeclaration" && node.exportKind === "type" || node.type === "ExportAllDeclaration" && node.exportKind === "type") {
          return;
        }
        super.assertModuleNodeAllowed(node);
      }
      parseExportDeclaration(node) {
        if (this.isContextual(130)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          if (this.match(5)) {
            node.specifiers = this.parseExportSpecifiers(true);
            super.parseExportFrom(node);
            return null;
          } else {
            return this.flowParseTypeAlias(declarationNode);
          }
        } else if (this.isContextual(131)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseOpaqueType(declarationNode, false);
        } else if (this.isContextual(129)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseInterface(declarationNode);
        } else if (this.isContextual(126)) {
          node.exportKind = "value";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(declarationNode);
        } else {
          return super.parseExportDeclaration(node);
        }
      }
      eatExportStar(node) {
        if (super.eatExportStar(node)) return true;
        if (this.isContextual(130) && this.lookahead().type === 55) {
          node.exportKind = "type";
          this.next();
          this.next();
          return true;
        }
        return false;
      }
      maybeParseExportNamespaceSpecifier(node) {
        const {
          startLoc
        } = this.state;
        const hasNamespace = super.maybeParseExportNamespaceSpecifier(node);
        if (hasNamespace && node.exportKind === "type") {
          this.unexpected(startLoc);
        }
        return hasNamespace;
      }
      parseClassId(node, isStatement2, optionalId) {
        super.parseClassId(node, isStatement2, optionalId);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
      }
      parseClassMember(classBody, member, state) {
        const {
          startLoc
        } = this.state;
        if (this.isContextual(125)) {
          if (super.parseClassMemberFromModifier(classBody, member)) {
            return;
          }
          member.declare = true;
        }
        super.parseClassMember(classBody, member, state);
        if (member.declare) {
          if (member.type !== "ClassProperty" && member.type !== "ClassPrivateProperty" && member.type !== "PropertyDefinition") {
            this.raise(FlowErrors.DeclareClassElement, startLoc);
          } else if (member.value) {
            this.raise(FlowErrors.DeclareClassFieldInitializer, member.value);
          }
        }
      }
      isIterator(word) {
        return word === "iterator" || word === "asyncIterator";
      }
      readIterator() {
        const word = super.readWord1();
        const fullWord = "@@" + word;
        if (!this.isIterator(word) || !this.state.inType) {
          this.raise(Errors.InvalidIdentifier, this.state.curPosition(), {
            identifierName: fullWord
          });
        }
        this.finishToken(132, fullWord);
      }
      getTokenFromCode(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code2 === 123 && next === 124) {
          this.finishOp(6, 2);
        } else if (this.state.inType && (code2 === 62 || code2 === 60)) {
          this.finishOp(code2 === 62 ? 48 : 47, 1);
        } else if (this.state.inType && code2 === 63) {
          if (next === 46) {
            this.finishOp(18, 2);
          } else {
            this.finishOp(17, 1);
          }
        } else if (isIteratorStart(code2, next, this.input.charCodeAt(this.state.pos + 2))) {
          this.state.pos += 2;
          this.readIterator();
        } else {
          super.getTokenFromCode(code2);
        }
      }
      isAssignable(node, isBinding) {
        if (node.type === "TypeCastExpression") {
          return this.isAssignable(node.expression, isBinding);
        } else {
          return super.isAssignable(node, isBinding);
        }
      }
      toAssignable(node, isLHS = false) {
        if (!isLHS && node.type === "AssignmentExpression" && node.left.type === "TypeCastExpression") {
          node.left = this.typeCastToParameter(node.left);
        }
        super.toAssignable(node, isLHS);
      }
      toAssignableList(exprList, trailingCommaLoc, isLHS) {
        for (let i = 0; i < exprList.length; i++) {
          const expr = exprList[i];
          if ((expr == null ? void 0 : expr.type) === "TypeCastExpression") {
            exprList[i] = this.typeCastToParameter(expr);
          }
        }
        super.toAssignableList(exprList, trailingCommaLoc, isLHS);
      }
      toReferencedList(exprList, isParenthesizedExpr) {
        for (let i = 0; i < exprList.length; i++) {
          var _expr$extra;
          const expr = exprList[i];
          if (expr && expr.type === "TypeCastExpression" && !((_expr$extra = expr.extra) != null && _expr$extra.parenthesized) && (exprList.length > 1 || !isParenthesizedExpr)) {
            this.raise(FlowErrors.TypeCastInPattern, expr.typeAnnotation);
          }
        }
        return exprList;
      }
      parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
        const node = super.parseArrayLike(close, canBePattern, isTuple, refExpressionErrors);
        if (canBePattern && !this.state.maybeInArrowParameters) {
          this.toReferencedList(node.elements);
        }
        return node;
      }
      isValidLVal(type, isParenthesized, binding) {
        return type === "TypeCastExpression" || super.isValidLVal(type, isParenthesized, binding);
      }
      parseClassProperty(node) {
        if (this.match(14)) {
          node.typeAnnotation = this.flowParseTypeAnnotation();
        }
        return super.parseClassProperty(node);
      }
      parseClassPrivateProperty(node) {
        if (this.match(14)) {
          node.typeAnnotation = this.flowParseTypeAnnotation();
        }
        return super.parseClassPrivateProperty(node);
      }
      isClassMethod() {
        return this.match(47) || super.isClassMethod();
      }
      isClassProperty() {
        return this.match(14) || super.isClassProperty();
      }
      isNonstaticConstructor(method) {
        return !this.match(14) && super.isNonstaticConstructor(method);
      }
      pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
        if (method.variance) {
          this.unexpected(method.variance.loc.start);
        }
        delete method.variance;
        if (this.match(47)) {
          method.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper);
        if (method.params && isConstructor) {
          const params = method.params;
          if (params.length > 0 && this.isThisParam(params[0])) {
            this.raise(FlowErrors.ThisParamBannedInConstructor, method);
          }
        } else if (method.type === "MethodDefinition" && isConstructor && method.value.params) {
          const params = method.value.params;
          if (params.length > 0 && this.isThisParam(params[0])) {
            this.raise(FlowErrors.ThisParamBannedInConstructor, method);
          }
        }
      }
      pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
        if (method.variance) {
          this.unexpected(method.variance.loc.start);
        }
        delete method.variance;
        if (this.match(47)) {
          method.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
      }
      parseClassSuper(node) {
        super.parseClassSuper(node);
        if (node.superClass && (this.match(47) || this.match(51))) {
          {
            node.superTypeParameters = this.flowParseTypeParameterInstantiationInExpression();
          }
        }
        if (this.isContextual(113)) {
          this.next();
          const implemented = node.implements = [];
          do {
            const node2 = this.startNode();
            node2.id = this.flowParseRestrictedIdentifier(true);
            if (this.match(47)) {
              node2.typeParameters = this.flowParseTypeParameterInstantiation();
            } else {
              node2.typeParameters = null;
            }
            implemented.push(this.finishNode(node2, "ClassImplements"));
          } while (this.eat(12));
        }
      }
      checkGetterSetterParams(method) {
        super.checkGetterSetterParams(method);
        const params = this.getObjectOrClassMethodParams(method);
        if (params.length > 0) {
          const param = params[0];
          if (this.isThisParam(param) && method.kind === "get") {
            this.raise(FlowErrors.GetterMayNotHaveThisParam, param);
          } else if (this.isThisParam(param)) {
            this.raise(FlowErrors.SetterMayNotHaveThisParam, param);
          }
        }
      }
      parsePropertyNamePrefixOperator(node) {
        node.variance = this.flowParseVariance();
      }
      parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
        if (prop.variance) {
          this.unexpected(prop.variance.loc.start);
        }
        delete prop.variance;
        let typeParameters;
        if (this.match(47) && !isAccessor) {
          typeParameters = this.flowParseTypeParameterDeclaration();
          if (!this.match(10)) this.unexpected();
        }
        const result = super.parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors);
        if (typeParameters) {
          (result.value || result).typeParameters = typeParameters;
        }
        return result;
      }
      parseFunctionParamType(param) {
        if (this.eat(17)) {
          if (param.type !== "Identifier") {
            this.raise(FlowErrors.PatternIsOptional, param);
          }
          if (this.isThisParam(param)) {
            this.raise(FlowErrors.ThisParamMayNotBeOptional, param);
          }
          param.optional = true;
        }
        if (this.match(14)) {
          param.typeAnnotation = this.flowParseTypeAnnotation();
        } else if (this.isThisParam(param)) {
          this.raise(FlowErrors.ThisParamAnnotationRequired, param);
        }
        if (this.match(29) && this.isThisParam(param)) {
          this.raise(FlowErrors.ThisParamNoDefault, param);
        }
        this.resetEndLocation(param);
        return param;
      }
      parseMaybeDefault(startLoc, left) {
        const node = super.parseMaybeDefault(startLoc, left);
        if (node.type === "AssignmentPattern" && node.typeAnnotation && node.right.start < node.typeAnnotation.start) {
          this.raise(FlowErrors.TypeBeforeInitializer, node.typeAnnotation);
        }
        return node;
      }
      checkImportReflection(node) {
        super.checkImportReflection(node);
        if (node.module && node.importKind !== "value") {
          this.raise(FlowErrors.ImportReflectionHasImportType, node.specifiers[0].loc.start);
        }
      }
      parseImportSpecifierLocal(node, specifier, type) {
        specifier.local = hasTypeImportKind(node) ? this.flowParseRestrictedIdentifier(true, true) : this.parseIdentifier();
        node.specifiers.push(this.finishImportSpecifier(specifier, type));
      }
      isPotentialImportPhase(isExport) {
        if (super.isPotentialImportPhase(isExport)) return true;
        if (this.isContextual(130)) {
          if (!isExport) return true;
          const ch = this.lookaheadCharCode();
          return ch === 123 || ch === 42;
        }
        return !isExport && this.isContextual(87);
      }
      applyImportPhase(node, isExport, phase, loc) {
        super.applyImportPhase(node, isExport, phase, loc);
        if (isExport) {
          if (!phase && this.match(65)) {
            return;
          }
          node.exportKind = phase === "type" ? phase : "value";
        } else {
          if (phase === "type" && this.match(55)) this.unexpected();
          node.importKind = phase === "type" || phase === "typeof" ? phase : "value";
        }
      }
      parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
        const firstIdent = specifier.imported;
        let specifierTypeKind = null;
        if (firstIdent.type === "Identifier") {
          if (firstIdent.name === "type") {
            specifierTypeKind = "type";
          } else if (firstIdent.name === "typeof") {
            specifierTypeKind = "typeof";
          }
        }
        let isBinding = false;
        if (this.isContextual(93) && !this.isLookaheadContextual("as")) {
          const as_ident = this.parseIdentifier(true);
          if (specifierTypeKind !== null && !tokenIsKeywordOrIdentifier(this.state.type)) {
            specifier.imported = as_ident;
            specifier.importKind = specifierTypeKind;
            specifier.local = cloneIdentifier(as_ident);
          } else {
            specifier.imported = firstIdent;
            specifier.importKind = null;
            specifier.local = this.parseIdentifier();
          }
        } else {
          if (specifierTypeKind !== null && tokenIsKeywordOrIdentifier(this.state.type)) {
            specifier.imported = this.parseIdentifier(true);
            specifier.importKind = specifierTypeKind;
          } else {
            if (importedIsString) {
              throw this.raise(Errors.ImportBindingIsString, specifier, {
                importName: firstIdent.value
              });
            }
            specifier.imported = firstIdent;
            specifier.importKind = null;
          }
          if (this.eatContextual(93)) {
            specifier.local = this.parseIdentifier();
          } else {
            isBinding = true;
            specifier.local = cloneIdentifier(specifier.imported);
          }
        }
        const specifierIsTypeImport = hasTypeImportKind(specifier);
        if (isInTypeOnlyImport && specifierIsTypeImport) {
          this.raise(FlowErrors.ImportTypeShorthandOnlyInPureImport, specifier);
        }
        if (isInTypeOnlyImport || specifierIsTypeImport) {
          this.checkReservedType(specifier.local.name, specifier.local.loc.start, true);
        }
        if (isBinding && !isInTypeOnlyImport && !specifierIsTypeImport) {
          this.checkReservedWord(specifier.local.name, specifier.loc.start, true, true);
        }
        return this.finishImportSpecifier(specifier, "ImportSpecifier");
      }
      parseBindingAtom() {
        switch (this.state.type) {
          case 78:
            return this.parseIdentifier(true);
          default:
            return super.parseBindingAtom();
        }
      }
      parseFunctionParams(node, isConstructor) {
        const kind = node.kind;
        if (kind !== "get" && kind !== "set" && this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.parseFunctionParams(node, isConstructor);
      }
      parseVarId(decl, kind) {
        super.parseVarId(decl, kind);
        if (this.match(14)) {
          decl.id.typeAnnotation = this.flowParseTypeAnnotation();
          this.resetEndLocation(decl.id);
        }
      }
      parseAsyncArrowFromCallExpression(node, call) {
        if (this.match(14)) {
          const oldNoAnonFunctionType = this.state.noAnonFunctionType;
          this.state.noAnonFunctionType = true;
          node.returnType = this.flowParseTypeAnnotation();
          this.state.noAnonFunctionType = oldNoAnonFunctionType;
        }
        return super.parseAsyncArrowFromCallExpression(node, call);
      }
      shouldParseAsyncArrow() {
        return this.match(14) || super.shouldParseAsyncArrow();
      }
      parseMaybeAssign(refExpressionErrors, afterLeftParse) {
        var _jsx;
        let state = null;
        let jsx2;
        if (this.hasPlugin("jsx") && (this.match(143) || this.match(47))) {
          state = this.state.clone();
          jsx2 = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
          if (!jsx2.error) return jsx2.node;
          const {
            context
          } = this.state;
          const currentContext = context[context.length - 1];
          if (currentContext === types.j_oTag || currentContext === types.j_expr) {
            context.pop();
          }
        }
        if ((_jsx = jsx2) != null && _jsx.error || this.match(47)) {
          var _jsx2, _jsx3;
          state = state || this.state.clone();
          let typeParameters;
          const arrow = this.tryParse((abort) => {
            var _arrowExpression$extr;
            typeParameters = this.flowParseTypeParameterDeclaration();
            const arrowExpression2 = this.forwardNoArrowParamsConversionAt(typeParameters, () => {
              const result = super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
              this.resetStartLocationFromNode(result, typeParameters);
              return result;
            });
            if ((_arrowExpression$extr = arrowExpression2.extra) != null && _arrowExpression$extr.parenthesized) abort();
            const expr = this.maybeUnwrapTypeCastExpression(arrowExpression2);
            if (expr.type !== "ArrowFunctionExpression") abort();
            expr.typeParameters = typeParameters;
            this.resetStartLocationFromNode(expr, typeParameters);
            return arrowExpression2;
          }, state);
          let arrowExpression = null;
          if (arrow.node && this.maybeUnwrapTypeCastExpression(arrow.node).type === "ArrowFunctionExpression") {
            if (!arrow.error && !arrow.aborted) {
              if (arrow.node.async) {
                this.raise(FlowErrors.UnexpectedTypeParameterBeforeAsyncArrowFunction, typeParameters);
              }
              return arrow.node;
            }
            arrowExpression = arrow.node;
          }
          if ((_jsx2 = jsx2) != null && _jsx2.node) {
            this.state = jsx2.failState;
            return jsx2.node;
          }
          if (arrowExpression) {
            this.state = arrow.failState;
            return arrowExpression;
          }
          if ((_jsx3 = jsx2) != null && _jsx3.thrown) throw jsx2.error;
          if (arrow.thrown) throw arrow.error;
          throw this.raise(FlowErrors.UnexpectedTokenAfterTypeParameter, typeParameters);
        }
        return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
      }
      parseArrow(node) {
        if (this.match(14)) {
          const result = this.tryParse(() => {
            const oldNoAnonFunctionType = this.state.noAnonFunctionType;
            this.state.noAnonFunctionType = true;
            const typeNode = this.startNode();
            [typeNode.typeAnnotation, node.predicate] = this.flowParseTypeAndPredicateInitialiser();
            this.state.noAnonFunctionType = oldNoAnonFunctionType;
            if (this.canInsertSemicolon()) this.unexpected();
            if (!this.match(19)) this.unexpected();
            return typeNode;
          });
          if (result.thrown) return null;
          if (result.error) this.state = result.failState;
          node.returnType = result.node.typeAnnotation ? this.finishNode(result.node, "TypeAnnotation") : null;
        }
        return super.parseArrow(node);
      }
      shouldParseArrow(params) {
        return this.match(14) || super.shouldParseArrow(params);
      }
      setArrowFunctionParameters(node, params) {
        if (this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) {
          node.params = params;
        } else {
          super.setArrowFunctionParameters(node, params);
        }
      }
      checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged = true) {
        if (isArrowFunction && this.state.noArrowParamsConversionAt.includes(this.offsetToSourcePos(node.start))) {
          return;
        }
        for (let i = 0; i < node.params.length; i++) {
          if (this.isThisParam(node.params[i]) && i > 0) {
            this.raise(FlowErrors.ThisParamMustBeFirst, node.params[i]);
          }
        }
        super.checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged);
      }
      parseParenAndDistinguishExpression(canBeArrow) {
        return super.parseParenAndDistinguishExpression(canBeArrow && !this.state.noArrowAt.includes(this.sourceToOffsetPos(this.state.start)));
      }
      parseSubscripts(base, startLoc, noCalls) {
        if (base.type === "Identifier" && base.name === "async" && this.state.noArrowAt.includes(startLoc.index)) {
          this.next();
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          node.arguments = super.parseCallExpressionArguments(11);
          base = this.finishNode(node, "CallExpression");
        } else if (base.type === "Identifier" && base.name === "async" && this.match(47)) {
          const state = this.state.clone();
          const arrow = this.tryParse((abort) => this.parseAsyncArrowWithTypeParameters(startLoc) || abort(), state);
          if (!arrow.error && !arrow.aborted) return arrow.node;
          const result = this.tryParse(() => super.parseSubscripts(base, startLoc, noCalls), state);
          if (result.node && !result.error) return result.node;
          if (arrow.node) {
            this.state = arrow.failState;
            return arrow.node;
          }
          if (result.node) {
            this.state = result.failState;
            return result.node;
          }
          throw arrow.error || result.error;
        }
        return super.parseSubscripts(base, startLoc, noCalls);
      }
      parseSubscript(base, startLoc, noCalls, subscriptState) {
        if (this.match(18) && this.isLookaheadToken_lt()) {
          subscriptState.optionalChainMember = true;
          if (noCalls) {
            subscriptState.stop = true;
            return base;
          }
          this.next();
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          node.typeArguments = this.flowParseTypeParameterInstantiationInExpression();
          this.expect(10);
          node.arguments = this.parseCallExpressionArguments(11);
          node.optional = true;
          return this.finishCallExpression(node, true);
        } else if (!noCalls && this.shouldParseTypes() && (this.match(47) || this.match(51))) {
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          const result = this.tryParse(() => {
            node.typeArguments = this.flowParseTypeParameterInstantiationCallOrNew();
            this.expect(10);
            node.arguments = super.parseCallExpressionArguments(11);
            if (subscriptState.optionalChainMember) {
              node.optional = false;
            }
            return this.finishCallExpression(node, subscriptState.optionalChainMember);
          });
          if (result.node) {
            if (result.error) this.state = result.failState;
            return result.node;
          }
        }
        return super.parseSubscript(base, startLoc, noCalls, subscriptState);
      }
      parseNewCallee(node) {
        super.parseNewCallee(node);
        let targs = null;
        if (this.shouldParseTypes() && this.match(47)) {
          targs = this.tryParse(() => this.flowParseTypeParameterInstantiationCallOrNew()).node;
        }
        node.typeArguments = targs;
      }
      parseAsyncArrowWithTypeParameters(startLoc) {
        const node = this.startNodeAt(startLoc);
        this.parseFunctionParams(node, false);
        if (!this.parseArrow(node)) return;
        return super.parseArrowExpression(node, void 0, true);
      }
      readToken_mult_modulo(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code2 === 42 && next === 47 && this.state.hasFlowComment) {
          this.state.hasFlowComment = false;
          this.state.pos += 2;
          this.nextToken();
          return;
        }
        super.readToken_mult_modulo(code2);
      }
      readToken_pipe_amp(code2) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code2 === 124 && next === 125) {
          this.finishOp(9, 2);
          return;
        }
        super.readToken_pipe_amp(code2);
      }
      parseTopLevel(file2, program) {
        const fileNode = super.parseTopLevel(file2, program);
        if (this.state.hasFlowComment) {
          this.raise(FlowErrors.UnterminatedFlowComment, this.state.curPosition());
        }
        return fileNode;
      }
      skipBlockComment() {
        if (this.hasPlugin("flowComments") && this.skipFlowComment()) {
          if (this.state.hasFlowComment) {
            throw this.raise(FlowErrors.NestedFlowComment, this.state.startLoc);
          }
          this.hasFlowCommentCompletion();
          const commentSkip = this.skipFlowComment();
          if (commentSkip) {
            this.state.pos += commentSkip;
            this.state.hasFlowComment = true;
          }
          return;
        }
        return super.skipBlockComment(this.state.hasFlowComment ? "*-/" : "*/");
      }
      skipFlowComment() {
        const {
          pos: pos2
        } = this.state;
        let shiftToFirstNonWhiteSpace = 2;
        while ([32, 9].includes(this.input.charCodeAt(pos2 + shiftToFirstNonWhiteSpace))) {
          shiftToFirstNonWhiteSpace++;
        }
        const ch2 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos2);
        const ch3 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos2 + 1);
        if (ch2 === 58 && ch3 === 58) {
          return shiftToFirstNonWhiteSpace + 2;
        }
        if (this.input.slice(shiftToFirstNonWhiteSpace + pos2, shiftToFirstNonWhiteSpace + pos2 + 12) === "flow-include") {
          return shiftToFirstNonWhiteSpace + 12;
        }
        if (ch2 === 58 && ch3 !== 58) {
          return shiftToFirstNonWhiteSpace;
        }
        return false;
      }
      hasFlowCommentCompletion() {
        const end = this.input.indexOf("*/", this.state.pos);
        if (end === -1) {
          throw this.raise(Errors.UnterminatedComment, this.state.curPosition());
        }
      }
      flowEnumErrorBooleanMemberNotInitialized(loc, {
        enumName,
        memberName
      }) {
        this.raise(FlowErrors.EnumBooleanMemberNotInitialized, loc, {
          memberName,
          enumName
        });
      }
      flowEnumErrorInvalidMemberInitializer(loc, enumContext) {
        return this.raise(!enumContext.explicitType ? FlowErrors.EnumInvalidMemberInitializerUnknownType : enumContext.explicitType === "symbol" ? FlowErrors.EnumInvalidMemberInitializerSymbolType : FlowErrors.EnumInvalidMemberInitializerPrimaryType, loc, enumContext);
      }
      flowEnumErrorNumberMemberNotInitialized(loc, details) {
        this.raise(FlowErrors.EnumNumberMemberNotInitialized, loc, details);
      }
      flowEnumErrorStringMemberInconsistentlyInitialized(node, details) {
        this.raise(FlowErrors.EnumStringMemberInconsistentlyInitialized, node, details);
      }
      flowEnumMemberInit() {
        const startLoc = this.state.startLoc;
        const endOfInit = () => this.match(12) || this.match(8);
        switch (this.state.type) {
          case 135: {
            const literal3 = this.parseNumericLiteral(this.state.value);
            if (endOfInit()) {
              return {
                type: "number",
                loc: literal3.loc.start,
                value: literal3
              };
            }
            return {
              type: "invalid",
              loc: startLoc
            };
          }
          case 134: {
            const literal3 = this.parseStringLiteral(this.state.value);
            if (endOfInit()) {
              return {
                type: "string",
                loc: literal3.loc.start,
                value: literal3
              };
            }
            return {
              type: "invalid",
              loc: startLoc
            };
          }
          case 85:
          case 86: {
            const literal3 = this.parseBooleanLiteral(this.match(85));
            if (endOfInit()) {
              return {
                type: "boolean",
                loc: literal3.loc.start,
                value: literal3
              };
            }
            return {
              type: "invalid",
              loc: startLoc
            };
          }
          default:
            return {
              type: "invalid",
              loc: startLoc
            };
        }
      }
      flowEnumMemberRaw() {
        const loc = this.state.startLoc;
        const id = this.parseIdentifier(true);
        const init = this.eat(29) ? this.flowEnumMemberInit() : {
          type: "none",
          loc
        };
        return {
          id,
          init
        };
      }
      flowEnumCheckExplicitTypeMismatch(loc, context, expectedType) {
        const {
          explicitType
        } = context;
        if (explicitType === null) {
          return;
        }
        if (explicitType !== expectedType) {
          this.flowEnumErrorInvalidMemberInitializer(loc, context);
        }
      }
      flowEnumMembers({
        enumName,
        explicitType
      }) {
        const seenNames = /* @__PURE__ */ new Set();
        const members = {
          booleanMembers: [],
          numberMembers: [],
          stringMembers: [],
          defaultedMembers: []
        };
        let hasUnknownMembers = false;
        while (!this.match(8)) {
          if (this.eat(21)) {
            hasUnknownMembers = true;
            break;
          }
          const memberNode = this.startNode();
          const {
            id,
            init
          } = this.flowEnumMemberRaw();
          const memberName = id.name;
          if (memberName === "") {
            continue;
          }
          if (/^[a-z]/.test(memberName)) {
            this.raise(FlowErrors.EnumInvalidMemberName, id, {
              memberName,
              suggestion: memberName[0].toUpperCase() + memberName.slice(1),
              enumName
            });
          }
          if (seenNames.has(memberName)) {
            this.raise(FlowErrors.EnumDuplicateMemberName, id, {
              memberName,
              enumName
            });
          }
          seenNames.add(memberName);
          const context = {
            enumName,
            explicitType,
            memberName
          };
          memberNode.id = id;
          switch (init.type) {
            case "boolean": {
              this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "boolean");
              memberNode.init = init.value;
              members.booleanMembers.push(this.finishNode(memberNode, "EnumBooleanMember"));
              break;
            }
            case "number": {
              this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "number");
              memberNode.init = init.value;
              members.numberMembers.push(this.finishNode(memberNode, "EnumNumberMember"));
              break;
            }
            case "string": {
              this.flowEnumCheckExplicitTypeMismatch(init.loc, context, "string");
              memberNode.init = init.value;
              members.stringMembers.push(this.finishNode(memberNode, "EnumStringMember"));
              break;
            }
            case "invalid": {
              throw this.flowEnumErrorInvalidMemberInitializer(init.loc, context);
            }
            case "none": {
              switch (explicitType) {
                case "boolean":
                  this.flowEnumErrorBooleanMemberNotInitialized(init.loc, context);
                  break;
                case "number":
                  this.flowEnumErrorNumberMemberNotInitialized(init.loc, context);
                  break;
                default:
                  members.defaultedMembers.push(this.finishNode(memberNode, "EnumDefaultedMember"));
              }
            }
          }
          if (!this.match(8)) {
            this.expect(12);
          }
        }
        return {
          members,
          hasUnknownMembers
        };
      }
      flowEnumStringMembers(initializedMembers, defaultedMembers, {
        enumName
      }) {
        if (initializedMembers.length === 0) {
          return defaultedMembers;
        } else if (defaultedMembers.length === 0) {
          return initializedMembers;
        } else if (defaultedMembers.length > initializedMembers.length) {
          for (const member of initializedMembers) {
            this.flowEnumErrorStringMemberInconsistentlyInitialized(member, {
              enumName
            });
          }
          return defaultedMembers;
        } else {
          for (const member of defaultedMembers) {
            this.flowEnumErrorStringMemberInconsistentlyInitialized(member, {
              enumName
            });
          }
          return initializedMembers;
        }
      }
      flowEnumParseExplicitType({
        enumName
      }) {
        if (!this.eatContextual(102)) return null;
        if (!tokenIsIdentifier(this.state.type)) {
          throw this.raise(FlowErrors.EnumInvalidExplicitTypeUnknownSupplied, this.state.startLoc, {
            enumName
          });
        }
        const {
          value
        } = this.state;
        this.next();
        if (value !== "boolean" && value !== "number" && value !== "string" && value !== "symbol") {
          this.raise(FlowErrors.EnumInvalidExplicitType, this.state.startLoc, {
            enumName,
            invalidEnumType: value
          });
        }
        return value;
      }
      flowEnumBody(node, id) {
        const enumName = id.name;
        const nameLoc = id.loc.start;
        const explicitType = this.flowEnumParseExplicitType({
          enumName
        });
        this.expect(5);
        const {
          members,
          hasUnknownMembers
        } = this.flowEnumMembers({
          enumName,
          explicitType
        });
        node.hasUnknownMembers = hasUnknownMembers;
        switch (explicitType) {
          case "boolean":
            node.explicitType = true;
            node.members = members.booleanMembers;
            this.expect(8);
            return this.finishNode(node, "EnumBooleanBody");
          case "number":
            node.explicitType = true;
            node.members = members.numberMembers;
            this.expect(8);
            return this.finishNode(node, "EnumNumberBody");
          case "string":
            node.explicitType = true;
            node.members = this.flowEnumStringMembers(members.stringMembers, members.defaultedMembers, {
              enumName
            });
            this.expect(8);
            return this.finishNode(node, "EnumStringBody");
          case "symbol":
            node.members = members.defaultedMembers;
            this.expect(8);
            return this.finishNode(node, "EnumSymbolBody");
          default: {
            const empty2 = () => {
              node.members = [];
              this.expect(8);
              return this.finishNode(node, "EnumStringBody");
            };
            node.explicitType = false;
            const boolsLen = members.booleanMembers.length;
            const numsLen = members.numberMembers.length;
            const strsLen = members.stringMembers.length;
            const defaultedLen = members.defaultedMembers.length;
            if (!boolsLen && !numsLen && !strsLen && !defaultedLen) {
              return empty2();
            } else if (!boolsLen && !numsLen) {
              node.members = this.flowEnumStringMembers(members.stringMembers, members.defaultedMembers, {
                enumName
              });
              this.expect(8);
              return this.finishNode(node, "EnumStringBody");
            } else if (!numsLen && !strsLen && boolsLen >= defaultedLen) {
              for (const member of members.defaultedMembers) {
                this.flowEnumErrorBooleanMemberNotInitialized(member.loc.start, {
                  enumName,
                  memberName: member.id.name
                });
              }
              node.members = members.booleanMembers;
              this.expect(8);
              return this.finishNode(node, "EnumBooleanBody");
            } else if (!boolsLen && !strsLen && numsLen >= defaultedLen) {
              for (const member of members.defaultedMembers) {
                this.flowEnumErrorNumberMemberNotInitialized(member.loc.start, {
                  enumName,
                  memberName: member.id.name
                });
              }
              node.members = members.numberMembers;
              this.expect(8);
              return this.finishNode(node, "EnumNumberBody");
            } else {
              this.raise(FlowErrors.EnumInconsistentMemberValues, nameLoc, {
                enumName
              });
              return empty2();
            }
          }
        }
      }
      flowParseEnumDeclaration(node) {
        const id = this.parseIdentifier();
        node.id = id;
        node.body = this.flowEnumBody(this.startNode(), id);
        return this.finishNode(node, "EnumDeclaration");
      }
      jsxParseOpeningElementAfterName(node) {
        if (this.shouldParseTypes()) {
          if (this.match(47) || this.match(51)) {
            node.typeArguments = this.flowParseTypeParameterInstantiationInExpression();
          }
        }
        return super.jsxParseOpeningElementAfterName(node);
      }
      isLookaheadToken_lt() {
        const next = this.nextTokenStart();
        if (this.input.charCodeAt(next) === 60) {
          const afterNext = this.input.charCodeAt(next + 1);
          return afterNext !== 60 && afterNext !== 61;
        }
        return false;
      }
      reScan_lt_gt() {
        const {
          type
        } = this.state;
        if (type === 47) {
          this.state.pos -= 1;
          this.readToken_lt();
        } else if (type === 48) {
          this.state.pos -= 1;
          this.readToken_gt();
        }
      }
      reScan_lt() {
        const {
          type
        } = this.state;
        if (type === 51) {
          this.state.pos -= 2;
          this.finishOp(47, 1);
          return 47;
        }
        return type;
      }
      maybeUnwrapTypeCastExpression(node) {
        return node.type === "TypeCastExpression" ? node.expression : node;
      }
    };
    var entities = {
      __proto__: null,
      quot: '"',
      amp: "&",
      apos: "'",
      lt: "<",
      gt: ">",
      nbsp: "\xA0",
      iexcl: "\xA1",
      cent: "\xA2",
      pound: "\xA3",
      curren: "\xA4",
      yen: "\xA5",
      brvbar: "\xA6",
      sect: "\xA7",
      uml: "\xA8",
      copy: "\xA9",
      ordf: "\xAA",
      laquo: "\xAB",
      not: "\xAC",
      shy: "\xAD",
      reg: "\xAE",
      macr: "\xAF",
      deg: "\xB0",
      plusmn: "\xB1",
      sup2: "\xB2",
      sup3: "\xB3",
      acute: "\xB4",
      micro: "\xB5",
      para: "\xB6",
      middot: "\xB7",
      cedil: "\xB8",
      sup1: "\xB9",
      ordm: "\xBA",
      raquo: "\xBB",
      frac14: "\xBC",
      frac12: "\xBD",
      frac34: "\xBE",
      iquest: "\xBF",
      Agrave: "\xC0",
      Aacute: "\xC1",
      Acirc: "\xC2",
      Atilde: "\xC3",
      Auml: "\xC4",
      Aring: "\xC5",
      AElig: "\xC6",
      Ccedil: "\xC7",
      Egrave: "\xC8",
      Eacute: "\xC9",
      Ecirc: "\xCA",
      Euml: "\xCB",
      Igrave: "\xCC",
      Iacute: "\xCD",
      Icirc: "\xCE",
      Iuml: "\xCF",
      ETH: "\xD0",
      Ntilde: "\xD1",
      Ograve: "\xD2",
      Oacute: "\xD3",
      Ocirc: "\xD4",
      Otilde: "\xD5",
      Ouml: "\xD6",
      times: "\xD7",
      Oslash: "\xD8",
      Ugrave: "\xD9",
      Uacute: "\xDA",
      Ucirc: "\xDB",
      Uuml: "\xDC",
      Yacute: "\xDD",
      THORN: "\xDE",
      szlig: "\xDF",
      agrave: "\xE0",
      aacute: "\xE1",
      acirc: "\xE2",
      atilde: "\xE3",
      auml: "\xE4",
      aring: "\xE5",
      aelig: "\xE6",
      ccedil: "\xE7",
      egrave: "\xE8",
      eacute: "\xE9",
      ecirc: "\xEA",
      euml: "\xEB",
      igrave: "\xEC",
      iacute: "\xED",
      icirc: "\xEE",
      iuml: "\xEF",
      eth: "\xF0",
      ntilde: "\xF1",
      ograve: "\xF2",
      oacute: "\xF3",
      ocirc: "\xF4",
      otilde: "\xF5",
      ouml: "\xF6",
      divide: "\xF7",
      oslash: "\xF8",
      ugrave: "\xF9",
      uacute: "\xFA",
      ucirc: "\xFB",
      uuml: "\xFC",
      yacute: "\xFD",
      thorn: "\xFE",
      yuml: "\xFF",
      OElig: "\u0152",
      oelig: "\u0153",
      Scaron: "\u0160",
      scaron: "\u0161",
      Yuml: "\u0178",
      fnof: "\u0192",
      circ: "\u02C6",
      tilde: "\u02DC",
      Alpha: "\u0391",
      Beta: "\u0392",
      Gamma: "\u0393",
      Delta: "\u0394",
      Epsilon: "\u0395",
      Zeta: "\u0396",
      Eta: "\u0397",
      Theta: "\u0398",
      Iota: "\u0399",
      Kappa: "\u039A",
      Lambda: "\u039B",
      Mu: "\u039C",
      Nu: "\u039D",
      Xi: "\u039E",
      Omicron: "\u039F",
      Pi: "\u03A0",
      Rho: "\u03A1",
      Sigma: "\u03A3",
      Tau: "\u03A4",
      Upsilon: "\u03A5",
      Phi: "\u03A6",
      Chi: "\u03A7",
      Psi: "\u03A8",
      Omega: "\u03A9",
      alpha: "\u03B1",
      beta: "\u03B2",
      gamma: "\u03B3",
      delta: "\u03B4",
      epsilon: "\u03B5",
      zeta: "\u03B6",
      eta: "\u03B7",
      theta: "\u03B8",
      iota: "\u03B9",
      kappa: "\u03BA",
      lambda: "\u03BB",
      mu: "\u03BC",
      nu: "\u03BD",
      xi: "\u03BE",
      omicron: "\u03BF",
      pi: "\u03C0",
      rho: "\u03C1",
      sigmaf: "\u03C2",
      sigma: "\u03C3",
      tau: "\u03C4",
      upsilon: "\u03C5",
      phi: "\u03C6",
      chi: "\u03C7",
      psi: "\u03C8",
      omega: "\u03C9",
      thetasym: "\u03D1",
      upsih: "\u03D2",
      piv: "\u03D6",
      ensp: "\u2002",
      emsp: "\u2003",
      thinsp: "\u2009",
      zwnj: "\u200C",
      zwj: "\u200D",
      lrm: "\u200E",
      rlm: "\u200F",
      ndash: "\u2013",
      mdash: "\u2014",
      lsquo: "\u2018",
      rsquo: "\u2019",
      sbquo: "\u201A",
      ldquo: "\u201C",
      rdquo: "\u201D",
      bdquo: "\u201E",
      dagger: "\u2020",
      Dagger: "\u2021",
      bull: "\u2022",
      hellip: "\u2026",
      permil: "\u2030",
      prime: "\u2032",
      Prime: "\u2033",
      lsaquo: "\u2039",
      rsaquo: "\u203A",
      oline: "\u203E",
      frasl: "\u2044",
      euro: "\u20AC",
      image: "\u2111",
      weierp: "\u2118",
      real: "\u211C",
      trade: "\u2122",
      alefsym: "\u2135",
      larr: "\u2190",
      uarr: "\u2191",
      rarr: "\u2192",
      darr: "\u2193",
      harr: "\u2194",
      crarr: "\u21B5",
      lArr: "\u21D0",
      uArr: "\u21D1",
      rArr: "\u21D2",
      dArr: "\u21D3",
      hArr: "\u21D4",
      forall: "\u2200",
      part: "\u2202",
      exist: "\u2203",
      empty: "\u2205",
      nabla: "\u2207",
      isin: "\u2208",
      notin: "\u2209",
      ni: "\u220B",
      prod: "\u220F",
      sum: "\u2211",
      minus: "\u2212",
      lowast: "\u2217",
      radic: "\u221A",
      prop: "\u221D",
      infin: "\u221E",
      ang: "\u2220",
      and: "\u2227",
      or: "\u2228",
      cap: "\u2229",
      cup: "\u222A",
      int: "\u222B",
      there4: "\u2234",
      sim: "\u223C",
      cong: "\u2245",
      asymp: "\u2248",
      ne: "\u2260",
      equiv: "\u2261",
      le: "\u2264",
      ge: "\u2265",
      sub: "\u2282",
      sup: "\u2283",
      nsub: "\u2284",
      sube: "\u2286",
      supe: "\u2287",
      oplus: "\u2295",
      otimes: "\u2297",
      perp: "\u22A5",
      sdot: "\u22C5",
      lceil: "\u2308",
      rceil: "\u2309",
      lfloor: "\u230A",
      rfloor: "\u230B",
      lang: "\u2329",
      rang: "\u232A",
      loz: "\u25CA",
      spades: "\u2660",
      clubs: "\u2663",
      hearts: "\u2665",
      diams: "\u2666"
    };
    var JsxErrors = ParseErrorEnum`jsx`({
      AttributeIsEmpty: "JSX attributes must only be assigned a non-empty expression.",
      MissingClosingTagElement: ({
        openingTagName
      }) => `Expected corresponding JSX closing tag for <${openingTagName}>.`,
      MissingClosingTagFragment: "Expected corresponding JSX closing tag for <>.",
      UnexpectedSequenceExpression: "Sequence expressions cannot be directly nested inside JSX. Did you mean to wrap it in parentheses (...)?",
      UnexpectedToken: ({
        unexpected,
        HTMLEntity
      }) => `Unexpected token \`${unexpected}\`. Did you mean \`${HTMLEntity}\` or \`{'${unexpected}'}\`?`,
      UnsupportedJsxValue: "JSX value should be either an expression or a quoted JSX text.",
      UnterminatedJsxContent: "Unterminated JSX contents.",
      UnwrappedAdjacentJSXElements: "Adjacent JSX elements must be wrapped in an enclosing tag. Did you want a JSX fragment <>...</>?"
    });
    function isFragment(object2) {
      return object2 ? object2.type === "JSXOpeningFragment" || object2.type === "JSXClosingFragment" : false;
    }
    function getQualifiedJSXName(object2) {
      if (object2.type === "JSXIdentifier") {
        return object2.name;
      }
      if (object2.type === "JSXNamespacedName") {
        return object2.namespace.name + ":" + object2.name.name;
      }
      if (object2.type === "JSXMemberExpression") {
        return getQualifiedJSXName(object2.object) + "." + getQualifiedJSXName(object2.property);
      }
      throw new Error("Node had unexpected type: " + object2.type);
    }
    var jsx = (superClass) => class JSXParserMixin extends superClass {
      jsxReadToken() {
        let out = "";
        let chunkStart = this.state.pos;
        for (; ; ) {
          if (this.state.pos >= this.length) {
            throw this.raise(JsxErrors.UnterminatedJsxContent, this.state.startLoc);
          }
          const ch = this.input.charCodeAt(this.state.pos);
          switch (ch) {
            case 60:
            case 123:
              if (this.state.pos === this.state.start) {
                if (ch === 60 && this.state.canStartJSXElement) {
                  ++this.state.pos;
                  this.finishToken(143);
                } else {
                  super.getTokenFromCode(ch);
                }
                return;
              }
              out += this.input.slice(chunkStart, this.state.pos);
              this.finishToken(142, out);
              return;
            case 38:
              out += this.input.slice(chunkStart, this.state.pos);
              out += this.jsxReadEntity();
              chunkStart = this.state.pos;
              break;
            case 62:
            case 125:
            default:
              if (isNewLine(ch)) {
                out += this.input.slice(chunkStart, this.state.pos);
                out += this.jsxReadNewLine(true);
                chunkStart = this.state.pos;
              } else {
                ++this.state.pos;
              }
          }
        }
      }
      jsxReadNewLine(normalizeCRLF) {
        const ch = this.input.charCodeAt(this.state.pos);
        let out;
        ++this.state.pos;
        if (ch === 13 && this.input.charCodeAt(this.state.pos) === 10) {
          ++this.state.pos;
          out = normalizeCRLF ? "\n" : "\r\n";
        } else {
          out = String.fromCharCode(ch);
        }
        ++this.state.curLine;
        this.state.lineStart = this.state.pos;
        return out;
      }
      jsxReadString(quote) {
        let out = "";
        let chunkStart = ++this.state.pos;
        for (; ; ) {
          if (this.state.pos >= this.length) {
            throw this.raise(Errors.UnterminatedString, this.state.startLoc);
          }
          const ch = this.input.charCodeAt(this.state.pos);
          if (ch === quote) break;
          if (ch === 38) {
            out += this.input.slice(chunkStart, this.state.pos);
            out += this.jsxReadEntity();
            chunkStart = this.state.pos;
          } else if (isNewLine(ch)) {
            out += this.input.slice(chunkStart, this.state.pos);
            out += this.jsxReadNewLine(false);
            chunkStart = this.state.pos;
          } else {
            ++this.state.pos;
          }
        }
        out += this.input.slice(chunkStart, this.state.pos++);
        this.finishToken(134, out);
      }
      jsxReadEntity() {
        const startPos = ++this.state.pos;
        if (this.codePointAtPos(this.state.pos) === 35) {
          ++this.state.pos;
          let radix = 10;
          if (this.codePointAtPos(this.state.pos) === 120) {
            radix = 16;
            ++this.state.pos;
          }
          const codePoint = this.readInt(radix, void 0, false, "bail");
          if (codePoint !== null && this.codePointAtPos(this.state.pos) === 59) {
            ++this.state.pos;
            return String.fromCodePoint(codePoint);
          }
        } else {
          let count = 0;
          let semi = false;
          while (count++ < 10 && this.state.pos < this.length && !(semi = this.codePointAtPos(this.state.pos) === 59)) {
            ++this.state.pos;
          }
          if (semi) {
            const desc = this.input.slice(startPos, this.state.pos);
            const entity = entities[desc];
            ++this.state.pos;
            if (entity) {
              return entity;
            }
          }
        }
        this.state.pos = startPos;
        return "&";
      }
      jsxReadWord() {
        let ch;
        const start = this.state.pos;
        do {
          ch = this.input.charCodeAt(++this.state.pos);
        } while (isIdentifierChar(ch) || ch === 45);
        this.finishToken(141, this.input.slice(start, this.state.pos));
      }
      jsxParseIdentifier() {
        const node = this.startNode();
        if (this.match(141)) {
          node.name = this.state.value;
        } else if (tokenIsKeyword(this.state.type)) {
          node.name = tokenLabelName(this.state.type);
        } else {
          this.unexpected();
        }
        this.next();
        return this.finishNode(node, "JSXIdentifier");
      }
      jsxParseNamespacedName() {
        const startLoc = this.state.startLoc;
        const name = this.jsxParseIdentifier();
        if (!this.eat(14)) return name;
        const node = this.startNodeAt(startLoc);
        node.namespace = name;
        node.name = this.jsxParseIdentifier();
        return this.finishNode(node, "JSXNamespacedName");
      }
      jsxParseElementName() {
        const startLoc = this.state.startLoc;
        let node = this.jsxParseNamespacedName();
        if (node.type === "JSXNamespacedName") {
          return node;
        }
        while (this.eat(16)) {
          const newNode = this.startNodeAt(startLoc);
          newNode.object = node;
          newNode.property = this.jsxParseIdentifier();
          node = this.finishNode(newNode, "JSXMemberExpression");
        }
        return node;
      }
      jsxParseAttributeValue() {
        let node;
        switch (this.state.type) {
          case 5:
            node = this.startNode();
            this.setContext(types.brace);
            this.next();
            node = this.jsxParseExpressionContainer(node, types.j_oTag);
            if (node.expression.type === "JSXEmptyExpression") {
              this.raise(JsxErrors.AttributeIsEmpty, node);
            }
            return node;
          case 143:
          case 134:
            return this.parseExprAtom();
          default:
            throw this.raise(JsxErrors.UnsupportedJsxValue, this.state.startLoc);
        }
      }
      jsxParseEmptyExpression() {
        const node = this.startNodeAt(this.state.lastTokEndLoc);
        return this.finishNodeAt(node, "JSXEmptyExpression", this.state.startLoc);
      }
      jsxParseSpreadChild(node) {
        this.next();
        node.expression = this.parseExpression();
        this.setContext(types.j_expr);
        this.state.canStartJSXElement = true;
        this.expect(8);
        return this.finishNode(node, "JSXSpreadChild");
      }
      jsxParseExpressionContainer(node, previousContext) {
        if (this.match(8)) {
          node.expression = this.jsxParseEmptyExpression();
        } else {
          const expression = this.parseExpression();
          node.expression = expression;
        }
        this.setContext(previousContext);
        this.state.canStartJSXElement = true;
        this.expect(8);
        return this.finishNode(node, "JSXExpressionContainer");
      }
      jsxParseAttribute() {
        const node = this.startNode();
        if (this.match(5)) {
          this.setContext(types.brace);
          this.next();
          this.expect(21);
          node.argument = this.parseMaybeAssignAllowIn();
          this.setContext(types.j_oTag);
          this.state.canStartJSXElement = true;
          this.expect(8);
          return this.finishNode(node, "JSXSpreadAttribute");
        }
        node.name = this.jsxParseNamespacedName();
        node.value = this.eat(29) ? this.jsxParseAttributeValue() : null;
        return this.finishNode(node, "JSXAttribute");
      }
      jsxParseOpeningElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        if (this.eat(144)) {
          return this.finishNode(node, "JSXOpeningFragment");
        }
        node.name = this.jsxParseElementName();
        return this.jsxParseOpeningElementAfterName(node);
      }
      jsxParseOpeningElementAfterName(node) {
        const attributes = [];
        while (!this.match(56) && !this.match(144)) {
          attributes.push(this.jsxParseAttribute());
        }
        node.attributes = attributes;
        node.selfClosing = this.eat(56);
        this.expect(144);
        return this.finishNode(node, "JSXOpeningElement");
      }
      jsxParseClosingElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        if (this.eat(144)) {
          return this.finishNode(node, "JSXClosingFragment");
        }
        node.name = this.jsxParseElementName();
        this.expect(144);
        return this.finishNode(node, "JSXClosingElement");
      }
      jsxParseElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        const children = [];
        const openingElement = this.jsxParseOpeningElementAt(startLoc);
        let closingElement = null;
        if (!openingElement.selfClosing) {
          contents: for (; ; ) {
            switch (this.state.type) {
              case 143:
                startLoc = this.state.startLoc;
                this.next();
                if (this.eat(56)) {
                  closingElement = this.jsxParseClosingElementAt(startLoc);
                  break contents;
                }
                children.push(this.jsxParseElementAt(startLoc));
                break;
              case 142:
                children.push(this.parseLiteral(this.state.value, "JSXText"));
                break;
              case 5: {
                const node2 = this.startNode();
                this.setContext(types.brace);
                this.next();
                if (this.match(21)) {
                  children.push(this.jsxParseSpreadChild(node2));
                } else {
                  children.push(this.jsxParseExpressionContainer(node2, types.j_expr));
                }
                break;
              }
              default:
                this.unexpected();
            }
          }
          if (isFragment(openingElement) && !isFragment(closingElement) && closingElement !== null) {
            this.raise(JsxErrors.MissingClosingTagFragment, closingElement);
          } else if (!isFragment(openingElement) && isFragment(closingElement)) {
            this.raise(JsxErrors.MissingClosingTagElement, closingElement, {
              openingTagName: getQualifiedJSXName(openingElement.name)
            });
          } else if (!isFragment(openingElement) && !isFragment(closingElement)) {
            if (getQualifiedJSXName(closingElement.name) !== getQualifiedJSXName(openingElement.name)) {
              this.raise(JsxErrors.MissingClosingTagElement, closingElement, {
                openingTagName: getQualifiedJSXName(openingElement.name)
              });
            }
          }
        }
        if (isFragment(openingElement)) {
          node.openingFragment = openingElement;
          node.closingFragment = closingElement;
        } else {
          node.openingElement = openingElement;
          node.closingElement = closingElement;
        }
        node.children = children;
        if (this.match(47)) {
          throw this.raise(JsxErrors.UnwrappedAdjacentJSXElements, this.state.startLoc);
        }
        return isFragment(openingElement) ? this.finishNode(node, "JSXFragment") : this.finishNode(node, "JSXElement");
      }
      jsxParseElement() {
        const startLoc = this.state.startLoc;
        this.next();
        return this.jsxParseElementAt(startLoc);
      }
      setContext(newContext) {
        const {
          context
        } = this.state;
        context[context.length - 1] = newContext;
      }
      parseExprAtom(refExpressionErrors) {
        if (this.match(143)) {
          return this.jsxParseElement();
        } else if (this.match(47) && this.input.charCodeAt(this.state.pos) !== 33) {
          this.replaceToken(143);
          return this.jsxParseElement();
        } else {
          return super.parseExprAtom(refExpressionErrors);
        }
      }
      skipSpace() {
        const curContext = this.curContext();
        if (!curContext.preserveSpace) super.skipSpace();
      }
      getTokenFromCode(code2) {
        const context = this.curContext();
        if (context === types.j_expr) {
          this.jsxReadToken();
          return;
        }
        if (context === types.j_oTag || context === types.j_cTag) {
          if (isIdentifierStart(code2)) {
            this.jsxReadWord();
            return;
          }
          if (code2 === 62) {
            ++this.state.pos;
            this.finishToken(144);
            return;
          }
          if ((code2 === 34 || code2 === 39) && context === types.j_oTag) {
            this.jsxReadString(code2);
            return;
          }
        }
        if (code2 === 60 && this.state.canStartJSXElement && this.input.charCodeAt(this.state.pos + 1) !== 33) {
          ++this.state.pos;
          this.finishToken(143);
          return;
        }
        super.getTokenFromCode(code2);
      }
      updateContext(prevType) {
        const {
          context,
          type
        } = this.state;
        if (type === 56 && prevType === 143) {
          context.splice(-2, 2, types.j_cTag);
          this.state.canStartJSXElement = false;
        } else if (type === 143) {
          context.push(types.j_oTag);
        } else if (type === 144) {
          const out = context[context.length - 1];
          if (out === types.j_oTag && prevType === 56 || out === types.j_cTag) {
            context.pop();
            this.state.canStartJSXElement = context[context.length - 1] === types.j_expr;
          } else {
            this.setContext(types.j_expr);
            this.state.canStartJSXElement = true;
          }
        } else {
          this.state.canStartJSXElement = tokenComesBeforeExpression(type);
        }
      }
    };
    var TypeScriptScope = class extends Scope {
      constructor(...args) {
        super(...args);
        this.tsNames = /* @__PURE__ */ new Map();
      }
    };
    var TypeScriptScopeHandler = class extends ScopeHandler {
      constructor(...args) {
        super(...args);
        this.importsStack = [];
      }
      createScope(flags) {
        this.importsStack.push(/* @__PURE__ */ new Set());
        return new TypeScriptScope(flags);
      }
      enter(flags) {
        if (flags === 256) {
          this.importsStack.push(/* @__PURE__ */ new Set());
        }
        super.enter(flags);
      }
      exit() {
        const flags = super.exit();
        if (flags === 256) {
          this.importsStack.pop();
        }
        return flags;
      }
      hasImport(name, allowShadow) {
        const len = this.importsStack.length;
        if (this.importsStack[len - 1].has(name)) {
          return true;
        }
        if (!allowShadow && len > 1) {
          for (let i = 0; i < len - 1; i++) {
            if (this.importsStack[i].has(name)) return true;
          }
        }
        return false;
      }
      declareName(name, bindingType, loc) {
        if (bindingType & 4096) {
          if (this.hasImport(name, true)) {
            this.parser.raise(Errors.VarRedeclaration, loc, {
              identifierName: name
            });
          }
          this.importsStack[this.importsStack.length - 1].add(name);
          return;
        }
        const scope = this.currentScope();
        let type = scope.tsNames.get(name) || 0;
        if (bindingType & 1024) {
          this.maybeExportDefined(scope, name);
          scope.tsNames.set(name, type | 16);
          return;
        }
        super.declareName(name, bindingType, loc);
        if (bindingType & 2) {
          if (!(bindingType & 1)) {
            this.checkRedeclarationInScope(scope, name, bindingType, loc);
            this.maybeExportDefined(scope, name);
          }
          type = type | 1;
        }
        if (bindingType & 256) {
          type = type | 2;
        }
        if (bindingType & 512) {
          type = type | 4;
        }
        if (bindingType & 128) {
          type = type | 8;
        }
        if (type) scope.tsNames.set(name, type);
      }
      isRedeclaredInScope(scope, name, bindingType) {
        const type = scope.tsNames.get(name);
        if ((type & 2) > 0) {
          if (bindingType & 256) {
            const isConst = !!(bindingType & 512);
            const wasConst = (type & 4) > 0;
            return isConst !== wasConst;
          }
          return true;
        }
        if (bindingType & 128 && (type & 8) > 0) {
          if (scope.names.get(name) & 2) {
            return !!(bindingType & 1);
          } else {
            return false;
          }
        }
        if (bindingType & 2 && (type & 1) > 0) {
          return true;
        }
        return super.isRedeclaredInScope(scope, name, bindingType);
      }
      checkLocalExport(id) {
        const {
          name
        } = id;
        if (this.hasImport(name)) return;
        const len = this.scopeStack.length;
        for (let i = len - 1; i >= 0; i--) {
          const scope = this.scopeStack[i];
          const type = scope.tsNames.get(name);
          if ((type & 1) > 0 || (type & 16) > 0) {
            return;
          }
        }
        super.checkLocalExport(id);
      }
    };
    var unwrapParenthesizedExpression = (node) => {
      return node.type === "ParenthesizedExpression" ? unwrapParenthesizedExpression(node.expression) : node;
    };
    var LValParser = class extends NodeUtils {
      toAssignable(node, isLHS = false) {
        var _node$extra, _node$extra3;
        let parenthesized = void 0;
        if (node.type === "ParenthesizedExpression" || (_node$extra = node.extra) != null && _node$extra.parenthesized) {
          parenthesized = unwrapParenthesizedExpression(node);
          if (isLHS) {
            if (parenthesized.type === "Identifier") {
              this.expressionScope.recordArrowParameterBindingError(Errors.InvalidParenthesizedAssignment, node);
            } else if (parenthesized.type !== "MemberExpression" && !this.isOptionalMemberExpression(parenthesized)) {
              this.raise(Errors.InvalidParenthesizedAssignment, node);
            }
          } else {
            this.raise(Errors.InvalidParenthesizedAssignment, node);
          }
        }
        switch (node.type) {
          case "Identifier":
          case "ObjectPattern":
          case "ArrayPattern":
          case "AssignmentPattern":
          case "RestElement":
            break;
          case "ObjectExpression":
            node.type = "ObjectPattern";
            for (let i = 0, length = node.properties.length, last = length - 1; i < length; i++) {
              var _node$extra2;
              const prop = node.properties[i];
              const isLast = i === last;
              this.toAssignableObjectExpressionProp(prop, isLast, isLHS);
              if (isLast && prop.type === "RestElement" && (_node$extra2 = node.extra) != null && _node$extra2.trailingCommaLoc) {
                this.raise(Errors.RestTrailingComma, node.extra.trailingCommaLoc);
              }
            }
            break;
          case "ObjectProperty": {
            const {
              key: key2,
              value
            } = node;
            if (this.isPrivateName(key2)) {
              this.classScope.usePrivateName(this.getPrivateNameSV(key2), key2.loc.start);
            }
            this.toAssignable(value, isLHS);
            break;
          }
          case "SpreadElement": {
            throw new Error("Internal @babel/parser error (this is a bug, please report it). SpreadElement should be converted by .toAssignable's caller.");
          }
          case "ArrayExpression":
            node.type = "ArrayPattern";
            this.toAssignableList(node.elements, (_node$extra3 = node.extra) == null ? void 0 : _node$extra3.trailingCommaLoc, isLHS);
            break;
          case "AssignmentExpression":
            if (node.operator !== "=") {
              this.raise(Errors.MissingEqInAssignment, node.left.loc.end);
            }
            node.type = "AssignmentPattern";
            delete node.operator;
            this.toAssignable(node.left, isLHS);
            break;
          case "ParenthesizedExpression":
            this.toAssignable(parenthesized, isLHS);
            break;
        }
      }
      toAssignableObjectExpressionProp(prop, isLast, isLHS) {
        if (prop.type === "ObjectMethod") {
          this.raise(prop.kind === "get" || prop.kind === "set" ? Errors.PatternHasAccessor : Errors.PatternHasMethod, prop.key);
        } else if (prop.type === "SpreadElement") {
          prop.type = "RestElement";
          const arg = prop.argument;
          this.checkToRestConversion(arg, false);
          this.toAssignable(arg, isLHS);
          if (!isLast) {
            this.raise(Errors.RestTrailingComma, prop);
          }
        } else {
          this.toAssignable(prop, isLHS);
        }
      }
      toAssignableList(exprList, trailingCommaLoc, isLHS) {
        const end = exprList.length - 1;
        for (let i = 0; i <= end; i++) {
          const elt = exprList[i];
          if (!elt) continue;
          this.toAssignableListItem(exprList, i, isLHS);
          if (elt.type === "RestElement") {
            if (i < end) {
              this.raise(Errors.RestTrailingComma, elt);
            } else if (trailingCommaLoc) {
              this.raise(Errors.RestTrailingComma, trailingCommaLoc);
            }
          }
        }
      }
      toAssignableListItem(exprList, index, isLHS) {
        const node = exprList[index];
        if (node.type === "SpreadElement") {
          node.type = "RestElement";
          const arg = node.argument;
          this.checkToRestConversion(arg, true);
          this.toAssignable(arg, isLHS);
        } else {
          this.toAssignable(node, isLHS);
        }
      }
      isAssignable(node, isBinding) {
        switch (node.type) {
          case "Identifier":
          case "ObjectPattern":
          case "ArrayPattern":
          case "AssignmentPattern":
          case "RestElement":
            return true;
          case "ObjectExpression": {
            const last = node.properties.length - 1;
            return node.properties.every((prop, i) => {
              return prop.type !== "ObjectMethod" && (i === last || prop.type !== "SpreadElement") && this.isAssignable(prop);
            });
          }
          case "ObjectProperty":
            return this.isAssignable(node.value);
          case "SpreadElement":
            return this.isAssignable(node.argument);
          case "ArrayExpression":
            return node.elements.every((element) => element === null || this.isAssignable(element));
          case "AssignmentExpression":
            return node.operator === "=";
          case "ParenthesizedExpression":
            return this.isAssignable(node.expression);
          case "MemberExpression":
          case "OptionalMemberExpression":
            return !isBinding;
          default:
            return false;
        }
      }
      toReferencedList(exprList, isParenthesizedExpr) {
        return exprList;
      }
      toReferencedListDeep(exprList, isParenthesizedExpr) {
        this.toReferencedList(exprList, isParenthesizedExpr);
        for (const expr of exprList) {
          if ((expr == null ? void 0 : expr.type) === "ArrayExpression") {
            this.toReferencedListDeep(expr.elements);
          }
        }
      }
      parseSpread(refExpressionErrors) {
        const node = this.startNode();
        this.next();
        node.argument = this.parseMaybeAssignAllowIn(refExpressionErrors, void 0);
        return this.finishNode(node, "SpreadElement");
      }
      parseRestBinding() {
        const node = this.startNode();
        this.next();
        node.argument = this.parseBindingAtom();
        return this.finishNode(node, "RestElement");
      }
      parseBindingAtom() {
        switch (this.state.type) {
          case 0: {
            const node = this.startNode();
            this.next();
            node.elements = this.parseBindingList(3, 93, 1);
            return this.finishNode(node, "ArrayPattern");
          }
          case 5:
            return this.parseObjectLike(8, true);
        }
        return this.parseIdentifier();
      }
      parseBindingList(close, closeCharCode, flags) {
        const allowEmpty = flags & 1;
        const elts = [];
        let first = true;
        while (!this.eat(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(12);
          }
          if (allowEmpty && this.match(12)) {
            elts.push(null);
          } else if (this.eat(close)) {
            break;
          } else if (this.match(21)) {
            let rest = this.parseRestBinding();
            if (this.hasPlugin("flow") || flags & 2) {
              rest = this.parseFunctionParamType(rest);
            }
            elts.push(rest);
            if (!this.checkCommaAfterRest(closeCharCode)) {
              this.expect(close);
              break;
            }
          } else {
            const decorators = [];
            if (flags & 2) {
              if (this.match(26) && this.hasPlugin("decorators")) {
                this.raise(Errors.UnsupportedParameterDecorator, this.state.startLoc);
              }
              while (this.match(26)) {
                decorators.push(this.parseDecorator());
              }
            }
            elts.push(this.parseBindingElement(flags, decorators));
          }
        }
        return elts;
      }
      parseBindingRestProperty(prop) {
        this.next();
        prop.argument = this.parseIdentifier();
        this.checkCommaAfterRest(125);
        return this.finishNode(prop, "RestElement");
      }
      parseBindingProperty() {
        const {
          type,
          startLoc
        } = this.state;
        if (type === 21) {
          return this.parseBindingRestProperty(this.startNode());
        }
        const prop = this.startNode();
        if (type === 139) {
          this.expectPlugin("destructuringPrivate", startLoc);
          this.classScope.usePrivateName(this.state.value, startLoc);
          prop.key = this.parsePrivateName();
        } else {
          this.parsePropertyName(prop);
        }
        prop.method = false;
        return this.parseObjPropValue(prop, startLoc, false, false, true, false);
      }
      parseBindingElement(flags, decorators) {
        const left = this.parseMaybeDefault();
        if (this.hasPlugin("flow") || flags & 2) {
          this.parseFunctionParamType(left);
        }
        const elt = this.parseMaybeDefault(left.loc.start, left);
        if (decorators.length) {
          left.decorators = decorators;
        }
        return elt;
      }
      parseFunctionParamType(param) {
        return param;
      }
      parseMaybeDefault(startLoc, left) {
        startLoc != null ? startLoc : startLoc = this.state.startLoc;
        left = left != null ? left : this.parseBindingAtom();
        if (!this.eat(29)) return left;
        const node = this.startNodeAt(startLoc);
        node.left = left;
        node.right = this.parseMaybeAssignAllowIn();
        return this.finishNode(node, "AssignmentPattern");
      }
      isValidLVal(type, isUnparenthesizedInAssign, binding) {
        switch (type) {
          case "AssignmentPattern":
            return "left";
          case "RestElement":
            return "argument";
          case "ObjectProperty":
            return "value";
          case "ParenthesizedExpression":
            return "expression";
          case "ArrayPattern":
            return "elements";
          case "ObjectPattern":
            return "properties";
        }
        return false;
      }
      isOptionalMemberExpression(expression) {
        return expression.type === "OptionalMemberExpression";
      }
      checkLVal(expression, ancestor, binding = 64, checkClashes = false, strictModeChanged = false, hasParenthesizedAncestor = false) {
        var _expression$extra;
        const type = expression.type;
        if (this.isObjectMethod(expression)) return;
        const isOptionalMemberExpression2 = this.isOptionalMemberExpression(expression);
        if (isOptionalMemberExpression2 || type === "MemberExpression") {
          if (isOptionalMemberExpression2) {
            this.expectPlugin("optionalChainingAssign", expression.loc.start);
            if (ancestor.type !== "AssignmentExpression") {
              this.raise(Errors.InvalidLhsOptionalChaining, expression, {
                ancestor
              });
            }
          }
          if (binding !== 64) {
            this.raise(Errors.InvalidPropertyBindingPattern, expression);
          }
          return;
        }
        if (type === "Identifier") {
          this.checkIdentifier(expression, binding, strictModeChanged);
          const {
            name
          } = expression;
          if (checkClashes) {
            if (checkClashes.has(name)) {
              this.raise(Errors.ParamDupe, expression);
            } else {
              checkClashes.add(name);
            }
          }
          return;
        }
        const validity = this.isValidLVal(type, !(hasParenthesizedAncestor || (_expression$extra = expression.extra) != null && _expression$extra.parenthesized) && ancestor.type === "AssignmentExpression", binding);
        if (validity === true) return;
        if (validity === false) {
          const ParseErrorClass = binding === 64 ? Errors.InvalidLhs : Errors.InvalidLhsBinding;
          this.raise(ParseErrorClass, expression, {
            ancestor
          });
          return;
        }
        let key2, isParenthesizedExpression;
        if (typeof validity === "string") {
          key2 = validity;
          isParenthesizedExpression = type === "ParenthesizedExpression";
        } else {
          [key2, isParenthesizedExpression] = validity;
        }
        const nextAncestor = type === "ArrayPattern" || type === "ObjectPattern" ? {
          type
        } : ancestor;
        const val = expression[key2];
        if (Array.isArray(val)) {
          for (const child of val) {
            if (child) {
              this.checkLVal(child, nextAncestor, binding, checkClashes, strictModeChanged, isParenthesizedExpression);
            }
          }
        } else if (val) {
          this.checkLVal(val, nextAncestor, binding, checkClashes, strictModeChanged, isParenthesizedExpression);
        }
      }
      checkIdentifier(at, bindingType, strictModeChanged = false) {
        if (this.state.strict && (strictModeChanged ? isStrictBindReservedWord(at.name, this.inModule) : isStrictBindOnlyReservedWord(at.name))) {
          if (bindingType === 64) {
            this.raise(Errors.StrictEvalArguments, at, {
              referenceName: at.name
            });
          } else {
            this.raise(Errors.StrictEvalArgumentsBinding, at, {
              bindingName: at.name
            });
          }
        }
        if (bindingType & 8192 && at.name === "let") {
          this.raise(Errors.LetInLexicalBinding, at);
        }
        if (!(bindingType & 64)) {
          this.declareNameFromIdentifier(at, bindingType);
        }
      }
      declareNameFromIdentifier(identifier4, binding) {
        this.scope.declareName(identifier4.name, binding, identifier4.loc.start);
      }
      checkToRestConversion(node, allowPattern) {
        switch (node.type) {
          case "ParenthesizedExpression":
            this.checkToRestConversion(node.expression, allowPattern);
            break;
          case "Identifier":
          case "MemberExpression":
            break;
          case "ArrayExpression":
          case "ObjectExpression":
            if (allowPattern) break;
          default:
            this.raise(Errors.InvalidRestAssignmentPattern, node);
        }
      }
      checkCommaAfterRest(close) {
        if (!this.match(12)) {
          return false;
        }
        this.raise(this.lookaheadCharCode() === close ? Errors.RestTrailingComma : Errors.ElementAfterRest, this.state.startLoc);
        return true;
      }
    };
    function nonNull2(x) {
      if (x == null) {
        throw new Error(`Unexpected ${x} value.`);
      }
      return x;
    }
    function assert2(x) {
      if (!x) {
        throw new Error("Assert fail");
      }
    }
    var TSErrors = ParseErrorEnum`typescript`({
      AbstractMethodHasImplementation: ({
        methodName
      }) => `Method '${methodName}' cannot have an implementation because it is marked abstract.`,
      AbstractPropertyHasInitializer: ({
        propertyName
      }) => `Property '${propertyName}' cannot have an initializer because it is marked abstract.`,
      AccessorCannotBeOptional: "An 'accessor' property cannot be declared optional.",
      AccessorCannotDeclareThisParameter: "'get' and 'set' accessors cannot declare 'this' parameters.",
      AccessorCannotHaveTypeParameters: "An accessor cannot have type parameters.",
      ClassMethodHasDeclare: "Class methods cannot have the 'declare' modifier.",
      ClassMethodHasReadonly: "Class methods cannot have the 'readonly' modifier.",
      ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference: "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference.",
      ConstructorHasTypeParameters: "Type parameters cannot appear on a constructor declaration.",
      DeclareAccessor: ({
        kind
      }) => `'declare' is not allowed in ${kind}ters.`,
      DeclareClassFieldHasInitializer: "Initializers are not allowed in ambient contexts.",
      DeclareFunctionHasImplementation: "An implementation cannot be declared in ambient contexts.",
      DuplicateAccessibilityModifier: ({
        modifier
      }) => `Accessibility modifier already seen.`,
      DuplicateModifier: ({
        modifier
      }) => `Duplicate modifier: '${modifier}'.`,
      EmptyHeritageClauseType: ({
        token: token2
      }) => `'${token2}' list cannot be empty.`,
      EmptyTypeArguments: "Type argument list cannot be empty.",
      EmptyTypeParameters: "Type parameter list cannot be empty.",
      ExpectedAmbientAfterExportDeclare: "'export declare' must be followed by an ambient declaration.",
      ImportAliasHasImportType: "An import alias can not use 'import type'.",
      ImportReflectionHasImportType: "An `import module` declaration can not use `type` modifier",
      IncompatibleModifiers: ({
        modifiers
      }) => `'${modifiers[0]}' modifier cannot be used with '${modifiers[1]}' modifier.`,
      IndexSignatureHasAbstract: "Index signatures cannot have the 'abstract' modifier.",
      IndexSignatureHasAccessibility: ({
        modifier
      }) => `Index signatures cannot have an accessibility modifier ('${modifier}').`,
      IndexSignatureHasDeclare: "Index signatures cannot have the 'declare' modifier.",
      IndexSignatureHasOverride: "'override' modifier cannot appear on an index signature.",
      IndexSignatureHasStatic: "Index signatures cannot have the 'static' modifier.",
      InitializerNotAllowedInAmbientContext: "Initializers are not allowed in ambient contexts.",
      InvalidHeritageClauseType: ({
        token: token2
      }) => `'${token2}' list can only include identifiers or qualified-names with optional type arguments.`,
      InvalidModifierOnTypeMember: ({
        modifier
      }) => `'${modifier}' modifier cannot appear on a type member.`,
      InvalidModifierOnTypeParameter: ({
        modifier
      }) => `'${modifier}' modifier cannot appear on a type parameter.`,
      InvalidModifierOnTypeParameterPositions: ({
        modifier
      }) => `'${modifier}' modifier can only appear on a type parameter of a class, interface or type alias.`,
      InvalidModifiersOrder: ({
        orderedModifiers
      }) => `'${orderedModifiers[0]}' modifier must precede '${orderedModifiers[1]}' modifier.`,
      InvalidPropertyAccessAfterInstantiationExpression: "Invalid property access after an instantiation expression. You can either wrap the instantiation expression in parentheses, or delete the type arguments.",
      InvalidTupleMemberLabel: "Tuple members must be labeled with a simple identifier.",
      MissingInterfaceName: "'interface' declarations must be followed by an identifier.",
      NonAbstractClassHasAbstractMethod: "Abstract methods can only appear within an abstract class.",
      NonClassMethodPropertyHasAbstractModifer: "'abstract' modifier can only appear on a class, method, or property declaration.",
      OptionalTypeBeforeRequired: "A required element cannot follow an optional element.",
      OverrideNotInSubClass: "This member cannot have an 'override' modifier because its containing class does not extend another class.",
      PatternIsOptional: "A binding pattern parameter cannot be optional in an implementation signature.",
      PrivateElementHasAbstract: "Private elements cannot have the 'abstract' modifier.",
      PrivateElementHasAccessibility: ({
        modifier
      }) => `Private elements cannot have an accessibility modifier ('${modifier}').`,
      ReadonlyForMethodSignature: "'readonly' modifier can only appear on a property declaration or index signature.",
      ReservedArrowTypeParam: "This syntax is reserved in files with the .mts or .cts extension. Add a trailing comma, as in `<T,>() => ...`.",
      ReservedTypeAssertion: "This syntax is reserved in files with the .mts or .cts extension. Use an `as` expression instead.",
      SetAccessorCannotHaveOptionalParameter: "A 'set' accessor cannot have an optional parameter.",
      SetAccessorCannotHaveRestParameter: "A 'set' accessor cannot have rest parameter.",
      SetAccessorCannotHaveReturnType: "A 'set' accessor cannot have a return type annotation.",
      SingleTypeParameterWithoutTrailingComma: ({
        typeParameterName
      }) => `Single type parameter ${typeParameterName} should have a trailing comma. Example usage: <${typeParameterName},>.`,
      StaticBlockCannotHaveModifier: "Static class blocks cannot have any modifier.",
      TupleOptionalAfterType: "A labeled tuple optional element must be declared using a question mark after the name and before the colon (`name?: type`), rather than after the type (`name: type?`).",
      TypeAnnotationAfterAssign: "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
      TypeImportCannotSpecifyDefaultAndNamed: "A type-only import can specify a default import or named bindings, but not both.",
      TypeModifierIsUsedInTypeExports: "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement.",
      TypeModifierIsUsedInTypeImports: "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement.",
      UnexpectedParameterModifier: "A parameter property is only allowed in a constructor implementation.",
      UnexpectedReadonly: "'readonly' type modifier is only permitted on array and tuple literal types.",
      UnexpectedTypeAnnotation: "Did not expect a type annotation here.",
      UnexpectedTypeCastInParameter: "Unexpected type cast in parameter position.",
      UnsupportedImportTypeArgument: "Argument in a type import must be a string literal.",
      UnsupportedParameterPropertyKind: "A parameter property may not be declared using a binding pattern.",
      UnsupportedSignatureParameterKind: ({
        type
      }) => `Name in a signature must be an Identifier, ObjectPattern or ArrayPattern, instead got ${type}.`
    });
    function keywordTypeFromName(value) {
      switch (value) {
        case "any":
          return "TSAnyKeyword";
        case "boolean":
          return "TSBooleanKeyword";
        case "bigint":
          return "TSBigIntKeyword";
        case "never":
          return "TSNeverKeyword";
        case "number":
          return "TSNumberKeyword";
        case "object":
          return "TSObjectKeyword";
        case "string":
          return "TSStringKeyword";
        case "symbol":
          return "TSSymbolKeyword";
        case "undefined":
          return "TSUndefinedKeyword";
        case "unknown":
          return "TSUnknownKeyword";
        default:
          return void 0;
      }
    }
    function tsIsAccessModifier(modifier) {
      return modifier === "private" || modifier === "public" || modifier === "protected";
    }
    function tsIsVarianceAnnotations(modifier) {
      return modifier === "in" || modifier === "out";
    }
    var typescript = (superClass) => class TypeScriptParserMixin extends superClass {
      constructor(...args) {
        super(...args);
        this.tsParseInOutModifiers = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["in", "out"],
          disallowedModifiers: ["const", "public", "private", "protected", "readonly", "declare", "abstract", "override"],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameter
        });
        this.tsParseConstModifier = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["const"],
          disallowedModifiers: ["in", "out"],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions
        });
        this.tsParseInOutConstModifiers = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["in", "out", "const"],
          disallowedModifiers: ["public", "private", "protected", "readonly", "declare", "abstract", "override"],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameter
        });
      }
      getScopeHandler() {
        return TypeScriptScopeHandler;
      }
      tsIsIdentifier() {
        return tokenIsIdentifier(this.state.type);
      }
      tsTokenCanFollowModifier() {
        return this.match(0) || this.match(5) || this.match(55) || this.match(21) || this.match(139) || this.isLiteralPropertyName();
      }
      tsNextTokenOnSameLineAndCanFollowModifier() {
        this.next();
        if (this.hasPrecedingLineBreak()) {
          return false;
        }
        return this.tsTokenCanFollowModifier();
      }
      tsNextTokenCanFollowModifier() {
        if (this.match(106)) {
          this.next();
          return this.tsTokenCanFollowModifier();
        }
        return this.tsNextTokenOnSameLineAndCanFollowModifier();
      }
      tsParseModifier(allowedModifiers, stopOnStartOfClassStaticBlock) {
        if (!tokenIsIdentifier(this.state.type) && this.state.type !== 58 && this.state.type !== 75) {
          return void 0;
        }
        const modifier = this.state.value;
        if (allowedModifiers.includes(modifier)) {
          if (stopOnStartOfClassStaticBlock && this.tsIsStartOfStaticBlocks()) {
            return void 0;
          }
          if (this.tsTryParse(this.tsNextTokenCanFollowModifier.bind(this))) {
            return modifier;
          }
        }
        return void 0;
      }
      tsParseModifiers({
        allowedModifiers,
        disallowedModifiers,
        stopOnStartOfClassStaticBlock,
        errorTemplate = TSErrors.InvalidModifierOnTypeMember
      }, modified) {
        const enforceOrder = (loc, modifier, before, after) => {
          if (modifier === before && modified[after]) {
            this.raise(TSErrors.InvalidModifiersOrder, loc, {
              orderedModifiers: [before, after]
            });
          }
        };
        const incompatible = (loc, modifier, mod1, mod2) => {
          if (modified[mod1] && modifier === mod2 || modified[mod2] && modifier === mod1) {
            this.raise(TSErrors.IncompatibleModifiers, loc, {
              modifiers: [mod1, mod2]
            });
          }
        };
        for (; ; ) {
          const {
            startLoc
          } = this.state;
          const modifier = this.tsParseModifier(allowedModifiers.concat(disallowedModifiers != null ? disallowedModifiers : []), stopOnStartOfClassStaticBlock);
          if (!modifier) break;
          if (tsIsAccessModifier(modifier)) {
            if (modified.accessibility) {
              this.raise(TSErrors.DuplicateAccessibilityModifier, startLoc, {
                modifier
              });
            } else {
              enforceOrder(startLoc, modifier, modifier, "override");
              enforceOrder(startLoc, modifier, modifier, "static");
              enforceOrder(startLoc, modifier, modifier, "readonly");
              modified.accessibility = modifier;
            }
          } else if (tsIsVarianceAnnotations(modifier)) {
            if (modified[modifier]) {
              this.raise(TSErrors.DuplicateModifier, startLoc, {
                modifier
              });
            }
            modified[modifier] = true;
            enforceOrder(startLoc, modifier, "in", "out");
          } else {
            if (hasOwnProperty.call(modified, modifier)) {
              this.raise(TSErrors.DuplicateModifier, startLoc, {
                modifier
              });
            } else {
              enforceOrder(startLoc, modifier, "static", "readonly");
              enforceOrder(startLoc, modifier, "static", "override");
              enforceOrder(startLoc, modifier, "override", "readonly");
              enforceOrder(startLoc, modifier, "abstract", "override");
              incompatible(startLoc, modifier, "declare", "override");
              incompatible(startLoc, modifier, "static", "abstract");
            }
            modified[modifier] = true;
          }
          if (disallowedModifiers != null && disallowedModifiers.includes(modifier)) {
            this.raise(errorTemplate, startLoc, {
              modifier
            });
          }
        }
      }
      tsIsListTerminator(kind) {
        switch (kind) {
          case "EnumMembers":
          case "TypeMembers":
            return this.match(8);
          case "HeritageClauseElement":
            return this.match(5);
          case "TupleElementTypes":
            return this.match(3);
          case "TypeParametersOrArguments":
            return this.match(48);
        }
      }
      tsParseList(kind, parseElement) {
        const result = [];
        while (!this.tsIsListTerminator(kind)) {
          result.push(parseElement());
        }
        return result;
      }
      tsParseDelimitedList(kind, parseElement, refTrailingCommaPos) {
        return nonNull2(this.tsParseDelimitedListWorker(kind, parseElement, true, refTrailingCommaPos));
      }
      tsParseDelimitedListWorker(kind, parseElement, expectSuccess, refTrailingCommaPos) {
        const result = [];
        let trailingCommaPos = -1;
        for (; ; ) {
          if (this.tsIsListTerminator(kind)) {
            break;
          }
          trailingCommaPos = -1;
          const element = parseElement();
          if (element == null) {
            return void 0;
          }
          result.push(element);
          if (this.eat(12)) {
            trailingCommaPos = this.state.lastTokStartLoc.index;
            continue;
          }
          if (this.tsIsListTerminator(kind)) {
            break;
          }
          if (expectSuccess) {
            this.expect(12);
          }
          return void 0;
        }
        if (refTrailingCommaPos) {
          refTrailingCommaPos.value = trailingCommaPos;
        }
        return result;
      }
      tsParseBracketedList(kind, parseElement, bracket, skipFirstToken, refTrailingCommaPos) {
        if (!skipFirstToken) {
          if (bracket) {
            this.expect(0);
          } else {
            this.expect(47);
          }
        }
        const result = this.tsParseDelimitedList(kind, parseElement, refTrailingCommaPos);
        if (bracket) {
          this.expect(3);
        } else {
          this.expect(48);
        }
        return result;
      }
      tsParseImportType() {
        const node = this.startNode();
        this.expect(83);
        this.expect(10);
        if (!this.match(134)) {
          this.raise(TSErrors.UnsupportedImportTypeArgument, this.state.startLoc);
          {
            node.argument = super.parseExprAtom();
          }
        } else {
          {
            node.argument = this.parseStringLiteral(this.state.value);
          }
        }
        if (this.eat(12) && !this.match(11)) {
          node.options = super.parseMaybeAssignAllowIn();
          this.eat(12);
        } else {
          node.options = null;
        }
        this.expect(11);
        if (this.eat(16)) {
          node.qualifier = this.tsParseEntityName(1 | 2);
        }
        if (this.match(47)) {
          {
            node.typeParameters = this.tsParseTypeArguments();
          }
        }
        return this.finishNode(node, "TSImportType");
      }
      tsParseEntityName(flags) {
        let entity;
        if (flags & 1 && this.match(78)) {
          if (flags & 2) {
            entity = this.parseIdentifier(true);
          } else {
            const node = this.startNode();
            this.next();
            entity = this.finishNode(node, "ThisExpression");
          }
        } else {
          entity = this.parseIdentifier(!!(flags & 1));
        }
        while (this.eat(16)) {
          const node = this.startNodeAtNode(entity);
          node.left = entity;
          node.right = this.parseIdentifier(!!(flags & 1));
          entity = this.finishNode(node, "TSQualifiedName");
        }
        return entity;
      }
      tsParseTypeReference() {
        const node = this.startNode();
        node.typeName = this.tsParseEntityName(1);
        if (!this.hasPrecedingLineBreak() && this.match(47)) {
          {
            node.typeParameters = this.tsParseTypeArguments();
          }
        }
        return this.finishNode(node, "TSTypeReference");
      }
      tsParseThisTypePredicate(lhs) {
        this.next();
        const node = this.startNodeAtNode(lhs);
        node.parameterName = lhs;
        node.typeAnnotation = this.tsParseTypeAnnotation(false);
        node.asserts = false;
        return this.finishNode(node, "TSTypePredicate");
      }
      tsParseThisTypeNode() {
        const node = this.startNode();
        this.next();
        return this.finishNode(node, "TSThisType");
      }
      tsParseTypeQuery() {
        const node = this.startNode();
        this.expect(87);
        if (this.match(83)) {
          node.exprName = this.tsParseImportType();
        } else {
          {
            node.exprName = this.tsParseEntityName(1 | 2);
          }
        }
        if (!this.hasPrecedingLineBreak() && this.match(47)) {
          {
            node.typeParameters = this.tsParseTypeArguments();
          }
        }
        return this.finishNode(node, "TSTypeQuery");
      }
      tsParseTypeParameter(parseModifiers) {
        const node = this.startNode();
        parseModifiers(node);
        node.name = this.tsParseTypeParameterName();
        node.constraint = this.tsEatThenParseType(81);
        node.default = this.tsEatThenParseType(29);
        return this.finishNode(node, "TSTypeParameter");
      }
      tsTryParseTypeParameters(parseModifiers) {
        if (this.match(47)) {
          return this.tsParseTypeParameters(parseModifiers);
        }
      }
      tsParseTypeParameters(parseModifiers) {
        const node = this.startNode();
        if (this.match(47) || this.match(143)) {
          this.next();
        } else {
          this.unexpected();
        }
        const refTrailingCommaPos = {
          value: -1
        };
        node.params = this.tsParseBracketedList("TypeParametersOrArguments", this.tsParseTypeParameter.bind(this, parseModifiers), false, true, refTrailingCommaPos);
        if (node.params.length === 0) {
          this.raise(TSErrors.EmptyTypeParameters, node);
        }
        if (refTrailingCommaPos.value !== -1) {
          this.addExtra(node, "trailingComma", refTrailingCommaPos.value);
        }
        return this.finishNode(node, "TSTypeParameterDeclaration");
      }
      tsFillSignature(returnToken, signature) {
        const returnTokenRequired = returnToken === 19;
        const paramsKey = "parameters";
        const returnTypeKey = "typeAnnotation";
        signature.typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
        this.expect(10);
        signature[paramsKey] = this.tsParseBindingListForSignature();
        if (returnTokenRequired) {
          signature[returnTypeKey] = this.tsParseTypeOrTypePredicateAnnotation(returnToken);
        } else if (this.match(returnToken)) {
          signature[returnTypeKey] = this.tsParseTypeOrTypePredicateAnnotation(returnToken);
        }
      }
      tsParseBindingListForSignature() {
        const list = super.parseBindingList(11, 41, 2);
        for (const pattern of list) {
          const {
            type
          } = pattern;
          if (type === "AssignmentPattern" || type === "TSParameterProperty") {
            this.raise(TSErrors.UnsupportedSignatureParameterKind, pattern, {
              type
            });
          }
        }
        return list;
      }
      tsParseTypeMemberSemicolon() {
        if (!this.eat(12) && !this.isLineTerminator()) {
          this.expect(13);
        }
      }
      tsParseSignatureMember(kind, node) {
        this.tsFillSignature(14, node);
        this.tsParseTypeMemberSemicolon();
        return this.finishNode(node, kind);
      }
      tsIsUnambiguouslyIndexSignature() {
        this.next();
        if (tokenIsIdentifier(this.state.type)) {
          this.next();
          return this.match(14);
        }
        return false;
      }
      tsTryParseIndexSignature(node) {
        if (!(this.match(0) && this.tsLookAhead(this.tsIsUnambiguouslyIndexSignature.bind(this)))) {
          return;
        }
        this.expect(0);
        const id = this.parseIdentifier();
        id.typeAnnotation = this.tsParseTypeAnnotation();
        this.resetEndLocation(id);
        this.expect(3);
        node.parameters = [id];
        const type = this.tsTryParseTypeAnnotation();
        if (type) node.typeAnnotation = type;
        this.tsParseTypeMemberSemicolon();
        return this.finishNode(node, "TSIndexSignature");
      }
      tsParsePropertyOrMethodSignature(node, readonly2) {
        if (this.eat(17)) node.optional = true;
        const nodeAny = node;
        if (this.match(10) || this.match(47)) {
          if (readonly2) {
            this.raise(TSErrors.ReadonlyForMethodSignature, node);
          }
          const method = nodeAny;
          if (method.kind && this.match(47)) {
            this.raise(TSErrors.AccessorCannotHaveTypeParameters, this.state.curPosition());
          }
          this.tsFillSignature(14, method);
          this.tsParseTypeMemberSemicolon();
          const paramsKey = "parameters";
          const returnTypeKey = "typeAnnotation";
          if (method.kind === "get") {
            if (method[paramsKey].length > 0) {
              this.raise(Errors.BadGetterArity, this.state.curPosition());
              if (this.isThisParam(method[paramsKey][0])) {
                this.raise(TSErrors.AccessorCannotDeclareThisParameter, this.state.curPosition());
              }
            }
          } else if (method.kind === "set") {
            if (method[paramsKey].length !== 1) {
              this.raise(Errors.BadSetterArity, this.state.curPosition());
            } else {
              const firstParameter = method[paramsKey][0];
              if (this.isThisParam(firstParameter)) {
                this.raise(TSErrors.AccessorCannotDeclareThisParameter, this.state.curPosition());
              }
              if (firstParameter.type === "Identifier" && firstParameter.optional) {
                this.raise(TSErrors.SetAccessorCannotHaveOptionalParameter, this.state.curPosition());
              }
              if (firstParameter.type === "RestElement") {
                this.raise(TSErrors.SetAccessorCannotHaveRestParameter, this.state.curPosition());
              }
            }
            if (method[returnTypeKey]) {
              this.raise(TSErrors.SetAccessorCannotHaveReturnType, method[returnTypeKey]);
            }
          } else {
            method.kind = "method";
          }
          return this.finishNode(method, "TSMethodSignature");
        } else {
          const property = nodeAny;
          if (readonly2) property.readonly = true;
          const type = this.tsTryParseTypeAnnotation();
          if (type) property.typeAnnotation = type;
          this.tsParseTypeMemberSemicolon();
          return this.finishNode(property, "TSPropertySignature");
        }
      }
      tsParseTypeMember() {
        const node = this.startNode();
        if (this.match(10) || this.match(47)) {
          return this.tsParseSignatureMember("TSCallSignatureDeclaration", node);
        }
        if (this.match(77)) {
          const id = this.startNode();
          this.next();
          if (this.match(10) || this.match(47)) {
            return this.tsParseSignatureMember("TSConstructSignatureDeclaration", node);
          } else {
            node.key = this.createIdentifier(id, "new");
            return this.tsParsePropertyOrMethodSignature(node, false);
          }
        }
        this.tsParseModifiers({
          allowedModifiers: ["readonly"],
          disallowedModifiers: ["declare", "abstract", "private", "protected", "public", "static", "override"]
        }, node);
        const idx = this.tsTryParseIndexSignature(node);
        if (idx) {
          return idx;
        }
        super.parsePropertyName(node);
        if (!node.computed && node.key.type === "Identifier" && (node.key.name === "get" || node.key.name === "set") && this.tsTokenCanFollowModifier()) {
          node.kind = node.key.name;
          super.parsePropertyName(node);
        }
        return this.tsParsePropertyOrMethodSignature(node, !!node.readonly);
      }
      tsParseTypeLiteral() {
        const node = this.startNode();
        node.members = this.tsParseObjectTypeMembers();
        return this.finishNode(node, "TSTypeLiteral");
      }
      tsParseObjectTypeMembers() {
        this.expect(5);
        const members = this.tsParseList("TypeMembers", this.tsParseTypeMember.bind(this));
        this.expect(8);
        return members;
      }
      tsIsStartOfMappedType() {
        this.next();
        if (this.eat(53)) {
          return this.isContextual(122);
        }
        if (this.isContextual(122)) {
          this.next();
        }
        if (!this.match(0)) {
          return false;
        }
        this.next();
        if (!this.tsIsIdentifier()) {
          return false;
        }
        this.next();
        return this.match(58);
      }
      tsParseMappedType() {
        const node = this.startNode();
        this.expect(5);
        if (this.match(53)) {
          node.readonly = this.state.value;
          this.next();
          this.expectContextual(122);
        } else if (this.eatContextual(122)) {
          node.readonly = true;
        }
        this.expect(0);
        {
          const typeParameter = this.startNode();
          typeParameter.name = this.tsParseTypeParameterName();
          typeParameter.constraint = this.tsExpectThenParseType(58);
          node.typeParameter = this.finishNode(typeParameter, "TSTypeParameter");
        }
        node.nameType = this.eatContextual(93) ? this.tsParseType() : null;
        this.expect(3);
        if (this.match(53)) {
          node.optional = this.state.value;
          this.next();
          this.expect(17);
        } else if (this.eat(17)) {
          node.optional = true;
        }
        node.typeAnnotation = this.tsTryParseType();
        this.semicolon();
        this.expect(8);
        return this.finishNode(node, "TSMappedType");
      }
      tsParseTupleType() {
        const node = this.startNode();
        node.elementTypes = this.tsParseBracketedList("TupleElementTypes", this.tsParseTupleElementType.bind(this), true, false);
        let seenOptionalElement = false;
        node.elementTypes.forEach((elementNode) => {
          const {
            type
          } = elementNode;
          if (seenOptionalElement && type !== "TSRestType" && type !== "TSOptionalType" && !(type === "TSNamedTupleMember" && elementNode.optional)) {
            this.raise(TSErrors.OptionalTypeBeforeRequired, elementNode);
          }
          seenOptionalElement || (seenOptionalElement = type === "TSNamedTupleMember" && elementNode.optional || type === "TSOptionalType");
        });
        return this.finishNode(node, "TSTupleType");
      }
      tsParseTupleElementType() {
        const restStartLoc = this.state.startLoc;
        const rest = this.eat(21);
        const {
          startLoc
        } = this.state;
        let labeled;
        let label;
        let optional2;
        let type;
        const isWord = tokenIsKeywordOrIdentifier(this.state.type);
        const chAfterWord = isWord ? this.lookaheadCharCode() : null;
        if (chAfterWord === 58) {
          labeled = true;
          optional2 = false;
          label = this.parseIdentifier(true);
          this.expect(14);
          type = this.tsParseType();
        } else if (chAfterWord === 63) {
          optional2 = true;
          const wordName = this.state.value;
          const typeOrLabel = this.tsParseNonArrayType();
          if (this.lookaheadCharCode() === 58) {
            labeled = true;
            label = this.createIdentifier(this.startNodeAt(startLoc), wordName);
            this.expect(17);
            this.expect(14);
            type = this.tsParseType();
          } else {
            labeled = false;
            type = typeOrLabel;
            this.expect(17);
          }
        } else {
          type = this.tsParseType();
          optional2 = this.eat(17);
          labeled = this.eat(14);
        }
        if (labeled) {
          let labeledNode;
          if (label) {
            labeledNode = this.startNodeAt(startLoc);
            labeledNode.optional = optional2;
            labeledNode.label = label;
            labeledNode.elementType = type;
            if (this.eat(17)) {
              labeledNode.optional = true;
              this.raise(TSErrors.TupleOptionalAfterType, this.state.lastTokStartLoc);
            }
          } else {
            labeledNode = this.startNodeAt(startLoc);
            labeledNode.optional = optional2;
            this.raise(TSErrors.InvalidTupleMemberLabel, type);
            labeledNode.label = type;
            labeledNode.elementType = this.tsParseType();
          }
          type = this.finishNode(labeledNode, "TSNamedTupleMember");
        } else if (optional2) {
          const optionalTypeNode = this.startNodeAt(startLoc);
          optionalTypeNode.typeAnnotation = type;
          type = this.finishNode(optionalTypeNode, "TSOptionalType");
        }
        if (rest) {
          const restNode = this.startNodeAt(restStartLoc);
          restNode.typeAnnotation = type;
          type = this.finishNode(restNode, "TSRestType");
        }
        return type;
      }
      tsParseParenthesizedType() {
        const node = this.startNode();
        this.expect(10);
        node.typeAnnotation = this.tsParseType();
        this.expect(11);
        return this.finishNode(node, "TSParenthesizedType");
      }
      tsParseFunctionOrConstructorType(type, abstract) {
        const node = this.startNode();
        if (type === "TSConstructorType") {
          node.abstract = !!abstract;
          if (abstract) this.next();
          this.next();
        }
        this.tsInAllowConditionalTypesContext(() => this.tsFillSignature(19, node));
        return this.finishNode(node, type);
      }
      tsParseLiteralTypeNode() {
        const node = this.startNode();
        switch (this.state.type) {
          case 135:
          case 136:
          case 134:
          case 85:
          case 86:
            node.literal = super.parseExprAtom();
            break;
          default:
            this.unexpected();
        }
        return this.finishNode(node, "TSLiteralType");
      }
      tsParseTemplateLiteralType() {
        {
          const node = this.startNode();
          node.literal = super.parseTemplate(false);
          return this.finishNode(node, "TSLiteralType");
        }
      }
      parseTemplateSubstitution() {
        if (this.state.inType) return this.tsParseType();
        return super.parseTemplateSubstitution();
      }
      tsParseThisTypeOrThisTypePredicate() {
        const thisKeyword = this.tsParseThisTypeNode();
        if (this.isContextual(116) && !this.hasPrecedingLineBreak()) {
          return this.tsParseThisTypePredicate(thisKeyword);
        } else {
          return thisKeyword;
        }
      }
      tsParseNonArrayType() {
        switch (this.state.type) {
          case 134:
          case 135:
          case 136:
          case 85:
          case 86:
            return this.tsParseLiteralTypeNode();
          case 53:
            if (this.state.value === "-") {
              const node = this.startNode();
              const nextToken = this.lookahead();
              if (nextToken.type !== 135 && nextToken.type !== 136) {
                this.unexpected();
              }
              node.literal = this.parseMaybeUnary();
              return this.finishNode(node, "TSLiteralType");
            }
            break;
          case 78:
            return this.tsParseThisTypeOrThisTypePredicate();
          case 87:
            return this.tsParseTypeQuery();
          case 83:
            return this.tsParseImportType();
          case 5:
            return this.tsLookAhead(this.tsIsStartOfMappedType.bind(this)) ? this.tsParseMappedType() : this.tsParseTypeLiteral();
          case 0:
            return this.tsParseTupleType();
          case 10:
            return this.tsParseParenthesizedType();
          case 25:
          case 24:
            return this.tsParseTemplateLiteralType();
          default: {
            const {
              type
            } = this.state;
            if (tokenIsIdentifier(type) || type === 88 || type === 84) {
              const nodeType = type === 88 ? "TSVoidKeyword" : type === 84 ? "TSNullKeyword" : keywordTypeFromName(this.state.value);
              if (nodeType !== void 0 && this.lookaheadCharCode() !== 46) {
                const node = this.startNode();
                this.next();
                return this.finishNode(node, nodeType);
              }
              return this.tsParseTypeReference();
            }
          }
        }
        this.unexpected();
      }
      tsParseArrayTypeOrHigher() {
        const {
          startLoc
        } = this.state;
        let type = this.tsParseNonArrayType();
        while (!this.hasPrecedingLineBreak() && this.eat(0)) {
          if (this.match(3)) {
            const node = this.startNodeAt(startLoc);
            node.elementType = type;
            this.expect(3);
            type = this.finishNode(node, "TSArrayType");
          } else {
            const node = this.startNodeAt(startLoc);
            node.objectType = type;
            node.indexType = this.tsParseType();
            this.expect(3);
            type = this.finishNode(node, "TSIndexedAccessType");
          }
        }
        return type;
      }
      tsParseTypeOperator() {
        const node = this.startNode();
        const operator = this.state.value;
        this.next();
        node.operator = operator;
        node.typeAnnotation = this.tsParseTypeOperatorOrHigher();
        if (operator === "readonly") {
          this.tsCheckTypeAnnotationForReadOnly(node);
        }
        return this.finishNode(node, "TSTypeOperator");
      }
      tsCheckTypeAnnotationForReadOnly(node) {
        switch (node.typeAnnotation.type) {
          case "TSTupleType":
          case "TSArrayType":
            return;
          default:
            this.raise(TSErrors.UnexpectedReadonly, node);
        }
      }
      tsParseInferType() {
        const node = this.startNode();
        this.expectContextual(115);
        const typeParameter = this.startNode();
        typeParameter.name = this.tsParseTypeParameterName();
        typeParameter.constraint = this.tsTryParse(() => this.tsParseConstraintForInferType());
        node.typeParameter = this.finishNode(typeParameter, "TSTypeParameter");
        return this.finishNode(node, "TSInferType");
      }
      tsParseConstraintForInferType() {
        if (this.eat(81)) {
          const constraint = this.tsInDisallowConditionalTypesContext(() => this.tsParseType());
          if (this.state.inDisallowConditionalTypesContext || !this.match(17)) {
            return constraint;
          }
        }
      }
      tsParseTypeOperatorOrHigher() {
        const isTypeOperator = tokenIsTSTypeOperator(this.state.type) && !this.state.containsEsc;
        return isTypeOperator ? this.tsParseTypeOperator() : this.isContextual(115) ? this.tsParseInferType() : this.tsInAllowConditionalTypesContext(() => this.tsParseArrayTypeOrHigher());
      }
      tsParseUnionOrIntersectionType(kind, parseConstituentType, operator) {
        const node = this.startNode();
        const hasLeadingOperator = this.eat(operator);
        const types2 = [];
        do {
          types2.push(parseConstituentType());
        } while (this.eat(operator));
        if (types2.length === 1 && !hasLeadingOperator) {
          return types2[0];
        }
        node.types = types2;
        return this.finishNode(node, kind);
      }
      tsParseIntersectionTypeOrHigher() {
        return this.tsParseUnionOrIntersectionType("TSIntersectionType", this.tsParseTypeOperatorOrHigher.bind(this), 45);
      }
      tsParseUnionTypeOrHigher() {
        return this.tsParseUnionOrIntersectionType("TSUnionType", this.tsParseIntersectionTypeOrHigher.bind(this), 43);
      }
      tsIsStartOfFunctionType() {
        if (this.match(47)) {
          return true;
        }
        return this.match(10) && this.tsLookAhead(this.tsIsUnambiguouslyStartOfFunctionType.bind(this));
      }
      tsSkipParameterStart() {
        if (tokenIsIdentifier(this.state.type) || this.match(78)) {
          this.next();
          return true;
        }
        if (this.match(5)) {
          const {
            errors
          } = this.state;
          const previousErrorCount = errors.length;
          try {
            this.parseObjectLike(8, true);
            return errors.length === previousErrorCount;
          } catch (_unused) {
            return false;
          }
        }
        if (this.match(0)) {
          this.next();
          const {
            errors
          } = this.state;
          const previousErrorCount = errors.length;
          try {
            super.parseBindingList(3, 93, 1);
            return errors.length === previousErrorCount;
          } catch (_unused2) {
            return false;
          }
        }
        return false;
      }
      tsIsUnambiguouslyStartOfFunctionType() {
        this.next();
        if (this.match(11) || this.match(21)) {
          return true;
        }
        if (this.tsSkipParameterStart()) {
          if (this.match(14) || this.match(12) || this.match(17) || this.match(29)) {
            return true;
          }
          if (this.match(11)) {
            this.next();
            if (this.match(19)) {
              return true;
            }
          }
        }
        return false;
      }
      tsParseTypeOrTypePredicateAnnotation(returnToken) {
        return this.tsInType(() => {
          const t6 = this.startNode();
          this.expect(returnToken);
          const node = this.startNode();
          const asserts = !!this.tsTryParse(this.tsParseTypePredicateAsserts.bind(this));
          if (asserts && this.match(78)) {
            let thisTypePredicate = this.tsParseThisTypeOrThisTypePredicate();
            if (thisTypePredicate.type === "TSThisType") {
              node.parameterName = thisTypePredicate;
              node.asserts = true;
              node.typeAnnotation = null;
              thisTypePredicate = this.finishNode(node, "TSTypePredicate");
            } else {
              this.resetStartLocationFromNode(thisTypePredicate, node);
              thisTypePredicate.asserts = true;
            }
            t6.typeAnnotation = thisTypePredicate;
            return this.finishNode(t6, "TSTypeAnnotation");
          }
          const typePredicateVariable = this.tsIsIdentifier() && this.tsTryParse(this.tsParseTypePredicatePrefix.bind(this));
          if (!typePredicateVariable) {
            if (!asserts) {
              return this.tsParseTypeAnnotation(false, t6);
            }
            node.parameterName = this.parseIdentifier();
            node.asserts = asserts;
            node.typeAnnotation = null;
            t6.typeAnnotation = this.finishNode(node, "TSTypePredicate");
            return this.finishNode(t6, "TSTypeAnnotation");
          }
          const type = this.tsParseTypeAnnotation(false);
          node.parameterName = typePredicateVariable;
          node.typeAnnotation = type;
          node.asserts = asserts;
          t6.typeAnnotation = this.finishNode(node, "TSTypePredicate");
          return this.finishNode(t6, "TSTypeAnnotation");
        });
      }
      tsTryParseTypeOrTypePredicateAnnotation() {
        if (this.match(14)) {
          return this.tsParseTypeOrTypePredicateAnnotation(14);
        }
      }
      tsTryParseTypeAnnotation() {
        if (this.match(14)) {
          return this.tsParseTypeAnnotation();
        }
      }
      tsTryParseType() {
        return this.tsEatThenParseType(14);
      }
      tsParseTypePredicatePrefix() {
        const id = this.parseIdentifier();
        if (this.isContextual(116) && !this.hasPrecedingLineBreak()) {
          this.next();
          return id;
        }
      }
      tsParseTypePredicateAsserts() {
        if (this.state.type !== 109) {
          return false;
        }
        const containsEsc = this.state.containsEsc;
        this.next();
        if (!tokenIsIdentifier(this.state.type) && !this.match(78)) {
          return false;
        }
        if (containsEsc) {
          this.raise(Errors.InvalidEscapedReservedWord, this.state.lastTokStartLoc, {
            reservedWord: "asserts"
          });
        }
        return true;
      }
      tsParseTypeAnnotation(eatColon = true, t6 = this.startNode()) {
        this.tsInType(() => {
          if (eatColon) this.expect(14);
          t6.typeAnnotation = this.tsParseType();
        });
        return this.finishNode(t6, "TSTypeAnnotation");
      }
      tsParseType() {
        assert2(this.state.inType);
        const type = this.tsParseNonConditionalType();
        if (this.state.inDisallowConditionalTypesContext || this.hasPrecedingLineBreak() || !this.eat(81)) {
          return type;
        }
        const node = this.startNodeAtNode(type);
        node.checkType = type;
        node.extendsType = this.tsInDisallowConditionalTypesContext(() => this.tsParseNonConditionalType());
        this.expect(17);
        node.trueType = this.tsInAllowConditionalTypesContext(() => this.tsParseType());
        this.expect(14);
        node.falseType = this.tsInAllowConditionalTypesContext(() => this.tsParseType());
        return this.finishNode(node, "TSConditionalType");
      }
      isAbstractConstructorSignature() {
        return this.isContextual(124) && this.lookahead().type === 77;
      }
      tsParseNonConditionalType() {
        if (this.tsIsStartOfFunctionType()) {
          return this.tsParseFunctionOrConstructorType("TSFunctionType");
        }
        if (this.match(77)) {
          return this.tsParseFunctionOrConstructorType("TSConstructorType");
        } else if (this.isAbstractConstructorSignature()) {
          return this.tsParseFunctionOrConstructorType("TSConstructorType", true);
        }
        return this.tsParseUnionTypeOrHigher();
      }
      tsParseTypeAssertion() {
        if (this.getPluginOption("typescript", "disallowAmbiguousJSXLike")) {
          this.raise(TSErrors.ReservedTypeAssertion, this.state.startLoc);
        }
        const node = this.startNode();
        node.typeAnnotation = this.tsInType(() => {
          this.next();
          return this.match(75) ? this.tsParseTypeReference() : this.tsParseType();
        });
        this.expect(48);
        node.expression = this.parseMaybeUnary();
        return this.finishNode(node, "TSTypeAssertion");
      }
      tsParseHeritageClause(token2) {
        const originalStartLoc = this.state.startLoc;
        const delimitedList = this.tsParseDelimitedList("HeritageClauseElement", () => {
          {
            const node = this.startNode();
            node.expression = this.tsParseEntityName(1 | 2);
            if (this.match(47)) {
              node.typeParameters = this.tsParseTypeArguments();
            }
            return this.finishNode(node, "TSExpressionWithTypeArguments");
          }
        });
        if (!delimitedList.length) {
          this.raise(TSErrors.EmptyHeritageClauseType, originalStartLoc, {
            token: token2
          });
        }
        return delimitedList;
      }
      tsParseInterfaceDeclaration(node, properties = {}) {
        if (this.hasFollowingLineBreak()) return null;
        this.expectContextual(129);
        if (properties.declare) node.declare = true;
        if (tokenIsIdentifier(this.state.type)) {
          node.id = this.parseIdentifier();
          this.checkIdentifier(node.id, 130);
        } else {
          node.id = null;
          this.raise(TSErrors.MissingInterfaceName, this.state.startLoc);
        }
        node.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers);
        if (this.eat(81)) {
          node.extends = this.tsParseHeritageClause("extends");
        }
        const body = this.startNode();
        body.body = this.tsInType(this.tsParseObjectTypeMembers.bind(this));
        node.body = this.finishNode(body, "TSInterfaceBody");
        return this.finishNode(node, "TSInterfaceDeclaration");
      }
      tsParseTypeAliasDeclaration(node) {
        node.id = this.parseIdentifier();
        this.checkIdentifier(node.id, 2);
        node.typeAnnotation = this.tsInType(() => {
          node.typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutModifiers);
          this.expect(29);
          if (this.isContextual(114) && this.lookahead().type !== 16) {
            const node2 = this.startNode();
            this.next();
            return this.finishNode(node2, "TSIntrinsicKeyword");
          }
          return this.tsParseType();
        });
        this.semicolon();
        return this.finishNode(node, "TSTypeAliasDeclaration");
      }
      tsInTopLevelContext(cb) {
        if (this.curContext() !== types.brace) {
          const oldContext = this.state.context;
          this.state.context = [oldContext[0]];
          try {
            return cb();
          } finally {
            this.state.context = oldContext;
          }
        } else {
          return cb();
        }
      }
      tsInType(cb) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        try {
          return cb();
        } finally {
          this.state.inType = oldInType;
        }
      }
      tsInDisallowConditionalTypesContext(cb) {
        const oldInDisallowConditionalTypesContext = this.state.inDisallowConditionalTypesContext;
        this.state.inDisallowConditionalTypesContext = true;
        try {
          return cb();
        } finally {
          this.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
        }
      }
      tsInAllowConditionalTypesContext(cb) {
        const oldInDisallowConditionalTypesContext = this.state.inDisallowConditionalTypesContext;
        this.state.inDisallowConditionalTypesContext = false;
        try {
          return cb();
        } finally {
          this.state.inDisallowConditionalTypesContext = oldInDisallowConditionalTypesContext;
        }
      }
      tsEatThenParseType(token2) {
        if (this.match(token2)) {
          return this.tsNextThenParseType();
        }
      }
      tsExpectThenParseType(token2) {
        return this.tsInType(() => {
          this.expect(token2);
          return this.tsParseType();
        });
      }
      tsNextThenParseType() {
        return this.tsInType(() => {
          this.next();
          return this.tsParseType();
        });
      }
      tsParseEnumMember() {
        const node = this.startNode();
        node.id = this.match(134) ? super.parseStringLiteral(this.state.value) : this.parseIdentifier(true);
        if (this.eat(29)) {
          node.initializer = super.parseMaybeAssignAllowIn();
        }
        return this.finishNode(node, "TSEnumMember");
      }
      tsParseEnumDeclaration(node, properties = {}) {
        if (properties.const) node.const = true;
        if (properties.declare) node.declare = true;
        this.expectContextual(126);
        node.id = this.parseIdentifier();
        this.checkIdentifier(node.id, node.const ? 8971 : 8459);
        {
          this.expect(5);
          node.members = this.tsParseDelimitedList("EnumMembers", this.tsParseEnumMember.bind(this));
          this.expect(8);
        }
        return this.finishNode(node, "TSEnumDeclaration");
      }
      tsParseEnumBody() {
        const node = this.startNode();
        this.expect(5);
        node.members = this.tsParseDelimitedList("EnumMembers", this.tsParseEnumMember.bind(this));
        this.expect(8);
        return this.finishNode(node, "TSEnumBody");
      }
      tsParseModuleBlock() {
        const node = this.startNode();
        this.scope.enter(0);
        this.expect(5);
        super.parseBlockOrModuleBlockBody(node.body = [], void 0, true, 8);
        this.scope.exit();
        return this.finishNode(node, "TSModuleBlock");
      }
      tsParseModuleOrNamespaceDeclaration(node, nested = false) {
        node.id = this.parseIdentifier();
        if (!nested) {
          this.checkIdentifier(node.id, 1024);
        }
        if (this.eat(16)) {
          const inner = this.startNode();
          this.tsParseModuleOrNamespaceDeclaration(inner, true);
          node.body = inner;
        } else {
          this.scope.enter(256);
          this.prodParam.enter(0);
          node.body = this.tsParseModuleBlock();
          this.prodParam.exit();
          this.scope.exit();
        }
        return this.finishNode(node, "TSModuleDeclaration");
      }
      tsParseAmbientExternalModuleDeclaration(node) {
        if (this.isContextual(112)) {
          node.kind = "global";
          {
            node.global = true;
          }
          node.id = this.parseIdentifier();
        } else if (this.match(134)) {
          node.kind = "module";
          node.id = super.parseStringLiteral(this.state.value);
        } else {
          this.unexpected();
        }
        if (this.match(5)) {
          this.scope.enter(256);
          this.prodParam.enter(0);
          node.body = this.tsParseModuleBlock();
          this.prodParam.exit();
          this.scope.exit();
        } else {
          this.semicolon();
        }
        return this.finishNode(node, "TSModuleDeclaration");
      }
      tsParseImportEqualsDeclaration(node, maybeDefaultIdentifier, isExport) {
        {
          node.isExport = isExport || false;
        }
        node.id = maybeDefaultIdentifier || this.parseIdentifier();
        this.checkIdentifier(node.id, 4096);
        this.expect(29);
        const moduleReference = this.tsParseModuleReference();
        if (node.importKind === "type" && moduleReference.type !== "TSExternalModuleReference") {
          this.raise(TSErrors.ImportAliasHasImportType, moduleReference);
        }
        node.moduleReference = moduleReference;
        this.semicolon();
        return this.finishNode(node, "TSImportEqualsDeclaration");
      }
      tsIsExternalModuleReference() {
        return this.isContextual(119) && this.lookaheadCharCode() === 40;
      }
      tsParseModuleReference() {
        return this.tsIsExternalModuleReference() ? this.tsParseExternalModuleReference() : this.tsParseEntityName(0);
      }
      tsParseExternalModuleReference() {
        const node = this.startNode();
        this.expectContextual(119);
        this.expect(10);
        if (!this.match(134)) {
          this.unexpected();
        }
        node.expression = super.parseExprAtom();
        this.expect(11);
        this.sawUnambiguousESM = true;
        return this.finishNode(node, "TSExternalModuleReference");
      }
      tsLookAhead(f) {
        const state = this.state.clone();
        const res = f();
        this.state = state;
        return res;
      }
      tsTryParseAndCatch(f) {
        const result = this.tryParse((abort) => f() || abort());
        if (result.aborted || !result.node) return;
        if (result.error) this.state = result.failState;
        return result.node;
      }
      tsTryParse(f) {
        const state = this.state.clone();
        const result = f();
        if (result !== void 0 && result !== false) {
          return result;
        }
        this.state = state;
      }
      tsTryParseDeclare(nany) {
        if (this.isLineTerminator()) {
          return;
        }
        let startType = this.state.type;
        let kind;
        if (this.isContextual(100)) {
          startType = 74;
          kind = "let";
        }
        return this.tsInAmbientContext(() => {
          switch (startType) {
            case 68:
              nany.declare = true;
              return super.parseFunctionStatement(nany, false, false);
            case 80:
              nany.declare = true;
              return this.parseClass(nany, true, false);
            case 126:
              return this.tsParseEnumDeclaration(nany, {
                declare: true
              });
            case 112:
              return this.tsParseAmbientExternalModuleDeclaration(nany);
            case 75:
            case 74:
              if (!this.match(75) || !this.isLookaheadContextual("enum")) {
                nany.declare = true;
                return this.parseVarStatement(nany, kind || this.state.value, true);
              }
              this.expect(75);
              return this.tsParseEnumDeclaration(nany, {
                const: true,
                declare: true
              });
            case 129: {
              const result = this.tsParseInterfaceDeclaration(nany, {
                declare: true
              });
              if (result) return result;
            }
            default:
              if (tokenIsIdentifier(startType)) {
                return this.tsParseDeclaration(nany, this.state.value, true, null);
              }
          }
        });
      }
      tsTryParseExportDeclaration() {
        return this.tsParseDeclaration(this.startNode(), this.state.value, true, null);
      }
      tsParseExpressionStatement(node, expr, decorators) {
        switch (expr.name) {
          case "declare": {
            const declaration = this.tsTryParseDeclare(node);
            if (declaration) {
              declaration.declare = true;
            }
            return declaration;
          }
          case "global":
            if (this.match(5)) {
              this.scope.enter(256);
              this.prodParam.enter(0);
              const mod = node;
              mod.kind = "global";
              {
                node.global = true;
              }
              mod.id = expr;
              mod.body = this.tsParseModuleBlock();
              this.scope.exit();
              this.prodParam.exit();
              return this.finishNode(mod, "TSModuleDeclaration");
            }
            break;
          default:
            return this.tsParseDeclaration(node, expr.name, false, decorators);
        }
      }
      tsParseDeclaration(node, value, next, decorators) {
        switch (value) {
          case "abstract":
            if (this.tsCheckLineTerminator(next) && (this.match(80) || tokenIsIdentifier(this.state.type))) {
              return this.tsParseAbstractDeclaration(node, decorators);
            }
            break;
          case "module":
            if (this.tsCheckLineTerminator(next)) {
              if (this.match(134)) {
                return this.tsParseAmbientExternalModuleDeclaration(node);
              } else if (tokenIsIdentifier(this.state.type)) {
                node.kind = "module";
                return this.tsParseModuleOrNamespaceDeclaration(node);
              }
            }
            break;
          case "namespace":
            if (this.tsCheckLineTerminator(next) && tokenIsIdentifier(this.state.type)) {
              node.kind = "namespace";
              return this.tsParseModuleOrNamespaceDeclaration(node);
            }
            break;
          case "type":
            if (this.tsCheckLineTerminator(next) && tokenIsIdentifier(this.state.type)) {
              return this.tsParseTypeAliasDeclaration(node);
            }
            break;
        }
      }
      tsCheckLineTerminator(next) {
        if (next) {
          if (this.hasFollowingLineBreak()) return false;
          this.next();
          return true;
        }
        return !this.isLineTerminator();
      }
      tsTryParseGenericAsyncArrowFunction(startLoc) {
        if (!this.match(47)) return;
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        this.state.maybeInArrowParameters = true;
        const res = this.tsTryParseAndCatch(() => {
          const node = this.startNodeAt(startLoc);
          node.typeParameters = this.tsParseTypeParameters(this.tsParseConstModifier);
          super.parseFunctionParams(node);
          node.returnType = this.tsTryParseTypeOrTypePredicateAnnotation();
          this.expect(19);
          return node;
        });
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        if (!res) return;
        return super.parseArrowExpression(res, null, true);
      }
      tsParseTypeArgumentsInExpression() {
        if (this.reScan_lt() !== 47) return;
        return this.tsParseTypeArguments();
      }
      tsParseTypeArguments() {
        const node = this.startNode();
        node.params = this.tsInType(() => this.tsInTopLevelContext(() => {
          this.expect(47);
          return this.tsParseDelimitedList("TypeParametersOrArguments", this.tsParseType.bind(this));
        }));
        if (node.params.length === 0) {
          this.raise(TSErrors.EmptyTypeArguments, node);
        } else if (!this.state.inType && this.curContext() === types.brace) {
          this.reScan_lt_gt();
        }
        this.expect(48);
        return this.finishNode(node, "TSTypeParameterInstantiation");
      }
      tsIsDeclarationStart() {
        return tokenIsTSDeclarationStart(this.state.type);
      }
      isExportDefaultSpecifier() {
        if (this.tsIsDeclarationStart()) return false;
        return super.isExportDefaultSpecifier();
      }
      parseBindingElement(flags, decorators) {
        const startLoc = this.state.startLoc;
        const modified = {};
        this.tsParseModifiers({
          allowedModifiers: ["public", "private", "protected", "override", "readonly"]
        }, modified);
        const accessibility = modified.accessibility;
        const override = modified.override;
        const readonly2 = modified.readonly;
        if (!(flags & 4) && (accessibility || readonly2 || override)) {
          this.raise(TSErrors.UnexpectedParameterModifier, startLoc);
        }
        const left = this.parseMaybeDefault();
        if (flags & 2) {
          this.parseFunctionParamType(left);
        }
        const elt = this.parseMaybeDefault(left.loc.start, left);
        if (accessibility || readonly2 || override) {
          const pp = this.startNodeAt(startLoc);
          if (decorators.length) {
            pp.decorators = decorators;
          }
          if (accessibility) pp.accessibility = accessibility;
          if (readonly2) pp.readonly = readonly2;
          if (override) pp.override = override;
          if (elt.type !== "Identifier" && elt.type !== "AssignmentPattern") {
            this.raise(TSErrors.UnsupportedParameterPropertyKind, pp);
          }
          pp.parameter = elt;
          return this.finishNode(pp, "TSParameterProperty");
        }
        if (decorators.length) {
          left.decorators = decorators;
        }
        return elt;
      }
      isSimpleParameter(node) {
        return node.type === "TSParameterProperty" && super.isSimpleParameter(node.parameter) || super.isSimpleParameter(node);
      }
      tsDisallowOptionalPattern(node) {
        for (const param of node.params) {
          if (param.type !== "Identifier" && param.optional && !this.state.isAmbientContext) {
            this.raise(TSErrors.PatternIsOptional, param);
          }
        }
      }
      setArrowFunctionParameters(node, params, trailingCommaLoc) {
        super.setArrowFunctionParameters(node, params, trailingCommaLoc);
        this.tsDisallowOptionalPattern(node);
      }
      parseFunctionBodyAndFinish(node, type, isMethod = false) {
        if (this.match(14)) {
          node.returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
        }
        const bodilessType = type === "FunctionDeclaration" ? "TSDeclareFunction" : type === "ClassMethod" || type === "ClassPrivateMethod" ? "TSDeclareMethod" : void 0;
        if (bodilessType && !this.match(5) && this.isLineTerminator()) {
          return this.finishNode(node, bodilessType);
        }
        if (bodilessType === "TSDeclareFunction" && this.state.isAmbientContext) {
          this.raise(TSErrors.DeclareFunctionHasImplementation, node);
          if (node.declare) {
            return super.parseFunctionBodyAndFinish(node, bodilessType, isMethod);
          }
        }
        this.tsDisallowOptionalPattern(node);
        return super.parseFunctionBodyAndFinish(node, type, isMethod);
      }
      registerFunctionStatementId(node) {
        if (!node.body && node.id) {
          this.checkIdentifier(node.id, 1024);
        } else {
          super.registerFunctionStatementId(node);
        }
      }
      tsCheckForInvalidTypeCasts(items) {
        items.forEach((node) => {
          if ((node == null ? void 0 : node.type) === "TSTypeCastExpression") {
            this.raise(TSErrors.UnexpectedTypeAnnotation, node.typeAnnotation);
          }
        });
      }
      toReferencedList(exprList, isInParens) {
        this.tsCheckForInvalidTypeCasts(exprList);
        return exprList;
      }
      parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
        const node = super.parseArrayLike(close, canBePattern, isTuple, refExpressionErrors);
        if (node.type === "ArrayExpression") {
          this.tsCheckForInvalidTypeCasts(node.elements);
        }
        return node;
      }
      parseSubscript(base, startLoc, noCalls, state) {
        if (!this.hasPrecedingLineBreak() && this.match(35)) {
          this.state.canStartJSXElement = false;
          this.next();
          const nonNullExpression = this.startNodeAt(startLoc);
          nonNullExpression.expression = base;
          return this.finishNode(nonNullExpression, "TSNonNullExpression");
        }
        let isOptionalCall = false;
        if (this.match(18) && this.lookaheadCharCode() === 60) {
          if (noCalls) {
            state.stop = true;
            return base;
          }
          state.optionalChainMember = isOptionalCall = true;
          this.next();
        }
        if (this.match(47) || this.match(51)) {
          let missingParenErrorLoc;
          const result = this.tsTryParseAndCatch(() => {
            if (!noCalls && this.atPossibleAsyncArrow(base)) {
              const asyncArrowFn = this.tsTryParseGenericAsyncArrowFunction(startLoc);
              if (asyncArrowFn) {
                return asyncArrowFn;
              }
            }
            const typeArguments = this.tsParseTypeArgumentsInExpression();
            if (!typeArguments) return;
            if (isOptionalCall && !this.match(10)) {
              missingParenErrorLoc = this.state.curPosition();
              return;
            }
            if (tokenIsTemplate(this.state.type)) {
              const result2 = super.parseTaggedTemplateExpression(base, startLoc, state);
              {
                result2.typeParameters = typeArguments;
              }
              return result2;
            }
            if (!noCalls && this.eat(10)) {
              const node2 = this.startNodeAt(startLoc);
              node2.callee = base;
              node2.arguments = this.parseCallExpressionArguments(11);
              this.tsCheckForInvalidTypeCasts(node2.arguments);
              {
                node2.typeParameters = typeArguments;
              }
              if (state.optionalChainMember) {
                node2.optional = isOptionalCall;
              }
              return this.finishCallExpression(node2, state.optionalChainMember);
            }
            const tokenType = this.state.type;
            if (tokenType === 48 || tokenType === 52 || tokenType !== 10 && tokenCanStartExpression(tokenType) && !this.hasPrecedingLineBreak()) {
              return;
            }
            const node = this.startNodeAt(startLoc);
            node.expression = base;
            {
              node.typeParameters = typeArguments;
            }
            return this.finishNode(node, "TSInstantiationExpression");
          });
          if (missingParenErrorLoc) {
            this.unexpected(missingParenErrorLoc, 10);
          }
          if (result) {
            if (result.type === "TSInstantiationExpression" && (this.match(16) || this.match(18) && this.lookaheadCharCode() !== 40)) {
              this.raise(TSErrors.InvalidPropertyAccessAfterInstantiationExpression, this.state.startLoc);
            }
            return result;
          }
        }
        return super.parseSubscript(base, startLoc, noCalls, state);
      }
      parseNewCallee(node) {
        var _callee$extra;
        super.parseNewCallee(node);
        const {
          callee
        } = node;
        if (callee.type === "TSInstantiationExpression" && !((_callee$extra = callee.extra) != null && _callee$extra.parenthesized)) {
          {
            node.typeParameters = callee.typeParameters;
          }
          node.callee = callee.expression;
        }
      }
      parseExprOp(left, leftStartLoc, minPrec) {
        let isSatisfies;
        if (tokenOperatorPrecedence(58) > minPrec && !this.hasPrecedingLineBreak() && (this.isContextual(93) || (isSatisfies = this.isContextual(120)))) {
          const node = this.startNodeAt(leftStartLoc);
          node.expression = left;
          node.typeAnnotation = this.tsInType(() => {
            this.next();
            if (this.match(75)) {
              if (isSatisfies) {
                this.raise(Errors.UnexpectedKeyword, this.state.startLoc, {
                  keyword: "const"
                });
              }
              return this.tsParseTypeReference();
            }
            return this.tsParseType();
          });
          this.finishNode(node, isSatisfies ? "TSSatisfiesExpression" : "TSAsExpression");
          this.reScan_lt_gt();
          return this.parseExprOp(node, leftStartLoc, minPrec);
        }
        return super.parseExprOp(left, leftStartLoc, minPrec);
      }
      checkReservedWord(word, startLoc, checkKeywords, isBinding) {
        if (!this.state.isAmbientContext) {
          super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
        }
      }
      checkImportReflection(node) {
        super.checkImportReflection(node);
        if (node.module && node.importKind !== "value") {
          this.raise(TSErrors.ImportReflectionHasImportType, node.specifiers[0].loc.start);
        }
      }
      checkDuplicateExports() {
      }
      isPotentialImportPhase(isExport) {
        if (super.isPotentialImportPhase(isExport)) return true;
        if (this.isContextual(130)) {
          const ch = this.lookaheadCharCode();
          return isExport ? ch === 123 || ch === 42 : ch !== 61;
        }
        return !isExport && this.isContextual(87);
      }
      applyImportPhase(node, isExport, phase, loc) {
        super.applyImportPhase(node, isExport, phase, loc);
        if (isExport) {
          node.exportKind = phase === "type" ? "type" : "value";
        } else {
          node.importKind = phase === "type" || phase === "typeof" ? phase : "value";
        }
      }
      parseImport(node) {
        if (this.match(134)) {
          node.importKind = "value";
          return super.parseImport(node);
        }
        let importNode;
        if (tokenIsIdentifier(this.state.type) && this.lookaheadCharCode() === 61) {
          node.importKind = "value";
          return this.tsParseImportEqualsDeclaration(node);
        } else if (this.isContextual(130)) {
          const maybeDefaultIdentifier = this.parseMaybeImportPhase(node, false);
          if (this.lookaheadCharCode() === 61) {
            return this.tsParseImportEqualsDeclaration(node, maybeDefaultIdentifier);
          } else {
            importNode = super.parseImportSpecifiersAndAfter(node, maybeDefaultIdentifier);
          }
        } else {
          importNode = super.parseImport(node);
        }
        if (importNode.importKind === "type" && importNode.specifiers.length > 1 && importNode.specifiers[0].type === "ImportDefaultSpecifier") {
          this.raise(TSErrors.TypeImportCannotSpecifyDefaultAndNamed, importNode);
        }
        return importNode;
      }
      parseExport(node, decorators) {
        if (this.match(83)) {
          const nodeImportEquals = node;
          this.next();
          let maybeDefaultIdentifier = null;
          if (this.isContextual(130) && this.isPotentialImportPhase(false)) {
            maybeDefaultIdentifier = this.parseMaybeImportPhase(nodeImportEquals, false);
          } else {
            nodeImportEquals.importKind = "value";
          }
          const declaration = this.tsParseImportEqualsDeclaration(nodeImportEquals, maybeDefaultIdentifier, true);
          {
            return declaration;
          }
        } else if (this.eat(29)) {
          const assign = node;
          assign.expression = super.parseExpression();
          this.semicolon();
          this.sawUnambiguousESM = true;
          return this.finishNode(assign, "TSExportAssignment");
        } else if (this.eatContextual(93)) {
          const decl = node;
          this.expectContextual(128);
          decl.id = this.parseIdentifier();
          this.semicolon();
          return this.finishNode(decl, "TSNamespaceExportDeclaration");
        } else {
          return super.parseExport(node, decorators);
        }
      }
      isAbstractClass() {
        return this.isContextual(124) && this.lookahead().type === 80;
      }
      parseExportDefaultExpression() {
        if (this.isAbstractClass()) {
          const cls = this.startNode();
          this.next();
          cls.abstract = true;
          return this.parseClass(cls, true, true);
        }
        if (this.match(129)) {
          const result = this.tsParseInterfaceDeclaration(this.startNode());
          if (result) return result;
        }
        return super.parseExportDefaultExpression();
      }
      parseVarStatement(node, kind, allowMissingInitializer = false) {
        const {
          isAmbientContext
        } = this.state;
        const declaration = super.parseVarStatement(node, kind, allowMissingInitializer || isAmbientContext);
        if (!isAmbientContext) return declaration;
        for (const {
          id,
          init
        } of declaration.declarations) {
          if (!init) continue;
          if (kind !== "const" || !!id.typeAnnotation) {
            this.raise(TSErrors.InitializerNotAllowedInAmbientContext, init);
          } else if (!isValidAmbientConstInitializer(init, this.hasPlugin("estree"))) {
            this.raise(TSErrors.ConstInitializerMustBeStringOrNumericLiteralOrLiteralEnumReference, init);
          }
        }
        return declaration;
      }
      parseStatementContent(flags, decorators) {
        if (this.match(75) && this.isLookaheadContextual("enum")) {
          const node = this.startNode();
          this.expect(75);
          return this.tsParseEnumDeclaration(node, {
            const: true
          });
        }
        if (this.isContextual(126)) {
          return this.tsParseEnumDeclaration(this.startNode());
        }
        if (this.isContextual(129)) {
          const result = this.tsParseInterfaceDeclaration(this.startNode());
          if (result) return result;
        }
        return super.parseStatementContent(flags, decorators);
      }
      parseAccessModifier() {
        return this.tsParseModifier(["public", "protected", "private"]);
      }
      tsHasSomeModifiers(member, modifiers) {
        return modifiers.some((modifier) => {
          if (tsIsAccessModifier(modifier)) {
            return member.accessibility === modifier;
          }
          return !!member[modifier];
        });
      }
      tsIsStartOfStaticBlocks() {
        return this.isContextual(106) && this.lookaheadCharCode() === 123;
      }
      parseClassMember(classBody, member, state) {
        const modifiers = ["declare", "private", "public", "protected", "override", "abstract", "readonly", "static"];
        this.tsParseModifiers({
          allowedModifiers: modifiers,
          disallowedModifiers: ["in", "out"],
          stopOnStartOfClassStaticBlock: true,
          errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions
        }, member);
        const callParseClassMemberWithIsStatic = () => {
          if (this.tsIsStartOfStaticBlocks()) {
            this.next();
            this.next();
            if (this.tsHasSomeModifiers(member, modifiers)) {
              this.raise(TSErrors.StaticBlockCannotHaveModifier, this.state.curPosition());
            }
            super.parseClassStaticBlock(classBody, member);
          } else {
            this.parseClassMemberWithIsStatic(classBody, member, state, !!member.static);
          }
        };
        if (member.declare) {
          this.tsInAmbientContext(callParseClassMemberWithIsStatic);
        } else {
          callParseClassMemberWithIsStatic();
        }
      }
      parseClassMemberWithIsStatic(classBody, member, state, isStatic) {
        const idx = this.tsTryParseIndexSignature(member);
        if (idx) {
          classBody.body.push(idx);
          if (member.abstract) {
            this.raise(TSErrors.IndexSignatureHasAbstract, member);
          }
          if (member.accessibility) {
            this.raise(TSErrors.IndexSignatureHasAccessibility, member, {
              modifier: member.accessibility
            });
          }
          if (member.declare) {
            this.raise(TSErrors.IndexSignatureHasDeclare, member);
          }
          if (member.override) {
            this.raise(TSErrors.IndexSignatureHasOverride, member);
          }
          return;
        }
        if (!this.state.inAbstractClass && member.abstract) {
          this.raise(TSErrors.NonAbstractClassHasAbstractMethod, member);
        }
        if (member.override) {
          if (!state.hadSuperClass) {
            this.raise(TSErrors.OverrideNotInSubClass, member);
          }
        }
        super.parseClassMemberWithIsStatic(classBody, member, state, isStatic);
      }
      parsePostMemberNameModifiers(methodOrProp) {
        const optional2 = this.eat(17);
        if (optional2) methodOrProp.optional = true;
        if (methodOrProp.readonly && this.match(10)) {
          this.raise(TSErrors.ClassMethodHasReadonly, methodOrProp);
        }
        if (methodOrProp.declare && this.match(10)) {
          this.raise(TSErrors.ClassMethodHasDeclare, methodOrProp);
        }
      }
      parseExpressionStatement(node, expr, decorators) {
        const decl = expr.type === "Identifier" ? this.tsParseExpressionStatement(node, expr, decorators) : void 0;
        return decl || super.parseExpressionStatement(node, expr, decorators);
      }
      shouldParseExportDeclaration() {
        if (this.tsIsDeclarationStart()) return true;
        return super.shouldParseExportDeclaration();
      }
      parseConditional(expr, startLoc, refExpressionErrors) {
        if (!this.match(17)) return expr;
        if (this.state.maybeInArrowParameters) {
          const nextCh = this.lookaheadCharCode();
          if (nextCh === 44 || nextCh === 61 || nextCh === 58 || nextCh === 41) {
            this.setOptionalParametersError(refExpressionErrors);
            return expr;
          }
        }
        return super.parseConditional(expr, startLoc, refExpressionErrors);
      }
      parseParenItem(node, startLoc) {
        const newNode = super.parseParenItem(node, startLoc);
        if (this.eat(17)) {
          newNode.optional = true;
          this.resetEndLocation(node);
        }
        if (this.match(14)) {
          const typeCastNode = this.startNodeAt(startLoc);
          typeCastNode.expression = node;
          typeCastNode.typeAnnotation = this.tsParseTypeAnnotation();
          return this.finishNode(typeCastNode, "TSTypeCastExpression");
        }
        return node;
      }
      parseExportDeclaration(node) {
        if (!this.state.isAmbientContext && this.isContextual(125)) {
          return this.tsInAmbientContext(() => this.parseExportDeclaration(node));
        }
        const startLoc = this.state.startLoc;
        const isDeclare = this.eatContextual(125);
        if (isDeclare && (this.isContextual(125) || !this.shouldParseExportDeclaration())) {
          throw this.raise(TSErrors.ExpectedAmbientAfterExportDeclare, this.state.startLoc);
        }
        const isIdentifier = tokenIsIdentifier(this.state.type);
        const declaration = isIdentifier && this.tsTryParseExportDeclaration() || super.parseExportDeclaration(node);
        if (!declaration) return null;
        if (declaration.type === "TSInterfaceDeclaration" || declaration.type === "TSTypeAliasDeclaration" || isDeclare) {
          node.exportKind = "type";
        }
        if (isDeclare && declaration.type !== "TSImportEqualsDeclaration") {
          this.resetStartLocation(declaration, startLoc);
          declaration.declare = true;
        }
        return declaration;
      }
      parseClassId(node, isStatement2, optionalId, bindingType) {
        if ((!isStatement2 || optionalId) && this.isContextual(113)) {
          return;
        }
        super.parseClassId(node, isStatement2, optionalId, node.declare ? 1024 : 8331);
        const typeParameters = this.tsTryParseTypeParameters(this.tsParseInOutConstModifiers);
        if (typeParameters) node.typeParameters = typeParameters;
      }
      parseClassPropertyAnnotation(node) {
        if (!node.optional) {
          if (this.eat(35)) {
            node.definite = true;
          } else if (this.eat(17)) {
            node.optional = true;
          }
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) node.typeAnnotation = type;
      }
      parseClassProperty(node) {
        this.parseClassPropertyAnnotation(node);
        if (this.state.isAmbientContext && !(node.readonly && !node.typeAnnotation) && this.match(29)) {
          this.raise(TSErrors.DeclareClassFieldHasInitializer, this.state.startLoc);
        }
        if (node.abstract && this.match(29)) {
          const {
            key: key2
          } = node;
          this.raise(TSErrors.AbstractPropertyHasInitializer, this.state.startLoc, {
            propertyName: key2.type === "Identifier" && !node.computed ? key2.name : `[${this.input.slice(this.offsetToSourcePos(key2.start), this.offsetToSourcePos(key2.end))}]`
          });
        }
        return super.parseClassProperty(node);
      }
      parseClassPrivateProperty(node) {
        if (node.abstract) {
          this.raise(TSErrors.PrivateElementHasAbstract, node);
        }
        if (node.accessibility) {
          this.raise(TSErrors.PrivateElementHasAccessibility, node, {
            modifier: node.accessibility
          });
        }
        this.parseClassPropertyAnnotation(node);
        return super.parseClassPrivateProperty(node);
      }
      parseClassAccessorProperty(node) {
        this.parseClassPropertyAnnotation(node);
        if (node.optional) {
          this.raise(TSErrors.AccessorCannotBeOptional, node);
        }
        return super.parseClassAccessorProperty(node);
      }
      pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
        const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
        if (typeParameters && isConstructor) {
          this.raise(TSErrors.ConstructorHasTypeParameters, typeParameters);
        }
        const {
          declare = false,
          kind
        } = method;
        if (declare && (kind === "get" || kind === "set")) {
          this.raise(TSErrors.DeclareAccessor, method, {
            kind
          });
        }
        if (typeParameters) method.typeParameters = typeParameters;
        super.pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper);
      }
      pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
        const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
        if (typeParameters) method.typeParameters = typeParameters;
        super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
      }
      declareClassPrivateMethodInScope(node, kind) {
        if (node.type === "TSDeclareMethod") return;
        if (node.type === "MethodDefinition" && !hasOwnProperty.call(node.value, "body")) {
          return;
        }
        super.declareClassPrivateMethodInScope(node, kind);
      }
      parseClassSuper(node) {
        super.parseClassSuper(node);
        if (node.superClass && (this.match(47) || this.match(51))) {
          {
            node.superTypeParameters = this.tsParseTypeArgumentsInExpression();
          }
        }
        if (this.eatContextual(113)) {
          node.implements = this.tsParseHeritageClause("implements");
        }
      }
      parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
        const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
        if (typeParameters) prop.typeParameters = typeParameters;
        return super.parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors);
      }
      parseFunctionParams(node, isConstructor) {
        const typeParameters = this.tsTryParseTypeParameters(this.tsParseConstModifier);
        if (typeParameters) node.typeParameters = typeParameters;
        super.parseFunctionParams(node, isConstructor);
      }
      parseVarId(decl, kind) {
        super.parseVarId(decl, kind);
        if (decl.id.type === "Identifier" && !this.hasPrecedingLineBreak() && this.eat(35)) {
          decl.definite = true;
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) {
          decl.id.typeAnnotation = type;
          this.resetEndLocation(decl.id);
        }
      }
      parseAsyncArrowFromCallExpression(node, call) {
        if (this.match(14)) {
          node.returnType = this.tsParseTypeAnnotation();
        }
        return super.parseAsyncArrowFromCallExpression(node, call);
      }
      parseMaybeAssign(refExpressionErrors, afterLeftParse) {
        var _jsx, _jsx2, _typeCast, _jsx3, _typeCast2;
        let state;
        let jsx2;
        let typeCast;
        if (this.hasPlugin("jsx") && (this.match(143) || this.match(47))) {
          state = this.state.clone();
          jsx2 = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
          if (!jsx2.error) return jsx2.node;
          const {
            context
          } = this.state;
          const currentContext = context[context.length - 1];
          if (currentContext === types.j_oTag || currentContext === types.j_expr) {
            context.pop();
          }
        }
        if (!((_jsx = jsx2) != null && _jsx.error) && !this.match(47)) {
          return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
        }
        if (!state || state === this.state) state = this.state.clone();
        let typeParameters;
        const arrow = this.tryParse((abort) => {
          var _expr$extra, _typeParameters;
          typeParameters = this.tsParseTypeParameters(this.tsParseConstModifier);
          const expr = super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
          if (expr.type !== "ArrowFunctionExpression" || (_expr$extra = expr.extra) != null && _expr$extra.parenthesized) {
            abort();
          }
          if (((_typeParameters = typeParameters) == null ? void 0 : _typeParameters.params.length) !== 0) {
            this.resetStartLocationFromNode(expr, typeParameters);
          }
          expr.typeParameters = typeParameters;
          return expr;
        }, state);
        if (!arrow.error && !arrow.aborted) {
          if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
          return arrow.node;
        }
        if (!jsx2) {
          assert2(!this.hasPlugin("jsx"));
          typeCast = this.tryParse(() => super.parseMaybeAssign(refExpressionErrors, afterLeftParse), state);
          if (!typeCast.error) return typeCast.node;
        }
        if ((_jsx2 = jsx2) != null && _jsx2.node) {
          this.state = jsx2.failState;
          return jsx2.node;
        }
        if (arrow.node) {
          this.state = arrow.failState;
          if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
          return arrow.node;
        }
        if ((_typeCast = typeCast) != null && _typeCast.node) {
          this.state = typeCast.failState;
          return typeCast.node;
        }
        throw ((_jsx3 = jsx2) == null ? void 0 : _jsx3.error) || arrow.error || ((_typeCast2 = typeCast) == null ? void 0 : _typeCast2.error);
      }
      reportReservedArrowTypeParam(node) {
        var _node$extra2;
        if (node.params.length === 1 && !node.params[0].constraint && !((_node$extra2 = node.extra) != null && _node$extra2.trailingComma) && this.getPluginOption("typescript", "disallowAmbiguousJSXLike")) {
          this.raise(TSErrors.ReservedArrowTypeParam, node);
        }
      }
      parseMaybeUnary(refExpressionErrors, sawUnary) {
        if (!this.hasPlugin("jsx") && this.match(47)) {
          return this.tsParseTypeAssertion();
        }
        return super.parseMaybeUnary(refExpressionErrors, sawUnary);
      }
      parseArrow(node) {
        if (this.match(14)) {
          const result = this.tryParse((abort) => {
            const returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
            if (this.canInsertSemicolon() || !this.match(19)) abort();
            return returnType;
          });
          if (result.aborted) return;
          if (!result.thrown) {
            if (result.error) this.state = result.failState;
            node.returnType = result.node;
          }
        }
        return super.parseArrow(node);
      }
      parseFunctionParamType(param) {
        if (this.eat(17)) {
          param.optional = true;
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) param.typeAnnotation = type;
        this.resetEndLocation(param);
        return param;
      }
      isAssignable(node, isBinding) {
        switch (node.type) {
          case "TSTypeCastExpression":
            return this.isAssignable(node.expression, isBinding);
          case "TSParameterProperty":
            return true;
          default:
            return super.isAssignable(node, isBinding);
        }
      }
      toAssignable(node, isLHS = false) {
        switch (node.type) {
          case "ParenthesizedExpression":
            this.toAssignableParenthesizedExpression(node, isLHS);
            break;
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSNonNullExpression":
          case "TSTypeAssertion":
            if (isLHS) {
              this.expressionScope.recordArrowParameterBindingError(TSErrors.UnexpectedTypeCastInParameter, node);
            } else {
              this.raise(TSErrors.UnexpectedTypeCastInParameter, node);
            }
            this.toAssignable(node.expression, isLHS);
            break;
          case "AssignmentExpression":
            if (!isLHS && node.left.type === "TSTypeCastExpression") {
              node.left = this.typeCastToParameter(node.left);
            }
          default:
            super.toAssignable(node, isLHS);
        }
      }
      toAssignableParenthesizedExpression(node, isLHS) {
        switch (node.expression.type) {
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSNonNullExpression":
          case "TSTypeAssertion":
          case "ParenthesizedExpression":
            this.toAssignable(node.expression, isLHS);
            break;
          default:
            super.toAssignable(node, isLHS);
        }
      }
      checkToRestConversion(node, allowPattern) {
        switch (node.type) {
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSTypeAssertion":
          case "TSNonNullExpression":
            this.checkToRestConversion(node.expression, false);
            break;
          default:
            super.checkToRestConversion(node, allowPattern);
        }
      }
      isValidLVal(type, isUnparenthesizedInAssign, binding) {
        switch (type) {
          case "TSTypeCastExpression":
            return true;
          case "TSParameterProperty":
            return "parameter";
          case "TSNonNullExpression":
            return "expression";
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSTypeAssertion":
            return (binding !== 64 || !isUnparenthesizedInAssign) && ["expression", true];
          default:
            return super.isValidLVal(type, isUnparenthesizedInAssign, binding);
        }
      }
      parseBindingAtom() {
        if (this.state.type === 78) {
          return this.parseIdentifier(true);
        }
        return super.parseBindingAtom();
      }
      parseMaybeDecoratorArguments(expr, startLoc) {
        if (this.match(47) || this.match(51)) {
          const typeArguments = this.tsParseTypeArgumentsInExpression();
          if (this.match(10)) {
            const call = super.parseMaybeDecoratorArguments(expr, startLoc);
            {
              call.typeParameters = typeArguments;
            }
            return call;
          }
          this.unexpected(null, 10);
        }
        return super.parseMaybeDecoratorArguments(expr, startLoc);
      }
      checkCommaAfterRest(close) {
        if (this.state.isAmbientContext && this.match(12) && this.lookaheadCharCode() === close) {
          this.next();
          return false;
        }
        return super.checkCommaAfterRest(close);
      }
      isClassMethod() {
        return this.match(47) || super.isClassMethod();
      }
      isClassProperty() {
        return this.match(35) || this.match(14) || super.isClassProperty();
      }
      parseMaybeDefault(startLoc, left) {
        const node = super.parseMaybeDefault(startLoc, left);
        if (node.type === "AssignmentPattern" && node.typeAnnotation && node.right.start < node.typeAnnotation.start) {
          this.raise(TSErrors.TypeAnnotationAfterAssign, node.typeAnnotation);
        }
        return node;
      }
      getTokenFromCode(code2) {
        if (this.state.inType) {
          if (code2 === 62) {
            this.finishOp(48, 1);
            return;
          }
          if (code2 === 60) {
            this.finishOp(47, 1);
            return;
          }
        }
        super.getTokenFromCode(code2);
      }
      reScan_lt_gt() {
        const {
          type
        } = this.state;
        if (type === 47) {
          this.state.pos -= 1;
          this.readToken_lt();
        } else if (type === 48) {
          this.state.pos -= 1;
          this.readToken_gt();
        }
      }
      reScan_lt() {
        const {
          type
        } = this.state;
        if (type === 51) {
          this.state.pos -= 2;
          this.finishOp(47, 1);
          return 47;
        }
        return type;
      }
      toAssignableListItem(exprList, index, isLHS) {
        const node = exprList[index];
        if (node.type === "TSTypeCastExpression") {
          exprList[index] = this.typeCastToParameter(node);
        }
        super.toAssignableListItem(exprList, index, isLHS);
      }
      typeCastToParameter(node) {
        node.expression.typeAnnotation = node.typeAnnotation;
        this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
        return node.expression;
      }
      shouldParseArrow(params) {
        if (this.match(14)) {
          return params.every((expr) => this.isAssignable(expr, true));
        }
        return super.shouldParseArrow(params);
      }
      shouldParseAsyncArrow() {
        return this.match(14) || super.shouldParseAsyncArrow();
      }
      canHaveLeadingDecorator() {
        return super.canHaveLeadingDecorator() || this.isAbstractClass();
      }
      jsxParseOpeningElementAfterName(node) {
        if (this.match(47) || this.match(51)) {
          const typeArguments = this.tsTryParseAndCatch(() => this.tsParseTypeArgumentsInExpression());
          if (typeArguments) {
            {
              node.typeParameters = typeArguments;
            }
          }
        }
        return super.jsxParseOpeningElementAfterName(node);
      }
      getGetterSetterExpectedParamCount(method) {
        const baseCount = super.getGetterSetterExpectedParamCount(method);
        const params = this.getObjectOrClassMethodParams(method);
        const firstParam = params[0];
        const hasContextParam = firstParam && this.isThisParam(firstParam);
        return hasContextParam ? baseCount + 1 : baseCount;
      }
      parseCatchClauseParam() {
        const param = super.parseCatchClauseParam();
        const type = this.tsTryParseTypeAnnotation();
        if (type) {
          param.typeAnnotation = type;
          this.resetEndLocation(param);
        }
        return param;
      }
      tsInAmbientContext(cb) {
        const {
          isAmbientContext: oldIsAmbientContext,
          strict: oldStrict
        } = this.state;
        this.state.isAmbientContext = true;
        this.state.strict = false;
        try {
          return cb();
        } finally {
          this.state.isAmbientContext = oldIsAmbientContext;
          this.state.strict = oldStrict;
        }
      }
      parseClass(node, isStatement2, optionalId) {
        const oldInAbstractClass = this.state.inAbstractClass;
        this.state.inAbstractClass = !!node.abstract;
        try {
          return super.parseClass(node, isStatement2, optionalId);
        } finally {
          this.state.inAbstractClass = oldInAbstractClass;
        }
      }
      tsParseAbstractDeclaration(node, decorators) {
        if (this.match(80)) {
          node.abstract = true;
          return this.maybeTakeDecorators(decorators, this.parseClass(node, true, false));
        } else if (this.isContextual(129)) {
          if (!this.hasFollowingLineBreak()) {
            node.abstract = true;
            this.raise(TSErrors.NonClassMethodPropertyHasAbstractModifer, node);
            return this.tsParseInterfaceDeclaration(node);
          }
        } else {
          this.unexpected(null, 80);
        }
      }
      parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope) {
        const method = super.parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope);
        if (method.abstract) {
          const hasEstreePlugin = this.hasPlugin("estree");
          const methodFn = hasEstreePlugin ? method.value : method;
          if (methodFn.body) {
            const {
              key: key2
            } = method;
            this.raise(TSErrors.AbstractMethodHasImplementation, method, {
              methodName: key2.type === "Identifier" && !method.computed ? key2.name : `[${this.input.slice(this.offsetToSourcePos(key2.start), this.offsetToSourcePos(key2.end))}]`
            });
          }
        }
        return method;
      }
      tsParseTypeParameterName() {
        const typeName = this.parseIdentifier();
        return typeName.name;
      }
      shouldParseAsAmbientContext() {
        return !!this.getPluginOption("typescript", "dts");
      }
      parse() {
        if (this.shouldParseAsAmbientContext()) {
          this.state.isAmbientContext = true;
        }
        return super.parse();
      }
      getExpression() {
        if (this.shouldParseAsAmbientContext()) {
          this.state.isAmbientContext = true;
        }
        return super.getExpression();
      }
      parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly) {
        if (!isString && isMaybeTypeOnly) {
          this.parseTypeOnlyImportExportSpecifier(node, false, isInTypeExport);
          return this.finishNode(node, "ExportSpecifier");
        }
        node.exportKind = "value";
        return super.parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly);
      }
      parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
        if (!importedIsString && isMaybeTypeOnly) {
          this.parseTypeOnlyImportExportSpecifier(specifier, true, isInTypeOnlyImport);
          return this.finishNode(specifier, "ImportSpecifier");
        }
        specifier.importKind = "value";
        return super.parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, isInTypeOnlyImport ? 4098 : 4096);
      }
      parseTypeOnlyImportExportSpecifier(node, isImport, isInTypeOnlyImportExport) {
        const leftOfAsKey = isImport ? "imported" : "local";
        const rightOfAsKey = isImport ? "local" : "exported";
        let leftOfAs = node[leftOfAsKey];
        let rightOfAs;
        let hasTypeSpecifier = false;
        let canParseAsKeyword = true;
        const loc = leftOfAs.loc.start;
        if (this.isContextual(93)) {
          const firstAs = this.parseIdentifier();
          if (this.isContextual(93)) {
            const secondAs = this.parseIdentifier();
            if (tokenIsKeywordOrIdentifier(this.state.type)) {
              hasTypeSpecifier = true;
              leftOfAs = firstAs;
              rightOfAs = isImport ? this.parseIdentifier() : this.parseModuleExportName();
              canParseAsKeyword = false;
            } else {
              rightOfAs = secondAs;
              canParseAsKeyword = false;
            }
          } else if (tokenIsKeywordOrIdentifier(this.state.type)) {
            canParseAsKeyword = false;
            rightOfAs = isImport ? this.parseIdentifier() : this.parseModuleExportName();
          } else {
            hasTypeSpecifier = true;
            leftOfAs = firstAs;
          }
        } else if (tokenIsKeywordOrIdentifier(this.state.type)) {
          hasTypeSpecifier = true;
          if (isImport) {
            leftOfAs = this.parseIdentifier(true);
            if (!this.isContextual(93)) {
              this.checkReservedWord(leftOfAs.name, leftOfAs.loc.start, true, true);
            }
          } else {
            leftOfAs = this.parseModuleExportName();
          }
        }
        if (hasTypeSpecifier && isInTypeOnlyImportExport) {
          this.raise(isImport ? TSErrors.TypeModifierIsUsedInTypeImports : TSErrors.TypeModifierIsUsedInTypeExports, loc);
        }
        node[leftOfAsKey] = leftOfAs;
        node[rightOfAsKey] = rightOfAs;
        const kindKey = isImport ? "importKind" : "exportKind";
        node[kindKey] = hasTypeSpecifier ? "type" : "value";
        if (canParseAsKeyword && this.eatContextual(93)) {
          node[rightOfAsKey] = isImport ? this.parseIdentifier() : this.parseModuleExportName();
        }
        if (!node[rightOfAsKey]) {
          node[rightOfAsKey] = cloneIdentifier(node[leftOfAsKey]);
        }
        if (isImport) {
          this.checkIdentifier(node[rightOfAsKey], hasTypeSpecifier ? 4098 : 4096);
        }
      }
    };
    function isPossiblyLiteralEnum(expression) {
      if (expression.type !== "MemberExpression") return false;
      const {
        computed,
        property
      } = expression;
      if (computed && property.type !== "StringLiteral" && (property.type !== "TemplateLiteral" || property.expressions.length > 0)) {
        return false;
      }
      return isUncomputedMemberExpressionChain(expression.object);
    }
    function isValidAmbientConstInitializer(expression, estree2) {
      var _expression$extra;
      const {
        type
      } = expression;
      if ((_expression$extra = expression.extra) != null && _expression$extra.parenthesized) {
        return false;
      }
      if (estree2) {
        if (type === "Literal") {
          const {
            value
          } = expression;
          if (typeof value === "string" || typeof value === "boolean") {
            return true;
          }
        }
      } else {
        if (type === "StringLiteral" || type === "BooleanLiteral") {
          return true;
        }
      }
      if (isNumber(expression, estree2) || isNegativeNumber(expression, estree2)) {
        return true;
      }
      if (type === "TemplateLiteral" && expression.expressions.length === 0) {
        return true;
      }
      if (isPossiblyLiteralEnum(expression)) {
        return true;
      }
      return false;
    }
    function isNumber(expression, estree2) {
      if (estree2) {
        return expression.type === "Literal" && (typeof expression.value === "number" || "bigint" in expression);
      }
      return expression.type === "NumericLiteral" || expression.type === "BigIntLiteral";
    }
    function isNegativeNumber(expression, estree2) {
      if (expression.type === "UnaryExpression") {
        const {
          operator,
          argument
        } = expression;
        if (operator === "-" && isNumber(argument, estree2)) {
          return true;
        }
      }
      return false;
    }
    function isUncomputedMemberExpressionChain(expression) {
      if (expression.type === "Identifier") return true;
      if (expression.type !== "MemberExpression" || expression.computed) {
        return false;
      }
      return isUncomputedMemberExpressionChain(expression.object);
    }
    var PlaceholderErrors = ParseErrorEnum`placeholders`({
      ClassNameIsRequired: "A class name is required.",
      UnexpectedSpace: "Unexpected space in placeholder."
    });
    var placeholders = (superClass) => class PlaceholdersParserMixin extends superClass {
      parsePlaceholder(expectedNode) {
        if (this.match(133)) {
          const node = this.startNode();
          this.next();
          this.assertNoSpace();
          node.name = super.parseIdentifier(true);
          this.assertNoSpace();
          this.expect(133);
          return this.finishPlaceholder(node, expectedNode);
        }
      }
      finishPlaceholder(node, expectedNode) {
        let placeholder = node;
        if (!placeholder.expectedNode || !placeholder.type) {
          placeholder = this.finishNode(placeholder, "Placeholder");
        }
        placeholder.expectedNode = expectedNode;
        return placeholder;
      }
      getTokenFromCode(code2) {
        if (code2 === 37 && this.input.charCodeAt(this.state.pos + 1) === 37) {
          this.finishOp(133, 2);
        } else {
          super.getTokenFromCode(code2);
        }
      }
      parseExprAtom(refExpressionErrors) {
        return this.parsePlaceholder("Expression") || super.parseExprAtom(refExpressionErrors);
      }
      parseIdentifier(liberal) {
        return this.parsePlaceholder("Identifier") || super.parseIdentifier(liberal);
      }
      checkReservedWord(word, startLoc, checkKeywords, isBinding) {
        if (word !== void 0) {
          super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
        }
      }
      parseBindingAtom() {
        return this.parsePlaceholder("Pattern") || super.parseBindingAtom();
      }
      isValidLVal(type, isParenthesized, binding) {
        return type === "Placeholder" || super.isValidLVal(type, isParenthesized, binding);
      }
      toAssignable(node, isLHS) {
        if (node && node.type === "Placeholder" && node.expectedNode === "Expression") {
          node.expectedNode = "Pattern";
        } else {
          super.toAssignable(node, isLHS);
        }
      }
      chStartsBindingIdentifier(ch, pos2) {
        if (super.chStartsBindingIdentifier(ch, pos2)) {
          return true;
        }
        const nextToken = this.lookahead();
        if (nextToken.type === 133) {
          return true;
        }
        return false;
      }
      verifyBreakContinue(node, isBreak) {
        if (node.label && node.label.type === "Placeholder") return;
        super.verifyBreakContinue(node, isBreak);
      }
      parseExpressionStatement(node, expr) {
        var _expr$extra;
        if (expr.type !== "Placeholder" || (_expr$extra = expr.extra) != null && _expr$extra.parenthesized) {
          return super.parseExpressionStatement(node, expr);
        }
        if (this.match(14)) {
          const stmt = node;
          stmt.label = this.finishPlaceholder(expr, "Identifier");
          this.next();
          stmt.body = super.parseStatementOrSloppyAnnexBFunctionDeclaration();
          return this.finishNode(stmt, "LabeledStatement");
        }
        this.semicolon();
        const stmtPlaceholder = node;
        stmtPlaceholder.name = expr.name;
        return this.finishPlaceholder(stmtPlaceholder, "Statement");
      }
      parseBlock(allowDirectives, createNewLexicalScope, afterBlockParse) {
        return this.parsePlaceholder("BlockStatement") || super.parseBlock(allowDirectives, createNewLexicalScope, afterBlockParse);
      }
      parseFunctionId(requireId) {
        return this.parsePlaceholder("Identifier") || super.parseFunctionId(requireId);
      }
      parseClass(node, isStatement2, optionalId) {
        const type = isStatement2 ? "ClassDeclaration" : "ClassExpression";
        this.next();
        const oldStrict = this.state.strict;
        const placeholder = this.parsePlaceholder("Identifier");
        if (placeholder) {
          if (this.match(81) || this.match(133) || this.match(5)) {
            node.id = placeholder;
          } else if (optionalId || !isStatement2) {
            node.id = null;
            node.body = this.finishPlaceholder(placeholder, "ClassBody");
            return this.finishNode(node, type);
          } else {
            throw this.raise(PlaceholderErrors.ClassNameIsRequired, this.state.startLoc);
          }
        } else {
          this.parseClassId(node, isStatement2, optionalId);
        }
        super.parseClassSuper(node);
        node.body = this.parsePlaceholder("ClassBody") || super.parseClassBody(!!node.superClass, oldStrict);
        return this.finishNode(node, type);
      }
      parseExport(node, decorators) {
        const placeholder = this.parsePlaceholder("Identifier");
        if (!placeholder) return super.parseExport(node, decorators);
        const node2 = node;
        if (!this.isContextual(98) && !this.match(12)) {
          node2.specifiers = [];
          node2.source = null;
          node2.declaration = this.finishPlaceholder(placeholder, "Declaration");
          return this.finishNode(node2, "ExportNamedDeclaration");
        }
        this.expectPlugin("exportDefaultFrom");
        const specifier = this.startNode();
        specifier.exported = placeholder;
        node2.specifiers = [this.finishNode(specifier, "ExportDefaultSpecifier")];
        return super.parseExport(node2, decorators);
      }
      isExportDefaultSpecifier() {
        if (this.match(65)) {
          const next = this.nextTokenStart();
          if (this.isUnparsedContextual(next, "from")) {
            if (this.input.startsWith(tokenLabelName(133), this.nextTokenStartSince(next + 4))) {
              return true;
            }
          }
        }
        return super.isExportDefaultSpecifier();
      }
      maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
        var _specifiers;
        if ((_specifiers = node.specifiers) != null && _specifiers.length) {
          return true;
        }
        return super.maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier);
      }
      checkExport(node) {
        const {
          specifiers
        } = node;
        if (specifiers != null && specifiers.length) {
          node.specifiers = specifiers.filter((node2) => node2.exported.type === "Placeholder");
        }
        super.checkExport(node);
        node.specifiers = specifiers;
      }
      parseImport(node) {
        const placeholder = this.parsePlaceholder("Identifier");
        if (!placeholder) return super.parseImport(node);
        node.specifiers = [];
        if (!this.isContextual(98) && !this.match(12)) {
          node.source = this.finishPlaceholder(placeholder, "StringLiteral");
          this.semicolon();
          return this.finishNode(node, "ImportDeclaration");
        }
        const specifier = this.startNodeAtNode(placeholder);
        specifier.local = placeholder;
        node.specifiers.push(this.finishNode(specifier, "ImportDefaultSpecifier"));
        if (this.eat(12)) {
          const hasStarImport = this.maybeParseStarImportSpecifier(node);
          if (!hasStarImport) this.parseNamedImportSpecifiers(node);
        }
        this.expectContextual(98);
        node.source = this.parseImportSource();
        this.semicolon();
        return this.finishNode(node, "ImportDeclaration");
      }
      parseImportSource() {
        return this.parsePlaceholder("StringLiteral") || super.parseImportSource();
      }
      assertNoSpace() {
        if (this.state.start > this.offsetToSourcePos(this.state.lastTokEndLoc.index)) {
          this.raise(PlaceholderErrors.UnexpectedSpace, this.state.lastTokEndLoc);
        }
      }
    };
    var v8intrinsic = (superClass) => class V8IntrinsicMixin extends superClass {
      parseV8Intrinsic() {
        if (this.match(54)) {
          const v8IntrinsicStartLoc = this.state.startLoc;
          const node = this.startNode();
          this.next();
          if (tokenIsIdentifier(this.state.type)) {
            const name = this.parseIdentifierName();
            const identifier4 = this.createIdentifier(node, name);
            identifier4.type = "V8IntrinsicIdentifier";
            if (this.match(10)) {
              return identifier4;
            }
          }
          this.unexpected(v8IntrinsicStartLoc);
        }
      }
      parseExprAtom(refExpressionErrors) {
        return this.parseV8Intrinsic() || super.parseExprAtom(refExpressionErrors);
      }
    };
    var PIPELINE_PROPOSALS = ["minimal", "fsharp", "hack", "smart"];
    var TOPIC_TOKENS = ["^^", "@@", "^", "%", "#"];
    function validatePlugins(pluginsMap) {
      if (pluginsMap.has("decorators")) {
        if (pluginsMap.has("decorators-legacy")) {
          throw new Error("Cannot use the decorators and decorators-legacy plugin together");
        }
        const decoratorsBeforeExport = pluginsMap.get("decorators").decoratorsBeforeExport;
        if (decoratorsBeforeExport != null && typeof decoratorsBeforeExport !== "boolean") {
          throw new Error("'decoratorsBeforeExport' must be a boolean, if specified.");
        }
        const allowCallParenthesized = pluginsMap.get("decorators").allowCallParenthesized;
        if (allowCallParenthesized != null && typeof allowCallParenthesized !== "boolean") {
          throw new Error("'allowCallParenthesized' must be a boolean.");
        }
      }
      if (pluginsMap.has("flow") && pluginsMap.has("typescript")) {
        throw new Error("Cannot combine flow and typescript plugins.");
      }
      if (pluginsMap.has("placeholders") && pluginsMap.has("v8intrinsic")) {
        throw new Error("Cannot combine placeholders and v8intrinsic plugins.");
      }
      if (pluginsMap.has("pipelineOperator")) {
        var _pluginsMap$get;
        const proposal = pluginsMap.get("pipelineOperator").proposal;
        if (!PIPELINE_PROPOSALS.includes(proposal)) {
          const proposalList = PIPELINE_PROPOSALS.map((p) => `"${p}"`).join(", ");
          throw new Error(`"pipelineOperator" requires "proposal" option whose value must be one of: ${proposalList}.`);
        }
        const tupleSyntaxIsHash = ((_pluginsMap$get = pluginsMap.get("recordAndTuple")) == null ? void 0 : _pluginsMap$get.syntaxType) === "hash";
        if (proposal === "hack") {
          if (pluginsMap.has("placeholders")) {
            throw new Error("Cannot combine placeholders plugin and Hack-style pipes.");
          }
          if (pluginsMap.has("v8intrinsic")) {
            throw new Error("Cannot combine v8intrinsic plugin and Hack-style pipes.");
          }
          const topicToken = pluginsMap.get("pipelineOperator").topicToken;
          if (!TOPIC_TOKENS.includes(topicToken)) {
            const tokenList = TOPIC_TOKENS.map((t6) => `"${t6}"`).join(", ");
            throw new Error(`"pipelineOperator" in "proposal": "hack" mode also requires a "topicToken" option whose value must be one of: ${tokenList}.`);
          }
          if (topicToken === "#" && tupleSyntaxIsHash) {
            throw new Error(`Plugin conflict between \`["pipelineOperator", { proposal: "hack", topicToken: "#" }]\` and \`${JSON.stringify(["recordAndTuple", pluginsMap.get("recordAndTuple")])}\`.`);
          }
        } else if (proposal === "smart" && tupleSyntaxIsHash) {
          throw new Error(`Plugin conflict between \`["pipelineOperator", { proposal: "smart" }]\` and \`${JSON.stringify(["recordAndTuple", pluginsMap.get("recordAndTuple")])}\`.`);
        }
      }
      if (pluginsMap.has("moduleAttributes")) {
        {
          if (pluginsMap.has("deprecatedImportAssert") || pluginsMap.has("importAssertions")) {
            throw new Error("Cannot combine importAssertions, deprecatedImportAssert and moduleAttributes plugins.");
          }
          const moduleAttributesVersionPluginOption = pluginsMap.get("moduleAttributes").version;
          if (moduleAttributesVersionPluginOption !== "may-2020") {
            throw new Error("The 'moduleAttributes' plugin requires a 'version' option, representing the last proposal update. Currently, the only supported value is 'may-2020'.");
          }
        }
      }
      if (pluginsMap.has("importAssertions")) {
        if (pluginsMap.has("deprecatedImportAssert")) {
          throw new Error("Cannot combine importAssertions and deprecatedImportAssert plugins.");
        }
      }
      if (!pluginsMap.has("deprecatedImportAssert") && pluginsMap.has("importAttributes") && pluginsMap.get("importAttributes").deprecatedAssertSyntax) {
        {
          pluginsMap.set("deprecatedImportAssert", {});
        }
      }
      if (pluginsMap.has("recordAndTuple")) {
        const syntaxType = pluginsMap.get("recordAndTuple").syntaxType;
        if (syntaxType != null) {
          {
            const RECORD_AND_TUPLE_SYNTAX_TYPES = ["hash", "bar"];
            if (!RECORD_AND_TUPLE_SYNTAX_TYPES.includes(syntaxType)) {
              throw new Error("The 'syntaxType' option of the 'recordAndTuple' plugin must be one of: " + RECORD_AND_TUPLE_SYNTAX_TYPES.map((p) => `'${p}'`).join(", "));
            }
          }
        }
      }
      if (pluginsMap.has("asyncDoExpressions") && !pluginsMap.has("doExpressions")) {
        const error45 = new Error("'asyncDoExpressions' requires 'doExpressions', please add 'doExpressions' to parser plugins.");
        error45.missingPlugins = "doExpressions";
        throw error45;
      }
      if (pluginsMap.has("optionalChainingAssign") && pluginsMap.get("optionalChainingAssign").version !== "2023-07") {
        throw new Error("The 'optionalChainingAssign' plugin requires a 'version' option, representing the last proposal update. Currently, the only supported value is '2023-07'.");
      }
    }
    var mixinPlugins = {
      estree,
      jsx,
      flow,
      typescript,
      v8intrinsic,
      placeholders
    };
    var mixinPluginNames = Object.keys(mixinPlugins);
    var ExpressionParser = class extends LValParser {
      checkProto(prop, isRecord, sawProto, refExpressionErrors) {
        if (prop.type === "SpreadElement" || this.isObjectMethod(prop) || prop.computed || prop.shorthand) {
          return sawProto;
        }
        const key2 = prop.key;
        const name = key2.type === "Identifier" ? key2.name : key2.value;
        if (name === "__proto__") {
          if (isRecord) {
            this.raise(Errors.RecordNoProto, key2);
            return true;
          }
          if (sawProto) {
            if (refExpressionErrors) {
              if (refExpressionErrors.doubleProtoLoc === null) {
                refExpressionErrors.doubleProtoLoc = key2.loc.start;
              }
            } else {
              this.raise(Errors.DuplicateProto, key2);
            }
          }
          return true;
        }
        return sawProto;
      }
      shouldExitDescending(expr, potentialArrowAt) {
        return expr.type === "ArrowFunctionExpression" && this.offsetToSourcePos(expr.start) === potentialArrowAt;
      }
      getExpression() {
        this.enterInitialScopes();
        this.nextToken();
        const expr = this.parseExpression();
        if (!this.match(140)) {
          this.unexpected();
        }
        this.finalizeRemainingComments();
        expr.comments = this.comments;
        expr.errors = this.state.errors;
        if (this.optionFlags & 256) {
          expr.tokens = this.tokens;
        }
        return expr;
      }
      parseExpression(disallowIn, refExpressionErrors) {
        if (disallowIn) {
          return this.disallowInAnd(() => this.parseExpressionBase(refExpressionErrors));
        }
        return this.allowInAnd(() => this.parseExpressionBase(refExpressionErrors));
      }
      parseExpressionBase(refExpressionErrors) {
        const startLoc = this.state.startLoc;
        const expr = this.parseMaybeAssign(refExpressionErrors);
        if (this.match(12)) {
          const node = this.startNodeAt(startLoc);
          node.expressions = [expr];
          while (this.eat(12)) {
            node.expressions.push(this.parseMaybeAssign(refExpressionErrors));
          }
          this.toReferencedList(node.expressions);
          return this.finishNode(node, "SequenceExpression");
        }
        return expr;
      }
      parseMaybeAssignDisallowIn(refExpressionErrors, afterLeftParse) {
        return this.disallowInAnd(() => this.parseMaybeAssign(refExpressionErrors, afterLeftParse));
      }
      parseMaybeAssignAllowIn(refExpressionErrors, afterLeftParse) {
        return this.allowInAnd(() => this.parseMaybeAssign(refExpressionErrors, afterLeftParse));
      }
      setOptionalParametersError(refExpressionErrors) {
        refExpressionErrors.optionalParametersLoc = this.state.startLoc;
      }
      parseMaybeAssign(refExpressionErrors, afterLeftParse) {
        const startLoc = this.state.startLoc;
        const isYield = this.isContextual(108);
        if (isYield) {
          if (this.prodParam.hasYield) {
            this.next();
            let left2 = this.parseYield(startLoc);
            if (afterLeftParse) {
              left2 = afterLeftParse.call(this, left2, startLoc);
            }
            return left2;
          }
        }
        let ownExpressionErrors;
        if (refExpressionErrors) {
          ownExpressionErrors = false;
        } else {
          refExpressionErrors = new ExpressionErrors();
          ownExpressionErrors = true;
        }
        const {
          type
        } = this.state;
        if (type === 10 || tokenIsIdentifier(type)) {
          this.state.potentialArrowAt = this.state.start;
        }
        let left = this.parseMaybeConditional(refExpressionErrors);
        if (afterLeftParse) {
          left = afterLeftParse.call(this, left, startLoc);
        }
        if (tokenIsAssignment(this.state.type)) {
          const node = this.startNodeAt(startLoc);
          const operator = this.state.value;
          node.operator = operator;
          if (this.match(29)) {
            this.toAssignable(left, true);
            node.left = left;
            const startIndex = startLoc.index;
            if (refExpressionErrors.doubleProtoLoc != null && refExpressionErrors.doubleProtoLoc.index >= startIndex) {
              refExpressionErrors.doubleProtoLoc = null;
            }
            if (refExpressionErrors.shorthandAssignLoc != null && refExpressionErrors.shorthandAssignLoc.index >= startIndex) {
              refExpressionErrors.shorthandAssignLoc = null;
            }
            if (refExpressionErrors.privateKeyLoc != null && refExpressionErrors.privateKeyLoc.index >= startIndex) {
              this.checkDestructuringPrivate(refExpressionErrors);
              refExpressionErrors.privateKeyLoc = null;
            }
          } else {
            node.left = left;
          }
          this.next();
          node.right = this.parseMaybeAssign();
          this.checkLVal(left, this.finishNode(node, "AssignmentExpression"));
          return node;
        } else if (ownExpressionErrors) {
          this.checkExpressionErrors(refExpressionErrors, true);
        }
        if (isYield) {
          const {
            type: type2
          } = this.state;
          const startsExpr2 = this.hasPlugin("v8intrinsic") ? tokenCanStartExpression(type2) : tokenCanStartExpression(type2) && !this.match(54);
          if (startsExpr2 && !this.isAmbiguousPrefixOrIdentifier()) {
            this.raiseOverwrite(Errors.YieldNotInGeneratorFunction, startLoc);
            return this.parseYield(startLoc);
          }
        }
        return left;
      }
      parseMaybeConditional(refExpressionErrors) {
        const startLoc = this.state.startLoc;
        const potentialArrowAt = this.state.potentialArrowAt;
        const expr = this.parseExprOps(refExpressionErrors);
        if (this.shouldExitDescending(expr, potentialArrowAt)) {
          return expr;
        }
        return this.parseConditional(expr, startLoc, refExpressionErrors);
      }
      parseConditional(expr, startLoc, refExpressionErrors) {
        if (this.eat(17)) {
          const node = this.startNodeAt(startLoc);
          node.test = expr;
          node.consequent = this.parseMaybeAssignAllowIn();
          this.expect(14);
          node.alternate = this.parseMaybeAssign();
          return this.finishNode(node, "ConditionalExpression");
        }
        return expr;
      }
      parseMaybeUnaryOrPrivate(refExpressionErrors) {
        return this.match(139) ? this.parsePrivateName() : this.parseMaybeUnary(refExpressionErrors);
      }
      parseExprOps(refExpressionErrors) {
        const startLoc = this.state.startLoc;
        const potentialArrowAt = this.state.potentialArrowAt;
        const expr = this.parseMaybeUnaryOrPrivate(refExpressionErrors);
        if (this.shouldExitDescending(expr, potentialArrowAt)) {
          return expr;
        }
        return this.parseExprOp(expr, startLoc, -1);
      }
      parseExprOp(left, leftStartLoc, minPrec) {
        if (this.isPrivateName(left)) {
          const value = this.getPrivateNameSV(left);
          if (minPrec >= tokenOperatorPrecedence(58) || !this.prodParam.hasIn || !this.match(58)) {
            this.raise(Errors.PrivateInExpectedIn, left, {
              identifierName: value
            });
          }
          this.classScope.usePrivateName(value, left.loc.start);
        }
        const op = this.state.type;
        if (tokenIsOperator(op) && (this.prodParam.hasIn || !this.match(58))) {
          let prec = tokenOperatorPrecedence(op);
          if (prec > minPrec) {
            if (op === 39) {
              this.expectPlugin("pipelineOperator");
              if (this.state.inFSharpPipelineDirectBody) {
                return left;
              }
              this.checkPipelineAtInfixOperator(left, leftStartLoc);
            }
            const node = this.startNodeAt(leftStartLoc);
            node.left = left;
            node.operator = this.state.value;
            const logical = op === 41 || op === 42;
            const coalesce = op === 40;
            if (coalesce) {
              prec = tokenOperatorPrecedence(42);
            }
            this.next();
            if (op === 39 && this.hasPlugin(["pipelineOperator", {
              proposal: "minimal"
            }])) {
              if (this.state.type === 96 && this.prodParam.hasAwait) {
                throw this.raise(Errors.UnexpectedAwaitAfterPipelineBody, this.state.startLoc);
              }
            }
            node.right = this.parseExprOpRightExpr(op, prec);
            const finishedNode = this.finishNode(node, logical || coalesce ? "LogicalExpression" : "BinaryExpression");
            const nextOp = this.state.type;
            if (coalesce && (nextOp === 41 || nextOp === 42) || logical && nextOp === 40) {
              throw this.raise(Errors.MixingCoalesceWithLogical, this.state.startLoc);
            }
            return this.parseExprOp(finishedNode, leftStartLoc, minPrec);
          }
        }
        return left;
      }
      parseExprOpRightExpr(op, prec) {
        const startLoc = this.state.startLoc;
        switch (op) {
          case 39:
            switch (this.getPluginOption("pipelineOperator", "proposal")) {
              case "hack":
                return this.withTopicBindingContext(() => {
                  return this.parseHackPipeBody();
                });
              case "fsharp":
                return this.withSoloAwaitPermittingContext(() => {
                  return this.parseFSharpPipelineBody(prec);
                });
            }
            if (this.getPluginOption("pipelineOperator", "proposal") === "smart") {
              return this.withTopicBindingContext(() => {
                if (this.prodParam.hasYield && this.isContextual(108)) {
                  throw this.raise(Errors.PipeBodyIsTighter, this.state.startLoc);
                }
                return this.parseSmartPipelineBodyInStyle(this.parseExprOpBaseRightExpr(op, prec), startLoc);
              });
            }
          default:
            return this.parseExprOpBaseRightExpr(op, prec);
        }
      }
      parseExprOpBaseRightExpr(op, prec) {
        const startLoc = this.state.startLoc;
        return this.parseExprOp(this.parseMaybeUnaryOrPrivate(), startLoc, tokenIsRightAssociative(op) ? prec - 1 : prec);
      }
      parseHackPipeBody() {
        var _body$extra;
        const {
          startLoc
        } = this.state;
        const body = this.parseMaybeAssign();
        const requiredParentheses = UnparenthesizedPipeBodyDescriptions.has(body.type);
        if (requiredParentheses && !((_body$extra = body.extra) != null && _body$extra.parenthesized)) {
          this.raise(Errors.PipeUnparenthesizedBody, startLoc, {
            type: body.type
          });
        }
        if (!this.topicReferenceWasUsedInCurrentContext()) {
          this.raise(Errors.PipeTopicUnused, startLoc);
        }
        return body;
      }
      checkExponentialAfterUnary(node) {
        if (this.match(57)) {
          this.raise(Errors.UnexpectedTokenUnaryExponentiation, node.argument);
        }
      }
      parseMaybeUnary(refExpressionErrors, sawUnary) {
        const startLoc = this.state.startLoc;
        const isAwait = this.isContextual(96);
        if (isAwait && this.recordAwaitIfAllowed()) {
          this.next();
          const expr2 = this.parseAwait(startLoc);
          if (!sawUnary) this.checkExponentialAfterUnary(expr2);
          return expr2;
        }
        const update2 = this.match(34);
        const node = this.startNode();
        if (tokenIsPrefix(this.state.type)) {
          node.operator = this.state.value;
          node.prefix = true;
          if (this.match(72)) {
            this.expectPlugin("throwExpressions");
          }
          const isDelete = this.match(89);
          this.next();
          node.argument = this.parseMaybeUnary(null, true);
          this.checkExpressionErrors(refExpressionErrors, true);
          if (this.state.strict && isDelete) {
            const arg = node.argument;
            if (arg.type === "Identifier") {
              this.raise(Errors.StrictDelete, node);
            } else if (this.hasPropertyAsPrivateName(arg)) {
              this.raise(Errors.DeletePrivateField, node);
            }
          }
          if (!update2) {
            if (!sawUnary) {
              this.checkExponentialAfterUnary(node);
            }
            return this.finishNode(node, "UnaryExpression");
          }
        }
        const expr = this.parseUpdate(node, update2, refExpressionErrors);
        if (isAwait) {
          const {
            type
          } = this.state;
          const startsExpr2 = this.hasPlugin("v8intrinsic") ? tokenCanStartExpression(type) : tokenCanStartExpression(type) && !this.match(54);
          if (startsExpr2 && !this.isAmbiguousPrefixOrIdentifier()) {
            this.raiseOverwrite(Errors.AwaitNotInAsyncContext, startLoc);
            return this.parseAwait(startLoc);
          }
        }
        return expr;
      }
      parseUpdate(node, update2, refExpressionErrors) {
        if (update2) {
          const updateExpressionNode = node;
          this.checkLVal(updateExpressionNode.argument, this.finishNode(updateExpressionNode, "UpdateExpression"));
          return node;
        }
        const startLoc = this.state.startLoc;
        let expr = this.parseExprSubscripts(refExpressionErrors);
        if (this.checkExpressionErrors(refExpressionErrors, false)) return expr;
        while (tokenIsPostfix(this.state.type) && !this.canInsertSemicolon()) {
          const node2 = this.startNodeAt(startLoc);
          node2.operator = this.state.value;
          node2.prefix = false;
          node2.argument = expr;
          this.next();
          this.checkLVal(expr, expr = this.finishNode(node2, "UpdateExpression"));
        }
        return expr;
      }
      parseExprSubscripts(refExpressionErrors) {
        const startLoc = this.state.startLoc;
        const potentialArrowAt = this.state.potentialArrowAt;
        const expr = this.parseExprAtom(refExpressionErrors);
        if (this.shouldExitDescending(expr, potentialArrowAt)) {
          return expr;
        }
        return this.parseSubscripts(expr, startLoc);
      }
      parseSubscripts(base, startLoc, noCalls) {
        const state = {
          optionalChainMember: false,
          maybeAsyncArrow: this.atPossibleAsyncArrow(base),
          stop: false
        };
        do {
          base = this.parseSubscript(base, startLoc, noCalls, state);
          state.maybeAsyncArrow = false;
        } while (!state.stop);
        return base;
      }
      parseSubscript(base, startLoc, noCalls, state) {
        const {
          type
        } = this.state;
        if (!noCalls && type === 15) {
          return this.parseBind(base, startLoc, noCalls, state);
        } else if (tokenIsTemplate(type)) {
          return this.parseTaggedTemplateExpression(base, startLoc, state);
        }
        let optional2 = false;
        if (type === 18) {
          if (noCalls) {
            this.raise(Errors.OptionalChainingNoNew, this.state.startLoc);
            if (this.lookaheadCharCode() === 40) {
              state.stop = true;
              return base;
            }
          }
          state.optionalChainMember = optional2 = true;
          this.next();
        }
        if (!noCalls && this.match(10)) {
          return this.parseCoverCallAndAsyncArrowHead(base, startLoc, state, optional2);
        } else {
          const computed = this.eat(0);
          if (computed || optional2 || this.eat(16)) {
            return this.parseMember(base, startLoc, state, computed, optional2);
          } else {
            state.stop = true;
            return base;
          }
        }
      }
      parseMember(base, startLoc, state, computed, optional2) {
        const node = this.startNodeAt(startLoc);
        node.object = base;
        node.computed = computed;
        if (computed) {
          node.property = this.parseExpression();
          this.expect(3);
        } else if (this.match(139)) {
          if (base.type === "Super") {
            this.raise(Errors.SuperPrivateField, startLoc);
          }
          this.classScope.usePrivateName(this.state.value, this.state.startLoc);
          node.property = this.parsePrivateName();
        } else {
          node.property = this.parseIdentifier(true);
        }
        if (state.optionalChainMember) {
          node.optional = optional2;
          return this.finishNode(node, "OptionalMemberExpression");
        } else {
          return this.finishNode(node, "MemberExpression");
        }
      }
      parseBind(base, startLoc, noCalls, state) {
        const node = this.startNodeAt(startLoc);
        node.object = base;
        this.next();
        node.callee = this.parseNoCallExpr();
        state.stop = true;
        return this.parseSubscripts(this.finishNode(node, "BindExpression"), startLoc, noCalls);
      }
      parseCoverCallAndAsyncArrowHead(base, startLoc, state, optional2) {
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        let refExpressionErrors = null;
        this.state.maybeInArrowParameters = true;
        this.next();
        const node = this.startNodeAt(startLoc);
        node.callee = base;
        const {
          maybeAsyncArrow,
          optionalChainMember
        } = state;
        if (maybeAsyncArrow) {
          this.expressionScope.enter(newAsyncArrowScope());
          refExpressionErrors = new ExpressionErrors();
        }
        if (optionalChainMember) {
          node.optional = optional2;
        }
        if (optional2) {
          node.arguments = this.parseCallExpressionArguments(11);
        } else {
          node.arguments = this.parseCallExpressionArguments(11, base.type !== "Super", node, refExpressionErrors);
        }
        let finishedNode = this.finishCallExpression(node, optionalChainMember);
        if (maybeAsyncArrow && this.shouldParseAsyncArrow() && !optional2) {
          state.stop = true;
          this.checkDestructuringPrivate(refExpressionErrors);
          this.expressionScope.validateAsPattern();
          this.expressionScope.exit();
          finishedNode = this.parseAsyncArrowFromCallExpression(this.startNodeAt(startLoc), finishedNode);
        } else {
          if (maybeAsyncArrow) {
            this.checkExpressionErrors(refExpressionErrors, true);
            this.expressionScope.exit();
          }
          this.toReferencedArguments(finishedNode);
        }
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        return finishedNode;
      }
      toReferencedArguments(node, isParenthesizedExpr) {
        this.toReferencedListDeep(node.arguments, isParenthesizedExpr);
      }
      parseTaggedTemplateExpression(base, startLoc, state) {
        const node = this.startNodeAt(startLoc);
        node.tag = base;
        node.quasi = this.parseTemplate(true);
        if (state.optionalChainMember) {
          this.raise(Errors.OptionalChainingNoTemplate, startLoc);
        }
        return this.finishNode(node, "TaggedTemplateExpression");
      }
      atPossibleAsyncArrow(base) {
        return base.type === "Identifier" && base.name === "async" && this.state.lastTokEndLoc.index === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 && this.offsetToSourcePos(base.start) === this.state.potentialArrowAt;
      }
      finishCallExpression(node, optional2) {
        if (node.callee.type === "Import") {
          if (node.arguments.length === 0 || node.arguments.length > 2) {
            this.raise(Errors.ImportCallArity, node);
          } else {
            for (const arg of node.arguments) {
              if (arg.type === "SpreadElement") {
                this.raise(Errors.ImportCallSpreadArgument, arg);
              }
            }
          }
        }
        return this.finishNode(node, optional2 ? "OptionalCallExpression" : "CallExpression");
      }
      parseCallExpressionArguments(close, allowPlaceholder, nodeForExtra, refExpressionErrors) {
        const elts = [];
        let first = true;
        const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
        this.state.inFSharpPipelineDirectBody = false;
        while (!this.eat(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(12);
            if (this.match(close)) {
              if (nodeForExtra) {
                this.addTrailingCommaExtraToNode(nodeForExtra);
              }
              this.next();
              break;
            }
          }
          elts.push(this.parseExprListItem(false, refExpressionErrors, allowPlaceholder));
        }
        this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
        return elts;
      }
      shouldParseAsyncArrow() {
        return this.match(19) && !this.canInsertSemicolon();
      }
      parseAsyncArrowFromCallExpression(node, call) {
        var _call$extra;
        this.resetPreviousNodeTrailingComments(call);
        this.expect(19);
        this.parseArrowExpression(node, call.arguments, true, (_call$extra = call.extra) == null ? void 0 : _call$extra.trailingCommaLoc);
        if (call.innerComments) {
          setInnerComments(node, call.innerComments);
        }
        if (call.callee.trailingComments) {
          setInnerComments(node, call.callee.trailingComments);
        }
        return node;
      }
      parseNoCallExpr() {
        const startLoc = this.state.startLoc;
        return this.parseSubscripts(this.parseExprAtom(), startLoc, true);
      }
      parseExprAtom(refExpressionErrors) {
        let node;
        let decorators = null;
        const {
          type
        } = this.state;
        switch (type) {
          case 79:
            return this.parseSuper();
          case 83:
            node = this.startNode();
            this.next();
            if (this.match(16)) {
              return this.parseImportMetaProperty(node);
            }
            if (this.match(10)) {
              if (this.optionFlags & 512) {
                return this.parseImportCall(node);
              } else {
                return this.finishNode(node, "Import");
              }
            } else {
              this.raise(Errors.UnsupportedImport, this.state.lastTokStartLoc);
              return this.finishNode(node, "Import");
            }
          case 78:
            node = this.startNode();
            this.next();
            return this.finishNode(node, "ThisExpression");
          case 90: {
            return this.parseDo(this.startNode(), false);
          }
          case 56:
          case 31: {
            this.readRegexp();
            return this.parseRegExpLiteral(this.state.value);
          }
          case 135:
            return this.parseNumericLiteral(this.state.value);
          case 136:
            return this.parseBigIntLiteral(this.state.value);
          case 134:
            return this.parseStringLiteral(this.state.value);
          case 84:
            return this.parseNullLiteral();
          case 85:
            return this.parseBooleanLiteral(true);
          case 86:
            return this.parseBooleanLiteral(false);
          case 10: {
            const canBeArrow = this.state.potentialArrowAt === this.state.start;
            return this.parseParenAndDistinguishExpression(canBeArrow);
          }
          case 2:
          case 1: {
            return this.parseArrayLike(this.state.type === 2 ? 4 : 3, false, true);
          }
          case 0: {
            return this.parseArrayLike(3, true, false, refExpressionErrors);
          }
          case 6:
          case 7: {
            return this.parseObjectLike(this.state.type === 6 ? 9 : 8, false, true);
          }
          case 5: {
            return this.parseObjectLike(8, false, false, refExpressionErrors);
          }
          case 68:
            return this.parseFunctionOrFunctionSent();
          case 26:
            decorators = this.parseDecorators();
          case 80:
            return this.parseClass(this.maybeTakeDecorators(decorators, this.startNode()), false);
          case 77:
            return this.parseNewOrNewTarget();
          case 25:
          case 24:
            return this.parseTemplate(false);
          case 15: {
            node = this.startNode();
            this.next();
            node.object = null;
            const callee = node.callee = this.parseNoCallExpr();
            if (callee.type === "MemberExpression") {
              return this.finishNode(node, "BindExpression");
            } else {
              throw this.raise(Errors.UnsupportedBind, callee);
            }
          }
          case 139: {
            this.raise(Errors.PrivateInExpectedIn, this.state.startLoc, {
              identifierName: this.state.value
            });
            return this.parsePrivateName();
          }
          case 33: {
            return this.parseTopicReferenceThenEqualsSign(54, "%");
          }
          case 32: {
            return this.parseTopicReferenceThenEqualsSign(44, "^");
          }
          case 37:
          case 38: {
            return this.parseTopicReference("hack");
          }
          case 44:
          case 54:
          case 27: {
            const pipeProposal = this.getPluginOption("pipelineOperator", "proposal");
            if (pipeProposal) {
              return this.parseTopicReference(pipeProposal);
            }
            this.unexpected();
            break;
          }
          case 47: {
            const lookaheadCh = this.input.codePointAt(this.nextTokenStart());
            if (isIdentifierStart(lookaheadCh) || lookaheadCh === 62) {
              this.expectOnePlugin(["jsx", "flow", "typescript"]);
            } else {
              this.unexpected();
            }
            break;
          }
          default:
            if (type === 137) {
              return this.parseDecimalLiteral(this.state.value);
            }
            if (tokenIsIdentifier(type)) {
              if (this.isContextual(127) && this.lookaheadInLineCharCode() === 123) {
                return this.parseModuleExpression();
              }
              const canBeArrow = this.state.potentialArrowAt === this.state.start;
              const containsEsc = this.state.containsEsc;
              const id = this.parseIdentifier();
              if (!containsEsc && id.name === "async" && !this.canInsertSemicolon()) {
                const {
                  type: type2
                } = this.state;
                if (type2 === 68) {
                  this.resetPreviousNodeTrailingComments(id);
                  this.next();
                  return this.parseAsyncFunctionExpression(this.startNodeAtNode(id));
                } else if (tokenIsIdentifier(type2)) {
                  if (this.lookaheadCharCode() === 61) {
                    return this.parseAsyncArrowUnaryFunction(this.startNodeAtNode(id));
                  } else {
                    return id;
                  }
                } else if (type2 === 90) {
                  this.resetPreviousNodeTrailingComments(id);
                  return this.parseDo(this.startNodeAtNode(id), true);
                }
              }
              if (canBeArrow && this.match(19) && !this.canInsertSemicolon()) {
                this.next();
                return this.parseArrowExpression(this.startNodeAtNode(id), [id], false);
              }
              return id;
            } else {
              this.unexpected();
            }
        }
      }
      parseTopicReferenceThenEqualsSign(topicTokenType, topicTokenValue) {
        const pipeProposal = this.getPluginOption("pipelineOperator", "proposal");
        if (pipeProposal) {
          this.state.type = topicTokenType;
          this.state.value = topicTokenValue;
          this.state.pos--;
          this.state.end--;
          this.state.endLoc = createPositionWithColumnOffset(this.state.endLoc, -1);
          return this.parseTopicReference(pipeProposal);
        } else {
          this.unexpected();
        }
      }
      parseTopicReference(pipeProposal) {
        const node = this.startNode();
        const startLoc = this.state.startLoc;
        const tokenType = this.state.type;
        this.next();
        return this.finishTopicReference(node, startLoc, pipeProposal, tokenType);
      }
      finishTopicReference(node, startLoc, pipeProposal, tokenType) {
        if (this.testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType)) {
          if (pipeProposal === "hack") {
            if (!this.topicReferenceIsAllowedInCurrentContext()) {
              this.raise(Errors.PipeTopicUnbound, startLoc);
            }
            this.registerTopicReference();
            return this.finishNode(node, "TopicReference");
          } else {
            if (!this.topicReferenceIsAllowedInCurrentContext()) {
              this.raise(Errors.PrimaryTopicNotAllowed, startLoc);
            }
            this.registerTopicReference();
            return this.finishNode(node, "PipelinePrimaryTopicReference");
          }
        } else {
          throw this.raise(Errors.PipeTopicUnconfiguredToken, startLoc, {
            token: tokenLabelName(tokenType)
          });
        }
      }
      testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType) {
        switch (pipeProposal) {
          case "hack": {
            return this.hasPlugin(["pipelineOperator", {
              topicToken: tokenLabelName(tokenType)
            }]);
          }
          case "smart":
            return tokenType === 27;
          default:
            throw this.raise(Errors.PipeTopicRequiresHackPipes, startLoc);
        }
      }
      parseAsyncArrowUnaryFunction(node) {
        this.prodParam.enter(functionFlags(true, this.prodParam.hasYield));
        const params = [this.parseIdentifier()];
        this.prodParam.exit();
        if (this.hasPrecedingLineBreak()) {
          this.raise(Errors.LineTerminatorBeforeArrow, this.state.curPosition());
        }
        this.expect(19);
        return this.parseArrowExpression(node, params, true);
      }
      parseDo(node, isAsync) {
        this.expectPlugin("doExpressions");
        if (isAsync) {
          this.expectPlugin("asyncDoExpressions");
        }
        node.async = isAsync;
        this.next();
        const oldLabels = this.state.labels;
        this.state.labels = [];
        if (isAsync) {
          this.prodParam.enter(2);
          node.body = this.parseBlock();
          this.prodParam.exit();
        } else {
          node.body = this.parseBlock();
        }
        this.state.labels = oldLabels;
        return this.finishNode(node, "DoExpression");
      }
      parseSuper() {
        const node = this.startNode();
        this.next();
        if (this.match(10) && !this.scope.allowDirectSuper && !(this.optionFlags & 16)) {
          this.raise(Errors.SuperNotAllowed, node);
        } else if (!this.scope.allowSuper && !(this.optionFlags & 16)) {
          this.raise(Errors.UnexpectedSuper, node);
        }
        if (!this.match(10) && !this.match(0) && !this.match(16)) {
          this.raise(Errors.UnsupportedSuper, node);
        }
        return this.finishNode(node, "Super");
      }
      parsePrivateName() {
        const node = this.startNode();
        const id = this.startNodeAt(createPositionWithColumnOffset(this.state.startLoc, 1));
        const name = this.state.value;
        this.next();
        node.id = this.createIdentifier(id, name);
        return this.finishNode(node, "PrivateName");
      }
      parseFunctionOrFunctionSent() {
        const node = this.startNode();
        this.next();
        if (this.prodParam.hasYield && this.match(16)) {
          const meta = this.createIdentifier(this.startNodeAtNode(node), "function");
          this.next();
          if (this.match(103)) {
            this.expectPlugin("functionSent");
          } else if (!this.hasPlugin("functionSent")) {
            this.unexpected();
          }
          return this.parseMetaProperty(node, meta, "sent");
        }
        return this.parseFunction(node);
      }
      parseMetaProperty(node, meta, propertyName) {
        node.meta = meta;
        const containsEsc = this.state.containsEsc;
        node.property = this.parseIdentifier(true);
        if (node.property.name !== propertyName || containsEsc) {
          this.raise(Errors.UnsupportedMetaProperty, node.property, {
            target: meta.name,
            onlyValidPropertyName: propertyName
          });
        }
        return this.finishNode(node, "MetaProperty");
      }
      parseImportMetaProperty(node) {
        const id = this.createIdentifier(this.startNodeAtNode(node), "import");
        this.next();
        if (this.isContextual(101)) {
          if (!this.inModule) {
            this.raise(Errors.ImportMetaOutsideModule, id);
          }
          this.sawUnambiguousESM = true;
        } else if (this.isContextual(105) || this.isContextual(97)) {
          const isSource = this.isContextual(105);
          this.expectPlugin(isSource ? "sourcePhaseImports" : "deferredImportEvaluation");
          if (!(this.optionFlags & 512)) {
            throw this.raise(Errors.DynamicImportPhaseRequiresImportExpressions, this.state.startLoc, {
              phase: this.state.value
            });
          }
          this.next();
          node.phase = isSource ? "source" : "defer";
          return this.parseImportCall(node);
        }
        return this.parseMetaProperty(node, id, "meta");
      }
      parseLiteralAtNode(value, type, node) {
        this.addExtra(node, "rawValue", value);
        this.addExtra(node, "raw", this.input.slice(this.offsetToSourcePos(node.start), this.state.end));
        node.value = value;
        this.next();
        return this.finishNode(node, type);
      }
      parseLiteral(value, type) {
        const node = this.startNode();
        return this.parseLiteralAtNode(value, type, node);
      }
      parseStringLiteral(value) {
        return this.parseLiteral(value, "StringLiteral");
      }
      parseNumericLiteral(value) {
        return this.parseLiteral(value, "NumericLiteral");
      }
      parseBigIntLiteral(value) {
        return this.parseLiteral(value, "BigIntLiteral");
      }
      parseDecimalLiteral(value) {
        return this.parseLiteral(value, "DecimalLiteral");
      }
      parseRegExpLiteral(value) {
        const node = this.startNode();
        this.addExtra(node, "raw", this.input.slice(this.offsetToSourcePos(node.start), this.state.end));
        node.pattern = value.pattern;
        node.flags = value.flags;
        this.next();
        return this.finishNode(node, "RegExpLiteral");
      }
      parseBooleanLiteral(value) {
        const node = this.startNode();
        node.value = value;
        this.next();
        return this.finishNode(node, "BooleanLiteral");
      }
      parseNullLiteral() {
        const node = this.startNode();
        this.next();
        return this.finishNode(node, "NullLiteral");
      }
      parseParenAndDistinguishExpression(canBeArrow) {
        const startLoc = this.state.startLoc;
        let val;
        this.next();
        this.expressionScope.enter(newArrowHeadScope());
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
        this.state.maybeInArrowParameters = true;
        this.state.inFSharpPipelineDirectBody = false;
        const innerStartLoc = this.state.startLoc;
        const exprList = [];
        const refExpressionErrors = new ExpressionErrors();
        let first = true;
        let spreadStartLoc;
        let optionalCommaStartLoc;
        while (!this.match(11)) {
          if (first) {
            first = false;
          } else {
            this.expect(12, refExpressionErrors.optionalParametersLoc === null ? null : refExpressionErrors.optionalParametersLoc);
            if (this.match(11)) {
              optionalCommaStartLoc = this.state.startLoc;
              break;
            }
          }
          if (this.match(21)) {
            const spreadNodeStartLoc = this.state.startLoc;
            spreadStartLoc = this.state.startLoc;
            exprList.push(this.parseParenItem(this.parseRestBinding(), spreadNodeStartLoc));
            if (!this.checkCommaAfterRest(41)) {
              break;
            }
          } else {
            exprList.push(this.parseMaybeAssignAllowIn(refExpressionErrors, this.parseParenItem));
          }
        }
        const innerEndLoc = this.state.lastTokEndLoc;
        this.expect(11);
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
        let arrowNode = this.startNodeAt(startLoc);
        if (canBeArrow && this.shouldParseArrow(exprList) && (arrowNode = this.parseArrow(arrowNode))) {
          this.checkDestructuringPrivate(refExpressionErrors);
          this.expressionScope.validateAsPattern();
          this.expressionScope.exit();
          this.parseArrowExpression(arrowNode, exprList, false);
          return arrowNode;
        }
        this.expressionScope.exit();
        if (!exprList.length) {
          this.unexpected(this.state.lastTokStartLoc);
        }
        if (optionalCommaStartLoc) this.unexpected(optionalCommaStartLoc);
        if (spreadStartLoc) this.unexpected(spreadStartLoc);
        this.checkExpressionErrors(refExpressionErrors, true);
        this.toReferencedListDeep(exprList, true);
        if (exprList.length > 1) {
          val = this.startNodeAt(innerStartLoc);
          val.expressions = exprList;
          this.finishNode(val, "SequenceExpression");
          this.resetEndLocation(val, innerEndLoc);
        } else {
          val = exprList[0];
        }
        return this.wrapParenthesis(startLoc, val);
      }
      wrapParenthesis(startLoc, expression) {
        if (!(this.optionFlags & 1024)) {
          this.addExtra(expression, "parenthesized", true);
          this.addExtra(expression, "parenStart", startLoc.index);
          this.takeSurroundingComments(expression, startLoc.index, this.state.lastTokEndLoc.index);
          return expression;
        }
        const parenExpression = this.startNodeAt(startLoc);
        parenExpression.expression = expression;
        return this.finishNode(parenExpression, "ParenthesizedExpression");
      }
      shouldParseArrow(params) {
        return !this.canInsertSemicolon();
      }
      parseArrow(node) {
        if (this.eat(19)) {
          return node;
        }
      }
      parseParenItem(node, startLoc) {
        return node;
      }
      parseNewOrNewTarget() {
        const node = this.startNode();
        this.next();
        if (this.match(16)) {
          const meta = this.createIdentifier(this.startNodeAtNode(node), "new");
          this.next();
          const metaProp = this.parseMetaProperty(node, meta, "target");
          if (!this.scope.inNonArrowFunction && !this.scope.inClass && !(this.optionFlags & 4)) {
            this.raise(Errors.UnexpectedNewTarget, metaProp);
          }
          return metaProp;
        }
        return this.parseNew(node);
      }
      parseNew(node) {
        this.parseNewCallee(node);
        if (this.eat(10)) {
          const args = this.parseExprList(11);
          this.toReferencedList(args);
          node.arguments = args;
        } else {
          node.arguments = [];
        }
        return this.finishNode(node, "NewExpression");
      }
      parseNewCallee(node) {
        const isImport = this.match(83);
        const callee = this.parseNoCallExpr();
        node.callee = callee;
        if (isImport && (callee.type === "Import" || callee.type === "ImportExpression")) {
          this.raise(Errors.ImportCallNotNewExpression, callee);
        }
      }
      parseTemplateElement(isTagged) {
        const {
          start,
          startLoc,
          end,
          value
        } = this.state;
        const elemStart = start + 1;
        const elem = this.startNodeAt(createPositionWithColumnOffset(startLoc, 1));
        if (value === null) {
          if (!isTagged) {
            this.raise(Errors.InvalidEscapeSequenceTemplate, createPositionWithColumnOffset(this.state.firstInvalidTemplateEscapePos, 1));
          }
        }
        const isTail = this.match(24);
        const endOffset = isTail ? -1 : -2;
        const elemEnd = end + endOffset;
        elem.value = {
          raw: this.input.slice(elemStart, elemEnd).replace(/\r\n?/g, "\n"),
          cooked: value === null ? null : value.slice(1, endOffset)
        };
        elem.tail = isTail;
        this.next();
        const finishedNode = this.finishNode(elem, "TemplateElement");
        this.resetEndLocation(finishedNode, createPositionWithColumnOffset(this.state.lastTokEndLoc, endOffset));
        return finishedNode;
      }
      parseTemplate(isTagged) {
        const node = this.startNode();
        let curElt = this.parseTemplateElement(isTagged);
        const quasis = [curElt];
        const substitutions = [];
        while (!curElt.tail) {
          substitutions.push(this.parseTemplateSubstitution());
          this.readTemplateContinuation();
          quasis.push(curElt = this.parseTemplateElement(isTagged));
        }
        node.expressions = substitutions;
        node.quasis = quasis;
        return this.finishNode(node, "TemplateLiteral");
      }
      parseTemplateSubstitution() {
        return this.parseExpression();
      }
      parseObjectLike(close, isPattern, isRecord, refExpressionErrors) {
        if (isRecord) {
          this.expectPlugin("recordAndTuple");
        }
        const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
        this.state.inFSharpPipelineDirectBody = false;
        let sawProto = false;
        let first = true;
        const node = this.startNode();
        node.properties = [];
        this.next();
        while (!this.match(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(12);
            if (this.match(close)) {
              this.addTrailingCommaExtraToNode(node);
              break;
            }
          }
          let prop;
          if (isPattern) {
            prop = this.parseBindingProperty();
          } else {
            prop = this.parsePropertyDefinition(refExpressionErrors);
            sawProto = this.checkProto(prop, isRecord, sawProto, refExpressionErrors);
          }
          if (isRecord && !this.isObjectProperty(prop) && prop.type !== "SpreadElement") {
            this.raise(Errors.InvalidRecordProperty, prop);
          }
          {
            if (prop.shorthand) {
              this.addExtra(prop, "shorthand", true);
            }
          }
          node.properties.push(prop);
        }
        this.next();
        this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
        let type = "ObjectExpression";
        if (isPattern) {
          type = "ObjectPattern";
        } else if (isRecord) {
          type = "RecordExpression";
        }
        return this.finishNode(node, type);
      }
      addTrailingCommaExtraToNode(node) {
        this.addExtra(node, "trailingComma", this.state.lastTokStartLoc.index);
        this.addExtra(node, "trailingCommaLoc", this.state.lastTokStartLoc, false);
      }
      maybeAsyncOrAccessorProp(prop) {
        return !prop.computed && prop.key.type === "Identifier" && (this.isLiteralPropertyName() || this.match(0) || this.match(55));
      }
      parsePropertyDefinition(refExpressionErrors) {
        let decorators = [];
        if (this.match(26)) {
          if (this.hasPlugin("decorators")) {
            this.raise(Errors.UnsupportedPropertyDecorator, this.state.startLoc);
          }
          while (this.match(26)) {
            decorators.push(this.parseDecorator());
          }
        }
        const prop = this.startNode();
        let isAsync = false;
        let isAccessor = false;
        let startLoc;
        if (this.match(21)) {
          if (decorators.length) this.unexpected();
          return this.parseSpread();
        }
        if (decorators.length) {
          prop.decorators = decorators;
          decorators = [];
        }
        prop.method = false;
        if (refExpressionErrors) {
          startLoc = this.state.startLoc;
        }
        let isGenerator = this.eat(55);
        this.parsePropertyNamePrefixOperator(prop);
        const containsEsc = this.state.containsEsc;
        this.parsePropertyName(prop, refExpressionErrors);
        if (!isGenerator && !containsEsc && this.maybeAsyncOrAccessorProp(prop)) {
          const {
            key: key2
          } = prop;
          const keyName = key2.name;
          if (keyName === "async" && !this.hasPrecedingLineBreak()) {
            isAsync = true;
            this.resetPreviousNodeTrailingComments(key2);
            isGenerator = this.eat(55);
            this.parsePropertyName(prop);
          }
          if (keyName === "get" || keyName === "set") {
            isAccessor = true;
            this.resetPreviousNodeTrailingComments(key2);
            prop.kind = keyName;
            if (this.match(55)) {
              isGenerator = true;
              this.raise(Errors.AccessorIsGenerator, this.state.curPosition(), {
                kind: keyName
              });
              this.next();
            }
            this.parsePropertyName(prop);
          }
        }
        return this.parseObjPropValue(prop, startLoc, isGenerator, isAsync, false, isAccessor, refExpressionErrors);
      }
      getGetterSetterExpectedParamCount(method) {
        return method.kind === "get" ? 0 : 1;
      }
      getObjectOrClassMethodParams(method) {
        return method.params;
      }
      checkGetterSetterParams(method) {
        var _params;
        const paramCount = this.getGetterSetterExpectedParamCount(method);
        const params = this.getObjectOrClassMethodParams(method);
        if (params.length !== paramCount) {
          this.raise(method.kind === "get" ? Errors.BadGetterArity : Errors.BadSetterArity, method);
        }
        if (method.kind === "set" && ((_params = params[params.length - 1]) == null ? void 0 : _params.type) === "RestElement") {
          this.raise(Errors.BadSetterRestParameter, method);
        }
      }
      parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
        if (isAccessor) {
          const finishedProp = this.parseMethod(prop, isGenerator, false, false, false, "ObjectMethod");
          this.checkGetterSetterParams(finishedProp);
          return finishedProp;
        }
        if (isAsync || isGenerator || this.match(10)) {
          if (isPattern) this.unexpected();
          prop.kind = "method";
          prop.method = true;
          return this.parseMethod(prop, isGenerator, isAsync, false, false, "ObjectMethod");
        }
      }
      parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
        prop.shorthand = false;
        if (this.eat(14)) {
          prop.value = isPattern ? this.parseMaybeDefault(this.state.startLoc) : this.parseMaybeAssignAllowIn(refExpressionErrors);
          return this.finishNode(prop, "ObjectProperty");
        }
        if (!prop.computed && prop.key.type === "Identifier") {
          this.checkReservedWord(prop.key.name, prop.key.loc.start, true, false);
          if (isPattern) {
            prop.value = this.parseMaybeDefault(startLoc, cloneIdentifier(prop.key));
          } else if (this.match(29)) {
            const shorthandAssignLoc = this.state.startLoc;
            if (refExpressionErrors != null) {
              if (refExpressionErrors.shorthandAssignLoc === null) {
                refExpressionErrors.shorthandAssignLoc = shorthandAssignLoc;
              }
            } else {
              this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
            }
            prop.value = this.parseMaybeDefault(startLoc, cloneIdentifier(prop.key));
          } else {
            prop.value = cloneIdentifier(prop.key);
          }
          prop.shorthand = true;
          return this.finishNode(prop, "ObjectProperty");
        }
      }
      parseObjPropValue(prop, startLoc, isGenerator, isAsync, isPattern, isAccessor, refExpressionErrors) {
        const node = this.parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) || this.parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors);
        if (!node) this.unexpected();
        return node;
      }
      parsePropertyName(prop, refExpressionErrors) {
        if (this.eat(0)) {
          prop.computed = true;
          prop.key = this.parseMaybeAssignAllowIn();
          this.expect(3);
        } else {
          const {
            type,
            value
          } = this.state;
          let key2;
          if (tokenIsKeywordOrIdentifier(type)) {
            key2 = this.parseIdentifier(true);
          } else {
            switch (type) {
              case 135:
                key2 = this.parseNumericLiteral(value);
                break;
              case 134:
                key2 = this.parseStringLiteral(value);
                break;
              case 136:
                key2 = this.parseBigIntLiteral(value);
                break;
              case 139: {
                const privateKeyLoc = this.state.startLoc;
                if (refExpressionErrors != null) {
                  if (refExpressionErrors.privateKeyLoc === null) {
                    refExpressionErrors.privateKeyLoc = privateKeyLoc;
                  }
                } else {
                  this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
                }
                key2 = this.parsePrivateName();
                break;
              }
              default:
                if (type === 137) {
                  key2 = this.parseDecimalLiteral(value);
                  break;
                }
                this.unexpected();
            }
          }
          prop.key = key2;
          if (type !== 139) {
            prop.computed = false;
          }
        }
      }
      initFunction(node, isAsync) {
        node.id = null;
        node.generator = false;
        node.async = isAsync;
      }
      parseMethod(node, isGenerator, isAsync, isConstructor, allowDirectSuper, type, inClassScope = false) {
        this.initFunction(node, isAsync);
        node.generator = isGenerator;
        this.scope.enter(2 | 16 | (inClassScope ? 64 : 0) | (allowDirectSuper ? 32 : 0));
        this.prodParam.enter(functionFlags(isAsync, node.generator));
        this.parseFunctionParams(node, isConstructor);
        const finishedNode = this.parseFunctionBodyAndFinish(node, type, true);
        this.prodParam.exit();
        this.scope.exit();
        return finishedNode;
      }
      parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
        if (isTuple) {
          this.expectPlugin("recordAndTuple");
        }
        const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
        this.state.inFSharpPipelineDirectBody = false;
        const node = this.startNode();
        this.next();
        node.elements = this.parseExprList(close, !isTuple, refExpressionErrors, node);
        this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
        return this.finishNode(node, isTuple ? "TupleExpression" : "ArrayExpression");
      }
      parseArrowExpression(node, params, isAsync, trailingCommaLoc) {
        this.scope.enter(2 | 4);
        let flags = functionFlags(isAsync, false);
        if (!this.match(5) && this.prodParam.hasIn) {
          flags |= 8;
        }
        this.prodParam.enter(flags);
        this.initFunction(node, isAsync);
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        if (params) {
          this.state.maybeInArrowParameters = true;
          this.setArrowFunctionParameters(node, params, trailingCommaLoc);
        }
        this.state.maybeInArrowParameters = false;
        this.parseFunctionBody(node, true);
        this.prodParam.exit();
        this.scope.exit();
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        return this.finishNode(node, "ArrowFunctionExpression");
      }
      setArrowFunctionParameters(node, params, trailingCommaLoc) {
        this.toAssignableList(params, trailingCommaLoc, false);
        node.params = params;
      }
      parseFunctionBodyAndFinish(node, type, isMethod = false) {
        this.parseFunctionBody(node, false, isMethod);
        return this.finishNode(node, type);
      }
      parseFunctionBody(node, allowExpression, isMethod = false) {
        const isExpression2 = allowExpression && !this.match(5);
        this.expressionScope.enter(newExpressionScope());
        if (isExpression2) {
          node.body = this.parseMaybeAssign();
          this.checkParams(node, false, allowExpression, false);
        } else {
          const oldStrict = this.state.strict;
          const oldLabels = this.state.labels;
          this.state.labels = [];
          this.prodParam.enter(this.prodParam.currentFlags() | 4);
          node.body = this.parseBlock(true, false, (hasStrictModeDirective) => {
            const nonSimple = !this.isSimpleParamList(node.params);
            if (hasStrictModeDirective && nonSimple) {
              this.raise(Errors.IllegalLanguageModeDirective, (node.kind === "method" || node.kind === "constructor") && !!node.key ? node.key.loc.end : node);
            }
            const strictModeChanged = !oldStrict && this.state.strict;
            this.checkParams(node, !this.state.strict && !allowExpression && !isMethod && !nonSimple, allowExpression, strictModeChanged);
            if (this.state.strict && node.id) {
              this.checkIdentifier(node.id, 65, strictModeChanged);
            }
          });
          this.prodParam.exit();
          this.state.labels = oldLabels;
        }
        this.expressionScope.exit();
      }
      isSimpleParameter(node) {
        return node.type === "Identifier";
      }
      isSimpleParamList(params) {
        for (let i = 0, len = params.length; i < len; i++) {
          if (!this.isSimpleParameter(params[i])) return false;
        }
        return true;
      }
      checkParams(node, allowDuplicates, isArrowFunction, strictModeChanged = true) {
        const checkClashes = !allowDuplicates && /* @__PURE__ */ new Set();
        const formalParameters = {
          type: "FormalParameters"
        };
        for (const param of node.params) {
          this.checkLVal(param, formalParameters, 5, checkClashes, strictModeChanged);
        }
      }
      parseExprList(close, allowEmpty, refExpressionErrors, nodeForExtra) {
        const elts = [];
        let first = true;
        while (!this.eat(close)) {
          if (first) {
            first = false;
          } else {
            this.expect(12);
            if (this.match(close)) {
              if (nodeForExtra) {
                this.addTrailingCommaExtraToNode(nodeForExtra);
              }
              this.next();
              break;
            }
          }
          elts.push(this.parseExprListItem(allowEmpty, refExpressionErrors));
        }
        return elts;
      }
      parseExprListItem(allowEmpty, refExpressionErrors, allowPlaceholder) {
        let elt;
        if (this.match(12)) {
          if (!allowEmpty) {
            this.raise(Errors.UnexpectedToken, this.state.curPosition(), {
              unexpected: ","
            });
          }
          elt = null;
        } else if (this.match(21)) {
          const spreadNodeStartLoc = this.state.startLoc;
          elt = this.parseParenItem(this.parseSpread(refExpressionErrors), spreadNodeStartLoc);
        } else if (this.match(17)) {
          this.expectPlugin("partialApplication");
          if (!allowPlaceholder) {
            this.raise(Errors.UnexpectedArgumentPlaceholder, this.state.startLoc);
          }
          const node = this.startNode();
          this.next();
          elt = this.finishNode(node, "ArgumentPlaceholder");
        } else {
          elt = this.parseMaybeAssignAllowIn(refExpressionErrors, this.parseParenItem);
        }
        return elt;
      }
      parseIdentifier(liberal) {
        const node = this.startNode();
        const name = this.parseIdentifierName(liberal);
        return this.createIdentifier(node, name);
      }
      createIdentifier(node, name) {
        node.name = name;
        node.loc.identifierName = name;
        return this.finishNode(node, "Identifier");
      }
      parseIdentifierName(liberal) {
        let name;
        const {
          startLoc,
          type
        } = this.state;
        if (tokenIsKeywordOrIdentifier(type)) {
          name = this.state.value;
        } else {
          this.unexpected();
        }
        const tokenIsKeyword2 = tokenKeywordOrIdentifierIsKeyword(type);
        if (liberal) {
          if (tokenIsKeyword2) {
            this.replaceToken(132);
          }
        } else {
          this.checkReservedWord(name, startLoc, tokenIsKeyword2, false);
        }
        this.next();
        return name;
      }
      checkReservedWord(word, startLoc, checkKeywords, isBinding) {
        if (word.length > 10) {
          return;
        }
        if (!canBeReservedWord(word)) {
          return;
        }
        if (checkKeywords && isKeyword(word)) {
          this.raise(Errors.UnexpectedKeyword, startLoc, {
            keyword: word
          });
          return;
        }
        const reservedTest = !this.state.strict ? isReservedWord2 : isBinding ? isStrictBindReservedWord : isStrictReservedWord;
        if (reservedTest(word, this.inModule)) {
          this.raise(Errors.UnexpectedReservedWord, startLoc, {
            reservedWord: word
          });
          return;
        } else if (word === "yield") {
          if (this.prodParam.hasYield) {
            this.raise(Errors.YieldBindingIdentifier, startLoc);
            return;
          }
        } else if (word === "await") {
          if (this.prodParam.hasAwait) {
            this.raise(Errors.AwaitBindingIdentifier, startLoc);
            return;
          }
          if (this.scope.inStaticBlock) {
            this.raise(Errors.AwaitBindingIdentifierInStaticBlock, startLoc);
            return;
          }
          this.expressionScope.recordAsyncArrowParametersError(startLoc);
        } else if (word === "arguments") {
          if (this.scope.inClassAndNotInNonArrowFunction) {
            this.raise(Errors.ArgumentsInClass, startLoc);
            return;
          }
        }
      }
      recordAwaitIfAllowed() {
        const isAwaitAllowed = this.prodParam.hasAwait || this.optionFlags & 1 && !this.scope.inFunction;
        if (isAwaitAllowed && !this.scope.inFunction) {
          this.state.hasTopLevelAwait = true;
        }
        return isAwaitAllowed;
      }
      parseAwait(startLoc) {
        const node = this.startNodeAt(startLoc);
        this.expressionScope.recordParameterInitializerError(Errors.AwaitExpressionFormalParameter, node);
        if (this.eat(55)) {
          this.raise(Errors.ObsoleteAwaitStar, node);
        }
        if (!this.scope.inFunction && !(this.optionFlags & 1)) {
          if (this.isAmbiguousPrefixOrIdentifier()) {
            this.ambiguousScriptDifferentAst = true;
          } else {
            this.sawUnambiguousESM = true;
          }
        }
        if (!this.state.soloAwait) {
          node.argument = this.parseMaybeUnary(null, true);
        }
        return this.finishNode(node, "AwaitExpression");
      }
      isAmbiguousPrefixOrIdentifier() {
        if (this.hasPrecedingLineBreak()) return true;
        const {
          type
        } = this.state;
        return type === 53 || type === 10 || type === 0 || tokenIsTemplate(type) || type === 102 && !this.state.containsEsc || type === 138 || type === 56 || this.hasPlugin("v8intrinsic") && type === 54;
      }
      parseYield(startLoc) {
        const node = this.startNodeAt(startLoc);
        this.expressionScope.recordParameterInitializerError(Errors.YieldInParameter, node);
        let delegating = false;
        let argument = null;
        if (!this.hasPrecedingLineBreak()) {
          delegating = this.eat(55);
          switch (this.state.type) {
            case 13:
            case 140:
            case 8:
            case 11:
            case 3:
            case 9:
            case 14:
            case 12:
              if (!delegating) break;
            default:
              argument = this.parseMaybeAssign();
          }
        }
        node.delegate = delegating;
        node.argument = argument;
        return this.finishNode(node, "YieldExpression");
      }
      parseImportCall(node) {
        this.next();
        node.source = this.parseMaybeAssignAllowIn();
        node.options = null;
        if (this.eat(12)) {
          if (!this.match(11)) {
            node.options = this.parseMaybeAssignAllowIn();
            if (this.eat(12) && !this.match(11)) {
              do {
                this.parseMaybeAssignAllowIn();
              } while (this.eat(12) && !this.match(11));
              this.raise(Errors.ImportCallArity, node);
            }
          }
        }
        this.expect(11);
        return this.finishNode(node, "ImportExpression");
      }
      checkPipelineAtInfixOperator(left, leftStartLoc) {
        if (this.hasPlugin(["pipelineOperator", {
          proposal: "smart"
        }])) {
          if (left.type === "SequenceExpression") {
            this.raise(Errors.PipelineHeadSequenceExpression, leftStartLoc);
          }
        }
      }
      parseSmartPipelineBodyInStyle(childExpr, startLoc) {
        if (this.isSimpleReference(childExpr)) {
          const bodyNode = this.startNodeAt(startLoc);
          bodyNode.callee = childExpr;
          return this.finishNode(bodyNode, "PipelineBareFunction");
        } else {
          const bodyNode = this.startNodeAt(startLoc);
          this.checkSmartPipeTopicBodyEarlyErrors(startLoc);
          bodyNode.expression = childExpr;
          return this.finishNode(bodyNode, "PipelineTopicExpression");
        }
      }
      isSimpleReference(expression) {
        switch (expression.type) {
          case "MemberExpression":
            return !expression.computed && this.isSimpleReference(expression.object);
          case "Identifier":
            return true;
          default:
            return false;
        }
      }
      checkSmartPipeTopicBodyEarlyErrors(startLoc) {
        if (this.match(19)) {
          throw this.raise(Errors.PipelineBodyNoArrow, this.state.startLoc);
        }
        if (!this.topicReferenceWasUsedInCurrentContext()) {
          this.raise(Errors.PipelineTopicUnused, startLoc);
        }
      }
      withTopicBindingContext(callback) {
        const outerContextTopicState = this.state.topicContext;
        this.state.topicContext = {
          maxNumOfResolvableTopics: 1,
          maxTopicIndex: null
        };
        try {
          return callback();
        } finally {
          this.state.topicContext = outerContextTopicState;
        }
      }
      withSmartMixTopicForbiddingContext(callback) {
        if (this.hasPlugin(["pipelineOperator", {
          proposal: "smart"
        }])) {
          const outerContextTopicState = this.state.topicContext;
          this.state.topicContext = {
            maxNumOfResolvableTopics: 0,
            maxTopicIndex: null
          };
          try {
            return callback();
          } finally {
            this.state.topicContext = outerContextTopicState;
          }
        } else {
          return callback();
        }
      }
      withSoloAwaitPermittingContext(callback) {
        const outerContextSoloAwaitState = this.state.soloAwait;
        this.state.soloAwait = true;
        try {
          return callback();
        } finally {
          this.state.soloAwait = outerContextSoloAwaitState;
        }
      }
      allowInAnd(callback) {
        const flags = this.prodParam.currentFlags();
        const prodParamToSet = 8 & ~flags;
        if (prodParamToSet) {
          this.prodParam.enter(flags | 8);
          try {
            return callback();
          } finally {
            this.prodParam.exit();
          }
        }
        return callback();
      }
      disallowInAnd(callback) {
        const flags = this.prodParam.currentFlags();
        const prodParamToClear = 8 & flags;
        if (prodParamToClear) {
          this.prodParam.enter(flags & ~8);
          try {
            return callback();
          } finally {
            this.prodParam.exit();
          }
        }
        return callback();
      }
      registerTopicReference() {
        this.state.topicContext.maxTopicIndex = 0;
      }
      topicReferenceIsAllowedInCurrentContext() {
        return this.state.topicContext.maxNumOfResolvableTopics >= 1;
      }
      topicReferenceWasUsedInCurrentContext() {
        return this.state.topicContext.maxTopicIndex != null && this.state.topicContext.maxTopicIndex >= 0;
      }
      parseFSharpPipelineBody(prec) {
        const startLoc = this.state.startLoc;
        this.state.potentialArrowAt = this.state.start;
        const oldInFSharpPipelineDirectBody = this.state.inFSharpPipelineDirectBody;
        this.state.inFSharpPipelineDirectBody = true;
        const ret = this.parseExprOp(this.parseMaybeUnaryOrPrivate(), startLoc, prec);
        this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
        return ret;
      }
      parseModuleExpression() {
        this.expectPlugin("moduleBlocks");
        const node = this.startNode();
        this.next();
        if (!this.match(5)) {
          this.unexpected(null, 5);
        }
        const program = this.startNodeAt(this.state.endLoc);
        this.next();
        const revertScopes = this.initializeScopes(true);
        this.enterInitialScopes();
        try {
          node.body = this.parseProgram(program, 8, "module");
        } finally {
          revertScopes();
        }
        return this.finishNode(node, "ModuleExpression");
      }
      parsePropertyNamePrefixOperator(prop) {
      }
    };
    var loopLabel = {
      kind: 1
    };
    var switchLabel = {
      kind: 2
    };
    var loneSurrogate = /[\uD800-\uDFFF]/u;
    var keywordRelationalOperator = /in(?:stanceof)?/y;
    function babel7CompatTokens(tokens, input, startIndex) {
      for (let i = 0; i < tokens.length; i++) {
        const token2 = tokens[i];
        const {
          type
        } = token2;
        if (typeof type === "number") {
          {
            if (type === 139) {
              const {
                loc,
                start,
                value,
                end
              } = token2;
              const hashEndPos = start + 1;
              const hashEndLoc = createPositionWithColumnOffset(loc.start, 1);
              tokens.splice(i, 1, new Token({
                type: getExportedToken(27),
                value: "#",
                start,
                end: hashEndPos,
                startLoc: loc.start,
                endLoc: hashEndLoc
              }), new Token({
                type: getExportedToken(132),
                value,
                start: hashEndPos,
                end,
                startLoc: hashEndLoc,
                endLoc: loc.end
              }));
              i++;
              continue;
            }
            if (tokenIsTemplate(type)) {
              const {
                loc,
                start,
                value,
                end
              } = token2;
              const backquoteEnd = start + 1;
              const backquoteEndLoc = createPositionWithColumnOffset(loc.start, 1);
              let startToken;
              if (input.charCodeAt(start - startIndex) === 96) {
                startToken = new Token({
                  type: getExportedToken(22),
                  value: "`",
                  start,
                  end: backquoteEnd,
                  startLoc: loc.start,
                  endLoc: backquoteEndLoc
                });
              } else {
                startToken = new Token({
                  type: getExportedToken(8),
                  value: "}",
                  start,
                  end: backquoteEnd,
                  startLoc: loc.start,
                  endLoc: backquoteEndLoc
                });
              }
              let templateValue, templateElementEnd, templateElementEndLoc, endToken;
              if (type === 24) {
                templateElementEnd = end - 1;
                templateElementEndLoc = createPositionWithColumnOffset(loc.end, -1);
                templateValue = value === null ? null : value.slice(1, -1);
                endToken = new Token({
                  type: getExportedToken(22),
                  value: "`",
                  start: templateElementEnd,
                  end,
                  startLoc: templateElementEndLoc,
                  endLoc: loc.end
                });
              } else {
                templateElementEnd = end - 2;
                templateElementEndLoc = createPositionWithColumnOffset(loc.end, -2);
                templateValue = value === null ? null : value.slice(1, -2);
                endToken = new Token({
                  type: getExportedToken(23),
                  value: "${",
                  start: templateElementEnd,
                  end,
                  startLoc: templateElementEndLoc,
                  endLoc: loc.end
                });
              }
              tokens.splice(i, 1, startToken, new Token({
                type: getExportedToken(20),
                value: templateValue,
                start: backquoteEnd,
                end: templateElementEnd,
                startLoc: backquoteEndLoc,
                endLoc: templateElementEndLoc
              }), endToken);
              i += 2;
              continue;
            }
          }
          token2.type = getExportedToken(type);
        }
      }
      return tokens;
    }
    var StatementParser = class extends ExpressionParser {
      parseTopLevel(file2, program) {
        file2.program = this.parseProgram(program);
        file2.comments = this.comments;
        if (this.optionFlags & 256) {
          file2.tokens = babel7CompatTokens(this.tokens, this.input, this.startIndex);
        }
        return this.finishNode(file2, "File");
      }
      parseProgram(program, end = 140, sourceType = this.options.sourceType) {
        program.sourceType = sourceType;
        program.interpreter = this.parseInterpreterDirective();
        this.parseBlockBody(program, true, true, end);
        if (this.inModule) {
          if (!(this.optionFlags & 64) && this.scope.undefinedExports.size > 0) {
            for (const [localName, at] of Array.from(this.scope.undefinedExports)) {
              this.raise(Errors.ModuleExportUndefined, at, {
                localName
              });
            }
          }
          this.addExtra(program, "topLevelAwait", this.state.hasTopLevelAwait);
        }
        let finishedProgram;
        if (end === 140) {
          finishedProgram = this.finishNode(program, "Program");
        } else {
          finishedProgram = this.finishNodeAt(program, "Program", createPositionWithColumnOffset(this.state.startLoc, -1));
        }
        return finishedProgram;
      }
      stmtToDirective(stmt) {
        const directive2 = stmt;
        directive2.type = "Directive";
        directive2.value = directive2.expression;
        delete directive2.expression;
        const directiveLiteral2 = directive2.value;
        const expressionValue = directiveLiteral2.value;
        const raw = this.input.slice(this.offsetToSourcePos(directiveLiteral2.start), this.offsetToSourcePos(directiveLiteral2.end));
        const val = directiveLiteral2.value = raw.slice(1, -1);
        this.addExtra(directiveLiteral2, "raw", raw);
        this.addExtra(directiveLiteral2, "rawValue", val);
        this.addExtra(directiveLiteral2, "expressionValue", expressionValue);
        directiveLiteral2.type = "DirectiveLiteral";
        return directive2;
      }
      parseInterpreterDirective() {
        if (!this.match(28)) {
          return null;
        }
        const node = this.startNode();
        node.value = this.state.value;
        this.next();
        return this.finishNode(node, "InterpreterDirective");
      }
      isLet() {
        if (!this.isContextual(100)) {
          return false;
        }
        return this.hasFollowingBindingAtom();
      }
      chStartsBindingIdentifier(ch, pos2) {
        if (isIdentifierStart(ch)) {
          keywordRelationalOperator.lastIndex = pos2;
          if (keywordRelationalOperator.test(this.input)) {
            const endCh = this.codePointAtPos(keywordRelationalOperator.lastIndex);
            if (!isIdentifierChar(endCh) && endCh !== 92) {
              return false;
            }
          }
          return true;
        } else if (ch === 92) {
          return true;
        } else {
          return false;
        }
      }
      chStartsBindingPattern(ch) {
        return ch === 91 || ch === 123;
      }
      hasFollowingBindingAtom() {
        const next = this.nextTokenStart();
        const nextCh = this.codePointAtPos(next);
        return this.chStartsBindingPattern(nextCh) || this.chStartsBindingIdentifier(nextCh, next);
      }
      hasInLineFollowingBindingIdentifierOrBrace() {
        const next = this.nextTokenInLineStart();
        const nextCh = this.codePointAtPos(next);
        return nextCh === 123 || this.chStartsBindingIdentifier(nextCh, next);
      }
      startsUsingForOf() {
        const {
          type,
          containsEsc
        } = this.lookahead();
        if (type === 102 && !containsEsc) {
          return false;
        } else if (tokenIsIdentifier(type) && !this.hasFollowingLineBreak()) {
          this.expectPlugin("explicitResourceManagement");
          return true;
        }
      }
      startsAwaitUsing() {
        let next = this.nextTokenInLineStart();
        if (this.isUnparsedContextual(next, "using")) {
          next = this.nextTokenInLineStartSince(next + 5);
          const nextCh = this.codePointAtPos(next);
          if (this.chStartsBindingIdentifier(nextCh, next)) {
            this.expectPlugin("explicitResourceManagement");
            return true;
          }
        }
        return false;
      }
      parseModuleItem() {
        return this.parseStatementLike(1 | 2 | 4 | 8);
      }
      parseStatementListItem() {
        return this.parseStatementLike(2 | 4 | (!this.options.annexB || this.state.strict ? 0 : 8));
      }
      parseStatementOrSloppyAnnexBFunctionDeclaration(allowLabeledFunction = false) {
        let flags = 0;
        if (this.options.annexB && !this.state.strict) {
          flags |= 4;
          if (allowLabeledFunction) {
            flags |= 8;
          }
        }
        return this.parseStatementLike(flags);
      }
      parseStatement() {
        return this.parseStatementLike(0);
      }
      parseStatementLike(flags) {
        let decorators = null;
        if (this.match(26)) {
          decorators = this.parseDecorators(true);
        }
        return this.parseStatementContent(flags, decorators);
      }
      parseStatementContent(flags, decorators) {
        const startType = this.state.type;
        const node = this.startNode();
        const allowDeclaration = !!(flags & 2);
        const allowFunctionDeclaration = !!(flags & 4);
        const topLevel = flags & 1;
        switch (startType) {
          case 60:
            return this.parseBreakContinueStatement(node, true);
          case 63:
            return this.parseBreakContinueStatement(node, false);
          case 64:
            return this.parseDebuggerStatement(node);
          case 90:
            return this.parseDoWhileStatement(node);
          case 91:
            return this.parseForStatement(node);
          case 68:
            if (this.lookaheadCharCode() === 46) break;
            if (!allowFunctionDeclaration) {
              this.raise(this.state.strict ? Errors.StrictFunction : this.options.annexB ? Errors.SloppyFunctionAnnexB : Errors.SloppyFunction, this.state.startLoc);
            }
            return this.parseFunctionStatement(node, false, !allowDeclaration && allowFunctionDeclaration);
          case 80:
            if (!allowDeclaration) this.unexpected();
            return this.parseClass(this.maybeTakeDecorators(decorators, node), true);
          case 69:
            return this.parseIfStatement(node);
          case 70:
            return this.parseReturnStatement(node);
          case 71:
            return this.parseSwitchStatement(node);
          case 72:
            return this.parseThrowStatement(node);
          case 73:
            return this.parseTryStatement(node);
          case 96:
            if (!this.state.containsEsc && this.startsAwaitUsing()) {
              if (!this.recordAwaitIfAllowed()) {
                this.raise(Errors.AwaitUsingNotInAsyncContext, node);
              } else if (!allowDeclaration) {
                this.raise(Errors.UnexpectedLexicalDeclaration, node);
              }
              this.next();
              return this.parseVarStatement(node, "await using");
            }
            break;
          case 107:
            if (this.state.containsEsc || !this.hasInLineFollowingBindingIdentifierOrBrace()) {
              break;
            }
            this.expectPlugin("explicitResourceManagement");
            if (!this.scope.inModule && this.scope.inTopLevel) {
              this.raise(Errors.UnexpectedUsingDeclaration, this.state.startLoc);
            } else if (!allowDeclaration) {
              this.raise(Errors.UnexpectedLexicalDeclaration, this.state.startLoc);
            }
            return this.parseVarStatement(node, "using");
          case 100: {
            if (this.state.containsEsc) {
              break;
            }
            const next = this.nextTokenStart();
            const nextCh = this.codePointAtPos(next);
            if (nextCh !== 91) {
              if (!allowDeclaration && this.hasFollowingLineBreak()) break;
              if (!this.chStartsBindingIdentifier(nextCh, next) && nextCh !== 123) {
                break;
              }
            }
          }
          case 75: {
            if (!allowDeclaration) {
              this.raise(Errors.UnexpectedLexicalDeclaration, this.state.startLoc);
            }
          }
          case 74: {
            const kind = this.state.value;
            return this.parseVarStatement(node, kind);
          }
          case 92:
            return this.parseWhileStatement(node);
          case 76:
            return this.parseWithStatement(node);
          case 5:
            return this.parseBlock();
          case 13:
            return this.parseEmptyStatement(node);
          case 83: {
            const nextTokenCharCode = this.lookaheadCharCode();
            if (nextTokenCharCode === 40 || nextTokenCharCode === 46) {
              break;
            }
          }
          case 82: {
            if (!(this.optionFlags & 8) && !topLevel) {
              this.raise(Errors.UnexpectedImportExport, this.state.startLoc);
            }
            this.next();
            let result;
            if (startType === 83) {
              result = this.parseImport(node);
            } else {
              result = this.parseExport(node, decorators);
            }
            this.assertModuleNodeAllowed(result);
            return result;
          }
          default: {
            if (this.isAsyncFunction()) {
              if (!allowDeclaration) {
                this.raise(Errors.AsyncFunctionInSingleStatementContext, this.state.startLoc);
              }
              this.next();
              return this.parseFunctionStatement(node, true, !allowDeclaration && allowFunctionDeclaration);
            }
          }
        }
        const maybeName = this.state.value;
        const expr = this.parseExpression();
        if (tokenIsIdentifier(startType) && expr.type === "Identifier" && this.eat(14)) {
          return this.parseLabeledStatement(node, maybeName, expr, flags);
        } else {
          return this.parseExpressionStatement(node, expr, decorators);
        }
      }
      assertModuleNodeAllowed(node) {
        if (!(this.optionFlags & 8) && !this.inModule) {
          this.raise(Errors.ImportOutsideModule, node);
        }
      }
      decoratorsEnabledBeforeExport() {
        if (this.hasPlugin("decorators-legacy")) return true;
        return this.hasPlugin("decorators") && this.getPluginOption("decorators", "decoratorsBeforeExport") !== false;
      }
      maybeTakeDecorators(maybeDecorators, classNode, exportNode) {
        if (maybeDecorators) {
          var _classNode$decorators;
          if ((_classNode$decorators = classNode.decorators) != null && _classNode$decorators.length) {
            if (typeof this.getPluginOption("decorators", "decoratorsBeforeExport") !== "boolean") {
              this.raise(Errors.DecoratorsBeforeAfterExport, classNode.decorators[0]);
            }
            classNode.decorators.unshift(...maybeDecorators);
          } else {
            classNode.decorators = maybeDecorators;
          }
          this.resetStartLocationFromNode(classNode, maybeDecorators[0]);
          if (exportNode) this.resetStartLocationFromNode(exportNode, classNode);
        }
        return classNode;
      }
      canHaveLeadingDecorator() {
        return this.match(80);
      }
      parseDecorators(allowExport) {
        const decorators = [];
        do {
          decorators.push(this.parseDecorator());
        } while (this.match(26));
        if (this.match(82)) {
          if (!allowExport) {
            this.unexpected();
          }
          if (!this.decoratorsEnabledBeforeExport()) {
            this.raise(Errors.DecoratorExportClass, this.state.startLoc);
          }
        } else if (!this.canHaveLeadingDecorator()) {
          throw this.raise(Errors.UnexpectedLeadingDecorator, this.state.startLoc);
        }
        return decorators;
      }
      parseDecorator() {
        this.expectOnePlugin(["decorators", "decorators-legacy"]);
        const node = this.startNode();
        this.next();
        if (this.hasPlugin("decorators")) {
          const startLoc = this.state.startLoc;
          let expr;
          if (this.match(10)) {
            const startLoc2 = this.state.startLoc;
            this.next();
            expr = this.parseExpression();
            this.expect(11);
            expr = this.wrapParenthesis(startLoc2, expr);
            const paramsStartLoc = this.state.startLoc;
            node.expression = this.parseMaybeDecoratorArguments(expr, startLoc2);
            if (this.getPluginOption("decorators", "allowCallParenthesized") === false && node.expression !== expr) {
              this.raise(Errors.DecoratorArgumentsOutsideParentheses, paramsStartLoc);
            }
          } else {
            expr = this.parseIdentifier(false);
            while (this.eat(16)) {
              const node2 = this.startNodeAt(startLoc);
              node2.object = expr;
              if (this.match(139)) {
                this.classScope.usePrivateName(this.state.value, this.state.startLoc);
                node2.property = this.parsePrivateName();
              } else {
                node2.property = this.parseIdentifier(true);
              }
              node2.computed = false;
              expr = this.finishNode(node2, "MemberExpression");
            }
            node.expression = this.parseMaybeDecoratorArguments(expr, startLoc);
          }
        } else {
          node.expression = this.parseExprSubscripts();
        }
        return this.finishNode(node, "Decorator");
      }
      parseMaybeDecoratorArguments(expr, startLoc) {
        if (this.eat(10)) {
          const node = this.startNodeAt(startLoc);
          node.callee = expr;
          node.arguments = this.parseCallExpressionArguments(11);
          this.toReferencedList(node.arguments);
          return this.finishNode(node, "CallExpression");
        }
        return expr;
      }
      parseBreakContinueStatement(node, isBreak) {
        this.next();
        if (this.isLineTerminator()) {
          node.label = null;
        } else {
          node.label = this.parseIdentifier();
          this.semicolon();
        }
        this.verifyBreakContinue(node, isBreak);
        return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
      }
      verifyBreakContinue(node, isBreak) {
        let i;
        for (i = 0; i < this.state.labels.length; ++i) {
          const lab = this.state.labels[i];
          if (node.label == null || lab.name === node.label.name) {
            if (lab.kind != null && (isBreak || lab.kind === 1)) {
              break;
            }
            if (node.label && isBreak) break;
          }
        }
        if (i === this.state.labels.length) {
          const type = isBreak ? "BreakStatement" : "ContinueStatement";
          this.raise(Errors.IllegalBreakContinue, node, {
            type
          });
        }
      }
      parseDebuggerStatement(node) {
        this.next();
        this.semicolon();
        return this.finishNode(node, "DebuggerStatement");
      }
      parseHeaderExpression() {
        this.expect(10);
        const val = this.parseExpression();
        this.expect(11);
        return val;
      }
      parseDoWhileStatement(node) {
        this.next();
        this.state.labels.push(loopLabel);
        node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
        this.state.labels.pop();
        this.expect(92);
        node.test = this.parseHeaderExpression();
        this.eat(13);
        return this.finishNode(node, "DoWhileStatement");
      }
      parseForStatement(node) {
        this.next();
        this.state.labels.push(loopLabel);
        let awaitAt = null;
        if (this.isContextual(96) && this.recordAwaitIfAllowed()) {
          awaitAt = this.state.startLoc;
          this.next();
        }
        this.scope.enter(0);
        this.expect(10);
        if (this.match(13)) {
          if (awaitAt !== null) {
            this.unexpected(awaitAt);
          }
          return this.parseFor(node, null);
        }
        const startsWithLet = this.isContextual(100);
        {
          const startsWithAwaitUsing = this.isContextual(96) && this.startsAwaitUsing();
          const starsWithUsingDeclaration = startsWithAwaitUsing || this.isContextual(107) && this.startsUsingForOf();
          const isLetOrUsing = startsWithLet && this.hasFollowingBindingAtom() || starsWithUsingDeclaration;
          if (this.match(74) || this.match(75) || isLetOrUsing) {
            const initNode = this.startNode();
            let kind;
            if (startsWithAwaitUsing) {
              kind = "await using";
              if (!this.recordAwaitIfAllowed()) {
                this.raise(Errors.AwaitUsingNotInAsyncContext, this.state.startLoc);
              }
              this.next();
            } else {
              kind = this.state.value;
            }
            this.next();
            this.parseVar(initNode, true, kind);
            const init2 = this.finishNode(initNode, "VariableDeclaration");
            const isForIn = this.match(58);
            if (isForIn && starsWithUsingDeclaration) {
              this.raise(Errors.ForInUsing, init2);
            }
            if ((isForIn || this.isContextual(102)) && init2.declarations.length === 1) {
              return this.parseForIn(node, init2, awaitAt);
            }
            if (awaitAt !== null) {
              this.unexpected(awaitAt);
            }
            return this.parseFor(node, init2);
          }
        }
        const startsWithAsync = this.isContextual(95);
        const refExpressionErrors = new ExpressionErrors();
        const init = this.parseExpression(true, refExpressionErrors);
        const isForOf = this.isContextual(102);
        if (isForOf) {
          if (startsWithLet) {
            this.raise(Errors.ForOfLet, init);
          }
          if (awaitAt === null && startsWithAsync && init.type === "Identifier") {
            this.raise(Errors.ForOfAsync, init);
          }
        }
        if (isForOf || this.match(58)) {
          this.checkDestructuringPrivate(refExpressionErrors);
          this.toAssignable(init, true);
          const type = isForOf ? "ForOfStatement" : "ForInStatement";
          this.checkLVal(init, {
            type
          });
          return this.parseForIn(node, init, awaitAt);
        } else {
          this.checkExpressionErrors(refExpressionErrors, true);
        }
        if (awaitAt !== null) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node, init);
      }
      parseFunctionStatement(node, isAsync, isHangingDeclaration) {
        this.next();
        return this.parseFunction(node, 1 | (isHangingDeclaration ? 2 : 0) | (isAsync ? 8 : 0));
      }
      parseIfStatement(node) {
        this.next();
        node.test = this.parseHeaderExpression();
        node.consequent = this.parseStatementOrSloppyAnnexBFunctionDeclaration();
        node.alternate = this.eat(66) ? this.parseStatementOrSloppyAnnexBFunctionDeclaration() : null;
        return this.finishNode(node, "IfStatement");
      }
      parseReturnStatement(node) {
        if (!this.prodParam.hasReturn && !(this.optionFlags & 2)) {
          this.raise(Errors.IllegalReturn, this.state.startLoc);
        }
        this.next();
        if (this.isLineTerminator()) {
          node.argument = null;
        } else {
          node.argument = this.parseExpression();
          this.semicolon();
        }
        return this.finishNode(node, "ReturnStatement");
      }
      parseSwitchStatement(node) {
        this.next();
        node.discriminant = this.parseHeaderExpression();
        const cases = node.cases = [];
        this.expect(5);
        this.state.labels.push(switchLabel);
        this.scope.enter(0);
        let cur;
        for (let sawDefault; !this.match(8); ) {
          if (this.match(61) || this.match(65)) {
            const isCase = this.match(61);
            if (cur) this.finishNode(cur, "SwitchCase");
            cases.push(cur = this.startNode());
            cur.consequent = [];
            this.next();
            if (isCase) {
              cur.test = this.parseExpression();
            } else {
              if (sawDefault) {
                this.raise(Errors.MultipleDefaultsInSwitch, this.state.lastTokStartLoc);
              }
              sawDefault = true;
              cur.test = null;
            }
            this.expect(14);
          } else {
            if (cur) {
              cur.consequent.push(this.parseStatementListItem());
            } else {
              this.unexpected();
            }
          }
        }
        this.scope.exit();
        if (cur) this.finishNode(cur, "SwitchCase");
        this.next();
        this.state.labels.pop();
        return this.finishNode(node, "SwitchStatement");
      }
      parseThrowStatement(node) {
        this.next();
        if (this.hasPrecedingLineBreak()) {
          this.raise(Errors.NewlineAfterThrow, this.state.lastTokEndLoc);
        }
        node.argument = this.parseExpression();
        this.semicolon();
        return this.finishNode(node, "ThrowStatement");
      }
      parseCatchClauseParam() {
        const param = this.parseBindingAtom();
        this.scope.enter(this.options.annexB && param.type === "Identifier" ? 8 : 0);
        this.checkLVal(param, {
          type: "CatchClause"
        }, 9);
        return param;
      }
      parseTryStatement(node) {
        this.next();
        node.block = this.parseBlock();
        node.handler = null;
        if (this.match(62)) {
          const clause = this.startNode();
          this.next();
          if (this.match(10)) {
            this.expect(10);
            clause.param = this.parseCatchClauseParam();
            this.expect(11);
          } else {
            clause.param = null;
            this.scope.enter(0);
          }
          clause.body = this.withSmartMixTopicForbiddingContext(() => this.parseBlock(false, false));
          this.scope.exit();
          node.handler = this.finishNode(clause, "CatchClause");
        }
        node.finalizer = this.eat(67) ? this.parseBlock() : null;
        if (!node.handler && !node.finalizer) {
          this.raise(Errors.NoCatchOrFinally, node);
        }
        return this.finishNode(node, "TryStatement");
      }
      parseVarStatement(node, kind, allowMissingInitializer = false) {
        this.next();
        this.parseVar(node, false, kind, allowMissingInitializer);
        this.semicolon();
        return this.finishNode(node, "VariableDeclaration");
      }
      parseWhileStatement(node) {
        this.next();
        node.test = this.parseHeaderExpression();
        this.state.labels.push(loopLabel);
        node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
        this.state.labels.pop();
        return this.finishNode(node, "WhileStatement");
      }
      parseWithStatement(node) {
        if (this.state.strict) {
          this.raise(Errors.StrictWith, this.state.startLoc);
        }
        this.next();
        node.object = this.parseHeaderExpression();
        node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
        return this.finishNode(node, "WithStatement");
      }
      parseEmptyStatement(node) {
        this.next();
        return this.finishNode(node, "EmptyStatement");
      }
      parseLabeledStatement(node, maybeName, expr, flags) {
        for (const label of this.state.labels) {
          if (label.name === maybeName) {
            this.raise(Errors.LabelRedeclaration, expr, {
              labelName: maybeName
            });
          }
        }
        const kind = tokenIsLoop(this.state.type) ? 1 : this.match(71) ? 2 : null;
        for (let i = this.state.labels.length - 1; i >= 0; i--) {
          const label = this.state.labels[i];
          if (label.statementStart === node.start) {
            label.statementStart = this.sourceToOffsetPos(this.state.start);
            label.kind = kind;
          } else {
            break;
          }
        }
        this.state.labels.push({
          name: maybeName,
          kind,
          statementStart: this.sourceToOffsetPos(this.state.start)
        });
        node.body = flags & 8 ? this.parseStatementOrSloppyAnnexBFunctionDeclaration(true) : this.parseStatement();
        this.state.labels.pop();
        node.label = expr;
        return this.finishNode(node, "LabeledStatement");
      }
      parseExpressionStatement(node, expr, decorators) {
        node.expression = expr;
        this.semicolon();
        return this.finishNode(node, "ExpressionStatement");
      }
      parseBlock(allowDirectives = false, createNewLexicalScope = true, afterBlockParse) {
        const node = this.startNode();
        if (allowDirectives) {
          this.state.strictErrors.clear();
        }
        this.expect(5);
        if (createNewLexicalScope) {
          this.scope.enter(0);
        }
        this.parseBlockBody(node, allowDirectives, false, 8, afterBlockParse);
        if (createNewLexicalScope) {
          this.scope.exit();
        }
        return this.finishNode(node, "BlockStatement");
      }
      isValidDirective(stmt) {
        return stmt.type === "ExpressionStatement" && stmt.expression.type === "StringLiteral" && !stmt.expression.extra.parenthesized;
      }
      parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
        const body = node.body = [];
        const directives = node.directives = [];
        this.parseBlockOrModuleBlockBody(body, allowDirectives ? directives : void 0, topLevel, end, afterBlockParse);
      }
      parseBlockOrModuleBlockBody(body, directives, topLevel, end, afterBlockParse) {
        const oldStrict = this.state.strict;
        let hasStrictModeDirective = false;
        let parsedNonDirective = false;
        while (!this.match(end)) {
          const stmt = topLevel ? this.parseModuleItem() : this.parseStatementListItem();
          if (directives && !parsedNonDirective) {
            if (this.isValidDirective(stmt)) {
              const directive2 = this.stmtToDirective(stmt);
              directives.push(directive2);
              if (!hasStrictModeDirective && directive2.value.value === "use strict") {
                hasStrictModeDirective = true;
                this.setStrict(true);
              }
              continue;
            }
            parsedNonDirective = true;
            this.state.strictErrors.clear();
          }
          body.push(stmt);
        }
        afterBlockParse == null || afterBlockParse.call(this, hasStrictModeDirective);
        if (!oldStrict) {
          this.setStrict(false);
        }
        this.next();
      }
      parseFor(node, init) {
        node.init = init;
        this.semicolon(false);
        node.test = this.match(13) ? null : this.parseExpression();
        this.semicolon(false);
        node.update = this.match(11) ? null : this.parseExpression();
        this.expect(11);
        node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
        this.scope.exit();
        this.state.labels.pop();
        return this.finishNode(node, "ForStatement");
      }
      parseForIn(node, init, awaitAt) {
        const isForIn = this.match(58);
        this.next();
        if (isForIn) {
          if (awaitAt !== null) this.unexpected(awaitAt);
        } else {
          node.await = awaitAt !== null;
        }
        if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || !this.options.annexB || this.state.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) {
          this.raise(Errors.ForInOfLoopInitializer, init, {
            type: isForIn ? "ForInStatement" : "ForOfStatement"
          });
        }
        if (init.type === "AssignmentPattern") {
          this.raise(Errors.InvalidLhs, init, {
            ancestor: {
              type: "ForStatement"
            }
          });
        }
        node.left = init;
        node.right = isForIn ? this.parseExpression() : this.parseMaybeAssignAllowIn();
        this.expect(11);
        node.body = this.withSmartMixTopicForbiddingContext(() => this.parseStatement());
        this.scope.exit();
        this.state.labels.pop();
        return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
      }
      parseVar(node, isFor, kind, allowMissingInitializer = false) {
        const declarations = node.declarations = [];
        node.kind = kind;
        for (; ; ) {
          const decl = this.startNode();
          this.parseVarId(decl, kind);
          decl.init = !this.eat(29) ? null : isFor ? this.parseMaybeAssignDisallowIn() : this.parseMaybeAssignAllowIn();
          if (decl.init === null && !allowMissingInitializer) {
            if (decl.id.type !== "Identifier" && !(isFor && (this.match(58) || this.isContextual(102)))) {
              this.raise(Errors.DeclarationMissingInitializer, this.state.lastTokEndLoc, {
                kind: "destructuring"
              });
            } else if ((kind === "const" || kind === "using" || kind === "await using") && !(this.match(58) || this.isContextual(102))) {
              this.raise(Errors.DeclarationMissingInitializer, this.state.lastTokEndLoc, {
                kind
              });
            }
          }
          declarations.push(this.finishNode(decl, "VariableDeclarator"));
          if (!this.eat(12)) break;
        }
        return node;
      }
      parseVarId(decl, kind) {
        const id = this.parseBindingAtom();
        if (kind === "using" || kind === "await using") {
          if (id.type === "ArrayPattern" || id.type === "ObjectPattern") {
            this.raise(Errors.UsingDeclarationHasBindingPattern, id.loc.start);
          }
        }
        this.checkLVal(id, {
          type: "VariableDeclarator"
        }, kind === "var" ? 5 : 8201);
        decl.id = id;
      }
      parseAsyncFunctionExpression(node) {
        return this.parseFunction(node, 8);
      }
      parseFunction(node, flags = 0) {
        const hangingDeclaration = flags & 2;
        const isDeclaration = !!(flags & 1);
        const requireId = isDeclaration && !(flags & 4);
        const isAsync = !!(flags & 8);
        this.initFunction(node, isAsync);
        if (this.match(55)) {
          if (hangingDeclaration) {
            this.raise(Errors.GeneratorInSingleStatementContext, this.state.startLoc);
          }
          this.next();
          node.generator = true;
        }
        if (isDeclaration) {
          node.id = this.parseFunctionId(requireId);
        }
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        this.state.maybeInArrowParameters = false;
        this.scope.enter(2);
        this.prodParam.enter(functionFlags(isAsync, node.generator));
        if (!isDeclaration) {
          node.id = this.parseFunctionId();
        }
        this.parseFunctionParams(node, false);
        this.withSmartMixTopicForbiddingContext(() => {
          this.parseFunctionBodyAndFinish(node, isDeclaration ? "FunctionDeclaration" : "FunctionExpression");
        });
        this.prodParam.exit();
        this.scope.exit();
        if (isDeclaration && !hangingDeclaration) {
          this.registerFunctionStatementId(node);
        }
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        return node;
      }
      parseFunctionId(requireId) {
        return requireId || tokenIsIdentifier(this.state.type) ? this.parseIdentifier() : null;
      }
      parseFunctionParams(node, isConstructor) {
        this.expect(10);
        this.expressionScope.enter(newParameterDeclarationScope());
        node.params = this.parseBindingList(11, 41, 2 | (isConstructor ? 4 : 0));
        this.expressionScope.exit();
      }
      registerFunctionStatementId(node) {
        if (!node.id) return;
        this.scope.declareName(node.id.name, !this.options.annexB || this.state.strict || node.generator || node.async ? this.scope.treatFunctionsAsVar ? 5 : 8201 : 17, node.id.loc.start);
      }
      parseClass(node, isStatement2, optionalId) {
        this.next();
        const oldStrict = this.state.strict;
        this.state.strict = true;
        this.parseClassId(node, isStatement2, optionalId);
        this.parseClassSuper(node);
        node.body = this.parseClassBody(!!node.superClass, oldStrict);
        return this.finishNode(node, isStatement2 ? "ClassDeclaration" : "ClassExpression");
      }
      isClassProperty() {
        return this.match(29) || this.match(13) || this.match(8);
      }
      isClassMethod() {
        return this.match(10);
      }
      nameIsConstructor(key2) {
        return key2.type === "Identifier" && key2.name === "constructor" || key2.type === "StringLiteral" && key2.value === "constructor";
      }
      isNonstaticConstructor(method) {
        return !method.computed && !method.static && this.nameIsConstructor(method.key);
      }
      parseClassBody(hadSuperClass, oldStrict) {
        this.classScope.enter();
        const state = {
          hadConstructor: false,
          hadSuperClass
        };
        let decorators = [];
        const classBody = this.startNode();
        classBody.body = [];
        this.expect(5);
        this.withSmartMixTopicForbiddingContext(() => {
          while (!this.match(8)) {
            if (this.eat(13)) {
              if (decorators.length > 0) {
                throw this.raise(Errors.DecoratorSemicolon, this.state.lastTokEndLoc);
              }
              continue;
            }
            if (this.match(26)) {
              decorators.push(this.parseDecorator());
              continue;
            }
            const member = this.startNode();
            if (decorators.length) {
              member.decorators = decorators;
              this.resetStartLocationFromNode(member, decorators[0]);
              decorators = [];
            }
            this.parseClassMember(classBody, member, state);
            if (member.kind === "constructor" && member.decorators && member.decorators.length > 0) {
              this.raise(Errors.DecoratorConstructor, member);
            }
          }
        });
        this.state.strict = oldStrict;
        this.next();
        if (decorators.length) {
          throw this.raise(Errors.TrailingDecorator, this.state.startLoc);
        }
        this.classScope.exit();
        return this.finishNode(classBody, "ClassBody");
      }
      parseClassMemberFromModifier(classBody, member) {
        const key2 = this.parseIdentifier(true);
        if (this.isClassMethod()) {
          const method = member;
          method.kind = "method";
          method.computed = false;
          method.key = key2;
          method.static = false;
          this.pushClassMethod(classBody, method, false, false, false, false);
          return true;
        } else if (this.isClassProperty()) {
          const prop = member;
          prop.computed = false;
          prop.key = key2;
          prop.static = false;
          classBody.body.push(this.parseClassProperty(prop));
          return true;
        }
        this.resetPreviousNodeTrailingComments(key2);
        return false;
      }
      parseClassMember(classBody, member, state) {
        const isStatic = this.isContextual(106);
        if (isStatic) {
          if (this.parseClassMemberFromModifier(classBody, member)) {
            return;
          }
          if (this.eat(5)) {
            this.parseClassStaticBlock(classBody, member);
            return;
          }
        }
        this.parseClassMemberWithIsStatic(classBody, member, state, isStatic);
      }
      parseClassMemberWithIsStatic(classBody, member, state, isStatic) {
        const publicMethod = member;
        const privateMethod = member;
        const publicProp = member;
        const privateProp = member;
        const accessorProp = member;
        const method = publicMethod;
        const publicMember = publicMethod;
        member.static = isStatic;
        this.parsePropertyNamePrefixOperator(member);
        if (this.eat(55)) {
          method.kind = "method";
          const isPrivateName = this.match(139);
          this.parseClassElementName(method);
          if (isPrivateName) {
            this.pushClassPrivateMethod(classBody, privateMethod, true, false);
            return;
          }
          if (this.isNonstaticConstructor(publicMethod)) {
            this.raise(Errors.ConstructorIsGenerator, publicMethod.key);
          }
          this.pushClassMethod(classBody, publicMethod, true, false, false, false);
          return;
        }
        const isContextual = !this.state.containsEsc && tokenIsIdentifier(this.state.type);
        const key2 = this.parseClassElementName(member);
        const maybeContextualKw = isContextual ? key2.name : null;
        const isPrivate = this.isPrivateName(key2);
        const maybeQuestionTokenStartLoc = this.state.startLoc;
        this.parsePostMemberNameModifiers(publicMember);
        if (this.isClassMethod()) {
          method.kind = "method";
          if (isPrivate) {
            this.pushClassPrivateMethod(classBody, privateMethod, false, false);
            return;
          }
          const isConstructor = this.isNonstaticConstructor(publicMethod);
          let allowsDirectSuper = false;
          if (isConstructor) {
            publicMethod.kind = "constructor";
            if (state.hadConstructor && !this.hasPlugin("typescript")) {
              this.raise(Errors.DuplicateConstructor, key2);
            }
            if (isConstructor && this.hasPlugin("typescript") && member.override) {
              this.raise(Errors.OverrideOnConstructor, key2);
            }
            state.hadConstructor = true;
            allowsDirectSuper = state.hadSuperClass;
          }
          this.pushClassMethod(classBody, publicMethod, false, false, isConstructor, allowsDirectSuper);
        } else if (this.isClassProperty()) {
          if (isPrivate) {
            this.pushClassPrivateProperty(classBody, privateProp);
          } else {
            this.pushClassProperty(classBody, publicProp);
          }
        } else if (maybeContextualKw === "async" && !this.isLineTerminator()) {
          this.resetPreviousNodeTrailingComments(key2);
          const isGenerator = this.eat(55);
          if (publicMember.optional) {
            this.unexpected(maybeQuestionTokenStartLoc);
          }
          method.kind = "method";
          const isPrivate2 = this.match(139);
          this.parseClassElementName(method);
          this.parsePostMemberNameModifiers(publicMember);
          if (isPrivate2) {
            this.pushClassPrivateMethod(classBody, privateMethod, isGenerator, true);
          } else {
            if (this.isNonstaticConstructor(publicMethod)) {
              this.raise(Errors.ConstructorIsAsync, publicMethod.key);
            }
            this.pushClassMethod(classBody, publicMethod, isGenerator, true, false, false);
          }
        } else if ((maybeContextualKw === "get" || maybeContextualKw === "set") && !(this.match(55) && this.isLineTerminator())) {
          this.resetPreviousNodeTrailingComments(key2);
          method.kind = maybeContextualKw;
          const isPrivate2 = this.match(139);
          this.parseClassElementName(publicMethod);
          if (isPrivate2) {
            this.pushClassPrivateMethod(classBody, privateMethod, false, false);
          } else {
            if (this.isNonstaticConstructor(publicMethod)) {
              this.raise(Errors.ConstructorIsAccessor, publicMethod.key);
            }
            this.pushClassMethod(classBody, publicMethod, false, false, false, false);
          }
          this.checkGetterSetterParams(publicMethod);
        } else if (maybeContextualKw === "accessor" && !this.isLineTerminator()) {
          this.expectPlugin("decoratorAutoAccessors");
          this.resetPreviousNodeTrailingComments(key2);
          const isPrivate2 = this.match(139);
          this.parseClassElementName(publicProp);
          this.pushClassAccessorProperty(classBody, accessorProp, isPrivate2);
        } else if (this.isLineTerminator()) {
          if (isPrivate) {
            this.pushClassPrivateProperty(classBody, privateProp);
          } else {
            this.pushClassProperty(classBody, publicProp);
          }
        } else {
          this.unexpected();
        }
      }
      parseClassElementName(member) {
        const {
          type,
          value
        } = this.state;
        if ((type === 132 || type === 134) && member.static && value === "prototype") {
          this.raise(Errors.StaticPrototype, this.state.startLoc);
        }
        if (type === 139) {
          if (value === "constructor") {
            this.raise(Errors.ConstructorClassPrivateField, this.state.startLoc);
          }
          const key2 = this.parsePrivateName();
          member.key = key2;
          return key2;
        }
        this.parsePropertyName(member);
        return member.key;
      }
      parseClassStaticBlock(classBody, member) {
        var _member$decorators;
        this.scope.enter(64 | 128 | 16);
        const oldLabels = this.state.labels;
        this.state.labels = [];
        this.prodParam.enter(0);
        const body = member.body = [];
        this.parseBlockOrModuleBlockBody(body, void 0, false, 8);
        this.prodParam.exit();
        this.scope.exit();
        this.state.labels = oldLabels;
        classBody.body.push(this.finishNode(member, "StaticBlock"));
        if ((_member$decorators = member.decorators) != null && _member$decorators.length) {
          this.raise(Errors.DecoratorStaticBlock, member);
        }
      }
      pushClassProperty(classBody, prop) {
        if (!prop.computed && this.nameIsConstructor(prop.key)) {
          this.raise(Errors.ConstructorClassField, prop.key);
        }
        classBody.body.push(this.parseClassProperty(prop));
      }
      pushClassPrivateProperty(classBody, prop) {
        const node = this.parseClassPrivateProperty(prop);
        classBody.body.push(node);
        this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), 0, node.key.loc.start);
      }
      pushClassAccessorProperty(classBody, prop, isPrivate) {
        if (!isPrivate && !prop.computed && this.nameIsConstructor(prop.key)) {
          this.raise(Errors.ConstructorClassField, prop.key);
        }
        const node = this.parseClassAccessorProperty(prop);
        classBody.body.push(node);
        if (isPrivate) {
          this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), 0, node.key.loc.start);
        }
      }
      pushClassMethod(classBody, method, isGenerator, isAsync, isConstructor, allowsDirectSuper) {
        classBody.body.push(this.parseMethod(method, isGenerator, isAsync, isConstructor, allowsDirectSuper, "ClassMethod", true));
      }
      pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
        const node = this.parseMethod(method, isGenerator, isAsync, false, false, "ClassPrivateMethod", true);
        classBody.body.push(node);
        const kind = node.kind === "get" ? node.static ? 6 : 2 : node.kind === "set" ? node.static ? 5 : 1 : 0;
        this.declareClassPrivateMethodInScope(node, kind);
      }
      declareClassPrivateMethodInScope(node, kind) {
        this.classScope.declarePrivateName(this.getPrivateNameSV(node.key), kind, node.key.loc.start);
      }
      parsePostMemberNameModifiers(methodOrProp) {
      }
      parseClassPrivateProperty(node) {
        this.parseInitializer(node);
        this.semicolon();
        return this.finishNode(node, "ClassPrivateProperty");
      }
      parseClassProperty(node) {
        this.parseInitializer(node);
        this.semicolon();
        return this.finishNode(node, "ClassProperty");
      }
      parseClassAccessorProperty(node) {
        this.parseInitializer(node);
        this.semicolon();
        return this.finishNode(node, "ClassAccessorProperty");
      }
      parseInitializer(node) {
        this.scope.enter(64 | 16);
        this.expressionScope.enter(newExpressionScope());
        this.prodParam.enter(0);
        node.value = this.eat(29) ? this.parseMaybeAssignAllowIn() : null;
        this.expressionScope.exit();
        this.prodParam.exit();
        this.scope.exit();
      }
      parseClassId(node, isStatement2, optionalId, bindingType = 8331) {
        if (tokenIsIdentifier(this.state.type)) {
          node.id = this.parseIdentifier();
          if (isStatement2) {
            this.declareNameFromIdentifier(node.id, bindingType);
          }
        } else {
          if (optionalId || !isStatement2) {
            node.id = null;
          } else {
            throw this.raise(Errors.MissingClassName, this.state.startLoc);
          }
        }
      }
      parseClassSuper(node) {
        node.superClass = this.eat(81) ? this.parseExprSubscripts() : null;
      }
      parseExport(node, decorators) {
        const maybeDefaultIdentifier = this.parseMaybeImportPhase(node, true);
        const hasDefault = this.maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier);
        const parseAfterDefault = !hasDefault || this.eat(12);
        const hasStar = parseAfterDefault && this.eatExportStar(node);
        const hasNamespace = hasStar && this.maybeParseExportNamespaceSpecifier(node);
        const parseAfterNamespace = parseAfterDefault && (!hasNamespace || this.eat(12));
        const isFromRequired = hasDefault || hasStar;
        if (hasStar && !hasNamespace) {
          if (hasDefault) this.unexpected();
          if (decorators) {
            throw this.raise(Errors.UnsupportedDecoratorExport, node);
          }
          this.parseExportFrom(node, true);
          this.sawUnambiguousESM = true;
          return this.finishNode(node, "ExportAllDeclaration");
        }
        const hasSpecifiers = this.maybeParseExportNamedSpecifiers(node);
        if (hasDefault && parseAfterDefault && !hasStar && !hasSpecifiers) {
          this.unexpected(null, 5);
        }
        if (hasNamespace && parseAfterNamespace) {
          this.unexpected(null, 98);
        }
        let hasDeclaration;
        if (isFromRequired || hasSpecifiers) {
          hasDeclaration = false;
          if (decorators) {
            throw this.raise(Errors.UnsupportedDecoratorExport, node);
          }
          this.parseExportFrom(node, isFromRequired);
        } else {
          hasDeclaration = this.maybeParseExportDeclaration(node);
        }
        if (isFromRequired || hasSpecifiers || hasDeclaration) {
          var _node2$declaration;
          const node2 = node;
          this.checkExport(node2, true, false, !!node2.source);
          if (((_node2$declaration = node2.declaration) == null ? void 0 : _node2$declaration.type) === "ClassDeclaration") {
            this.maybeTakeDecorators(decorators, node2.declaration, node2);
          } else if (decorators) {
            throw this.raise(Errors.UnsupportedDecoratorExport, node);
          }
          this.sawUnambiguousESM = true;
          return this.finishNode(node2, "ExportNamedDeclaration");
        }
        if (this.eat(65)) {
          const node2 = node;
          const decl = this.parseExportDefaultExpression();
          node2.declaration = decl;
          if (decl.type === "ClassDeclaration") {
            this.maybeTakeDecorators(decorators, decl, node2);
          } else if (decorators) {
            throw this.raise(Errors.UnsupportedDecoratorExport, node);
          }
          this.checkExport(node2, true, true);
          this.sawUnambiguousESM = true;
          return this.finishNode(node2, "ExportDefaultDeclaration");
        }
        this.unexpected(null, 5);
      }
      eatExportStar(node) {
        return this.eat(55);
      }
      maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
        if (maybeDefaultIdentifier || this.isExportDefaultSpecifier()) {
          this.expectPlugin("exportDefaultFrom", maybeDefaultIdentifier == null ? void 0 : maybeDefaultIdentifier.loc.start);
          const id = maybeDefaultIdentifier || this.parseIdentifier(true);
          const specifier = this.startNodeAtNode(id);
          specifier.exported = id;
          node.specifiers = [this.finishNode(specifier, "ExportDefaultSpecifier")];
          return true;
        }
        return false;
      }
      maybeParseExportNamespaceSpecifier(node) {
        if (this.isContextual(93)) {
          var _ref, _ref$specifiers;
          (_ref$specifiers = (_ref = node).specifiers) != null ? _ref$specifiers : _ref.specifiers = [];
          const specifier = this.startNodeAt(this.state.lastTokStartLoc);
          this.next();
          specifier.exported = this.parseModuleExportName();
          node.specifiers.push(this.finishNode(specifier, "ExportNamespaceSpecifier"));
          return true;
        }
        return false;
      }
      maybeParseExportNamedSpecifiers(node) {
        if (this.match(5)) {
          const node2 = node;
          if (!node2.specifiers) node2.specifiers = [];
          const isTypeExport = node2.exportKind === "type";
          node2.specifiers.push(...this.parseExportSpecifiers(isTypeExport));
          node2.source = null;
          if (this.hasPlugin("importAssertions")) {
            node2.assertions = [];
          } else {
            node2.attributes = [];
          }
          node2.declaration = null;
          return true;
        }
        return false;
      }
      maybeParseExportDeclaration(node) {
        if (this.shouldParseExportDeclaration()) {
          node.specifiers = [];
          node.source = null;
          if (this.hasPlugin("importAssertions")) {
            node.assertions = [];
          } else {
            node.attributes = [];
          }
          node.declaration = this.parseExportDeclaration(node);
          return true;
        }
        return false;
      }
      isAsyncFunction() {
        if (!this.isContextual(95)) return false;
        const next = this.nextTokenInLineStart();
        return this.isUnparsedContextual(next, "function");
      }
      parseExportDefaultExpression() {
        const expr = this.startNode();
        if (this.match(68)) {
          this.next();
          return this.parseFunction(expr, 1 | 4);
        } else if (this.isAsyncFunction()) {
          this.next();
          this.next();
          return this.parseFunction(expr, 1 | 4 | 8);
        }
        if (this.match(80)) {
          return this.parseClass(expr, true, true);
        }
        if (this.match(26)) {
          if (this.hasPlugin("decorators") && this.getPluginOption("decorators", "decoratorsBeforeExport") === true) {
            this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
          }
          return this.parseClass(this.maybeTakeDecorators(this.parseDecorators(false), this.startNode()), true, true);
        }
        if (this.match(75) || this.match(74) || this.isLet()) {
          throw this.raise(Errors.UnsupportedDefaultExport, this.state.startLoc);
        }
        const res = this.parseMaybeAssignAllowIn();
        this.semicolon();
        return res;
      }
      parseExportDeclaration(node) {
        if (this.match(80)) {
          const node2 = this.parseClass(this.startNode(), true, false);
          return node2;
        }
        return this.parseStatementListItem();
      }
      isExportDefaultSpecifier() {
        const {
          type
        } = this.state;
        if (tokenIsIdentifier(type)) {
          if (type === 95 && !this.state.containsEsc || type === 100) {
            return false;
          }
          if ((type === 130 || type === 129) && !this.state.containsEsc) {
            const {
              type: nextType
            } = this.lookahead();
            if (tokenIsIdentifier(nextType) && nextType !== 98 || nextType === 5) {
              this.expectOnePlugin(["flow", "typescript"]);
              return false;
            }
          }
        } else if (!this.match(65)) {
          return false;
        }
        const next = this.nextTokenStart();
        const hasFrom = this.isUnparsedContextual(next, "from");
        if (this.input.charCodeAt(next) === 44 || tokenIsIdentifier(this.state.type) && hasFrom) {
          return true;
        }
        if (this.match(65) && hasFrom) {
          const nextAfterFrom = this.input.charCodeAt(this.nextTokenStartSince(next + 4));
          return nextAfterFrom === 34 || nextAfterFrom === 39;
        }
        return false;
      }
      parseExportFrom(node, expect) {
        if (this.eatContextual(98)) {
          node.source = this.parseImportSource();
          this.checkExport(node);
          this.maybeParseImportAttributes(node);
          this.checkJSONModuleImport(node);
        } else if (expect) {
          this.unexpected();
        }
        this.semicolon();
      }
      shouldParseExportDeclaration() {
        const {
          type
        } = this.state;
        if (type === 26) {
          this.expectOnePlugin(["decorators", "decorators-legacy"]);
          if (this.hasPlugin("decorators")) {
            if (this.getPluginOption("decorators", "decoratorsBeforeExport") === true) {
              this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
            }
            return true;
          }
        }
        if (this.isContextual(107)) {
          this.raise(Errors.UsingDeclarationExport, this.state.startLoc);
          return true;
        }
        if (this.isContextual(96) && this.startsAwaitUsing()) {
          this.raise(Errors.UsingDeclarationExport, this.state.startLoc);
          return true;
        }
        return type === 74 || type === 75 || type === 68 || type === 80 || this.isLet() || this.isAsyncFunction();
      }
      checkExport(node, checkNames, isDefault, isFrom) {
        if (checkNames) {
          var _node$specifiers;
          if (isDefault) {
            this.checkDuplicateExports(node, "default");
            if (this.hasPlugin("exportDefaultFrom")) {
              var _declaration$extra;
              const declaration = node.declaration;
              if (declaration.type === "Identifier" && declaration.name === "from" && declaration.end - declaration.start === 4 && !((_declaration$extra = declaration.extra) != null && _declaration$extra.parenthesized)) {
                this.raise(Errors.ExportDefaultFromAsIdentifier, declaration);
              }
            }
          } else if ((_node$specifiers = node.specifiers) != null && _node$specifiers.length) {
            for (const specifier of node.specifiers) {
              const {
                exported
              } = specifier;
              const exportName = exported.type === "Identifier" ? exported.name : exported.value;
              this.checkDuplicateExports(specifier, exportName);
              if (!isFrom && specifier.local) {
                const {
                  local
                } = specifier;
                if (local.type !== "Identifier") {
                  this.raise(Errors.ExportBindingIsString, specifier, {
                    localName: local.value,
                    exportName
                  });
                } else {
                  this.checkReservedWord(local.name, local.loc.start, true, false);
                  this.scope.checkLocalExport(local);
                }
              }
            }
          } else if (node.declaration) {
            const decl = node.declaration;
            if (decl.type === "FunctionDeclaration" || decl.type === "ClassDeclaration") {
              const {
                id
              } = decl;
              if (!id) throw new Error("Assertion failure");
              this.checkDuplicateExports(node, id.name);
            } else if (decl.type === "VariableDeclaration") {
              for (const declaration of decl.declarations) {
                this.checkDeclaration(declaration.id);
              }
            }
          }
        }
      }
      checkDeclaration(node) {
        if (node.type === "Identifier") {
          this.checkDuplicateExports(node, node.name);
        } else if (node.type === "ObjectPattern") {
          for (const prop of node.properties) {
            this.checkDeclaration(prop);
          }
        } else if (node.type === "ArrayPattern") {
          for (const elem of node.elements) {
            if (elem) {
              this.checkDeclaration(elem);
            }
          }
        } else if (node.type === "ObjectProperty") {
          this.checkDeclaration(node.value);
        } else if (node.type === "RestElement") {
          this.checkDeclaration(node.argument);
        } else if (node.type === "AssignmentPattern") {
          this.checkDeclaration(node.left);
        }
      }
      checkDuplicateExports(node, exportName) {
        if (this.exportedIdentifiers.has(exportName)) {
          if (exportName === "default") {
            this.raise(Errors.DuplicateDefaultExport, node);
          } else {
            this.raise(Errors.DuplicateExport, node, {
              exportName
            });
          }
        }
        this.exportedIdentifiers.add(exportName);
      }
      parseExportSpecifiers(isInTypeExport) {
        const nodes = [];
        let first = true;
        this.expect(5);
        while (!this.eat(8)) {
          if (first) {
            first = false;
          } else {
            this.expect(12);
            if (this.eat(8)) break;
          }
          const isMaybeTypeOnly = this.isContextual(130);
          const isString = this.match(134);
          const node = this.startNode();
          node.local = this.parseModuleExportName();
          nodes.push(this.parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly));
        }
        return nodes;
      }
      parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly) {
        if (this.eatContextual(93)) {
          node.exported = this.parseModuleExportName();
        } else if (isString) {
          node.exported = cloneStringLiteral(node.local);
        } else if (!node.exported) {
          node.exported = cloneIdentifier(node.local);
        }
        return this.finishNode(node, "ExportSpecifier");
      }
      parseModuleExportName() {
        if (this.match(134)) {
          const result = this.parseStringLiteral(this.state.value);
          const surrogate = loneSurrogate.exec(result.value);
          if (surrogate) {
            this.raise(Errors.ModuleExportNameHasLoneSurrogate, result, {
              surrogateCharCode: surrogate[0].charCodeAt(0)
            });
          }
          return result;
        }
        return this.parseIdentifier(true);
      }
      isJSONModuleImport(node) {
        if (node.assertions != null) {
          return node.assertions.some(({
            key: key2,
            value
          }) => {
            return value.value === "json" && (key2.type === "Identifier" ? key2.name === "type" : key2.value === "type");
          });
        }
        return false;
      }
      checkImportReflection(node) {
        const {
          specifiers
        } = node;
        const singleBindingType = specifiers.length === 1 ? specifiers[0].type : null;
        if (node.phase === "source") {
          if (singleBindingType !== "ImportDefaultSpecifier") {
            this.raise(Errors.SourcePhaseImportRequiresDefault, specifiers[0].loc.start);
          }
        } else if (node.phase === "defer") {
          if (singleBindingType !== "ImportNamespaceSpecifier") {
            this.raise(Errors.DeferImportRequiresNamespace, specifiers[0].loc.start);
          }
        } else if (node.module) {
          var _node$assertions;
          if (singleBindingType !== "ImportDefaultSpecifier") {
            this.raise(Errors.ImportReflectionNotBinding, specifiers[0].loc.start);
          }
          if (((_node$assertions = node.assertions) == null ? void 0 : _node$assertions.length) > 0) {
            this.raise(Errors.ImportReflectionHasAssertion, specifiers[0].loc.start);
          }
        }
      }
      checkJSONModuleImport(node) {
        if (this.isJSONModuleImport(node) && node.type !== "ExportAllDeclaration") {
          const {
            specifiers
          } = node;
          if (specifiers != null) {
            const nonDefaultNamedSpecifier = specifiers.find((specifier) => {
              let imported;
              if (specifier.type === "ExportSpecifier") {
                imported = specifier.local;
              } else if (specifier.type === "ImportSpecifier") {
                imported = specifier.imported;
              }
              if (imported !== void 0) {
                return imported.type === "Identifier" ? imported.name !== "default" : imported.value !== "default";
              }
            });
            if (nonDefaultNamedSpecifier !== void 0) {
              this.raise(Errors.ImportJSONBindingNotDefault, nonDefaultNamedSpecifier.loc.start);
            }
          }
        }
      }
      isPotentialImportPhase(isExport) {
        if (isExport) return false;
        return this.isContextual(105) || this.isContextual(97) || this.isContextual(127);
      }
      applyImportPhase(node, isExport, phase, loc) {
        if (isExport) {
          return;
        }
        if (phase === "module") {
          this.expectPlugin("importReflection", loc);
          node.module = true;
        } else if (this.hasPlugin("importReflection")) {
          node.module = false;
        }
        if (phase === "source") {
          this.expectPlugin("sourcePhaseImports", loc);
          node.phase = "source";
        } else if (phase === "defer") {
          this.expectPlugin("deferredImportEvaluation", loc);
          node.phase = "defer";
        } else if (this.hasPlugin("sourcePhaseImports")) {
          node.phase = null;
        }
      }
      parseMaybeImportPhase(node, isExport) {
        if (!this.isPotentialImportPhase(isExport)) {
          this.applyImportPhase(node, isExport, null);
          return null;
        }
        const phaseIdentifier = this.parseIdentifier(true);
        const {
          type
        } = this.state;
        const isImportPhase = tokenIsKeywordOrIdentifier(type) ? type !== 98 || this.lookaheadCharCode() === 102 : type !== 12;
        if (isImportPhase) {
          this.resetPreviousIdentifierLeadingComments(phaseIdentifier);
          this.applyImportPhase(node, isExport, phaseIdentifier.name, phaseIdentifier.loc.start);
          return null;
        } else {
          this.applyImportPhase(node, isExport, null);
          return phaseIdentifier;
        }
      }
      isPrecedingIdImportPhase(phase) {
        const {
          type
        } = this.state;
        return tokenIsIdentifier(type) ? type !== 98 || this.lookaheadCharCode() === 102 : type !== 12;
      }
      parseImport(node) {
        if (this.match(134)) {
          return this.parseImportSourceAndAttributes(node);
        }
        return this.parseImportSpecifiersAndAfter(node, this.parseMaybeImportPhase(node, false));
      }
      parseImportSpecifiersAndAfter(node, maybeDefaultIdentifier) {
        node.specifiers = [];
        const hasDefault = this.maybeParseDefaultImportSpecifier(node, maybeDefaultIdentifier);
        const parseNext = !hasDefault || this.eat(12);
        const hasStar = parseNext && this.maybeParseStarImportSpecifier(node);
        if (parseNext && !hasStar) this.parseNamedImportSpecifiers(node);
        this.expectContextual(98);
        return this.parseImportSourceAndAttributes(node);
      }
      parseImportSourceAndAttributes(node) {
        var _node$specifiers2;
        (_node$specifiers2 = node.specifiers) != null ? _node$specifiers2 : node.specifiers = [];
        node.source = this.parseImportSource();
        this.maybeParseImportAttributes(node);
        this.checkImportReflection(node);
        this.checkJSONModuleImport(node);
        this.semicolon();
        this.sawUnambiguousESM = true;
        return this.finishNode(node, "ImportDeclaration");
      }
      parseImportSource() {
        if (!this.match(134)) this.unexpected();
        return this.parseExprAtom();
      }
      parseImportSpecifierLocal(node, specifier, type) {
        specifier.local = this.parseIdentifier();
        node.specifiers.push(this.finishImportSpecifier(specifier, type));
      }
      finishImportSpecifier(specifier, type, bindingType = 8201) {
        this.checkLVal(specifier.local, {
          type
        }, bindingType);
        return this.finishNode(specifier, type);
      }
      parseImportAttributes() {
        this.expect(5);
        const attrs = [];
        const attrNames = /* @__PURE__ */ new Set();
        do {
          if (this.match(8)) {
            break;
          }
          const node = this.startNode();
          const keyName = this.state.value;
          if (attrNames.has(keyName)) {
            this.raise(Errors.ModuleAttributesWithDuplicateKeys, this.state.startLoc, {
              key: keyName
            });
          }
          attrNames.add(keyName);
          if (this.match(134)) {
            node.key = this.parseStringLiteral(keyName);
          } else {
            node.key = this.parseIdentifier(true);
          }
          this.expect(14);
          if (!this.match(134)) {
            throw this.raise(Errors.ModuleAttributeInvalidValue, this.state.startLoc);
          }
          node.value = this.parseStringLiteral(this.state.value);
          attrs.push(this.finishNode(node, "ImportAttribute"));
        } while (this.eat(12));
        this.expect(8);
        return attrs;
      }
      parseModuleAttributes() {
        const attrs = [];
        const attributes = /* @__PURE__ */ new Set();
        do {
          const node = this.startNode();
          node.key = this.parseIdentifier(true);
          if (node.key.name !== "type") {
            this.raise(Errors.ModuleAttributeDifferentFromType, node.key);
          }
          if (attributes.has(node.key.name)) {
            this.raise(Errors.ModuleAttributesWithDuplicateKeys, node.key, {
              key: node.key.name
            });
          }
          attributes.add(node.key.name);
          this.expect(14);
          if (!this.match(134)) {
            throw this.raise(Errors.ModuleAttributeInvalidValue, this.state.startLoc);
          }
          node.value = this.parseStringLiteral(this.state.value);
          attrs.push(this.finishNode(node, "ImportAttribute"));
        } while (this.eat(12));
        return attrs;
      }
      maybeParseImportAttributes(node) {
        let attributes;
        {
          var useWith = false;
        }
        if (this.match(76)) {
          if (this.hasPrecedingLineBreak() && this.lookaheadCharCode() === 40) {
            return;
          }
          this.next();
          if (this.hasPlugin("moduleAttributes")) {
            attributes = this.parseModuleAttributes();
            this.addExtra(node, "deprecatedWithLegacySyntax", true);
          } else {
            attributes = this.parseImportAttributes();
          }
          {
            useWith = true;
          }
        } else if (this.isContextual(94) && !this.hasPrecedingLineBreak()) {
          if (!this.hasPlugin("deprecatedImportAssert") && !this.hasPlugin("importAssertions")) {
            this.raise(Errors.ImportAttributesUseAssert, this.state.startLoc);
          }
          if (!this.hasPlugin("importAssertions")) {
            this.addExtra(node, "deprecatedAssertSyntax", true);
          }
          this.next();
          attributes = this.parseImportAttributes();
        } else {
          attributes = [];
        }
        if (!useWith && this.hasPlugin("importAssertions")) {
          node.assertions = attributes;
        } else {
          node.attributes = attributes;
        }
      }
      maybeParseDefaultImportSpecifier(node, maybeDefaultIdentifier) {
        if (maybeDefaultIdentifier) {
          const specifier = this.startNodeAtNode(maybeDefaultIdentifier);
          specifier.local = maybeDefaultIdentifier;
          node.specifiers.push(this.finishImportSpecifier(specifier, "ImportDefaultSpecifier"));
          return true;
        } else if (tokenIsKeywordOrIdentifier(this.state.type)) {
          this.parseImportSpecifierLocal(node, this.startNode(), "ImportDefaultSpecifier");
          return true;
        }
        return false;
      }
      maybeParseStarImportSpecifier(node) {
        if (this.match(55)) {
          const specifier = this.startNode();
          this.next();
          this.expectContextual(93);
          this.parseImportSpecifierLocal(node, specifier, "ImportNamespaceSpecifier");
          return true;
        }
        return false;
      }
      parseNamedImportSpecifiers(node) {
        let first = true;
        this.expect(5);
        while (!this.eat(8)) {
          if (first) {
            first = false;
          } else {
            if (this.eat(14)) {
              throw this.raise(Errors.DestructureNamedImport, this.state.startLoc);
            }
            this.expect(12);
            if (this.eat(8)) break;
          }
          const specifier = this.startNode();
          const importedIsString = this.match(134);
          const isMaybeTypeOnly = this.isContextual(130);
          specifier.imported = this.parseModuleExportName();
          const importSpecifier2 = this.parseImportSpecifier(specifier, importedIsString, node.importKind === "type" || node.importKind === "typeof", isMaybeTypeOnly, void 0);
          node.specifiers.push(importSpecifier2);
        }
      }
      parseImportSpecifier(specifier, importedIsString, isInTypeOnlyImport, isMaybeTypeOnly, bindingType) {
        if (this.eatContextual(93)) {
          specifier.local = this.parseIdentifier();
        } else {
          const {
            imported
          } = specifier;
          if (importedIsString) {
            throw this.raise(Errors.ImportBindingIsString, specifier, {
              importName: imported.value
            });
          }
          this.checkReservedWord(imported.name, specifier.loc.start, true, true);
          if (!specifier.local) {
            specifier.local = cloneIdentifier(imported);
          }
        }
        return this.finishImportSpecifier(specifier, "ImportSpecifier", bindingType);
      }
      isThisParam(param) {
        return param.type === "Identifier" && param.name === "this";
      }
    };
    var Parser = class extends StatementParser {
      constructor(options, input, pluginsMap) {
        options = getOptions(options);
        super(options, input);
        this.options = options;
        this.initializeScopes();
        this.plugins = pluginsMap;
        this.filename = options.sourceFilename;
        this.startIndex = options.startIndex;
        let optionFlags = 0;
        if (options.allowAwaitOutsideFunction) {
          optionFlags |= 1;
        }
        if (options.allowReturnOutsideFunction) {
          optionFlags |= 2;
        }
        if (options.allowImportExportEverywhere) {
          optionFlags |= 8;
        }
        if (options.allowSuperOutsideMethod) {
          optionFlags |= 16;
        }
        if (options.allowUndeclaredExports) {
          optionFlags |= 64;
        }
        if (options.allowNewTargetOutsideFunction) {
          optionFlags |= 4;
        }
        if (options.allowYieldOutsideFunction) {
          optionFlags |= 32;
        }
        if (options.ranges) {
          optionFlags |= 128;
        }
        if (options.tokens) {
          optionFlags |= 256;
        }
        if (options.createImportExpressions) {
          optionFlags |= 512;
        }
        if (options.createParenthesizedExpressions) {
          optionFlags |= 1024;
        }
        if (options.errorRecovery) {
          optionFlags |= 2048;
        }
        if (options.attachComment) {
          optionFlags |= 4096;
        }
        if (options.annexB) {
          optionFlags |= 8192;
        }
        this.optionFlags = optionFlags;
      }
      getScopeHandler() {
        return ScopeHandler;
      }
      parse() {
        this.enterInitialScopes();
        const file2 = this.startNode();
        const program = this.startNode();
        this.nextToken();
        file2.errors = null;
        this.parseTopLevel(file2, program);
        file2.errors = this.state.errors;
        file2.comments.length = this.state.commentsLen;
        return file2;
      }
    };
    function parse6(input, options) {
      var _options;
      if (((_options = options) == null ? void 0 : _options.sourceType) === "unambiguous") {
        options = Object.assign({}, options);
        try {
          options.sourceType = "module";
          const parser = getParser(options, input);
          const ast = parser.parse();
          if (parser.sawUnambiguousESM) {
            return ast;
          }
          if (parser.ambiguousScriptDifferentAst) {
            try {
              options.sourceType = "script";
              return getParser(options, input).parse();
            } catch (_unused) {
            }
          } else {
            ast.program.sourceType = "script";
          }
          return ast;
        } catch (moduleError) {
          try {
            options.sourceType = "script";
            return getParser(options, input).parse();
          } catch (_unused2) {
          }
          throw moduleError;
        }
      } else {
        return getParser(options, input).parse();
      }
    }
    function parseExpression(input, options) {
      const parser = getParser(options, input);
      if (parser.options.strictMode) {
        parser.state.strict = true;
      }
      return parser.getExpression();
    }
    function generateExportedTokenTypes(internalTokenTypes) {
      const tokenTypes2 = {};
      for (const typeName of Object.keys(internalTokenTypes)) {
        tokenTypes2[typeName] = getExportedToken(internalTokenTypes[typeName]);
      }
      return tokenTypes2;
    }
    var tokTypes = generateExportedTokenTypes(tt);
    function getParser(options, input) {
      let cls = Parser;
      const pluginsMap = /* @__PURE__ */ new Map();
      if (options != null && options.plugins) {
        for (const plugin of options.plugins) {
          let name, opts;
          if (typeof plugin === "string") {
            name = plugin;
          } else {
            [name, opts] = plugin;
          }
          if (!pluginsMap.has(name)) {
            pluginsMap.set(name, opts || {});
          }
        }
        validatePlugins(pluginsMap);
        cls = getParserClass(pluginsMap);
      }
      return new cls(options, input, pluginsMap);
    }
    var parserClassCache = /* @__PURE__ */ new Map();
    function getParserClass(pluginsMap) {
      const pluginList = [];
      for (const name of mixinPluginNames) {
        if (pluginsMap.has(name)) {
          pluginList.push(name);
        }
      }
      const key2 = pluginList.join("|");
      let cls = parserClassCache.get(key2);
      if (!cls) {
        cls = Parser;
        for (const plugin of pluginList) {
          cls = mixinPlugins[plugin](cls);
        }
        parserClassCache.set(key2, cls);
      }
      return cls;
    }
    exports2.parse = parse6;
    exports2.parseExpression = parseExpression;
    exports2.tokTypes = tokTypes;
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/replacement.js
var require_replacement = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/replacement.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2._replaceWith = _replaceWith;
    exports2.replaceExpressionWithStatements = replaceExpressionWithStatements;
    exports2.replaceInline = replaceInline;
    exports2.replaceWith = replaceWith;
    exports2.replaceWithMultiple = replaceWithMultiple;
    exports2.replaceWithSourceString = replaceWithSourceString;
    var _codeFrame = require_lib3();
    var _index = require_lib6();
    var _index2 = require_path();
    var _cache = require_cache();
    var _modification = require_modification();
    var _parser = require_lib4();
    var _t = require("@babel/types");
    var _context3 = require_context2();
    var {
      FUNCTION_TYPES,
      arrowFunctionExpression: arrowFunctionExpression2,
      assignmentExpression: assignmentExpression2,
      awaitExpression: awaitExpression2,
      blockStatement: blockStatement3,
      buildUndefinedNode,
      callExpression: callExpression4,
      cloneNode: cloneNode2,
      conditionalExpression: conditionalExpression3,
      expressionStatement: expressionStatement2,
      getBindingIdentifiers,
      identifier: identifier4,
      inheritLeadingComments,
      inheritTrailingComments,
      inheritsComments,
      isBlockStatement,
      isEmptyStatement,
      isExpression: isExpression2,
      isExpressionStatement,
      isIfStatement,
      isProgram,
      isStatement: isStatement2,
      isVariableDeclaration: isVariableDeclaration2,
      removeComments,
      returnStatement: returnStatement3,
      sequenceExpression: sequenceExpression2,
      validate: validate2,
      yieldExpression
    } = _t;
    function replaceWithMultiple(nodes) {
      var _getCachedPaths;
      _context3.resync.call(this);
      nodes = _modification._verifyNodeList.call(this, nodes);
      inheritLeadingComments(nodes[0], this.node);
      inheritTrailingComments(nodes[nodes.length - 1], this.node);
      (_getCachedPaths = (0, _cache.getCachedPaths)(this.hub, this.parent)) == null || _getCachedPaths.delete(this.node);
      this.node = this.container[this.key] = null;
      const paths = this.insertAfter(nodes);
      if (this.node) {
        this.requeue();
      } else {
        this.remove();
      }
      return paths;
    }
    function replaceWithSourceString(replacement) {
      _context3.resync.call(this);
      let ast;
      try {
        replacement = `(${replacement})`;
        ast = (0, _parser.parse)(replacement);
      } catch (err) {
        const loc = err.loc;
        if (loc) {
          err.message += " - make sure this is an expression.\n" + (0, _codeFrame.codeFrameColumns)(replacement, {
            start: {
              line: loc.line,
              column: loc.column + 1
            }
          });
          err.code = "BABEL_REPLACE_SOURCE_ERROR";
        }
        throw err;
      }
      const expressionAST = ast.program.body[0].expression;
      _index.default.removeProperties(expressionAST);
      return this.replaceWith(expressionAST);
    }
    function replaceWith(replacementPath) {
      _context3.resync.call(this);
      if (this.removed) {
        throw new Error("You can't replace this node, we've already removed it");
      }
      let replacement = replacementPath instanceof _index2.default ? replacementPath.node : replacementPath;
      if (!replacement) {
        throw new Error("You passed `path.replaceWith()` a falsy node, use `path.remove()` instead");
      }
      if (this.node === replacement) {
        return [this];
      }
      if (this.isProgram() && !isProgram(replacement)) {
        throw new Error("You can only replace a Program root node with another Program node");
      }
      if (Array.isArray(replacement)) {
        throw new Error("Don't use `path.replaceWith()` with an array of nodes, use `path.replaceWithMultiple()`");
      }
      if (typeof replacement === "string") {
        throw new Error("Don't use `path.replaceWith()` with a source string, use `path.replaceWithSourceString()`");
      }
      let nodePath = "";
      if (this.isNodeType("Statement") && isExpression2(replacement)) {
        if (!this.canHaveVariableDeclarationOrExpression() && !this.canSwapBetweenExpressionAndStatement(replacement) && !this.parentPath.isExportDefaultDeclaration()) {
          replacement = expressionStatement2(replacement);
          nodePath = "expression";
        }
      }
      if (this.isNodeType("Expression") && isStatement2(replacement)) {
        if (!this.canHaveVariableDeclarationOrExpression() && !this.canSwapBetweenExpressionAndStatement(replacement)) {
          return this.replaceExpressionWithStatements([replacement]);
        }
      }
      const oldNode = this.node;
      if (oldNode) {
        inheritsComments(replacement, oldNode);
        removeComments(oldNode);
      }
      _replaceWith.call(this, replacement);
      this.type = replacement.type;
      _context3.setScope.call(this);
      this.requeue();
      return [nodePath ? this.get(nodePath) : this];
    }
    function _replaceWith(node) {
      var _getCachedPaths2;
      if (!this.container) {
        throw new ReferenceError("Container is falsy");
      }
      if (this.inList) {
        validate2(this.parent, this.key, [node]);
      } else {
        validate2(this.parent, this.key, node);
      }
      this.debug(`Replace with ${node == null ? void 0 : node.type}`);
      (_getCachedPaths2 = (0, _cache.getCachedPaths)(this.hub, this.parent)) == null || _getCachedPaths2.set(node, this).delete(this.node);
      this.node = this.container[this.key] = node;
    }
    function replaceExpressionWithStatements(nodes) {
      _context3.resync.call(this);
      const declars = [];
      const nodesAsSingleExpression = gatherSequenceExpressions(nodes, declars);
      if (nodesAsSingleExpression) {
        for (const id of declars) this.scope.push({
          id
        });
        return this.replaceWith(nodesAsSingleExpression)[0].get("expressions");
      }
      const functionParent = this.getFunctionParent();
      const isParentAsync = functionParent == null ? void 0 : functionParent.node.async;
      const isParentGenerator = functionParent == null ? void 0 : functionParent.node.generator;
      const container = arrowFunctionExpression2([], blockStatement3(nodes));
      this.replaceWith(callExpression4(container, []));
      const callee = this.get("callee");
      callee.get("body").scope.hoistVariables((id) => this.scope.push({
        id
      }));
      const completionRecords = callee.getCompletionRecords();
      for (const path of completionRecords) {
        if (!path.isExpressionStatement()) continue;
        const loop = path.findParent((path2) => path2.isLoop());
        if (loop) {
          let uid = loop.getData("expressionReplacementReturnUid");
          if (!uid) {
            uid = callee.scope.generateDeclaredUidIdentifier("ret");
            callee.get("body").pushContainer("body", returnStatement3(cloneNode2(uid)));
            loop.setData("expressionReplacementReturnUid", uid);
          } else {
            uid = identifier4(uid.name);
          }
          path.get("expression").replaceWith(assignmentExpression2("=", cloneNode2(uid), path.node.expression));
        } else {
          path.replaceWith(returnStatement3(path.node.expression));
        }
      }
      callee.arrowFunctionToExpression();
      const newCallee = callee;
      const needToAwaitFunction = isParentAsync && _index.default.hasType(this.get("callee.body").node, "AwaitExpression", FUNCTION_TYPES);
      const needToYieldFunction = isParentGenerator && _index.default.hasType(this.get("callee.body").node, "YieldExpression", FUNCTION_TYPES);
      if (needToAwaitFunction) {
        newCallee.set("async", true);
        if (!needToYieldFunction) {
          this.replaceWith(awaitExpression2(this.node));
        }
      }
      if (needToYieldFunction) {
        newCallee.set("generator", true);
        this.replaceWith(yieldExpression(this.node, true));
      }
      return newCallee.get("body.body");
    }
    function gatherSequenceExpressions(nodes, declars) {
      const exprs = [];
      let ensureLastUndefined = true;
      for (const node of nodes) {
        if (!isEmptyStatement(node)) {
          ensureLastUndefined = false;
        }
        if (isExpression2(node)) {
          exprs.push(node);
        } else if (isExpressionStatement(node)) {
          exprs.push(node.expression);
        } else if (isVariableDeclaration2(node)) {
          if (node.kind !== "var") return;
          for (const declar of node.declarations) {
            const bindings = getBindingIdentifiers(declar);
            for (const key2 of Object.keys(bindings)) {
              declars.push(cloneNode2(bindings[key2]));
            }
            if (declar.init) {
              exprs.push(assignmentExpression2("=", declar.id, declar.init));
            }
          }
          ensureLastUndefined = true;
        } else if (isIfStatement(node)) {
          const consequent = node.consequent ? gatherSequenceExpressions([node.consequent], declars) : buildUndefinedNode();
          const alternate = node.alternate ? gatherSequenceExpressions([node.alternate], declars) : buildUndefinedNode();
          if (!consequent || !alternate) return;
          exprs.push(conditionalExpression3(node.test, consequent, alternate));
        } else if (isBlockStatement(node)) {
          const body = gatherSequenceExpressions(node.body, declars);
          if (!body) return;
          exprs.push(body);
        } else if (isEmptyStatement(node)) {
          if (nodes.indexOf(node) === 0) {
            ensureLastUndefined = true;
          }
        } else {
          return;
        }
      }
      if (ensureLastUndefined) exprs.push(buildUndefinedNode());
      if (exprs.length === 1) {
        return exprs[0];
      } else {
        return sequenceExpression2(exprs);
      }
    }
    function replaceInline(nodes) {
      _context3.resync.call(this);
      if (Array.isArray(nodes)) {
        if (Array.isArray(this.container)) {
          nodes = _modification._verifyNodeList.call(this, nodes);
          const paths = _modification._containerInsertAfter.call(this, nodes);
          this.remove();
          return paths;
        } else {
          return this.replaceWithMultiple(nodes);
        }
      } else {
        return this.replaceWith(nodes);
      }
    }
  }
});

// node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/evaluation.js
var require_evaluation = __commonJS({
  "node_modules/@babel/helpers/node_modules/@babel/traverse/lib/path/evaluation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.evaluate = evaluate;
    exports2.evaluateTruthy = evaluateTruthy;
    var VALID_OBJECT_CALLEES = ["Number", "String", "Math"];
    var VALID_IDENTIFIER_CALLEES = ["isFinite", "isNaN", "parseFloat", "parseInt", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", null, null];
    var INVALID_METHODS = ["random"];
    function isValidObjectCallee(val) {
      return VALID_OBJECT_CALLEES.includes(val);
    }
    function isValidIdentifierCallee(val) {
      return VALID_IDENTIFIER_CALLEES.includes(val);
    }
    function isInvalidMethod(val) {
      return INVALID_METHODS.includes(val);
    }
    function evaluateTruthy() {
      const res = this.evaluate();
      if (res.confident) return !!res.value;
    }
    function deopt(path, state) {
      if (!state.confident) return;
      state.deoptPath = path;
      state.confident = false;
    }
    var Globals = /* @__PURE__ */ new Map([["undefined", void 0], ["Infinity", Infinity], ["NaN", NaN]]);
    function evaluateCached(path, state) {
      const {
        node
      } = path;
      const {
        seen
      } = state;
      if (seen.has(node)) {
        const existing = seen.get(node);
        if (existing.resolved) {
          return existing.value;
        } else {
          deopt(path, state);
          return;
        }
      } else {
        const item = {
          resolved: false
        };
        seen.set(node, item);
        const val = _evaluate(path, state);
        if (state.confident) {